/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.work.thirdtime;

import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.modules.health.entity.base.company.CompanyArea;
import cn.smarthse.modules.health.entity.work.thirdtime.TsProject;
import cn.smarthse.modules.health.enums.thirdtime.TsProjectTypeEnum;
import cn.smarthse.modules.health.service.base.company.ICompanyAreaService;
import cn.smarthse.modules.health.service.work.thirdtime.ITsProjectService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Enumeration;
import javax.cn.smarthse.modules.health.exception.HealthException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/work/thirdtime/base"})
public class TsProjectBaseController
extends ControllerSupport {
    @DubboReference
    private ITsProjectService tsProjectService;
    @DubboReference
    private ICompanyAreaService companyAreaService;

    @RequiresPermissions(value={"thirdtime.view"})
    @RequestMapping(value={"staff/{tsProjectId}"})
    public String staff(ModelMap m, @PathVariable(value="tsProjectId") Long tsProjectId, boolean lookup, boolean isThirdPart) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        this.settinTsProject(m, tsProjectId);
        m.put((Object)"lookup", (Object)lookup);
        m.put((Object)"isThirdPart", (Object)isThirdPart);
        if (isThirdPart) {
            return "work/thirdtime/base/base_staff2";
        }
        return "work/thirdtime/base/base_staff";
    }

    @RequiresPermissions(value={"thirdtime.view"})
    @RequestMapping(value={"device/{tsProjectId}"})
    public String device(ModelMap m, @PathVariable(value="tsProjectId") Long tsProjectId, boolean lookup) {
        this.settinTsProject(m, tsProjectId);
        m.put((Object)"lookup", (Object)lookup);
        return "work/thirdtime/base/base_device";
    }

    @RequiresPermissions(value={"thirdtime.view"})
    @RequestMapping(value={"matter/{tsProjectId}"})
    public String matter(ModelMap m, @PathVariable(value="tsProjectId") Long tsProjectId, boolean lookup, boolean isproduct) {
        this.settinTsProject(m, tsProjectId);
        m.put((Object)"lookup", (Object)lookup);
        m.put((Object)"isproduct", (Object)isproduct);
        if (isproduct) {
            return "work/thirdtime/base/base_matter2";
        }
        return "work/thirdtime/base/base_matter";
    }

    @RequiresPermissions(value={"thirdtime.view"})
    @RequestMapping(value={"build/{tsProjectId}"})
    public String build(ModelMap m, @PathVariable(value="tsProjectId") Long tsProjectId, boolean lookup) {
        this.settinTsProject(m, tsProjectId);
        m.put((Object)"lookup", (Object)lookup);
        return "work/thirdtime/base/base_build";
    }

    @RequiresPermissions(value={"thirdtime.view"})
    @RequestMapping(value={"manager/{tsProjectId}"})
    public String manager(ModelMap m, @PathVariable(value="tsProjectId") Long tsProjectId, boolean lookup) {
        this.settinTsProject(m, tsProjectId);
        m.put((Object)"lookup", (Object)lookup);
        return "work/thirdtime/base/base_manager";
    }

    @RequiresPermissions(value={"thirdtime.view"})
    @RequestMapping(value={"gy/{tsProjectId}"})
    public String gy(ModelMap m, @PathVariable(value="tsProjectId") Long tsProjectId, boolean lookup) {
        this.settinTsProject(m, tsProjectId);
        m.put((Object)"lookup", (Object)lookup);
        return "work/thirdtime/base/base_gy";
    }

    @RequiresPermissions(value={"thirdtime.view"})
    @RequestMapping(value={"gotoPage/{page}"})
    public String gotoPage(ModelMap m, @PathVariable(value="page") String page, HttpServletRequest request) {
        Enumeration eparam = request.getParameterNames();
        while (eparam.hasMoreElements()) {
            String param = (String)eparam.nextElement();
            String value = request.getParameter(param);
            m.put((Object)param, (Object)value);
        }
        return "work/thirdtime/base/" + page;
    }

    @RequiresPermissions(value={"thirdtime.view"})
    @ResponseBody
    @RequestMapping(value={"buildLijiulistdata"})
    public JqGridData<CompanyArea> buildLijiulistdata(JqGridParam param) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        PageInfo list = this.companyAreaService.getBuildingPageInfoByCid(cid, param.getPage(), param.getRows(), true);
        JqGridData data = new JqGridData(list, param);
        return data;
    }

    public void settinTsProject(ModelMap m, Long tsProjectId) {
        if (tsProjectId == null) {
            throw new HealthException("\u4e09\u540c\u65f6\u9879\u76eeID\u53c2\u6570\u4e22\u5931\uff0c \u65e0\u6cd5\u8bbf\u95ee\u8be5\u9875\u9762");
        }
        TsProject tsProject = (TsProject)this.tsProjectService.getById(tsProjectId);
        if (tsProject != null) {
            m.put((Object)"tsp", (Object)tsProject);
            m.put((Object)"tsprojecttypeName", (Object)TsProjectTypeEnum.getNameByCode((Byte)tsProject.getProjectType()));
        }
    }
}

