/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.work.statisticalQuery;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.mapper.HseJsonArray;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckAbnormalInfo;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckParam;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckResultCount;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckResultCountInfo;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckResultGroup;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckResultGroupCount;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckResultRate;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckResultTypeGroup;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckTypeInfo;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalQueryCheck;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalQueryCheckInfo;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalYearCountQuery;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCheckCollectDataStat;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCheckHarm;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCheckHarmMapByWorkAndYear;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCheckHarmStatByYear;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCheckPlanQueryParam;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCheckStatHarmByYearAndWork;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCheckWorkPointRate;
import cn.smarthse.modules.health.entity.work.hccheckplan.vo.HarmCheckRateVo;
import cn.smarthse.modules.health.entity.work.hccheckplan.vo.HcCheckConcentrationStat;
import cn.smarthse.modules.health.entity.work.statisticalQuery.DeptOrWork;
import cn.smarthse.modules.health.entity.work.statisticalQuery.StatisticsOption;
import cn.smarthse.modules.health.enums.scene.InspectionTableTypeEnum;
import cn.smarthse.modules.health.enums.statistics.StatisticsOptionEnum;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckCountService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicService;
import cn.smarthse.modules.health.service.work.scene.ISceneInspectionService;
import cn.smarthse.modules.health.vo.summary.InspectionAndReformMonthCountSummaryVo;
import cn.smarthse.modules.health.vo.summary.InspectionTypeCountSummaryVo;
import cn.smarthse.modules.health.vo.summary.ReformLevelCountSummaryVo;
import cn.smarthse.modules.health.vo.summary.ReformMonthSummaryVo;
import cn.smarthse.modules.health.vo.summary.ReformSourceCountSummaryVo;
import cn.smarthse.modules.health.vo.summary.ReformTrendByYearSummaryVo;
import cn.smarthse.modules.health.vo.summary.ReformTypeCountSummaryVo;
import cn.smarthse.services.hfi.api.entity.CheckOverPoint;
import cn.smarthse.services.hfi.api.entity.CheckPlan;
import cn.smarthse.services.hfi.api.model.list.CheckPlanList;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.controller.work.statisticalQuery.CheckStatisticHelper;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/statistical"})
public class StatisticsController
extends ControllerSupport {
    @DubboReference
    IPhcPhysicalCheckCountService phcPhysicalCheckCountService;
    @DubboReference
    ISceneInspectionService sceneInspectionService;
    @DubboReference
    IReformItemBasicService reformItemBasicService;
    @Autowired
    private CheckStatisticHelper checkStatisticHelper;

    @Log(title="\u7edf\u8ba1", type=2)
    @RequiresPermissions(value={"count.query.view"})
    @RequestMapping
    public String page_index(@RequestParam(value="page", required=false, defaultValue="1") int pageIndex, HttpSession session, ModelMap m) {
        this.logger.info("\u3010\u3011-\u7edf\u8ba1\u9996\u9875");
        Long cid = UserUtils.getLoginStaffCompanyId();
        StatisticsOption param = new StatisticsOption();
        param.setTimeType(StatisticsOptionEnum.year.getCode());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
        Date date = new Date();
        String years = sdf.format(date);
        Integer year = Integer.parseInt(years);
        param.setCountYear(year);
        PhcPhysicalYearCountQuery query = new PhcPhysicalYearCountQuery();
        query.setBeginYear(year);
        query.setEndYear(year);
        query.setCid(cid);
        this.getPhcResultSummDatavo(m, query, param);
        return "work/statisticalQuery/statistical/countIndex";
    }

    @Log(title="\u67e5\u8be2\u9875", type=2)
    @RequiresPermissions(value={"count.query.view"})
    @RequestMapping(value={"toQuery"})
    public String query(HttpSession session, ModelMap m) {
        this.logger.info("\u3010\u3011-\u67e5\u8be2\u9996\u9875");
        return "work/statisticalQuery/query/healthQuery";
    }

    @RequiresPermissions(value={"count.query.view"})
    @RequestMapping(value={"toFactorQuery"})
    public String toFactorQuery(HttpSession session, ModelMap m) {
        this.logger.info("\u3010\u3011-\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u67e5\u8be2");
        return "work/statisticalQuery/query/factorsQuery";
    }

    @RequiresPermissions(value={"count.query.view"})
    @RequestMapping(value={"toSceneQuery"})
    public String toSceneQuery(HttpSession session, ModelMap m) {
        this.logger.info("\u3010\u3011-\u9690\u60a3\u6392\u67e5\u4e0e\u6cbb\u7406\u67e5\u8be2\u67e5\u8be2");
        return "work/statisticalQuery/query/sceneQuery";
    }

    @RequiresPermissions(value={"count.query.view"})
    @RequestMapping(value={"toCountPage"})
    public String toCountPage(HttpServletRequest request, ModelMap m, StatisticsOption param) {
        List deptOrWOrks;
        String promis = "work/statisticalQuery/statistical/promis";
        Long cid = UserUtils.getLoginStaffCompanyId();
        String[] workRoleIds = request.getParameterValues("workRoleId");
        String[] depts = request.getParameterValues("deptId");
        ArrayList<Long> deptsOrWorks = new ArrayList<Long>();
        if (param.getCountObject() == StatisticsOptionEnum.countDept.getCode()) {
            if (depts != null && depts.length != 0) {
                for (a = 0; a < depts.length; ++a) {
                    deptsOrWorks.add(Long.parseLong(depts[a]));
                }
            }
        } else if (param.getCountObject() == StatisticsOptionEnum.countWorkRole.getCode() && workRoleIds != null && workRoleIds.length != 0) {
            for (a = 0; a < workRoleIds.length; ++a) {
                deptsOrWorks.add(Long.parseLong(workRoleIds[a]));
            }
        }
        if ((deptOrWOrks = param.getDeptOrWOrks()) != null) {
            ArrayList<DeptOrWork> deptOrWOrk = new ArrayList<DeptOrWork>();
            for (DeptOrWork dept : deptOrWOrks) {
                if (dept.getDeptOrWorkId() == null) continue;
                deptOrWOrk.add(dept);
            }
            param.setDeptOrWOrks(deptOrWOrk);
        }
        m.put((Object)"paramInfo", (Object)param);
        if (param.getCountType() == StatisticsOptionEnum.phcCount.getCode()) {
            PhcPhysicalYearCountQuery query = new PhcPhysicalYearCountQuery();
            query.setCid(cid);
            query.setDeptsOrWorks(deptsOrWorks);
            if (param.getHealthContent() == StatisticsOptionEnum.phcDataSumm.getCode()) {
                return this.getPhcResultSummData(m, param, query);
            }
            if (param.getHealthContent() == StatisticsOptionEnum.PhcAbnormalDataSumm.getCode()) {
                return this.getPhcAbnormalSummData(m, param, query);
            }
            if (param.getHealthContent() == StatisticsOptionEnum.phcTrend.getCode()) {
                return this.getPhcTrendData(m, param, query);
            }
            return promis;
        }
        if (param.getCountType() == StatisticsOptionEnum.occCount.getCode()) {
            if (param.getFactorsContent() == StatisticsOptionEnum.exceSumm.getCode()) {
                return this.getExceSumm(m, param);
            }
            if (param.getFactorsContent() == StatisticsOptionEnum.checkTrend.getCode()) {
                if (workRoleIds != null && workRoleIds.length == 1) {
                    return this.getOverProofSumm(m, param, workRoleIds);
                }
                if (workRoleIds != null && workRoleIds.length > 1) {
                    return this.getOverProofSummMoreWork(m, param, workRoleIds);
                }
                return "work/statisticalQuery/statistical/promis";
            }
            return promis;
        }
        if (param.getCountType() == StatisticsOptionEnum.sceneCount.getCode()) {
            if (param.getSceneContent() == StatisticsOptionEnum.sceneInvestSumm.getCode()) {
                return this.getSceneInvestSumm(m, param);
            }
            if (param.getSceneContent() == StatisticsOptionEnum.sceneGivermSumm.getCode()) {
                return this.getGivermSumm(m, param);
            }
            if (param.getSceneContent() == StatisticsOptionEnum.sceneTrend.getCode()) {
                return this.getSceneTrend(m, param);
            }
            return promis;
        }
        return promis;
    }

    private String getSceneTrend(ModelMap m, StatisticsOption param) {
        if (param.getTimeRange() == null || param.getTimeRange() != null && param.getTimeRange().equals((byte)0)) {
            return "work/statisticalQuery/statistical/promis";
        }
        Long cid = UserUtils.getLoginStaffCompanyId();
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        Integer beginYear = null;
        Integer endYear = null;
        ArrayList<Integer> years = new ArrayList<Integer>();
        if (param.getTimeRange() == StatisticsOptionEnum.fiveYear.getCode()) {
            beginYear = year - 4;
            endYear = year;
            for (i = 0; i <= 4; ++i) {
                years.add(year - i);
            }
        } else if (param.getTimeRange() == StatisticsOptionEnum.threeYear.getCode()) {
            beginYear = year - 2;
            endYear = year;
            for (i = 0; i <= 2; ++i) {
                years.add(year - i);
            }
        }
        String yearStartStr = beginYear.toString();
        String yearEndStr = endYear.toString();
        List reformTrendSumm = this.reformItemBasicService.getReformTrendSummaryByYear(yearStartStr, yearEndStr, cid);
        ArrayList<ReformTrendByYearSummaryVo> sumData = new ArrayList<ReformTrendByYearSummaryVo>();
        for (Integer ye : years) {
            Boolean haveThisYearDate = false;
            for (ReformTrendByYearSummaryVo reform : reformTrendSumm) {
                Integer a = new Integer(reform.getYear());
                if (!ye.equals(a)) continue;
                haveThisYearDate = true;
                sumData.add(reform);
                break;
            }
            if (haveThisYearDate.booleanValue()) continue;
            ReformTrendByYearSummaryVo vo = new ReformTrendByYearSummaryVo();
            vo.setYear(ye.intValue());
            vo.setAll(0);
            vo.setGeneralScene(0);
            vo.setGeneralTimeLimit(0);
            vo.setMajorStop(0);
            sumData.add(vo);
        }
        m.put((Object)"reformTrendSumm", sumData);
        m.put((Object)"reformTrendSummJson", (Object)HseJsonArray.getInstance().fromObject(sumData));
        return "work/statisticalQuery/statistical/sceneCount3";
    }

    private String getGivermSumm(ModelMap m, StatisticsOption param) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Integer year = param.getCountYear();
        if (year == null) {
            return "work/statisticalQuery/statistical/promis";
        }
        String yearStr = year.toString();
        List depts = param.getDeptOrWOrks();
        Object orgIds = null;
        if (depts != null && depts.size() > 0) {
            for (DeptOrWork dept : depts) {
                if (orgIds == null) {
                    orgIds = dept.getDeptOrWorkId().toString();
                    continue;
                }
                orgIds = (String)orgIds + "," + dept.getDeptOrWorkId();
            }
        }
        ReformMonthSummaryVo reformMonthSumm = this.reformItemBasicService.getReformMonthSummaryByYear(yearStr, cid);
        List reformOrgCountSumm = this.reformItemBasicService.getReformOrgCountSummaryByYear(yearStr, cid, orgIds);
        m.put((Object)"yearStr", (Object)yearStr);
        m.put((Object)"reformMonthSumm", (Object)reformMonthSumm);
        m.put((Object)"reformOrgCountSumm", (Object)HseJsonArray.getInstance().fromObject((Object)reformOrgCountSumm));
        return "work/statisticalQuery/statistical/sceneCount2";
    }

    private String getSceneInvestSumm(ModelMap m, StatisticsOption param) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Integer year = param.getCountYear();
        if (year == null || param.getInspectionType() == null) {
            return "work/statisticalQuery/statistical/promis";
        }
        String yearStr = year.toString();
        String inspectionType = param.getInspectionType();
        ArrayList<InspectionTableTypeEnum> typeList = new ArrayList<InspectionTableTypeEnum>();
        if (inspectionType.contains("1")) {
            typeList.add(InspectionTableTypeEnum.occupationalHelath);
        }
        if (inspectionType.contains("2")) {
            typeList.add(InspectionTableTypeEnum.security);
        }
        if (typeList == null || typeList.size() < 1) {
            return "work/statisticalQuery/statistical/promis";
        }
        InspectionAndReformMonthCountSummaryVo monthSumm = this.sceneInspectionService.getMonthSummaryByYear(yearStr, cid, typeList);
        InspectionTypeCountSummaryVo inspectionTypeSumm = this.sceneInspectionService.getInspectionTypeCountSummaryByYear(yearStr, cid, typeList);
        ReformLevelCountSummaryVo reformLevelSumm = this.reformItemBasicService.getReformLevelCountSummaryByYear(yearStr, cid);
        ReformTypeCountSummaryVo reformTypeSumm = this.reformItemBasicService.getReformTypeCountSummaryByYear(yearStr, cid);
        ReformSourceCountSummaryVo reformSourceSumm = this.reformItemBasicService.getReformSourceCountSummaryByYear(yearStr, cid);
        m.put((Object)"yearStr", (Object)yearStr);
        m.put((Object)"reformLevelSumm", (Object)reformLevelSumm);
        m.put((Object)"inspectionTypeSumm", (Object)inspectionTypeSumm);
        m.put((Object)"monthSumm", (Object)monthSumm);
        m.put((Object)"inspectionMonthSummJson", (Object)monthSumm.getInspection());
        m.put((Object)"reformMonthSummJson", (Object)monthSumm.getReform());
        m.put((Object)"reformTypeSumm", (Object)reformTypeSumm);
        m.put((Object)"reformSourceSumm", (Object)reformSourceSumm);
        return "work/statisticalQuery/statistical/sceneCount1";
    }

    private String getOverProofSummMoreWork(ModelMap m, StatisticsOption param, String[] workRoleIds) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        if (param.getTimeRange() == null || param.getTimeRange() != null && param.getTimeRange().equals((byte)0)) {
            return "work/statisticalQuery/statistical/promis";
        }
        Integer beginYear = null;
        Integer endYear = null;
        ArrayList<Integer> years = new ArrayList<Integer>();
        if (param.getTimeRange() == StatisticsOptionEnum.fiveYear.getCode()) {
            beginYear = year - 4;
            endYear = year;
            for (i = 4; i >= 0; --i) {
                years.add(year - i);
            }
        } else if (param.getTimeRange() == StatisticsOptionEnum.threeYear.getCode()) {
            beginYear = year - 2;
            endYear = year;
            for (i = 2; i >= 0; --i) {
                years.add(year - i);
            }
        }
        List<Long> workIds = Arrays.stream(workRoleIds).map(workId -> Long.parseLong(workId)).collect(Collectors.toList());
        List<HcCheckStatHarmByYearAndWork> countList = this.checkStatisticHelper.getHcCheckStatHarmByYearAndWork(cid, beginYear, endYear, workIds);
        m.put((Object)"countList", (Object)HseJsonArray.getInstance().fromObject(countList));
        m.put((Object)"years", (Object)HseJsonArray.getInstance().fromObject(years));
        m.put((Object)"thisyear", (Object)year);
        return "work/statisticalQuery/statistical/factorsCount3";
    }

    private String getOverProofSumm(ModelMap m, StatisticsOption param, String[] workRoleIds) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        Integer beginYear = null;
        Integer endYear = null;
        if (param.getTimeRange() == null || param.getTimeRange() != null && param.getTimeRange().equals((byte)0)) {
            return "work/statisticalQuery/statistical/promis";
        }
        if (param.getTimeRange() == StatisticsOptionEnum.fiveYear.getCode()) {
            beginYear = year - 4;
            endYear = year;
        } else if (param.getTimeRange() == StatisticsOptionEnum.threeYear.getCode()) {
            beginYear = year - 2;
            endYear = year;
        }
        String workRoleId = workRoleIds[0];
        Long workId = Long.parseLong(workRoleId);
        List<HcCheckHarmStatByYear> countList = this.checkStatisticHelper.getHcCheckHarmStatByYearAndWorkId(cid, workId, beginYear, endYear);
        HcCheckConcentrationStat hcCheckConcentrationStat = this.checkStatisticHelper.getHcCheckConcentrationStat(cid, beginYear, endYear, workId);
        m.put((Object)"hcCheckConcentration", (Object)HseJsonArray.getInstance().fromObject((Object)hcCheckConcentrationStat));
        m.put((Object)"hcCheckConcentrationStat", (Object)hcCheckConcentrationStat);
        this.putLineData(hcCheckConcentrationStat, m);
        m.put((Object)"countList", (Object)HseJsonArray.getInstance().fromObject(countList));
        return "work/statisticalQuery/statistical/factorsCount2";
    }

    private void putLineData(HcCheckConcentrationStat hcCheckConcentrationStat, ModelMap m) {
        List chemicals = hcCheckConcentrationStat.getChemicals();
        m.put((Object)"chemical", (Object)chemicals);
        m.put((Object)"chemicals", (Object)HseJsonArray.getInstance().fromObject((Object)chemicals));
        List biologicals = hcCheckConcentrationStat.getBiologicals();
        m.put((Object)"biologicals", (Object)HseJsonArray.getInstance().fromObject((Object)biologicals));
        List dusts = hcCheckConcentrationStat.getDusts();
        m.put((Object)"dusts", (Object)HseJsonArray.getInstance().fromObject((Object)dusts));
        List noise = hcCheckConcentrationStat.getNoise();
        m.put((Object)"noise", (Object)HseJsonArray.getInstance().fromObject((Object)noise));
        List highFrequency = hcCheckConcentrationStat.getHighFrequency();
        m.put((Object)"highFrequency", (Object)HseJsonArray.getInstance().fromObject((Object)highFrequency));
        List ionizingradiation = hcCheckConcentrationStat.getIonizingradiation();
        m.put((Object)"ionizingradiation", (Object)HseJsonArray.getInstance().fromObject((Object)ionizingradiation));
        List ultrahighfrequencyradiation = hcCheckConcentrationStat.getUltrahighfrequencyradiation();
        m.put((Object)"ultrahighfrequencyradiation", (Object)HseJsonArray.getInstance().fromObject((Object)ultrahighfrequencyradiation));
        List handtransmitted = hcCheckConcentrationStat.getHandtransmitted();
        m.put((Object)"handtransmitted", (Object)HseJsonArray.getInstance().fromObject((Object)handtransmitted));
        List microwaveradiation = hcCheckConcentrationStat.getMicrowaveradiation();
        m.put((Object)"microwaveradiation", (Object)HseJsonArray.getInstance().fromObject((Object)microwaveradiation));
        List ultravioletlight = hcCheckConcentrationStat.getUltravioletlight();
        m.put((Object)"ultravioletlight", (Object)HseJsonArray.getInstance().fromObject((Object)ultravioletlight));
        List powerfrequency = hcCheckConcentrationStat.getPowerfrequency();
        m.put((Object)"powerfrequency", (Object)HseJsonArray.getInstance().fromObject((Object)powerfrequency));
        List hightemperature = hcCheckConcentrationStat.getHightemperature();
        m.put((Object)"hightemperature", (Object)HseJsonArray.getInstance().fromObject((Object)hightemperature));
        List laserradiation = hcCheckConcentrationStat.getLaserradiation();
        m.put((Object)"laserradiation", (Object)HseJsonArray.getInstance().fromObject((Object)laserradiation));
    }

    private String getExceSumm(ModelMap m, StatisticsOption param) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Integer beginYear = null;
        Integer endYear = null;
        if (param.getTimeType().equals(StatisticsOptionEnum.year.getCode())) {
            if (param.getCountYear() == null) {
                return "work/statisticalQuery/statistical/promis";
            }
            beginYear = param.getCountYear();
            endYear = param.getCountYear();
        } else if (param.getTimeType().equals(StatisticsOptionEnum.cycle.getCode())) {
            if (param.getBeginYear() == null || param.getEndYear() == null) {
                return "work/statisticalQuery/statistical/promis";
            }
            endYear = param.getEndYear();
            beginYear = param.getBeginYear();
        }
        if (beginYear == null || endYear == null) {
            return "work/statisticalQuery/statistical/promis";
        }
        List<HcCheckCollectDataStat> hcCheckCollectDataStatList = this.checkStatisticHelper.getHcCheckCollectDataStatFromWorkByYear(cid, beginYear, endYear);
        List<HcCheckCollectDataStat> hcCheckCollectDataStatList1 = this.checkStatisticHelper.getHcCheckCollectDataStatFromHarmByYear(cid, beginYear, endYear);
        List<HcCheckHarmMapByWorkAndYear> relituData = this.checkStatisticHelper.getHcCheckHarmMapByWorkAndYear(cid, beginYear, endYear);
        List<HcCheckHarm> harmList = this.checkStatisticHelper.getAllFactor(relituData);
        this.checkStatisticHelper.fillHarmCheckResult(relituData, harmList);
        m.put((Object)"hcCheckCollectDataStatList", (Object)HseJsonArray.getInstance().fromObject(hcCheckCollectDataStatList));
        m.put((Object)"hcCheckCollectDataStatList1", (Object)HseJsonArray.getInstance().fromObject(hcCheckCollectDataStatList1));
        m.put((Object)"relituData", relituData);
        m.put((Object)"harmList", harmList);
        m.put((Object)"beginYear", (Object)beginYear);
        m.put((Object)"endYear", (Object)endYear);
        return "work/statisticalQuery/statistical/factorsCount1";
    }

    @ResponseBody
    @RequestMapping(value={"getHcCheckWorkPointRateData"})
    public JqGridData<HcCheckWorkPointRate> getHcCheckWorkPointRateData(HttpServletRequest request, JqGridParam param, Integer beginYear, Integer endYear, HttpSession session, ModelMap m) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        PageInfo<HcCheckWorkPointRate> page = this.checkStatisticHelper.harmWorkRate(param, cid, beginYear, endYear);
        JqGridData data = new JqGridData(page, param);
        return data;
    }

    private String getPhcTrendData(ModelMap m, StatisticsOption param, PhcPhysicalYearCountQuery query) {
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        if (param.getTimeRange() == null || param.getTimeRange() != null && param.getTimeRange().equals((byte)0)) {
            return "work/statisticalQuery/statistical/promis";
        }
        ArrayList<Integer> years = new ArrayList<Integer>();
        if (param.getTimeRange() == StatisticsOptionEnum.fiveYear.getCode()) {
            query.setBeginYear(Integer.valueOf(year - 4));
            query.setEndYear(Integer.valueOf(year));
            for (i = 4; i >= 0; --i) {
                years.add(year - i);
            }
        } else if (param.getTimeRange() == StatisticsOptionEnum.threeYear.getCode()) {
            query.setBeginYear(Integer.valueOf(year - 2));
            query.setEndYear(Integer.valueOf(year));
            for (i = 2; i >= 0; --i) {
                years.add(year - i);
            }
        }
        if (param.getCountObject() == StatisticsOptionEnum.countDept.getCode()) {
            query.setDeptOrWork("dept");
        } else if (param.getCountObject() == StatisticsOptionEnum.countWorkRole.getCode()) {
            query.setDeptOrWork("work");
        }
        m.put((Object)"thisyear", (Object)year);
        List deptOrWOrks = param.getDeptOrWOrks();
        List yearCountGropList = this.phcPhysicalCheckCountService.countYearResultInfo(query);
        ArrayList<PhcPhysicalCheckResultRate> yearCountList = new ArrayList<PhcPhysicalCheckResultRate>();
        for (PhcPhysicalCheckResultGroup res : yearCountGropList) {
            PhcPhysicalCheckResultRate rate = new PhcPhysicalCheckResultRate();
            rate.setCheckYear(res.getCheckYear());
            int abnorm = res.getOc() + res.getSd() + res.getRecheck() + res.getDiseasers();
            int count = abnorm + res.getNormal() + res.getOther();
            if (count > 0) {
                DecimalFormat df = new DecimalFormat("0.00");
                float rate1 = Float.parseFloat(df.format((float)abnorm / (float)count * 100.0f));
                float rate2 = Float.parseFloat(df.format((float)res.getNormal().intValue() / (float)count * 100.0f));
                float rate3 = Float.parseFloat(df.format(100.0f - rate1 - rate2));
                rate.setAbnormalRate(rate1);
                rate.setNormalRate(rate2);
                rate.setOtherRate(rate3);
            }
            yearCountList.add(rate);
        }
        List deptOrworkPhcCountList = this.phcPhysicalCheckCountService.countDeptOrWorkYearResultInfo(query);
        if (deptOrWOrks != null) {
            for (DeptOrWork dept : deptOrWOrks) {
                Boolean ishave = false;
                for (PhcPhysicalCheckResultCountInfo countInfo : deptOrworkPhcCountList) {
                    String deptid = dept.getDeptOrWorkId().toString();
                    if (!countInfo.getGroupId().equals(deptid)) continue;
                    ishave = true;
                    break;
                }
                if (ishave.booleanValue()) continue;
                PhcPhysicalCheckResultCountInfo checkResult = new PhcPhysicalCheckResultCountInfo();
                checkResult.setGroupId(dept.getDeptOrWorkId().toString());
                checkResult.setGroupName(dept.getDeptOrWorkName());
                deptOrworkPhcCountList.add(checkResult);
            }
        }
        m.put((Object)"years", (Object)HseJsonArray.getInstance().fromObject(years));
        m.put((Object)"yearCountList", (Object)HseJsonArray.getInstance().fromObject(yearCountList));
        m.put((Object)"deptOrworkPhcCountList", (Object)HseJsonArray.getInstance().fromObject((Object)deptOrworkPhcCountList));
        if (query.getDeptsOrWorks() != null && query.getDeptsOrWorks().size() == 1) {
            return "work/statisticalQuery/statistical/healthCheckCount3";
        }
        if (query.getDeptsOrWorks() != null && query.getDeptsOrWorks().size() > 1) {
            return "work/statisticalQuery/statistical/healthCheckCount4";
        }
        return "work/statisticalQuery/statistical/promis";
    }

    private String getPhcResultSummData(ModelMap m, StatisticsOption param, PhcPhysicalYearCountQuery query) {
        if (param.getTimeType() == StatisticsOptionEnum.year.getCode()) {
            if (param.getCountYear() == null) {
                return "work/statisticalQuery/statistical/promis";
            }
            query.setBeginYear(param.getCountYear());
            query.setEndYear(param.getCountYear());
        } else if (param.getTimeType() == StatisticsOptionEnum.cycle.getCode()) {
            if (param.getBeginYear() == null || param.getEndYear() == null) {
                return "work/statisticalQuery/statistical/promis";
            }
            query.setBeginYear(param.getBeginYear());
            query.setEndYear(param.getEndYear());
        } else {
            return "work/statisticalQuery/statistical/promis";
        }
        List infolist = this.phcPhysicalCheckCountService.checkTypesInfo(query);
        PhcPhysicalCheckResultCount resultCount = this.phcPhysicalCheckCountService.countResult(query);
        List countList = this.phcPhysicalCheckCountService.countCheckTypeResult(query);
        for (int i = 1; i <= 6; ++i) {
            Boolean ishave = false;
            for (PhcPhysicalCheckTypeInfo info : infolist) {
                if (info.getCheckType() != (byte)i) continue;
                ishave = true;
                break;
            }
            if (ishave.booleanValue()) continue;
            PhcPhysicalCheckTypeInfo checkinfo = new PhcPhysicalCheckTypeInfo();
            checkinfo.setCheckType(Byte.valueOf((byte)i));
            checkinfo.setStaffs(Integer.valueOf(0));
            checkinfo.setTotal(Integer.valueOf(0));
            infolist.add(checkinfo);
        }
        m.put((Object)"infolist", (Object)infolist);
        PhcPhysicalCheckResultCount beforeCheckCo = new PhcPhysicalCheckResultCount();
        PhcPhysicalCheckResultCount onCheckCo = new PhcPhysicalCheckResultCount();
        PhcPhysicalCheckResultCount leaveCheckCo = new PhcPhysicalCheckResultCount();
        PhcPhysicalCheckResultCount reviewCheckCo = new PhcPhysicalCheckResultCount();
        PhcPhysicalCheckResultCount emeCheckCo = new PhcPhysicalCheckResultCount();
        PhcPhysicalCheckResultCount leftCheckCo = new PhcPhysicalCheckResultCount();
        for (PhcPhysicalCheckResultCount count : countList) {
            if (count.getCheckType() != null && count.getCheckType() == 1) {
                beforeCheckCo = count;
                continue;
            }
            if (count.getCheckType() != null && count.getCheckType() == 2) {
                onCheckCo = count;
                continue;
            }
            if (count.getCheckType() != null && count.getCheckType() == 3) {
                leaveCheckCo = count;
                continue;
            }
            if (count.getCheckType() != null && count.getCheckType() == 4) {
                reviewCheckCo = count;
                continue;
            }
            if (count.getCheckType() != null && count.getCheckType() == 5) {
                emeCheckCo = count;
                continue;
            }
            if (count.getCheckType() == null || count.getCheckType() != 6) continue;
            leftCheckCo = count;
        }
        List deptOrWOrks = param.getDeptOrWOrks();
        m.put((Object)"deptOrWOrks", (Object)HseJsonArray.getInstance().fromObject((Object)deptOrWOrks));
        m.put((Object)"beforeCheckCo", (Object)beforeCheckCo);
        m.put((Object)"onCheckCo", (Object)onCheckCo);
        m.put((Object)"leaveCheckCo", (Object)leaveCheckCo);
        m.put((Object)"reviewCheckCo", (Object)reviewCheckCo);
        m.put((Object)"emeCheckCo", (Object)emeCheckCo);
        m.put((Object)"leftCheckCo", (Object)leftCheckCo);
        m.put((Object)"resultCount", (Object)resultCount);
        return "work/statisticalQuery/statistical/healthCheckCount1";
    }

    private void getPhcResultSummDatavo(ModelMap m, PhcPhysicalYearCountQuery query, StatisticsOption param) {
        List infolist = this.phcPhysicalCheckCountService.checkTypesInfo(query);
        PhcPhysicalCheckResultCount resultCount = this.phcPhysicalCheckCountService.countResult(query);
        List countList = this.phcPhysicalCheckCountService.countCheckTypeResult(query);
        for (int i = 1; i <= 6; ++i) {
            Boolean ishave = false;
            for (PhcPhysicalCheckTypeInfo info : infolist) {
                if (info.getCheckType() != (byte)i) continue;
                ishave = true;
                break;
            }
            if (ishave.booleanValue()) continue;
            PhcPhysicalCheckTypeInfo checkinfo = new PhcPhysicalCheckTypeInfo();
            checkinfo.setCheckType(Byte.valueOf((byte)i));
            checkinfo.setStaffs(Integer.valueOf(0));
            checkinfo.setTotal(Integer.valueOf(0));
            infolist.add(checkinfo);
        }
        m.put((Object)"infolist", (Object)infolist);
        PhcPhysicalCheckResultCount beforeCheckCo = new PhcPhysicalCheckResultCount();
        PhcPhysicalCheckResultCount onCheckCo = new PhcPhysicalCheckResultCount();
        PhcPhysicalCheckResultCount leaveCheckCo = new PhcPhysicalCheckResultCount();
        PhcPhysicalCheckResultCount reviewCheckCo = new PhcPhysicalCheckResultCount();
        PhcPhysicalCheckResultCount emeCheckCo = new PhcPhysicalCheckResultCount();
        PhcPhysicalCheckResultCount leftCheckCo = new PhcPhysicalCheckResultCount();
        for (PhcPhysicalCheckResultCount count : countList) {
            if (count.getCheckType() != null && count.getCheckType() == 1) {
                beforeCheckCo = count;
                continue;
            }
            if (count.getCheckType() != null && count.getCheckType() == 2) {
                onCheckCo = count;
                continue;
            }
            if (count.getCheckType() != null && count.getCheckType() == 3) {
                leaveCheckCo = count;
                continue;
            }
            if (count.getCheckType() != null && count.getCheckType() == 4) {
                reviewCheckCo = count;
                continue;
            }
            if (count.getCheckType() != null && count.getCheckType() == 5) {
                emeCheckCo = count;
                continue;
            }
            if (count.getCheckType() == null || count.getCheckType() != 6) continue;
            leftCheckCo = count;
        }
        m.put((Object)"paramInfo", (Object)param);
        m.put((Object)"beforeCheckCo", (Object)beforeCheckCo);
        m.put((Object)"onCheckCo", (Object)onCheckCo);
        m.put((Object)"leaveCheckCo", (Object)leaveCheckCo);
        m.put((Object)"reviewCheckCo", (Object)reviewCheckCo);
        m.put((Object)"emeCheckCo", (Object)emeCheckCo);
        m.put((Object)"leftCheckCo", (Object)leftCheckCo);
        m.put((Object)"resultCount", (Object)resultCount);
    }

    /*
     * WARNING - void declaration
     */
    private String getPhcAbnormalSummData(ModelMap m, StatisticsOption param, PhcPhysicalYearCountQuery query) {
        if (param.getTimeType() == StatisticsOptionEnum.year.getCode()) {
            if (param.getCountYear() == null) {
                return "work/statisticalQuery/statistical/promis";
            }
            query.setBeginYear(param.getCountYear());
            query.setEndYear(param.getCountYear());
        } else if (param.getTimeType() == StatisticsOptionEnum.cycle.getCode()) {
            if (param.getBeginYear() == null || param.getEndYear() == null) {
                return "work/statisticalQuery/statistical/promis";
            }
            query.setBeginYear(param.getBeginYear());
            query.setEndYear(param.getEndYear());
        }
        if (param.getCountObject() == StatisticsOptionEnum.countDept.getCode()) {
            query.setDeptOrWork("dept");
        } else if (param.getCountObject() == StatisticsOptionEnum.countWorkRole.getCode()) {
            query.setDeptOrWork("work");
        }
        if (query.getDeptsOrWorks() == null || query.getDeptsOrWorks().size() < 1) {
            return "work/statisticalQuery/statistical/promis";
        }
        List deptOrWOrks = param.getDeptOrWOrks();
        PhcPhysicalCheckResultGroupCount AbnormalSummData = this.phcPhysicalCheckCountService.countWorkResultInfo(query);
        List AbnormalSummList = AbnormalSummData.getDeptOrWorkGroups();
        Map beforeCheckGroup = new HashMap();
        ArrayList<PhcPhysicalCheckResultGroup> beforeCheckData = new ArrayList<PhcPhysicalCheckResultGroup>();
        Map onCheckGroup = new HashMap();
        ArrayList<PhcPhysicalCheckResultGroup> onCheckData = new ArrayList<PhcPhysicalCheckResultGroup>();
        Map leaveCheckGroup = new HashMap();
        ArrayList<PhcPhysicalCheckResultGroup> leaveCheckData = new ArrayList<PhcPhysicalCheckResultGroup>();
        Map reviewCheckGroup = new HashMap();
        ArrayList<PhcPhysicalCheckResultGroup> reviewCheckData = new ArrayList<PhcPhysicalCheckResultGroup>();
        Map emeCheckGroup = new HashMap();
        ArrayList<PhcPhysicalCheckResultGroup> emeCheckData = new ArrayList<PhcPhysicalCheckResultGroup>();
        Map leftCheckGroup = new HashMap();
        ArrayList<PhcPhysicalCheckResultGroup> leftCheckData = new ArrayList<PhcPhysicalCheckResultGroup>();
        for (PhcPhysicalCheckResultTypeGroup resultGroup : AbnormalSummData.getDeptOrWorkTypeGroups()) {
            if (resultGroup.getCheckType() != null && resultGroup.getCheckType() == 1) {
                beforeCheckGroup = resultGroup.getResultGroup();
                continue;
            }
            if (resultGroup.getCheckType() != null && resultGroup.getCheckType() == 2) {
                onCheckGroup = resultGroup.getResultGroup();
                continue;
            }
            if (resultGroup.getCheckType() != null && resultGroup.getCheckType() == 3) {
                leaveCheckGroup = resultGroup.getResultGroup();
                continue;
            }
            if (resultGroup.getCheckType() != null && resultGroup.getCheckType() == 4) {
                reviewCheckGroup = resultGroup.getResultGroup();
                continue;
            }
            if (resultGroup.getCheckType() != null && resultGroup.getCheckType() == 5) {
                emeCheckGroup = resultGroup.getResultGroup();
                continue;
            }
            if (resultGroup.getCheckType() == null || resultGroup.getCheckType() != 6) continue;
            leftCheckGroup = resultGroup.getResultGroup();
        }
        for (PhcPhysicalCheckResultGroup value : beforeCheckGroup.values()) {
            beforeCheckData.add(value);
        }
        for (PhcPhysicalCheckResultGroup value : onCheckGroup.values()) {
            onCheckData.add(value);
        }
        for (PhcPhysicalCheckResultGroup value : leaveCheckGroup.values()) {
            leaveCheckData.add(value);
        }
        for (PhcPhysicalCheckResultGroup value : reviewCheckGroup.values()) {
            reviewCheckData.add(value);
        }
        for (PhcPhysicalCheckResultGroup value : emeCheckGroup.values()) {
            emeCheckData.add(value);
        }
        for (PhcPhysicalCheckResultGroup value : leftCheckGroup.values()) {
            leftCheckData.add(value);
        }
        if (deptOrWOrks != null) {
            for (DeptOrWork dept : deptOrWOrks) {
                void var27_34;
                Object abnormal72;
                void var25_25;
                Object abnormal52;
                Object abnormal322;
                Boolean ishave = false;
                for (Object abnormal322 : AbnormalSummList) {
                    if (!abnormal322.getDeptOrWorkId().equals(dept.getDeptOrWorkId())) continue;
                    ishave = true;
                    break;
                }
                if (!ishave.booleanValue()) {
                    PhcPhysicalCheckResultGroup checkResult = new PhcPhysicalCheckResultGroup();
                    checkResult.setDeptOrWorkId(dept.getDeptOrWorkId());
                    checkResult.setDeptOrWorkName(dept.getDeptOrWorkName());
                    AbnormalSummList.add(checkResult);
                }
                Boolean beforeCheckishave = false;
                abnormal322 = beforeCheckData.iterator();
                while (abnormal322.hasNext()) {
                    PhcPhysicalCheckResultGroup abnormal4 = (PhcPhysicalCheckResultGroup)abnormal322.next();
                    if (!abnormal4.getDeptOrWorkId().equals(dept.getDeptOrWorkId())) continue;
                    beforeCheckishave = true;
                    break;
                }
                if (!beforeCheckishave.booleanValue()) {
                    PhcPhysicalCheckResultGroup checkResult = new PhcPhysicalCheckResultGroup();
                    checkResult.setDeptOrWorkId(dept.getDeptOrWorkId());
                    checkResult.setDeptOrWorkName(dept.getDeptOrWorkName());
                    beforeCheckData.add(checkResult);
                }
                Boolean onCheckishave = false;
                for (PhcPhysicalCheckResultGroup phcPhysicalCheckResultGroup : onCheckData) {
                    if (!phcPhysicalCheckResultGroup.getDeptOrWorkId().equals(dept.getDeptOrWorkId())) continue;
                    onCheckishave = true;
                    break;
                }
                if (!onCheckishave.booleanValue()) {
                    PhcPhysicalCheckResultGroup checkResult = new PhcPhysicalCheckResultGroup();
                    checkResult.setDeptOrWorkId(dept.getDeptOrWorkId());
                    checkResult.setDeptOrWorkName(dept.getDeptOrWorkName());
                    onCheckData.add(checkResult);
                }
                Boolean leaveCheckishave = false;
                for (Object abnormal52 : leaveCheckData) {
                    if (!abnormal52.getDeptOrWorkId().equals(dept.getDeptOrWorkId())) continue;
                    leaveCheckishave = true;
                    break;
                }
                if (!leaveCheckishave.booleanValue()) {
                    PhcPhysicalCheckResultGroup phcPhysicalCheckResultGroup = new PhcPhysicalCheckResultGroup();
                    phcPhysicalCheckResultGroup.setDeptOrWorkId(dept.getDeptOrWorkId());
                    phcPhysicalCheckResultGroup.setDeptOrWorkName(dept.getDeptOrWorkName());
                    leaveCheckData.add(phcPhysicalCheckResultGroup);
                }
                Boolean bl = false;
                abnormal52 = reviewCheckData.iterator();
                while (abnormal52.hasNext()) {
                    PhcPhysicalCheckResultGroup phcPhysicalCheckResultGroup = (PhcPhysicalCheckResultGroup)abnormal52.next();
                    if (!phcPhysicalCheckResultGroup.getDeptOrWorkId().equals(dept.getDeptOrWorkId())) continue;
                    Boolean bl2 = true;
                    break;
                }
                if (!var25_25.booleanValue()) {
                    PhcPhysicalCheckResultGroup checkResult = new PhcPhysicalCheckResultGroup();
                    checkResult.setDeptOrWorkId(dept.getDeptOrWorkId());
                    checkResult.setDeptOrWorkName(dept.getDeptOrWorkName());
                    reviewCheckData.add(checkResult);
                }
                Boolean emeCheckishave = false;
                for (Object abnormal72 : emeCheckData) {
                    if (!abnormal72.getDeptOrWorkId().equals(dept.getDeptOrWorkId())) continue;
                    emeCheckishave = true;
                    break;
                }
                if (!emeCheckishave.booleanValue()) {
                    PhcPhysicalCheckResultGroup phcPhysicalCheckResultGroup = new PhcPhysicalCheckResultGroup();
                    phcPhysicalCheckResultGroup.setDeptOrWorkId(dept.getDeptOrWorkId());
                    phcPhysicalCheckResultGroup.setDeptOrWorkName(dept.getDeptOrWorkName());
                    emeCheckData.add(phcPhysicalCheckResultGroup);
                }
                Boolean bl3 = false;
                abnormal72 = leftCheckData.iterator();
                while (abnormal72.hasNext()) {
                    PhcPhysicalCheckResultGroup abnormal8 = (PhcPhysicalCheckResultGroup)abnormal72.next();
                    if (!abnormal8.getDeptOrWorkId().equals(dept.getDeptOrWorkId())) continue;
                    Boolean bl4 = true;
                    break;
                }
                if (var27_34.booleanValue()) continue;
                PhcPhysicalCheckResultGroup checkResult = new PhcPhysicalCheckResultGroup();
                checkResult.setDeptOrWorkId(dept.getDeptOrWorkId());
                checkResult.setDeptOrWorkName(dept.getDeptOrWorkName());
                leftCheckData.add(checkResult);
            }
        }
        m.put((Object)"beforeCheckData", (Object)HseJsonArray.getInstance().fromObject(beforeCheckData));
        m.put((Object)"onCheckData", (Object)HseJsonArray.getInstance().fromObject(onCheckData));
        m.put((Object)"leaveCheckData", (Object)HseJsonArray.getInstance().fromObject(leaveCheckData));
        m.put((Object)"reviewCheckData", (Object)HseJsonArray.getInstance().fromObject(reviewCheckData));
        m.put((Object)"emeCheckData", (Object)HseJsonArray.getInstance().fromObject(emeCheckData));
        m.put((Object)"leftCheckData", (Object)HseJsonArray.getInstance().fromObject(leftCheckData));
        m.put((Object)"AbnormalSummList", (Object)HseJsonArray.getInstance().fromObject((Object)AbnormalSummList));
        return "work/statisticalQuery/statistical/healthCheckCount2";
    }

    @ResponseBody
    @RequestMapping(value={"listPhcCheckData"})
    public JqGridData<PhcPhysicalQueryCheckInfo> listPhcCheckData(HttpServletRequest request, JqGridParam param, PhcPhysicalQueryCheck query, HttpSession session, ModelMap m) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        query.setCid(cid);
        PageInfo page = this.phcPhysicalCheckCountService.queryCheckList(param, query);
        JqGridData data = new JqGridData(page, param);
        return data;
    }

    @RequestMapping(value={"viewHealthCheck"}, method={RequestMethod.GET})
    public String page_edit(Long checkId, HttpSession session, ModelMap m) {
        PhcPhysicalQueryCheckInfo checkInfo = this.phcPhysicalCheckCountService.queryCheckInfo(checkId, null);
        m.put((Object)"checkInfo", (Object)checkInfo);
        return "work/statisticalQuery/query/viewCheckInfo";
    }

    @ResponseBody
    @RequestMapping(value={"getAbnormalInfo"})
    public JqGridData<PhcPhysicalCheckAbnormalInfo> getAbnormalInfo(HttpServletRequest request, JqGridParam param, PhcPhysicalCheckParam query, HttpSession session, ModelMap m) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        query.setCid(cid);
        PageInfo page = this.phcPhysicalCheckCountService.queryCheckAbnormalResult(param, query);
        JqGridData data = new JqGridData(page, param);
        return data;
    }

    @ResponseBody
    @RequestMapping(value={"listFactorData"})
    public JqGridData<CheckPlanList> listFactorData(HttpServletRequest request, JqGridParam param, HcCheckPlanQueryParam query, HttpSession session, ModelMap m) {
        return this.checkStatisticHelper.listFactorData(param, query);
    }

    @RequestMapping(value={"viewHcCHeckPlan"}, method={RequestMethod.GET})
    public String viewHcCHeckPlan(Long checkPlanId, HttpSession session, ModelMap m) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        CheckPlan checkInfo = this.checkStatisticHelper.getCheckById(checkPlanId);
        CheckOverPoint overPoint = this.checkStatisticHelper.getCheckPointByCheck(checkPlanId);
        m.put((Object)"checkInfo", (Object)checkInfo);
        m.put((Object)"overPoint", (Object)overPoint);
        m.put((Object)"successRate", (Object)0);
        if (overPoint.getCheckPoint() > 0) {
            double v = (double)overPoint.getPassPoint().intValue() / (double)overPoint.getCheckPoint().intValue();
            String s = this.checkStatisticHelper.formatPercent(v);
            m.put((Object)"successRate", (Object)s);
        }
        return "work/statisticalQuery/query/viewFactorCheck";
    }

    @ResponseBody
    @RequestMapping(value={"getPointRate"})
    public JqGridData<HarmCheckRateVo> getPointRate(HttpServletRequest request, JqGridParam param, Long hcId, HttpSession session, ModelMap m) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        PageInfo<HarmCheckRateVo> page = this.checkStatisticHelper.getHarmCheckRateVosByHcId(param, cid, hcId);
        JqGridData data = new JqGridData(page, param);
        return data;
    }
}

