/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.work.statisticalQuery;

import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.util.PageUtil;
import cn.smarthse.modules.health.entity.base.company.CompanyOrganization;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCheckCollectDataStat;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCheckHarm;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCheckHarmMapByWorkAndYear;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCheckHarmStatByYear;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCheckPlanQueryParam;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCheckStatHarmByYearAndWork;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCheckWorkPointRate;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCheckYearCount;
import cn.smarthse.modules.health.entity.work.hccheckplan.vo.HarmCheckRateVo;
import cn.smarthse.modules.health.entity.work.hccheckplan.vo.HcCheckBiologicalConcentrationStat;
import cn.smarthse.modules.health.entity.work.hccheckplan.vo.HcCheckBiologicalConcentrationVo;
import cn.smarthse.modules.health.entity.work.hccheckplan.vo.HcCheckChemicalConcentrationStat;
import cn.smarthse.modules.health.entity.work.hccheckplan.vo.HcCheckChemicalConcentrationVo;
import cn.smarthse.modules.health.entity.work.hccheckplan.vo.HcCheckCollectMicrowaveradiationConcentrationVo;
import cn.smarthse.modules.health.entity.work.hccheckplan.vo.HcCheckCollectPowerfrequencyConcentrationVo;
import cn.smarthse.modules.health.entity.work.hccheckplan.vo.HcCheckCollectUltravioletlightConcentrationVo;
import cn.smarthse.modules.health.entity.work.hccheckplan.vo.HcCheckConcentrationStat;
import cn.smarthse.modules.health.entity.work.hccheckplan.vo.HcCheckDustConcentrationStat;
import cn.smarthse.modules.health.entity.work.hccheckplan.vo.HcCheckDustConcentrationVo;
import cn.smarthse.modules.health.entity.work.hccheckplan.vo.HcCheckHandtransmittedConcentrationVo;
import cn.smarthse.modules.health.entity.work.hccheckplan.vo.HcCheckHighFrequencyConcentrationVo;
import cn.smarthse.modules.health.entity.work.hccheckplan.vo.HcCheckHightemperatureConcentrationVo;
import cn.smarthse.modules.health.entity.work.hccheckplan.vo.HcCheckIonizingradiationConcentrationVo;
import cn.smarthse.modules.health.entity.work.hccheckplan.vo.HcCheckLaserradiationConcentrationVo;
import cn.smarthse.modules.health.entity.work.hccheckplan.vo.HcCheckNoiseConcentrationVo;
import cn.smarthse.modules.health.entity.work.hccheckplan.vo.HcCheckUltrahighfrequencyradiationConcentrationVo;
import cn.smarthse.modules.health.service.base.company.ICompanyOrganizationService;
import cn.smarthse.modules.health.service.work.harmfactor.IHarmfactorWorkSourceService;
import cn.smarthse.modules.health.vo.work.harmfactor.WorkHarmFactorCheckPointVo;
import cn.smarthse.services.hfi.api.entity.CheckOverPoint;
import cn.smarthse.services.hfi.api.entity.CheckPlan;
import cn.smarthse.services.hfi.api.model.CheckResultParseQueryModel;
import cn.smarthse.services.hfi.api.model.list.CheckPlanList;
import cn.smarthse.services.hfi.api.model.list.CheckPlanListParam;
import cn.smarthse.services.hfi.api.pojo.vo.CheckRecordFileCheckResultVo;
import cn.smarthse.services.hfi.api.pojo.vo.CheckRecordFileVo;
import cn.smarthse.services.hfi.api.service.ICheckOverPointService;
import cn.smarthse.services.hfi.api.service.ICheckPlanService;
import cn.smarthse.services.hfi.api.service.ICheckResultParseService;
import cn.smarthse.util.common.date.DateUtils;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Component;

@Component
public class CheckStatisticHelper {
    @DubboReference
    private ICheckResultParseService checkResultParseService;
    @DubboReference
    private IHarmfactorWorkSourceService workSourceService;
    @DubboReference
    private ICheckPlanService checkPlanService;
    @DubboReference
    private ICompanyOrganizationService organizationService;
    @DubboReference
    private ICheckOverPointService checkOverPointService;

    public PageInfo<HcCheckWorkPointRate> harmWorkRate(JqGridParam param, Long cid, Integer beginYear, Integer endYear) {
        CheckResultParseQueryModel queryModel = this.checkResultParseQueryModel(cid, beginYear, endYear);
        List resultVos = this.checkResultParseService.queryCheckRecordFileVos(queryModel);
        List all = this.workSourceService.getAllWorkHarmFactorVos(cid);
        if (resultVos == null || resultVos.isEmpty() || all == null || all.isEmpty()) {
            return new PageInfo(new ArrayList(0));
        }
        this.filterCheck(all, resultVos);
        if (all.isEmpty()) {
            return new PageInfo(new ArrayList(0));
        }
        HashSet<Long> workIds = new HashSet<Long>();
        HashSet<Long> failWorkIds = new HashSet<Long>();
        LinkedList<HcCheckWorkPointRate> rates = new LinkedList<HcCheckWorkPointRate>();
        HcCheckWorkPointRate currentRate = this.createHcCheckWorkPointRate((WorkHarmFactorCheckPointVo)all.get(0));
        rates.add(currentRate);
        for (WorkHarmFactorCheckPointVo vo : all) {
            if (!vo.getHarmId().equals(currentRate.getHarmId())) {
                this.parseCount(currentRate, workIds, failWorkIds);
                currentRate = this.createHcCheckWorkPointRate(vo);
                workIds.clear();
                failWorkIds.clear();
                rates.add(currentRate);
                continue;
            }
            workIds.add(vo.getWorkId());
            boolean isFail = this.isFail(vo, resultVos);
            if (!isFail) continue;
            failWorkIds.add(vo.getWorkId());
        }
        this.parseCount(currentRate, workIds, failWorkIds);
        return PageUtil.getPageInfo(rates, (int)param.getPage(), (int)param.getRows());
    }

    private void parseCount(HcCheckWorkPointRate currentRate, Set<Long> workIds, Set<Long> failWorkIds) {
        currentRate.setCheckWorkCount(Integer.valueOf(workIds.size()));
        currentRate.setOverproofCount(Integer.valueOf(failWorkIds.size()));
        currentRate.setOverproofWordIds(failWorkIds.stream().map(id -> "" + id).collect(Collectors.toList()));
        if (currentRate.getCheckWorkCount() > 0) {
            currentRate.setRate(String.format("%.2f", (double)currentRate.getOverproofCount().intValue() / (double)currentRate.getCheckWorkCount().intValue()));
        }
    }

    private boolean isFail(WorkHarmFactorCheckPointVo vo, List<CheckRecordFileVo> resultVos) {
        for (CheckRecordFileVo resultVo : resultVos) {
            if (!vo.getHarmId().toString().equals(resultVo.getFactorId()) || !vo.getCheckId().equals(resultVo.getCheckId()) || !vo.getCheckPoint().equals(resultVo.getCheckPointName()) || !"3".equals(resultVo.getJudgeResult())) continue;
            return true;
        }
        return false;
    }

    private HcCheckWorkPointRate createHcCheckWorkPointRate(WorkHarmFactorCheckPointVo vo) {
        HcCheckWorkPointRate currentRate = new HcCheckWorkPointRate();
        currentRate.setCheckWorkCount(Integer.valueOf(0));
        currentRate.setHarmId(vo.getHarmId());
        currentRate.setHarmName(vo.getHarmName());
        currentRate.setOverproofCount(Integer.valueOf(0));
        currentRate.setRate("0");
        return currentRate;
    }

    private void filterCheck(List<WorkHarmFactorCheckPointVo> all, List<CheckRecordFileVo> resultVos) {
        HashSet ids = new HashSet();
        resultVos.forEach(vo -> ids.add(vo.getCheckId()));
        Iterator<WorkHarmFactorCheckPointVo> iterator = all.iterator();
        while (iterator.hasNext()) {
            if (ids.contains(iterator.next().getCheckId())) continue;
            iterator.remove();
        }
    }

    private CheckResultParseQueryModel checkResultParseQueryModel(Long cid, Integer beginYear, Integer endYear) {
        LocalDateTime start = DateUtils.getLocalDateTime((int)beginYear, (int)1, (int)1, (int)0, (int)0, (int)0);
        LocalDateTime end = DateUtils.getLocalDateTime((int)endYear, (int)12, (int)31, (int)23, (int)59, (int)59);
        CheckResultParseQueryModel queryModel = new CheckResultParseQueryModel();
        queryModel.setCheckBeginStart(start);
        queryModel.setCheckBeginEnd(end);
        queryModel.setCheckTypes(Arrays.asList(1L, 2L, 3L, 4L, 5L));
        queryModel.setCid(cid);
        return queryModel;
    }

    public List<HcCheckHarmMapByWorkAndYear> getHcCheckHarmMapByWorkAndYear(Long cid, Integer beginYear, Integer endYear) {
        List all = this.workSourceService.getAllWorkHarmFactorVos(cid);
        List resultVos = this.checkResultParseService.queryCheckRecordFileVos(this.checkResultParseQueryModel(cid, beginYear, endYear));
        this.filterCheck(all, resultVos);
        List<HcCheckHarmMapByWorkAndYear> list = this.groupByWorkId(all, resultVos);
        return list;
    }

    private List<HcCheckCollectDataStat> getHcCheckHarmMapByHarmAndYear(Long cid, Integer beginYear, Integer endYear) {
        List all = this.workSourceService.getAllWorkHarmFactorVos(cid);
        List resultVos = this.checkResultParseService.queryCheckRecordFileVos(this.checkResultParseQueryModel(cid, beginYear, endYear));
        this.filterCheck(all, resultVos);
        List<HcCheckCollectDataStat> list = this.groupByHarmId(all, resultVos);
        return list;
    }

    public List<HcCheckHarm> getAllFactor(List<HcCheckHarmMapByWorkAndYear> list) {
        LinkedList<HcCheckHarm> rList = new LinkedList<HcCheckHarm>();
        HashSet<Long> harmIdSet = new HashSet<Long>();
        for (HcCheckHarmMapByWorkAndYear andYear : list) {
            for (HcCheckHarm harm : andYear.getList()) {
                if (harmIdSet.contains(harm.getHarmId())) continue;
                rList.add(harm);
                harmIdSet.add(harm.getHarmId());
            }
        }
        return rList;
    }

    private List<HcCheckHarmMapByWorkAndYear> groupByWorkId(List<WorkHarmFactorCheckPointVo> all, List<CheckRecordFileVo> resultVos) {
        HashMap<Long, HcCheckHarmMapByWorkAndYear> map = new HashMap<Long, HcCheckHarmMapByWorkAndYear>();
        all.forEach(vo -> {
            HcCheckHarmMapByWorkAndYear workAndYear = (HcCheckHarmMapByWorkAndYear)map.get(vo.getWorkId());
            if (workAndYear == null) {
                workAndYear = new HcCheckHarmMapByWorkAndYear();
                workAndYear.setWorkId(vo.getWorkId());
                workAndYear.setWorkName(vo.getWorkName());
                workAndYear.setList(new LinkedList());
                workAndYear.setMap(new HashMap());
                map.put(vo.getWorkId(), workAndYear);
            }
            List list = workAndYear.getList();
            Map m = workAndYear.getMap();
            HcCheckHarm harm = new HcCheckHarm();
            harm.setHarmId(vo.getHarmId());
            harm.setHarmName(vo.getHarmName());
            harm.setYear(this.getCheckYear((WorkHarmFactorCheckPointVo)vo, resultVos));
            harm.setIsOverproof(Boolean.valueOf(this.isFail((WorkHarmFactorCheckPointVo)vo, resultVos)));
            harm.setProof(Integer.valueOf(harm.getIsOverproof() != false ? 1 : 0));
            list.add(harm);
            if (m.get("" + harm.getHarmId()) == null || !((HcCheckHarm)m.get("" + harm.getHarmId())).getIsOverproof().booleanValue()) {
                m.put("" + harm.getHarmId(), harm);
            }
        });
        LinkedList<HcCheckHarmMapByWorkAndYear> list = new LinkedList<HcCheckHarmMapByWorkAndYear>();
        map.forEach((key, value) -> list.add((HcCheckHarmMapByWorkAndYear)value));
        return list;
    }

    private Integer getCheckYear(WorkHarmFactorCheckPointVo vo, List<CheckRecordFileVo> resultVos) {
        for (CheckRecordFileVo resultVo : resultVos) {
            if (!vo.getHarmId().toString().equals(resultVo.getFactorId()) || !vo.getCheckId().equals(resultVo.getCheckId()) || !vo.getCheckPoint().equals(resultVo.getCheckPointName())) continue;
            return resultVo.getCheckDate().getYear();
        }
        return null;
    }

    private List<HcCheckCollectDataStat> groupByHarmId(List<WorkHarmFactorCheckPointVo> all, List<CheckRecordFileVo> resultVos) {
        HashMap<Long, HcCheckCollectDataStat> map = new HashMap<Long, HcCheckCollectDataStat>();
        all.forEach(vo -> {
            HcCheckCollectDataStat dataStat = (HcCheckCollectDataStat)map.get(vo.getHarmId());
            if (dataStat == null) {
                dataStat = new HcCheckCollectDataStat();
                dataStat.setHarmId(vo.getHarmId());
                dataStat.setHarmName(vo.getHarmName());
                dataStat.setOverproofCount(Long.valueOf(0L));
                dataStat.setWorkNames("");
                map.put(vo.getHarmId(), dataStat);
            }
            if (this.isFail((WorkHarmFactorCheckPointVo)vo, resultVos) && !dataStat.getWorkNames().contains(vo.getWorkName())) {
                dataStat.setWorkNames(dataStat.getWorkNames() + vo.getWorkName() + ",");
                dataStat.setOverproofCount(Long.valueOf(dataStat.getOverproofCount() + 1L));
            }
        });
        LinkedList<HcCheckCollectDataStat> list = new LinkedList<HcCheckCollectDataStat>();
        map.forEach((key, value) -> list.add((HcCheckCollectDataStat)value));
        return list;
    }

    public List<HcCheckCollectDataStat> getHcCheckCollectDataStatFromWorkByYear(Long cid, Integer beginYear, Integer endYear) {
        List<HcCheckHarmMapByWorkAndYear> list = this.getHcCheckHarmMapByWorkAndYear(cid, beginYear, endYear);
        LinkedList<HcCheckCollectDataStat> rList = new LinkedList<HcCheckCollectDataStat>();
        list.forEach(work -> {
            HcCheckCollectDataStat stat = new HcCheckCollectDataStat();
            stat.setWorkName(work.getWorkName());
            stat.setHarmNames(this.getFailFactorNames((HcCheckHarmMapByWorkAndYear)work));
            stat.setWorkId(work.getWorkId());
            stat.setOverproofCount(this.getFailCount((HcCheckHarmMapByWorkAndYear)work));
            rList.add(stat);
        });
        return rList;
    }

    private Long getFailCount(HcCheckHarmMapByWorkAndYear work) {
        Long count = 0L;
        for (HcCheckHarm harm : work.getList()) {
            if (!harm.getIsOverproof().booleanValue()) continue;
            Long l = count;
            count = count + 1L;
        }
        return count;
    }

    private String getFailFactorNames(HcCheckHarmMapByWorkAndYear work) {
        StringBuilder sb = new StringBuilder();
        List list = work.getList();
        list.forEach(harm -> {
            if (harm.getIsOverproof().booleanValue()) {
                sb.append(harm.getHarmName());
                sb.append(",");
            }
        });
        if (sb.length() > 0) {
            return sb.substring(0, sb.length() - 1);
        }
        return "";
    }

    public List<HcCheckCollectDataStat> getHcCheckCollectDataStatFromHarmByYear(Long cid, Integer beginYear, Integer endYear) {
        return this.getHcCheckHarmMapByHarmAndYear(cid, beginYear, endYear);
    }

    public void fillHarmCheckResult(List<HcCheckHarmMapByWorkAndYear> relituData, List<HcCheckHarm> harmList) {
        for (HcCheckHarmMapByWorkAndYear relituDatum : relituData) {
            relituDatum.setHarmCheckResult(new LinkedHashMap());
            LinkedHashMap harmCheckResult = relituDatum.getHarmCheckResult();
            for (HcCheckHarm harm : harmList) {
                String result = this.getJudgeResult(harm, relituDatum.getList());
                harmCheckResult.put(harm.getHarmId(), result);
            }
        }
    }

    private String getJudgeResult(HcCheckHarm harm, List<HcCheckHarm> list) {
        StringBuilder sb = new StringBuilder();
        for (HcCheckHarm hcCheckHarm : list) {
            if (!hcCheckHarm.getHarmId().equals(harm.getHarmId())) continue;
            sb.append(hcCheckHarm.getIsOverproof() != false ? "\u8d85\u6807" : "\u7b26\u5408");
        }
        if (sb.length() == 0) {
            return "";
        }
        if (sb.toString().contains("\u8d85\u6807")) {
            return "\u8d85\u6807";
        }
        return "\u7b26\u5408";
    }

    public List<HcCheckHarmStatByYear> getHcCheckHarmStatByYearAndWorkId(Long cid, Long workId, Integer beginYear, Integer endYear) {
        CheckResultParseQueryModel queryModel = this.checkResultParseQueryModel(cid, beginYear, endYear);
        List resultVos = this.checkResultParseService.queryCheckRecordFileVos(queryModel);
        List all = this.workSourceService.getAllWorkHarmFactorVos(cid);
        this.filterCheck(all, resultVos);
        this.filterByWorkId(all, workId);
        HashMap<Integer, HcCheckHarmStatByYear> map = new HashMap<Integer, HcCheckHarmStatByYear>();
        for (int i = beginYear.intValue(); i <= endYear; ++i) {
            HcCheckHarmStatByYear byYear = new HcCheckHarmStatByYear();
            byYear.setHarmCount(Long.valueOf(0L));
            byYear.setHarmNames("");
            byYear.setYear(Integer.valueOf(i));
            map.put(i, byYear);
        }
        all.forEach(vo -> {
            for (CheckRecordFileVo resultVo : resultVos) {
                if (!vo.getHarmId().toString().equals(resultVo.getFactorId()) || !vo.getCheckId().equals(resultVo.getCheckId()) || !vo.getCheckPoint().equals(resultVo.getCheckPointName()) || !"3".equals(resultVo.getJudgeResult())) continue;
                Integer year = resultVo.getCheckDate().getYear();
                HcCheckHarmStatByYear byYear = (HcCheckHarmStatByYear)map.get(year);
                if (byYear == null) {
                    byYear = new HcCheckHarmStatByYear();
                    byYear.setHarmCount(Long.valueOf(1L));
                    byYear.setHarmNames(vo.getHarmName());
                    byYear.setYear(year);
                    map.put(year, byYear);
                    continue;
                }
                if (byYear.getHarmNames().contains(vo.getHarmName())) continue;
                byYear.setHarmCount(Long.valueOf(byYear.getHarmCount() + 1L));
                byYear.setHarmNames(byYear.getHarmNames() + " " + vo.getHarmName());
            }
        });
        LinkedList<HcCheckHarmStatByYear> list = new LinkedList<HcCheckHarmStatByYear>();
        list.addAll(map.values());
        return list;
    }

    private void filterByWorkId(List<WorkHarmFactorCheckPointVo> all, Long ... workIds) {
        Iterator<WorkHarmFactorCheckPointVo> iterator = all.iterator();
        while (iterator.hasNext()) {
            WorkHarmFactorCheckPointVo next = iterator.next();
            boolean find = false;
            for (Long workId : workIds) {
                if (!next.getWorkId().equals(workId)) continue;
                find = true;
                break;
            }
            if (find) continue;
            iterator.remove();
        }
    }

    public JqGridData<CheckPlanList> listFactorData(JqGridParam param, HcCheckPlanQueryParam query) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        CheckPlanListParam searchVo = new CheckPlanListParam();
        searchVo.setCid(cid);
        searchVo.setWorkNo(query.getSearchKey());
        if (query.getServiceOrgId() != null) {
            searchVo.setThirdOrgId(Long.valueOf(Long.parseLong(query.getServiceOrgId())));
        }
        if (query.getCheckTypes() != null) {
            searchVo.setCheckTypes(query.getCheckTypes().stream().map(Byte::intValue).collect(Collectors.toList()));
        }
        searchVo.setCheckDateBegin(query.getStartTime());
        searchVo.setCheckDateEnd(query.getEndTime());
        searchVo.setCheckResultType(query.getCheckResultType());
        PageInfo list = this.checkPlanService.getCheckPlanPage(param, searchVo, Boolean.valueOf(true));
        List deptS = this.organizationService.getListByCid(cid);
        for (CheckPlanList planList : list.getList()) {
            if (planList.getDeptId() != null) {
                planList.setThirdOrgName(this.getDept(deptS, planList.getDeptId()));
            }
            if (planList.getThirdOrgId() == null) continue;
        }
        return new JqGridData(list, param);
    }

    private String getDept(List<CompanyOrganization> orgs, Long id) {
        for (CompanyOrganization org : orgs) {
            if (!org.getId().equals(id)) continue;
            return org.getOrganizationName();
        }
        return "";
    }

    public CheckPlan getCheckById(Long checkPlanId) {
        return (CheckPlan)this.checkPlanService.getById((Serializable)checkPlanId);
    }

    public CheckOverPoint getCheckPointByCheck(Long checkId) {
        return (CheckOverPoint)this.checkOverPointService.getById((Serializable)checkId);
    }

    public PageInfo<HarmCheckRateVo> getHarmCheckRateVosByHcId(JqGridParam param, Long cid, Long hcId) {
        CheckResultParseQueryModel queryModel = new CheckResultParseQueryModel();
        queryModel.setCid(cid);
        queryModel.setCheckId(hcId);
        List resultVos = this.checkResultParseService.queryCheckRecordFileVos(queryModel);
        LinkedList list = new LinkedList();
        HashMap<Long, HarmCheckRateVo> map = new HashMap<Long, HarmCheckRateVo>();
        for (CheckRecordFileVo vo : resultVos) {
            try {
                Long harmId = Long.parseLong(vo.getFactorId());
                HarmCheckRateVo rateVo = (HarmCheckRateVo)map.get(harmId);
                if (rateVo == null) {
                    rateVo = new HarmCheckRateVo();
                    rateVo.setHarmName(vo.getFactorName());
                    rateVo.setHarmId(harmId);
                    rateVo.setCheckPointCount(Integer.valueOf(0));
                    rateVo.setGoodCheckPointCount(Integer.valueOf(0));
                    rateVo.setHcId(vo.getCheckId());
                    rateVo.setNoGoodCheckPointCount(Integer.valueOf(0));
                    map.put(harmId, rateVo);
                }
                rateVo.setCheckPointCount(Integer.valueOf(rateVo.getCheckPointCount() + 1));
                if ("2".equals(vo.getJudgeResult())) {
                    rateVo.setGoodCheckPointCount(Integer.valueOf(rateVo.getGoodCheckPointCount() + 1));
                }
                if ("3".equals(vo.getJudgeResult())) {
                    rateVo.setNoGoodCheckPointCount(Integer.valueOf(rateVo.getNoGoodCheckPointCount() + 1));
                }
                double v = (double)rateVo.getGoodCheckPointCount().intValue() / (double)rateVo.getCheckPointCount().intValue();
                String s = this.formatPercent(v);
                rateVo.setRate(s);
            }
            catch (NumberFormatException e) {}
        }
        list.addAll(map.values());
        return PageUtil.getPageInfo(list, (int)param.getPage(), (int)param.getRows());
    }

    public String formatPercent(double v) {
        String format;
        DecimalFormat decimalFormat = new DecimalFormat("###################.###########");
        String substring = format = decimalFormat.format(v * 100.0);
        if (format.length() > 5) {
            substring = format.substring(0, 5);
        }
        return substring + "%";
    }

    public HcCheckConcentrationStat getHcCheckConcentrationStat(Long cid, Integer beginYear, Integer endYear, Long ... workId) {
        HcCheckConcentrationStat stat = new HcCheckConcentrationStat();
        CheckResultParseQueryModel queryModel = this.checkResultParseQueryModel(cid, beginYear, endYear);
        List resultVos = this.checkResultParseService.queryCheckRecordFileVos(queryModel);
        List all = this.workSourceService.getAllWorkHarmFactorVos(cid);
        this.filterByWorkId(all, workId);
        this.filterCheckResult(resultVos, all);
        stat.setChemicals(this.getChemicalStat(resultVos));
        stat.setBiologicals(this.getBiologicalStat(resultVos));
        stat.setDusts(this.getDustStat(resultVos));
        stat.setNoise(this.getNoiseStat(resultVos));
        stat.setHighFrequency(this.getHighFrequencyStat(resultVos));
        stat.setIonizingradiation(this.getIonizingradiationStat(resultVos));
        stat.setUltrahighfrequencyradiation(this.getUltrahighfrequencyradiationStat(resultVos));
        stat.setHandtransmitted(this.getHandtransmittedStat(resultVos));
        stat.setMicrowaveradiation(this.getMicrowaveradiationStat(resultVos));
        stat.setUltravioletlight(this.getUltravioletlightStat(resultVos));
        stat.setPowerfrequency(this.getPowerfrequencyStat(resultVos));
        stat.setHightemperature(this.getHightemperatureStat(resultVos));
        stat.setLaserradiation(this.getLaserradiationStat(resultVos));
        return stat;
    }

    private void filterCheckResult(List<CheckRecordFileVo> resultVos, List<WorkHarmFactorCheckPointVo> checkPointVos) {
        Iterator<CheckRecordFileVo> iterator = resultVos.iterator();
        while (iterator.hasNext()) {
            boolean find = false;
            CheckRecordFileVo vo = iterator.next();
            for (WorkHarmFactorCheckPointVo pointVo : checkPointVos) {
                if (vo.getFactorId() == null || !vo.getFactorId().equals("" + pointVo.getHarmId()) || !vo.getCheckId().equals(pointVo.getCheckId()) || !vo.getCheckPointName().equals(pointVo.getCheckPoint())) continue;
                find = true;
                break;
            }
            if (find) continue;
            iterator.remove();
        }
    }

    private List<HcCheckChemicalConcentrationStat> getChemicalStat(List<CheckRecordFileVo> resultVos) {
        LinkedList<HcCheckChemicalConcentrationStat> list = new LinkedList<HcCheckChemicalConcentrationStat>();
        resultVos = resultVos.stream().filter(vo -> vo.getItemId().equals(1L)).collect(Collectors.toList());
        Map<String, List<CheckRecordFileVo>> map = this.groupByFactor(resultVos);
        for (Map.Entry<String, List<CheckRecordFileVo>> entry : map.entrySet()) {
            HcCheckChemicalConcentrationStat stat = new HcCheckChemicalConcentrationStat();
            list.add(stat);
            String key = entry.getKey();
            stat.setHarmName(key.substring(key.indexOf("-") + 1));
            Long harmId = Long.parseLong(key.substring(0, key.indexOf("-")));
            LinkedList<HcCheckChemicalConcentrationVo> subList = new LinkedList<HcCheckChemicalConcentrationVo>();
            stat.setList(subList);
            Map<Integer, List<CheckRecordFileVo>> yearMap = this.groupByYear(entry.getValue());
            for (Map.Entry<Integer, List<CheckRecordFileVo>> yearEntry : yearMap.entrySet()) {
                HcCheckChemicalConcentrationVo vo2 = new HcCheckChemicalConcentrationVo();
                subList.add(vo2);
                vo2.setYear(yearEntry.getKey());
                vo2.setHarmId(harmId);
                vo2.setHarmName(stat.getHarmName());
                List<CheckRecordFileVo> values = yearEntry.getValue();
                vo2.setCmacMax(this.getMaxValueByTargetId(values, 6));
                vo2.setCmacMin(this.getMinValueByTargetId(values, 6));
                vo2.setCmacAvg(this.getAvgValueByTargetId(values, 6));
                vo2.setCtwaMax(this.getMaxValueByTargetId(values, 3));
                vo2.setCtwaMin(this.getMinValueByTargetId(values, 3));
                vo2.setCtwaAvg(this.getAvgValueByTargetId(values, 3));
                vo2.setCstelMax(this.getMaxValueByTargetId(values, 7));
                vo2.setCstelMin(this.getMinValueByTargetId(values, 7));
                vo2.setCstelAvg(this.getAvgValueByTargetId(values, 7));
                vo2.setPeakcontactconcentrationMax(this.getMaxValueByTargetId(values, 8));
                vo2.setPeakcontactconcentrationMin(this.getMinValueByTargetId(values, 8));
                vo2.setPeakcontactconcentrationAvg(this.getAvgValueByTargetId(values, 8));
                vo2.setTimesMax(this.getMaxValueByTargetId(values, 9));
                vo2.setTimesMin(this.getMinValueByTargetId(values, 9));
                vo2.setTimesAvg(this.getAvgValueByTargetId(values, 9));
            }
        }
        return list;
    }

    private List<HcCheckBiologicalConcentrationStat> getBiologicalStat(List<CheckRecordFileVo> resultVos) {
        LinkedList<HcCheckBiologicalConcentrationStat> list = new LinkedList<HcCheckBiologicalConcentrationStat>();
        resultVos = resultVos.stream().filter(vo -> vo.getItemId().equals(13L)).collect(Collectors.toList());
        Map<String, List<CheckRecordFileVo>> map = this.groupByFactor(resultVos);
        for (Map.Entry<String, List<CheckRecordFileVo>> entry : map.entrySet()) {
            HcCheckBiologicalConcentrationStat stat = new HcCheckBiologicalConcentrationStat();
            list.add(stat);
            String key = entry.getKey();
            stat.setHarmName(key.substring(key.indexOf("-") + 1));
            Long harmId = Long.parseLong(key.substring(0, key.indexOf("-")));
            LinkedList<HcCheckBiologicalConcentrationVo> subList = new LinkedList<HcCheckBiologicalConcentrationVo>();
            stat.setList(subList);
            Map<Integer, List<CheckRecordFileVo>> yearMap = this.groupByYear(entry.getValue());
            for (Map.Entry<Integer, List<CheckRecordFileVo>> yearEntry : yearMap.entrySet()) {
                HcCheckBiologicalConcentrationVo vo2 = new HcCheckBiologicalConcentrationVo();
                subList.add(vo2);
                vo2.setYear(yearEntry.getKey());
                vo2.setHarmId(harmId);
                vo2.setHarmName(stat.getHarmName());
                List<CheckRecordFileVo> values = yearEntry.getValue();
                vo2.setCmacMax(this.getMaxValueByTargetId(values, 100));
                vo2.setCmacMin(this.getMinValueByTargetId(values, 100));
                vo2.setCmacAvg(this.getAvgValueByTargetId(values, 100));
                vo2.setCtwaMax(this.getMaxValueByTargetId(values, 101));
                vo2.setCtwaMin(this.getMinValueByTargetId(values, 101));
                vo2.setCtwaAvg(this.getAvgValueByTargetId(values, 101));
                vo2.setCstelMax(this.getMaxValueByTargetId(values, 103));
                vo2.setCstelMin(this.getMinValueByTargetId(values, 103));
                vo2.setCstelAvg(this.getAvgValueByTargetId(values, 103));
                vo2.setTimesMax(0.0);
                vo2.setTimesMin(0.0);
                vo2.setTimesAvg(0.0);
            }
        }
        return list;
    }

    private List<HcCheckDustConcentrationStat> getDustStat(List<CheckRecordFileVo> resultVos) {
        LinkedList<HcCheckDustConcentrationStat> list = new LinkedList<HcCheckDustConcentrationStat>();
        resultVos = resultVos.stream().filter(vo -> vo.getItemId().equals(2L)).collect(Collectors.toList());
        Map<String, List<CheckRecordFileVo>> map = this.groupByFactor(resultVos);
        for (Map.Entry<String, List<CheckRecordFileVo>> entry : map.entrySet()) {
            HcCheckDustConcentrationStat stat = new HcCheckDustConcentrationStat();
            list.add(stat);
            String key = entry.getKey();
            stat.setHarmName(key.substring(key.indexOf("-") + 1));
            Long harmId = Long.parseLong(key.substring(0, key.indexOf("-")));
            LinkedList<HcCheckDustConcentrationVo> subList = new LinkedList<HcCheckDustConcentrationVo>();
            stat.setList(subList);
            Map<Integer, List<CheckRecordFileVo>> yearMap = this.groupByYear(entry.getValue());
            for (Map.Entry<Integer, List<CheckRecordFileVo>> yearEntry : yearMap.entrySet()) {
                HcCheckDustConcentrationVo vo2 = new HcCheckDustConcentrationVo();
                subList.add(vo2);
                vo2.setYear(yearEntry.getKey());
                vo2.setHarmId(harmId);
                vo2.setHarmName(stat.getHarmName());
                List<CheckRecordFileVo> values = yearEntry.getValue();
                vo2.setCtwa1Max(this.getMaxValueByTargetId(values, 13));
                vo2.setCtwa1Min(this.getMinValueByTargetId(values, 13));
                vo2.setCtwa1Avg(this.getAvgValueByTargetId(values, 13));
                vo2.setTimes1Max(this.getMaxValueByTargetId(values, 16));
                vo2.setTimes1Min(this.getMinValueByTargetId(values, 16));
                vo2.setTimes1Avg(this.getAvgValueByTargetId(values, 16));
                vo2.setPeakcontactconcentration1Max(this.getMaxValueByTargetId(values, 15));
                vo2.setPeakcontactconcentration1Min(this.getMinValueByTargetId(values, 15));
                vo2.setPeakcontactconcentration1Avg(this.getAvgValueByTargetId(values, 15));
                vo2.setCtwa2Max(this.getMaxValueByTargetId(values, 18));
                vo2.setCtwa2Min(this.getMinValueByTargetId(values, 18));
                vo2.setCtwa2Avg(this.getAvgValueByTargetId(values, 18));
                vo2.setTimes2Max(this.getMaxValueByTargetId(values, 21));
                vo2.setTimes2Min(this.getMinValueByTargetId(values, 21));
                vo2.setTimes2Avg(this.getAvgValueByTargetId(values, 21));
                vo2.setPeakcontactconcentration2Max(this.getMaxValueByTargetId(values, 20));
                vo2.setPeakcontactconcentration2Min(this.getMinValueByTargetId(values, 20));
                vo2.setPeakcontactconcentration2Avg(this.getAvgValueByTargetId(values, 20));
            }
        }
        return list;
    }

    private List<HcCheckNoiseConcentrationVo> getNoiseStat(List<CheckRecordFileVo> resultVos) {
        LinkedList<HcCheckNoiseConcentrationVo> list = new LinkedList<HcCheckNoiseConcentrationVo>();
        resultVos = resultVos.stream().filter(vo -> "567".equals(vo.getFactorId())).collect(Collectors.toList());
        Map<Integer, List<CheckRecordFileVo>> map = this.groupByYear(resultVos);
        for (Map.Entry<Integer, List<CheckRecordFileVo>> entry : map.entrySet()) {
            HcCheckNoiseConcentrationVo nosieVo = new HcCheckNoiseConcentrationVo();
            nosieVo.setYear(entry.getKey());
            nosieVo.setHarmId(Long.valueOf(567L));
            List<CheckRecordFileVo> values = entry.getValue();
            nosieVo.setEquallevelMax(this.getMaxValueByTargetId(values, 29));
            nosieVo.setEquallevelMin(this.getMinValueByTargetId(values, 29));
            nosieVo.setEquallevelAvg(this.getAvgValueByTargetId(values, 29));
            nosieVo.setMaxnoiseMax(this.getMaxValueByTargetId(values, 31));
            nosieVo.setMaxnoiseMin(this.getMinValueByTargetId(values, 31));
            nosieVo.setMaxnoiseAvg(this.getAvgValueByTargetId(values, 31));
            list.add(nosieVo);
        }
        return list;
    }

    private List<HcCheckHighFrequencyConcentrationVo> getHighFrequencyStat(List<CheckRecordFileVo> resultVos) {
        LinkedList<HcCheckHighFrequencyConcentrationVo> list = new LinkedList<HcCheckHighFrequencyConcentrationVo>();
        resultVos = resultVos.stream().filter(vo -> "579".equals(vo.getFactorId())).collect(Collectors.toList());
        Map<Integer, List<CheckRecordFileVo>> map = this.groupByYear(resultVos);
        for (Map.Entry<Integer, List<CheckRecordFileVo>> entry : map.entrySet()) {
            HcCheckHighFrequencyConcentrationVo vo2 = new HcCheckHighFrequencyConcentrationVo();
            vo2.setYear(entry.getKey());
            vo2.setHarmId(Long.valueOf(579L));
            List<CheckRecordFileVo> values = entry.getValue();
            vo2.setEstrongMax(this.getMaxValueByTargetId(values, 67));
            vo2.setEstrongMin(this.getMinValueByTargetId(values, 67));
            vo2.setEstrongAvg(this.getAvgValueByTargetId(values, 67));
            vo2.setMstrongMax(this.getMaxValueByTargetId(values, 68));
            vo2.setMstrongMin(this.getMinValueByTargetId(values, 68));
            vo2.setMstrongAvg(this.getAvgValueByTargetId(values, 68));
            list.add(vo2);
        }
        return list;
    }

    private List<HcCheckIonizingradiationConcentrationVo> getIonizingradiationStat(List<CheckRecordFileVo> resultVos) {
        LinkedList<HcCheckIonizingradiationConcentrationVo> list = new LinkedList<HcCheckIonizingradiationConcentrationVo>();
        resultVos = resultVos.stream().filter(vo -> "704".equals(vo.getFactorId())).collect(Collectors.toList());
        Map<Integer, List<CheckRecordFileVo>> map = this.groupByYear(resultVos);
        for (Map.Entry<Integer, List<CheckRecordFileVo>> entry : map.entrySet()) {
            HcCheckIonizingradiationConcentrationVo vo2 = new HcCheckIonizingradiationConcentrationVo();
            vo2.setYear(entry.getKey());
            vo2.setHarmId(Long.valueOf(704L));
            List<CheckRecordFileVo> values = entry.getValue();
            vo2.setCheckresultMax(this.getMaxValueByTargetId(values, 78));
            vo2.setCheckresultMin(this.getMinValueByTargetId(values, 78));
            vo2.setCheckresultAvg(this.getAvgValueByTargetId(values, 78));
            list.add(vo2);
            vo2 = new HcCheckIonizingradiationConcentrationVo();
            vo2.setYear(entry.getKey());
            vo2.setHarmId(Long.valueOf(704L));
            vo2.setCheckresultMax(this.getMaxValueByTargetId(values, 82));
            vo2.setCheckresultMin(this.getMinValueByTargetId(values, 82));
            vo2.setCheckresultAvg(this.getAvgValueByTargetId(values, 82));
            list.add(vo2);
        }
        return list;
    }

    private List<HcCheckUltrahighfrequencyradiationConcentrationVo> getUltrahighfrequencyradiationStat(List<CheckRecordFileVo> resultVos) {
        LinkedList<HcCheckUltrahighfrequencyradiationConcentrationVo> list = new LinkedList<HcCheckUltrahighfrequencyradiationConcentrationVo>();
        resultVos = resultVos.stream().filter(vo -> "580".equals(vo.getFactorId())).collect(Collectors.toList());
        Map<Integer, List<CheckRecordFileVo>> map = this.groupByYear(resultVos);
        for (Map.Entry<Integer, List<CheckRecordFileVo>> entry : map.entrySet()) {
            HcCheckUltrahighfrequencyradiationConcentrationVo vo2 = new HcCheckUltrahighfrequencyradiationConcentrationVo();
            vo2.setYear(entry.getKey());
            vo2.setHarmId(Long.valueOf(580L));
            List<CheckRecordFileVo> values = entry.getValue();
            vo2.setPowerMax(this.getMaxValueByTargetId(values, 73));
            vo2.setPowerMin(this.getMinValueByTargetId(values, 73));
            vo2.setPowerAvg(this.getAvgValueByTargetId(values, 73));
            vo2.setElectricMax(this.getMaxValueByTargetId(values, 74));
            vo2.setElectricMin(this.getMinValueByTargetId(values, 74));
            vo2.setElectricAvg(this.getAvgValueByTargetId(values, 74));
            list.add(vo2);
        }
        return list;
    }

    private List<HcCheckHandtransmittedConcentrationVo> getHandtransmittedStat(List<CheckRecordFileVo> resultVos) {
        LinkedList<HcCheckHandtransmittedConcentrationVo> list = new LinkedList<HcCheckHandtransmittedConcentrationVo>();
        resultVos = resultVos.stream().filter(vo -> "572".equals(vo.getFactorId())).collect(Collectors.toList());
        Map<Integer, List<CheckRecordFileVo>> map = this.groupByYear(resultVos);
        for (Map.Entry<Integer, List<CheckRecordFileVo>> entry : map.entrySet()) {
            HcCheckHandtransmittedConcentrationVo vo2 = new HcCheckHandtransmittedConcentrationVo();
            vo2.setYear(entry.getKey());
            vo2.setHarmId(Long.valueOf(572L));
            List<CheckRecordFileVo> values = entry.getValue();
            vo2.setSpeedMax(this.getMaxValueByTargetId(values, 86));
            vo2.setSpeedMin(this.getMinValueByTargetId(values, 86));
            vo2.setSpeedAvg(this.getAvgValueByTargetId(values, 86));
            list.add(vo2);
        }
        return list;
    }

    private List<HcCheckCollectMicrowaveradiationConcentrationVo> getMicrowaveradiationStat(List<CheckRecordFileVo> resultVos) {
        LinkedList<HcCheckCollectMicrowaveradiationConcentrationVo> list = new LinkedList<HcCheckCollectMicrowaveradiationConcentrationVo>();
        resultVos = resultVos.stream().filter(vo -> "575".equals(vo.getFactorId())).collect(Collectors.toList());
        Map<Integer, List<CheckRecordFileVo>> map = this.groupByYear(resultVos);
        for (Map.Entry<Integer, List<CheckRecordFileVo>> entry : map.entrySet()) {
            HcCheckCollectMicrowaveradiationConcentrationVo vo2 = new HcCheckCollectMicrowaveradiationConcentrationVo();
            vo2.setYear(entry.getKey());
            vo2.setHarmId(Long.valueOf(575L));
            List<CheckRecordFileVo> values = entry.getValue();
            vo2.setAmountMax(this.getMaxValueByTargetId(values, 60));
            vo2.setAmountMin(this.getMinValueByTargetId(values, 60));
            vo2.setAmountAvg(this.getAvgValueByTargetId(values, 60));
            vo2.setAvgdensityMax(this.getMaxValueByTargetId(values, 61));
            vo2.setAvgdensityMin(this.getMinValueByTargetId(values, 61));
            vo2.setAvgdensityAvg(this.getAvgValueByTargetId(values, 61));
            vo2.setPowerdensityMax(this.getMaxValueByTargetId(values, 62));
            vo2.setPowerdensityMin(this.getMinValueByTargetId(values, 62));
            vo2.setPowerdensityAvg(this.getAvgValueByTargetId(values, 62));
            list.add(vo2);
        }
        return list;
    }

    private List<HcCheckCollectUltravioletlightConcentrationVo> getUltravioletlightStat(List<CheckRecordFileVo> resultVos) {
        LinkedList<HcCheckCollectUltravioletlightConcentrationVo> list = new LinkedList<HcCheckCollectUltravioletlightConcentrationVo>();
        resultVos = resultVos.stream().filter(vo -> "576".equals(vo.getFactorId())).collect(Collectors.toList());
        Map<Integer, List<CheckRecordFileVo>> map = this.groupByYear(resultVos);
        for (Map.Entry<Integer, List<CheckRecordFileVo>> entry : map.entrySet()) {
            HcCheckCollectUltravioletlightConcentrationVo vo2 = new HcCheckCollectUltravioletlightConcentrationVo();
            vo2.setYear(entry.getKey());
            vo2.setHarmId(Long.valueOf(576L));
            List<CheckRecordFileVo> values = entry.getValue();
            vo2.setIrradianceMax(this.getMaxValueByTargetId(values, 41));
            vo2.setIrradianceMin(this.getMinValueByTargetId(values, 41));
            vo2.setIrradianceAvg(this.getAvgValueByTargetId(values, 41));
            vo2.setExposureMax(this.getMaxValueByTargetId(values, 42));
            vo2.setExposureMin(this.getMinValueByTargetId(values, 42));
            vo2.setExposureAvg(this.getAvgValueByTargetId(values, 42));
            list.add(vo2);
        }
        return list;
    }

    private List<HcCheckCollectPowerfrequencyConcentrationVo> getPowerfrequencyStat(List<CheckRecordFileVo> resultVos) {
        LinkedList<HcCheckCollectPowerfrequencyConcentrationVo> list = new LinkedList<HcCheckCollectPowerfrequencyConcentrationVo>();
        resultVos = resultVos.stream().filter(vo -> "578".equals(vo.getFactorId())).collect(Collectors.toList());
        Map<Integer, List<CheckRecordFileVo>> map = this.groupByYear(resultVos);
        for (Map.Entry<Integer, List<CheckRecordFileVo>> entry : map.entrySet()) {
            HcCheckCollectPowerfrequencyConcentrationVo vo2 = new HcCheckCollectPowerfrequencyConcentrationVo();
            vo2.setYear(entry.getKey());
            vo2.setHarmId(Long.valueOf(578L));
            List<CheckRecordFileVo> values = entry.getValue();
            vo2.setPowerMax(this.getMaxValueByTargetId(values, 55));
            vo2.setPowerMin(this.getMinValueByTargetId(values, 55));
            vo2.setPowerAvg(this.getAvgValueByTargetId(values, 55));
            list.add(vo2);
        }
        return list;
    }

    private List<HcCheckHightemperatureConcentrationVo> getHightemperatureStat(List<CheckRecordFileVo> resultVos) {
        LinkedList<HcCheckHightemperatureConcentrationVo> list = new LinkedList<HcCheckHightemperatureConcentrationVo>();
        resultVos = resultVos.stream().filter(vo -> "568".equals(vo.getFactorId())).collect(Collectors.toList());
        Map<Integer, List<CheckRecordFileVo>> map = this.groupByYear(resultVos);
        for (Map.Entry<Integer, List<CheckRecordFileVo>> entry : map.entrySet()) {
            HcCheckHightemperatureConcentrationVo vo2 = new HcCheckHightemperatureConcentrationVo();
            vo2.setYear(entry.getKey());
            vo2.setHarmId(Long.valueOf(568L));
            List<CheckRecordFileVo> values = entry.getValue();
            vo2.setCheckresultMax(this.getMaxValueByTargetId(values, 36));
            vo2.setCheckresultMin(this.getMinValueByTargetId(values, 36));
            vo2.setCheckresultAvg(this.getAvgValueByTargetId(values, 36));
            list.add(vo2);
        }
        return list;
    }

    private List<HcCheckLaserradiationConcentrationVo> getLaserradiationStat(List<CheckRecordFileVo> resultVos) {
        LinkedList<HcCheckLaserradiationConcentrationVo> list = new LinkedList<HcCheckLaserradiationConcentrationVo>();
        resultVos = resultVos.stream().filter(vo -> "573".equals(vo.getFactorId())).collect(Collectors.toList());
        Map<Integer, List<CheckRecordFileVo>> map = this.groupByYear(resultVos);
        for (Map.Entry<Integer, List<CheckRecordFileVo>> entry : map.entrySet()) {
            HcCheckLaserradiationConcentrationVo vo2 = new HcCheckLaserradiationConcentrationVo();
            vo2.setYear(entry.getKey());
            vo2.setHarmId(Long.valueOf(573L));
            List<CheckRecordFileVo> values = entry.getValue();
            vo2.setExposureMax(this.getMaxValueByTargetId(values, 94));
            vo2.setExposureMin(this.getMinValueByTargetId(values, 94));
            vo2.setExposureAvg(this.getAvgValueByTargetId(values, 94));
            vo2.setIrradianceMax(this.getMaxValueByTargetId(values, 95));
            vo2.setIrradianceMin(this.getMinValueByTargetId(values, 95));
            vo2.setIrradianceAvg(this.getAvgValueByTargetId(values, 95));
            list.add(vo2);
        }
        return list;
    }

    private double getLaserradiationValue(String value) {
        if (value == null || value.isEmpty()) {
            return 0.0;
        }
        String[] split = value.split(",");
        if (split.length != 4) {
            return 0.0;
        }
        return Double.parseDouble(split[2]) * Math.pow(10.0, Double.parseDouble(split[3]));
    }

    private double getMaxValueByTargetId(List<CheckRecordFileVo> results, Integer targetId) {
        double max = 0.0;
        for (CheckRecordFileVo result : results) {
            for (CheckRecordFileCheckResultVo resultVo : result.getResultList()) {
                if (!resultVo.getTargetId().equals(targetId)) continue;
                String checkValue = "";
                checkValue = resultVo.getCheckValueType().equals(1) ? resultVo.getCheckValue() : resultVo.getCheckValueMax();
                try {
                    double v = 0.0;
                    v = targetId.equals(94) || targetId.equals(95) ? this.getLaserradiationValue(checkValue) : Double.parseDouble(checkValue);
                    if (!(v > max)) continue;
                    max = v;
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        return max;
    }

    private double getMinValueByTargetId(List<CheckRecordFileVo> results, Integer targetId) {
        double min = 0.0;
        for (CheckRecordFileVo result : results) {
            for (CheckRecordFileCheckResultVo resultVo : result.getResultList()) {
                if (!resultVo.getTargetId().equals(targetId)) continue;
                String checkValue = "";
                checkValue = resultVo.getCheckValueType().equals(1) ? resultVo.getCheckValue() : resultVo.getCheckValueMin();
                try {
                    double v = 0.0;
                    v = targetId.equals(94) || targetId.equals(95) ? this.getLaserradiationValue(checkValue) : Double.parseDouble(checkValue);
                    if (!(v < min) && min != 0.0) continue;
                    min = v;
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        return min;
    }

    private double getAvgValueByTargetId(List<CheckRecordFileVo> results, Integer targetId) {
        ArrayList<Double> values = new ArrayList<Double>();
        for (CheckRecordFileVo result : results) {
            for (CheckRecordFileCheckResultVo resultVo : result.getResultList()) {
                if (!resultVo.getTargetId().equals(targetId)) continue;
                try {
                    if (resultVo.getCheckValueType().equals(1)) {
                        if (targetId.equals(94) || targetId.equals(95)) {
                            values.add(this.getLaserradiationValue(resultVo.getCheckValue()));
                            continue;
                        }
                        values.add(Double.parseDouble(resultVo.getCheckValue()));
                        continue;
                    }
                    values.add(Double.parseDouble(resultVo.getCheckValueMax()));
                    values.add(Double.parseDouble(resultVo.getCheckValueMin()));
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        if (!values.isEmpty()) {
            return (Double)values.stream().reduce((v1, v2) -> v1 + v2).get() / (double)values.size();
        }
        return 0.0;
    }

    private Map<Integer, List<CheckRecordFileVo>> groupByYear(List<CheckRecordFileVo> resultVos) {
        HashMap<Integer, List<CheckRecordFileVo>> map = new HashMap<Integer, List<CheckRecordFileVo>>();
        for (CheckRecordFileVo resultVo : resultVos) {
            Integer year = resultVo.getCheckDate().getYear();
            List list = map.computeIfAbsent(year, k -> new LinkedList());
            list.add(resultVo);
        }
        return map;
    }

    private Map<String, List<CheckRecordFileVo>> groupByFactor(List<CheckRecordFileVo> resultVos) {
        HashMap<String, List<CheckRecordFileVo>> map = new HashMap<String, List<CheckRecordFileVo>>();
        for (CheckRecordFileVo resultVo : resultVos) {
            String factorId = resultVo.getFactorId();
            String factorName = resultVo.getFactorName();
            if (factorId == null || factorId.isEmpty()) continue;
            String key = factorId + "-" + factorName;
            List list = map.computeIfAbsent(key, k -> new LinkedList());
            list.add(resultVo);
        }
        return map;
    }

    public List<HcCheckStatHarmByYearAndWork> getHcCheckStatHarmByYearAndWork(Long cid, Integer beginYear, Integer endYear, List<Long> workIds) {
        LinkedList<HcCheckStatHarmByYearAndWork> list = new LinkedList<HcCheckStatHarmByYearAndWork>();
        List all = this.workSourceService.getAllWorkHarmFactorVos(cid);
        List resultVos = this.checkResultParseService.queryCheckRecordFileVos(this.checkResultParseQueryModel(cid, beginYear, endYear));
        this.filterCheck(all, resultVos);
        this.filterByWorkId(all, workIds.toArray(new Long[workIds.size()]));
        List<HcCheckHarmMapByWorkAndYear> workList = this.groupByWorkId(all, resultVos);
        for (HcCheckHarmMapByWorkAndYear work : workList) {
            HcCheckStatHarmByYearAndWork harmWork = new HcCheckStatHarmByYearAndWork();
            list.add(harmWork);
            harmWork.setWorkId(work.getWorkId());
            harmWork.setWorkName(work.getWorkName());
            List<HcCheckYearCount> subList = this.checkHarmGroupByYear(work);
            harmWork.setList(subList);
        }
        return list;
    }

    private List<HcCheckYearCount> checkHarmGroupByYear(HcCheckHarmMapByWorkAndYear work) {
        LinkedList<HcCheckYearCount> list = new LinkedList<HcCheckYearCount>();
        List harmList = work.getList();
        HashMap<Integer, Set> map = new HashMap<Integer, Set>();
        for (HcCheckHarm hcCheckHarm : harmList) {
            Set harmIds = map.computeIfAbsent(hcCheckHarm.getYear(), k -> new HashSet());
            if (!hcCheckHarm.getIsOverproof().booleanValue()) continue;
            harmIds.add(hcCheckHarm.getHarmId());
        }
        for (Map.Entry entry : map.entrySet()) {
            HcCheckYearCount count = new HcCheckYearCount();
            count.setYear((Integer)entry.getKey());
            count.setCount(Integer.valueOf(((Set)entry.getValue()).size()));
            list.add(count);
        }
        return list;
    }
}

