/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.work.shield;

import cn.smarthse.modules.health.entity.work.shield.L09PpeLifetime;
import cn.smarthse.modules.health.entity.work.shield.L09PpeLifetimePpe;
import cn.smarthse.modules.health.entity.work.shield.L09WorkType;
import cn.smarthse.modules.health.service.work.shield.IShieldUseRuleService;
import cn.smarthse.web.controller.ControllerSupport;
import jakarta.servlet.http.HttpSession;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/work/shield/shieldUseRoles"})
public class ShieldUseRuleController
extends ControllerSupport {
    @DubboReference
    IShieldUseRuleService ruleService;

    @RequiresPermissions(value={"shield.view"})
    @RequestMapping
    public String index(L09WorkType workType, HttpSession session, ModelMap m, Integer eid) {
        List workTypes = this.ruleService.listAllWorkType();
        m.put((Object)"workTypes", (Object)workTypes);
        if (workType.getId() != null) {
            workType = this.ruleService.getWorkTypeById(workType.getId());
            List selection = this.ruleService.getSelection(workType);
            List lifetime = this.ruleService.getLifetime(workType);
            this.setPpes(lifetime, m);
            m.put((Object)"selection", (Object)selection);
            m.put((Object)"lifetime", (Object)lifetime);
        }
        m.put((Object)"eid", (Object)eid);
        m.put((Object)"workType", (Object)workType);
        return "work/shield/equipWorkRole/shieldUseRule";
    }

    private void setPpes(List<L09PpeLifetime> lifetime, ModelMap m) {
        HashSet<String> workers = new HashSet<String>();
        TreeMap shieldTypes = new TreeMap();
        HashMap<CallSite, L09PpeLifetime> ppeLifeTimes = new HashMap<CallSite, L09PpeLifetime>();
        for (L09PpeLifetime lt : lifetime) {
            L09PpeLifetimePpe ppe;
            workers.add(lt.getTypicalWorker());
            ppeLifeTimes.put((CallSite)((Object)(lt.getTypicalWorker() + "_" + lt.getPpeType() + "_" + lt.getPpeCode())), lt);
            TreeMap<String, L09PpeLifetimePpe> shieldTypePpe = (TreeMap<String, L09PpeLifetimePpe>)shieldTypes.get(lt.getPpeType());
            if (shieldTypePpe == null) {
                shieldTypePpe = new TreeMap<String, L09PpeLifetimePpe>();
            }
            if ((ppe = (L09PpeLifetimePpe)shieldTypePpe.get(lt.getPpeCode())) == null) {
                ppe = new L09PpeLifetimePpe();
                ppe.setPpe(lt.getPpe());
                ppe.setPpeCode(lt.getPpeCode());
                ppe.setPpeType(lt.getPpeType());
                ppe.setWorkTypeLifeTime(new HashMap());
            }
            ppe.getWorkTypeLifeTime().put(lt.getTypicalWorker() + "_" + lt.getPpeType() + "_" + lt.getPpeCode(), lt);
            shieldTypePpe.put(lt.getPpeCode(), ppe);
            shieldTypes.put(lt.getPpeType(), shieldTypePpe);
        }
        m.put((Object)"workers", workers);
        m.put((Object)"shieldTypes", shieldTypes);
        m.put((Object)"ppeLifeTimes", ppeLifeTimes);
    }

    private Map<String, Map<String, List<L09PpeLifetime>>> setLifeTime(List<L09PpeLifetime> lifetime) {
        HashMap<String, Map<String, List<L09PpeLifetime>>> workers = new HashMap<String, Map<String, List<L09PpeLifetime>>>();
        for (L09PpeLifetime lt : lifetime) {
            HashMap shields = workers.get(lt.getTypicalWorker()) == null ? new HashMap() : (Map)workers.get(lt.getTypicalWorker());
            ArrayList<L09PpeLifetime> shield = shields.get(lt.getPpeType()) == null ? new ArrayList<L09PpeLifetime>() : (List)shields.get(lt.getPpeType());
            shield.add(lt);
            shields.put(lt.getPpeType(), shield);
            workers.put(lt.getTypicalWorker(), shields);
        }
        return workers;
    }

    @ResponseBody
    @RequestMapping(value={"test"})
    public Map<String, Map<String, List<L09PpeLifetime>>> test(L09WorkType workType, HttpSession session, ModelMap m) {
        workType = this.ruleService.getWorkTypeById(workType.getId());
        List lifetime = this.ruleService.getLifetime(workType);
        Map<String, Map<String, List<L09PpeLifetime>>> workers = this.setLifeTime(lifetime);
        return workers;
    }
}

