/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.work.shield;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.util.BeanMapUtil;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.excel.ExcelUtil;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.health.entity.base.company.CompanyOrganization;
import cn.smarthse.modules.health.entity.base.staff.StaffBasicInfo;
import cn.smarthse.modules.health.entity.base.staff.StaffBasicWork;
import cn.smarthse.modules.health.entity.work.shield.ShieldEquipRuleDetail;
import cn.smarthse.modules.health.entity.work.shield.ShieldSendRecord;
import cn.smarthse.modules.health.entity.work.shield.ShieldSendRecordDetail;
import cn.smarthse.modules.health.enums.shield.ShieldCountUnitEnum;
import cn.smarthse.modules.health.service.base.company.ICompanyOrganizationService;
import cn.smarthse.modules.health.service.base.staff.IStaffBasicInfoService;
import cn.smarthse.modules.health.service.base.staff.IStaffBasicWorkService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.work.shield.IShieldEquipRuleDetailService;
import cn.smarthse.modules.health.service.work.shield.IShieldSendRecordService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.AppConfigHolder;
import cn.smarthse.web.util.ExportExcelUtils;
import cn.smarthse.web.util.SysFileUtil;
import cn.smarthse.web.util.UserUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.beans.IntrospectionException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/work/shield/send/record"})
public class ShieldSendRecordController
extends ControllerSupport {
    @DubboReference
    IShieldSendRecordService shieldSendRecordService;
    @DubboReference
    IShieldEquipRuleDetailService shieldEquipRuleDetailService;
    @DubboReference
    private IStaffInfoService staffInfoService;
    @DubboReference
    private IStaffBasicInfoService staffBasicInfoService;
    @DubboReference
    private IStaffBasicWorkService staffBasicWorkService;
    @DubboReference
    private ICompanyOrganizationService organizationServcie;
    @Autowired
    private ThreadPoolExecutor executor;

    @RequestMapping(value={"/view/{id}"}, method={RequestMethod.GET})
    @RequiresPermissions(value={"shield.edit"})
    public String view(@PathVariable Long id, HttpSession session, ModelMap m) {
        ShieldSendRecord data = null;
        data = id != null ? this.shieldSendRecordService.getDetailById(id) : new ShieldSendRecord();
        m.put((Object)"data", (Object)data);
        m.put((Object)"countUnitEnums", (Object)ShieldCountUnitEnum.values());
        return "work/shield/shieldSend/record/send_record_info";
    }

    @RequestMapping(value={"/info"}, method={RequestMethod.GET})
    @RequiresPermissions(value={"shield.edit"})
    public String info(ShieldSendRecord data, Byte requireType, HttpSession session, ModelMap m) {
        if (data.getId() != null) {
            data = this.shieldSendRecordService.getDetailById(data.getId());
        }
        m.put((Object)"data", (Object)data);
        m.put((Object)"requireType", (Object)requireType);
        m.put((Object)"countUnitEnums", (Object)ShieldCountUnitEnum.values());
        return "work/shield/shieldSend/record/send_record_edit";
    }

    @ResponseBody
    @RequestMapping(value={"/info"}, method={RequestMethod.POST})
    @RequiresPermissions(value={"shield.edit"})
    public ResponseData<ShieldSendRecord> infoPost(HttpSession session, ShieldSendRecord record, String requirerIds) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffId = UserUtils.getLoginStaffId();
        boolean isSelfFetch = true;
        List details = record.getDetails();
        if (details != null) {
            for (ShieldSendRecordDetail detail : details) {
                detail.setIsFetch(Boolean.valueOf(false));
            }
        }
        if (requirerIds != null && requirerIds.length() > 0) {
            String[] requireIdArr;
            for (String requireId : requireIdArr = requirerIds.split(",")) {
                record.setRequirerId(Long.valueOf(Long.parseLong(requireId)));
                if (isSelfFetch) {
                    record.setFetcher(record.getRequirerId());
                }
                this.shieldSendRecordService.insertOrUpdate(record, staffId, cid);
            }
        } else {
            if (isSelfFetch) {
                record.setFetcher(record.getRequirerId());
            }
            this.shieldSendRecordService.insertOrUpdate(record, staffId, cid);
        }
        ResponseData data = new ResponseData();
        data.setResult((Object)record);
        data.setContent("\u64cd\u4f5c\u6210\u529f");
        return data;
    }

    @RequiresPermissions(value={"shield.edit"})
    @RequestMapping(value={"/clone/{id}"}, method={RequestMethod.GET})
    public String clone(@PathVariable Long id, HttpSession session, ModelMap m) {
        ShieldSendRecord record = this.shieldSendRecordService.getDetailById(id);
        this.clearCloneInfo(record);
        m.put((Object)"data", (Object)record);
        m.put((Object)"countUnitEnums", (Object)ShieldCountUnitEnum.values());
        return "work/shield/shieldSend/record/send_record_edit";
    }

    private void clearCloneInfo(ShieldSendRecord record) {
        record.setId(null);
        record.setRequirerId(null);
        record.setRequireDeptId(null);
    }

    @ResponseBody
    @RequestMapping(value={"/del/{id}"}, method={RequestMethod.DELETE})
    @RequiresPermissions(value={"shield.edit"})
    public ResponseData<Long> ajax_delete(@PathVariable Long id, HttpSession session) {
        this.shieldSendRecordService.deleteById(id);
        ResponseData data = new ResponseData();
        data.setResult((Object)id);
        data.setContent("\u5220\u9664\u6210\u529f");
        return data;
    }

    @RequestMapping(value={"/downloadImportTemplate"}, method={RequestMethod.GET})
    public void downloadImportTemplate(HttpServletResponse response, HttpServletRequest request) throws Exception {
        ShieldEquipRuleDetail param = new ShieldEquipRuleDetail();
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        List list = this.shieldEquipRuleDetailService.getDetailTable(param);
        String templateDirPath = super.getTemplateFilePath();
        String tempDirPath = super.getTempFilePath();
        String resultFileName = "\u9632\u62a4\u7528\u54c1\u53d1\u653e\u5bfc\u5165\u6a21\u677f.xls";
        String template = "shield/shieldSendRecordDetailTemplate_3_1_1.xls";
        String actualizeCompanyName = AppConfigHolder.getConfig("actualizeCompanyName");
        if ("\u534e\u4e1c\u533b\u836f".equals(actualizeCompanyName)) {
            template = "shield/24-014-shieldSendRecordDetailTemplateHuaDong.xls";
        }
        String templateFileName = templateDirPath + template;
        String resultFilePath = tempDirPath + resultFileName;
        Map<String, Object> datas = this.getDatas(list);
        ExportExcelUtils.downloadByTemplate(resultFileName, templateFileName, datas, response, request);
    }

    @ResponseBody
    @RequestMapping(value={"/import"}, method={RequestMethod.POST})
    @RequiresPermissions(value={"shield.edit"})
    public ResponseData<Object> importArea(Long sendId, String ossUrl, Long fileId, HttpServletRequest request) throws Exception {
        ResponseData data = new ResponseData();
        data.setState(ResponseStateEnum.fail);
        if (StringUtils.isEmpty((CharSequence)ossUrl)) {
            data.setContent("\u4e0a\u4f20\u540e\u7684\u6587\u4ef6\u8def\u5f84\u4e22\u5931");
            return data;
        }
        ossUrl = this.ossClientBean.getUrl(ossUrl);
        return this.importDetail(sendId, fileId, ossUrl, request);
    }

    private ResponseData<Object> importDetail(Long sendId, Long fileId, String ossUrl, HttpServletRequest request) throws Exception {
        ResponseData data = new ResponseData();
        data.setContent("success");
        data.setState(ResponseStateEnum.success);
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long userId = UserUtils.getLoginStaffId();
        ShieldEquipRuleDetail param = new ShieldEquipRuleDetail();
        param.setCid(cid);
        Date now = new Date();
        Future<List> StaffInfoFuture = this.executor.submit(() -> this.staffInfoService.getAllByCid(cid));
        Future<List> staffBasicInfosFuture = this.executor.submit(() -> this.staffBasicInfoService.getAllByCid(cid));
        Future<List> orgListFuture = this.executor.submit(() -> this.organizationServcie.getListByCid(cid));
        Future<List> shieldListFuture = this.executor.submit(() -> this.shieldEquipRuleDetailService.getDetailTable(param));
        Future<List> staffWorkListFuture = this.executor.submit(() -> this.staffBasicWorkService.getAllByCid(cid));
        List staffList = StaffInfoFuture.get();
        List staffBasicInfos = staffBasicInfosFuture.get();
        List orgList = orgListFuture.get();
        List shieldList = shieldListFuture.get();
        List staffWorkList = staffWorkListFuture.get();
        HashMap<Long, Long> basicIdToStaffIdMap = new HashMap<Long, Long>();
        for (Object staffInfo : staffList) {
            if (staffInfo.getStaffBasicId() == null) continue;
            basicIdToStaffIdMap.put(staffInfo.getStaffBasicId(), staffInfo.getId());
        }
        HashMap<Long, String> staffIdToWorNumMap = new HashMap<Long, String>();
        for (StaffBasicWork staffBasicWork : staffWorkList) {
            if (staffBasicWork.getStaffId() == null || staffBasicWork.getWorkNo() == null) continue;
            staffIdToWorNumMap.put(staffBasicWork.getStaffId(), staffBasicWork.getWorkNo());
        }
        ArrayList<Integer> cellValidNumList = new ArrayList<Integer>();
        cellValidNumList.add(0);
        ArrayList<Integer> colValidNumList = new ArrayList<Integer>();
        colValidNumList.add(2);
        Map contentMap = null;
        SysFileModel file = SysFileUtil.getFileById(fileId);
        contentMap = ExcelUtil.getInstance().getContentFromUrl(ossUrl, cellValidNumList, colValidNumList);
        Iterator iterator = contentMap.entrySet().iterator();
        ArrayList<ShieldSendRecord> records = new ArrayList<ShieldSendRecord>();
        StringBuilder sb = new StringBuilder();
        while (iterator.hasNext()) {
            ArrayList list = (ArrayList)iterator.next().getValue();
            for (int i = 0; i < list.size(); ++i) {
                String lineMsg = "\u7b2c" + (i + 2) + "\u884c: ";
                ArrayList l = (ArrayList)list.get(i);
                String requireName = (String)l.get(0);
                if (requireName == null || requireName.length() == 0) {
                    sb.append(lineMsg + "\u53d1\u653e\u5bf9\u8c61 \u5177\u4f53\u540d\u79f0 \u4e0d\u80fd\u4e3a\u7a7a<br/>");
                }
                requireName = StringUtils.toDBC((String)requireName);
                String[] requireNames = new String[]{requireName};
                if (requireName.contains(";")) {
                    requireNames = requireName.split(";");
                }
                for (String name : requireNames) {
                    Long shieldId;
                    ShieldSendRecord record = new ShieldSendRecord();
                    records.add(record);
                    record.setCid(cid);
                    record.setCreateBy(userId);
                    record.setFetchTime(now);
                    record.setCreateDate(now);
                    record.setUpdateBy(userId);
                    record.setUpdateDate(now);
                    record.setIsValid(Boolean.valueOf(true));
                    record.setSendId(sendId);
                    Long requiredUserId = this.queryUserId(staffBasicInfos, name, staffIdToWorNumMap, basicIdToStaffIdMap);
                    if (requiredUserId == null && !StringUtils.isEmpty((CharSequence)name)) {
                        sb.append(lineMsg + "\u627e\u4e0d\u5230\u8be5\u53d1\u653e\u5bf9\u8c61\uff1a" + name + ",\u8bf7\u786e\u8ba4\u586b\u5199\u5185\u5bb9\u548c\u683c\u5f0f\u6b63\u786e<br/>");
                    }
                    record.setRequireType(Byte.valueOf((byte)1));
                    record.setRequirerId(requiredUserId);
                    record.setFetcher(requiredUserId);
                    if (l.size() > 7) {
                        String remark = (String)l.get(7);
                        record.setRemark(remark);
                    }
                    ArrayList<ShieldSendRecordDetail> details = new ArrayList<ShieldSendRecordDetail>();
                    record.setDetails(details);
                    ShieldSendRecordDetail detail = new ShieldSendRecordDetail();
                    details.add(detail);
                    String shieldName = (String)l.get(1);
                    if (shieldName == null || shieldName.length() == 0) {
                        sb.append(lineMsg + "\u9632\u62a4\u7528\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a<br/>");
                    }
                    String proLevel = (String)l.get(2);
                    String desc = (String)l.get(3);
                    detail.setShieldName(desc);
                    String model = (String)l.get(4);
                    detail.setModel(model);
                    String num = (String)l.get(5);
                    try {
                        detail.setFetchAmount(Integer.valueOf(Integer.parseInt(num)));
                    }
                    catch (Exception e) {
                        if (num == null || num.length() == 0) {
                            sb.append(lineMsg + "\u9886\u53d6\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a<br/>");
                        }
                        sb.append(lineMsg + "\u8bf7\u6309\u8bf4\u660e\u586b\u5199\u6570\u91cf<br/>");
                    }
                    String unit = null;
                    if (l.size() >= 7) {
                        unit = (String)l.get(6);
                    }
                    if (unit == null || unit.length() == 0) {
                        sb.append(lineMsg + "\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a<br/>");
                    }
                    if ((shieldId = this.queryShieldId(shieldList, shieldName, proLevel, unit)) == null && !StringUtils.isEmpty((CharSequence)shieldName)) {
                        sb.append(lineMsg + "\u627e\u4e0d\u5230\u8be5\u9632\u62a4\u7528\u54c1:" + shieldName + ",\u8bf7\u68c0\u67e5\u540d\u79f0\u3001\u4fdd\u62a4\u7b49\u7ea7\u548c\u5355\u4f4d<br/>");
                    }
                    detail.setShieldId(shieldId);
                    detail.setUnit(ShieldCountUnitEnum.getCodeByName((String)unit));
                    detail.setCreateBy(userId);
                    detail.setUpdateBy(userId);
                    detail.setUpdateDate(now);
                    detail.setCreateDate(now);
                    detail.setIsValid(Boolean.valueOf(true));
                }
                if (sb.length() <= 0) continue;
                data.setState(ResponseStateEnum.fail);
            }
        }
        if (data.getState().equals(ResponseStateEnum.fail)) {
            data.setContent(sb.toString());
            return data;
        }
        for (ShieldSendRecord record : records) {
            this.shieldSendRecordService.insertOrUpdate(record, userId, cid);
        }
        return data;
    }

    private Map<String, Object> getDatas(List<ShieldEquipRuleDetail> list) throws IllegalAccessException, IntrospectionException, InvocationTargetException {
        HashMap<String, Object> paramDto = new HashMap<String, Object>();
        ArrayList<Map> result = new ArrayList<Map>();
        if (list == null || list.isEmpty()) {
            paramDto.put("infos", result);
            return paramDto;
        }
        for (ShieldEquipRuleDetail shield : list) {
            Map itemMap = BeanMapUtil.bean2Map((Object)shield);
            if (shield.getCountUnitName() == null || shield.getCountUnitName().length() == 0) {
                itemMap.put("countUnitName", "\u4e2a");
            }
            result.add(itemMap);
        }
        paramDto.put("infos", result);
        return paramDto;
    }

    private Long queryUserId(List<StaffBasicInfo> staffBasicInfos, String name, Map<Long, String> staffIdToWorNumMap, Map<Long, Long> basicIdToStaffIdMap) {
        String[] strings = name.split("/");
        if (strings.length != 2) {
            return null;
        }
        String realName = strings[0];
        String no = strings[1];
        if (realName == null || realName.length() == 0 || no == null || no.length() == 0) {
            return null;
        }
        String targetName = null;
        String targetIdCard = null;
        String targetWorkNo = null;
        for (StaffBasicInfo staffBasicInfo : staffBasicInfos) {
            targetName = staffBasicInfo.getRealName();
            if (targetName == null || !targetName.equals(realName)) continue;
            targetIdCard = staffBasicInfo.getIdCard();
            if (no.equals(targetIdCard)) {
                return basicIdToStaffIdMap.get(staffBasicInfo.getId());
            }
            Long staffId = basicIdToStaffIdMap.get(staffBasicInfo.getId());
            if (staffId == null || (targetWorkNo = staffIdToWorNumMap.get(staffId)) == null || !targetWorkNo.equals(no)) continue;
            return staffId;
        }
        return null;
    }

    private Long queryRequiredDeptId(List<CompanyOrganization> organizations, String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        for (CompanyOrganization organization : organizations) {
            if (!name.equals(organization.getOrganizationName())) continue;
            return organization.getId();
        }
        return null;
    }

    private Long queryShieldId(List<ShieldEquipRuleDetail> shieldList, String detailName, String proLevel, String unit) {
        if (detailName == null || detailName.length() == 0) {
            return null;
        }
        for (ShieldEquipRuleDetail shield : shieldList) {
            if (!detailName.equals(shield.getDetailName())) continue;
            String countUnitName = shield.getCountUnitName();
            if (countUnitName != null && countUnitName.length() > 0) {
                if (!countUnitName.equals(unit)) continue;
                if (shield.getProLevel() != null && shield.getProLevel().equals(proLevel)) {
                    return shield.getId();
                }
                if (shield.getProLevel() != null && shield.getProLevel().length() != 0 || proLevel != null && proLevel.length() != 0) continue;
                return shield.getId();
            }
            if (unit != null && unit.length() != 0) continue;
            if (shield.getProLevel() != null && shield.getProLevel().equals(proLevel)) {
                return shield.getId();
            }
            if (shield.getProLevel() != null && shield.getProLevel().length() != 0 || proLevel != null && proLevel.length() != 0) continue;
            return shield.getId();
        }
        return null;
    }
}

