/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.work.shield;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.excel.ExportExcel;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.entity.work.shield.ShieldSendExpireLog;
import cn.smarthse.modules.health.entity.work.shield.vo.ShieldSendExpireLogParam;
import cn.smarthse.modules.health.service.base.IBusinessNoService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.work.shield.IShieldSendExpireService;
import cn.smarthse.modules.health.vo.work.shield.ShieldExpireUserVo;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/work/shield/sendExpire"})
public class ShieldSendExpireController
extends ControllerSupport {
    @DubboReference
    IShieldSendExpireService shieldSendExpireService;
    @DubboReference
    private IBusinessNoService businessNoService;
    @DubboReference
    IStaffInfoService staffInfoService;

    @RequiresPermissions(value={"shield.view"})
    @RequestMapping(value={"/index"})
    public String page_index() {
        return "work/shield/shieldSend/expire/user_list";
    }

    @RequiresPermissions(value={"shield.view"})
    @ResponseBody
    @RequestMapping(value={"/userListData"})
    public PageInfo<ShieldExpireUserVo> listData(HttpSession session, JqGridParam gparam, String nameWorkNo, Long orgId, Long workId) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        if (StringUtils.isEmpty((CharSequence)nameWorkNo)) {
            nameWorkNo = null;
        }
        PageInfo pageInfo = this.shieldSendExpireService.getUserList(gparam, nameWorkNo, orgId, workId, cid);
        return pageInfo;
    }

    @RequiresPermissions(value={"shield.view"})
    @ResponseBody
    @RequestMapping(value={"/ignore"})
    public ResponseData<Object> ignore(Long requirerId, String shieldIds) {
        String[] ids = shieldIds.split(",");
        if (ids.length > 0) {
            Long[] longIds = new Long[ids.length];
            for (int i = 0; i < ids.length; ++i) {
                longIds[i] = Long.parseLong(ids[i]);
            }
            this.shieldSendExpireService.ignore(requirerId, longIds);
        } else {
            this.logger.info("shieldIds\u4e3a\u7a7a");
        }
        ResponseData data = new ResponseData();
        data.setResult(null);
        data.setContent("success");
        data.setState(ResponseStateEnum.success);
        return data;
    }

    @RequiresPermissions(value={"shield.view"})
    @RequestMapping(value={"/userShieldDetail"})
    public String userShieldDetail(Model model, String shieldIds) {
        String[] ids = shieldIds.split(",");
        if (ids.length > 0) {
            Long[] longIds = new Long[ids.length];
            for (int i = 0; i < ids.length; ++i) {
                longIds[i] = Long.parseLong(ids[i]);
            }
            List shieldDetails = this.shieldSendExpireService.getShieldDetail(longIds);
            model.addAttribute("shieldDetails", (Object)JSONObject.toJSONString((Object)shieldDetails));
        } else {
            this.logger.info("shieldIds\u4e3a\u7a7a");
        }
        return "work/shield/shieldSend/expire/detail";
    }

    @RequiresPermissions(value={"shield.view"})
    @RequestMapping(value={"/count"})
    public String count() {
        return "work/shield/shieldSend/expire/count_list";
    }

    @RequiresPermissions(value={"shield.view"})
    @ResponseBody
    @RequestMapping(value={"/countListData"})
    public JqGridData<ShieldSendExpireLog> countListData(JqGridParam gparam, ShieldSendExpireLogParam param) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        PageInfo pageInfo = this.shieldSendExpireService.getPage(gparam, param);
        JqGridData data = new JqGridData(pageInfo, gparam);
        return data;
    }

    @RequiresPermissions(value={"shield.view"})
    @RequestMapping(value={"countExport"})
    public void export(ShieldSendExpireLogParam param, HttpSession session, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String fileName = "\u672a\u53ca\u65f6\u9886\u53d6\u9632\u62a4\u7528\u54c1\u7edf\u8ba1\u6e05\u5355" + dateFormat.format(new Date()) + ".xls";
        response.setHeader("Content-Disposition", "attachment;filename=" + new String(fileName.getBytes("GBK"), "ISO8859_1"));
        response.setContentType("application/octet-stream; charset=GBK");
        String[] colums = new String[]{"\u90e8\u95e8/\u8f66\u95f4|organizationName", "\u5c97\u4f4d/\u5de5\u79cd|workName", "\u672a\u9886\u53d6\u9632\u62a4\u7528\u54c1|shieldDetailName", "\u529f\u80fd|func", "\u8bf4\u660e|shieldDesc", "\u53d1\u653e\u5468\u671f|shieldCycle", "\u59d3\u540d|requirerName", "\u5de5\u53f7|workNo", "\u4e0a\u6b21\u9886\u7528\u65f6\u95f4|lastSendTime", "\u5b9e\u9645\u9886\u7528\u65f6\u95f4|realSendTime"};
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        List list = this.shieldSendExpireService.getExportList(param);
        ExportExcel export = new ExportExcel();
        export.simpleExport3("\u672a\u53ca\u65f6\u9886\u53d6\u9632\u62a4\u7528\u54c1\u4eba\u5458\u6e05\u5355", colums, list, (OutputStream)response.getOutputStream());
    }
}

