/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.work.shield;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.BusinessNoTypeEnum;
import cn.smarthse.common.framework.excel.ExportExcel;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.entity.work.shield.ShieldSend;
import cn.smarthse.modules.health.entity.work.shield.ShieldSendFile;
import cn.smarthse.modules.health.entity.work.shield.ShieldSendRecord;
import cn.smarthse.modules.health.entity.work.shield.ShieldSendRecordDetail;
import cn.smarthse.modules.health.service.base.IBusinessNoService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.work.shield.IShieldEquipRuleDetailService;
import cn.smarthse.modules.health.service.work.shield.IShieldSendExpireService;
import cn.smarthse.modules.health.service.work.shield.IShieldSendService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/work/shield/send"})
public class ShieldSendController
extends ControllerSupport {
    @DubboReference
    IShieldSendService shieldSendService;
    @DubboReference
    private IBusinessNoService businessNoService;
    @DubboReference
    IStaffInfoService staffInfoService;
    @DubboReference
    private IShieldSendExpireService shieldSendExpireService;
    @DubboReference
    IShieldEquipRuleDetailService shieldEquipRuleDetailService;

    @RequiresPermissions(value={"shield.view"})
    @RequestMapping(value={"unfinish"})
    public String page_index(HttpSession session, ModelMap m, ShieldSend data) {
        this.logger.info("\u3010\u3011-\u6c47\u603b\u9996\u9875");
        data.setStatus(Byte.valueOf((byte)0));
        m.put((Object)"data", (Object)data);
        return "work/shield/shieldSend/send_list";
    }

    @RequiresPermissions(value={"shield.view"})
    @ResponseBody
    @RequestMapping(value={"listData"})
    public JqGridData<ShieldSend> listData(HttpSession session, JqGridParam gparam, ShieldSend param) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        UserUtils.startWebDataScope();
        PageInfo list = this.shieldSendService.getList(gparam, param);
        JqGridData data = new JqGridData(list, gparam);
        return data;
    }

    private void getOthersFlag(ModelMap m) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Integer staffs = this.staffInfoService.getStaffCountByCid(cid, null);
        m.put((Object)"staffs", (Object)staffs);
        m.put((Object)"tipName", (Object)"\u9632\u62a4\u7528\u54c1\u53d1\u653e\u4fe1\u606f\u767b\u8bb0");
    }

    @RequiresPermissions(value={"shield.view"})
    @RequestMapping(value={"/view/{id}"}, method={RequestMethod.GET})
    public String info(@PathVariable Long id, String fromPage, HttpSession session, ModelMap m) {
        ShieldSend data = null;
        data = id != null ? this.shieldSendService.getDetailById(id) : new ShieldSend();
        this.getOthersFlag(m);
        m.put((Object)"data", (Object)data);
        m.put((Object)"fromPage", (Object)fromPage);
        return "work/shield/shieldSend/send_info";
    }

    @RequiresPermissions(value={"shield.edit"})
    @RequestMapping(value={"/add"}, method={RequestMethod.GET})
    public String add(ShieldSend data, HttpSession session, ModelMap m) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        data.setSendNo(this.businessNoService.getBusinessNo(cid, BusinessNoTypeEnum.SHIELDFETCH.getCode()));
        data.setWorkName("\u9632\u62a4\u7528\u54c1\u53d1\u653e");
        data.setSendTime(new Date());
        m.put((Object)"fromPage", (Object)"new");
        this.getOthersFlag(m);
        m.put((Object)"data", (Object)data);
        return "work/shield/shieldSend/send_edit";
    }

    @RequiresPermissions(value={"shield.edit"})
    @RequestMapping(value={"/addSimple"}, method={RequestMethod.GET})
    public String addSimple(Long id, HttpSession session, ModelMap m) {
        ShieldSend data = null;
        Long cid = UserUtils.getLoginStaffCompanyId();
        if (id != null) {
            data = this.shieldSendService.getDetailById(id);
        }
        m.put((Object)"data", data);
        if ("true".equals(this.isActualize)) {
            this.getOthersFlag(m);
            return "work/shield/shieldSend/send_edit";
        }
        return "work/shield/shieldSend/send_addSimple";
    }

    @RequiresPermissions(value={"shield.edit"})
    @RequestMapping(value={"/edit/{id}"}, method={RequestMethod.GET})
    public String edit(@PathVariable Long id, String fromPage, HttpSession session, ModelMap m) {
        ShieldSend data = null;
        data = id != null ? this.shieldSendService.getDetailById(id) : new ShieldSend();
        this.getOthersFlag(m);
        m.put((Object)"data", (Object)data);
        m.put((Object)"fromPage", (Object)fromPage);
        return "work/shield/shieldSend/send_edit";
    }

    @RequiresPermissions(value={"shield.edit"})
    @RequestMapping(value={"/clone/{id}"}, method={RequestMethod.GET})
    public String clone(@PathVariable Long id, String fromPage, HttpSession session, ModelMap m) {
        ShieldSend data = null;
        if (id != null) {
            Long staffId = UserUtils.getLoginStaffId();
            Long cid = UserUtils.getLoginStaffCompanyId();
            data = this.shieldSendService.clone(id, staffId, cid);
        } else {
            data = new ShieldSend();
        }
        this.getOthersFlag(m);
        m.put((Object)"data", (Object)data);
        m.put((Object)"fromPage", (Object)fromPage);
        return "work/shield/shieldSend/send_edit";
    }

    @RequiresPermissions(value={"shield.edit"})
    @ResponseBody
    @RequestMapping(value={"/info"}, method={RequestMethod.POST})
    public ResponseData<ShieldSend> infoPost(HttpSession session, HttpServletRequest request, ShieldSend send) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffId = UserUtils.getLoginStaffId();
        String[] fileIds = request.getParameterValues("files1Ids");
        send.setFiles1(this.convertFileIds(fileIds));
        if (send.getId() == null && StringUtils.isEmpty((CharSequence)send.getOrgId())) {
            send.setOrgId("" + UserUtils.getOrgId());
        }
        if ((send = this.shieldSendService.insertOrUpdate(send, cid, staffId)).getStatus() != null && send.getStatus().equals((byte)1)) {
            this.shieldSendExpireService.removeIgnore(send.getId());
            this.shieldSendExpireService.addLogs();
        }
        ResponseData data = new ResponseData();
        data.setResult((Object)send);
        data.setContent("\u64cd\u4f5c\u6210\u529f");
        return data;
    }

    private List<ShieldSendFile> convertFileIds(String[] fileIds) {
        ArrayList<ShieldSendFile> files = new ArrayList<ShieldSendFile>();
        if (fileIds == null || fileIds.length == 0) {
            return files;
        }
        for (String fileId : fileIds) {
            ShieldSendFile sendFile = new ShieldSendFile();
            sendFile.setFileId(Long.valueOf(Long.parseLong(fileId)));
            files.add(sendFile);
        }
        return files;
    }

    @RequiresPermissions(value={"shield.edit"})
    @ResponseBody
    @RequestMapping(value={"/del/{ids}"}, method={RequestMethod.DELETE})
    public ResponseData<String> ajax_delete(@PathVariable String ids, HttpSession session) {
        this.logger.info("ajax-\u3010\u3011-\u5220\u9664\u8bb0\u5f55:" + ids);
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffId = UserUtils.getLoginStaffId();
        this.shieldSendService.deleteByIds(ids, staffId, cid);
        ResponseData data = new ResponseData();
        data.setResult((Object)ids);
        data.setContent("\u5220\u9664\u6210\u529f");
        return data;
    }

    @RequiresPermissions(value={"shield.view"})
    @RequestMapping(value={"exportList"})
    public void export(ShieldSend data, HttpSession session, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String fileName = "\u9632\u62a4\u7528\u54c1\u53d1\u653e\u6e05\u5355" + dateFormat.format(new Date()) + ".xls";
        response.setHeader("Content-Disposition", "attachment;filename=" + new String(fileName.getBytes("GBK"), "ISO8859_1"));
        response.setContentType("application/octet-stream; charset=GBK");
        String[] colums = new String[]{"\u53d1\u653e\u4eba|senderName", "\u53d1\u653e\u65f6\u95f4|sendTime"};
        data.setCid(UserUtils.getLoginStaffCompanyId());
        UserUtils.startWebDataScope();
        List list = this.shieldSendService.listDetails(data);
        ExportExcel export = new ExportExcel();
        export.simpleExport3("\u9632\u62a4\u7528\u54c1\u53d1\u653e\u6e05\u5355", colums, list, (OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"exportDetail"})
    public void export(Long id, HttpSession session, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String fileName = "\u9632\u62a4\u7528\u54c1\u53d1\u653e\u8be6\u60c5" + dateFormat.format(new Date()) + ".xls";
        response.setHeader("Content-Disposition", "attachment;filename=" + new String(fileName.getBytes("GBK"), "ISO8859_1"));
        response.setContentType("application/octet-stream; charset=GBK");
        String[] colums = new String[]{"\u53d1\u653e\u5bf9\u8c61", "\u9632\u62a4\u7528\u54c1\u7c7b\u522b", "\u540d\u79f0", "\u529f\u80fd", "\u8bf4\u660e", "\u9886\u53d6\u4eba", "\u9886\u53d6\u6570\u91cf", "\u578b\u53f7", "\u5355\u4f4d"};
        ShieldSend data = this.shieldSendService.getDetailById(id);
        data.setCid(UserUtils.getLoginStaffCompanyId());
        List list = data.getRecords();
        this.exportMergeExcel(fileName, "\u9632\u62a4\u7528\u54c1\u53d1\u653e\u8be6\u60c5", colums, list, (OutputStream)response.getOutputStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportMergeExcel(String fileName, String sheetName, String[] titles, List<ShieldSendRecord> list, OutputStream out) {
        try {
            int i;
            HSSFWorkbook wb = new HSSFWorkbook();
            HSSFSheet sheet = wb.createSheet(sheetName);
            HSSFCellStyle style = wb.createCellStyle();
            style.setVerticalAlignment(VerticalAlignment.CENTER);
            style.setAlignment(HorizontalAlignment.CENTER);
            HSSFRow row = sheet.createRow(0);
            for (i = 0; i < titles.length; ++i) {
                HSSFCell title = row.createCell(i);
                title.setCellValue(titles[i]);
                title.setCellStyle(style);
            }
            i = 0;
            for (ShieldSendRecord entry : list) {
                HSSFCell cell8;
                HSSFCell cell7;
                HSSFCell cell6;
                HSSFCell cell5;
                HSSFCell cell4;
                HSSFCell cell3;
                HSSFCell cell2;
                HSSFCell cell1;
                List shields = entry.getDetails();
                Byte requireType = entry.getRequireType();
                if (shields != null && shields.size() > 0) {
                    for (int j = 0; j < shields.size(); ++j) {
                        ShieldSendRecordDetail vo = (ShieldSendRecordDetail)shields.get(j);
                        row = sheet.createRow(++i);
                        if (j == 0) {
                            HSSFCell cell0 = row.createCell(0);
                            if (requireType == null || requireType == 1) {
                                cell0.setCellValue(this.staffInfoService.getStaffNameIncludeDelStatusByStaffId(entry.getRequirerId()));
                            } else {
                                cell0.setCellValue(entry.getRequireDeptName());
                            }
                            cell0.setCellStyle(style);
                        }
                        cell1 = row.createCell(1);
                        cell1.setCellValue(vo.getShieldTypeName());
                        cell2 = row.createCell(2);
                        cell2.setCellValue(vo.getDetailName());
                        cell3 = row.createCell(3);
                        cell3.setCellValue(vo.getFunc());
                        cell4 = row.createCell(4);
                        cell4.setCellValue(vo.getShieldName());
                        cell5 = row.createCell(5);
                        cell5.setCellValue(this.staffInfoService.getStaffNameIncludeDelStatusByStaffId(entry.getFetcher()));
                        cell6 = row.createCell(6);
                        cell6.setCellValue(vo.getFetchAmount() == null ? "" : String.valueOf(vo.getFetchAmount()));
                        cell7 = row.createCell(7);
                        cell7.setCellValue(vo.getModel());
                        cell8 = row.createCell(8);
                        cell8.setCellValue(vo.getUnitName());
                        cell1.setCellStyle(style);
                        cell2.setCellStyle(style);
                        cell3.setCellStyle(style);
                        cell4.setCellStyle(style);
                        cell5.setCellStyle(style);
                        cell6.setCellStyle(style);
                        cell7.setCellStyle(style);
                        cell8.setCellStyle(style);
                    }
                    if (shields.size() <= 1) continue;
                    sheet.addMergedRegion(new CellRangeAddress(i - shields.size() + 1, i, 0, 0));
                    continue;
                }
                ShieldSendRecordDetail vo = new ShieldSendRecordDetail();
                row = sheet.createRow(++i);
                HSSFCell cell0 = row.createCell(0);
                if (requireType == null || requireType == 1) {
                    cell0.setCellValue(this.staffInfoService.getStaffNameIncludeDelStatusByStaffId(entry.getRequirerId()));
                } else {
                    cell0.setCellValue(entry.getRequireDeptName());
                }
                cell1 = row.createCell(1);
                cell1.setCellValue(vo.getShieldTypeName());
                cell2 = row.createCell(2);
                cell2.setCellValue(vo.getDetailName());
                cell3 = row.createCell(3);
                cell3.setCellValue(vo.getFunc());
                cell4 = row.createCell(4);
                cell4.setCellValue(vo.getShieldName());
                cell5 = row.createCell(5);
                cell5.setCellValue(this.staffInfoService.getStaffNameIncludeDelStatusByStaffId(entry.getFetcher()));
                cell6 = row.createCell(6);
                cell6.setCellValue(vo.getFetchAmount() == null ? "" : String.valueOf(vo.getFetchAmount()));
                cell7 = row.createCell(7);
                cell7.setCellValue(vo.getModel());
                cell8 = row.createCell(8);
                cell8.setCellValue(vo.getUnitName());
                cell1.setCellStyle(style);
                cell2.setCellStyle(style);
                cell3.setCellStyle(style);
                cell4.setCellStyle(style);
                cell5.setCellStyle(style);
                cell6.setCellStyle(style);
                cell7.setCellStyle(style);
                cell8.setCellStyle(style);
            }
            try {
                wb.write(out);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    wb.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @RequiresPermissions(value={"shield.edit"})
    @ResponseBody
    @RequestMapping(value={"/cancel/{ids}"}, method={RequestMethod.POST})
    public ResponseData<String> cancel(@PathVariable String ids, HttpSession session) {
        this.logger.info("ajax-\u3010\u3011-\u5220\u9664\u8bb0\u5f55:" + ids);
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffId = UserUtils.getLoginStaffId();
        this.shieldSendService.cancelByIds(ids, staffId, cid);
        ResponseData data = new ResponseData();
        data.setResult((Object)ids);
        data.setContent("\u4f5c\u5e9f\u6210\u529f");
        return data;
    }
}

