/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.work.shield;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.BusinessNoTypeEnum;
import cn.smarthse.common.framework.enums.BusinessTypeEnum;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.excel.ExportExcel;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.excel.ExcelUtil;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.health.entity.work.planyear.vo.PlanYearExecute;
import cn.smarthse.modules.health.entity.work.shield.ShieldEquipRuleDetail;
import cn.smarthse.modules.health.entity.work.shield.ShieldPurchase;
import cn.smarthse.modules.health.entity.work.shield.ShieldPurchaseFile;
import cn.smarthse.modules.health.enums.planyear.PlanYearDetailImplState;
import cn.smarthse.modules.health.enums.shield.ShieldCountUnitEnum;
import cn.smarthse.modules.health.service.base.IBusinessNoService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.work.shield.IShieldEquipRuleDetailService;
import cn.smarthse.modules.health.service.work.shield.IShieldPurchaseService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.SyncBusinessUtil;
import cn.smarthse.web.util.SysFileUtil;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/work/shield/purchase"})
public class ShieldPurchaseController
extends ControllerSupport {
    @DubboReference
    IShieldPurchaseService shieldPurchaseService;
    @DubboReference
    private IBusinessNoService businessNoService;
    @DubboReference
    IStaffInfoService staffInfoService;
    @DubboReference
    IShieldEquipRuleDetailService shieldEquipRuleDetailService;

    @RequiresPermissions(value={"shield.view"})
    @RequestMapping(value={"unfinish"})
    public String page_index(HttpSession session, ModelMap m, ShieldPurchase data) {
        this.logger.info("\u3010\u3011-\u6c47\u603b\u9996\u9875");
        data.setStatus(Byte.valueOf((byte)0));
        m.put((Object)"data", (Object)data);
        return "work/shield/shieldPurchase/purchase_list";
    }

    @RequiresPermissions(value={"shield.view"})
    @ResponseBody
    @RequestMapping(value={"listData"})
    public JqGridData<ShieldPurchase> listData(HttpSession session, JqGridParam gparam, ShieldPurchase param) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        UserUtils.startWebDataScope();
        PageInfo list = this.shieldPurchaseService.getList(gparam, param);
        JqGridData data = new JqGridData(list, gparam);
        return data;
    }

    private void getOthersFlag(ModelMap m) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Integer staffs = this.staffInfoService.getStaffCountByCid(cid, null);
        m.put((Object)"staffs", (Object)staffs);
        m.put((Object)"tipName", (Object)"\u9632\u62a4\u7528\u54c1\u91c7\u8d2d\u4fe1\u606f\u767b\u8bb0");
        m.put((Object)"countUnitEnums", (Object)ShieldCountUnitEnum.values());
    }

    @RequiresPermissions(value={"shield.view"})
    @RequestMapping(value={"/view/{id}"}, method={RequestMethod.GET})
    public String info(@PathVariable Long id, String fromPage, HttpSession session, ModelMap m) {
        ShieldPurchase rule = null;
        rule = id != null ? this.shieldPurchaseService.getDetailById(id) : new ShieldPurchase();
        this.getOthersFlag(m);
        m.put((Object)"fromPage", (Object)fromPage);
        m.put((Object)"data", (Object)rule);
        m.addAttribute("page_editable", (Object)false);
        return "work/shield/shieldPurchase/purchase_info";
    }

    @RequiresPermissions(value={"shield.edit"})
    @RequestMapping(value={"/add"}, method={RequestMethod.GET})
    public String add(ShieldPurchase data, HttpSession session, ModelMap m) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        data.setBuyNo(this.businessNoService.getBusinessNo(cid, BusinessNoTypeEnum.SHIELDFETCH.getCode()));
        data.setBuyName("\u9632\u62a4\u7528\u54c1\u91c7\u8d2d");
        data.setBuyDate(new Date());
        data.setManager(UserUtils.getLoginStaffId());
        data.setManagerName(UserUtils.getLoginStaffName());
        m.put((Object)"data", (Object)data);
        this.getOthersFlag(m);
        m.put((Object)"fromPage", (Object)"new");
        m.addAttribute("page_editable", (Object)true);
        return "work/shield/shieldPurchase/purchase_edit";
    }

    @RequiresPermissions(value={"shield.edit"})
    @RequestMapping(value={"/edit/{id}"}, method={RequestMethod.GET})
    public String edit(@PathVariable Long id, String fromPage, HttpSession session, ModelMap m) {
        ShieldPurchase rule = null;
        rule = id != null ? this.shieldPurchaseService.getDetailById(id) : new ShieldPurchase();
        m.put((Object)"fromPage", (Object)fromPage);
        m.put((Object)"data", (Object)rule);
        this.getOthersFlag(m);
        m.addAttribute("page_editable", (Object)true);
        return "work/shield/shieldPurchase/purchase_edit";
    }

    @RequiresPermissions(value={"shield.edit"})
    @ResponseBody
    @RequestMapping(value={"/info"}, method={RequestMethod.POST})
    public ResponseData<ShieldPurchase> infoPost(HttpSession session, HttpServletRequest request, ShieldPurchase purchase) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffId = UserUtils.getLoginStaffId();
        this.setFilesByRequest(request, purchase);
        if (purchase.getId() == null && StringUtils.isEmpty((CharSequence)purchase.getOrgId())) {
            purchase.setOrgId("" + UserUtils.getOrgId());
        }
        purchase = this.shieldPurchaseService.insertOrUpdate(purchase, cid, staffId);
        PlanYearExecute planYearExecute = new PlanYearExecute();
        if (purchase.getStatus() != null && purchase.getStatus() == 1) {
            planYearExecute.setImplState(PlanYearDetailImplState.implemented);
        } else {
            planYearExecute.setImplState(PlanYearDetailImplState.progressing);
        }
        planYearExecute.setCid(cid);
        planYearExecute.setBusinessType(BusinessTypeEnum.shieldPurchase.getCode());
        planYearExecute.setBusinessId(purchase.getId());
        planYearExecute.setImplStartDate(purchase.getBuyDate());
        planYearExecute.setImplWorkName(purchase.getBuyName());
        planYearExecute.setImplManagerId(purchase.getManager());
        SyncBusinessUtil.executeUpdatePlanYearDetail(planYearExecute);
        ResponseData data = new ResponseData();
        data.setResult((Object)purchase);
        data.setContent("\u64cd\u4f5c\u6210\u529f");
        return data;
    }

    private void setFilesByRequest(HttpServletRequest request, ShieldPurchase data) {
        String[] files1Ids = request.getParameterValues("files1Ids");
        String[] files2Ids = request.getParameterValues("files2Ids");
        String[] files3Ids = request.getParameterValues("files3Ids");
        data.setFiles1(this.convertFileIds(files1Ids));
        data.setFiles2(this.convertFileIds(files2Ids));
        data.setFiles3(this.convertFileIds(files3Ids));
    }

    private List<ShieldPurchaseFile> convertFileIds(String[] fileIds) {
        ArrayList<ShieldPurchaseFile> files = new ArrayList<ShieldPurchaseFile>();
        if (fileIds == null || fileIds.length == 0) {
            return files;
        }
        for (String fileId : fileIds) {
            if (!StringUtils.isNumber((String)fileId)) continue;
            ShieldPurchaseFile file = new ShieldPurchaseFile();
            file.setFileId(Long.valueOf(Long.parseLong(fileId)));
            files.add(file);
        }
        return files;
    }

    @RequiresPermissions(value={"shield.edit"})
    @ResponseBody
    @RequestMapping(value={"/del/{ids}"}, method={RequestMethod.DELETE})
    public ResponseData<String> ajax_delete(@PathVariable String ids, HttpSession session) {
        this.logger.info("ajax-\u3010\u3011-\u5220\u9664\u8bb0\u5f55:" + ids);
        Long staffId = UserUtils.getLoginStaffId();
        this.shieldPurchaseService.deleteByIds(ids, staffId);
        Long cid = UserUtils.getLoginStaffCompanyId();
        List idArray = StringUtils.parseToLongList((String)ids, (String)",");
        if (idArray != null && idArray.size() > 0) {
            for (Long id : idArray) {
                PlanYearExecute planYearExecute = new PlanYearExecute();
                planYearExecute.setImplState(PlanYearDetailImplState.unimplemented);
                planYearExecute.setCid(cid);
                planYearExecute.setBusinessId(id);
                planYearExecute.setBusinessType(BusinessTypeEnum.shieldPurchase.getCode());
                SyncBusinessUtil.executeUpdatePlanYearDetail(planYearExecute);
            }
        }
        ResponseData data = new ResponseData();
        data.setResult((Object)ids);
        data.setContent("\u5220\u9664\u6210\u529f");
        return data;
    }

    @RequiresPermissions(value={"shield.view"})
    @RequestMapping(value={"exportList"})
    public void export(ShieldPurchase data, HttpSession session, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String fileName = "\u5df2\u5b8c\u6210\u9632\u62a4\u7528\u54c1\u91c7\u8d2d\u6e05\u5355" + dateFormat.format(new Date()) + ".xls";
        response.setHeader("Content-Disposition", "attachment;filename=" + new String(fileName.getBytes("GBK"), "ISO8859_1"));
        response.setContentType("application/octet-stream; charset=GBK");
        String[] colums = new String[]{"\u5de5\u4f5c\u540d\u79f0|buyName", "\u91c7\u8d2d\u65f6\u95f4|buyDate", "\u8d1f\u8d23\u4eba|managerName", "\u91c7\u8d2d\u8d39\u7528|buyCost", "\u66f4\u65b0\u65f6\u95f4|updateDate"};
        data.setCid(UserUtils.getLoginStaffCompanyId());
        data.setStatus(Byte.valueOf((byte)1));
        UserUtils.startWebDataScope();
        List list = this.shieldPurchaseService.listDetails(data);
        ExportExcel export = new ExportExcel();
        export.simpleExport3("\u9632\u62a4\u7528\u54c1\u91c7\u8d2d", colums, list, (OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"exportDetail"})
    public void exportDetail(Long id, HttpSession session, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ShieldPurchase data = null;
        data = id != null ? this.shieldPurchaseService.getDetailById(id) : new ShieldPurchase();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String fileName = "\u5355\u4e2a\u9632\u62a4\u7528\u54c1\u91c7\u8d2d\u6e05\u5355" + dateFormat.format(new Date()) + ".xls";
        response.setHeader("Content-Disposition", "attachment;filename=" + new String(fileName.getBytes("GBK"), "ISO8859_1"));
        response.setContentType("application/octet-stream; charset=GBK");
        String[] colums = new String[]{"\u9632\u62a4\u7528\u54c1\u7c7b\u522b|shieldName", "\u540d\u79f0|detailName", "\u529f\u80fd|func", "\u8bf4\u660e|description", "\u6570\u91cf|amount", "\u5355\u4f4d|unitName"};
        List list = data.getDetails();
        ExportExcel export = new ExportExcel();
        export.simpleExport3("\u5355\u4e2a\u9632\u62a4\u7528\u54c1\u91c7\u8d2d\u6e05\u5355", colums, list, (OutputStream)response.getOutputStream());
    }

    @RequiresPermissions(value={"shield.edit"})
    @ResponseBody
    @RequestMapping(value={"/cancel/{ids}"}, method={RequestMethod.POST})
    public ResponseData<String> cancel(@PathVariable String ids, HttpSession session) {
        this.logger.info("ajax-\u3010\u3011-\u5220\u9664\u8bb0\u5f55:" + ids);
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffId = UserUtils.getLoginStaffId();
        this.shieldPurchaseService.cancelByIds(ids, staffId, cid);
        ResponseData data = new ResponseData();
        data.setResult((Object)ids);
        data.setContent("\u4f5c\u5e9f\u6210\u529f");
        return data;
    }

    @RequestMapping(value={"/downloadImportTemplate"}, method={RequestMethod.GET})
    public void downloadImportTemplate(HttpServletResponse response) throws Exception {
        ShieldEquipRuleDetail param = new ShieldEquipRuleDetail();
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        List list = this.shieldEquipRuleDetailService.getDetailTable(param);
        String templateDirPath = super.getTemplateFilePath();
        String tempDirPath = super.getTempFilePath();
        String resultFileName = "\u9632\u62a4\u7528\u54c1\u91c7\u8d2d\u5bfc\u5165\u6a21\u677f.xls";
        String templateFileName = templateDirPath + "shield/\u9632\u62a4\u7528\u54c1\u91c7\u8d2d\u5bfc\u5165\u6a21\u677f.xls";
        String resultFilePath = tempDirPath + new Date().getTime() + ".xls";
        this.createTempExcel(list, templateFileName, resultFilePath);
        this.downloadFile(response, resultFilePath, resultFileName);
    }

    private void createTempExcel(List<ShieldEquipRuleDetail> list, String templateFileName, String resultFilePath) {
        try {
            FileInputStream is = new FileInputStream(templateFileName);
            HSSFWorkbook xwb = new HSSFWorkbook((InputStream)is);
            HSSFSheet sheet = xwb.getSheetAt(0);
            for (int i = 1; i <= list.size(); ++i) {
                ShieldEquipRuleDetail detail = list.get(i - 1);
                HSSFRow row = sheet.createRow(i);
                HSSFCell cell1 = row.createCell(0);
                cell1.setCellValue(detail.getDetailName());
                HSSFCell cell2 = row.createCell(1);
                cell2.setCellValue(detail.getProLevel());
                HSSFCell cell3 = row.createCell(2);
                cell3.setCellValue(detail.getShieldDesc());
                HSSFCell cell5 = row.createCell(4);
                cell5.setCellValue(StringUtils.isEmpty((CharSequence)detail.getCountUnitName()) ? ShieldCountUnitEnum.one.getName() : detail.getCountUnitName());
            }
            FileOutputStream out = new FileOutputStream(resultFilePath);
            xwb.write((OutputStream)out);
            ((InputStream)is).close();
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadFile(HttpServletResponse response, String resultFilePath, String resultFileName) throws IOException {
        BufferedOutputStream bos = new BufferedOutputStream((OutputStream)response.getOutputStream());
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(resultFilePath));
        try {
            int bytesRead;
            response.setHeader("Content-Disposition", "attachment;filename=" + new String(resultFileName.getBytes("GBK"), "ISO8859_1"));
            response.setContentType("application/octet-stream; charset=GBK");
            response.setHeader("Content-Length", String.valueOf(new File(resultFilePath).length()));
            byte[] buff = new byte[1024];
            while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                bos.write(buff, 0, bytesRead);
            }
        }
        finally {
            if (bos != null) {
                bos.close();
            }
            if (bis != null) {
                bis.close();
            }
        }
    }

    @RequestMapping(value={"/importPage"}, method={RequestMethod.GET})
    public String import_page(ModelMap m) {
        return "work/shield/shieldPurchase/import";
    }

    @RequestMapping(value={"/import"}, method={RequestMethod.POST})
    public String upload(Long id, Long fileId, HttpServletRequest request, ModelMap m) {
        ResponseData data = new ResponseData();
        data.setState(ResponseStateEnum.fail);
        if (fileId == null) {
            data.setContent("\u4e0a\u4f20\u6587\u4ef6\u4e0d\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20");
            m.put((Object)"data", (Object)data);
            return "work/shield/shieldPurchase/import_result";
        }
        try {
            SysFileModel file = SysFileUtil.getFileById(fileId);
            if (file == null) {
                data.setContent("\u4e0a\u4f20\u6587\u4ef6\u4e0d\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20");
                m.put((Object)"data", (Object)data);
                return "work/shield/shieldPurchase/import_result";
            }
            String fileExt = file.getFileExt();
            if (!"xls".equals(fileExt)) {
                data.setContent("\u4e0a\u4f20\u6587\u4ef6\u4e0d\u6b63\u786e\uff0c\u8bf7\u4e0a\u4f20xls\u6587\u4ef6");
                m.put((Object)"data", (Object)data);
                return "work/shield/shieldPurchase/import_result";
            }
            InputStream is = SysFileUtil.getInputStreamFileUrlByfid(file, request);
            if (is == null) {
                data.setContent("\u4e0a\u4f20\u6587\u4ef6\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20");
                m.put((Object)"data", (Object)data);
                return "work/shield/shieldPurchase/import_result";
            }
            Long cid = UserUtils.getLoginStaffCompanyId();
            Long staffId = UserUtils.getLoginStaffId();
            List<List<String>> contents = this.getImportDatas(is);
            data = this.shieldPurchaseService.importRules(id, contents, staffId, cid);
        }
        catch (Exception e) {
            data.setState(ResponseStateEnum.fail);
            e.printStackTrace();
            data.setContent("\u670d\u52a1\u5668\u7e41\u5fd9\u8bf7\u7a0d\u540e\u518d\u8bd5");
            m.put((Object)"data", (Object)data);
            return "work/shield/shieldPurchase/import_result";
        }
        m.put((Object)"data", (Object)data);
        return "work/shield/shieldPurchase/import_result";
    }

    private List<List<String>> getImportDatas(InputStream iputstream) {
        List contents = null;
        ExcelUtil util = ExcelUtil.getInstance();
        ArrayList<Integer> cellNum = new ArrayList<Integer>();
        cellNum.add(5);
        try {
            contents = util.getAllContentByCell(iputstream, cellNum, 1);
            return contents;
        }
        catch (Exception e) {
            e.printStackTrace();
            return contents;
        }
    }
}

