/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.work.shield;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.entity.work.shield.ShieldEquipRule;
import cn.smarthse.modules.health.entity.work.shield.ShieldEquipRuleDetail;
import cn.smarthse.modules.health.enums.shield.ShieldCountUnitEnum;
import cn.smarthse.modules.health.service.base.staff.IStaffWorkRoleService;
import cn.smarthse.modules.health.service.work.shield.IShieldEquipRuleDetailService;
import cn.smarthse.modules.health.service.work.shield.IShieldEquipRuleService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/work/shield/equipWorkRole/detail"})
public class ShieldEquipRuleDetailController
extends ControllerSupport {
    @DubboReference
    IShieldEquipRuleDetailService shieldEquipRuleDetailService;
    @DubboReference
    private IShieldEquipRuleService shieldEquipRuleService;
    @DubboReference
    private IStaffWorkRoleService staffWorkRoleService;

    @RequestMapping(value={"/list"})
    public String getWorkPlaceData(ShieldEquipRuleDetail param, ModelMap m) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        List list = this.shieldEquipRuleDetailService.getDetailList(param);
        m.put((Object)"countUnitEnums", (Object)ShieldCountUnitEnum.values());
        m.put((Object)"list", (Object)list);
        return "work/shield/equipWorkRole/selectShieldMoreTable";
    }

    @RequestMapping(value={"/table"})
    public String getTableData(ShieldEquipRuleDetail param, ModelMap m, String staffIds) {
        List list = null;
        Long cid = UserUtils.getLoginStaffCompanyId();
        if (!StringUtils.isEmpty((CharSequence)staffIds)) {
            String[] staffs;
            ArrayList<Long> staffLongIds = new ArrayList<Long>();
            param.setWorkId(null);
            for (String staffId : staffs = staffIds.split(",")) {
                staffLongIds.add(Long.parseLong(staffId));
            }
            List workIds = this.staffWorkRoleService.getWorkIdsByStaffIds(staffLongIds);
            List ruleIds = this.shieldEquipRuleService.getIdsByWorkIds(workIds);
            list = this.shieldEquipRuleDetailService.getDetailTableV2_9(cid, ruleIds);
        } else {
            param.setCid(cid);
            list = this.shieldEquipRuleDetailService.getDetailTable(param);
        }
        m.put((Object)"countUnitEnums", (Object)ShieldCountUnitEnum.values());
        m.put((Object)"list", (Object)list);
        return "work/shield/equipWorkRole/selectShieldMoreTable";
    }

    @RequiresPermissions(value={"shield.edit"})
    @ResponseBody
    @RequestMapping(value={"/info"}, method={RequestMethod.POST})
    public ResponseData<Long> infoPost(HttpSession session, HttpServletRequest request, Long ruleId) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffId = UserUtils.getLoginStaffId();
        String[] checkedProtectPPEIds = request.getParameterValues("protectId");
        String[] removedProtectPPEIds = request.getParameterValues("removeProtectId");
        this.shieldEquipRuleDetailService.updateByProtects(ruleId, checkedProtectPPEIds, removedProtectPPEIds, staffId, cid);
        ResponseData data = new ResponseData();
        data.setResult((Object)ruleId);
        data.setContent("\u64cd\u4f5c\u6210\u529f");
        return data;
    }

    @RequiresPermissions(value={"shield.edit"})
    @ResponseBody
    @RequestMapping(value={"/info/rule"}, method={RequestMethod.POST})
    public ResponseData<Long> infoPost1(HttpSession session, HttpServletRequest request, ShieldEquipRule rule) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffId = UserUtils.getLoginStaffId();
        rule.setCreateBy(staffId);
        rule.setCid(cid);
        String[] removedProtectPPEIds = request.getParameterValues("removeProtectId");
        this.shieldEquipRuleDetailService.updateByProtects(rule, removedProtectPPEIds);
        ResponseData data = new ResponseData();
        data.setResult((Object)rule.getId());
        data.setContent("\u64cd\u4f5c\u6210\u529f");
        return data;
    }
}

