/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.work.shield;

import cn.smarthse.common.framework.excel.ExportExcel;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.modules.health.entity.work.shield.ShieldPurchase;
import cn.smarthse.modules.health.entity.work.shield.ShieldSend;
import cn.smarthse.modules.health.entity.work.shield.vo.ShieldSendCount;
import cn.smarthse.modules.health.entity.work.shield.vo.ShieldSendInfo;
import cn.smarthse.modules.health.service.work.shield.IShieldInfoService;
import cn.smarthse.modules.health.service.work.shield.IShieldSendService;
import cn.smarthse.modules.health.vo.work.shield.ShieldSendCountParamVo;
import cn.smarthse.modules.health.vo.work.shield.ShieldSendCountVo;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/work/shield/count"})
public class ShieldCountController
extends ControllerSupport {
    @DubboReference
    IShieldInfoService shieldInfoService;
    @DubboReference
    IShieldSendService shieldSendService;
    int distance = 2;

    @RequiresPermissions(value={"shield.view"})
    @RequestMapping(value={"/purchase"})
    public String purchase(HttpSession session, ModelMap m, ShieldPurchase data) {
        data.setStatus(Byte.valueOf((byte)1));
        m.put((Object)"data", (Object)data);
        return "work/shield/shieldPurchase/purchase_finish_list";
    }

    @RequiresPermissions(value={"shield.view"})
    @RequestMapping(value={"/send"})
    public String send(HttpSession session, ModelMap m, ShieldSend data) {
        data.setStatus(Byte.valueOf((byte)1));
        m.put((Object)"data", (Object)data);
        return "work/shield/shieldSend/send_finish_list";
    }

    @RequiresPermissions(value={"shield.view"})
    @RequestMapping
    public String count(HttpSession session, ModelMap m) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        List count = this.shieldSendService.countShieldSend(this.distance, cid);
        List<Integer> years = this.getYearsByDistance(this.distance);
        m.put((Object)"count", (Object)count);
        m.put((Object)"years", years);
        return "work/shield/equipWorkRole/count";
    }

    private List<Integer> getYearsByDistance(int distance) {
        ArrayList<Integer> years = new ArrayList<Integer>();
        int maxYear = DateUtils.getThisYear();
        for (int i = distance; i >= 0; --i) {
            int year = maxYear - i;
            years.add(year);
        }
        return years;
    }

    @RequiresPermissions(value={"shield.view"})
    @RequestMapping(value={"/export"})
    public void export(HttpServletRequest request, HttpServletResponse response) throws Exception {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String fileName = "\u9632\u62a4\u7528\u54c1\u53d1\u653e\u7edf\u8ba1" + dateFormat.format(new Date()) + ".xls";
        Long cid = UserUtils.getLoginStaffCompanyId();
        List count = this.shieldSendService.countShieldSend(this.distance, cid);
        List<Object> titles = this.getTitles(this.distance);
        response.setHeader("Content-Disposition", "attachment;filename=" + new String(fileName.getBytes("GBK"), "ISO8859_1"));
        response.setContentType("application/octet-stream; charset=GBK");
        this.exportCountExcel(fileName, "\u9632\u62a4\u7528\u54c1\u53d1\u653e\u7edf\u8ba1", titles, count, (OutputStream)response.getOutputStream());
    }

    private List<Object> getTitles(int distance) {
        ArrayList<Object> titles = new ArrayList<Object>();
        titles.add("\u9632\u62a4\u7528\u54c1\u540d\u79f0");
        titles.add("\u5355\u4f4d");
        int maxYear = DateUtils.getThisYear();
        for (int i = distance; i >= 0; --i) {
            int year = maxYear - i;
            titles.add(year);
        }
        return titles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportCountExcel(String fileName, String sheetName, List<Object> titles, List<ShieldSendCount> list, OutputStream out) {
        try {
            HSSFWorkbook wb = new HSSFWorkbook();
            HSSFSheet sheet = wb.createSheet(sheetName);
            HSSFCellStyle style = wb.createCellStyle();
            style.setVerticalAlignment(VerticalAlignment.CENTER);
            style.setAlignment(HorizontalAlignment.CENTER);
            int rowIndex = 0;
            HSSFRow row = sheet.createRow(rowIndex);
            for (int i = 0; i < titles.size(); ++i) {
                row.createCell(i).setCellValue(String.valueOf(titles.get(i)));
            }
            for (ShieldSendCount entry : list) {
                row = sheet.createRow(++rowIndex);
                List infos = entry.getSendInfos();
                HSSFCell cell0 = row.createCell(0);
                cell0.setCellValue(entry.getShieldName());
                HSSFCell cell1 = row.createCell(1);
                cell1.setCellValue(entry.getUnitName());
                if (infos == null || infos.size() == 0) continue;
                for (int j = 0; j < infos.size(); ++j) {
                    ShieldSendInfo vo = (ShieldSendInfo)infos.get(j);
                    HSSFCell yearCell = row.createCell(j + 2);
                    yearCell.setCellValue((double)vo.getSendCount());
                }
            }
            try {
                wb.write(out);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    wb.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @RequiresPermissions(value={"shield.view"})
    @RequestMapping(value={"/newCount"})
    public String newCount(ModelMap m) {
        Date initEndDate = new Date();
        m.put((Object)"initBeginDate", (Object)DateUtils.getDistanceDate((Date)initEndDate, (int)2, (int)-1));
        m.put((Object)"initEndDate", (Object)initEndDate);
        return "work/shield/equipWorkRole/count_v2_10_2";
    }

    @RequiresPermissions(value={"shield.view"})
    @RequestMapping(value={"/dataList"})
    @ResponseBody
    public List<ShieldSendCountVo> dataList(ShieldSendCountParamVo param) throws ParseException {
        this.setSendCountParam(param);
        List list = this.shieldSendService.countShieldSend2_10_3(param);
        return list;
    }

    private void setSendCountParam(ShieldSendCountParamVo param) throws ParseException {
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        if (param.getEndDate() == null) {
            param.setEndDate(new Date());
        }
        String format = DateUtil.format((Date)param.getEndDate(), (String)"yyyy-MM-dd");
        param.setEndDate(DateUtil.parseDate((String)(format + " 23:59:59"), (String)"yyyy-MM-dd HH:mm:ss"));
    }

    @RequiresPermissions(value={"shield.view"})
    @RequestMapping(value={"/newExport"})
    public void newExport(HttpServletResponse response, ShieldSendCountParamVo param) throws Exception {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String fileName = "\u9632\u62a4\u7528\u54c1\u53d1\u653e\u7edf\u8ba1" + dateFormat.format(new Date()) + ".xls";
        this.setSendCountParam(param);
        param.setExportFlag(Boolean.valueOf(true));
        List list = this.shieldSendService.countShieldSend2_10_3(param);
        String[] colums = new String[]{"\u9632\u62a4\u7528\u54c1\u7c7b\u522b|proClass", "\u9632\u62a4\u7528\u54c1\u540d\u79f0|detailName", "\u529f\u80fd|func", "\u8bf4\u660e|shieldDesc", "\u578b\u53f7|model", "\u53d1\u653e\u5bf9\u8c61|requiredName", "\u53d1\u653e\u6570\u91cf|num", "\u5355\u4f4d|unit", "\u53d1\u653e\u65f6\u95f4|sendTime", "\u9886\u53d6\u4eba|fetchName", "\u7edf\u8ba1\u65f6\u95f4|countTime"};
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-Disposition", "attachment;filename=" + new String(fileName.getBytes("GBK"), "ISO8859_1"));
        response.setContentType("application/octet-stream; charset=GBK");
        ExportExcel listexcel = new ExportExcel();
        listexcel.simpleExport3("\u9632\u62a4\u7528\u54c1\u53d1\u653e\u7edf\u8ba1", colums, list, (OutputStream)response.getOutputStream());
    }
}

