/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.work.shield;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.modules.health.entity.work.shield.ProtectList;
import cn.smarthse.modules.health.entity.work.shield.ShieldEquipRule;
import cn.smarthse.modules.health.entity.work.shield.vo.ProtectQuery;
import cn.smarthse.modules.health.entity.work.shield.vo.ShieldEquipRuleHarm;
import cn.smarthse.modules.health.enums.shield.OxygenLackProtectEnum;
import cn.smarthse.modules.health.service.work.shield.IProtectListService;
import cn.smarthse.modules.health.service.work.shield.IShieldEquipRuleService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpSession;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/work/shield/protect"})
public class ProtectListController
extends ControllerSupport {
    @DubboReference
    IProtectListService protectListService;
    @DubboReference
    IShieldEquipRuleService shieldEquipRuleService;

    @RequiresPermissions(value={"shield.view"})
    @ResponseBody
    @RequestMapping(value={"listData"})
    public JqGridData<ProtectList> listData(HttpSession session, JqGridParam gparam, ProtectQuery query) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        query.setCid(cid);
        PageInfo list = this.protectListService.getPage(gparam, query);
        JqGridData data = new JqGridData(list, gparam);
        return data;
    }

    @RequiresPermissions(value={"shield.edit"})
    @ResponseBody
    @RequestMapping(method={RequestMethod.GET}, value={"/addProtectList"})
    public ResponseData<ProtectList> addProtectList(ModelMap modelMap, ProtectList protectList) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        protectList.setCid(cid);
        ProtectList protectListBack = this.protectListService.addProtectList(protectList);
        return new ResponseData("\u65b0\u589e\u6210\u529f", (Object)protectListBack);
    }

    @RequiresPermissions(value={"shield.view"})
    @ResponseBody
    @RequestMapping(value={"listTypeData"})
    public JqGridData<ProtectList> listTypeData(HttpSession session, JqGridParam gparam, ProtectQuery query) {
        PageInfo list = null;
        list = query.getType() == null ? new PageInfo() : this.protectListService.getPage(gparam, query);
        JqGridData data = new JqGridData(list, gparam);
        return data;
    }

    private void setOthers(ProtectQuery query, ModelMap m) {
        ShieldEquipRule rule = this.shieldEquipRuleService.getRuleInfoById(query.getRuleId());
        m.put((Object)"rule", (Object)rule);
        Integer type = query.getType();
        String tip = "";
        tip = type == null ? "\u8bf7\u6839\u636e\u60a8\u9700\u8981\u9632\u62a4\u7684\u8eab\u4f53\u90e8\u4f4d\u9009\u62e9\u9632\u62a4\u7528\u54c1\u7684\u7c7b\u522b\uff0c\u7cfb\u7edf\u4f1a\u63d0\u4f9b\u60a8\u8be5\u7c7b\u522b\u4e0b\u7684\u9632\u62a4\u7528\u54c1\u3002" : (type == 6 ? "\u5728\u201c\u62a4\u542c\u5668\u9009\u62e9\u201d\u4e2d\u901a\u8fc7\u8f93\u5165\u566a\u58f0\u7684\u5f3a\u5ea6\uff0c\u7cfb\u7edf\u53ef\u4e3a\u60a8\u63a8\u8350\u51fa\u66f4\u9002\u5408\u60a8\u7684\u62a4\u542c\u5668\u3002" : (type == 7 ? "\u5728\u201c\u5b58\u5728\u6c61\u67d3\u7269\u7684\u73af\u5883\u201d\u4e2d\u901a\u8fc7\u8f93\u5165\u5371\u5bb3\u56e0\u7d20\u7684\u6d53\u5ea6\uff0c\u7cfb\u7edf\u53ef\u4e3a\u60a8\u63a8\u8350\u51fa\u66f4\u9002\u5408\u60a8\u7684\u547c\u5438\u7c7b\u9632\u62a4\u7528\u54c1\u3002" : "\u6839\u636e\u60a8\u9700\u8981\u9632\u62a4\u7684\u8eab\u4f53\u90e8\u4f4d\uff0c\u7cfb\u7edf\u4e3a\u60a8\u63d0\u4f9b\u4ee5\u4e0b\u9632\u62a4\u7528\u54c1\u4f9b\u9009\u62e9\u3002"));
        m.put((Object)"tip", (Object)tip);
    }

    @RequestMapping(value={""}, method={RequestMethod.GET})
    public String index(ProtectQuery query, HttpSession session, ModelMap m) {
        List data = this.protectListService.getProtectClassList();
        m.put((Object)"data", (Object)data);
        m.put((Object)"query", (Object)query);
        this.setOthers(query, m);
        return "work/shield/protect/index";
    }

    @RequestMapping(value={"/type"}, method={RequestMethod.GET})
    public String type(ProtectQuery query, HttpSession session, ModelMap m) {
        List data = this.protectListService.getProtectClassList();
        m.put((Object)"data", (Object)data);
        m.put((Object)"query", (Object)query);
        List details = this.protectListService.getList(query);
        m.put((Object)"details", (Object)details);
        this.setOthers(query, m);
        return "work/shield/protect/type_6";
    }

    @RequestMapping(value={"/breath"}, method={RequestMethod.GET})
    public String breath(ProtectQuery query, HttpSession session, ModelMap m) {
        List data = this.protectListService.getProtectClassList();
        query.setPpeIds(OxygenLackProtectEnum.getCodes());
        List details = this.protectListService.getList(query);
        List harms = this.shieldEquipRuleService.getHarmfactorListByRule(query.getRuleId());
        m.put((Object)"data", (Object)data);
        m.put((Object)"query", (Object)query);
        m.put((Object)"details", (Object)details);
        m.put((Object)"harms", (Object)harms);
        this.setOthers(query, m);
        return "work/shield/protect/type_7";
    }

    @RequestMapping(value={"/breath/recommend"}, method={RequestMethod.POST})
    public String infoBreath(ShieldEquipRuleHarm harm, ModelMap m) {
        harm = this.protectListService.getProtectByBreathHarm(harm);
        m.put((Object)"harm", (Object)harm);
        return "work/shield/protect/breath_recommend";
    }
}

