/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.work.shield;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.framework.sensitive.utils.DesensitizationUtils;
import cn.smarthse.modules.common.enums.BigLogBusinessModuleEnum;
import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.modules.datacentre.model.bigdata.BigLog;
import cn.smarthse.modules.health.compliance.enums.ComplianceCodeEnum;
import cn.smarthse.modules.health.compliance.service.IBusinessDataUpdateRefreshService;
import cn.smarthse.modules.health.entity.work.shield.ProtectEquipIssueRecord;
import cn.smarthse.modules.health.entity.work.shield.ProtectEquipIssueRecordDetail;
import cn.smarthse.modules.health.newcompanyguide.enums.NewCompanyGuideRefreshModelEnum;
import cn.smarthse.modules.health.newcompanyguide.service.INewCompanyGuideFinishedReportService;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveUpdateService;
import cn.smarthse.modules.health.service.work.shield.IProtectEquipIssueRecordDetailService;
import cn.smarthse.modules.health.service.work.shield.IProtectEquipIssueRecordService;
import cn.smarthse.modules.health.supervise.entity.keyFactory.KeyFactoryApprovalHistory;
import cn.smarthse.modules.health.supervise.enums.keyFactory.KeyFactoryTypeEnum;
import cn.smarthse.modules.health.supervise.service.keyFactory.IKeyFactoryApprovalHistoryService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.controller.base.BaseController;
import cn.smarthse.web.util.UserUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.github.pagehelper.PageInfo;
import com.sx.log.enums.ActionTypeEnum;
import com.sx.log.enums.UserRoleEnum;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/work/shield/equip"})
public class PersonalProtectEquipController
extends ControllerSupport {
    @DubboReference
    IProtectEquipIssueRecordService equipIssueRecordService;
    @DubboReference
    IProtectEquipIssueRecordDetailService equipIssueRecordDetailService;
    @DubboReference(timeout=600000, check=false)
    IKeyFactoryApprovalHistoryService historyService;
    @DubboReference
    ILiteArchiveUpdateService archiveUpdateService;
    @DubboReference(check=false)
    private IBusinessDataUpdateRefreshService refreshService;
    @DubboReference(check=false)
    private INewCompanyGuideFinishedReportService companyGuideFinishedReportService;
    @Autowired
    private BaseController baseController;

    @RequiresPermissions(value={"shield"})
    @RequestMapping(method={RequestMethod.GET}, value={"/toRecordIndex"})
    public String toRecordIndex(ModelMap modelMap) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        List years = this.equipIssueRecordService.getAllRecordYearBySearch(cid);
        modelMap.put((Object)"years", (Object)years);
        return "/views/keyFactorManagement/shieldEquipRecord/shieldEquipRecordList";
    }

    @RequiresPermissions(value={"shield.view"})
    @ResponseBody
    @RequestMapping(method={RequestMethod.POST}, value={"/listRecordData"})
    public JqGridData<ProtectEquipIssueRecord> listRecordData(JqGridParam jqGridParam, ProtectEquipIssueRecord searchModel) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        searchModel.setCid(cid);
        PageInfo pageInfo = this.equipIssueRecordService.getPagesIssueRecordBySearchModel(jqGridParam, searchModel);
        return new JqGridData(pageInfo, jqGridParam);
    }

    @RequiresPermissions(value={"shield.view"})
    @RequestMapping(method={RequestMethod.GET}, value={"/viewRecord"})
    public String viewPageRecord(ModelMap modelMap, Long id) {
        ProtectEquipIssueRecord record = (ProtectEquipIssueRecord)this.equipIssueRecordService.getById(id);
        if (record != null && StringUtils.isNotBlank((CharSequence)record.getFactorNames())) {
            record.setFactorNames(record.getFactorNames().replaceAll("[\t\n\r]", ""));
        }
        DesensitizationUtils.setDesensitizationFieldFromObject((Object)record);
        modelMap.put((Object)"record", (Object)record);
        modelMap.put((Object)"isEdit", (Object)false);
        return "/views/keyFactorManagement/shieldEquipRecord/shieldEquipRecordDetail";
    }

    @RequiresPermissions(value={"shield.edit"})
    @RequestMapping(method={RequestMethod.GET}, value={"/editRecord"})
    public String editPageRecord(ModelMap modelMap, Long id) {
        ProtectEquipIssueRecord record = (ProtectEquipIssueRecord)this.equipIssueRecordService.getById(id);
        if (record != null && StringUtils.isNotBlank((CharSequence)record.getFactorNames())) {
            record.setFactorNames(record.getFactorNames().replaceAll("[\t\n\r]", ""));
        }
        modelMap.put((Object)"record", (Object)record);
        modelMap.put((Object)"isEdit", (Object)true);
        return "/views/keyFactorManagement/shieldEquipRecord/shieldEquipRecordDetail";
    }

    @RequiresPermissions(value={"shield.edit"})
    @ResponseBody
    @RequestMapping(method={RequestMethod.GET}, value={"/deleteRecord"})
    public ResponseData<String> deleteRecord(ModelMap modelMap, Long id) {
        if (id == null) {
            return ResponseData.fail((String)"\u5220\u9664\u7684id\u4e3a\u7a7a");
        }
        ProtectEquipIssueRecord record = (ProtectEquipIssueRecord)this.equipIssueRecordService.getById(id);
        if (record == null) {
            return ResponseData.fail((String)"\u6570\u636e\u4e0d\u5b58\u5728");
        }
        if (!record.getReportState().equals(1)) {
            return ResponseData.fail((String)"\u4e0d\u662f\u8349\u7a3f\u72b6\u6001\uff0c\u5220\u9664\u5931\u8d25,\u8bf7\u5237\u65b0\u9875\u9762");
        }
        try {
            this.equipIssueRecordService.deleteByIds(Collections.singletonList(id), UserUtils.getLoginStaffId());
            return ResponseData.success();
        }
        catch (Exception e) {
            return ResponseData.fail((String)e.getMessage());
        }
    }

    @RequiresPermissions(value={"shield.edit"})
    @ResponseBody
    @RequestMapping(method={RequestMethod.GET}, value={"/setTermination"})
    @BigLog(userRole=UserRoleEnum.ENTERPRISE_TYPE, actionType=ActionTypeEnum.WORK_END_TYPE, businessModule=BigLogBusinessModuleEnum.module2, businessIdParamName="keyFactoryId")
    public ResponseData<String> setTermination(ModelMap modelMap, Long id, HttpServletRequest request) {
        if (id == null) {
            request.setAttribute("actionType", (Object)ActionTypeEnum.BIZ_LOG_TYPE.getValue());
            return ResponseData.fail((String)"\u8bbe\u7f6e\u7684id\u4e3a\u7a7a");
        }
        try {
            Long keyFactoryId = this.equipIssueRecordService.setTermination(new ProtectEquipIssueRecord().setId(id), UserUtils.getLoginStaffId(), UserUtils.getCurrentCompany());
            request.setAttribute("keyFactoryId", (Object)keyFactoryId);
            request.setAttribute("actionType", (Object)ActionTypeEnum.WORK_END_TYPE.getValue());
            return ResponseData.success();
        }
        catch (Exception e) {
            request.setAttribute("actionType", (Object)ActionTypeEnum.BIZ_LOG_TYPE.getValue());
            return ResponseData.fail((String)e.getMessage());
        }
    }

    @RequiresPermissions(value={"shield.edit"})
    @ResponseBody
    @RequestMapping(method={RequestMethod.GET}, value={"/cloneRecord"})
    public ResponseData<ProtectEquipIssueRecord> cloneRecord(ModelMap modelMap, Long id) {
        try {
            return ResponseData.success((Object)this.equipIssueRecordService.cloneRecord(id, UserUtils.getLoginStaffId()));
        }
        catch (Exception e) {
            return ResponseData.fail((String)e.getMessage());
        }
    }

    @RequiresPermissions(value={"shield.edit"})
    @ResponseBody
    @RequestMapping(method={RequestMethod.GET}, value={"/toAddRecord"})
    public ResponseData<Long> toAddRecord(ModelMap modelMap, Integer reportType) {
        try {
            Long loginStaffId = UserUtils.getLoginStaffId();
            Long cid = UserUtils.getLoginStaffCompanyId();
            ProtectEquipIssueRecord param = new ProtectEquipIssueRecord();
            param.setCid(cid);
            param.setReportType(reportType);
            param.setReportState(Integer.valueOf(1));
            param.setCreateBy(loginStaffId);
            param.setUpdateBy(loginStaffId);
            param.setUpdateDate(new Date());
            param.setCreateDate(new Date());
            ProtectEquipIssueRecord record = this.equipIssueRecordService.addRecordByCheck(param);
            return ResponseData.success((Object)record.getId());
        }
        catch (Exception e) {
            return ResponseData.fail((String)e.getMessage());
        }
    }

    @RequiresPermissions(value={"shield.view"})
    @ResponseBody
    @RequestMapping(method={RequestMethod.POST}, value={"/listRecordDetailData"})
    public JqGridData<ProtectEquipIssueRecordDetail> listRecordDetailData(JqGridParam jqGridParam, ProtectEquipIssueRecordDetail recordDetail) {
        if (recordDetail == null || recordDetail.getEquipIssueRecordId() == null) {
            return new JqGridData(new PageInfo(), jqGridParam);
        }
        PageInfo pageInfo = this.equipIssueRecordDetailService.getPageRecordDetailListBySearchModel(jqGridParam, recordDetail);
        return new JqGridData(pageInfo, jqGridParam);
    }

    @RequiresPermissions(value={"shield.edit"})
    @ResponseBody
    @RequestMapping(method={RequestMethod.POST}, value={"/editRecordDetail"})
    public ResponseData<ProtectEquipIssueRecordDetail> editRecordDetail(ModelMap modelMap, ProtectEquipIssueRecordDetail recordDetail) {
        try {
            ProtectEquipIssueRecordDetail detail = this.equipIssueRecordDetailService.addOrUpdate(recordDetail, UserUtils.getLoginStaffId());
            return ResponseData.success((Object)detail);
        }
        catch (Exception e) {
            return ResponseData.fail((String)e.getMessage());
        }
    }

    @RequiresPermissions(value={"shield.edit"})
    @ResponseBody
    @RequestMapping(method={RequestMethod.GET}, value={"/cloneRecordDetail"})
    public ResponseData<ProtectEquipIssueRecordDetail> cloneRecordDetail(ModelMap modelMap, Long id) {
        Long loginStaffId = UserUtils.getLoginStaffId();
        ProtectEquipIssueRecordDetail recordDetail = (ProtectEquipIssueRecordDetail)this.equipIssueRecordDetailService.getById(id);
        if (recordDetail == null) {
            return ResponseData.fail((String)"\u672a\u627e\u5230\u53d1\u653e\u8bb0\u5f55\u8be6\u60c5");
        }
        try {
            recordDetail.setId(null);
            recordDetail.setWorkshop(null);
            recordDetail.setWorkName(null);
            ProtectEquipIssueRecordDetail recordDetailNew = this.equipIssueRecordDetailService.addOrUpdate(recordDetail, loginStaffId);
            return ResponseData.success((Object)recordDetailNew);
        }
        catch (Exception e) {
            return ResponseData.fail((String)e.getMessage());
        }
    }

    @RequiresPermissions(value={"shield.edit"})
    @ResponseBody
    @RequestMapping(method={RequestMethod.GET}, value={"/deleteRecordDetail"})
    public ResponseData<String> deleteRecordDetail(ModelMap modelMap, Long id) {
        try {
            this.equipIssueRecordDetailService.delete((Object)new ProtectEquipIssueRecordDetail().setId(id), UserUtils.getLoginStaffId());
            return ResponseData.success((String)"\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            return ResponseData.fail((String)e.getMessage());
        }
    }

    @RequiresPermissions(value={"shield.edit"})
    @ResponseBody
    @RequestMapping(method={RequestMethod.POST}, value={"/saveRecord"})
    @BigLog(userRole=UserRoleEnum.ENTERPRISE_TYPE, actionType=ActionTypeEnum.WORK_START_TYPE, businessModule=BigLogBusinessModuleEnum.module2, businessIdParamName="keyFactoryId")
    public ResponseData<String> saveRecord(ModelMap modelMap, ProtectEquipIssueRecord record, Integer changeState, HttpServletRequest request) {
        if (record == null || changeState == null || record.getId() == null) {
            return ResponseData.fail((String)"\u7f3a\u5c11\u53c2\u6570");
        }
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        Company currentCompany = UserUtils.getCurrentCompany();
        if (changeState == 2) {
            record.setUpdateByStr(UserUtils.getLoginStaffName());
            if (currentCompany != null) {
                record.setCompanyName(currentCompany.getName());
            }
        }
        record.setCid(cid);
        record.setUpdateBy(loginStaffId);
        record.setUpdateDate(new Date());
        try {
            ActionTypeEnum actionType = ActionTypeEnum.BIZ_LOG_TYPE;
            if (changeState == 2) {
                ProtectEquipIssueRecord dbProtect = (ProtectEquipIssueRecord)this.equipIssueRecordService.getById(record.getId());
                if (dbProtect != null && Objects.equals(dbProtect.getReportState(), 1)) {
                    actionType = ActionTypeEnum.WORK_START_TYPE;
                }
                if (Objects.equals(record.getReportType(), 1)) {
                    actionType = ActionTypeEnum.WORK_END_TYPE;
                }
            }
            ProtectEquipIssueRecord issueRecord = this.equipIssueRecordService.saveOrSubmitRecord(record, changeState);
            if (changeState == 2) {
                this.baseController.passKeyFactorAuditIfTrainBase(currentCompany, UserUtils.getLoginStaff(), issueRecord.getId());
            }
            if (Objects.equals(changeState, 2) && Objects.equals(record.getReportType(), 1)) {
                this.archiveUpdateService.refreshArchive(cid, "210,410");
                this.refreshService.addBusinessDataUpdateMsg(cid, null, new ComplianceCodeEnum[]{ComplianceCodeEnum.CODE11});
            }
            this.companyGuideFinishedReportService.refreshFinishReport(Collections.singletonList(cid), NewCompanyGuideRefreshModelEnum.PERSONSHIELD, null);
            request.setAttribute("keyFactoryId", (Object)issueRecord.getKeyFactoryId());
            request.setAttribute("actionType", (Object)actionType.getValue());
            return ResponseData.success();
        }
        catch (Exception e) {
            return ResponseData.fail((String)e.getMessage());
        }
    }

    @RequiresPermissions(value={"shield.edit"})
    @ResponseBody
    @RequestMapping(method={RequestMethod.GET}, value={"/verifyData"})
    public String verifyData(ModelMap modelMap, ProtectEquipIssueRecord searchModel) {
        return this.equipIssueRecordService.verifyData(searchModel);
    }

    @RequiresPermissions(value={"shield.edit"})
    @ResponseBody
    @RequestMapping(method={RequestMethod.GET}, value={"/changeReportType"})
    public ResponseData<String> changeReportType(ModelMap modelMap, Long id, Integer reportType) {
        try {
            this.equipIssueRecordService.changeRecordReportType(id, reportType, UserUtils.getLoginStaffId());
            return ResponseData.success();
        }
        catch (Exception e) {
            return ResponseData.fail((String)e.getMessage());
        }
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/getOperateRecord"})
    @ResponseBody
    public JqGridData<KeyFactoryApprovalHistory> getOperateRecord(JqGridParam jqGridParam, KeyFactoryApprovalHistory history) {
        history.setCid(UserUtils.getLoginStaffCompanyId());
        history.setType(KeyFactoryTypeEnum.PROTECTIVE.getCode());
        PageInfo pageInfo = this.historyService.getPageOperatorHistory(jqGridParam, history);
        return new JqGridData(pageInfo, jqGridParam);
    }
}

