/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.work.servicedemand;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideByHSEService;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.entity.work.servicedemand.vo.EducationTrainServiceDemandVo;
import cn.smarthse.modules.health.entity.work.servicedemand.vo.EvaluateWorkServiceDemandVo;
import cn.smarthse.modules.health.entity.work.servicedemand.vo.HarmInspectServiceDemandVo;
import cn.smarthse.modules.health.entity.work.servicedemand.vo.HealthCheckServiceDemandVo;
import cn.smarthse.modules.health.enums.servicedemand.ServiceDemandTypeEnum;
import cn.smarthse.modules.health.service.work.servicedemand.IEducationTrainServiceDemandService;
import cn.smarthse.modules.health.service.work.servicedemand.IEvaluateWorkServiceDemandService;
import cn.smarthse.modules.health.service.work.servicedemand.IHarmInspectServiceDemandService;
import cn.smarthse.modules.health.service.work.servicedemand.IHealthCheckServiceDemandService;
import cn.smarthse.modules.health.service.work.servicedemand.IServiceDemandHarmService;
import cn.smarthse.modules.platform.model.AreaModel;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/work/servicedemand"})
public class ServiceDemandController
extends ControllerSupport {
    @DubboReference
    private IEducationTrainServiceDemandService educationTrainServiceDemandService;
    @DubboReference
    private IEvaluateWorkServiceDemandService evaluateWorkServiceDemandService;
    @DubboReference
    private IHarmInspectServiceDemandService harmInspectServiceDemandService;
    @DubboReference
    private IHealthCheckServiceDemandService healthCheckServiceDemandService;
    @DubboReference
    private IServiceDemandHarmService serviceDemandHarmService;
    @DubboReference(version="1.0.0")
    private ICompanyProvideByHSEService companyProvideByHSEService;
    @DubboReference(version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;

    @RequestMapping(value={"summaryPage"})
    public String summaryPage(ModelMap m) {
        m.put((Object)"years", (Object)this.educationTrainServiceDemandService.getServiceDemandMaxAndMinYear());
        m.put((Object)"nowYear", (Object)DateUtils.getThisYear());
        return "work/servicedemand/summaryPage";
    }

    @RequestMapping(value={"serviceDemandStatPage"})
    public String serviceDemandStatPage(ModelMap m, Integer year) {
        m.put((Object)"educationStat", (Object)this.educationTrainServiceDemandService.getServiceDemandStatVoByYear(UserUtils.getLoginStaffCompanyId(), year));
        m.put((Object)"evaluateStat", (Object)this.evaluateWorkServiceDemandService.getServiceDemandStatVoByYear(UserUtils.getLoginStaffCompanyId(), year));
        m.put((Object)"inspectStat", (Object)this.harmInspectServiceDemandService.getServiceDemandStatVoByYear(UserUtils.getLoginStaffCompanyId(), year));
        m.put((Object)"checkStat", (Object)this.healthCheckServiceDemandService.getServiceDemandStatVoByYear(UserUtils.getLoginStaffCompanyId(), year));
        return "work/servicedemand/serviceDemandStatPage";
    }

    @RequestMapping(value={"addServiceDemand"})
    public String addServiceDemand(ModelMap m, Integer type) {
        CompanyBaseInfoModel cmp = this.companyProvideByHSEService.getCompanyById(UserUtils.getLoginStaffCompanyId());
        m.put((Object)"cmp", (Object)cmp);
        if (type == 1) {
            return "work/servicedemand/addCheck";
        }
        if (type == 2) {
            return "work/servicedemand/addInspect";
        }
        if (type == 3) {
            return "work/servicedemand/addEducation";
        }
        if (type == 4) {
            return "work/servicedemand/addEvaluate";
        }
        return "";
    }

    @ResponseBody
    @RequestMapping(value={"addHealthCheckServiceDemand"})
    public ResponseData<Boolean> addHealthCheckServiceDemand(HealthCheckServiceDemandVo vo) {
        ResponseData data = new ResponseData();
        vo.setCid(UserUtils.getLoginStaffCompanyId());
        this.healthCheckServiceDemandService.addHealthCheckServiceDemand(vo, UserUtils.getLoginStaffId());
        data.setResult((Object)true);
        data.setContent("\u65b0\u589e\u6210\u529f\uff01");
        return data;
    }

    @ResponseBody
    @RequestMapping(value={"addEducationTrainServiceDemand"})
    public ResponseData<Boolean> addEducationTrainServiceDemand(EducationTrainServiceDemandVo vo) {
        ResponseData data = new ResponseData();
        vo.setCid(UserUtils.getLoginStaffCompanyId());
        this.educationTrainServiceDemandService.addEducationTrainServiceDemand(vo, UserUtils.getLoginStaffId());
        data.setResult((Object)true);
        data.setContent("\u65b0\u589e\u6210\u529f\uff01");
        return data;
    }

    @ResponseBody
    @RequestMapping(value={"addHarmInspectServiceDemand"})
    public ResponseData<Boolean> addHarmInspectServiceDemand(HarmInspectServiceDemandVo vo) {
        ResponseData data = new ResponseData();
        vo.setCid(UserUtils.getLoginStaffCompanyId());
        this.harmInspectServiceDemandService.addHarmInspectServiceDemand(vo, UserUtils.getLoginStaffId());
        data.setResult((Object)true);
        data.setContent("\u65b0\u589e\u6210\u529f\uff01");
        return data;
    }

    @ResponseBody
    @RequestMapping(value={"addEvaluateWorkServiceDemand"})
    public ResponseData<Boolean> addEvaluateWorkServiceDemand(EvaluateWorkServiceDemandVo vo) {
        ResponseData data = new ResponseData();
        vo.setCid(UserUtils.getLoginStaffCompanyId());
        this.evaluateWorkServiceDemandService.addEvaluateWorkServiceDemand(vo, UserUtils.getLoginStaffId());
        data.setResult((Object)true);
        data.setContent("\u65b0\u589e\u6210\u529f\uff01");
        return data;
    }

    @RequestMapping(value={"listPage"})
    public String listPage(ModelMap m, Integer year, Integer type, Byte state) {
        m.put((Object)"year", (Object)year);
        m.put((Object)"state", (Object)state);
        if (type == 1) {
            return "work/servicedemand/listCheckPage";
        }
        if (type == 2) {
            return "work/servicedemand/listInspectPage";
        }
        if (type == 3) {
            return "work/servicedemand/listEducationPage";
        }
        if (type == 4) {
            return "work/servicedemand/listEvaluatePage";
        }
        return "";
    }

    @ResponseBody
    @RequestMapping(value={"listCheckData"})
    public JqGridData<HealthCheckServiceDemandVo> listCheckData(JqGridParam param, Integer year, Byte state) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        PageInfo page = this.healthCheckServiceDemandService.listCheckData(param, year, state);
        JqGridData data = new JqGridData(page, param);
        return data;
    }

    @ResponseBody
    @RequestMapping(value={"listInspectData"})
    public JqGridData<HarmInspectServiceDemandVo> listInspectData(JqGridParam param, Integer year, Byte state) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        PageInfo page = this.harmInspectServiceDemandService.listInspectData(param, year, state);
        JqGridData data = new JqGridData(page, param);
        return data;
    }

    @ResponseBody
    @RequestMapping(value={"listEducationData"})
    public JqGridData<EducationTrainServiceDemandVo> listEducationData(JqGridParam param, Integer year, Byte state) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        PageInfo page = this.educationTrainServiceDemandService.listEducationData(param, year, state);
        JqGridData data = new JqGridData(page, param);
        return data;
    }

    @ResponseBody
    @RequestMapping(value={"listEvaluateData"})
    public JqGridData<EvaluateWorkServiceDemandVo> listEvaluateData(JqGridParam param, Integer year, Byte state) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        PageInfo page = this.evaluateWorkServiceDemandService.listEvaluateData(param, year, state);
        JqGridData data = new JqGridData(page, param);
        return data;
    }

    @RequestMapping(value={"editServiceDemand"})
    public String editServiceDemand(ModelMap m, Long id, Integer type) {
        if (type == 1) {
            HealthCheckServiceDemandVo vo = this.healthCheckServiceDemandService.getVoById(id);
            AreaModel am = this.sysAreaProvideService.getAreaById(vo.getLocationAreaId());
            m.put((Object)"am", (Object)am);
            m.put((Object)"vo", (Object)vo);
            return "work/servicedemand/editCheck";
        }
        if (type == 2) {
            HarmInspectServiceDemandVo vo = this.harmInspectServiceDemandService.getVoById(id);
            AreaModel am = this.sysAreaProvideService.getAreaById(vo.getLocationAreaId());
            m.put((Object)"am", (Object)am);
            m.put((Object)"vo", (Object)vo);
            return "work/servicedemand/editInspect";
        }
        if (type == 3) {
            EducationTrainServiceDemandVo vo = this.educationTrainServiceDemandService.getVoById(id);
            AreaModel am = this.sysAreaProvideService.getAreaById(vo.getLocationAreaId());
            m.put((Object)"am", (Object)am);
            m.put((Object)"vo", (Object)vo);
            return "work/servicedemand/editEducation";
        }
        if (type == 4) {
            EvaluateWorkServiceDemandVo vo = this.evaluateWorkServiceDemandService.getVoById(id);
            AreaModel am = this.sysAreaProvideService.getAreaById(vo.getLocationAreaId());
            m.put((Object)"am", (Object)am);
            m.put((Object)"vo", (Object)vo);
            return "work/servicedemand/editEvaluate";
        }
        return "";
    }

    @ResponseBody
    @RequestMapping(value={"editHealthCheckServiceDemand"})
    public ResponseData<Boolean> editHealthCheckServiceDemand(HealthCheckServiceDemandVo vo) {
        ResponseData data = new ResponseData();
        vo.setCid(UserUtils.getLoginStaffCompanyId());
        this.healthCheckServiceDemandService.editHealthCheckServiceDemand(vo, UserUtils.getLoginStaffId());
        data.setResult((Object)true);
        data.setContent("\u65b0\u589e\u6210\u529f\uff01");
        return data;
    }

    @ResponseBody
    @RequestMapping(value={"editEducationTrainServiceDemand"})
    public ResponseData<Boolean> editEducationTrainServiceDemand(EducationTrainServiceDemandVo vo) {
        ResponseData data = new ResponseData();
        vo.setCid(UserUtils.getLoginStaffCompanyId());
        this.educationTrainServiceDemandService.editEducationTrainServiceDemand(vo, UserUtils.getLoginStaffId());
        data.setResult((Object)true);
        data.setContent("\u65b0\u589e\u6210\u529f\uff01");
        return data;
    }

    @ResponseBody
    @RequestMapping(value={"editHarmInspectServiceDemand"})
    public ResponseData<Boolean> editHarmInspectServiceDemand(HarmInspectServiceDemandVo vo) {
        ResponseData data = new ResponseData();
        vo.setCid(UserUtils.getLoginStaffCompanyId());
        this.harmInspectServiceDemandService.editHarmInspectServiceDemand(vo, UserUtils.getLoginStaffId());
        data.setResult((Object)true);
        data.setContent("\u65b0\u589e\u6210\u529f\uff01");
        return data;
    }

    @ResponseBody
    @RequestMapping(value={"editEvaluateWorkServiceDemand"})
    public ResponseData<Boolean> editEvaluateWorkServiceDemand(EvaluateWorkServiceDemandVo vo) {
        ResponseData data = new ResponseData();
        vo.setCid(UserUtils.getLoginStaffCompanyId());
        this.evaluateWorkServiceDemandService.editEvaluateWorkServiceDemand(vo, UserUtils.getLoginStaffId());
        data.setResult((Object)true);
        data.setContent("\u65b0\u589e\u6210\u529f\uff01");
        return data;
    }

    @RequestMapping(value={"viewServiceDemand"})
    public String viewServiceDemand(ModelMap m, Long id, Integer type) {
        CompanyBaseInfoModel cmp = this.companyProvideByHSEService.getCompanyById(UserUtils.getLoginStaffCompanyId());
        m.put((Object)"cmp", (Object)cmp);
        if (type == 1) {
            HealthCheckServiceDemandVo vo = this.healthCheckServiceDemandService.getVoById(id);
            AreaModel am = this.sysAreaProvideService.getAreaById(vo.getLocationAreaId());
            m.put((Object)"am", (Object)am);
            m.put((Object)"vo", (Object)vo);
            return "work/servicedemand/viewCheck";
        }
        if (type == 2) {
            HarmInspectServiceDemandVo vo = this.harmInspectServiceDemandService.getVoById(id);
            AreaModel am = this.sysAreaProvideService.getAreaById(vo.getLocationAreaId());
            m.put((Object)"am", (Object)am);
            m.put((Object)"vo", (Object)vo);
            return "work/servicedemand/viewInspect";
        }
        if (type == 3) {
            EducationTrainServiceDemandVo vo = this.educationTrainServiceDemandService.getVoById(id);
            AreaModel am = this.sysAreaProvideService.getAreaById(vo.getLocationAreaId());
            m.put((Object)"am", (Object)am);
            m.put((Object)"vo", (Object)vo);
            return "work/servicedemand/viewEducation";
        }
        if (type == 4) {
            EvaluateWorkServiceDemandVo vo = this.evaluateWorkServiceDemandService.getVoById(id);
            AreaModel am = this.sysAreaProvideService.getAreaById(vo.getLocationAreaId());
            m.put((Object)"am", (Object)am);
            m.put((Object)"vo", (Object)vo);
            return "work/servicedemand/viewEvaluate";
        }
        return "";
    }

    @ResponseBody
    @RequestMapping(value={"deleteServiceDemand"})
    public ResponseData<Boolean> deleteServiceDemand(ModelMap m, Long id, Integer type) {
        Long userId = UserUtils.getLoginStaffId();
        ResponseData data = new ResponseData();
        if (type == 1) {
            this.healthCheckServiceDemandService.deleteServiceDemandById(id, userId);
        } else if (type == 2) {
            this.harmInspectServiceDemandService.deleteServiceDemandById(id, userId);
        } else if (type == 3) {
            this.educationTrainServiceDemandService.deleteServiceDemandById(id, userId);
        } else if (type == 4) {
            this.evaluateWorkServiceDemandService.deleteServiceDemandById(id, userId);
        }
        data.setResult((Object)true);
        data.setContent("\u65b0\u589e\u6210\u529f\uff01");
        return data;
    }

    @ResponseBody
    @RequestMapping(value={"offShelvesServiceDemand"})
    public ResponseData<Boolean> offShelvesServiceDemand(ModelMap m, Long id, Integer type) {
        ResponseData data = new ResponseData();
        Long userId = UserUtils.getLoginStaffId();
        if (type == 1) {
            this.healthCheckServiceDemandService.offShelvesServiceDemandById(id, userId);
        } else if (type == 2) {
            this.harmInspectServiceDemandService.offShelvesServiceDemandById(id, userId);
        } else if (type == 3) {
            this.educationTrainServiceDemandService.offShelvesServiceDemandById(id, userId);
        } else if (type == 4) {
            this.evaluateWorkServiceDemandService.offShelvesServiceDemandById(id, userId);
        }
        data.setResult((Object)true);
        data.setContent("\u65b0\u589e\u6210\u529f\uff01");
        return data;
    }

    @RequestMapping(value={"viewServiceDemandHeader"})
    public String viewServiceDemandHeader(ModelMap m) {
        m.put((Object)"types", (Object)ServiceDemandTypeEnum.values());
        return "work/servicedemand/viewServiceDemand";
    }

    @RequestMapping(value={"viewServiceDemandContent"})
    public String viewServiceDemandContent(ModelMap m, Integer type, Integer num) {
        List lists;
        List list = this.healthCheckServiceDemandService.getListByCid(UserUtils.getLoginStaffCompanyId());
        HashMap cmap = new HashMap();
        m.put((Object)"lists", lists.subList(0, (lists = ListUtils.partition(list = list.stream().filter(s -> {
            CompanyBaseInfoModel cbm = this.companyProvideByHSEService.getCompanyById(s.getCid());
            if (cbm != null) {
                if (cmap.get(cbm.getId()) == null) {
                    cmap.put(cbm.getId(), cbm);
                }
                s.setCompanyName(((CompanyBaseInfoModel)cmap.get(cbm.getId())).getName());
                s.setIndustryName(((CompanyBaseInfoModel)cmap.get(cbm.getId())).getIndustryCategoryName());
            }
            return type == null || type == s.getType().getCode();
        }).collect(Collectors.toList()), (int)4)).size() >= num ? num.intValue() : lists.size()));
        m.put((Object)"size", (Object)list.size());
        m.put((Object)"cid", (Object)UserUtils.getLoginStaffCompanyId());
        return "work/servicedemand/viewServiceDemandContent";
    }

    @RequestMapping(value={"viewServiceDemandById"})
    public String viewServiceDemandById(ModelMap m, Long id, Integer type) {
        CompanyBaseInfoModel cmp = this.companyProvideByHSEService.getCompanyById(UserUtils.getLoginStaffCompanyId());
        m.put((Object)"cmp", (Object)cmp);
        if (type == 1) {
            HealthCheckServiceDemandVo vo = this.healthCheckServiceDemandService.getVoById(id);
            AreaModel am = this.sysAreaProvideService.getAreaById(vo.getLocationAreaId());
            vo.setLocationName(am.getFullname() + vo.getLocationDetail());
            m.put((Object)"am", (Object)am);
            m.put((Object)"vo", (Object)vo);
            return "work/servicedemand/viewCheckById";
        }
        if (type == 2) {
            HarmInspectServiceDemandVo vo = this.harmInspectServiceDemandService.getVoById(id);
            AreaModel am = this.sysAreaProvideService.getAreaById(vo.getLocationAreaId());
            m.put((Object)"am", (Object)am);
            vo.setLocationName(am.getFullname() + vo.getLocationDetail());
            m.put((Object)"vo", (Object)vo);
            return "work/servicedemand/viewInspectById";
        }
        if (type == 3) {
            EducationTrainServiceDemandVo vo = this.educationTrainServiceDemandService.getVoById(id);
            AreaModel am = this.sysAreaProvideService.getAreaById(vo.getLocationAreaId());
            m.put((Object)"am", (Object)am);
            vo.setLocationName(am.getFullname() + vo.getLocationDetail());
            m.put((Object)"vo", (Object)vo);
            return "work/servicedemand/viewEducationById";
        }
        if (type == 4) {
            EvaluateWorkServiceDemandVo vo = this.evaluateWorkServiceDemandService.getVoById(id);
            AreaModel am = this.sysAreaProvideService.getAreaById(vo.getLocationAreaId());
            m.put((Object)"am", (Object)am);
            vo.setLocationName(am.getFullname() + vo.getLocationDetail());
            m.put((Object)"vo", (Object)vo);
            return "work/servicedemand/viewEvaluateById";
        }
        return "";
    }
}

