/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.work.scene;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.jqgrid.ParamSeachFieldVO;
import cn.smarthse.common.framework.mapper.HseJsonArray;
import cn.smarthse.common.framework.mapper.JsonMapper;
import cn.smarthse.common.util.leak.ResponseLeakUtil;
import cn.smarthse.modules.health.entity.standard.L07LawStandard2Relation;
import cn.smarthse.modules.health.entity.work.scene.SceneInspectionTable;
import cn.smarthse.modules.health.entity.work.scene.SceneInspectionTableCurrent;
import cn.smarthse.modules.health.entity.work.scene.SceneInspectionTableFeatures;
import cn.smarthse.modules.health.entity.work.scene.SceneInspectionTableItemCustomCurrent;
import cn.smarthse.modules.health.enums.scene.InspectionTableFeatureGroupEnum;
import cn.smarthse.modules.health.enums.scene.InspectionTableNativeCodeEnum;
import cn.smarthse.modules.health.enums.scene.InspectionTableTypeEnum;
import cn.smarthse.modules.health.enums.sys.StatusEnum;
import cn.smarthse.modules.health.service.standard.IStandardService;
import cn.smarthse.modules.health.service.work.scene.ISceneInspectionTableService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.excel.write.metadata.fill.FillConfig;
import com.alibaba.fastjson2.JSONObject;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.cn.smarthse.modules.health.exception.HealthException;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/work/scene/inspectionTable"})
public class SceneInspectionTableController
extends ControllerSupport {
    @DubboReference
    private ISceneInspectionTableService tableServcie;
    @DubboReference
    private IStandardService standardService;
    private String BASE_PATH = "work/sceneInspection/inspectionTable/";

    @Log(title="\u67e5\u770b\u68c0\u67e5\u8868\u5217\u8868", type=2)
    @RequiresPermissions(value={"inspection.view"})
    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public String list(Model model) {
        model.addAttribute("inspectionTableType", (Object)JsonMapper.toJsonString((Object)InspectionTableTypeEnum.values()));
        Long cid = UserUtils.getLoginStaffCompanyId();
        List allFeatures = this.tableServcie.getInspectionTableFeaturesAll(cid);
        model.addAttribute("allFeature", (Object)JsonMapper.toJsonString((Object)allFeatures));
        model.addAttribute("status", (Object)JsonMapper.toJsonString((Object)StatusEnum.values()));
        return this.BASE_PATH + "list";
    }

    @Log(title="\u6dfb\u52a0\u68c0\u67e5\u9879", type=20)
    @RequiresPermissions(value={"inspection.edit"})
    @RequestMapping(value={"/current/{tableId}/addCurrentTableItem"}, method={RequestMethod.GET})
    public String addCurrentTableItem(Model model, @PathVariable(value="tableId") Long tableId) {
        model.addAttribute("tableId", (Object)tableId);
        return this.BASE_PATH + "addCurrentTableItem";
    }

    @RequiresPermissions(value={"inspection.edit"})
    @ResponseBody
    @RequestMapping(value={"/current/{tableId}/addCurrentTableItem"}, method={RequestMethod.POST})
    public String saveCurrentTableItem(Model model, @PathVariable(value="tableId") Long tableId, SceneInspectionTableItemCustomCurrent entity) {
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        entity = this.tableServcie.saveCurrentTableItem(entity, loginStaffId, cid);
        ResponseData data = new ResponseData();
        data.setResult((Object)entity);
        return JsonMapper.toJsonString((Object)data);
    }

    @RequestMapping(value={"/{id}/editContents"}, method={RequestMethod.GET})
    public String tableContent(Model model, @PathVariable(value="id") Long tableId, Boolean page_editable) {
        model.addAttribute("page_editable", (Object)page_editable);
        Long cid = UserUtils.getLoginStaffCompanyId();
        SceneInspectionTable table = this.tableServcie.getTableItemCustom(tableId, cid);
        if (table == null) {
            throw new HealthException("\u68c0\u67e5\u8868\u4e22\u5931");
        }
        model.addAttribute("table", (Object)table);
        if (InspectionTableNativeCodeEnum.custom.getValue().equals(table.getTableNativeCode())) {
            return this.BASE_PATH + "tableContentCustom";
        }
        if (InspectionTableNativeCodeEnum.device.getValue().equals(table.getTableNativeCode())) {
            return this.BASE_PATH + "tableContentDevice";
        }
        if (InspectionTableNativeCodeEnum.emergencyMaterial.getValue().equals(table.getTableNativeCode())) {
            throw new HealthException("\u4e0d\u5b58\u5728\u5e94\u6025\u7269\u8d44\u68c0\u67e5\u8868");
        }
        if (InspectionTableNativeCodeEnum.reformItem.getValue().equals(table.getTableNativeCode())) {
            return this.BASE_PATH + "tableContentReform";
        }
        if (InspectionTableNativeCodeEnum.warningSigns.getValue().equals(table.getTableNativeCode())) {
            return this.BASE_PATH + "tableContentWarningSigns";
        }
        throw new HealthException("\u68c0\u67e5\u8868\u9519\u8bef");
    }

    @RequiresPermissions(value={"inspection.view"})
    @ResponseBody
    @RequestMapping(value={"/list/jqGrid/data"}, method={RequestMethod.POST})
    public JSONObject getInspectionTableData(JqGridParam param) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        PageInfo inspectionTablePageInfo = this.tableServcie.getInspectionTablePageInfo(cid, param);
        return HseJsonArray.getInstance().getFromObject((Object)inspectionTablePageInfo);
    }

    @RequiresPermissions(value={"inspection.edit"})
    @ResponseBody
    @RequestMapping(value={"/feature/comtomer"}, method={RequestMethod.POST})
    public ResponseData<SceneInspectionTableFeatures> addCustomerFeature(SceneInspectionTableFeatures feature) {
        ResponseData data = new ResponseData();
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long loginStaffId = UserUtils.getLoginStaffId();
        feature = this.tableServcie.saveCustomerFeature(feature, loginStaffId, cid);
        data.setResult((Object)feature);
        return data;
    }

    @RequiresPermissions(value={"inspection.view"})
    @ResponseBody
    @RequestMapping(value={"/{id}/item/jqGrid/data"}, method={RequestMethod.POST})
    public JSONObject getInspectionItemData(@PathVariable(value="id") Long tableId, JqGridParam param, Boolean isHideNoHiddenDenger) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        PageInfo pageInfo = this.tableServcie.getTemplateItemList(tableId, param.getPage(), param.getRows(), cid);
        return HseJsonArray.getInstance().getFromObject((Object)pageInfo);
    }

    @RequiresPermissions(value={"inspection.view"})
    @ResponseBody
    @RequestMapping(value={"/current/{id}/item/jqGrid/data"}, method={RequestMethod.POST})
    public String getInspectionCurrentItemData(@PathVariable(value="id") Long tableId, JqGridParam param, Boolean isHideNoHiddenDenger) {
        SceneInspectionTableCurrent table;
        List postDatas = param.getPostDatas();
        if (postDatas != null && !postDatas.isEmpty()) {
            String fieldValue = null;
            for (ParamSeachFieldVO vo : postDatas) {
                if (!"hideNoHiddenDenger".equals(vo.getSearchField())) continue;
                fieldValue = vo.getSearchValue();
                break;
            }
            if ("1".equals(fieldValue)) {
                isHideNoHiddenDenger = true;
            }
        }
        if ((table = this.tableServcie.getCurrentTableAndItemsById(tableId, isHideNoHiddenDenger, param.getPage(), param.getRows())) == null) {
            return "";
        }
        if (InspectionTableNativeCodeEnum.custom.getValue().equals(table.getTableNativeCode())) {
            return JsonMapper.toJsonString((Object)table.getItemCustomList());
        }
        if (InspectionTableNativeCodeEnum.device.getValue().equals(table.getTableNativeCode())) {
            return JsonMapper.toJsonString((Object)table.getItemDeviceList());
        }
        if (InspectionTableNativeCodeEnum.warningSigns.getValue().equals(table.getTableNativeCode())) {
            return JsonMapper.toJsonString((Object)table.getItemWarningSingsList());
        }
        if (InspectionTableNativeCodeEnum.reformItem.getValue().equals(table.getTableNativeCode())) {
            return JsonMapper.toJsonString((Object)table.getItemReformList());
        }
        return "";
    }

    @Log(title="\u514b\u9686\u68c0\u67e5\u8868", type=21)
    @RequiresPermissions(value={"inspection.edit"})
    @ResponseBody
    @RequestMapping(value={"/{id}/clone"}, method={RequestMethod.GET})
    public String cloneTableToCurrent(@PathVariable(value="id") Long tableId) {
        ResponseData data = new ResponseData();
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        SceneInspectionTableCurrent entity = this.tableServcie.cloneTableToCurrent(tableId, loginStaffId, cid);
        data.setResult((Object)entity);
        return JsonMapper.toJsonString((Object)data);
    }

    @RequiresPermissions(value={"inspection.view"})
    @ResponseBody
    @RequestMapping(value={"/list/complete/jqGrid/data"}, method={RequestMethod.POST})
    public JSONObject getInspectionTableDataComplete(JqGridParam param) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        PageInfo inspectionTablePageInfo = this.tableServcie.getInspectionTableCompletePageInfo(cid, param);
        return HseJsonArray.getInstance().getFromObject((Object)inspectionTablePageInfo);
    }

    @RequiresPermissions(value={"inspection.view"})
    @RequestMapping(value={"/selectFeature"}, method={RequestMethod.GET})
    public String selectFeature(Model model, String ids) {
        List allFeatures = this.tableServcie.getInspectionTableFeaturesSystemBring();
        if (StringUtils.isNotEmpty((CharSequence)ids)) {
            String[] selectIds;
            for (String id : selectIds = ids.split(",")) {
                for (SceneInspectionTableFeatures feature : allFeatures) {
                    if (!feature.getId().equals(Long.valueOf(id))) continue;
                    feature.setIsChecked(Boolean.valueOf(true));
                }
            }
        }
        model.addAttribute("range", (Object)InspectionTableFeatureGroupEnum.range);
        model.addAttribute("inspectionType", (Object)InspectionTableFeatureGroupEnum.inspectionType);
        model.addAttribute("subType", (Object)InspectionTableFeatureGroupEnum.typeSub);
        model.addAttribute("allFeatures", (Object)allFeatures);
        return this.BASE_PATH + "selectFeatureNew";
    }

    @RequiresPermissions(value={"inspection.view"})
    @RequestMapping(value={"/{tableId}"}, method={RequestMethod.GET})
    public String viewInspectionTable(Model model, @PathVariable(value="tableId") Long tableId) {
        model.addAttribute("page_editable", (Object)false);
        return this.inspectionInfo(model, tableId);
    }

    @Log(title="\u5220\u9664\u68c0\u67e5\u8868", type=22)
    @RequiresPermissions(value={"inspection.edit"})
    @ResponseBody
    @RequestMapping(value={"/{tableId}"}, method={RequestMethod.DELETE})
    public String deleteInspectionTable(@PathVariable(value="tableId") Long tableId) {
        ResponseData data = new ResponseData();
        SceneInspectionTable entity = new SceneInspectionTable();
        entity.setId(tableId);
        Long loginStaffId = UserUtils.getLoginStaffId();
        this.tableServcie.delete((Object)entity, loginStaffId);
        return JsonMapper.toJsonString((Object)data);
    }

    @Log(title="\u5220\u9664\u68c0\u67e5\u8868\u7684\u68c0\u67e5\u9879", type=22)
    @RequiresPermissions(value={"inspection.edit"})
    @ResponseBody
    @RequestMapping(value={"/currentItem/{itemId}"}, method={RequestMethod.DELETE})
    public String deleteCurrentTableItem(@PathVariable(value="itemId") Long itemId) {
        ResponseData data = new ResponseData();
        Long loginStaffId = UserUtils.getLoginStaffId();
        this.tableServcie.delCurrentTableItem(itemId, loginStaffId);
        return JsonMapper.toJsonString((Object)data);
    }

    private String inspectionInfo(Model model, Long tableId) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        SceneInspectionTable table = this.tableServcie.getTableAndItemById(tableId, cid);
        model.addAttribute("inspectionTableType", (Object)InspectionTableTypeEnum.values());
        List allFeatures = this.tableServcie.getInspectionTableFeaturesAll(cid);
        ArrayList<SceneInspectionTableFeatures> rangFeaturesList = new ArrayList<SceneInspectionTableFeatures>();
        ArrayList<SceneInspectionTableFeatures> inspectionTypeFeaturesList = new ArrayList<SceneInspectionTableFeatures>();
        for (SceneInspectionTableFeatures feature : allFeatures) {
            if (InspectionTableFeatureGroupEnum.range.getValue().equals(feature.getGroupId())) {
                rangFeaturesList.add(feature);
                continue;
            }
            if (!InspectionTableFeatureGroupEnum.inspectionType.getValue().equals(feature.getGroupId())) continue;
            inspectionTypeFeaturesList.add(feature);
        }
        model.addAttribute("allFeature", (Object)allFeatures);
        model.addAttribute("rangFeaturesList", rangFeaturesList);
        model.addAttribute("inspectionTypeFeaturesList", inspectionTypeFeaturesList);
        model.addAttribute("draff", (Object)StatusEnum.draff);
        model.addAttribute("entity", (Object)table);
        if (table != null && StatusEnum.complete.getValue().equals(table.getStatus())) {
            model.addAttribute("page_editable", (Object)false);
        }
        if (table == null) {
            return this.BASE_PATH + "inspectionTableCustom";
        }
        if (InspectionTableNativeCodeEnum.custom.getValue().equals(table.getTableNativeCode())) {
            return this.BASE_PATH + "inspectionTableCustom";
        }
        if (InspectionTableNativeCodeEnum.device.getValue().equals(table.getTableNativeCode())) {
            return this.BASE_PATH + "inspectionTableDevice";
        }
        if (InspectionTableNativeCodeEnum.emergencyMaterial.getValue().equals(table.getTableNativeCode())) {
            throw new HealthException("\u4e0d\u5b58\u5728\u5e94\u6025\u7269\u8d44\u68c0\u67e5\u8868");
        }
        if (InspectionTableNativeCodeEnum.reformItem.getValue().equals(table.getTableNativeCode())) {
            return this.BASE_PATH + "inspectionTableReform";
        }
        if (InspectionTableNativeCodeEnum.warningSigns.getValue().equals(table.getTableNativeCode())) {
            return this.BASE_PATH + "inspectionTableWarningSigns";
        }
        return this.BASE_PATH + "inspectionTableCustom";
    }

    @RequiresPermissions(value={"inspection.edit"})
    @RequestMapping(value={"/edit"}, method={RequestMethod.GET})
    public String editInspectionTable(Model model, Long tableId) {
        return this.inspectionInfo(model, tableId);
    }

    @Log(title="\u4fdd\u5b58\u68c0\u67e5\u8868\u4fe1\u606f", type=21)
    @RequiresPermissions(value={"inspection.edit"})
    @ResponseBody
    @RequestMapping(value={"/save"}, method={RequestMethod.POST})
    public String saveInspectionTableInfo(SceneInspectionTable entity, String deleteItemIds) {
        ResponseData data = new ResponseData();
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        entity = this.tableServcie.saveSceneInspectionTableInfo(entity, deleteItemIds, loginStaffId, cid);
        data.setResult((Object)entity);
        return JsonMapper.toJsonString((Object)data);
    }

    @Log(title="\u5bfc\u5165\u68c0\u67e5\u8868", type=23)
    @RequiresPermissions(value={"inspection.edit"})
    @ResponseBody
    @RequestMapping(value={"/import"}, method={RequestMethod.POST})
    public String importTableItem(String ossUrl) {
        ResponseData data = new ResponseData();
        if (StringUtils.isEmpty((CharSequence)ossUrl)) {
            data.setContent("\u4e0a\u4f20\u540e\u7684\u6587\u4ef6\u8def\u5f84\u4e22\u5931");
            data.setState(ResponseStateEnum.fail);
            return JsonMapper.toJsonString((Object)data);
        }
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        List list = this.tableServcie.getTableItemByUrlPath(this.ossClientBean.getUrl(ossUrl), loginStaffId, cid);
        data.setResult((Object)list);
        return JsonMapper.toJsonString((Object)data);
    }

    @RequiresPermissions(value={"inspection.edit"})
    @RequestMapping(value={"/importDialog"}, method={RequestMethod.GET})
    public String importDialog(Model model) {
        model.addAttribute("time", (Object)new Date().getTime());
        return "work/sceneInspection/inspectionTable/import";
    }

    @RequiresPermissions(value={"inspection.edit"})
    @RequestMapping(value={"/platform"}, method={RequestMethod.GET})
    public String platform(Model model, Long tableId) {
        model.addAttribute("tableId", (Object)tableId);
        return "work/sceneInspection/inspectionTable/platformSupport";
    }

    @RequiresPermissions(value={"inspection.edit"})
    @RequestMapping(value={"/platform/standardList"}, method={RequestMethod.GET})
    public String standardList(Model model, String searchKey) {
        List standardList = this.standardService.searchByTitleNo(searchKey);
        model.addAttribute("standardList", (Object)standardList);
        model.addAttribute("searchKey", (Object)searchKey);
        return "work/sceneInspection/inspectionTable/standardList";
    }

    @RequiresPermissions(value={"inspection.edit"})
    @RequestMapping(value={"/selectTable"}, method={RequestMethod.GET})
    public String selectTable(Model model, String searchKey) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        model.addAttribute("inspectionTableType", (Object)JsonMapper.toJsonString((Object)InspectionTableTypeEnum.values()));
        List allFeatures = this.tableServcie.getInspectionTableFeaturesAll(cid);
        model.addAttribute("allFeature", (Object)JsonMapper.toJsonString((Object)allFeatures));
        return "work/sceneInspection/inspectionTable/selectTable";
    }

    @RequiresPermissions(value={"inspection.edit"})
    @RequestMapping(value={"/platform/contents"}, method={RequestMethod.POST})
    public String standardContents(Model model, Integer pid, Integer standardId, String standardNo) {
        List list = this.standardService.getStandardContentListByStandardIdAndPid(standardId, pid);
        L07LawStandard2Relation relation = this.standardService.getL07LawStandard2RelationByPrimaryKey(pid);
        if (relation != null) {
            model.addAttribute("grandFatherId", (Object)relation.getPid());
        }
        model.addAttribute("pid", (Object)pid);
        model.addAttribute("standardId", (Object)standardId);
        model.addAttribute("standardNo", (Object)standardNo);
        model.addAttribute("contentList", (Object)list);
        return "work/sceneInspection/inspectionTable/contents";
    }

    @RequiresPermissions(value={"inspection.edit"})
    @ResponseBody
    @RequestMapping(value={"/platform/contents/jqGrid/data"}, method={RequestMethod.POST})
    public String standardContentsJQgrid(Integer id, Integer standardId) {
        if (id == null || standardId == null) {
            return "";
        }
        List list = this.standardService.getStandardContentListByStandardIdAndPidChildren(standardId, id);
        return JsonMapper.toJsonString((Object)list);
    }

    @RequiresPermissions(value={"inspection.edit"})
    @ResponseBody
    @RequestMapping(value={"/platform/addSelectContents"}, method={RequestMethod.POST})
    public ResponseData<String> addSelectContent(@RequestBody SceneInspectionTable table) {
        if (table.getItemCustomList().isEmpty()) {
            throw new HealthException("\u8bf7\u9009\u62e9\u9700\u8981\u6dfb\u52a0\u7684\u5185\u5bb9");
        }
        ResponseData data = new ResponseData();
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        this.tableServcie.addTableItems(table.getItemCustomList(), loginStaffId, cid);
        return data;
    }

    @Log(title="\u5bfc\u51fa\u68c0\u67e5\u8868", type=24)
    @RequiresPermissions(value={"inspection.view"})
    @RequestMapping(value={"/{tableId}/export"}, method={RequestMethod.GET})
    public void exportInspectionTemplateTable(@PathVariable(value="tableId") Long tableId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Long cid = UserUtils.getLoginStaffCompanyId();
        SceneInspectionTable table = this.tableServcie.getTableAndItemById(tableId, cid);
        if (table == null) {
            return;
        }
        String templateFileName = InspectionTableNativeCodeEnum.getTemplateFileName((Byte)table.getTableNativeCode());
        if (StringUtils.isEmpty((CharSequence)templateFileName)) {
            return;
        }
        String templateFilePath = super.getTemplateFilePath() + "scene/" + templateFileName;
        String resultFileName = table.getTableName() + ".xls";
        Map data = this.tableServcie.getExportDataById(tableId, cid);
        try {
            response.setContentType("application/vnd.ms-excel");
            response.setCharacterEncoding("utf-8");
            String fileName = URLEncoder.encode(resultFileName, "UTF-8").replaceAll("\\+", "%20");
            ResponseLeakUtil.setReponseFileName((HttpServletResponse)response, (String)fileName);
            FillConfig fillConfig = new FillConfig();
            fillConfig.setForceNewRow(Boolean.valueOf(true));
            ExcelWriter excelWriter = EasyExcel.write((OutputStream)response.getOutputStream()).withTemplate(templateFilePath).build();
            WriteSheet writeSheet = EasyExcel.writerSheet().build();
            excelWriter.fill((Object)data, fillConfig, writeSheet);
            excelWriter.fill(data.get("itemList"), fillConfig, writeSheet);
            excelWriter.finish();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

