/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.work.scene;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.BusinessNoTypeEnum;
import cn.smarthse.common.framework.enums.BusinessTypeEnum;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.excel.ExportExcel;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.mapper.JsonMapper;
import cn.smarthse.common.util.validation.ValidateUtil;
import cn.smarthse.modules.health.entity.work.planyear.vo.PlanYearExecute;
import cn.smarthse.modules.health.entity.work.scene.SceneInspection;
import cn.smarthse.modules.health.enums.planyear.PlanYearDetailImplState;
import cn.smarthse.modules.health.enums.reform.ReformItemLevelEnum;
import cn.smarthse.modules.health.enums.reform.ReformSourceEnum;
import cn.smarthse.modules.health.enums.scene.InspectionObjectEnum;
import cn.smarthse.modules.health.enums.scene.InspectionResultEnum;
import cn.smarthse.modules.health.enums.scene.InspectionTableTypeEnum;
import cn.smarthse.modules.health.enums.scene.InspectionTypeEnum;
import cn.smarthse.modules.health.enums.sys.ActionEnum;
import cn.smarthse.modules.health.enums.sys.StatusEnum;
import cn.smarthse.modules.health.service.base.IBusinessNoService;
import cn.smarthse.modules.health.service.base.company.ICompanyAreaService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicService;
import cn.smarthse.modules.health.service.work.scene.ISceneInspectionService;
import cn.smarthse.modules.health.service.work.scene.ISceneInspectionTableService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.controller.work.reform.ReformController;
import cn.smarthse.web.util.SyncBusinessUtil;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.cn.smarthse.modules.health.exception.ErrorEnum;
import javax.cn.smarthse.modules.health.exception.HealthException;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/work/scene/normal"})
public class SceneInspectionNormalController
extends ControllerSupport {
    @DubboReference
    private IBusinessNoService businessNoService;
    @DubboReference
    private ISceneInspectionTableService tableService;
    @DubboReference
    private ISceneInspectionService inspectionServcie;
    @DubboReference
    private ICompanyAreaService areaService;
    @Autowired
    private IStaffInfoService staffInfoService;
    @DubboReference
    private IReformItemBasicService reformService;
    @Autowired
    private ReformController reformController;

    @Log(title="\u5220\u9664\u68c0\u67e5\u4fe1\u606f", type=22)
    @RequiresPermissions(value={"inspection.edit"})
    @ResponseBody
    @RequestMapping(value={"/{inspectionId}"}, method={RequestMethod.DELETE})
    public String deleteInspection(@PathVariable(value="inspectionId") Long inspectionId) {
        ResponseData data = new ResponseData();
        SceneInspection entity = new SceneInspection();
        entity.setId(inspectionId);
        Long loginStaffId = UserUtils.getLoginStaffId();
        this.inspectionServcie.delete((Object)entity, loginStaffId);
        PlanYearExecute execute = new PlanYearExecute();
        execute.setBusinessId(entity.getId());
        execute.setBusinessType(BusinessTypeEnum.sceneInspection.getCode());
        execute.setCid(UserUtils.getLoginStaffCompanyId());
        execute.setImplState(PlanYearDetailImplState.unimplemented);
        SyncBusinessUtil.executeUpdatePlanYearDetail(execute);
        return JsonMapper.toJsonString((Object)data);
    }

    @RequiresPermissions(value={"inspection.view"})
    @RequestMapping(value={"/unfinished"}, method={RequestMethod.GET})
    public String unfinished(Model model, String inspectionType, Integer year) {
        String path;
        if (StringUtils.isEmpty((CharSequence)inspectionType)) {
            inspectionType = InspectionObjectEnum.inspectionType2.name();
        }
        String name = "";
        if (InspectionObjectEnum.inspectionTypeSuper.name().equals(inspectionType)) {
            name = "\u4e0a\u7ea7\u76d1\u7763\u68c0\u67e5";
            path = "work/sceneInspection/normalInspection/unfinishedSuper";
        } else {
            name = "\u9690\u60a3\u6392\u67e5";
            path = "work/sceneInspection/normalInspection/unfinished";
        }
        model.addAttribute("name", (Object)name);
        model.addAttribute("year", (Object)year);
        model.addAttribute("inspectionType", (Object)inspectionType);
        return path;
    }

    @Log(title="\u83b7\u53d6\u5df2\u5b8c\u6210\u68c0\u67e5\u5217\u8868", type=2)
    @RequiresPermissions(value={"inspection.view"})
    @RequestMapping(value={"/count/purchase"}, method={RequestMethod.GET})
    public String finished(Model model, String inspectionType0S, Byte inspectionType1S, Integer year) {
        model.addAttribute("inspectionTypes", (Object)InspectionObjectEnum.inspectionTypeAll.getValue());
        model.addAttribute("inspectionType1", (Object)InspectionObjectEnum.inspectionType1.getValue());
        model.addAttribute("year", (Object)year);
        if (StringUtils.isNotBlank((CharSequence)inspectionType0S)) {
            model.addAttribute("inspectionType0S", (Object)inspectionType0S);
        }
        if (inspectionType1S != null) {
            model.addAttribute("inspectionType1S", (Object)inspectionType1S);
        }
        return "work/sceneInspection/normalInspection/finished";
    }

    @Log(title="\u4fdd\u5b58\u68c0\u67e5\u6570\u636e", type=21)
    @RequiresPermissions(value={"inspection.edit"})
    @ResponseBody
    @RequestMapping(value={"/save"}, method={RequestMethod.POST})
    public String save(SceneInspection entity) {
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long orgId = UserUtils.getOrgId();
        if (entity == null) {
            throw new HealthException(ErrorEnum.PARAMETER_ERROR);
        }
        entity.setOrgId(orgId);
        entity = InspectionTypeEnum.isSuperiorsType((Byte)entity.getInspectionType()) ? this.inspectionServcie.saveInspectionSuperiors(entity, loginStaffId, cid) : this.inspectionServcie.saveInspection(entity, loginStaffId, cid);
        PlanYearExecute execute = new PlanYearExecute();
        execute.setBusinessId(entity.getId());
        execute.setBusinessType(BusinessTypeEnum.sceneInspection.getCode());
        execute.setCid(cid);
        execute.setImplManagerId(entity.getInspectionDirector());
        execute.setImplStartDate(entity.getInspectionActualTime());
        execute.setImplWorkName(entity.getWorkName());
        if (StatusEnum.finished.getValue().equals(entity.getStatus())) {
            execute.setImplState(PlanYearDetailImplState.implemented);
        } else {
            execute.setImplState(PlanYearDetailImplState.progressing);
        }
        SyncBusinessUtil.executeUpdatePlanYearDetail(execute);
        ResponseData data = new ResponseData();
        data.setResult((Object)entity);
        return JsonMapper.toJsonString((Object)data);
    }

    private String goToInspectionNormal(Model model, SceneInspection entity, Long cid) {
        JqGridParam param = new JqGridParam();
        param.setRows(1);
        param.setPage(1);
        boolean hasInspectionTable = this.tableService.hasTables(cid);
        model.addAttribute("hasInspectionTable", (Object)hasInspectionTable);
        Integer areaCount = this.areaService.getAreaCountByCid(cid);
        boolean hasArea = areaCount != null && areaCount >= 1;
        model.addAttribute("hasArea", (Object)hasArea);
        Integer staffCount = this.staffInfoService.getStaffCountByCid(cid, Boolean.valueOf(false));
        boolean hasStaff = staffCount != null && staffCount >= 1;
        model.addAttribute("hasStaff", (Object)hasStaff);
        model.addAttribute("entity", (Object)entity);
        model.addAttribute("inspectioType1Enum", (Object)InspectionObjectEnum.inspectionType1.getValue());
        model.addAttribute("inspectionType", (Object)InspectionObjectEnum.inspectionType2.getValue());
        return "work/sceneInspection/normalInspection/inspectionInfo";
    }

    private String goToSuperInspection(Model model, SceneInspection entity) {
        JqGridParam param = new JqGridParam();
        param.setRows(1);
        param.setPage(1);
        model.addAttribute("entity", (Object)entity);
        model.addAttribute("inspectionResults", (Object)InspectionResultEnum.values());
        model.addAttribute("inspectioType1Enum", (Object)InspectionObjectEnum.inspectionType1.getValue());
        model.addAttribute("inspectionType", (Object)InspectionObjectEnum.inspectionType2.getValue());
        model.addAttribute("reformItemLevel", (Object)JsonMapper.toJsonString((Object)ReformItemLevelEnum.values()));
        model.addAttribute("reformItemSource", (Object)JsonMapper.toJsonString((Object)ReformSourceEnum.values()));
        model.addAttribute("sourceType", (Object)ReformSourceEnum.supervise.getValue());
        return "work/sceneInspection/normalInspection/superInspectionInfo";
    }

    @RequiresPermissions(value={"inspection.view"})
    @RequestMapping(value={"/superInspection"}, method={RequestMethod.GET})
    public String superInspection(Model model, Long inspectionId) {
        SceneInspection entity = (SceneInspection)this.inspectionServcie.getById(inspectionId);
        Long cid = UserUtils.getLoginStaffCompanyId();
        if (entity == null || inspectionId == null) {
            entity = new SceneInspection();
            String businessNo = this.businessNoService.getBusinessNo(cid, BusinessNoTypeEnum.HIDDEN_DANGER_INSPECTION.getCode());
            entity.setInspectionNo(businessNo);
            entity.setInspectionType1(InspectionTableTypeEnum.occupationalHelath.getValue() + ",");
            entity.setInspectionType(InspectionTypeEnum.superiorsInspect.getValue());
            model.addAttribute("actionStatus", (Object)ActionEnum.add);
        }
        return this.goRealInspectionPage(model, entity, cid);
    }

    private String goRealInspectionPage(Model model, SceneInspection entity, Long cid) {
        if (entity == null) {
            throw new HealthException(ErrorEnum.PARAMETER_ERROR);
        }
        if (StatusEnum.finished.getValue().equals(entity.getStatus())) {
            if (!UserUtils.isSuperAdmin()) {
                model.addAttribute("page_editable", (Object)false);
                model.addAttribute("actionStatus", (Object)ActionEnum.view);
                model.addAttribute("finished", (Object)true);
            } else {
                model.addAttribute("finishedEdit", (Object)true);
            }
        }
        if (InspectionTypeEnum.isSuperiorsType((Byte)entity.getInspectionType())) {
            return this.goToSuperInspection(model, entity);
        }
        return this.goToInspectionNormal(model, entity, cid);
    }

    @ResponseBody
    @RequestMapping(value={"/validate"}, method={RequestMethod.POST})
    public ResponseData<String> ValidateReformItemAcceptanceRecord(SceneInspection entity) {
        ResponseData data = new ResponseData();
        if (InspectionTypeEnum.isSuperiorsType((Byte)entity.getInspectionType())) {
            ValidateUtil.valid((Object)entity, (String)"superiors");
        } else {
            ValidateUtil.valid((Object)entity, (String)"add");
        }
        boolean isComplete = this.reformService.isCompleteForSource(entity.getId(), true);
        if (!isComplete) {
            data.setContent("\u6709\u9690\u60a3\u672a\u5b8c\u6210\uff0c\u8bf7\u5148\u786e\u4fdd\u9690\u60a3\u4fe1\u606f\u5df2\u5b8c\u6210\uff01");
            data.setState(ResponseStateEnum.fail);
        }
        return data;
    }

    @RequiresPermissions(value={"inspection.view"})
    @RequestMapping(value={"/view/{inspectionId}"}, method={RequestMethod.GET})
    public String viewInspection(Model model, @PathVariable(value="inspectionId") Long inspectionId) {
        SceneInspection entity = (SceneInspection)this.inspectionServcie.getById(inspectionId);
        model.addAttribute("page_editable", (Object)false);
        model.addAttribute("actionStatus", (Object)ActionEnum.view);
        Long cid = UserUtils.getLoginStaffCompanyId();
        return this.goRealInspectionPage(model, entity, cid);
    }

    @RequiresPermissions(value={"inspection.edit"})
    @RequestMapping(value={"/edit"}, method={RequestMethod.GET})
    public String editInspection(Model model, Long inspectionId) {
        SceneInspection entity = (SceneInspection)this.inspectionServcie.getById(inspectionId);
        Long cid = UserUtils.getLoginStaffCompanyId();
        if (entity == null || inspectionId == null) {
            entity = new SceneInspection();
            String businessNo = this.businessNoService.getBusinessNo(cid, BusinessNoTypeEnum.HIDDEN_DANGER_INSPECTION.getCode());
            entity.setInspectionNo(businessNo);
            entity.setInspectionType1(InspectionTableTypeEnum.occupationalHelath.getValue() + ",");
            model.addAttribute("actionStatus", (Object)ActionEnum.add);
        } else {
            model.addAttribute("actionStatus", (Object)ActionEnum.edit);
        }
        return this.goRealInspectionPage(model, entity, cid);
    }

    @RequiresPermissions(value={"inspection.view"})
    @ResponseBody
    @RequestMapping(value={"/unfinished/{inspectionType}/jqGrid/data"}, method={RequestMethod.POST})
    public PageInfo<SceneInspection> unfinishedJqGridData(JqGridParam param, @PathVariable(value="inspectionType") String inspectionType, Integer year) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        UserUtils.startWebDataScope();
        PageInfo pageInfo = inspectionType.equals(InspectionObjectEnum.inspectionTypeSuper.name()) ? this.inspectionServcie.getPageUnfinishedInspectionSuperiors(cid, param) : this.inspectionServcie.getPageUnfinishedInspection(cid, param, year);
        return pageInfo;
    }

    @RequiresPermissions(value={"inspection.view"})
    @ResponseBody
    @RequestMapping(value={"/finished/jqGrid/data"}, method={RequestMethod.POST})
    public PageInfo<SceneInspection> finishedJqGridData(JqGridParam param, Integer year) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        UserUtils.startWebDataScope();
        PageInfo pageInfo = this.inspectionServcie.getPagefinishedInspection(cid, param, year);
        return pageInfo;
    }

    @RequiresPermissions(value={"inspection.view"})
    @Log(title="\u5bfc\u51fa\u9690\u60a3\u6392\u67e5\u5df2\u5b8c\u6210\u6e05\u5355", type=24)
    @RequestMapping(value={"/finished/export"}, method={RequestMethod.GET})
    public void technologyProcessExport(HttpServletResponse response, Integer year) throws Exception {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String fileName = "\u5df2\u5b8c\u6210\u9690\u60a3\u6392\u67e5\u6e05\u5355" + dateFormat.format(new Date()) + ".xls";
        String[] colums = new String[]{"\u5e8f\u53f7|export_index", "\u5de5\u4f5c\u540d\u79f0|workName", "\u68c0\u67e5\u65f6\u95f4|inspectionActualTime", "\u68c0\u67e5\u7c7b\u578b|inspectionTypeName", "\u68c0\u67e5\u8303\u56f4|inspectionRangesName", "\u8d1f\u8d23\u4eba|inspectionDirectorName", "\u5b8c\u6210\u65f6\u95f4|updateDateStr"};
        Long cid = UserUtils.getLoginStaffCompanyId();
        UserUtils.startWebDataScope();
        List list = this.inspectionServcie.getFinishedList(cid, null, year);
        response.setHeader("Content-Disposition", "attachment;filename=" + new String(fileName.getBytes("GBK"), "ISO8859_1"));
        response.setContentType("application/octet-stream; charset=GBK");
        ExportExcel listexcel = new ExportExcel();
        listexcel.simpleExport2("\u5df2\u5b8c\u6210\u9690\u60a3\u6392\u67e5\u6e05\u5355", colums, list, (OutputStream)response.getOutputStream());
    }
}

