/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.work.reform;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.redis.RedisClient;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.framework.encrypt.annotation.ApiEncrypt;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideByHSEService;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.bx.entity.BxRiskReport;
import cn.smarthse.modules.health.bx.service.IBxRiskReportService;
import cn.smarthse.modules.health.entity.work.reform.ReformCheckMeasure;
import cn.smarthse.modules.health.entity.work.reform.ReformItemAcceptanceRecord;
import cn.smarthse.modules.health.entity.work.reform.ReformItemBasic;
import cn.smarthse.modules.health.entity.work.reform.param.RiskListSearch;
import cn.smarthse.modules.health.entity.work.reform.vo.ReformAcceptRecordEditVo;
import cn.smarthse.modules.health.entity.work.reform.vo.ReformAcceptRecordViewVo;
import cn.smarthse.modules.health.entity.work.reform.vo.ReformItemBasicView;
import cn.smarthse.modules.health.entity.work.reform.vo.ReformTableListVo;
import cn.smarthse.modules.health.entity.work.reform.vo.RiskInfoDataVo;
import cn.smarthse.modules.health.entity.work.reform.vo.RiskListItemDataVo;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveService;
import cn.smarthse.modules.health.service.work.check.checkV3221.IPhcPhysicalStaffCheckInfoService;
import cn.smarthse.modules.health.service.work.reform.IReformItemAcceptanceRecordService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicNewService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicService;
import cn.smarthse.modules.health.service.work.reform.IReformItemSourceService;
import cn.smarthse.modules.health.vo.litearchive.ZjArchiveCountView;
import cn.smarthse.modules.health.vo.summary.ReformSearchVo;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/riskResolution"})
public class RiskResolutionController
extends ControllerSupport {
    @DubboReference(version="1.0.0")
    private ICompanyProvideByHSEService companyProvideByHSEService;
    @DubboReference
    private IReformItemBasicService reformItemBasicService;
    @DubboReference
    private IPhcPhysicalStaffCheckInfoService phcPhysicalStaffCheckInfoService;
    @DubboReference
    private IReformItemSourceService reformItemSourceService;
    @DubboReference
    private IReformItemAcceptanceRecordService acceptanceRecordService;
    @DubboReference(timeout=5000000)
    private ISysFileProvideService fileService;
    @DubboReference
    private ILiteArchiveService liteArchiveService;
    @DubboReference
    private IReformItemBasicNewService reformItemBasicNewService;
    @DubboReference(check=false)
    private IBxRiskReportService bxRiskReportService;
    @Autowired
    RedisClient redisClient;

    @RequiresPermissions(value={"reformItem.view"})
    @GetMapping(value={"/keyList", "/abnormalList", "/otherList"})
    public String toIndex1(ModelMap m, RiskListSearch search) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        CompanyBaseInfoModel company = this.companyProvideByHSEService.getCompanyById(cid);
        int newCompanyState = Objects.equals(company.getDataSource(), 11) ? (Objects.equals(company.getIsDec(), true) ? 2 : 1) : 0;
        m.put((Object)"newCompanyState", (Object)newCompanyState);
        m.put((Object)"search", (Object)search);
        m.put((Object)"cid", (Object)cid);
        return "views/riskMitigationManagement/riskList";
    }

    @RequiresPermissions(value={"reformItem.view"})
    @GetMapping(value={"/key2List", "/other2List"})
    public String toIndex2(ModelMap m, RiskListSearch search) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        CompanyBaseInfoModel company = this.companyProvideByHSEService.getCompanyById(cid);
        int newCompanyState = Objects.equals(company.getDataSource(), 11) ? (Objects.equals(company.getIsDec(), true) ? 2 : 1) : 0;
        m.put((Object)"newCompanyState", (Object)newCompanyState);
        m.put((Object)"search", (Object)search);
        m.put((Object)"cid", (Object)cid);
        return "views/riskMitigationManagement/pilot2025/riskList";
    }

    @RequiresPermissions(value={"reformItem.view"})
    @GetMapping(value={"/indexGuideNewCompany"})
    public String toIndex3(ModelMap m, RiskListSearch search) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        CompanyBaseInfoModel company = this.companyProvideByHSEService.getCompanyById(cid);
        int newCompanyState = Objects.equals(company.getDataSource(), 11) ? (Objects.equals(company.getIsDec(), true) ? 2 : 1) : 0;
        m.put((Object)"newCompanyState", (Object)newCompanyState);
        m.put((Object)"search", (Object)search);
        m.put((Object)"cid", (Object)cid);
        return "views/riskMitigationManagement/newCompanyGuide/riskList";
    }

    @GetMapping(value={"forwardIndex"})
    public String forwardIndex(ModelMap m, String name) {
        Integer searchSource = null;
        if (StringUtils.isNotBlank((CharSequence)name)) {
            switch (name) {
                case "jccb": {
                    searchSource = 3;
                    break;
                }
                case "jjz": {
                    searchSource = 4;
                    break;
                }
                case "yszyb": {
                    searchSource = 5;
                    break;
                }
                case "jccbzg": {
                    searchSource = 21;
                    break;
                }
            }
        }
        return "redirect:/riskResolution/abnormalList&searchSource=" + searchSource;
    }

    @RequestMapping(value={"getRiskListData"}, method={RequestMethod.GET})
    @ResponseBody
    public PageInfo<RiskListItemDataVo> getRiskListData(JqGridParam param, RiskListSearch search, Integer searchType) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        search.setCid(cid);
        PageInfo pageInfo = this.reformItemBasicService.getRiskListDataPage(param, search, Boolean.valueOf(true), searchType);
        if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            List<String> cardIds = pageInfo.getList().stream().filter(item -> item != null && Arrays.asList(4, 5).contains(item.getGenerationSource().intValue()) && StringUtils.isNotBlank((CharSequence)item.getTjBusinessId())).map(RiskListItemDataVo::getTjBusinessId).sorted(Comparator.reverseOrder()).toList();
            if (CollectionUtils.isEmpty(cardIds)) {
                return pageInfo;
            }
            Map map = (Map)this.redisClient.get("phcPhysicalCheckV3221Service", "getCompanyNameDif:" + cardIds.hashCode() + ":" + cid, 3600L, () -> this.phcPhysicalStaffCheckInfoService.getCompanyNameDif(cardIds, cid));
            if (MapUtils.isEmpty((Map)map)) {
                return pageInfo;
            }
            pageInfo.getList().forEach(item -> {
                if (item == null) {
                    return;
                }
                if (Arrays.asList(4, 5).contains(item.getGenerationSource().intValue())) {
                    item.setOutpackName((String)map.get(item.getTjBusinessId()));
                }
            });
        }
        return pageInfo;
    }

    @GetMapping(value={"/getReformItemBasicCountView"})
    @ResponseBody
    public ResponseData<ReformItemBasicView> getReformItemBasicCountView(ReformSearchVo searchVo) {
        searchVo.setCid(UserUtils.getLoginStaffCompanyId());
        List countViewList = this.reformItemBasicNewService.getReformItemBasicCountView(searchVo);
        if (CollectionUtils.isEmpty((Collection)countViewList)) {
            ReformItemBasicView basicView = new ReformItemBasicView();
            basicView.setCid(searchVo.getCid());
            basicView.setHasRisks(Boolean.valueOf(false));
            basicView.setKeyListCount(Integer.valueOf(0));
            basicView.setAbnormalListCount(Integer.valueOf(0));
            return new ResponseData((Object)basicView);
        }
        return new ResponseData((Object)((ReformItemBasicView)countViewList.get(0)));
    }

    @GetMapping(value={"/riskInfo"})
    public String riskInfo(ModelMap m, RiskListSearch search) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        m.put((Object)"cid", (Object)cid);
        m.put((Object)"search", (Object)search);
        ReformItemBasic reform = (ReformItemBasic)this.reformItemBasicService.getById(search.getId());
        List generationSourceValueList = this.reformItemBasicService.getGenerationSourceValue();
        if (!generationSourceValueList.contains(reform.getGenerationSource())) {
            reform.setGenerationSourceStr("\u5176\u4ed6");
        }
        m.put((Object)"reform", (Object)reform);
        if (Objects.equals(reform.getGenerationSource().intValue(), 18)) {
            int thisYear = DateUtils.getYear((Date)reform.getFindTime());
            ZjArchiveCountView view = (ZjArchiveCountView)this.liteArchiveService.getArchiveData(cid).get(thisYear);
            m.put((Object)"archive", (Object)view);
        }
        return "views/riskMitigationManagement/riskInfo";
    }

    @GetMapping(value={"/detailView", "/riskInfoGuideNewCompany"})
    public String detailView(ModelMap m, RiskListSearch search) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        m.put((Object)"cid", (Object)cid);
        m.put((Object)"search", (Object)search);
        RiskListSearch search2 = new RiskListSearch();
        search2.setId(search.getId());
        search2.setCid(cid);
        List riskListData = this.reformItemBasicService.getRiskListData(search2, null);
        if (CollectionUtils.isNotEmpty((Collection)riskListData) && riskListData.get(0) != null) {
            RiskListItemDataVo reform = (RiskListItemDataVo)riskListData.get(0);
            m.put((Object)"reform", (Object)reform);
            if (Objects.equals(reform.getGenerationSource().intValue(), 18)) {
                int thisYear = DateUtils.getYear((Date)reform.getFindTime());
                ZjArchiveCountView view = (ZjArchiveCountView)this.liteArchiveService.getArchiveData(cid).get(thisYear);
                m.put((Object)"archive", (Object)view);
            }
        }
        return "views/riskMitigationManagement/pilot2025/riskInfo";
    }

    @ResponseBody
    @RequestMapping(value={"getAllRiskInfoList"})
    public ResponseData getAllRiskInfoList(Long id) {
        ReformItemBasic reform = (ReformItemBasic)this.reformItemBasicService.getById(id);
        if (reform == null) {
            return ResponseData.fail((String)"\u672a\u627e\u5230\u6570\u636e");
        }
        if (DateUtils.getYear((Date)reform.getFindTime()) <= 2023) {
            return ResponseData.success((Object)this.reformItemBasicService.getReformItemSourceListView(reform, Integer.valueOf(1)));
        }
        return ResponseData.success((Object)this.reformItemSourceService.getReformItemSourceListView(Collections.singletonList(id)));
    }

    @ResponseBody
    @GetMapping(value={"/getRiskInfo"})
    public ResponseData<RiskInfoDataVo> getRiskInfo(RiskListSearch search) {
        ResponseData responseData = new ResponseData();
        search.setCid(UserUtils.getLoginStaffCompanyId());
        ReformItemBasic reform = this.reformItemBasicService.getMultipleDataSourceBySearch(search);
        RiskInfoDataVo vo = new RiskInfoDataVo();
        BeanUtils.copyProperties((Object)reform, (Object)vo);
        responseData.setResult((Object)vo);
        return responseData;
    }

    @ResponseBody
    @GetMapping(value={"/getRiskListInfo"})
    public ResponseData<ReformItemBasic> getRiskListInfo(RiskListSearch search) {
        ResponseData responseData = new ResponseData();
        ReformItemBasic reform = (ReformItemBasic)this.reformItemBasicService.getById(search.getId());
        if (reform == null) {
            responseData.setResult((Object)reform);
        } else {
            if (reform.getReformItemFiles() != null) {
                List files = this.fileService.getListByIds(reform.getReformItemFiles());
                reform.setReformItemFileList(files);
            }
            if (search.getAcceptanceId() != null && reform.getAceptanceList() != null && !reform.getAceptanceList().isEmpty()) {
                for (int i = 0; i < reform.getAceptanceList().size(); ++i) {
                    if (!search.getAcceptanceId().equals(((ReformItemAcceptanceRecord)reform.getAceptanceList().get(i)).getId())) continue;
                    reform.setAcceptance((ReformItemAcceptanceRecord)reform.getAceptanceList().get(i));
                    break;
                }
            }
            if (reform.getAcceptance() != null && reform.getAcceptance().getReformFinishedFiles() != null) {
                String fileIds = reform.getAcceptance().getReformFinishedFiles();
                List files = this.fileService.getListByIds(fileIds);
                reform.setFinishFileList(files);
            }
            responseData.setResult((Object)reform);
        }
        return responseData;
    }

    @RequiresPermissions(value={"reformItem.edit"})
    @ResponseBody
    @RequestMapping(value={"/saveGenerationAcce"}, method={RequestMethod.POST})
    @Log(title="\u4fdd\u5b58\u6574\u6539\u4fe1\u606f", type=21)
    @ApiEncrypt(request=true)
    public ResponseData<ReformItemBasic> saveGenerationAcce(@RequestBody ReformItemBasic reformItem) {
        try {
            reformItem.setCid(UserUtils.getLoginStaffCompanyId());
            return ResponseData.success((Object)this.reformItemBasicNewService.saveGenerationAccToHes(reformItem, UserUtils.getLoginStaffId(), null));
        }
        catch (Exception e) {
            return ResponseData.fail((String)e.getMessage());
        }
    }

    @GetMapping(value={"/tabList"})
    @ResponseBody
    public ResponseData<List<ReformTableListVo>> tabList(Long reformId) {
        ReformItemBasic reform = (ReformItemBasic)this.reformItemBasicService.getById(reformId);
        List aceptanceList = reform.getAceptanceList();
        List list = aceptanceList.stream().map(item -> {
            ReformTableListVo vo = new ReformTableListVo();
            vo.setLabel("\u6574\u6539\u53ca\u9a8c\u6536\u8bb0\u5f55" + String.valueOf(aceptanceList.indexOf(item) == 0 ? "" : Integer.valueOf(aceptanceList.indexOf(item))));
            vo.setValue(item.getId());
            return vo;
        }).collect(Collectors.toList());
        ResponseData data = new ResponseData();
        data.setResult(list);
        return data;
    }

    @GetMapping(value={"/viewAcceptRecord"})
    @ResponseBody
    public ResponseData<ReformAcceptRecordViewVo> viewAcceptRecord(Long reformId, Long acceptanceId) {
        try {
            return ResponseData.success((Object)this.reformItemBasicNewService.getReformAcceptanceRecordToHse(reformId, acceptanceId, null));
        }
        catch (Exception e) {
            return ResponseData.fail((String)e.getMessage());
        }
    }

    @GetMapping(value={"/editAcceptRecord"})
    @ResponseBody
    @ApiEncrypt(response=true)
    public ResponseData<ReformAcceptRecordEditVo> editAcceptRecord(Long reformId, Long acceptanceId) {
        try {
            ReformAcceptRecordViewVo record = this.reformItemBasicNewService.getReformAcceptanceRecordToHse(reformId, acceptanceId, null);
            ReformAcceptRecordEditVo vo = new ReformAcceptRecordEditVo();
            BeanUtils.copyProperties((Object)record, (Object)vo);
            return ResponseData.success((Object)vo);
        }
        catch (Exception e) {
            return ResponseData.fail((String)e.getMessage());
        }
    }

    @GetMapping(value={"/getCheckMeasureFactorNameList"})
    @ResponseBody
    public ResponseData<List<String>> getCheckMeasureFactorNameList(Long acceptanceId) {
        try {
            return ResponseData.success((Object)this.acceptanceRecordService.getCheckMeasureFactorNameList(acceptanceId));
        }
        catch (Exception e) {
            return ResponseData.fail();
        }
    }

    @ResponseBody
    @RequestMapping(value={"getBxRiskReportInfo"}, method={RequestMethod.GET})
    public ResponseData<BxRiskReport> getBxRiskReportInfo(Long id) {
        return ResponseData.success((Object)this.bxRiskReportService.getBxRiskReportInfo(id, null));
    }

    @RequestMapping(value={"getReformCheckMeasureList"}, method={RequestMethod.GET})
    @ResponseBody
    public PageInfo<ReformCheckMeasure> getReformCheckMeasureList(JqGridParam jqGridParam, ReformCheckMeasure checkMeasure) {
        checkMeasure.setCid(UserUtils.getLoginStaffCompanyId());
        checkMeasure.setIsBackFileModel(Boolean.valueOf(true));
        return this.acceptanceRecordService.getPageReformCheckMeasureList(jqGridParam, checkMeasure);
    }

    @PostMapping(value={"/saveReformCheckMeasure"})
    @ResponseBody
    public ResponseData<ReformCheckMeasure> saveReformCheckMeasure(ReformCheckMeasure checkMeasure) {
        try {
            Long cid = UserUtils.getLoginStaffCompanyId();
            Long loginStaffId = UserUtils.getLoginStaffId();
            checkMeasure.setCid(cid);
            checkMeasure.setUpdateBy(loginStaffId);
            checkMeasure.setUpdateDate(new Date());
            ReformCheckMeasure measure = this.acceptanceRecordService.updateReformCheckMeasureByDetail(checkMeasure);
            return ResponseData.success((Object)measure);
        }
        catch (Exception e) {
            return ResponseData.fail((String)e.getMessage());
        }
    }

    @GetMapping(value={"/showReformCheckMeasure"})
    @ResponseBody
    public ResponseData<ReformCheckMeasure> showReformCheckMeasure(Long checkMeasureId) {
        try {
            List measureList = this.acceptanceRecordService.getReformCheckMeasureList(new ReformCheckMeasure().setId(checkMeasureId));
            if (CollectionUtils.isEmpty((Collection)measureList)) {
                return ResponseData.success();
            }
            return ResponseData.success((Object)((ReformCheckMeasure)measureList.get(0)));
        }
        catch (Exception e) {
            return ResponseData.fail((String)e.getMessage());
        }
    }

    @PostMapping(value={"/deleteReformCheckMeasure"})
    @ResponseBody
    public ResponseData<ReformCheckMeasure> deleteReformCheckMeasure(Long id) {
        ResponseData data = new ResponseData();
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long loginStaffId = UserUtils.getLoginStaffId();
        Integer i = this.acceptanceRecordService.deleteReformCheckMeasure(id);
        if (i > 0) {
            data.setState(ResponseStateEnum.success);
            data.setContent("\u5220\u9664\u6210\u529f");
        } else {
            data.setState(ResponseStateEnum.fail);
            data.setContent("\u5220\u9664\u5931\u8d25");
        }
        return data;
    }

    @GetMapping(value={"/getOverFourMonthRisk"})
    @ResponseBody
    public ResponseData<List<Byte>> getOverFourMonthRisk() {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Map overFourMonthRisk = this.reformItemBasicNewService.getOverFourMonthRisk(String.valueOf(cid));
        return ResponseData.success((Object)((List)overFourMonthRisk.get(cid)));
    }

    @ResponseBody
    @RequestMapping(value={"/autoAcceptance"})
    public String autoAcceptance(final String cids) throws Exception {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    RiskResolutionController.this.reformItemBasicService.autoAcceptance(cids);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
        return "\u81ea\u52a8\u9a8c\u6536\u5b8c\u6210";
    }

    @GetMapping(value={"/deleteReform"})
    @ResponseBody
    public ResponseData deleteReform(String cidList, String generationSources, String idList) {
        this.reformItemBasicNewService.deleteReform(StringUtils.parseToLongList((String)cidList, (String)","), StringUtils.parseToByteList((String)generationSources, (String)","), StringUtils.parseToLongList((String)idList, (String)","));
        return ResponseData.success();
    }

    @ResponseBody
    @RequestMapping(value={"/threeTimeStatusChange"})
    public String threeTimeStatusChange(final String cids) throws Exception {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    RiskResolutionController.this.reformItemBasicService.threeTimeStatusChange(cids);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
        return "\u4e09\u540c\u65f6\u98ce\u9669\u72b6\u6001\u4fee\u6539\u72b6\u6001\u66f4\u6539\u5b8c\u6210";
    }

    @ResponseBody
    @RequestMapping(value={"/autoGenDeclReform"})
    public String autoGenDeclReform(final String cids) throws Exception {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    RiskResolutionController.this.reformItemBasicService.autoGenDeclReform(cids);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
        return "\u4f01\u4e1a\u7533\u62a5\u98ce\u9669\u751f\u6210\uff0c\u5206\u7c7b\u5bf9\u8c61\u4f46\u662f\u4e0d\u662f\u7533\u62a5\u4f01\u4e1a\u7684\uff082023\u4eca\u5e74\u4e34\u65f6\u4f7f\u7528\uff09\u5b8c\u6210";
    }

    @ResponseBody
    @RequestMapping(value={"/autoGenKeyFactorReform"})
    public String autoGenKeyFactorReform(final String cids) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                RiskResolutionController.this.reformItemBasicService.autoGenKeyFactorReform(cids);
            }
        }).start();
        return "\u81ea\u52a8\u751f\u6210\u5173\u952e\u56e0\u7d20\u753b\u50cf\u6574\u6539\u5b8c\u6210";
    }

    @ResponseBody
    @RequestMapping(value={"/onlyFileAcceptReformAfterTwoMonth"})
    public String onlyFileAcceptReformAfterTwoMonth(final String cids) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                RiskResolutionController.this.reformItemBasicNewService.onlyFileAcceptReformAfterTwoMonth(cids);
            }
        }).start();
        return "\u81ea\u52a8\u751f\u6210\u5173\u952e\u56e0\u7d20\u753b\u50cf\u6574\u6539\u5b8c\u6210";
    }

    @GetMapping(value={"/divideBatchGenKeyReform"})
    @ResponseBody
    public String divideBatchGenKeyReform(String cids, Byte generationSource, Integer year, Byte dataSource) {
        if (StringUtils.isEmpty((CharSequence)cids) || generationSource == null || year == null || dataSource == null) {
            return "\u4f01\u4e1aid\u4e0d\u80fd\u4e3a\u7a7a";
        }
        this.reformItemBasicNewService.divideBatchGenKeyReform(StringUtils.parseToLongList((String)cids), generationSource, year, dataSource);
        return "\u751f\u6210\u753b\u50cf\u98ce\u9669--\u5355\u72ec\u5b8c\u6210" + generationSource;
    }
}

