/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.work.reform;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.entity.work.reform.ReformItemAcceptanceRecord;
import cn.smarthse.modules.health.entity.work.reform.ReformItemBasic;
import cn.smarthse.modules.health.entity.work.reform.param.RiskListSearch;
import cn.smarthse.modules.health.entity.work.reform.vo.ReformAcceptRecordViewVo;
import cn.smarthse.modules.health.entity.work.reform.vo.ReformTableListVo;
import cn.smarthse.modules.health.entity.work.reform.vo.RiskInfoDataVo;
import cn.smarthse.modules.health.entity.work.reform.vo.RiskListItemDataVo;
import cn.smarthse.modules.health.service.litearchive.ILiteArchiveService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicNewService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicService;
import cn.smarthse.modules.health.thirdOrganization.entity.org.ThirdOrganization;
import cn.smarthse.modules.health.thirdOrganization.service.org.IThirdOrganizationService;
import cn.smarthse.modules.health.vo.litearchive.ZjArchiveCountView;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletRequest;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/work/risk"})
public class RiskController
extends ControllerSupport {
    @DubboReference
    private IReformItemBasicService reformItemBasicService;
    @DubboReference
    private IReformItemBasicNewService reformItemBasicNewService;
    @DubboReference
    private IReformItemBasicService reformService;
    @DubboReference(timeout=5000000)
    private ISysFileProvideService fileService;
    @DubboReference
    private ILiteArchiveService liteArchiveService;
    @DubboReference
    private IThirdOrganizationService thirdOrganizationService;

    @RequiresPermissions(value={"assistManage"})
    @RequestMapping(value={"index"}, method={RequestMethod.GET})
    public String index(ModelMap m, RiskListSearch search) {
        m.put((Object)"search", (Object)search);
        boolean hasReformEdit = UserUtils.hasPermissionCode("reformItem.edit");
        m.put((Object)"hasReformEdit", (Object)hasReformEdit);
        return "views/riskMitigationManagement/township/riskList";
    }

    @RequiresPermissions(value={"reformItem.view"})
    @RequestMapping(value={"getRiskListData"}, method={RequestMethod.GET})
    @ResponseBody
    public PageInfo<RiskListItemDataVo> getRiskListData(JqGridParam param, RiskListSearch search) {
        UserUtils.startWebDataScope();
        search.setCid(UserUtils.getLoginStaffCompanyId());
        PageInfo townShipRiskListData = this.reformItemBasicService.getTownShipRiskListData(param, search);
        return townShipRiskListData;
    }

    @GetMapping(value={"/riskInfo"})
    public String riskInfo(ModelMap m, RiskListSearch search) {
        m.put((Object)"search", (Object)search);
        boolean hasReformEdit = UserUtils.hasPermissionCode("reformItem.edit");
        m.put((Object)"hasReformEdit", (Object)hasReformEdit);
        ReformItemBasic reform = (ReformItemBasic)this.reformItemBasicService.getById(search.getId());
        List generationSourceValueList = this.reformItemBasicService.getGenerationSourceValue();
        if (!generationSourceValueList.contains(reform.getGenerationSource())) {
            reform.setGenerationSourceStr("\u5176\u4ed6");
        }
        m.put((Object)"reform", (Object)reform);
        if (Objects.equals(reform.getGenerationSource().intValue(), 18)) {
            Long cid = UserUtils.getLoginStaffCompanyId();
            ZjArchiveCountView view = this.liteArchiveService.getZjArchiveCountViewByCid(cid);
            m.put((Object)"archive", (Object)view);
        }
        return "work/riskResolution/riskInfo";
    }

    @ResponseBody
    @RequestMapping(value={"getAllRiskInfoList"})
    public ResponseData<List<ReformItemBasic>> getAllRiskInfoList(Long id) {
        ResponseData responseData = new ResponseData();
        ReformItemBasic reform = (ReformItemBasic)this.reformItemBasicService.getById(id);
        if (reform == null) {
            return responseData;
        }
        List list = this.reformItemBasicService.getReformItemSourceList(reform, Integer.valueOf(2));
        responseData.setResult((Object)list);
        return responseData;
    }

    @ResponseBody
    @GetMapping(value={"/getRiskInfo"})
    public ResponseData<RiskInfoDataVo> getRiskInfo(RiskListSearch search) {
        ResponseData responseData = new ResponseData();
        search.setCid(UserUtils.getLoginStaffCompanyId());
        ReformItemBasic reform = (ReformItemBasic)this.reformService.getById(search.getId());
        RiskInfoDataVo vo = new RiskInfoDataVo();
        BeanUtils.copyProperties((Object)reform, (Object)vo);
        responseData.setResult((Object)vo);
        return responseData;
    }

    @ResponseBody
    @GetMapping(value={"/getRiskListInfo"})
    public ResponseData<ReformItemBasic> getRiskListInfo(RiskListSearch search) {
        ResponseData responseData = new ResponseData();
        ReformItemBasic reform = (ReformItemBasic)this.reformService.getById(search.getId());
        if (reform == null) {
            responseData.setResult((Object)reform);
        } else {
            if (reform.getReformItemFiles() != null) {
                List files = this.fileService.getListByIds(reform.getReformItemFiles());
                reform.setReformItemFileList(files);
            }
            if (search.getAcceptanceId() != null && reform.getAceptanceList() != null && !reform.getAceptanceList().isEmpty()) {
                for (int i = 0; i < reform.getAceptanceList().size(); ++i) {
                    if (!search.getAcceptanceId().equals(((ReformItemAcceptanceRecord)reform.getAceptanceList().get(i)).getId())) continue;
                    reform.setAcceptance((ReformItemAcceptanceRecord)reform.getAceptanceList().get(i));
                    break;
                }
            }
            if (reform.getAcceptance() != null && reform.getAcceptance().getReformFinishedFiles() != null) {
                String fileIds = reform.getAcceptance().getReformFinishedFiles();
                List files = this.fileService.getListByIds(fileIds);
                reform.setFinishFileList(files);
            }
            responseData.setResult((Object)reform);
        }
        return responseData;
    }

    @RequiresPermissions(value={"reformItem.edit"})
    @ResponseBody
    @RequestMapping(value={"/saveAcceptanceRecord"}, method={RequestMethod.POST})
    @Log(title="\u4fdd\u5b58\u6574\u6539\u4fe1\u606f", type=21)
    public ResponseData<ReformItemAcceptanceRecord> saveAcceptanceRecord(ReformItemAcceptanceRecord record, HttpServletRequest request) {
        ResponseData res = new ResponseData();
        Long cid = UserUtils.getLoginStaffCompanyId();
        record.setCid(cid);
        Long loginStaffId = UserUtils.getLoginStaffId();
        String[] finishedFile = request.getParameterValues("fileIds");
        if (finishedFile != null && finishedFile.length > 0) {
            String fileIds = StringUtils.convertArrayToString((String[])finishedFile, (String)",");
            record.setReformFinishedFiles(fileIds);
        }
        res.setResult((Object)record);
        return res;
    }

    @RequiresPermissions(value={"reformItem.edit"})
    @ResponseBody
    @RequestMapping(value={"/saveGenerationAcce"}, method={RequestMethod.POST})
    @Log(title="\u4fdd\u5b58\u6574\u6539\u4fe1\u606f", type=21)
    public ResponseData<ReformItemBasic> saveGenerationAcce(ReformItemBasic reformItem, HttpServletRequest request) {
        String reformDirectorName;
        ThirdOrganization thirdOrganization;
        ReformItemBasic basic;
        ResponseData res = new ResponseData();
        Long cid = UserUtils.getLoginStaffCompanyId();
        reformItem.setCid(cid);
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long orgId = UserUtils.getOrgId();
        String[] finishedFile = request.getParameterValues("files");
        if (finishedFile != null && finishedFile.length > 0) {
            String fileIds = StringUtils.convertArrayToString((String[])finishedFile, (String)",");
            reformItem.getAcceptance().setReformFinishedFiles(fileIds);
        }
        if ((basic = (ReformItemBasic)this.reformService.getById(reformItem.getId())) == null) {
            res.setState(ResponseStateEnum.fail);
            res.setResult((Object)reformItem);
            res.setContent("\u672a\u67e5\u8be2\u5230\u6574\u6539\u4fe1\u606f\uff0c\u6574\u6539\u5931\u8d25\uff01");
            return res;
        }
        ReformItemAcceptanceRecord acceptance = reformItem.getAcceptance();
        if (acceptance != null && StringUtils.isNotEmpty((String)acceptance.getReformDirectorName()) && (thirdOrganization = this.thirdOrganizationService.getByName(reformDirectorName = acceptance.getReformDirectorName())) != null) {
            res.setState(ResponseStateEnum.fail);
            res.setResult((Object)reformItem);
            res.setContent("\u6574\u6539\u8d1f\u8d23\u4eba\u4e0d\u80fd\u4e3a\u68c0\u6d4b\u673a\u6784\uff0c\u8bf7\u91cd\u65b0\u586b\u5199");
            return res;
        }
        Date findTime = basic.getFindTime();
        if (findTime != null) {
            Date date = DateUtils.addDay((Date)findTime, (int)60);
            basic.getAcceptance().setRequireFinishTime(date);
        }
        if (basic.getStatus() != null && (basic.getStatus().intValue() == 0 || basic.getStatus().intValue() == 1 || basic.getStatus().intValue() == 5)) {
            this.reformService.saveGenerationReform(reformItem, loginStaffId);
        } else {
            res.setState(ResponseStateEnum.fail);
        }
        res.setResult((Object)reformItem);
        return res;
    }

    @GetMapping(value={"/tabList"})
    @ResponseBody
    public ResponseData<List<ReformTableListVo>> tabList(Long reformId) {
        ReformItemBasic reform = (ReformItemBasic)this.reformItemBasicService.getById(reformId);
        List aceptanceList = reform.getAceptanceList();
        List list = aceptanceList.stream().map(item -> {
            ReformTableListVo vo = new ReformTableListVo();
            vo.setLabel("\u6574\u6539\u53ca\u9a8c\u6536\u8bb0\u5f55" + String.valueOf(aceptanceList.indexOf(item) == 0 ? "" : Integer.valueOf(aceptanceList.indexOf(item))));
            vo.setValue(item.getId());
            return vo;
        }).collect(Collectors.toList());
        ResponseData data = new ResponseData();
        data.setResult(list);
        return data;
    }

    @GetMapping(value={"/acceptanceRecord"})
    @ResponseBody
    public ResponseData<ReformAcceptRecordViewVo> reformAcceptanceRecord(Long reformId, Long acceptanceId) {
        List files;
        ResponseData data = new ResponseData();
        ReformAcceptRecordViewVo vo = new ReformAcceptRecordViewVo();
        ReformItemBasic reform = (ReformItemBasic)this.reformItemBasicService.getById(reformId);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        if (acceptanceId != null && reform.getAceptanceList() != null && !reform.getAceptanceList().isEmpty()) {
            for (int i = 0; i < reform.getAceptanceList().size(); ++i) {
                if (!acceptanceId.equals(((ReformItemAcceptanceRecord)reform.getAceptanceList().get(i)).getId())) continue;
                reform.setAcceptance((ReformItemAcceptanceRecord)reform.getAceptanceList().get(i));
                break;
            }
        }
        if (reform.getAcceptance() != null && reform.getAcceptance().getAcceptanceFiles() != null) {
            String fileIds = reform.getAcceptance().getAcceptanceFiles();
            files = this.fileService.getListByIds(fileIds);
            reform.getAcceptance().setAcceptanceFilesList(files);
        }
        if (reform.getAcceptance() != null && reform.getAcceptance().getReformFinishedFiles() != null) {
            String fileIds = reform.getAcceptance().getReformFinishedFiles();
            files = this.fileService.getListByIds(fileIds);
            reform.getAcceptance().setReformFinishedFilesList(files);
        }
        ReformItemAcceptanceRecord acc = reform.getAcceptance();
        vo.setId(acceptanceId);
        vo.setReformDirector(acc.getReformDirectorName());
        vo.setReformMeasure(StringEscapeUtils.unescapeHtml((String)acc.getReformMeasure()));
        Date findTime = reform.getFindTime();
        if (findTime != null) {
            Date date = DateUtils.addDay((Date)findTime, (int)60);
            vo.setRequireFinishTime(date);
        }
        vo.setReformFinishedFilesList(acc.getReformFinishedFilesList());
        vo.setStatus(acc.getStatus());
        vo.setActualFinishTime(acc.getActualFinishTime());
        vo.setFindTime(reform.getFindTime());
        vo.setDealMeasure(acc.getDealMeasure());
        vo.setDealMeasureName(acc.getDealMeasureName());
        vo.setThirdOrgId(acc.getThirdOrgId());
        vo.setThirdOrgName(acc.getThirdOrgName());
        vo.setDealTimeBegin(Objects.nonNull(acc.getDealTimeBegin()) ? sdf.format(acc.getDealTimeBegin()) : "");
        vo.setAcceptanceDirectorName(acc.getAcceptanceDirectorName());
        vo.setAcceptanceDate(acc.getAcceptanceDate());
        vo.setAcceptanceFileList(acc.getAcceptanceFilesList());
        vo.setAcceptanceResult(acc.getAcceptanceResult());
        vo.setAcceptanceResultExplain(acc.getAcceptanceResultExplain());
        data.setResult((Object)vo);
        return data;
    }
}

