/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.work.reform;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.BusinessNoTypeEnum;
import cn.smarthse.common.framework.enums.BusinessTypeEnum;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.excel.ExportExcel;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.jqgrid.ParamSeachFieldVO;
import cn.smarthse.common.framework.mapper.HseJsonArray;
import cn.smarthse.common.framework.mapper.JsonMapper;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.PageUtil;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.validation.ValidateUtil;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.entity.work.reform.CheckPlanReformItem;
import cn.smarthse.modules.health.entity.work.reform.ReformItemAcceptanceRecord;
import cn.smarthse.modules.health.entity.work.reform.ReformItemBasic;
import cn.smarthse.modules.health.entity.work.reform.vo.ReformItemFinishedSeniorSearch;
import cn.smarthse.modules.health.entity.work.reform.vo.ReformItemListVo;
import cn.smarthse.modules.health.entity.work.trusteeship.TrusteeshipInfo;
import cn.smarthse.modules.health.entity.work.trusteeship.TrusteeshipInfoDetail;
import cn.smarthse.modules.health.enums.reform.AcceptanceResultEnum;
import cn.smarthse.modules.health.enums.reform.ReformItemHarmFactorStatusEnum;
import cn.smarthse.modules.health.enums.reform.ReformItemLevelEnum;
import cn.smarthse.modules.health.enums.reform.ReformItemTypeEnum;
import cn.smarthse.modules.health.enums.reform.ReformSourceEnum;
import cn.smarthse.modules.health.enums.reform.ReformSourceLiteEnum;
import cn.smarthse.modules.health.enums.sys.ActionEnum;
import cn.smarthse.modules.health.enums.sys.StatusEnum;
import cn.smarthse.modules.health.service.base.IBusinessNoService;
import cn.smarthse.modules.health.service.base.company.ICompanyAreaService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.work.reform.ICheckPlanReformItemService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicService;
import cn.smarthse.modules.health.service.work.reform.IReformProgrammeService;
import cn.smarthse.modules.health.service.work.trusteeship.ITrusteeshipInfoDetailService;
import cn.smarthse.modules.health.service.work.trusteeship.ITrusteeshipInfoService;
import cn.smarthse.modules.health.util.ReformItemUtil;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.alibaba.fastjson2.JSONObject;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.cn.smarthse.modules.health.exception.HealthException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/work/reform"})
@Deprecated(since="\u6574\u6539\u7ba1\u7406\u2014\u2014\u65e7\u7248,\u5e94\u8be5\u662f\u6ca1\u6709\u4f7f\u7528\uff0c\u4f46\u662f\u4e0d\u786e\u5b9a\u524d\u7aef\uff0c\u6240\u6709\u6ca1\u6709\u5904\u7406")
public class ReformController
extends ControllerSupport {
    @DubboReference
    private IBusinessNoService businessNoService;
    @DubboReference
    private IReformItemBasicService reformService;
    @DubboReference
    private ICheckPlanReformItemService checkPlanReformItemService;
    @DubboReference
    private ICompanyAreaService areaService;
    @DubboReference
    private IStaffInfoService staffService;
    @DubboReference(timeout=5000000)
    private ISysFileProvideService fileService;
    @DubboReference
    private IReformProgrammeService reformProgrammeService;
    @DubboReference(timeout=60000)
    private ITrusteeshipInfoDetailService trusteeshipInfoDetailService;
    @DubboReference(timeout=60000)
    private ITrusteeshipInfoService trusteeshipInfoService;

    @Log(title="\u83b7\u53d6\u8fdb\u884c\u4e2d\u7684\u6574\u6539\u5217\u8868", type=2)
    @RequiresPermissions(value={"reformItem.view"})
    @RequestMapping(value={"/unfinished"}, method={RequestMethod.GET})
    public String unfinished(Model model, Byte sourceType, Integer overTime, Byte status) {
        model.addAttribute("overTime", (Object)overTime);
        model.addAttribute("sourceType", (Object)sourceType);
        model.addAttribute("status", (Object)status);
        model.addAttribute("reformItemLevel", (Object)JsonMapper.toJsonString((Object)ReformItemLevelEnum.values()));
        if ("true".equals(this.isActualize)) {
            model.addAttribute("reformItemSource", (Object)JsonMapper.toJsonString((Object)ReformSourceEnum.values()));
        } else {
            model.addAttribute("reformItemSource", (Object)JsonMapper.toJsonString((Object)ReformSourceLiteEnum.values()));
        }
        model.addAttribute("loginStaffId", (Object)UserUtils.getLoginStaffId());
        return "work/reform/unfinished";
    }

    @RequiresPermissions(value={"reformItem.view"})
    @RequestMapping(value={"/sourceType/{sourceType}/sourceId/{sourceId}"}, method={RequestMethod.GET})
    public String inspectionList(Model model, @PathVariable(value="sourceId") Long sourceId, @PathVariable(value="sourceType") Byte sourceType, String action, String sourceNo) {
        model.addAttribute("reformItemLevel", (Object)JsonMapper.toJsonString((Object)ReformItemLevelEnum.values()));
        model.addAttribute("reformItemSource", (Object)JsonMapper.toJsonString((Object)ReformSourceEnum.values()));
        model.addAttribute("sourceId", (Object)sourceId);
        model.addAttribute("sourceType", (Object)sourceType);
        model.addAttribute("sourceNo", (Object)sourceNo);
        if (StringUtils.isNotEmpty((String)action) && ActionEnum.view.getCode().equals(action)) {
            model.addAttribute("page_editable", (Object)false);
        } else {
            model.addAttribute("page_editable", (Object)true);
        }
        return "work/reform/reformListBySource";
    }

    @Log(title="\u83b7\u53d6\u6574\u6539\u5b8c\u6210\u5217\u8868", type=2)
    @RequiresPermissions(value={"reformItem.view"})
    @RequestMapping(value={"/finished"}, method={RequestMethod.GET})
    public String finished(Model model, Integer year, Byte sourceType) {
        model.addAttribute("reformItemLevel", (Object)ReformItemLevelEnum.values());
        model.addAttribute("reformItemSource", (Object)ReformSourceEnum.values());
        model.addAttribute("year", (Object)year);
        model.addAttribute("sourceType", (Object)sourceType);
        return "work/reform/finished";
    }

    @RequiresPermissions(value={"reformItem.view"})
    @RequestMapping(value={"/finished/harmFactor"}, method={RequestMethod.GET})
    public String finishedHarmFactor(Model model) {
        model.addAttribute("reformItemLevel", (Object)ReformItemLevelEnum.values());
        model.addAttribute("reformItemSource", (Object)ReformSourceEnum.values());
        return "work/reform/selectFinishedForHarmFactor";
    }

    @Log(title="\u6574\u6539\u67e5\u770b", type=2)
    @RequiresPermissions(value={"reformItem.view"})
    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET})
    public String view(Model model, @PathVariable(value="id") Long reformId, String action) {
        model.addAttribute("page_editable", (Object)false);
        model.addAttribute("action", (Object)action);
        ReformItemBasic reform = (ReformItemBasic)this.reformService.getById(reformId);
        this.setModelInfo(reform, model, reformId, null, null, false);
        model.addAttribute("page_editable", (Object)false);
        return "work/reform/basicEdit";
    }

    @RequiresPermissions(value={"reformItem.edit"})
    @ResponseBody
    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE})
    @Log(title="\u9690\u60a3\u6392\u67e5\u6574\u6539\u9879\u76ee-\u5220\u9664", type=22)
    public String delete(Model model, @PathVariable(value="id") Long reformId) {
        ReformItemBasic entity = new ReformItemBasic();
        entity.setId(reformId);
        this.reformService.deleteByIdAndBusinessType(reformId, UserUtils.getLoginStaffId(), BusinessTypeEnum.reform);
        return "" + ResponseStateEnum.success.getValue();
    }

    @RequiresPermissions(value={"reformItem.edit", "hccheckplan.edit"}, logical=Logical.OR)
    @ResponseBody
    @RequestMapping(value={"/{id}/harmfactor"}, method={RequestMethod.DELETE})
    public String deleteHarmfactor(Model model, @PathVariable(value="id") Long reformId) {
        ReformItemBasic entity = new ReformItemBasic();
        entity.setId(reformId);
        this.reformService.deleteByIdAndBusinessType(reformId, UserUtils.getLoginStaffId(), BusinessTypeEnum.hccheckplan);
        return "" + ResponseStateEnum.success.getValue();
    }

    @Log(title="\u5220\u9664\u6574\u6539\u9879\u4fe1\u606f", type=22)
    @RequiresPermissions(value={"reformItem.edit"})
    @ResponseBody
    @RequestMapping(value={"/{id}/reformSource/{businessType}"}, method={RequestMethod.DELETE})
    public String deleteFormSourceModule(Model model, @PathVariable(value="id") Long reformId, @PathVariable(value="businessType") Byte businessType) {
        this.reformService.deleteByIdAndBusinessType(reformId, UserUtils.getLoginStaffId(), ReformSourceEnum.getBusinessTypeByValue((Byte)businessType));
        return "" + ResponseStateEnum.success.getValue();
    }

    @Log(title="\u7f16\u8f91\u6574\u6539\u4e0e\u9a8c\u6536\u4fe1\u606f", type=21)
    @RequiresPermissions(value={"reformItem.view"})
    @RequestMapping(value={"/{id}/acceptance"}, method={RequestMethod.GET})
    public String acceptanceEdit(Model model, @PathVariable(value="id") Long reformId, Long acceptanceId, String action) {
        ReformItemBasic reform;
        ReformItemAcceptanceRecord entity;
        block15: {
            block14: {
                entity = null;
                reform = (ReformItemBasic)this.reformService.getById(reformId);
                if (acceptanceId != null) break block14;
                if (reform != null && !reform.getAceptanceList().isEmpty() && !StatusEnum.complete.getValue().equals(((ReformItemAcceptanceRecord)reform.getAceptanceList().get(reform.getAceptanceList().size() - 1)).getStatus())) {
                    entity = (ReformItemAcceptanceRecord)reform.getAceptanceList().get(reform.getAceptanceList().size() - 1);
                    entity.setReformItemBasic(reform);
                    acceptanceId = entity.getId();
                }
                if (acceptanceId != null) break block15;
                entity = new ReformItemAcceptanceRecord();
                entity.setReformItemId(reformId);
                entity.setStatus(StatusEnum.draff.getValue());
                entity.setReformItemBasic(reform);
                entity.getReformItemBasic().getAceptanceList().add(entity);
                break block15;
            }
            if (reform.getAceptanceList() != null && !reform.getAceptanceList().isEmpty()) {
                for (ReformItemAcceptanceRecord record : reform.getAceptanceList()) {
                    if (!acceptanceId.equals(record.getId())) continue;
                    entity = record;
                    entity.setReformItemBasic(reform);
                    break;
                }
            }
        }
        model.addAttribute("entityId", (Object)acceptanceId);
        this.setHasBuildingAndAreaInfo(model);
        if (StatusEnum.finished.getValue().equals(entity.getReformItemBasic().getBusinessStatus())) {
            model.addAttribute("finished", (Object)true);
        }
        Byte draffValue = StatusEnum.draff.getValue();
        Byte completeValue = StatusEnum.complete.getValue();
        boolean canEdit = this.isCanbeEdit(entity, action);
        if (reform.getReformItemSourceId() == null) {
            canEdit = true;
        }
        if (ActionEnum.view.getCode().equals(action)) {
            canEdit = false;
        }
        boolean basicEdit = false;
        boolean acceptEdit = false;
        boolean isFirstAcceptance = false;
        if (canEdit) {
            if (reform.getIsProcess() != null && reform.getIsProcess().booleanValue()) {
                if (StatusEnum.draff.getValue().equals(entity.getStatus())) {
                    basicEdit = true;
                    completeValue = StatusEnum.reformAboutComplete.getValue();
                } else if (StatusEnum.reformAboutComplete.getValue().equals(entity.getStatus())) {
                    acceptEdit = true;
                    draffValue = StatusEnum.reformAboutComplete.getValue();
                    completeValue = StatusEnum.complete.getValue();
                }
                if (reform != null && reform.getAceptanceList() != null && reform.getAceptanceList().size() > 0) {
                    isFirstAcceptance = ((ReformItemAcceptanceRecord)reform.getAceptanceList().get(0)).getId().equals(acceptanceId);
                }
                if (!basicEdit && !acceptEdit) {
                    canEdit = false;
                }
            } else {
                basicEdit = true;
                acceptEdit = true;
            }
        }
        model.addAttribute("basicEdit", (Object)basicEdit);
        model.addAttribute("acceptEdit", (Object)acceptEdit);
        model.addAttribute("requireFinishTimeEdit", (Object)(basicEdit && !isFirstAcceptance ? 1 : 0));
        model.addAttribute("draffValue", (Object)draffValue);
        model.addAttribute("completeValue", (Object)completeValue);
        model.addAttribute("page_editable", (Object)canEdit);
        model.addAttribute("entity", (Object)entity);
        model.addAttribute("action", (Object)action);
        model.addAttribute("acceptanceResult", (Object)AcceptanceResultEnum.values());
        return "work/reform/acceptance";
    }

    private void setHasBuildingAndAreaInfo(Model model) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        boolean hasBuilding = false;
        Integer areaCount = this.areaService.getBuildingCount(cid);
        if (areaCount != null && areaCount > 0) {
            hasBuilding = true;
        }
        boolean hasStaff = false;
        Integer staffCount = this.staffService.getStaffInfoCountByCid(cid);
        if (staffCount != null && staffCount > 0) {
            hasStaff = true;
        }
        model.addAttribute("hasBuilding", (Object)hasBuilding);
        model.addAttribute("hasStaff", (Object)hasStaff);
    }

    private boolean isCanbeEdit(ReformItemAcceptanceRecord entity, String action) {
        if (entity == null || entity.getId() == null) {
            return true;
        }
        if (ActionEnum.view.getCode().equals(action)) {
            return false;
        }
        ReformItemBasic reformItem = entity.getReformItemBasic();
        if (reformItem != null && StatusEnum.finished.getValue().equals(reformItem.getBusinessStatus())) {
            return false;
        }
        boolean isCanbeEdit = true;
        if (StatusEnum.complete.getValue().equals(entity.getStatus())) {
            isCanbeEdit = false;
        } else if (reformItem.getReformItemSourceId() != null) {
            isCanbeEdit = true;
        }
        if (entity.getId().equals(((ReformItemAcceptanceRecord)reformItem.getAceptanceList().get(reformItem.getAceptanceList().size() - 1)).getId())) {
            isCanbeEdit = true;
        }
        return isCanbeEdit;
    }

    @RequiresPermissions(value={"reformItem.edit"})
    @ResponseBody
    @RequestMapping(value={"/{id}/acceptance/{acceptanceId}"}, method={RequestMethod.DELETE})
    @Log(title="\u5220\u9664\u6574\u6539\u4e0e\u9a8c\u6536", type=22)
    public ResponseData<String> acceptanceDelete(@PathVariable(value="acceptanceId") Long acceptanceId) {
        ResponseData data = new ResponseData();
        Long loginStaffId = UserUtils.getLoginStaffId();
        this.reformService.deleteAcceptanceRecord(acceptanceId, loginStaffId);
        return data;
    }

    @Log(title="\u7f16\u8f91\u6574\u6539\u9884\u9a8c\u6536\u6570\u636e", type=21)
    @RequiresPermissions(value={"reformItem.edit"})
    @RequestMapping(value={"/{id}/acceptanceSuper"}, method={RequestMethod.GET})
    public String acceptanceSuperEdit(Model model, @PathVariable(value="id") Long reformId, Long acceptanceId) {
        ReformItemAcceptanceRecord entity = null;
        ReformItemBasic reform = (ReformItemBasic)this.reformService.getById(reformId);
        if (!StatusEnum.finished.getValue().equals(reform.getBusinessStatus())) {
            throw new HealthException("\u975e\u6cd5\u8bf7\u6c42\uff0c\u975e\u5b8c\u6210\u4e1a\u52a1");
        }
        if (!UserUtils.isSuperAdmin()) {
            throw new HealthException("\u975e\u6cd5\u8bf7\u6c42,\u975e\u8d85\u7ea7\u7ba1\u7406\u5458");
        }
        boolean isLast = false;
        if (acceptanceId != null && reform.getAceptanceList() != null && !reform.getAceptanceList().isEmpty()) {
            for (int i = 0; i < reform.getAceptanceList().size(); ++i) {
                if (!acceptanceId.equals(((ReformItemAcceptanceRecord)reform.getAceptanceList().get(i)).getId())) continue;
                entity = (ReformItemAcceptanceRecord)reform.getAceptanceList().get(i);
                entity.setReformItemBasic(reform);
                if (i != reform.getAceptanceList().size() - 1) break;
                isLast = true;
                break;
            }
            for (ReformItemAcceptanceRecord reformItemAcceptanceRecord : reform.getAceptanceList()) {
            }
        }
        if (entity == null) {
            entity = new ReformItemAcceptanceRecord();
            entity.setId(acceptanceId);
            entity.setReformItemId(reform.getId());
            entity.setReformItemBasic(reform);
            if (reform.getAceptanceList() != null) {
                reform.getAceptanceList().add(entity);
            }
            isLast = true;
        }
        model.addAttribute("isLast", (Object)isLast);
        model.addAttribute("entityId", (Object)acceptanceId);
        this.setHasBuildingAndAreaInfo(model);
        model.addAttribute("finished", (Object)true);
        model.addAttribute("isEditSuper", (Object)true);
        model.addAttribute("page_editable", (Object)true);
        model.addAttribute("entity", (Object)entity);
        model.addAttribute("acceptanceResult", (Object)AcceptanceResultEnum.values());
        return "work/reform/acceptanceSuperEdit";
    }

    @Log(title="\u4fdd\u5b58\u6574\u6539\u9884\u9a8c\u6536\u6570\u636e", type=21)
    @RequiresPermissions(value={"reformItem.edit"})
    @ResponseBody
    @RequestMapping(value={"/{id}/acceptance"}, method={RequestMethod.POST})
    public JSONObject acceptanceSave(ReformItemAcceptanceRecord entity, String statusType) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long loginStaffId = UserUtils.getLoginStaffId();
        entity = this.reformService.saveReformItemAcceptanceRecord(entity, loginStaffId, cid, statusType);
        ResponseData data = new ResponseData();
        data.setResult((Object)entity);
        return HseJsonArray.getInstance().getFromObject((Object)data);
    }

    @Log(title="\u4fdd\u5b58\u6574\u6539\u9884\u9a8c\u6536\u6570\u636e", type=21)
    @RequiresPermissions(value={"reformItem.edit"})
    @ResponseBody
    @RequestMapping(value={"/{id}/acceptanceSuper"}, method={RequestMethod.POST})
    public JSONObject acceptanceSaveSuper(ReformItemAcceptanceRecord entity, String statusType) {
        if (!UserUtils.isSuperAdmin()) {
            throw new HealthException("\u975e\u6cd5\u8bf7\u6c42");
        }
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long loginStaffId = UserUtils.getLoginStaffId();
        entity.setStatus(StatusEnum.complete.getValue());
        entity = this.reformService.saveAcceptanceRecordOnly(entity, loginStaffId, cid, statusType);
        ResponseData data = new ResponseData();
        data.setResult((Object)entity);
        return HseJsonArray.getInstance().getFromObject((Object)data);
    }

    @ResponseBody
    @RequestMapping(value={"/{id}/acceptance/validate"}, method={RequestMethod.POST})
    public ResponseData<String> ValidateReformItemAcceptanceRecord(ReformItemAcceptanceRecord reformItem) {
        ResponseData data = new ResponseData();
        if (reformItem.getReformDirector() != null) {
            reformItem.setReformDirectorName(this.staffService.getStaffNameByStaffId(reformItem.getReformDirector()));
        }
        if (reformItem.getAcceptanceDirector() != null) {
            reformItem.setAcceptanceDirectorName(this.staffService.getStaffNameByStaffId(reformItem.getAcceptanceDirector()));
        }
        ValidateUtil.valid((Object)reformItem, (String)"add");
        return data;
    }

    private void setModelInfo(ReformItemBasic reform, Model model, Long reformId, Byte source, Boolean isValidateBySource, boolean isEdit) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        if (reform == null) {
            reform = new ReformItemBasic();
            String businessNo = this.businessNoService.getBusinessNo(cid, BusinessNoTypeEnum.HIDDEN_DANGER_REFORM.getCode());
            reform.setReformItemSn(businessNo);
        }
        model.addAttribute("entityId", (Object)reformId);
        if (source != null) {
            reform.setReformItemSource(source);
            model.addAttribute("hasSource", (Object)true);
        }
        if (StatusEnum.finished.getValue().equals(reform.getBusinessStatus())) {
            model.addAttribute("finished", (Object)true);
        }
        this.setHasBuildingAndAreaInfo(model);
        reform.setIsShowInReformModular(Boolean.valueOf(true));
        reform.setIsValidateBySource(isValidateBySource);
        model.addAttribute("reform", (Object)reform);
        model.addAttribute("reformSources", (Object)ReformSourceEnum.values());
        model.addAttribute("reformItemLevel", (Object)ReformItemLevelEnum.values());
        model.addAttribute("reformItemType", (Object)ReformItemTypeEnum.values());
    }

    @RequiresPermissions(value={"reformItem.edit"})
    @RequestMapping(value={"/editUnfinished"}, method={RequestMethod.GET})
    public String editUnfinished(Model model, Long reformId, Byte source) {
        if (reformId == null) {
            model.addAttribute("isAdd", (Object)true);
        }
        model.addAttribute("action", (Object)ActionEnum.edit.getCode());
        ReformItemBasic reform = (ReformItemBasic)this.reformService.getById(reformId);
        this.setModelInfo(reform, model, reformId, source, null, true);
        if (reform != null && reform.getAceptanceList() != null && reform.getAceptanceList().size() > 0) {
            model.addAttribute("page_editable", (Object)false);
        }
        return "work/reform/basicEdit";
    }

    @RequiresPermissions(value={"reformItem.view"})
    @RequestMapping(value={"/generationView"}, method={RequestMethod.GET})
    public String generationView(Model model, Long reformId) {
        TrusteeshipInfoDetail tru;
        ReformItemBasic reform = (ReformItemBasic)this.reformService.getById(reformId);
        if (reform.getGenerationSource() != null && reform.getGenerationSource().intValue() == 2 && reform.getReformItemSourceId() != null && (tru = (TrusteeshipInfoDetail)this.trusteeshipInfoDetailService.getById(reform.getReformItemSourceId())) != null) {
            reform.setReformItemSourceId(tru.getTrusteeshipInfoId());
            TrusteeshipInfo truinfo = (TrusteeshipInfo)this.trusteeshipInfoService.getById(tru.getTrusteeshipInfoId());
            model.addAttribute("truinfo", (Object)truinfo);
        }
        if (reform.getReformItemSource() != null) {
            String ReformItemSourceName = ReformSourceLiteEnum.getSourceNameByValue((Byte)reform.getReformItemSource());
            model.addAttribute("ReformItemSourceName", (Object)ReformItemSourceName);
        }
        if (reform.getReformItemFiles() != null) {
            List files = this.fileService.getListByIds(reform.getReformItemFiles());
            reform.setReformItemFileList(files);
        }
        model.addAttribute("reform", (Object)reform);
        return "work/reform/viewGenerationReformInfo";
    }

    @RequiresPermissions(value={"reformItem.edit"})
    @RequestMapping(value={"/generationEdit"}, method={RequestMethod.GET})
    public String generationEdit(Model model, Long reformId) {
        TrusteeshipInfoDetail tru;
        ReformItemBasic reform = (ReformItemBasic)this.reformService.getById(reformId);
        if (reform.getGenerationSource() != null && reform.getGenerationSource().intValue() == 2 && reform.getReformItemSourceId() != null && (tru = (TrusteeshipInfoDetail)this.trusteeshipInfoDetailService.getById(reform.getReformItemSourceId())) != null) {
            reform.setReformItemSourceId(tru.getTrusteeshipInfoId());
            reform.setReformItemSourceId(tru.getTrusteeshipInfoId());
            TrusteeshipInfo truinfo = (TrusteeshipInfo)this.trusteeshipInfoService.getById(tru.getTrusteeshipInfoId());
            model.addAttribute("truinfo", (Object)truinfo);
        }
        if (reform.getReformItemSource() != null) {
            String ReformItemSourceName = ReformSourceLiteEnum.getSourceNameByValue((Byte)reform.getReformItemSource());
            model.addAttribute("ReformItemSourceName", (Object)ReformItemSourceName);
        }
        if (reform.getReformItemFiles() != null) {
            List files = this.fileService.getListByIds(reform.getReformItemFiles());
            reform.setReformItemFileList(files);
        }
        model.addAttribute("reform", (Object)reform);
        return "work/reform/generationReform";
    }

    @RequiresPermissions(value={"reformItem.edit"})
    @ResponseBody
    @RequestMapping(value={"/saveGenerationBasic"}, method={RequestMethod.POST})
    @Log(title="\u4fdd\u5b58\u6574\u6539\u4fe1\u606f", type=21)
    public ResponseData<ReformItemBasic> saveGeneration(ReformItemBasic reformItem, HttpServletRequest request) {
        ResponseData res = new ResponseData();
        Long cid = UserUtils.getLoginStaffCompanyId();
        reformItem.setCid(cid);
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long orgId = UserUtils.getOrgId();
        String[] solutionFile = request.getParameterValues("reformItemFile");
        if (solutionFile != null && solutionFile.length > 0) {
            String fileIds = StringUtils.convertArrayToString((String[])solutionFile, (String)",");
            reformItem.setReformItemFiles(fileIds);
        }
        reformItem.setOrgId(orgId);
        this.reformService.update((Object)reformItem, loginStaffId);
        res.setResult((Object)reformItem);
        return res;
    }

    @RequiresPermissions(value={"reformItem.edit"})
    @RequestMapping(value={"/generationAcceEdit"}, method={RequestMethod.GET})
    public String generationAcceEdit(Model model, Long reformId, Long acceptanceId) {
        List files;
        String fileIds;
        ReformItemBasic reform = (ReformItemBasic)this.reformService.getById(reformId);
        if (acceptanceId == null) {
            acceptanceId = reform.getAcceptance().getId();
        }
        if (reform.getReformItemFiles() != null) {
            List files2 = this.fileService.getListByIds(reform.getReformItemFiles());
            reform.setReformItemFileList(files2);
        }
        if (acceptanceId != null && reform.getAceptanceList() != null && !reform.getAceptanceList().isEmpty()) {
            for (int i = 0; i < reform.getAceptanceList().size(); ++i) {
                if (!acceptanceId.equals(((ReformItemAcceptanceRecord)reform.getAceptanceList().get(i)).getId())) continue;
                reform.setAcceptance((ReformItemAcceptanceRecord)reform.getAceptanceList().get(i));
                break;
            }
        }
        if (reform.getAcceptance() != null && reform.getAcceptance().getReformFinishedFiles() != null) {
            fileIds = reform.getAcceptance().getReformFinishedFiles();
            files = this.fileService.getListByIds(fileIds);
            model.addAttribute("finishFiles", (Object)files);
        }
        if (reform.getAcceptance() != null && reform.getAcceptance().getReformNotification() != null) {
            fileIds = reform.getAcceptance().getReformNotification();
            files = this.fileService.getListByIds(fileIds);
            model.addAttribute("notifyFiles", (Object)files);
        }
        if (reform.getAcceptance() != null && reform.getAcceptance().getReformProgrammeFiles() != null) {
            fileIds = reform.getAcceptance().getReformProgrammeFiles();
            files = this.fileService.getListByIds(fileIds);
            model.addAttribute("proFiles", (Object)files);
        }
        if (reform.getAcceptance() != null && reform.getAcceptance().getAcceptanceFiles() != null) {
            fileIds = reform.getAcceptance().getAcceptanceFiles();
            files = this.fileService.getListByIds(fileIds);
            model.addAttribute("acfiles", (Object)files);
        }
        if (reform.getGenerationSource() != null && reform.getGenerationSource() == 3) {
            List proList = this.reformProgrammeService.getReformProgrammeListByReformId(acceptanceId);
            reform.setProgrammeList(proList);
        }
        model.addAttribute("reform", (Object)reform);
        model.addAttribute("acceptanceId", (Object)acceptanceId);
        return "work/reform/generationReformAcceptance";
    }

    @RequiresPermissions(value={"reformItem.view"})
    @RequestMapping(value={"/generationAcceView"}, method={RequestMethod.GET})
    public String generationAcceView(Model model, Long reformId, Long acceptanceId) {
        List files;
        String fileIds;
        ReformItemBasic reform = (ReformItemBasic)this.reformService.getById(reformId);
        if (reform.getReformItemFiles() != null) {
            List files2 = this.fileService.getListByIds(reform.getReformItemFiles());
            reform.setReformItemFileList(files2);
        }
        if (acceptanceId != null && reform.getAceptanceList() != null && !reform.getAceptanceList().isEmpty()) {
            for (int i = 0; i < reform.getAceptanceList().size(); ++i) {
                if (!acceptanceId.equals(((ReformItemAcceptanceRecord)reform.getAceptanceList().get(i)).getId())) continue;
                reform.setAcceptance((ReformItemAcceptanceRecord)reform.getAceptanceList().get(i));
                break;
            }
        }
        if (reform.getAcceptance() != null && reform.getAcceptance().getReformFinishedFiles() != null) {
            fileIds = reform.getAcceptance().getReformFinishedFiles();
            files = this.fileService.getListByIds(fileIds);
            model.addAttribute("finishFiles", (Object)files);
        }
        if (reform.getAcceptance() != null && reform.getAcceptance().getReformNotification() != null) {
            fileIds = reform.getAcceptance().getReformNotification();
            files = this.fileService.getListByIds(fileIds);
            model.addAttribute("notifyFiles", (Object)files);
        }
        if (reform.getAcceptance() != null && reform.getAcceptance().getReformProgrammeFiles() != null) {
            fileIds = reform.getAcceptance().getReformProgrammeFiles();
            files = this.fileService.getListByIds(fileIds);
            model.addAttribute("proFiles", (Object)files);
        }
        if (reform.getAcceptance() != null && reform.getAcceptance().getAcceptanceFiles() != null) {
            fileIds = reform.getAcceptance().getAcceptanceFiles();
            files = this.fileService.getListByIds(fileIds);
            model.addAttribute("acfiles", (Object)files);
        }
        if (reform.getGenerationSource() != null && reform.getGenerationSource() == 3) {
            List proList = this.reformProgrammeService.getReformProgrammeListByReformId(acceptanceId);
            reform.setProgrammeList(proList);
        }
        model.addAttribute("reform", (Object)reform);
        model.addAttribute("acceptanceId", (Object)acceptanceId);
        return "work/reform/viewGenerationReformAcceptance";
    }

    @RequiresPermissions(value={"reformItem.edit"})
    @ResponseBody
    @RequestMapping(value={"/saveGenerationAcce"}, method={RequestMethod.POST})
    @Log(title="\u4fdd\u5b58\u6574\u6539\u4fe1\u606f", type=21)
    public ResponseData<ReformItemBasic> saveGenerationAcce(ReformItemBasic reformItem, HttpServletRequest request) {
        String fileIds;
        ResponseData res = new ResponseData();
        Long cid = UserUtils.getLoginStaffCompanyId();
        reformItem.setCid(cid);
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long orgId = UserUtils.getOrgId();
        String[] notifyFile = request.getParameterValues("notifyFile");
        String[] finishedFile = request.getParameterValues("finishedFile");
        String[] proFile = request.getParameterValues("proFile");
        String[] acfile = request.getParameterValues("acfile");
        if (notifyFile != null && notifyFile.length > 0) {
            fileIds = StringUtils.convertArrayToString((String[])notifyFile, (String)",");
            reformItem.getAcceptance().setReformNotification(fileIds);
        }
        if (finishedFile != null && finishedFile.length > 0) {
            fileIds = StringUtils.convertArrayToString((String[])finishedFile, (String)",");
            reformItem.getAcceptance().setReformFinishedFiles(fileIds);
        }
        if (proFile != null && proFile.length > 0) {
            fileIds = StringUtils.convertArrayToString((String[])proFile, (String)",");
            reformItem.getAcceptance().setReformProgrammeFiles(fileIds);
        }
        if (acfile != null && acfile.length > 0) {
            fileIds = StringUtils.convertArrayToString((String[])acfile, (String)",");
            reformItem.getAcceptance().setAcceptanceFiles(fileIds);
        }
        this.reformService.saveGenerationReform(reformItem, loginStaffId);
        res.setResult((Object)reformItem);
        return res;
    }

    @Log(title="\u6574\u6539\u4fe1\u606f\u7f16\u8f91", type=21)
    @RequiresPermissions(value={"reformItem.edit"})
    @RequestMapping(value={"/edit/{reformId}"}, method={RequestMethod.GET})
    public String editFinished(Model model, @PathVariable(value="reformId") Long reformId, Byte source) {
        if (!UserUtils.isSuperAdmin()) {
            throw new HealthException("\u975e\u6cd5\u8bbf\u95ee");
        }
        model.addAttribute("action", (Object)ActionEnum.edit.getCode());
        ReformItemBasic reform = (ReformItemBasic)this.reformService.getById(reformId);
        model.addAttribute("isEditSuper", (Object)(UserUtils.isSuperAdmin() && StatusEnum.finished.getValue().equals(reform.getBusinessStatus()) ? 1 : 0));
        if (!UserUtils.isSuperAdmin()) {
            throw new HealthException("\u975e\u6cd5\u8bbf\u95ee\uff0c\u672a\u5b8c\u6210\u4e1a\u52a1");
        }
        this.setModelInfo(reform, model, reformId, source, null, true);
        return "work/reform/basicEdit";
    }

    @Log(title="\u7f16\u8f91\u6574\u6539\u9879\u4fe1\u606f", type=21)
    @RequiresPermissions(value={"reformItem.edit", "reformItem.view", "inspection.edit", "inspection.view"}, logical=Logical.OR)
    @RequestMapping(value={"/editDialog"}, method={RequestMethod.GET})
    public String editDialog(Model model, Long reformId, Byte source, String action) {
        if (StringUtils.isNotBlank((CharSequence)action) && ActionEnum.view.getCode().equals(action)) {
            model.addAttribute("page_editable", (Object)false);
            model.addAttribute("action", (Object)action);
        }
        Long cid = UserUtils.getLoginStaffCompanyId();
        ReformItemBasic reform = (ReformItemBasic)this.reformService.getById(reformId);
        if (reform == null) {
            reform = new ReformItemBasic();
        }
        if (reformId == null) {
            String businessNo = this.businessNoService.getBusinessNo(cid, BusinessNoTypeEnum.HIDDEN_DANGER_REFORM.getCode());
            reform.setReformItemSn(businessNo);
        }
        model.addAttribute("entityId", (Object)reformId);
        if (source != null) {
            reform.setReformItemSource(source);
            model.addAttribute("hasSource", (Object)true);
        }
        this.setHasBuildingAndAreaInfo(model);
        if (StatusEnum.finished.getValue().equals(reform.getBusinessStatus())) {
            model.addAttribute("finished", (Object)true);
        }
        reform.setIsShowInReformModular(Boolean.valueOf(true));
        reform.setIsValidateBySource(Boolean.valueOf(true));
        model.addAttribute("reform", (Object)reform);
        model.addAttribute("reformSources", (Object)ReformSourceEnum.values());
        model.addAttribute("reformItemLevel", (Object)ReformItemLevelEnum.values());
        model.addAttribute("reformItemType", (Object)ReformItemTypeEnum.values());
        return "work/reform/basicEditDialog";
    }

    @RequiresPermissions(value={"reformItem.edit"})
    @ResponseBody
    @RequestMapping(value={"/basic"}, method={RequestMethod.POST})
    @Log(title="\u4fdd\u5b58\u9690\u60a3\u6cbb\u7406\u57fa\u7840\u4fe1\u606f", type=2)
    public JSONObject saveReformBasic(ReformItemBasic reformItem) {
        ResponseData data = new ResponseData();
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long orgId = UserUtils.getOrgId();
        if (reformItem.getFinder() != null && reformItem.getFinderName() == null) {
            reformItem.setFinderName(this.staffService.getStaffNameByStaffId(reformItem.getFinder()));
        }
        reformItem.setOrgId(orgId);
        reformItem = this.reformService.saveReformItemBasic(reformItem, cid, loginStaffId);
        data.setResult((Object)reformItem);
        return HseJsonArray.getInstance().getFromObject((Object)data);
    }

    @Log(title="\u4fdd\u5b58\u6574\u6539\u9879\u57fa\u672c\u4fe1\u606f\u4ee5\u53ca\u6574\u6539\u4e0e\u9a8c\u6536\u76f8\u5173\u4fe1\u606f", type=21)
    @RequiresPermissions(value={"reformItem.edit"})
    @ResponseBody
    @RequestMapping(value={"/basicAndAcceptance"}, method={RequestMethod.POST})
    public JSONObject saveReformBasicAndAcceptance(ReformItemBasic reformItem) {
        ResponseData data = new ResponseData();
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long orgId = UserUtils.getOrgId();
        reformItem.setOrgId(orgId);
        reformItem = this.reformService.saveReformItemBasic(reformItem, cid, loginStaffId);
        data.setResult((Object)reformItem);
        return HseJsonArray.getInstance().getFromObject((Object)data);
    }

    @ResponseBody
    @RequestMapping(value={"/basic/validate"}, method={RequestMethod.POST})
    public ResponseData<String> ValidateReformItemBasic(ReformItemBasic reformItem) {
        ResponseData data = new ResponseData();
        if (reformItem.getFinder() != null && reformItem.getFinderName() == null) {
            reformItem.setFinderName(this.staffService.getStaffNameByStaffId(reformItem.getFinder()));
        }
        if (reformItem.getAcceptance() != null && reformItem.getAcceptance().getReformDirector() != null) {
            reformItem.getAcceptance().setReformDirectorName(this.staffService.getStaffNameByStaffId(reformItem.getAcceptance().getReformDirector()));
        }
        if (reformItem.getAcceptance() != null && reformItem.getAcceptance().getAcceptanceDirector() != null) {
            reformItem.getAcceptance().setAcceptanceDirectorName(this.staffService.getStaffNameByStaffId(reformItem.getAcceptance().getAcceptanceDirector()));
        }
        ReformItemUtil.validate((ReformItemBasic)reformItem);
        return data;
    }

    @Log(title="\u6574\u6539\u9879\u590d\u6d4b\u5ffd\u7565", type=21)
    @ResponseBody
    @RequestMapping(value={"/{id}/harmFactor/ignore"}, method={RequestMethod.GET})
    public String harmFactorIgnore(@PathVariable(value="id") Long id) {
        Long loginStaffId = UserUtils.getLoginStaffId();
        this.reformService.reformItemRetestIgnore(id, loginStaffId);
        return ResponseStateEnum.success.name();
    }

    @ResponseBody
    @RequestMapping(value={"/{id}/harmFactor/recovery"}, method={RequestMethod.GET})
    @Log(title="\u56de\u590d\u5ffd\u7565\u7684\u6574\u6539\u9879", type=2)
    public String harmFactorRecovery(@PathVariable(value="id") Long id) {
        Long loginStaffId = UserUtils.getLoginStaffId();
        this.reformService.reformItemRetestRecovery(id, loginStaffId);
        return ResponseStateEnum.success.name();
    }

    @RequiresPermissions(value={"reformItem.view"})
    @ResponseBody
    @RequestMapping(value={"/unfinished/jqGrid/data"}, method={RequestMethod.POST})
    @Log(title="\u83b7\u53d6\u6574\u6539\u5217\u8868\u6570\u636e\u4fe1\u606f", type=2)
    public JSONObject unfinishedJqGridData(JqGridParam param, ReformItemFinishedSeniorSearch search) {
        UserUtils.startWebDataScope();
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        if (search.getStatus() == null) {
            search.setStatus(search.getUrlStatus());
        }
        PageInfo pageInfo = this.reformService.getUnfinishedReformItemPageByParam(param, search);
        return HseJsonArray.getInstance().getFromObject((Object)pageInfo);
    }

    @RequiresPermissions(value={"reformItem.view"})
    @ResponseBody
    @RequestMapping(value={"/getFinishListData"}, method={RequestMethod.POST})
    @Log(title="\u83b7\u53d6\u6574\u6539\u5217\u8868\u6570\u636e\u4fe1\u606f", type=2)
    public JSONObject getFinishListData(JqGridParam param, ReformItemFinishedSeniorSearch search) {
        UserUtils.startWebDataScope();
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        PageInfo pageInfo = this.reformService.getFinishedReformItemPageByParam(param, search);
        return HseJsonArray.getInstance().getFromObject((Object)pageInfo);
    }

    @RequiresPermissions(value={"reformItem.view"})
    @ResponseBody
    @RequestMapping(value={"/reformBySource/jqGrid/data/{sourceId}"}, method={RequestMethod.POST})
    @Log(title="\u6839\u636e\u6574\u6539\u6765\u6e90\uff0c\u83b7\u53d6\u6574\u6539\u9879\u5217\u8868", type=2)
    public String reformBySourceJqGridData(JqGridParam param, @PathVariable(value="sourceId") Long sourceId) {
        PageInfo pageInfo = this.reformService.getReformItemPageBySourceId(UserUtils.getLoginStaffCompanyId(), param, sourceId);
        return JsonMapper.toJsonString((Object)pageInfo);
    }

    @RequiresPermissions(value={"reformItem.view"})
    @ResponseBody
    @RequestMapping(value={"/finished/jqGrid/data"}, method={RequestMethod.POST})
    @Log(title="\u5df2\u5b8c\u6210\u5217\u8868\u6570\u636e", type=2)
    public JSONObject finishedJqGridData(JqGridParam param, Integer year, Byte sourceType) {
        UserUtils.startWebDataScope();
        PageInfo pageInfo = null;
        if (sourceType != null) {
            param.setState(sourceType);
        }
        if (year != null) {
            int page = param.getPage();
            int rows = param.getRows();
            param.setPage(1);
            param.setRows(Integer.MAX_VALUE);
            pageInfo = this.reformService.getReformItemFinishedPageSenior(UserUtils.getLoginStaffCompanyId(), param);
            List list = pageInfo.getList();
            ArrayList<ReformItemListVo> rlist = new ArrayList<ReformItemListVo>();
            for (ReformItemListVo vo : list) {
                if (vo.getActualFinishTime() == null || DateUtils.getYear((String)vo.getActualFinishTime()) != year) continue;
                rlist.add(vo);
            }
            pageInfo = PageUtil.getPageInfo(rlist, (int)page, (int)rows);
        } else {
            pageInfo = this.reformService.getReformItemFinishedPageSenior(UserUtils.getLoginStaffCompanyId(), param);
        }
        return HseJsonArray.getInstance().getFromObject((Object)pageInfo);
    }

    @RequiresPermissions(value={"reformItem.view"})
    @ResponseBody
    @Log(title="\u83b7\u53d6\u6574\u6539\u5b8c\u6210\u5f85\u590d\u6d4b\u7684\u6574\u6539\u9879\uff08\u5371\u5bb3\u56e0\u7d20\u76f8\u5173\uff09", type=2)
    @RequestMapping(value={"/finished/jqGrid/data/harmFactor"}, method={RequestMethod.POST})
    public JSONObject finishedJqGridDataHarmFactor(JqGridParam param, Byte harmFactorStatus) {
        if (harmFactorStatus == null) {
            harmFactorStatus = ReformItemHarmFactorStatusEnum.normal.getValue();
        }
        if (ReformItemHarmFactorStatusEnum.getByValue((Byte)harmFactorStatus) != null) {
            ParamSeachFieldVO source = new ParamSeachFieldVO();
            source.setSearchField("reformItemSource");
            source.setSearchValue("" + ReformSourceEnum.harmFactorInspection.getValue());
            param.getPostDatas().add(source);
            ParamSeachFieldVO hfStatus = new ParamSeachFieldVO();
            hfStatus.setSearchField("harmFactorStatus");
            hfStatus.setSearchValue("" + harmFactorStatus);
            param.getPostDatas().add(hfStatus);
            PageInfo pageInfo = this.reformService.getReformItemFinishedPageSenior(UserUtils.getLoginStaffCompanyId(), param);
            return HseJsonArray.getInstance().getFromObject((Object)pageInfo);
        }
        PageInfo pageInfo = new PageInfo();
        return HseJsonArray.getInstance().getFromObject((Object)pageInfo);
    }

    @RequiresPermissions(value={"reformItem.view"})
    @Log(title="\u5bfc\u51fa\u5df2\u5b8c\u6210\u9690\u60a3\u6cbb\u7406", type=24)
    @RequestMapping(value={"/finished/export"}, method={RequestMethod.GET})
    public void exportFinished(HttpServletResponse response, Integer year) throws Exception {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String fileName = "\u5df2\u5b8c\u6210\u9690\u60a3\u6cbb\u7406\u6e05\u5355" + dateFormat.format(new Date()) + ".xls";
        String[] colums = new String[]{"\u5e8f\u53f7|export_index", "\u9690\u60a3\u7f16\u53f7|reformItemSn", "\u9690\u60a3\u540d\u79f0|reformItemName", "\u9690\u60a3\u7b49\u7ea7|reformItemLevel", "\u9690\u60a3\u6765\u6e90|reformItemSource", "\u6574\u6539\u8d1f\u8d23\u4eba|reformDirector", "\u6574\u6539\u671f\u9650|requireFinishTime", "\u6574\u6539\u65b9\u6848|reformSolution", "\u9a8c\u6536\u8d1f\u8d23\u4eba|acceptanceDirector", "\u5b9e\u9645\u5b8c\u6210\u65f6\u95f4|actualFinishTime"};
        Long cid = UserUtils.getLoginStaffCompanyId();
        ArrayList<ReformItemListVo> reformItemList = this.reformService.getReformItemFinishedListSeniorForVo(cid, null);
        if (year != null) {
            ArrayList<ReformItemListVo> rlist = new ArrayList<ReformItemListVo>();
            for (ReformItemListVo vo : reformItemList) {
                if (vo.getActualFinishTime() == null || DateUtils.getYear((String)vo.getActualFinishTime()) != year) continue;
                rlist.add(vo);
            }
            reformItemList = rlist;
        }
        response.setHeader("Content-Disposition", "attachment;filename=" + new String(fileName.getBytes("GBK"), "ISO8859_1"));
        response.setContentType("application/octet-stream; charset=GBK");
        ExportExcel listexcel = new ExportExcel();
        listexcel.simpleExport2("\u5df2\u5b8c\u6210\u9690\u60a3\u6cbb\u7406\u6e05\u5355", colums, reformItemList, (OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/sendMessage"}, method={RequestMethod.GET})
    public String sendMessage(Long receiver, Model model, Boolean isMust) {
        model.addAttribute("receiver", (Object)receiver);
        model.addAttribute("isMust", (Object)isMust);
        return "work/reform/sendMessage";
    }

    @ResponseBody
    @RequestMapping(value={"export"}, method={RequestMethod.POST})
    public void export(HttpServletResponse response, JqGridParam param) throws Exception {
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        List list = this.reformService.getReformItemFinishedListSeniorForVo(cid, param);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String fileName = "\u9690\u60a3\u6cbb\u7406\u5df2\u5b8c\u6210\u6e05\u5355" + dateFormat.format(new Date()) + ".xls";
        String[] colums = new String[]{"\u9690\u60a3\u7f16\u53f7|reformItemSn", "\u9690\u60a3\u540d\u79f0|reformItemName", "\u9690\u60a3\u5206\u7c7b|reformItemType", "\u9690\u60a3\u6765\u6e90|reformItemSource", "\u6574\u6539\u8d1f\u8d23\u4eba|reformDirector", "\u6574\u6539\u671f\u9650|requireFinishTime", "\u5b9e\u9645\u5b8c\u6210\u65f6\u95f4|actualFinishTime"};
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-Disposition", "attachment;filename=" + new String(fileName.getBytes("GBK"), "ISO8859_1"));
        response.setContentType("application/octet-stream; charset=GBK");
        ExportExcel listexcel = new ExportExcel();
        listexcel.simpleExportAutoWidthAndHeight("\u5c97\u4f4d\u5de5\u79cd\u4fe1\u606f", colums, list, Integer.valueOf(20000), (OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/checkInfo"})
    public String dataResult(ModelMap m, Long result) {
        CheckPlanReformItem info = this.checkPlanReformItemService.getCheckPlanReformItemByResultId(result);
        m.put((Object)"info", (Object)info);
        return "work/reform/checkOverData";
    }
}

