/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.work.planyear;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.web.repeatform.RepeatUrlFormData;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.entity.work.planyear.PlanYearUploadFile;
import cn.smarthse.modules.health.entity.work.planyear.PreventionExpend;
import cn.smarthse.modules.health.enums.planyear.PlanYearExpendTypeEnum;
import cn.smarthse.modules.health.service.work.planyear.IPlanYearUploadFileService;
import cn.smarthse.modules.health.service.work.planyear.IPreventionExpendService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.StaffUtil;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpSession;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/work/planyear/preExpend"})
public class PreventionExpendController
extends ControllerSupport {
    @DubboReference
    IPreventionExpendService preventionExpendService;
    @DubboReference
    IPlanYearUploadFileService planYearUploadFileServiceImpl;
    @DubboReference(timeout=5000000)
    ISysFileProvideService sysFileServiceImpl;

    @RequestMapping(value={"unfilishedList"}, method={RequestMethod.GET})
    public String unfilishedList(Model model) {
        this.logger.info("\u804c\u4e1a\u75c5\u9632\u6cbb\u7ecf\u8d39\u767b\u8bb0\u6e05\u5355(\u8fdb\u884c\u4e2d)");
        model.addAttribute("expendTypes", (Object)PlanYearExpendTypeEnum.values());
        return "work/planyear/preventionExpend/unfinishedList";
    }

    @ResponseBody
    @RequestMapping(value={"getlistData"})
    public JqGridData<PreventionExpend> getlistData(JqGridParam param, PreventionExpend search) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffid = UserUtils.getLoginStaffId();
        search.setCid(cid);
        search.setIsFinish(Boolean.valueOf(false));
        UserUtils.startWebDataScope();
        PageInfo pageInfo = this.preventionExpendService.getListPageByParam(param, search);
        if (pageInfo.getList() != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            for (PreventionExpend info : pageInfo.getList()) {
                if (info.getExpendType() != null) {
                    info.setTypeName(PlanYearExpendTypeEnum.getName((Integer)info.getExpendType().intValue()));
                }
                if (info.getCreateBy() != null) {
                    info.setCreateName(StaffUtil.getStaffFullNameById(info.getCreateBy()));
                }
                if (info.getWorkStartDate() == null || info.getWorkEndDate() == null) continue;
                String planDate = dateFormat.format(info.getWorkStartDate()) + "\u81f3" + dateFormat.format(info.getWorkEndDate());
                info.setPlanImplDate(planDate);
            }
        }
        JqGridData data = new JqGridData(pageInfo, param);
        return data;
    }

    @RequestMapping(value={"filishedList"}, method={RequestMethod.GET})
    public String filishedList(Model model) {
        this.logger.info("\u804c\u4e1a\u75c5\u9632\u6cbb\u7ecf\u8d39\u767b\u8bb0\u6e05\u5355(\u5df2\u5b8c\u6210)");
        model.addAttribute("expendTypes", (Object)PlanYearExpendTypeEnum.values());
        return "work/planyear/preventionExpend/finishedList";
    }

    @ResponseBody
    @RequestMapping(value={"getFilishedlistData"})
    public JqGridData<PreventionExpend> getFilishedlistData(JqGridParam param, PreventionExpend search) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffid = UserUtils.getLoginStaffId();
        search.setCid(cid);
        search.setIsFinish(Boolean.valueOf(true));
        UserUtils.startWebDataScope();
        PageInfo pageInfo = this.preventionExpendService.getListPage(param, search);
        if (pageInfo.getList() != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            for (PreventionExpend info : pageInfo.getList()) {
                if (info.getExpendType() != null) {
                    info.setTypeName(PlanYearExpendTypeEnum.getName((Integer)info.getExpendType().intValue()));
                }
                if (info.getCreateBy() != null) {
                    info.setCreateName(StaffUtil.getStaffFullNameById(info.getCreateBy()));
                }
                if (info.getWorkStartDate() == null || info.getWorkEndDate() == null) continue;
                String planDate = dateFormat.format(info.getWorkStartDate()) + "\u81f3" + dateFormat.format(info.getWorkEndDate());
                info.setPlanImplDate(planDate);
            }
        }
        JqGridData data = new JqGridData(pageInfo, param);
        return data;
    }

    @RequestMapping(value={"addExpend"}, method={RequestMethod.GET})
    public String page_AddPlan(Model model) {
        this.logger.info("\u804c\u4e1a\u75c5\u9632\u6cbb\u7ecf\u8d39\u300b\u65b0\u589e");
        model.addAttribute("expendTypes", (Object)PlanYearExpendTypeEnum.values());
        return "work/planyear/preventionExpend/preventionExpendEdit";
    }

    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"save"}, method={RequestMethod.POST})
    public ResponseData<PreventionExpend> ajax_addPlan(PreventionExpend info, Long[] fileIds) {
        this.logger.info("\u804c\u4e1a\u75c5\u9632\u6cbb\u7ecf\u8d39\u4fdd\u5b58");
        ResponseData r = new ResponseData();
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffid = UserUtils.getLoginStaffId();
        Long orgId = UserUtils.getOrgId();
        info.setOrgId(orgId);
        try {
            info = info.getId() == null ? this.preventionExpendService.addWithFile(info, cid, staffid, fileIds) : this.preventionExpendService.updateWithFile(info, cid, staffid, fileIds);
            r.setResult((Object)info);
            r.setContent("\u4fdd\u5b58\u6210\u529f");
            r.setState(ResponseStateEnum.success);
        }
        catch (Exception e) {
            r.setContent("\u4fdd\u5b58\u5931\u8d25");
            r.setState(ResponseStateEnum.fail);
        }
        return r;
    }

    @RequestMapping(value={"editExpend"}, method={RequestMethod.GET})
    public String editExpend(Model model, Long id) {
        this.logger.info("\u804c\u4e1a\u75c5\u9632\u6cbb\u7ecf\u8d39\u7f16\u8f91");
        PreventionExpend info = (PreventionExpend)this.preventionExpendService.getById(id);
        if (info != null) {
            ArrayList<SysFileModel> fileList = new ArrayList<SysFileModel>();
            List planYearUploadFileList = this.planYearUploadFileServiceImpl.getByPlanYearId(info.getId(), Byte.valueOf((byte)5));
            Object fileIds = "";
            for (PlanYearUploadFile planYearUploadFile : planYearUploadFileList) {
                if (planYearUploadFile.getFileId() == null) continue;
                SysFileModel sysFile = this.sysFileServiceImpl.getFileById(planYearUploadFile.getFileId());
                fileList.add(sysFile);
                fileIds = (String)fileIds + sysFile.getId() + ",";
            }
            model.addAttribute("fileList", fileList);
            model.addAttribute("fileIds", fileIds);
        }
        if (info.getWorkStartDate() != null && info.getWorkEndDate() != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String planDate = dateFormat.format(info.getWorkStartDate()) + "\u81f3" + dateFormat.format(info.getWorkEndDate());
            info.setPlanImplDate(planDate);
        }
        model.addAttribute("data", (Object)info);
        model.addAttribute("expendTypes", (Object)PlanYearExpendTypeEnum.values());
        return "work/planyear/preventionExpend/preventionExpendEdit";
    }

    @RequestMapping(value={"viewExpend"}, method={RequestMethod.GET})
    public String page_viewPlan(Model model, Long id) {
        this.logger.info("\u804c\u4e1a\u75c5\u9632\u6cbb\u7ecf\u8d39\u767b\u8bb0\u67e5\u770b");
        PreventionExpend info = (PreventionExpend)this.preventionExpendService.getById(id);
        if (info != null) {
            ArrayList<SysFileModel> fileList = new ArrayList<SysFileModel>();
            List planYearUploadFileList = this.planYearUploadFileServiceImpl.getByPlanYearId(info.getId(), Byte.valueOf((byte)5));
            Object fileIds = "";
            for (PlanYearUploadFile planYearUploadFile : planYearUploadFileList) {
                if (planYearUploadFile.getFileId() == null) continue;
                SysFileModel sysFile = this.sysFileServiceImpl.getFileById(planYearUploadFile.getFileId());
                fileList.add(sysFile);
                fileIds = (String)fileIds + sysFile.getId() + ",";
            }
            model.addAttribute("fileList", fileList);
            model.addAttribute("fileIds", fileIds);
        }
        if (info.getWorkStartDate() != null && info.getWorkEndDate() != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String planDate = dateFormat.format(info.getWorkStartDate()) + "\u81f3" + dateFormat.format(info.getWorkEndDate());
            info.setPlanImplDate(planDate);
        }
        if (info.getExpendType() != null) {
            info.setTypeName(PlanYearExpendTypeEnum.getName((Integer)info.getExpendType().intValue()));
        }
        info.setCreateName(StaffUtil.getStaffFullNameById(info.getCreateBy()));
        model.addAttribute("data", (Object)info);
        return "work/planyear/preventionExpend/preventionExpendView";
    }

    @ResponseBody
    @RequestMapping(value={"/delete"}, method={RequestMethod.DELETE})
    public ResponseData<Integer> delExpend(HttpSession session, Long id, ModelMap m) {
        ResponseData data = new ResponseData();
        Long staffid = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        try {
            PreventionExpend info = (PreventionExpend)this.preventionExpendService.getById(id);
            this.preventionExpendService.delete((Object)info, staffid);
            data.setContent("\u5220\u9664\u6210\u529f\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
            data.setContent("\u5220\u9664\u5931\u8d25\uff01");
        }
        return data;
    }
}

