/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.work.planyear;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.web.repeatform.RepeatUrlFormData;
import cn.smarthse.modules.health.entity.work.planyear.PlanYearExpend;
import cn.smarthse.modules.health.enums.planyear.PlanYearExpendTypeEnum;
import cn.smarthse.modules.health.service.work.planyear.IPlanYearExpendService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.StaffUtil;
import cn.smarthse.web.util.UserUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/work/planyear/expend"})
public class PlanYearExpendController
extends ControllerSupport {
    @DubboReference
    IPlanYearExpendService planYearExpendServiceImpl;

    @ResponseBody
    @RequestMapping(value={"listData"})
    public JqGridData<PlanYearExpend> listData(Long id, String expendIds, JqGridParam param) {
        this.logger.info(param.toString());
        List list = new ArrayList();
        if (id != null) {
            param.setId(id);
            list = this.planYearExpendServiceImpl.getPlanYearExpendListByGridParam(param);
            for (PlanYearExpend planYearExpend : list) {
                planYearExpend.setTypeName(PlanYearExpendTypeEnum.getName((Integer)planYearExpend.getExpendType().intValue()));
                planYearExpend.setStaffName(StaffUtil.getStaffFullNameById(planYearExpend.getManagerId()));
            }
        } else if (expendIds == null || expendIds.trim().isEmpty()) {
            list = new ArrayList();
        } else {
            expendIds = expendIds.substring(0, expendIds.length() - 1);
            list = this.planYearExpendServiceImpl.getListByIds(expendIds);
            for (PlanYearExpend planYearExpend : list) {
                planYearExpend.setTypeName(PlanYearExpendTypeEnum.getName((Integer)planYearExpend.getExpendType().intValue()));
            }
        }
        PageInfo pageInfo = new PageInfo(list);
        JqGridData data = new JqGridData(pageInfo, param);
        return data;
    }

    @RequestMapping(value={"viewadd"}, method={RequestMethod.GET})
    public String page_viewAdd() {
        this.logger.info("\u5e74\u5ea6\u8ba1\u5212\u300b\u9884\u7b97\u300b\u65b0\u589e");
        return "work/planyear/dialog_addPlanYearExpend";
    }

    @RequestMapping(value={"viewedit/{id}"}, method={RequestMethod.GET})
    public String page_viewEdit(@PathVariable(value="id") Long id, Model model) {
        PlanYearExpend planYearExpend;
        this.logger.info("\u5e74\u5ea6\u8ba1\u5212\u300b\u9884\u7b97\u300b\u7f16\u8f91");
        if (id != null && (planYearExpend = (PlanYearExpend)this.planYearExpendServiceImpl.getById(id)) != null) {
            model.addAttribute("planYearExpend", (Object)planYearExpend);
        }
        return "work/planyear/dialog_editPlanYearExpend";
    }

    @RequestMapping(value={"vieweditsummary/{id}"}, method={RequestMethod.GET})
    public String page_viewEditSummary(@PathVariable(value="id") Long id, Model model) {
        PlanYearExpend planYearExpend;
        this.logger.info("\u5e74\u5ea6\u8ba1\u5212\u300b\u9884\u7b97\u300b\u7f16\u8f91");
        if (id != null && (planYearExpend = (PlanYearExpend)this.planYearExpendServiceImpl.getById(id)) != null) {
            planYearExpend.setStaffName(StaffUtil.getStaffFullNameById(planYearExpend.getManagerId()));
            planYearExpend.setTypeName(PlanYearExpendTypeEnum.getName((Integer)planYearExpend.getExpendType().intValue()));
            model.addAttribute("planYearExpend", (Object)planYearExpend);
        }
        return "work/planyear/dialog_editSummaryPlanYearExpend";
    }

    @Log(title="\u9884\u7b97\u65b0\u589e", type=20)
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"add"}, method={RequestMethod.POST})
    public ResponseData<String> ajax_addPlanYearExpend(PlanYearExpend planYearExpend, String expends, Long planYearId) {
        this.logger.info("ajax-\u5e74\u5ea6\u8ba1\u5212\u300b\u9884\u7b97\u300b\u65b0\u589e");
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffid = UserUtils.getLoginStaffId();
        ResponseData r = new ResponseData();
        if (planYearExpend.getExpendType() == null || planYearExpend.getExpendType() == 0) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u8bf7\u9009\u62e9\u7528\u9014");
            return r;
        }
        if (planYearExpend.getBudgetMoney() == null) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u9884\u7b97\u4e0d\u5f97\u4e3a\u7a7a");
            return r;
        }
        if (planYearExpend.getContent() == null || planYearExpend.getContent().trim().isEmpty()) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u8be6\u60c5\u4e0d\u5f97\u4e3a\u7a7a");
            return r;
        }
        if (planYearId != null) {
            planYearExpend.setPlanYearId(planYearId);
        }
        if ((planYearExpend = (PlanYearExpend)this.planYearExpendServiceImpl.add((Object)planYearExpend, staffid, cid)).getPlanYearId() == null) {
            List<Object> list = null;
            if (expends == null || expends.trim().isEmpty()) {
                list = new ArrayList<PlanYearExpend>();
            } else {
                expends = StringEscapeUtils.unescapeHtml((String)expends);
                list = JSONObject.parseArray((String)expends, PlanYearExpend.class);
            }
            list.add(planYearExpend);
            expends = JSON.toJSON(list).toString();
            r.setResult((Object)expends);
        }
        return r;
    }

    @Log(title="\u9884\u7b97\u7f16\u8f91", type=21)
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"edit"}, method={RequestMethod.POST})
    public ResponseData<String> ajax_editPlanYearExpend(PlanYearExpend planYearExpend, String expends) {
        this.logger.info("ajax-\u5e74\u5ea6\u8ba1\u5212\u300b\u9884\u7b97\u300b\u7f16\u8f91");
        Long staffid = UserUtils.getLoginStaffId();
        ResponseData r = new ResponseData();
        if (planYearExpend.getId() == null) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u65e0\u6cd5\u83b7\u53d6\u8be5\u6761\u6570\u636e");
            return r;
        }
        if (planYearExpend.getExpendType() == null || planYearExpend.getExpendType() == 0) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u8bf7\u9009\u62e9\u7528\u9014");
            return r;
        }
        if (planYearExpend.getBudgetMoney() == null) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u7ecf\u8d39\u9884\u7b97\u4e0d\u5f97\u4e3a\u7a7a");
            return r;
        }
        if (planYearExpend.getContent() == null || planYearExpend.getContent().trim().isEmpty()) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u8be6\u60c5\u4e0d\u5f97\u4e3a\u7a7a");
            return r;
        }
        this.planYearExpendServiceImpl.update((Object)planYearExpend, staffid);
        if (planYearExpend.getPlanYearId() == null) {
            List list = null;
            if (expends == null || expends.trim().isEmpty()) {
                list = new ArrayList();
            } else {
                expends = StringEscapeUtils.unescapeHtml((String)expends);
                list = JSONObject.parseArray((String)expends, PlanYearExpend.class);
                for (PlanYearExpend planYearExpend2 : list) {
                    if (planYearExpend2.getId().longValue() != planYearExpend.getId().longValue()) continue;
                    planYearExpend2.setExpendType(planYearExpend.getExpendType());
                    planYearExpend2.setBudgetMoney(planYearExpend.getBudgetMoney());
                    planYearExpend2.setContent(planYearExpend.getContent());
                    planYearExpend2.setRemark(planYearExpend.getRemark());
                }
            }
            expends = JSON.toJSON(list).toString();
            r.setResult((Object)expends);
        }
        return r;
    }

    @Log(title="\u9884\u7b97\u7f16\u8f91", type=21)
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"editsummary"}, method={RequestMethod.POST})
    public ResponseData<String> ajax_editPlanYearExpendSummary(PlanYearExpend planYearExpend) {
        this.logger.info("ajax-\u5e74\u5ea6\u8ba1\u5212\u300b\u9884\u7b97\u300b\u7f16\u8f91");
        Long staffid = UserUtils.getLoginStaffId();
        ResponseData r = new ResponseData();
        if (planYearExpend.getId() == null) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u65e0\u6cd5\u83b7\u53d6\u8be5\u6761\u6570\u636e");
            return r;
        }
        if (planYearExpend.getManagerId() == null) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u8bf7\u9009\u62e9\u9879\u76ee\u8d1f\u8d23\u4eba");
            return r;
        }
        if (planYearExpend.getActualMoney() == null) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u5b9e\u9645\u82b1\u8d39\u4e0d\u5f97\u4e3a\u7a7a");
            return r;
        }
        this.planYearExpendServiceImpl.update((Object)planYearExpend, staffid);
        return r;
    }

    @Log(title="\u9884\u7b97\u5220\u9664", type=22)
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"del/{id}"}, method={RequestMethod.POST})
    public ResponseData<String> ajax_delPlanYearExpend(@PathVariable(value="id") Long id, String expends) {
        this.logger.info("ajax-\u5e74\u5ea6\u8ba1\u5212\u300b\u9884\u7b97\u300b\u5220\u9664");
        Long staffid = UserUtils.getLoginStaffId();
        ResponseData r = new ResponseData();
        if (id != null) {
            PlanYearExpend planYearExpend = (PlanYearExpend)this.planYearExpendServiceImpl.getById(id);
            planYearExpend.setIsValid(Boolean.valueOf(false));
            this.planYearExpendServiceImpl.update((Object)planYearExpend, staffid);
            if (planYearExpend.getPlanYearId() == null) {
                List list = null;
                if (expends == null || expends.trim().isEmpty()) {
                    list = new ArrayList();
                } else {
                    Integer index = null;
                    expends = StringEscapeUtils.unescapeHtml((String)expends);
                    list = JSONObject.parseArray((String)expends, PlanYearExpend.class);
                    for (int i = 0; i < list.size(); ++i) {
                        if (((PlanYearExpend)list.get(i)).getId().longValue() != planYearExpend.getId().longValue()) continue;
                        index = i;
                    }
                    if (index != null && index <= list.size()) {
                        list.remove(index);
                    }
                }
                expends = JSON.toJSON(list).toString();
                r.setResult((Object)expends);
            }
        } else {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u65e0\u6cd5\u83b7\u53d6\u8be5\u6761\u6570\u636e");
            if (expends != null && !expends.trim().isEmpty()) {
                r.setResult((Object)expends);
            }
        }
        return r;
    }
}

