/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.work.planyear;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.web.repeatform.RepeatUrlFormData;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.entity.work.planyear.PlanYearDetail;
import cn.smarthse.modules.health.entity.work.planyear.PlanYearModulars;
import cn.smarthse.modules.health.enums.check.CheckTypeEnum;
import cn.smarthse.modules.health.enums.evaluate.EvaluateHseTypeEnum;
import cn.smarthse.modules.health.enums.hccheckplan.HcCheckTypeEnum;
import cn.smarthse.modules.health.enums.planyear.PlanYearDetailImplState;
import cn.smarthse.modules.health.enums.scene.InspectionTypeEnum;
import cn.smarthse.modules.health.enums.train.TrainPlanTypeEnum;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.work.planyear.IPlanYearDetailService;
import cn.smarthse.modules.health.service.work.planyear.IPlanYearModularsService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.StaffUtil;
import cn.smarthse.web.util.UserUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/work/planyear/detail"})
public class PlanYearDetailController
extends ControllerSupport {
    @DubboReference
    IPlanYearDetailService planYearDetailServiceImpl;
    @DubboReference
    IPlanYearModularsService planYearModularsService;
    @DubboReference
    IStaffInfoService staffInfoService;

    @ResponseBody
    @RequestMapping(value={"listData"})
    public JqGridData<PlanYearDetail> listData(Long id, String detailIds, JqGridParam param) {
        this.logger.info(param.toString());
        List list = new ArrayList();
        if (id != null) {
            param.setId(id);
            list = this.planYearDetailServiceImpl.getPlanYearDetailListByGridParam(param);
            for (PlanYearDetail planYearDetail : list) {
                planYearDetail.setModular((PlanYearModulars)this.planYearModularsService.getById(planYearDetail.getBussnissModularId()));
                planYearDetail.setManagerName(StaffUtil.getStaffFullNameById(planYearDetail.getManagerId()));
                planYearDetail.setImplManagerName(StaffUtil.getStaffFullNameById(planYearDetail.getImplManagerId()));
                planYearDetail.setImplState(PlanYearDetailImplState.get((Byte)planYearDetail.getImplResult()));
                planYearDetail.setImplStateName(planYearDetail.getImplResult() == 0 ? "\u672a\u5b9e\u65bd" : planYearDetail.getImplState().getName());
            }
        } else if (detailIds == null || detailIds.trim().isEmpty()) {
            list = new ArrayList();
        } else {
            detailIds = detailIds.substring(0, detailIds.length() - 1);
            list = this.planYearDetailServiceImpl.getListByIds(detailIds);
            for (PlanYearDetail planYearDetail : list) {
                planYearDetail.setModular((PlanYearModulars)this.planYearModularsService.getById(planYearDetail.getBussnissModularId()));
                planYearDetail.setManagerName(StaffUtil.getStaffFullNameById(planYearDetail.getManagerId()));
                planYearDetail.setImplManagerName(StaffUtil.getStaffFullNameById(planYearDetail.getImplManagerId()));
            }
        }
        PageInfo pageInfo = new PageInfo(list);
        JqGridData data = new JqGridData(pageInfo, param);
        return data;
    }

    @ResponseBody
    @RequestMapping(value={"listDataEdit"})
    public JqGridData<PlanYearDetail> listDataEdit(Long id, String detailIds, JqGridParam param) {
        this.logger.info(param.toString());
        List list = new ArrayList();
        if (id != null) {
            param.setId(id);
            list = this.planYearDetailServiceImpl.getPlanYearDetailListByGridParam(param);
            for (PlanYearDetail planYearDetail : list) {
                planYearDetail.setModular((PlanYearModulars)this.planYearModularsService.getById(planYearDetail.getBussnissModularId()));
                planYearDetail.setManagerName(StaffUtil.getStaffFullNameById(planYearDetail.getManagerId()));
                planYearDetail.setImplManagerName(StaffUtil.getStaffFullNameById(planYearDetail.getImplManagerId()));
                planYearDetail.setImplState(PlanYearDetailImplState.get((Byte)planYearDetail.getImplResult()));
                planYearDetail.setImplStateName("<select name=\"detailId_status\" >\r\n\t\t\t\t\t\t\t\t\t\t\t<option " + (planYearDetail.getImplResult() == 1 ? "selected" : "") + "   value=\"" + planYearDetail.getId() + ":1\">\u5df2\u5b8c\u6210</option>\r\n\t\t\t\t\t\t\t\t\t\t\t<option " + (planYearDetail.getImplResult() == 2 || planYearDetail.getImplResult() == 0 ? "selected" : "") + " value=\"" + planYearDetail.getId() + ":2\">\u672a\u5b9e\u65bd</option>\r\n\t\t\t\t\t\t\t\t\t\t</select>");
            }
        } else if (detailIds == null || detailIds.trim().isEmpty()) {
            list = new ArrayList();
        } else {
            detailIds = detailIds.substring(0, detailIds.length() - 1);
            list = this.planYearDetailServiceImpl.getListByIds(detailIds);
            for (PlanYearDetail planYearDetail : list) {
                planYearDetail.setModular((PlanYearModulars)this.planYearModularsService.getById(planYearDetail.getBussnissModularId()));
                planYearDetail.setManagerName(StaffUtil.getStaffFullNameById(planYearDetail.getManagerId()));
                planYearDetail.setImplManagerName(StaffUtil.getStaffFullNameById(planYearDetail.getImplManagerId()));
            }
        }
        PageInfo pageInfo = new PageInfo(list);
        JqGridData data = new JqGridData(pageInfo, param);
        return data;
    }

    @RequestMapping(value={"viewadd"}, method={RequestMethod.GET})
    public String page_viewAdd(Model model) {
        this.logger.info("\u5e74\u5ea6\u8ba1\u5212\u300b\u8be6\u7ec6\u8ba1\u5212\u300b\u65b0\u589e");
        StaffInfo staffInfo = this.staffInfoService.getStaffInfoWithStaffBasicWorkById(UserUtils.getLoginStaffId());
        model.addAttribute("staffInfo", (Object)staffInfo);
        return "work/planyear/dialog_addPlanYearDetail";
    }

    @RequestMapping(value={"viewedit/{id}"}, method={RequestMethod.GET})
    public String page_viewEdit(@PathVariable(value="id") Long id, Model model) {
        PlanYearDetail planYearDetail;
        this.logger.info("\u5e74\u5ea6\u8ba1\u5212\u300b\u8be6\u7ec6\u8ba1\u5212\u300b\u7f16\u8f91");
        StaffInfo staffInfo = this.staffInfoService.getStaffInfoWithStaffBasicWorkById(UserUtils.getLoginStaffId());
        model.addAttribute("staffInfo", (Object)staffInfo);
        if (id != null && (planYearDetail = (PlanYearDetail)this.planYearDetailServiceImpl.getById(id)) != null) {
            planYearDetail.setManagerName(StaffUtil.getStaffFullNameById(planYearDetail.getManagerId()));
            model.addAttribute("planYearDetail", (Object)planYearDetail);
        }
        return "work/planyear/dialog_editPlanYearDetail";
    }

    @Log(title="\u8be6\u7ec6\u8ba1\u5212\u65b0\u589e", type=20)
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"add"}, method={RequestMethod.POST})
    public ResponseData<String> ajax_addPlanYearDetail(PlanYearDetail planYearDetail, String details, Long planYearId) {
        this.logger.info("ajax-\u5e74\u5ea6\u8ba1\u5212\u300b\u8be6\u7ec6\u8ba1\u5212\u300b\u65b0\u589e");
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffid = UserUtils.getLoginStaffId();
        ResponseData r = new ResponseData();
        if (planYearDetail.getBussnissModularId() == null || planYearDetail.getBussnissModularId() == 0L) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u8bf7\u9009\u62e9\u5de5\u4f5c\u7c7b\u522b");
            return r;
        }
        if (StringUtils.isEmpty((CharSequence)planYearDetail.getPlanWorkName())) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u5de5\u4f5c\u540d\u79f0\u4e0d\u5f97\u4e3a\u7a7a");
            return r;
        }
        if (StringUtils.isEmpty((CharSequence)planYearDetail.getWorkContent())) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u5de5\u4f5c\u5185\u5bb9\u4e0d\u5f97\u4e3a\u7a7a");
            return r;
        }
        if (planYearDetail.getPlanImplDate() == null) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u8ba1\u5212\u5b9e\u65bd\u65e5\u671f\u4e0d\u5f97\u4e3a\u7a7a");
            return r;
        }
        if (planYearDetail.getManagerId() == null || planYearDetail.getManagerId() == 0L) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u5206\u914d\u4eba\u4e0d\u5f97\u4e3a\u7a7a");
            return r;
        }
        if (planYearId != null) {
            planYearDetail.setPlanYearId(planYearId);
        }
        if ((planYearDetail = (PlanYearDetail)this.planYearDetailServiceImpl.add((Object)planYearDetail, staffid, cid)).getPlanYearId() == null) {
            List<Object> list = null;
            if (details == null || details.trim().isEmpty()) {
                list = new ArrayList<PlanYearDetail>();
            } else {
                details = StringEscapeUtils.unescapeHtml((String)details);
                list = JSONObject.parseArray((String)details, PlanYearDetail.class);
            }
            list.add(planYearDetail);
            details = JSON.toJSON(list).toString();
            r.setResult((Object)details);
        }
        return r;
    }

    @Log(title="\u8be6\u7ec6\u8ba1\u5212\u7f16\u8f91", type=21)
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"edit"}, method={RequestMethod.POST})
    public ResponseData<String> ajax_editPlanYearDetail(PlanYearDetail planYearDetail, String details) {
        this.logger.info("ajax-\u5e74\u5ea6\u8ba1\u5212\u300b\u8be6\u7ec6\u8ba1\u5212\u300b\u7f16\u8f91");
        Long staffid = UserUtils.getLoginStaffId();
        ResponseData r = new ResponseData();
        if (planYearDetail.getId() == null) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u65e0\u6cd5\u83b7\u53d6\u8be5\u6761\u6570\u636e");
            return r;
        }
        if (planYearDetail.getBussnissModularId() == null || planYearDetail.getBussnissModularId() == 0L) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u8bf7\u9009\u62e9\u5de5\u4f5c\u7c7b\u522b");
            return r;
        }
        if (planYearDetail.getPlanWorkName() == null || planYearDetail.getPlanWorkName().trim().isEmpty()) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u5de5\u4f5c\u540d\u79f0\u4e0d\u5f97\u4e3a\u7a7a");
            return r;
        }
        if (planYearDetail.getWorkContent() == null || planYearDetail.getWorkContent().trim().isEmpty()) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u5de5\u4f5c\u5185\u5bb9\u4e0d\u5f97\u4e3a\u7a7a");
            return r;
        }
        if (planYearDetail.getPlanImplDate() == null) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u8ba1\u5212\u5b9e\u65bd\u65e5\u671f\u4e0d\u5f97\u4e3a\u7a7a");
            return r;
        }
        if (planYearDetail.getManagerId() == null || planYearDetail.getManagerId() == 0L) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u5206\u914d\u4eba\u4e0d\u5f97\u4e3a\u7a7a");
            return r;
        }
        this.planYearDetailServiceImpl.update((Object)planYearDetail, staffid);
        if (planYearDetail.getPlanYearId() == null) {
            List list = null;
            if (details == null || details.trim().isEmpty()) {
                list = new ArrayList();
            } else {
                details = StringEscapeUtils.unescapeHtml((String)details);
                list = JSONObject.parseArray((String)details, PlanYearDetail.class);
                for (PlanYearDetail planYearDetail2 : list) {
                    if (planYearDetail2.getId().longValue() != planYearDetail.getId().longValue()) continue;
                    planYearDetail2.setBussnissModularId(planYearDetail.getBussnissModularId());
                    planYearDetail2.setPlanWorkName(planYearDetail.getPlanWorkName());
                    planYearDetail2.setWorkContent(planYearDetail.getWorkContent());
                    planYearDetail2.setPlanImplDate(planYearDetail.getPlanImplDate());
                    planYearDetail2.setManagerId(planYearDetail.getManagerId());
                }
            }
            details = JSON.toJSON(list).toString();
            r.setResult((Object)details);
        }
        return r;
    }

    @Log(title="\u8be6\u7ec6\u8ba1\u5212\u5220\u9664", type=22)
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"del/{id}"}, method={RequestMethod.POST})
    public ResponseData<String> ajax_delPlanYearDetail(@PathVariable(value="id") Long id, String details) {
        this.logger.info("ajax-\u5e74\u5ea6\u8ba1\u5212\u300b\u8be6\u7ec6\u8ba1\u5212\u300b\u5220\u9664");
        Long staffid = UserUtils.getLoginStaffId();
        ResponseData r = new ResponseData();
        if (id != null) {
            PlanYearDetail planYearDetail = (PlanYearDetail)this.planYearDetailServiceImpl.getById(id);
            planYearDetail.setIsValid(Boolean.valueOf(false));
            this.planYearDetailServiceImpl.update((Object)planYearDetail, staffid);
            if (planYearDetail.getPlanYearId() == null) {
                List list = null;
                if (details == null || details.trim().isEmpty()) {
                    list = new ArrayList();
                } else {
                    Integer index = null;
                    details = StringEscapeUtils.unescapeHtml((String)details);
                    list = JSONObject.parseArray((String)details, PlanYearDetail.class);
                    for (int i = 0; i < list.size(); ++i) {
                        if (((PlanYearDetail)list.get(i)).getId().longValue() != planYearDetail.getId().longValue()) continue;
                        index = i;
                    }
                    if (index != null && index <= list.size()) {
                        list.remove(index);
                    }
                }
                details = JSON.toJSON(list).toString();
                r.setResult((Object)details);
            }
        } else {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u65e0\u6cd5\u83b7\u53d6\u8be5\u6761\u6570\u636e");
            if (details != null && !details.trim().isEmpty()) {
                r.setResult((Object)details);
            }
        }
        return r;
    }

    @RequestMapping(value={"getWorkSubtypeByWorkType"}, method={RequestMethod.GET})
    public String getWorkSubtypeByWorkType(ModelMap m, String workType, String workSubtype) {
        if ("1".equals(workType)) {
            m.put((Object)"subtypes", (Object)CheckTypeEnum.values());
        } else if ("2".equals(workType)) {
            m.put((Object)"subtypes", (Object)HcCheckTypeEnum.values());
        } else if ("3".equals(workType)) {
            m.put((Object)"subtypes", (Object)TrainPlanTypeEnum.values());
        } else if ("6".equals(workType)) {
            m.put((Object)"subtypes", (Object)InspectionTypeEnum.values());
        } else if (!"7".equals(workType) && "9".equals(workType)) {
            m.put((Object)"subtypes", (Object)EvaluateHseTypeEnum.values());
        }
        m.put((Object)"workType", (Object)workType);
        m.put((Object)"workSubtype", (Object)workSubtype);
        return "work/planyear/getWorkSubtypeByWorkType";
    }
}

