/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.work.planyear;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.excel.ExportExcel;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.web.repeatform.RepeatUrlFormData;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.entity.sys.message.Message;
import cn.smarthse.modules.health.entity.sys.message.MessageReceiver;
import cn.smarthse.modules.health.entity.work.planyear.PlanWorkTransferRecord;
import cn.smarthse.modules.health.entity.work.planyear.PlanYear;
import cn.smarthse.modules.health.entity.work.planyear.PlanYearDetail;
import cn.smarthse.modules.health.entity.work.planyear.PlanYearExpend;
import cn.smarthse.modules.health.entity.work.planyear.PlanYearModulars;
import cn.smarthse.modules.health.entity.work.planyear.PlanYearUploadFile;
import cn.smarthse.modules.health.entity.work.planyear.vo.PlanExpendStaticVo;
import cn.smarthse.modules.health.entity.work.planyear.vo.SearchParamVo;
import cn.smarthse.modules.health.enums.planyear.PlanYearDetailImplState;
import cn.smarthse.modules.health.enums.planyear.PlanYearExpendTypeEnum;
import cn.smarthse.modules.health.enums.sys.MessageBusinessFromEnum;
import cn.smarthse.modules.health.enums.sys.MessageBusinessTypeEnum;
import cn.smarthse.modules.health.service.sys.message.IMessageService;
import cn.smarthse.modules.health.service.work.planyear.IPlanWorkTransferRecordService;
import cn.smarthse.modules.health.service.work.planyear.IPlanYearDetailService;
import cn.smarthse.modules.health.service.work.planyear.IPlanYearExpendService;
import cn.smarthse.modules.health.service.work.planyear.IPlanYearModularsService;
import cn.smarthse.modules.health.service.work.planyear.IPlanYearService;
import cn.smarthse.modules.health.service.work.planyear.IPlanYearUploadFileService;
import cn.smarthse.modules.health.vo.work.yearplan.NeedDecomposeWorkPlan;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.DocUtil;
import cn.smarthse.web.util.StaffUtil;
import cn.smarthse.web.util.SyncBusinessUtil;
import cn.smarthse.web.util.UserUtils;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/work/planyear"})
public class PlanYearController
extends ControllerSupport {
    @DubboReference
    IPlanYearService planYearServiceImpl;
    @DubboReference
    IPlanYearUploadFileService planYearUploadFileServiceImpl;
    @DubboReference
    IPlanYearDetailService planYearDetailServiceImpl;
    @DubboReference
    IPlanYearExpendService planYearExpendServiceImpl;
    @DubboReference
    IPlanYearModularsService planYearModularsService;
    @DubboReference
    IPlanWorkTransferRecordService planWorkTransferRecordService;
    @DubboReference(timeout=5000000)
    ISysFileProvideService sysFileServiceImpl;
    @DubboReference
    IMessageService messageService;

    @Log(title="\u5e74\u5ea6\u8ba1\u5212\u300b\u5e74\u5ea6\u8ba1\u5212\u8ba1\u5212\u6e05\u5355(\u8fdb\u884c\u4e2d)", type=2)
    @RequestMapping(value={"planlist"}, method={RequestMethod.GET})
    public String page_planList() {
        this.logger.info("\u5e74\u5ea6\u8ba1\u5212\u300b\u5e74\u5ea6\u8ba1\u5212\u8ba1\u5212\u6e05\u5355(\u8fdb\u884c\u4e2d)");
        return "work/planyear/plan_list";
    }

    @Log(title="\u5e74\u5ea6\u8ba1\u5212\u8ba1\u5212\u6e05\u5355(\u8fdb\u884c\u4e2d)\u5217\u8868\u6570\u636e", type=2)
    @ResponseBody
    @RequestMapping(value={"planlistData"})
    public JqGridData<PlanYear> planListData(JqGridParam param) {
        this.logger.info(param.toString());
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffid = UserUtils.getLoginStaffId();
        param.setCid(cid);
        UserUtils.startWebDataScope();
        PageInfo pageInfo = this.planYearServiceImpl.getPlanYearListByGridParam(param);
        JqGridData data = new JqGridData(pageInfo, param);
        return data;
    }

    @Log(title="\u5e74\u5ea6\u8ba1\u5212\u603b\u7ed3\u6e05\u5355(\u8fdb\u884c\u4e2d)\u5217\u8868\u9875", type=2)
    @RequestMapping(value={"summarylist"}, method={RequestMethod.GET})
    public String page_summaryList() {
        this.logger.info("\u5e74\u5ea6\u8ba1\u5212\u300b\u5e74\u5ea6\u8ba1\u5212\u603b\u7ed3\u6e05\u5355(\u8fdb\u884c\u4e2d)");
        return "work/planyear/summary_list";
    }

    @Log(title="\u5e74\u5ea6\u8ba1\u5212\u603b\u7ed3\u6e05\u5355(\u8fdb\u884c\u4e2d)\u5217\u8868\u6570\u636e", type=2)
    @ResponseBody
    @RequestMapping(value={"summarylistData"})
    public JqGridData<PlanYear> summaryListData(JqGridParam param) {
        this.logger.info(param.toString());
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffid = UserUtils.getLoginStaffId();
        param.setCid(cid);
        UserUtils.startWebDataScope();
        PageInfo pageInfo = this.planYearServiceImpl.getPlanYearListByGridParam(param);
        JqGridData data = new JqGridData(pageInfo, param);
        return data;
    }

    @Log(title="\u5e74\u5ea6\u8ba1\u5212\u8ba1\u5212\u6e05\u5355(\u5df2\u5b8c\u6210)\u5217\u8868\u9875", type=2)
    @RequestMapping(value={"plancompletelist"}, method={RequestMethod.GET})
    public String page_planCompleteList() {
        this.logger.info("\u5e74\u5ea6\u8ba1\u5212\u300b\u5e74\u5ea6\u8ba1\u5212\u8ba1\u5212\u6e05\u5355(\u5df2\u5b8c\u6210)");
        return "work/planyear/planComplete_list";
    }

    @ResponseBody
    @Log(title="\u5e74\u5ea6\u8ba1\u5212\u8ba1\u5212\u6e05\u5355(\u5df2\u5b8c\u6210)\u5217\u8868\u6570\u636e", type=2)
    @RequestMapping(value={"plancompletelistData"})
    public JqGridData<PlanYear> planCompleteListData(JqGridParam param) {
        this.logger.info(param.toString());
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        PageInfo pageInfo = this.planYearServiceImpl.getPlanCompleteListByCid(param);
        for (PlanYear planYear : pageInfo.getList()) {
            planYear.setStaffName(StaffUtil.getStaffFullNameById(planYear.getCreateBy()));
        }
        JqGridData data = new JqGridData(pageInfo, param);
        return data;
    }

    @Log(title="\u5e74\u5ea6\u8ba1\u5212\u300b\u5e74\u5ea6\u8ba1\u5212\u603b\u7ed3\u6e05\u5355(\u5df2\u5b8c\u6210)", type=2)
    @RequestMapping(value={"summarycompletelist"}, method={RequestMethod.GET})
    public String page_summaryCompleteList() {
        this.logger.info("\u5e74\u5ea6\u8ba1\u5212\u300b\u5e74\u5ea6\u8ba1\u5212\u603b\u7ed3\u6e05\u5355(\u5df2\u5b8c\u6210)");
        return "work/planyear/summaryComplete_list";
    }

    @Log(title="\u5e74\u5ea6\u8ba1\u5212\u603b\u7ed3\u6e05\u5355(\u5df2\u5b8c\u6210)\u5217\u8868\u6570\u636e", type=2)
    @ResponseBody
    @RequestMapping(value={"summarycompletelistData"})
    public JqGridData<PlanYear> summaryCompleteListData(JqGridParam param) {
        this.logger.info(param.toString());
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        PageInfo pageInfo = this.planYearServiceImpl.getSummaryCompleteListByCid(param);
        for (PlanYear planYear : pageInfo.getList()) {
            planYear.setStaffName(StaffUtil.getStaffFullNameById(planYear.getCreateBy()));
        }
        JqGridData data = new JqGridData(pageInfo, param);
        return data;
    }

    @Log(title="\u5e74\u5ea6\u8ba1\u5212\u65b0\u589e\u9875", type=20)
    @RequiresPermissions(value={"yearPlan.edit"})
    @RequestMapping(value={"viewaddplan"}, method={RequestMethod.GET})
    public String page_viewAddPlan(Model model, String details, String expends, String[] form, String fileId2) {
        this.logger.info("\u5e74\u5ea6\u8ba1\u5212\u300b\u65b0\u589e");
        ArrayList<Integer> list = new ArrayList<Integer>();
        Calendar calendar = Calendar.getInstance();
        Integer year = calendar.get(1);
        list.add(year + 2);
        list.add(year + 1);
        list.add(year);
        list.add(year - 1);
        list.add(year - 2);
        model.addAttribute("list", list);
        model.addAttribute("details", (Object)details);
        if (details != null && !details.trim().isEmpty()) {
            Object detailIds = "";
            details = StringEscapeUtils.unescapeHtml((String)details);
            List list2 = JSONObject.parseArray((String)details, PlanYearDetail.class);
            for (PlanYearDetail planYearDetail : list2) {
                detailIds = (String)detailIds + planYearDetail.getId() + ",";
            }
            model.addAttribute("detailIds", detailIds);
        }
        model.addAttribute("expends", (Object)expends);
        BigDecimal budgetTotal = new BigDecimal(0);
        if (expends != null && !expends.trim().isEmpty()) {
            Object expendIds = "";
            expends = StringEscapeUtils.unescapeHtml((String)expends);
            List list3 = JSONObject.parseArray((String)expends, PlanYearExpend.class);
            for (PlanYearExpend planYearExpend : list3) {
                expendIds = (String)expendIds + planYearExpend.getId() + ",";
                if (planYearExpend.getBudgetMoney() == null) continue;
                BigDecimal budget = new BigDecimal(planYearExpend.getBudgetMoney().toString());
                budgetTotal = budgetTotal.add(budget);
            }
            model.addAttribute("expendIds", expendIds);
        }
        model.addAttribute("budgetTotal", (Object)budgetTotal);
        if (form != null && form.length >= 3) {
            PlanYear planYear = new PlanYear();
            planYear.setScheduleYear(form[0]);
            planYear.setPlanName(form[1]);
            planYear.setPlanContent(form[2]);
            model.addAttribute("planYear", (Object)planYear);
        }
        if (fileId2 != null && !fileId2.trim().isEmpty()) {
            List fileList = this.sysFileServiceImpl.getListByIds(fileId2);
            model.addAttribute("fileList", (Object)fileList);
        }
        return "work/planyear/plan";
    }

    @Log(title="\u5e74\u5ea6\u8ba1\u5212\u300b\u8ba1\u5212\u9636\u6bb5\u7f16\u8f91", type=21)
    @RequestMapping(value={"vieweditplan/{id}"}, method={RequestMethod.GET})
    public String page_viewEditPlan(@PathVariable(value="id") Long id, Model model, Byte isCreateBy) {
        this.logger.info("\u5e74\u5ea6\u8ba1\u5212\u300b\u8ba1\u5212\u9636\u6bb5\u7f16\u8f91");
        ArrayList<Integer> list = new ArrayList<Integer>();
        Calendar calendar = Calendar.getInstance();
        Integer year = calendar.get(1);
        list.add(year + 2);
        list.add(year + 1);
        list.add(year);
        list.add(year - 1);
        list.add(year - 2);
        model.addAttribute("list", list);
        if (id != null) {
            PlanYear planYear = (PlanYear)this.planYearServiceImpl.getById(id);
            if (planYear != null) {
                model.addAttribute("planYear", (Object)planYear);
                ArrayList<SysFileModel> fileList = new ArrayList<SysFileModel>();
                Object fileId2 = "";
                List planYearUploadFileList = this.planYearUploadFileServiceImpl.getByPlanYearId(planYear.getId(), Byte.valueOf((byte)1));
                for (PlanYearUploadFile planYearUploadFile : planYearUploadFileList) {
                    if (planYearUploadFile.getFileId() == null) continue;
                    SysFileModel sysFile = this.sysFileServiceImpl.getFileById(planYearUploadFile.getFileId());
                    fileList.add(sysFile);
                    fileId2 = (String)fileId2 + sysFile.getId() + ",";
                }
                model.addAttribute("fileId2", fileId2);
                model.addAttribute("fileList", fileList);
            }
            BigDecimal budgetTotal = new BigDecimal(0);
            JqGridParam param = new JqGridParam();
            Long cid = UserUtils.getLoginStaffCompanyId();
            param.setCid(cid);
            param.setId(id);
            List planYearExpendList = this.planYearExpendServiceImpl.getPlanYearExpendListByGridParam(param);
            for (PlanYearExpend planYearExpend : planYearExpendList) {
                if (planYearExpend.getBudgetMoney() == null) continue;
                BigDecimal budget = new BigDecimal(planYearExpend.getBudgetMoney().toString());
                budgetTotal = budgetTotal.add(budget);
            }
            model.addAttribute("budgetTotal", (Object)budgetTotal);
        }
        Boolean isHas = UserUtils.hasPermissionCode("yearPlan.edit");
        if (isCreateBy != null && isCreateBy == 1 && isHas != null && isHas.booleanValue()) {
            return "work/planyear/plan";
        }
        return "work/planyear/plan_view";
    }

    @RequestMapping(value={"viewAdmineditplan/{id}"}, method={RequestMethod.GET})
    public String page_viewAdminEditPlan(@PathVariable(value="id") Long id, Model model, Byte isCreateBy) {
        this.logger.info("\u5e74\u5ea6\u8ba1\u5212\u300b\u8ba1\u5212\u9636\u6bb5\u7f16\u8f91");
        ArrayList<Integer> list = new ArrayList<Integer>();
        Calendar calendar = Calendar.getInstance();
        Integer year = calendar.get(1);
        list.add(year + 2);
        list.add(year + 1);
        list.add(year);
        list.add(year - 1);
        list.add(year - 2);
        model.addAttribute("list", list);
        if (id != null) {
            PlanYear planYear = (PlanYear)this.planYearServiceImpl.getById(id);
            if (planYear != null) {
                model.addAttribute("planYear", (Object)planYear);
                ArrayList<SysFileModel> fileList = new ArrayList<SysFileModel>();
                Object fileId2 = "";
                List planYearUploadFileList = this.planYearUploadFileServiceImpl.getByPlanYearId(planYear.getId(), Byte.valueOf((byte)1));
                for (PlanYearUploadFile planYearUploadFile : planYearUploadFileList) {
                    if (planYearUploadFile.getFileId() == null) continue;
                    SysFileModel sysFile = this.sysFileServiceImpl.getFileById(planYearUploadFile.getFileId());
                    fileList.add(sysFile);
                    fileId2 = (String)fileId2 + sysFile.getId() + ",";
                }
                model.addAttribute("fileId2", fileId2);
                model.addAttribute("fileList", fileList);
            }
            BigDecimal budgetTotal = new BigDecimal(0);
            JqGridParam param = new JqGridParam();
            Long cid = UserUtils.getLoginStaffCompanyId();
            param.setCid(cid);
            param.setId(id);
            List planYearExpendList = this.planYearExpendServiceImpl.getPlanYearExpendListByGridParam(param);
            for (PlanYearExpend planYearExpend : planYearExpendList) {
                if (planYearExpend.getBudgetMoney() == null) continue;
                BigDecimal budget = new BigDecimal(planYearExpend.getBudgetMoney().toString());
                budgetTotal = budgetTotal.add(budget);
            }
            model.addAttribute("budgetTotal", (Object)budgetTotal);
        }
        return "work/planyear/planAdmin";
    }

    @Log(title="\u5e74\u5ea6\u8ba1\u5212(\u603b\u7ed3\u9636\u6bb5)\u7f16\u8f91\u9875", type=21)
    @RequestMapping(value={"vieweditsummary/{id}"}, method={RequestMethod.GET})
    public String page_viewEditSummary(@PathVariable(value="id") Long id, Model model, Byte isCreateBy) {
        this.logger.info("\u5e74\u5ea6\u8ba1\u5212\u300b\u603b\u7ed3\u9636\u6bb5\u7f16\u8f91");
        if (id != null) {
            PlanYear planYear = (PlanYear)this.planYearServiceImpl.getById(id);
            if (planYear != null) {
                model.addAttribute("planYear", (Object)planYear);
                ArrayList<SysFileModel> fileList = new ArrayList<SysFileModel>();
                List planYearUploadFileList = this.planYearUploadFileServiceImpl.getByPlanYearId(planYear.getId(), Byte.valueOf((byte)2));
                Object fileId2 = "";
                for (PlanYearUploadFile planYearUploadFile : planYearUploadFileList) {
                    if (planYearUploadFile.getFileId() == null) continue;
                    SysFileModel sysFile = this.sysFileServiceImpl.getFileById(planYearUploadFile.getFileId());
                    fileList.add(sysFile);
                    fileId2 = (String)fileId2 + sysFile.getId() + ",";
                }
                model.addAttribute("fileList", fileList);
                model.addAttribute("fileId2", fileId2);
            }
            BigDecimal budgetTotal = new BigDecimal(0);
            BigDecimal actualTotal = new BigDecimal(0);
            JqGridParam param = new JqGridParam();
            Long cid = UserUtils.getLoginStaffCompanyId();
            param.setCid(cid);
            param.setId(id);
            List planYearExpendList = this.planYearExpendServiceImpl.getPlanYearExpendListByGridParam(param);
            for (PlanYearExpend planYearExpend : planYearExpendList) {
                if (planYearExpend.getBudgetMoney() != null) {
                    BigDecimal budget = new BigDecimal(planYearExpend.getBudgetMoney().toString());
                    budgetTotal = budgetTotal.add(budget);
                }
                if (planYearExpend.getActualMoney() == null) continue;
                BigDecimal actual = new BigDecimal(planYearExpend.getActualMoney().toString());
                actualTotal = actualTotal.add(actual);
            }
            model.addAttribute("budgetTotal", (Object)budgetTotal);
            model.addAttribute("actualTotal", (Object)actualTotal);
        }
        Boolean isHas = UserUtils.hasPermissionCode("yearPlan.edit");
        if (isCreateBy != null && isCreateBy == 1 && isHas != null && isHas.booleanValue()) {
            return "work/planyear/summary";
        }
        return "work/planyear/summary_view";
    }

    @Log(title="\u5e74\u5ea6\u8ba1\u5212\u300b\u603b\u7ed3\u9636\u6bb5\u7f16\u8f91", type=21)
    @RequestMapping(value={"page_viewAdminEditSummary/{id}"}, method={RequestMethod.GET})
    public String page_viewAdminEditSummary(@PathVariable(value="id") Long id, Model model, Byte isCreateBy) {
        this.logger.info("\u5e74\u5ea6\u8ba1\u5212\u300b\u603b\u7ed3\u9636\u6bb5\u7f16\u8f91");
        if (id != null) {
            PlanYear planYear = (PlanYear)this.planYearServiceImpl.getById(id);
            if (planYear != null) {
                model.addAttribute("planYear", (Object)planYear);
                ArrayList<SysFileModel> fileList = new ArrayList<SysFileModel>();
                List planYearUploadFileList = this.planYearUploadFileServiceImpl.getByPlanYearId(planYear.getId(), Byte.valueOf((byte)2));
                Object fileId2 = "";
                for (PlanYearUploadFile planYearUploadFile : planYearUploadFileList) {
                    if (planYearUploadFile.getFileId() == null) continue;
                    SysFileModel sysFile = this.sysFileServiceImpl.getFileById(planYearUploadFile.getFileId());
                    fileList.add(sysFile);
                    fileId2 = (String)fileId2 + sysFile.getId() + ",";
                }
                model.addAttribute("fileList", fileList);
                model.addAttribute("fileId2", fileId2);
            }
            BigDecimal budgetTotal = new BigDecimal(0);
            BigDecimal actualTotal = new BigDecimal(0);
            JqGridParam param = new JqGridParam();
            Long cid = UserUtils.getLoginStaffCompanyId();
            param.setCid(cid);
            param.setId(id);
            List planYearExpendList = this.planYearExpendServiceImpl.getPlanYearExpendListByGridParam(param);
            for (PlanYearExpend planYearExpend : planYearExpendList) {
                if (planYearExpend.getBudgetMoney() != null) {
                    BigDecimal budget = new BigDecimal(planYearExpend.getBudgetMoney().toString());
                    budgetTotal = budgetTotal.add(budget);
                }
                if (planYearExpend.getActualMoney() == null) continue;
                BigDecimal actual = new BigDecimal(planYearExpend.getActualMoney().toString());
                actualTotal = actualTotal.add(actual);
            }
            model.addAttribute("budgetTotal", (Object)budgetTotal);
            model.addAttribute("actualTotal", (Object)actualTotal);
        }
        return "work/planyear/summaryAdmin";
    }

    @Log(title="ajax-\u5e74\u5ea6\u8ba1\u5212\u300b\u8ba1\u5212\u9636\u6bb5(\u5b58\u8349\u7a3f)", type=20)
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"adddraft"}, method={RequestMethod.POST})
    public ResponseData<String> ajax_addPlanDraft(PlanYear planYear, Long[] fileId2, String details, String expends) {
        this.logger.info("ajax-\u5e74\u5ea6\u8ba1\u5212\u300b\u8ba1\u5212\u9636\u6bb5(\u5b58\u8349\u7a3f)");
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffid = UserUtils.getLoginStaffId();
        ResponseData r = new ResponseData();
        planYear.setStage(Byte.valueOf((byte)1));
        if (planYear.getId() == null) {
            String id = this.planYearServiceImpl.addPlanYear(cid, staffid, planYear, fileId2, details, expends);
            r.setResult((Object)id);
        } else {
            String id = this.planYearServiceImpl.updatePlanYear(cid, staffid, planYear, fileId2, Byte.valueOf((byte)1));
            r.setResult((Object)id);
        }
        return r;
    }

    @Log(title="\u5f02\u6b65\u5e74\u5ea6\u8ba1\u5212\u8ba1\u5212\u9636\u6bb5(\u5b8c\u6210)", type=20)
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"add"}, method={RequestMethod.POST})
    public ResponseData<String> ajax_addPlan(PlanYear planYear, Long[] fileId2, String details, String expends) {
        this.logger.info("ajax-\u5e74\u5ea6\u8ba1\u5212\u300b\u8ba1\u5212\u9636\u6bb5(\u5b8c\u6210)");
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffid = UserUtils.getLoginStaffId();
        ResponseData r = new ResponseData();
        if (planYear.getScheduleYear() == null || planYear.getScheduleYear().trim().isEmpty()) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u8bf7\u9009\u62e9\u5e74\u5ea6");
            return r;
        }
        if (planYear.getPlanName() == null || planYear.getPlanName().trim().isEmpty()) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u8ba1\u5212\u540d\u79f0\u4e0d\u5f97\u4e3a\u7a7a");
            return r;
        }
        planYear.setStage(Byte.valueOf((byte)2));
        String id = null;
        id = planYear.getId() == null ? this.planYearServiceImpl.addPlanYear(cid, staffid, planYear, fileId2, details, expends) : this.planYearServiceImpl.updatePlanYear(cid, staffid, planYear, fileId2, Byte.valueOf((byte)1));
        planYear.setId(Long.valueOf(id));
        SyncBusinessUtil.syncBusinessWorkByPlanYear(planYear);
        r.setResult((Object)id);
        return r;
    }

    @Log(title="\u5e74\u5ea6\u8ba1\u5212\u7f16\u8f91", type=21)
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"editsummarydraft"}, method={RequestMethod.POST})
    public ResponseData<String> ajax_editSummaryDraft(PlanYear planYear, Long[] fileId2) {
        this.logger.info("ajax-\u5e74\u5ea6\u8ba1\u5212\u300b\u603b\u7ed3\u9636\u6bb5(\u5b58\u8349\u7a3f)");
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffid = UserUtils.getLoginStaffId();
        ResponseData r = new ResponseData();
        if (planYear.getId() == null) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u65e0\u6cd5\u83b7\u53d6\u8be5\u6761\u6570\u636e");
            return r;
        }
        JqGridParam param = new JqGridParam();
        param.setCid(cid);
        param.setId(planYear.getId());
        String id = this.planYearServiceImpl.updatePlanYear(cid, staffid, planYear, fileId2, Byte.valueOf((byte)2));
        r.setResult((Object)id);
        return r;
    }

    @Log(title="\u5e74\u5ea6\u8ba1\u5212\u7f16\u8f91", type=21)
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"editsummary"}, method={RequestMethod.POST})
    public ResponseData<String> ajax_editSummary(PlanYear planYear, Long[] fileId2) {
        this.logger.info("ajax-\u5e74\u5ea6\u8ba1\u5212\u300b\u603b\u7ed3\u9636\u6bb5(\u5b58\u8349\u7a3f)");
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffid = UserUtils.getLoginStaffId();
        ResponseData r = new ResponseData();
        if (planYear.getId() == null) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u65e0\u6cd5\u83b7\u53d6\u8be5\u6761\u6570\u636e");
            return r;
        }
        boolean x = false;
        JqGridParam param = new JqGridParam();
        param.setCid(cid);
        param.setId(planYear.getId());
        List expendList = this.planYearExpendServiceImpl.getPlanYearExpendListByGridParam(param);
        for (PlanYearExpend planYearExpend : expendList) {
            if (planYearExpend.getActualMoney() != null) continue;
            x = true;
            break;
        }
        if (x) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u8bf7\u586b\u5199\u9884\u7b97\u5b9e\u9645\u82b1\u8d39");
            return r;
        }
        planYear.setStage(Byte.valueOf((byte)3));
        String id = this.planYearServiceImpl.updatePlanYear(cid, staffid, planYear, fileId2, Byte.valueOf((byte)2));
        r.setResult((Object)id);
        return r;
    }

    @Log(title="\u5e74\u5ea6\u8ba1\u5212\u5220\u9664", type=22)
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"del/{id}"}, method={RequestMethod.POST})
    public ResponseData<String> ajax_delMsPohop(@PathVariable(value="id") Long id) {
        this.logger.info("ajax-\u5e74\u5ea6\u8ba1\u5212\u300b\u5220\u9664");
        Long staffid = UserUtils.getLoginStaffId();
        ResponseData r = new ResponseData();
        if (id == null) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u65e0\u6cd5\u83b7\u53d6\u8be5\u6761\u6570\u636e");
            return r;
        }
        PlanYear planYear = (PlanYear)this.planYearServiceImpl.getById(id);
        planYear.setIsValid(Boolean.valueOf(false));
        this.planYearServiceImpl.update((Object)planYear, staffid);
        return new ResponseData();
    }

    @RequestMapping(value={"viewplancomplete/{id}"}, method={RequestMethod.GET})
    public String page_viewPlanComplete(@PathVariable(value="id") Long id, Model model) {
        this.logger.info("\u5e74\u5ea6\u8ba1\u5212\u300b\u8ba1\u5212\u5df2\u5b8c\u6210\u9875");
        if (id != null) {
            PlanYear planYear = (PlanYear)this.planYearServiceImpl.getById(id);
            if (planYear != null) {
                model.addAttribute("planYear", (Object)planYear);
                ArrayList<SysFileModel> fileList = new ArrayList<SysFileModel>();
                List planYearUploadFileList = this.planYearUploadFileServiceImpl.getByPlanYearId(planYear.getId(), Byte.valueOf((byte)1));
                for (PlanYearUploadFile planYearUploadFile : planYearUploadFileList) {
                    if (planYearUploadFile.getFileId() == null) continue;
                    SysFileModel sysFile = this.sysFileServiceImpl.getFileById(planYearUploadFile.getFileId());
                    fileList.add(sysFile);
                }
                model.addAttribute("fileList", fileList);
            }
            BigDecimal budgetTotal = new BigDecimal(0);
            JqGridParam param = new JqGridParam();
            Long cid = UserUtils.getLoginStaffCompanyId();
            param.setCid(cid);
            param.setId(id);
            List planYearExpendList = this.planYearExpendServiceImpl.getPlanYearExpendListByGridParam(param);
            for (PlanYearExpend planYearExpend : planYearExpendList) {
                if (planYearExpend.getBudgetMoney() == null) continue;
                BigDecimal budget = new BigDecimal(planYearExpend.getBudgetMoney().toString());
                budgetTotal = budgetTotal.add(budget);
            }
            model.addAttribute("budgetTotal", (Object)budgetTotal);
        }
        return "work/planyear/planComplete";
    }

    @RequestMapping(value={"viewsummarycomplete/{id}"}, method={RequestMethod.GET})
    public String page_viewSummaryComplete(@PathVariable(value="id") Long id, Model model) {
        this.logger.info("\u5e74\u5ea6\u8ba1\u5212\u300b\u603b\u7ed3\u5df2\u5b8c\u6210");
        if (id != null) {
            PlanYear planYear = (PlanYear)this.planYearServiceImpl.getById(id);
            if (planYear != null) {
                model.addAttribute("planYear", (Object)planYear);
                ArrayList<SysFileModel> fileList = new ArrayList<SysFileModel>();
                List planYearUploadFileList = this.planYearUploadFileServiceImpl.getByPlanYearId(planYear.getId(), Byte.valueOf((byte)2));
                for (PlanYearUploadFile planYearUploadFile : planYearUploadFileList) {
                    if (planYearUploadFile.getFileId() == null) continue;
                    SysFileModel sysFile = this.sysFileServiceImpl.getFileById(planYearUploadFile.getFileId());
                    fileList.add(sysFile);
                }
                model.addAttribute("fileList", fileList);
            }
            BigDecimal budgetTotal = new BigDecimal(0);
            BigDecimal actualTotal = new BigDecimal(0);
            JqGridParam param = new JqGridParam();
            Long cid = UserUtils.getLoginStaffCompanyId();
            param.setCid(cid);
            param.setId(id);
            List planYearExpendList = this.planYearExpendServiceImpl.getPlanYearExpendListByGridParam(param);
            for (PlanYearExpend planYearExpend : planYearExpendList) {
                if (planYearExpend.getBudgetMoney() != null) {
                    BigDecimal budget = new BigDecimal(planYearExpend.getBudgetMoney().toString());
                    budgetTotal = budgetTotal.add(budget);
                }
                if (planYearExpend.getActualMoney() == null) continue;
                BigDecimal actual = new BigDecimal(planYearExpend.getActualMoney().toString());
                actualTotal = actualTotal.add(actual);
            }
            model.addAttribute("budgetTotal", (Object)budgetTotal);
            model.addAttribute("actualTotal", (Object)actualTotal);
        }
        return "work/planyear/summaryComplete";
    }

    @Log(title="\u5e74\u5ea6\u8ba1\u5212\u5bfc\u51fa", type=24)
    @RequestMapping(value={"/planexport/{id}"})
    public void planExport(@PathVariable(value="id") Long id, HttpServletResponse response) {
        this.logger.info("ajax-\u3010\u5e74\u5ea6\u8ba1\u5212(\u8ba1\u5212\u5df2\u5b8c\u6210)\u3011-\u5bfc\u51faWord");
        try {
            if (id != null) {
                JqGridParam param = new JqGridParam();
                param.setId(id);
                PlanYear planYear = (PlanYear)this.planYearServiceImpl.getById(id);
                List detailList = this.planYearDetailServiceImpl.getPlanYearDetailListByGridParam(param);
                List expendList = this.planYearExpendServiceImpl.getPlanYearExpendListByGridParam(param);
                List planYearUploadFileList = this.planYearUploadFileServiceImpl.getByPlanYearId(id, Byte.valueOf((byte)1));
                for (Object datail : detailList) {
                    datail.setManagerName(StaffUtil.getStaffFullNameById(datail.getManagerId()));
                    datail.setImplManagerName(StaffUtil.getStaffFullNameById(datail.getImplManagerId()));
                    datail.setModular((PlanYearModulars)this.planYearModularsService.getById(datail.getBussnissModularId()));
                    datail.setImplState(PlanYearDetailImplState.get((Byte)datail.getImplResult()));
                    datail.setImplStateName(datail.getImplState().getName());
                }
                BigDecimal total = new BigDecimal("0");
                for (Object expend : expendList) {
                    expend.setTypeName(PlanYearExpendTypeEnum.getName((Integer)expend.getExpendType().intValue()));
                    total = total.add(expend.getBudgetMoney());
                }
                ArrayList<SysFileModel> fileList = new ArrayList<SysFileModel>();
                for (PlanYearUploadFile planYearUploadFile : planYearUploadFileList) {
                    if (planYearUploadFile.getFileId() == null) continue;
                    SysFileModel sysFile = this.sysFileServiceImpl.getFileById(planYearUploadFile.getFileId());
                    fileList.add(sysFile);
                }
                HashMap<String, Object> dataMap = new HashMap<String, Object>();
                dataMap.put("planYear", planYear);
                dataMap.put("detailList", detailList);
                dataMap.put("expendList", expendList);
                dataMap.put("fileList", fileList);
                dataMap.put("total", total);
                Object fileName = "\u5e74\u5ea6\u8ba1\u5212-\u8ba1\u5212\u9636\u6bb5";
                fileName = (String)fileName + ".doc";
                response.setContentType("application/x-download");
                response.setHeader("Content-disposition", "attachment; filename=" + new String(((String)fileName).getBytes("gbk"), "iso8859-1"));
                DocUtil docUtil = new DocUtil();
                docUtil.createDoc(dataMap, "yearPlan.ftl", response.getWriter(), "/templates/files/planyear/");
            }
        }
        catch (Exception e) {
            this.logger.info(this.getExceptionDetail(e));
        }
    }

    @Log(title="\u5e74\u5ea6\u8ba1\u5212\u5bfc\u51fa", type=24)
    @RequestMapping(value={"/summaryexport/{id}"})
    public void summaryExport(@PathVariable(value="id") Long id, HttpServletResponse response) {
        this.logger.info("ajax-\u3010\u5e74\u5ea6\u8ba1\u5212(\u603b\u7ed3\u5df2\u5b8c\u6210)\u3011-\u5bfc\u51faWord");
        try {
            if (id != null) {
                JqGridParam param = new JqGridParam();
                param.setId(id);
                PlanYear planYear = (PlanYear)this.planYearServiceImpl.getById(id);
                List detailList = this.planYearDetailServiceImpl.getPlanYearDetailListByGridParam(param);
                List expendList = this.planYearExpendServiceImpl.getPlanYearExpendListByGridParam(param);
                List planYearUploadFileList = this.planYearUploadFileServiceImpl.getByPlanYearId(id, Byte.valueOf((byte)2));
                for (PlanYearDetail datail : detailList) {
                    datail.setManagerName(StaffUtil.getStaffFullNameById(datail.getManagerId()));
                    datail.setImplManagerName(StaffUtil.getStaffFullNameById(datail.getImplManagerId()));
                    datail.setModular((PlanYearModulars)this.planYearModularsService.getById(datail.getBussnissModularId()));
                    datail.setImplState(PlanYearDetailImplState.get((Byte)datail.getImplResult()));
                    datail.setImplStateName(datail.getImplResult() == 0 ? "\u672a\u5b9e\u65bd" : datail.getImplState().getName());
                    if (!StringUtils.isNotEmpty((String)datail.getImplWorkName())) {
                        datail.setImplWorkName(datail.getPlanWorkName());
                    }
                    if (datail.getImplStartDate() != null) {
                        if (datail.getImplEndDate() != null) {
                            datail.setImplateDateStr(DateUtils.format((Date)datail.getImplStartDate(), (String)"yyyy-MM-dd") + "\u81f3" + DateUtils.format((Date)datail.getImplEndDate(), (String)"yyyy-MM-dd"));
                        } else {
                            datail.setImplateDateStr(DateUtils.format((Date)datail.getImplStartDate(), (String)"yyyy-MM-dd"));
                        }
                    } else if (datail.getPlanImplDate() != null) {
                        datail.setImplateDateStr(DateUtils.format((Date)datail.getPlanImplDate(), (String)"yyyy-MM-dd"));
                    }
                    if (StringUtils.isNotEmpty((String)datail.getImplManagerName())) continue;
                    datail.setImplManagerName(datail.getManagerName());
                }
                BigDecimal budgetTotal = new BigDecimal("0");
                BigDecimal actualTotal = new BigDecimal("0");
                for (Object expend : expendList) {
                    expend.setTypeName(PlanYearExpendTypeEnum.getName((Integer)expend.getExpendType().intValue()));
                    expend.setStaffName(StaffUtil.getStaffFullNameById(expend.getManagerId()));
                    if (expend.getBudgetMoney() != null) {
                        budgetTotal = budgetTotal.add(expend.getBudgetMoney());
                    }
                    if (expend.getActualMoney() == null) continue;
                    actualTotal = actualTotal.add(expend.getActualMoney());
                }
                ArrayList<SysFileModel> fileList = new ArrayList<SysFileModel>();
                for (PlanYearUploadFile planYearUploadFile : planYearUploadFileList) {
                    if (planYearUploadFile.getFileId() == null) continue;
                    SysFileModel sysFile = this.sysFileServiceImpl.getFileById(planYearUploadFile.getFileId());
                    fileList.add(sysFile);
                }
                HashMap<String, Object> dataMap = new HashMap<String, Object>();
                dataMap.put("planYear", planYear);
                dataMap.put("detailList", detailList);
                dataMap.put("expendList", expendList);
                dataMap.put("fileList", fileList);
                dataMap.put("budgetTotal", budgetTotal);
                dataMap.put("actualTotal", actualTotal);
                Object fileName = "\u5e74\u5ea6\u8ba1\u5212-\u603b\u7ed3\u9636\u6bb5";
                fileName = (String)fileName + ".doc";
                response.setContentType("application/x-download");
                response.setHeader("Content-disposition", "attachment; filename=" + new String(((String)fileName).getBytes("gbk"), "iso8859-1"));
                DocUtil docUtil = new DocUtil();
                docUtil.createDoc(dataMap, "yearSummary.ftl", response.getWriter(), "/templates/files/planyear/");
            }
        }
        catch (Exception e) {
            this.logger.info(this.getExceptionDetail(e));
        }
    }

    public String getExceptionDetail(Exception e) {
        StringBuffer msg = new StringBuffer("null");
        if (e != null) {
            msg = new StringBuffer("");
            String message = e.toString();
            int length = e.getStackTrace().length;
            if (length > 0) {
                msg.append(message + "\n");
                for (int i = 0; i < length; ++i) {
                    msg.append("\t" + String.valueOf(e.getStackTrace()[i]) + "\n");
                }
            } else {
                msg.append(message);
            }
        }
        return msg.toString();
    }

    @Log(title="\u5e74\u5ea6\u8ba1\u5212\u8ba1\u5212\u9636\u6bb5\u5df2\u5b8c\u6210\u6e05\u5355\u5bfc\u51fa", type=24)
    @RequestMapping(value={"exportPlanCompleteList"})
    public void exportPlanCompleteList(HttpServletResponse response) throws Exception {
        String[] colums = new String[]{"\u5e8f\u53f7|id", "\u5e74\u4efd|scheduleYear", "\u8ba1\u5212\u540d\u79f0|planName", "\u7f16\u5236\u4eba|staffName", "\u5b8c\u6210\u65f6\u95f4|planContent"};
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String fileName = "\u5e74\u5ea6\u8ba1\u5212\u8ba1\u5212\u9636\u6bb5\u5df2\u5b8c\u6210\u6e05\u5355" + dateFormat.format(new Date()) + ".xls";
        response.setHeader("Content-Disposition", "attachment;filename=" + new String(fileName.getBytes("GBK"), "ISO8859_1"));
        response.setContentType("application/octet-stream; charset=GBK");
        Long cid = UserUtils.getLoginStaffCompanyId();
        List list = this.planYearServiceImpl.exportPlanCompleteList(cid);
        for (int i = 0; i < list.size(); ++i) {
            PlanYear y = (PlanYear)list.get(i);
            y.setId(Long.valueOf((long)i + 1L));
            y.setPlanContent(dateFormat.format(y.getUpdateDate()));
            y.setStaffName(StaffUtil.getStaffFullNameById(y.getCreateBy()));
        }
        ExportExcel excelList = new ExportExcel();
        excelList.simpleExport2(fileName, colums, list, (OutputStream)response.getOutputStream());
    }

    @Log(title="\u5e74\u5ea6\u8ba1\u5212\u603b\u7ed3\u9636\u6bb5\u5df2\u5b8c\u6210\u6e05\u5355\u5bfc\u51fa", type=24)
    @RequestMapping(value={"exportSummaryCompleteList"})
    public void exportSummaryCompleteList(HttpServletResponse response) throws Exception {
        String[] colums = new String[]{"\u5e8f\u53f7|id", "\u5e74\u4efd|scheduleYear", "\u8ba1\u5212\u540d\u79f0|planName", "\u7f16\u5236\u4eba|staffName", "\u5b8c\u6210\u65f6\u95f4|planContent"};
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String fileName = "\u5e74\u5ea6\u8ba1\u5212\u603b\u7ed3\u9636\u6bb5\u5df2\u5b8c\u6210\u6e05\u5355" + dateFormat.format(new Date()) + ".xls";
        response.setHeader("Content-Disposition", "attachment;filename=" + new String(fileName.getBytes("GBK"), "ISO8859_1"));
        response.setContentType("application/octet-stream; charset=GBK");
        Long cid = UserUtils.getLoginStaffCompanyId();
        List list = this.planYearServiceImpl.exportSummaryCompleteList(cid);
        for (int i = 0; i < list.size(); ++i) {
            PlanYear y = (PlanYear)list.get(i);
            y.setId(Long.valueOf((long)i + 1L));
            y.setPlanContent(dateFormat.format(y.getUpdateDate()));
            y.setStaffName(StaffUtil.getStaffFullNameById(y.getCreateBy()));
        }
        ExportExcel excelList = new ExportExcel();
        excelList.simpleExport2(fileName, colums, list, (OutputStream)response.getOutputStream());
    }

    @Log(title="\u65b0\u589e\u5e74\u5ea6\u8ba1\u5212", type=20)
    @RequestMapping(value={"addEveryYearPlan"}, method={RequestMethod.GET})
    public String addEveryYearPlan(ModelMap m) {
        m.put((Object)"years", (Object)DateUtils.getNowYearsByOffsets((Integer)2));
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long orgId = UserUtils.getOrgId();
        m.put((Object)"py", (Object)this.planYearServiceImpl.addIsNotValidPlanYear(cid, UserUtils.getLoginStaffId(), orgId));
        return "work/planyear/addEveryYearPlan";
    }

    @Log(title="\u5f85\u5206\u89e3\u7684\u5de5\u4f5c\u8ba1\u5212", type=2)
    @RequestMapping(value={"needDecomposePlanWorkList"}, method={RequestMethod.GET})
    public String needDecomposePlanWorkList(ModelMap m) {
        return "work/planyear/needDecomposePlanWorkList";
    }

    @Log(title="\u5f85\u5206\u89e3\u7684\u5de5\u4f5c\u8ba1\u5212", type=2)
    @RequestMapping(value={"needDecomposePlanWorkSummaryList"}, method={RequestMethod.GET})
    public String needDecomposePlanWorkSummaryList(ModelMap m) {
        return "work/planyear/needDecomposePlanWorkSummaryList";
    }

    @Log(title="\u5f85\u5206\u89e3\u7684\u5de5\u4f5c\u8ba1\u5212", type=2)
    @ResponseBody
    @RequestMapping(value={"needDecomposePlanWorkListData"})
    public JqGridData<PlanYearDetail> needDecomposePlanWorkListData(SearchParamVo search, JqGridParam gparam) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        search.setCid(cid);
        search.setLoginStaffId(UserUtils.getLoginStaffId());
        UserUtils.startWebDataScope();
        PageInfo list = this.planYearDetailServiceImpl.needDecomposePlanWorkParentListDataPage(gparam, search);
        return new JqGridData(list, gparam);
    }

    @Log(title="\u5e74\u5ea6\u5de5\u4f5c\u8ba1\u5212\u7f16\u8f91", type=20)
    @RequestMapping(value={"editEveryYearPlan"}, method={RequestMethod.GET})
    public String editEveryYearPlan(ModelMap m, Long id) {
        m.put((Object)"years", (Object)DateUtils.getNowYearsByOffsets((Integer)2));
        PlanYear py = this.planYearServiceImpl.getPlanYearById(id);
        m.put((Object)"py", (Object)py);
        return "work/planyear/editEveryYearPlan";
    }

    @Log(title="\u5e74\u5ea6\u5de5\u4f5c\u8ba1\u5212\u67e5\u770b", type=2)
    @RequestMapping(value={"viewEveryYearPlan"}, method={RequestMethod.GET})
    public String viewEveryYearPlan(ModelMap m, Long id) {
        m.put((Object)"years", (Object)DateUtils.getNowYearsByOffsets((Integer)2));
        PlanYear py = this.planYearServiceImpl.getPlanYearById(id);
        m.put((Object)"py", (Object)py);
        return "work/planyear/viewEveryYearPlan";
    }

    @Log(title="\u603b\u7ed3\u5f85\u5b8c\u6210\u53d8\u66f4", type=2)
    @RequestMapping(value={"changeEveryYearPlan"}, method={RequestMethod.GET})
    public String changeEveryYearPlan(ModelMap m, Long id) {
        m.put((Object)"years", (Object)DateUtils.getNowYearsByOffsets((Integer)2));
        PlanYear py = (PlanYear)this.planYearServiceImpl.getById(id);
        m.put((Object)"py", (Object)py);
        return "work/planyear/changeEveryYearPlan";
    }

    @Log(title="\u66f4\u65b0\u5e74\u5ea6\u8ba1\u5212", type=21)
    @ResponseBody
    @RequestMapping(value={"updatePlanYearSubmitById"})
    public ResponseData<String> updatePlanYearSubmitById(PlanYear planYear) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long orgId = UserUtils.getOrgId();
        planYear.setIsValid(Boolean.valueOf(true));
        if (planYear.getStage() != null && planYear.getStage() == 2) {
            planYear.setPlanCompleteTime(new Date());
        }
        if (planYear.getStage() != null && planYear.getStage() == 3) {
            planYear.setSummaryCompleteTime(new Date());
        }
        int row = this.planYearServiceImpl.updatePlanYearSubmitById(planYear, cid, loginStaffId);
        if (StringUtils.isEmpty((CharSequence)planYear.getOrgId())) {
            planYear.setOrgId("" + orgId);
        }
        if (row == 1 && planYear.getStage() != null && planYear.getStage() == 2) {
            SyncBusinessUtil.syncBusinessWorkByPlanYear(planYear);
        }
        if (planYear.getId() != null && planYear.getStage() != null && planYear.getStage() == 2) {
            List needDecomposeDetails = this.planYearDetailServiceImpl.getNeedDecomposeListByPlanYearId(planYear.getId());
            for (PlanYearDetail pyd : needDecomposeDetails) {
                this.planYearServiceImpl.createDecomposePlanYearByParentIdAndType(planYear.getId(), pyd.getId(), Byte.valueOf((byte)1), Byte.valueOf((byte)1), cid, loginStaffId);
            }
            List needDecomposeExpends = this.planYearExpendServiceImpl.getNeedDecomposeListByPlanYearId(planYear.getId());
            for (PlanYearExpend pye : needDecomposeExpends) {
                this.planYearServiceImpl.createDecomposePlanYearByParentIdAndType(planYear.getId(), pye.getId(), Byte.valueOf((byte)1), Byte.valueOf((byte)2), cid, loginStaffId);
            }
        }
        return new ResponseData();
    }

    @Log(title="\u5220\u9664\u5e74\u5ea6\u8ba1\u5212", type=22)
    @ResponseBody
    @RequestMapping(value={"deleteEveryYearPlan"})
    public ResponseData<String> deleteEveryYearPlan(Long id) {
        Long loginStaffId = UserUtils.getLoginStaffId();
        this.planYearServiceImpl.deleteEveryYearPlanSubmitById(id, loginStaffId);
        return new ResponseData();
    }

    @Log(title="\u7f16\u8f91\u5e74\u5ea6\u8ba1\u5212", type=21)
    @RequestMapping(value={"editEveryYearPlanSummary"})
    public String editEveryYearPlanSummary(ModelMap m, Long id) {
        m.put((Object)"years", (Object)DateUtils.getNowYearsByOffsets((Integer)2));
        PlanYear py = this.planYearServiceImpl.getPlanYearById(id);
        m.put((Object)"py", (Object)py);
        return "work/planyear/editEveryYearPlanSummary";
    }

    @Log(title="\u67e5\u770b\u5e74\u5ea6\u8ba1\u5212", type=2)
    @RequestMapping(value={"viewEveryYearPlanSummary"})
    public String viewEveryYearPlanSummary(ModelMap m, Long id) {
        m.put((Object)"years", (Object)DateUtils.getNowYearsByOffsets((Integer)2));
        PlanYear py = this.planYearServiceImpl.getPlanYearById(id);
        m.put((Object)"py", (Object)py);
        return "work/planyear/viewEveryYearPlanSummary";
    }

    @Log(title="\u5e74\u5ea6\u8ba1\u5212\u5b9e\u65bd\u65b9\u6848", type=2)
    @ResponseBody
    @RequestMapping(value={"planYearDetailListData"})
    public JqGridData<PlanYearDetail> planYearDetailListData(Long id, String detailIds, JqGridParam param) {
        this.logger.info(param.toString());
        List list = this.planYearDetailServiceImpl.getPlanYearDetailListByGridParam(param);
        PageInfo pageInfo = new PageInfo(list);
        JqGridData data = new JqGridData(pageInfo, param);
        return data;
    }

    @Log(title="\u5e74\u5ea6\u8ba1\u5212\u7ecf\u8d39\u9884\u7b97", type=2)
    @ResponseBody
    @RequestMapping(value={"planYearExpendListData"})
    public JqGridData<PlanYearExpend> planYearExpendListData(Long id, JqGridParam param) {
        this.logger.info(param.toString());
        param.setId(id);
        List list = this.planYearExpendServiceImpl.getPlanYearExpendListByGridParam(param);
        PageInfo pageInfo = new PageInfo(list);
        JqGridData data = new JqGridData(pageInfo, param);
        return data;
    }

    @Log(title="\u5e74\u5ea6\u8ba1\u5212\u5b9e\u65bd\u65b9\u6848\u6dfb\u52a0", type=20)
    @RequestMapping(value={"addPlanWorkDetail"}, method={RequestMethod.GET})
    public String addPlanWorkDetail(Long planId, ModelMap m) {
        m.put((Object)"planId", (Object)planId);
        return "work/planyear/addPlanWorkDetail";
    }

    @Log(title="\u5e74\u5ea6\u8ba1\u5212\u5b9e\u65bd\u65b9\u6848\u7f16\u8f91", type=21)
    @RequestMapping(value={"editPlanWorkDetail"}, method={RequestMethod.GET})
    public String editPlanWorkDetail(Long id, ModelMap m) {
        PlanYearDetail planYearDetail = this.planYearDetailServiceImpl.getPlanYearDetailById(id);
        m.put((Object)"pyd", (Object)planYearDetail);
        return "work/planyear/editPlanWorkDetail";
    }

    @Log(title="\u5e74\u5ea6\u8ba1\u5212\u5b9e\u65bd\u65b9\u6848\u7f16\u8f91\u53d8\u66f4", type=21)
    @RequestMapping(value={"editPlanWorkDetailChange"}, method={RequestMethod.GET})
    public String editPlanWorkDetailChange(Long id, ModelMap m) {
        PlanYearDetail planYearDetail = this.planYearDetailServiceImpl.getPlanYearDetailById(id);
        m.put((Object)"pyd", (Object)planYearDetail);
        return "work/planyear/editPlanWorkDetailChange";
    }

    @Log(title="\u5e74\u5ea6\u8ba1\u5212\u5b9e\u65bd\u65b9\u6848\u6dfb\u52a0", type=20)
    @ResponseBody
    @RequestMapping(value={"addPlanWorkDetailSubmit"})
    public ResponseData<String> addPlanWorkDetailSubmit(PlanYearDetail planYearDetail) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long loginStaffId = UserUtils.getLoginStaffId();
        this.planYearDetailServiceImpl.addPlanWorkDetailSubmit(planYearDetail, loginStaffId, cid);
        return new ResponseData();
    }

    @Log(title="\u5e74\u5ea6\u8ba1\u5212\u5b9e\u65bd\u65b9\u6848\u66f4\u65b0", type=21)
    @ResponseBody
    @RequestMapping(value={"updatePlanWorkDetailSubmit"})
    public ResponseData<String> updatePlanWorkDetailSubmit(PlanYearDetail planYearDetail) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long loginStaffId = UserUtils.getLoginStaffId();
        planYearDetail.setCid(cid);
        this.planYearDetailServiceImpl.updatePlanWorkDetailSubmit(planYearDetail, loginStaffId);
        return new ResponseData();
    }

    @Log(title="\u5e74\u5ea6\u8ba1\u5212\u5b9e\u65bd\u65b9\u6848\u5220\u9664", type=22)
    @ResponseBody
    @RequestMapping(value={"deletePlanWorkDetailSubmit"})
    public ResponseData<String> deletePlanWorkDetailSubmit(Long id, Long planId, Byte dataStatus) {
        Long loginStaffId = UserUtils.getLoginStaffId();
        this.planYearDetailServiceImpl.deletePlanWorkDetailSubmit(id, planId, Byte.valueOf((byte)1), loginStaffId, dataStatus);
        return new ResponseData();
    }

    @Log(title="\u5e74\u5ea6\u8ba1\u5212\u7ecf\u8d39\u9884\u7b97\u6dfb\u52a0", type=20)
    @RequestMapping(value={"addPlanWorkExpend"}, method={RequestMethod.GET})
    public String addPlanWorkExpend(Long planId, ModelMap m) {
        m.put((Object)"planId", (Object)planId);
        return "work/planyear/addPlanWorkExpend";
    }

    @Log(title="\u5e74\u5ea6\u8ba1\u5212\u7ecf\u8d39\u9884\u7b97\u7f16\u8f91", type=21)
    @RequestMapping(value={"editPlanWorkExpend"}, method={RequestMethod.GET})
    public String editPlanWorkExpend(Long id, ModelMap m) {
        m.put((Object)"planId", (Object)id);
        PlanYearExpend planYearExpend = this.planYearExpendServiceImpl.getPlanWorkExpendById(id);
        m.put((Object)"pye", (Object)planYearExpend);
        return "work/planyear/editPlanWorkExpend";
    }

    @Log(title="\u5e74\u5ea6\u8ba1\u5212\u7ecf\u8d39\u9884\u7b97\u7f16\u8f91\u53d8\u66f4", type=21)
    @RequestMapping(value={"editPlanWorkExpendChange"}, method={RequestMethod.GET})
    public String editPlanWorkExpendChange(Long id, ModelMap m) {
        m.put((Object)"planId", (Object)id);
        PlanYearExpend planYearExpend = this.planYearExpendServiceImpl.getPlanWorkExpendById(id);
        m.put((Object)"pye", (Object)planYearExpend);
        return "work/planyear/editPlanWorkExpendChange";
    }

    @Log(title="\u5e74\u5ea6\u8ba1\u5212\u7ecf\u8d39\u9884\u7b97\u6dfb\u52a0", type=20)
    @ResponseBody
    @RequestMapping(value={"addPlanYearExpendSubmit"})
    public ResponseData<String> addPlanYearExpendSubmit(PlanYearExpend planYearExpend) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long loginStaffId = UserUtils.getLoginStaffId();
        this.planYearExpendServiceImpl.addPlanYearExpendSubmit(planYearExpend, loginStaffId, cid);
        return new ResponseData();
    }

    @Log(title="\u5e74\u5ea6\u8ba1\u5212\u7ecf\u8d39\u9884\u7b97\u66f4\u65b0", type=21)
    @ResponseBody
    @RequestMapping(value={"updatePlanYearExpendSubmit"})
    public ResponseData<String> updatePlanYearExpendSubmit(PlanYearExpend planYearExpend) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long loginStaffId = UserUtils.getLoginStaffId();
        planYearExpend.setCid(cid);
        this.planYearExpendServiceImpl.updatePlanYearExpendSubmit(planYearExpend, loginStaffId);
        return new ResponseData();
    }

    @Log(title="\u5e74\u5ea6\u8ba1\u5212\u7ecf\u8d39\u9884\u7b97\u5220\u9664", type=22)
    @ResponseBody
    @RequestMapping(value={"deletePlanYearExpendSubmit"})
    public ResponseData<String> deletePlanYearExpendSubmit(Long id, Long planId, Byte dataStatus) {
        Long loginStaffId = UserUtils.getLoginStaffId();
        this.planYearExpendServiceImpl.deletePlanYearExpendSubmit(id, planId, (byte)2, loginStaffId, dataStatus);
        return new ResponseData();
    }

    @Log(title="\u5e74\u5ea6\u8ba1\u5212\u5b9e\u65bd\u65b9\u6848\u7f16\u8f91", type=21)
    @RequestMapping(value={"editPlanWorkDetailSummary"}, method={RequestMethod.GET})
    public String editPlanWorkDetailSummary(Long id, ModelMap m) {
        PlanYearDetail planYearDetail = this.planYearDetailServiceImpl.getPlanYearDetailById(id);
        m.put((Object)"planYearDetail", (Object)planYearDetail);
        return "work/planyear/editPlanWorkDetailSummary";
    }

    @Log(title="\u5e74\u5ea6\u8ba1\u5212\u5b9e\u65bd\u65b9\u6848\u7f16\u8f91", type=21)
    @ResponseBody
    @RequestMapping(value={"editPlanWorkDetailSummarySubmit"})
    public ResponseData<String> editPlanWorkDetailSummarySubmit(PlanYearDetail planYearDetail) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long loginStaffId = UserUtils.getLoginStaffId();
        planYearDetail.setCid(cid);
        this.planYearDetailServiceImpl.editPlanWorkDetailSummarySubmit(planYearDetail, loginStaffId);
        return new ResponseData();
    }

    @Log(title="\u5e74\u5ea6\u8ba1\u5212\u7ecf\u8d39\u9884\u7b97\u7f16\u8f91", type=21)
    @ResponseBody
    @RequestMapping(value={"updatePlanYearExpendSummarySubmit"})
    public ResponseData<String> updatePlanYearExpendSummarySubmit(PlanYearExpend planYearExpend) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long loginStaffId = UserUtils.getLoginStaffId();
        planYearExpend.setCid(cid);
        this.planYearExpendServiceImpl.updatePlanYearExpendSummarySubmit(planYearExpend, loginStaffId);
        return new ResponseData();
    }

    @Log(title="\u5e74\u5ea6\u8ba1\u5212\u7ecf\u8d39\u9884\u7b97\u7f16\u8f91", type=21)
    @RequestMapping(value={"editPlanWorkExpendSummary"}, method={RequestMethod.GET})
    public String editPlanWorkExpendSummary(Long id, ModelMap m) {
        m.put((Object)"planId", (Object)id);
        PlanYearExpend planYearExpend = this.planYearExpendServiceImpl.getPlanWorkExpendById(id);
        m.put((Object)"pye", (Object)planYearExpend);
        return "work/planyear/editPlanWorkExpendSummary";
    }

    @Log(title="\u5f85\u5206\u89e3\u7684\u804c\u4e1a\u75c5\u9632\u6cbb\u5e74\u5ea6\u7ecf\u8d39\u8ba1\u5212", type=2)
    @RequestMapping(value={"needDecomposePlanExpendList"}, method={RequestMethod.GET})
    public String needDecomposePlanExpendList(ModelMap m) {
        return "work/planyear/needDecomposePlanExpendList";
    }

    @Log(title="\u5f85\u5206\u89e3\u7684\u804c\u4e1a\u75c5\u9632\u6cbb\u5e74\u5ea6\u7ecf\u8d39\u8ba1\u5212", type=2)
    @ResponseBody
    @RequestMapping(value={"needDecomposePlanExpendParentListData"})
    public JqGridData<PlanYearExpend> needDecomposePlanExpendParentListData(SearchParamVo search, JqGridParam gparam) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        search.setCid(cid);
        UserUtils.startWebDataScope();
        PageInfo list = this.planYearExpendServiceImpl.needDecomposePlanExpendParentListDataPage(gparam, search);
        return new JqGridData(list, gparam);
    }

    @Log(title="\u5f85\u5206\u89e3\u5de5\u4f5c\u8ba1\u5212\u7f16\u8f91", type=21)
    @RequestMapping(value={"editNeedDecomposePlanWork"}, method={RequestMethod.GET})
    public String editNeedDecomposePlanWork(ModelMap m, Long id) {
        PlanYearDetail pyd = this.planYearDetailServiceImpl.getNeedDecomposePlanWorkById(id);
        m.put((Object)"pyd", (Object)pyd);
        return "work/planyear/editNeedDecomposePlanWork";
    }

    @Log(title="\u5f85\u5206\u89e3\u5de5\u4f5c\u8ba1\u5212\u7f16\u8f91", type=21)
    @ResponseBody
    @RequestMapping(value={"editNeedDecomposePlanWorkSubmit"})
    public ResponseData<String> editNeedDecomposePlanWorkSubmit(PlanYearDetail planYearDetail) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long loginStaffId = UserUtils.getLoginStaffId();
        planYearDetail.setCid(cid);
        if (planYearDetail.getSelfPlan() != null && planYearDetail.getSelfPlan().getId() != null && planYearDetail.getSelfPlan().getStage() == 2) {
            planYearDetail.getSelfPlan().setPlanCompleteTime(new Date());
        }
        this.planYearDetailServiceImpl.editNeedDecomposePlanWorkSubmit(planYearDetail, loginStaffId);
        if (planYearDetail.getSelfPlan() != null && planYearDetail.getSelfPlan().getId() != null && planYearDetail.getSelfPlan().getStage() == 2) {
            SyncBusinessUtil.syncBusinessWorkByPlanYear(planYearDetail.getSelfPlan());
        }
        return new ResponseData();
    }

    @Log(title="\u5f85\u5206\u89e3\u5de5\u4f5c\u8ba1\u5212\u67e5\u770b", type=2)
    @RequestMapping(value={"viewNeedDecomposePlanWork"}, method={RequestMethod.GET})
    public String viewNeedDecomposePlanWork(ModelMap m, Long id) {
        PlanYearDetail pyd = this.planYearDetailServiceImpl.getNeedDecomposePlanWorkById(id);
        m.put((Object)"pyd", (Object)pyd);
        return "work/planyear/viewNeedDecomposePlanWork";
    }

    @Log(title="\u5206\u89e3\u603b\u7ed3\u7f16\u8f91", type=21)
    @RequestMapping(value={"editNeedDecomposePlanWorkSummary"}, method={RequestMethod.GET})
    public String editNeedDecomposePlanWorkSummary(ModelMap m, Long id) {
        PlanYearDetail pyd = this.planYearDetailServiceImpl.getNeedDecomposePlanWorkById(id);
        if (pyd.getImplStartDate() == null) {
            pyd.setImplStartDate(pyd.getPlanImplDate());
        }
        if (pyd.getImplEndDate() == null) {
            pyd.setImplEndDate(pyd.getPlanImplDateEnd());
        }
        if (StringUtils.isEmpty((CharSequence)pyd.getImplDateStr())) {
            pyd.setImplDateStr(pyd.getPlanImplDateStr());
        }
        m.put((Object)"pyd", (Object)pyd);
        return "work/planyear/editNeedDecomposePlanWorkSummary";
    }

    @Log(title="\u5206\u89e3\u603b\u7ed3\u7f16\u8f91\u63d0\u4ea4", type=21)
    @ResponseBody
    @RequestMapping(value={"editNeedDecomposePlanWorkSummarySubmit"})
    public ResponseData<String> editNeedDecomposePlanWorkSummarySubmit(PlanYearDetail planYearDetail) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long loginStaffId = UserUtils.getLoginStaffId();
        planYearDetail.setCid(cid);
        planYearDetail.getSelfPlan().setSummaryCompleteTime(new Date());
        this.planYearDetailServiceImpl.editNeedDecomposePlanWorkSubmit(planYearDetail, loginStaffId);
        return new ResponseData();
    }

    @Log(title="\u5206\u89e3\u603b\u7ed3\u7f16\u8f91\u67e5\u770b", type=2)
    @RequestMapping(value={"viewNeedDecomposePlanWorkSummary"}, method={RequestMethod.GET})
    public String viewNeedDecomposePlanWorkSummary(ModelMap m, Long id) {
        PlanYearDetail pyd = this.planYearDetailServiceImpl.getNeedDecomposePlanWorkById(id);
        m.put((Object)"pyd", (Object)pyd);
        return "work/planyear/viewNeedDecomposePlanWorkSummary";
    }

    @Log(title="\u5206\u89e3\u7ecf\u8d39\u7f16\u8f91", type=21)
    @RequestMapping(value={"editNeedDecomposePlanExpend"}, method={RequestMethod.GET})
    public String editNeedDecomposePlanExpend(ModelMap m, Long id) {
        PlanYearExpend pye = this.planYearExpendServiceImpl.getNeedDecomposePlanExpendById(id);
        m.put((Object)"pye", (Object)pye);
        return "work/planyear/editNeedDecomposePlanExpend";
    }

    @Log(title="\u5206\u89e3\u7ecf\u8d39\u67e5\u770b", type=2)
    @RequestMapping(value={"viewNeedDecomposePlanExpend"}, method={RequestMethod.GET})
    public String viewNeedDecomposePlanExpend(ModelMap m, Long id) {
        PlanYearExpend pye = this.planYearExpendServiceImpl.getNeedDecomposePlanExpendById(id);
        m.put((Object)"pye", (Object)pye);
        return "work/planyear/viewNeedDecomposePlanExpend";
    }

    @Log(title="\u5206\u89e3\u7ecf\u8d39\u7f16\u8f91", type=21)
    @ResponseBody
    @RequestMapping(value={"editNeedDecomposePlanExpendSubmit"})
    public ResponseData<String> editNeedDecomposePlanExpendSubmit(PlanYearExpend planYearExpend) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long loginStaffId = UserUtils.getLoginStaffId();
        planYearExpend.setCid(cid);
        this.planYearExpendServiceImpl.editNeedDecomposePlanExpendSubmit(planYearExpend, loginStaffId);
        return new ResponseData();
    }

    @Log(title="\u5b9e\u65bd\u65b9\u6848\u5df2\u5b8c\u6210", type=2)
    @RequestMapping(value={"planYearDetailCompletedPage"}, method={RequestMethod.GET})
    public String planYearDetailCompletedPage(ModelMap m) {
        return "work/planyear/planYearDetailCompletedPage";
    }

    @Log(title="\u5b9e\u65bd\u65b9\u6848\u603b\u7ed3\u5df2\u5b8c\u6210", type=2)
    @RequestMapping(value={"planYearDetailSummaryCompletedPage"}, method={RequestMethod.GET})
    public String planYearDetailImplStageCompletedPage(ModelMap m) {
        return "work/planyear/planYearDetailSummaryCompletedPage";
    }

    @Log(title="\u5206\u89e3\u8ba1\u5212\u8ba1\u5212\u5df2\u5b8c\u6210", type=2)
    @RequestMapping(value={"decomposePlanWorkCompletedPage"}, method={RequestMethod.GET})
    public String decomposePlanWorkCompletedPage(ModelMap m) {
        return "work/planyear/decomposePlanWorkCompletedPage";
    }

    @Log(title="\u5206\u89e3\u8ba1\u5212\u603b\u7ed3\u5df2\u5b8c\u6210", type=2)
    @RequestMapping(value={"decomposePlanWorkSummaryCompletedPage"}, method={RequestMethod.GET})
    public String decomposePlanWorkSummaryCompletedPage(ModelMap m) {
        return "work/planyear/decomposePlanWorkSummaryCompletedPage";
    }

    @Log(title="\u5206\u89e3\u8ba1\u5212\u603b\u7ed3\u5df2\u5b8c\u6210", type=2)
    @RequestMapping(value={"decomposePlanExpendCompletedPage"}, method={RequestMethod.GET})
    public String decomposePlanExpendCompletedPage(ModelMap m) {
        return "work/planyear/decomposePlanExpendCompletedPage";
    }

    @Log(title="\u5b50\u8ba1\u5212\u5de5\u4f5c\u8ba1\u5212", type=2)
    @RequestMapping(value={"getChildrenPlanWorkDetail"}, method={RequestMethod.GET})
    public String getChildrenPlanWorkDetail(ModelMap m, Long id, Long planId) {
        m.put((Object)"planId", (Object)planId);
        m.put((Object)"detail", this.planYearDetailServiceImpl.getById(id));
        return "work/planyear/getChildrenPlanWorkDetail";
    }

    @Log(title="\u5b50\u8ba1\u5212\u7ecf\u8d39\u9884\u7b97", type=2)
    @RequestMapping(value={"getChildrenPlanWorkExpend"}, method={RequestMethod.GET})
    public String getChildrenPlanWorkExpend(ModelMap m, Long id, Long planId) {
        m.put((Object)"planId", (Object)planId);
        m.put((Object)"pye", this.planYearExpendServiceImpl.getById(id));
        return "work/planyear/getChildrenPlanWorkExpend";
    }

    @Log(title="\u5b50\u8ba1\u5212\u7ecf\u8d39\u9884\u7b97", type=2)
    @ResponseBody
    @RequestMapping(value={"childrenExpendListData"}, method={RequestMethod.GET})
    public JqGridData<PlanYearExpend> childrenExpendListData(Long id, Long planId, JqGridParam param) {
        this.logger.info(param.toString());
        param.setId(id);
        PageInfo pageInfo = this.planYearExpendServiceImpl.getChildrenxpendListDataGridParam(param);
        JqGridData data = new JqGridData(pageInfo, param);
        return data;
    }

    @Log(title="\u5de5\u4f5c\u79fb\u4ea4", type=2)
    @RequestMapping(value={"toPlanWorkTransferRecordPage"}, method={RequestMethod.GET})
    public String toPlanWorkTransferRecordPage(ModelMap m, Long planId, Long id) {
        m.put((Object)"planId", (Object)planId);
        PlanYearDetail pyd = this.planYearDetailServiceImpl.getPlanYearDetailById(id);
        m.put((Object)"pyd", (Object)pyd);
        m.put((Object)"id", (Object)id);
        return "work/planyear/toPlanWorkTransferRecordPage";
    }

    @Log(title="\u5de5\u4f5c\u79fb\u4ea4", type=2)
    @ResponseBody
    @RequestMapping(value={"planWorkTransferRecordListData"}, method={RequestMethod.GET})
    public JqGridData<PlanWorkTransferRecord> planWorkTransferRecordListData(Long id, Long planId, JqGridParam param) {
        this.logger.info(param.toString());
        param.setId(id);
        PageInfo pageInfo = this.planWorkTransferRecordService.getPlanWorkTransferRecordListDataPage(param);
        JqGridData data = new JqGridData(pageInfo, param);
        return data;
    }

    @Log(title="\u6dfb\u52a0\u5de5\u4f5c\u79fb\u4ea4", type=20)
    @ResponseBody
    @RequestMapping(value={"addPlanWorkTransferRecordSubmit"})
    public ResponseData<String> addPlanWorkTransferRecordSubmit(PlanWorkTransferRecord record, Long detailId) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long loginStaffId = UserUtils.getLoginStaffId();
        record.setCid(cid);
        this.planWorkTransferRecordService.addPlanWorkTransferRecord(record, loginStaffId, cid, detailId);
        return new ResponseData();
    }

    @ResponseBody
    @RequestMapping(value={"planStageCompletedListData"})
    public JqGridData<PlanYear> planStageCompletedListData(JqGridParam param) {
        this.logger.info(param.toString());
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffid = UserUtils.getLoginStaffId();
        param.setCid(cid);
        UserUtils.startWebDataScope();
        PageInfo pageInfo = this.planYearServiceImpl.getPlanYearPlanCompletedListByGridParam(param);
        JqGridData data = new JqGridData(pageInfo, param);
        return data;
    }

    @Log(title="\u8ba1\u5212\u7ecf\u8d39\u9884\u7b97\u7edf\u8ba1\u53d8\u66f4", type=2)
    @RequestMapping(value={"statisticPlanExpend"})
    public String statisticPlanExpend(ModelMap m) {
        m.put((Object)"years", (Object)DateUtils.getNowYearsByOffsets((Integer)2));
        return "work/planyear/statisticPlanExpend";
    }

    @Log(title="\u8ba1\u5212\u7ecf\u8d39\u9884\u7b97\u7edf\u8ba1\u53d8\u66f4", type=2)
    @RequestMapping(value={"statisticPlanExpendMap"})
    public String statisticPlanExpendMap(ModelMap m, SearchParamVo vo) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        vo.setCid(cid);
        List list = this.planYearExpendServiceImpl.getStaticPlanExpend(vo);
        Object map1Str = "";
        Object map2Str = "";
        for (int i = 0; i < list.size(); ++i) {
            map1Str = (String)map1Str + "[\"" + ((PlanExpendStaticVo)list.get(i)).getTypeName() + "\"," + String.valueOf(((PlanExpendStaticVo)list.get(i)).getBudgetMoney()) + "],";
            map2Str = (String)map2Str + "[\"" + ((PlanExpendStaticVo)list.get(i)).getTypeName() + "\"," + String.valueOf(((PlanExpendStaticVo)list.get(i)).getActualMoney()) + "],";
        }
        m.put((Object)"map1Str", map1Str);
        m.put((Object)"map2Str", map2Str);
        return "work/planyear/statisticPlanExpendMap";
    }

    @Log(title="\u8ba1\u5212\u7ecf\u8d39\u9884\u7b97\u7edf\u8ba1\u53d8\u66f4", type=2)
    @ResponseBody
    @RequestMapping(value={"statisticPlanExpendListData"})
    public JqGridData<PlanExpendStaticVo> statisticPlanExpendListData(JqGridParam param, SearchParamVo vo) {
        this.logger.info(param.toString());
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        PageInfo pageInfo = this.planYearExpendServiceImpl.statisticPlanExpendListData(param, vo);
        JqGridData data = new JqGridData(pageInfo, param);
        return data;
    }

    @Log(title="\u8ba1\u5212\u7edf\u8ba1\u53d8\u66f4", type=2)
    @RequestMapping(value={"statisticPlanWork"})
    public String statisticPlanWork(ModelMap m) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        m.put((Object)"years", (Object)DateUtils.getNowYearsByOffsets((Integer)2));
        m.put((Object)"count", (Object)this.planYearDetailServiceImpl.getPlanCountByCid(cid));
        m.put((Object)"stag23Count", (Object)this.planYearDetailServiceImpl.getPlanCompletedStageCountByCid(cid));
        m.put((Object)"stag3Count", (Object)this.planYearDetailServiceImpl.getPlanSummaryCompletedStageCountByCid(cid));
        return "work/planyear/statisticPlanWork";
    }

    @Log(title="\u8ba1\u5212\u7edf\u8ba1\u53d8\u66f4", type=2)
    @ResponseBody
    @RequestMapping(value={"statisticPlanDetailListData"})
    public JqGridData<PlanYearDetail> statisticPlanDetailListData(JqGridParam param, SearchParamVo vo) {
        this.logger.info(param.toString());
        Long cid = UserUtils.getLoginStaffCompanyId();
        vo.setCid(cid);
        UserUtils.startWebDataScope();
        PageInfo pageInfo = this.planYearDetailServiceImpl.statisticPlanDetailListData(param, vo);
        JqGridData data = new JqGridData(pageInfo, param);
        return data;
    }

    @Log(title="\u8ba1\u5212\u5f85\u603b\u7ed3\u53d8\u66f4\u53d8\u66f4", type=2)
    @ResponseBody
    @RequestMapping(value={"updateChangePlanYearSubmitById"})
    public ResponseData<String> updateChangePlanYearSubmitById(PlanYear planYear) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long loginStaffId = UserUtils.getLoginStaffId();
        planYear.setIsValid(Boolean.valueOf(true));
        this.planYearServiceImpl.updatePlanYearSubmitById(planYear, cid, loginStaffId);
        Long orgId = UserUtils.getOrgId();
        if (planYear.getId() != null && planYear.getChangeStatus() == 2) {
            List needDecomposeDetails = this.planYearDetailServiceImpl.getChangeNeedDecomposeListByPlanYearId(planYear.getId());
            for (PlanYearDetail pyd : needDecomposeDetails) {
                this.planYearServiceImpl.createDecomposePlanYearByParentIdAndType(planYear.getId(), pyd.getId(), Byte.valueOf((byte)1), Byte.valueOf((byte)1), cid, loginStaffId);
            }
            List needDecomposeExpends = this.planYearExpendServiceImpl.getChangeNeedDecomposeListByPlanYearId(planYear.getId());
            for (PlanYearExpend pye : needDecomposeExpends) {
                this.planYearServiceImpl.createDecomposePlanYearByParentIdAndType(planYear.getId(), pye.getId(), Byte.valueOf((byte)1), Byte.valueOf((byte)2), cid, loginStaffId);
            }
        }
        return new ResponseData();
    }

    @RequestMapping(value={"viewPlanYearSummaryCompleted"})
    public String viewPlanYearSummaryCompleted(Long id, String tab, ModelMap m) {
        PlanYear py = this.planYearServiceImpl.getPlanYearById(id);
        m.put((Object)"py", (Object)py);
        if ("plan".equals(tab)) {
            return "work/planyear/viewPlanYearSummaryCompletedPlan";
        }
        if ("change".equals(tab)) {
            return "work/planyear/viewPlanYearSummaryCompletedChange";
        }
        return "work/planyear/viewPlanYearSummaryCompleted";
    }

    @Log(title="\u8ba1\u5212\u7ecf\u8d39\u9884\u7b97\u53d8\u66f4", type=2)
    @ResponseBody
    @RequestMapping(value={"planYearDetailListDataChange"})
    public JqGridData<PlanYearDetail> planYearDetailListDataChange(Long id, String detailIds, JqGridParam param) {
        this.logger.info(param.toString());
        List list = this.planYearDetailServiceImpl.getPlanYearDetailListChangeByGridParam(param);
        PageInfo pageInfo = new PageInfo(list);
        JqGridData data = new JqGridData(pageInfo, param);
        return data;
    }

    @Log(title="\u8ba1\u5212\u7ecf\u8d39\u9884\u7b97\u53d8\u66f4", type=2)
    @ResponseBody
    @RequestMapping(value={"planYearExpendListDataChange"})
    public JqGridData<PlanYearExpend> planYearExpendListDataChange(Long id, JqGridParam param) {
        this.logger.info(param.toString());
        param.setId(id);
        List list = this.planYearExpendServiceImpl.getPlanYearExpendListByGridParam(param);
        PageInfo pageInfo = new PageInfo(list);
        JqGridData data = new JqGridData(pageInfo, param);
        return data;
    }

    @Log(title="\u5220\u9664\u5206\u89e3\u8ba1\u5212", type=22)
    @ResponseBody
    @RequestMapping(value={"deleteDecomposePlanByDetailId"})
    public ResponseData<String> deleteDecomposePlanByDetailId(Long id, Long planId) {
        Long loginStaffId = UserUtils.getLoginStaffId();
        this.planYearDetailServiceImpl.deleteDecomposePlanByDetailId(id, planId, loginStaffId);
        return new ResponseData();
    }

    @Log(title="\u8ba1\u5212\u53d1\u9001\u63d0\u9192", type=2)
    @RequestMapping(value={"toSendMessage"}, method={RequestMethod.GET})
    public String toSendMessage(Model model, Long id) {
        this.logger.info("\u53d1\u9001\u63d0\u9192");
        Long staffid = UserUtils.getLoginStaffId();
        PlanYearExpend pye = this.planYearExpendServiceImpl.getPlanWorkExpendById(id);
        model.addAttribute("staffid", (Object)staffid);
        model.addAttribute("pye", (Object)pye);
        return "work/planyear/sendMessage";
    }

    @Log(title="\u8ba1\u5212\u53d1\u9001\u63d0\u9192", type=20)
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"sendMessage"})
    public ResponseData<Integer> sendMessage(Long planId) {
        this.logger.info("\u53d1\u9001\u63d0\u9192");
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffid = UserUtils.getLoginStaffId();
        PlanYearExpend pye = (PlanYearExpend)this.planYearExpendServiceImpl.getById(planId);
        PlanYearExpend ppye = null;
        ResponseData r = new ResponseData();
        try {
            if (pye != null && pye.getExpendPid() != null) {
                ppye = this.planYearExpendServiceImpl.getPlanWorkExpendById(pye.getExpendPid());
            }
            this.sendMes(ppye, staffid, cid);
            r.setContent("\u53d1\u9001\u6210\u529f");
            r.setState(ResponseStateEnum.success);
        }
        catch (Exception e) {
            r.setContent("\u53d1\u9001\u5931\u8d25");
            r.setState(ResponseStateEnum.fail);
        }
        return r;
    }

    private void sendMes(PlanYearExpend detail, Long staffid, Long cid) {
        Message mes = new Message();
        mes.setBussinesId(detail.getId());
        mes.setBussinesType(MessageBusinessTypeEnum.remind.getValue());
        mes.setTypeName(MessageBusinessTypeEnum.remind.getName());
        mes.setBussinesFromType(MessageBusinessFromEnum.workPlan.getValue());
        mes.setBussinesFrom(StaffUtil.getStaffNameOrgByStaffId(staffid));
        mes.setSendTime(new Date());
        mes.setBussinesNo("\u2014\u2014");
        mes.setCreateBy(staffid);
        mes.setUpdateBy(staffid);
        mes.setBussinesName("\u8bf7\u5c3d\u5feb\u5236\u5b9a\u5e74\u5ea6\u7ecf\u8d39\u8ba1\u5212");
        String con = "\u7528\u9014\uff1a" + detail.getTypeName() + "<br />\u8be6\u60c5\uff1a" + detail.getContent() + "<br />\u63d0\u9192\u5185\u5bb9\uff1a\u8bf7\u5c3d\u5feb\u5236\u5b9a\u5e74\u5ea6\u7ecf\u8d39\u8ba1\u5212\uff01<br /><a target=\"_blank\" href=\"{contextPath}/work/planyear/editNeedDecomposePlanExpend?id=" + detail.getId() + "\">\u524d\u5f80\u5de5\u4f5c\u754c\u9762</a>";
        mes.setBussinessContent(con);
        ArrayList<MessageReceiver> receivers = new ArrayList<MessageReceiver>();
        if (detail.getManagerId() != null) {
            MessageReceiver receiver = new MessageReceiver();
            receiver.setReveiver(detail.getManagerId());
            receivers.add(receiver);
        }
        mes.setReceivers(receivers);
        this.messageService.pushMessage(mes, staffid, cid);
    }

    @Log(title="\u8ba1\u5212\u53d1\u9001\u63d0\u9192", type=2)
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"sendMoreMessage"}, method={RequestMethod.POST})
    public ResponseData<Integer> sendMoreMessage(Long planId) {
        this.logger.info("\u53d1\u9001\u63d0\u9192");
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffid = UserUtils.getLoginStaffId();
        List list = this.planYearExpendServiceImpl.getChildrenPlanYearExpendByPid(planId);
        ResponseData r = new ResponseData();
        try {
            if (list != null) {
                for (PlanYearExpend detail : list) {
                    this.sendMes(detail, staffid, cid);
                }
            }
            r.setContent("\u53d1\u9001\u6210\u529f");
            r.setState(ResponseStateEnum.success);
        }
        catch (Exception e) {
            r.setContent("\u53d1\u9001\u5931\u8d25");
            r.setState(ResponseStateEnum.fail);
        }
        return r;
    }

    @Log(title="\u8ba1\u5212\u53d1\u9001\u63d0\u9192", type=2)
    @RequestMapping(value={"oneTouchRemind"}, method={RequestMethod.GET})
    public String oneTouchRemind(Model model, Long id) {
        this.logger.info("\u53d1\u9001\u63d0\u9192");
        Long staffid = UserUtils.getLoginStaffId();
        List list = this.planYearExpendServiceImpl.getChildrenPlanYearExpendByPid(id);
        Object reminder = null;
        if (list != null) {
            for (PlanYearExpend detail : list) {
                if (detail.getSelfPlan() == null || detail.getSelfPlan().getStage() == 2) continue;
                if (reminder == null) {
                    reminder = StaffUtil.getStaffNameOrgByStaffId(detail.getManagerId());
                    continue;
                }
                reminder = (String)reminder + "\u3001" + StaffUtil.getStaffNameOrgByStaffId(detail.getManagerId());
            }
        }
        model.addAttribute("staffid", (Object)staffid);
        model.addAttribute("reminder", reminder);
        return "work/planyear/dailyPlan/oneTouchRemind";
    }

    @Log(title="\u5220\u9664\u5206\u89e3\u8ba1\u5212", type=22)
    @ResponseBody
    @RequestMapping(value={"deleteNeedDecomposePlanExpendByExpendId"})
    public ResponseData<String> deleteNeedDecomposePlanExpendByExpendId(Long id, Long planId) {
        Long loginStaffId = UserUtils.getLoginStaffId();
        this.planYearExpendServiceImpl.deleteDecomposePlanByDetailId(id, planId, loginStaffId);
        return new ResponseData();
    }

    @Log(title="\u5206\u89e3\u8ba1\u5212", type=2)
    @ResponseBody
    @RequestMapping(value={"needDecomposePlanWorkListDataV2102"})
    public JqGridData<NeedDecomposeWorkPlan> needDecomposePlanWorkListDataV2102(SearchParamVo search, JqGridParam gparam) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        search.setCid(cid);
        search.setLoginStaffId(UserUtils.getLoginStaffId());
        UserUtils.startWebDataScope();
        PageInfo list = this.planYearDetailServiceImpl.needDecomposePlanWorkParentListDataV2102Page(gparam, search);
        return new JqGridData(list, gparam);
    }
}

