/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.work.planyear;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.web.repeatform.RepeatUrlFormData;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.entity.sys.message.Message;
import cn.smarthse.modules.health.entity.sys.message.MessageReceiver;
import cn.smarthse.modules.health.entity.work.planyear.PlanYear;
import cn.smarthse.modules.health.entity.work.planyear.PlanYearDetail;
import cn.smarthse.modules.health.entity.work.planyear.PlanYearUploadFile;
import cn.smarthse.modules.health.entity.work.planyear.vo.SearchParamVo;
import cn.smarthse.modules.health.enums.check.CheckTypeEnum;
import cn.smarthse.modules.health.enums.evaluate.EvaluateHseTypeEnum;
import cn.smarthse.modules.health.enums.hccheckplan.HcCheckTypeEnum;
import cn.smarthse.modules.health.enums.planyear.PlanYearDetailTypeEnum;
import cn.smarthse.modules.health.enums.scene.InspectionTypeEnum;
import cn.smarthse.modules.health.enums.sys.MessageBusinessFromEnum;
import cn.smarthse.modules.health.enums.sys.MessageBusinessTypeEnum;
import cn.smarthse.modules.health.enums.train.TrainPlanTypeEnum;
import cn.smarthse.modules.health.service.sys.message.IMessageService;
import cn.smarthse.modules.health.service.work.planyear.IPlanWorkExecutorOrgRecordService;
import cn.smarthse.modules.health.service.work.planyear.IPlanYearDetailService;
import cn.smarthse.modules.health.service.work.planyear.IPlanYearModularsService;
import cn.smarthse.modules.health.service.work.planyear.IPlanYearService;
import cn.smarthse.modules.health.service.work.planyear.IPlanYearUploadFileService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.StaffUtil;
import cn.smarthse.web.util.SyncBusinessUtil;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/work/planyear/daily"})
public class PlanDailyController
extends ControllerSupport {
    @DubboReference
    IPlanYearService planYearServiceImpl;
    @DubboReference
    IPlanYearUploadFileService planYearUploadFileServiceImpl;
    @DubboReference
    IPlanYearDetailService planYearDetailServiceImpl;
    @DubboReference
    IPlanYearModularsService planYearModularsService;
    @DubboReference
    IPlanWorkExecutorOrgRecordService planWorkExecutorOrgRecordService;
    @DubboReference(timeout=5000000)
    ISysFileProvideService sysFileServiceImpl;
    @DubboReference
    IMessageService messageService;

    @Log(title="\u83b7\u53d6\u8fdb\u884c\u4e2d\u65e5\u5e38\u5de5\u4f5c\u8ba1\u5212\u5217\u8868", type=2)
    @RequestMapping(value={"unfilishedPlan"}, method={RequestMethod.GET})
    public String page_planList() {
        this.logger.info("\u5de5\u4f5c\u8ba1\u5212\u300b\u65e5\u5e38\u8ba1\u5212\u8ba1\u5212\u6e05\u5355(\u8fdb\u884c\u4e2d)");
        return "work/planyear/dailyPlan/dailyPlanList";
    }

    @ResponseBody
    @RequestMapping(value={"getUnfilishedList"})
    public JqGridData<PlanYearDetail> getUnfilishedList(JqGridParam param, SearchParamVo vo) {
        this.logger.info(param.toString());
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        vo.setCid(cid);
        vo.setPlanType(Byte.valueOf((byte)2));
        vo.setStage(Byte.valueOf((byte)1));
        vo.setSearchType(Byte.valueOf((byte)1));
        UserUtils.startWebDataScope();
        PageInfo pageInfo = this.planYearDetailServiceImpl.getDailyPlanListByParam(param, vo);
        JqGridData data = new JqGridData(pageInfo, param);
        return data;
    }

    @ResponseBody
    @RequestMapping(value={"getfinishedList"})
    public JqGridData<PlanYearDetail> getfinishedList(JqGridParam param, SearchParamVo vo) {
        this.logger.info(param.toString());
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        vo.setCid(cid);
        vo.setPlanType(Byte.valueOf((byte)2));
        vo.setStage(Byte.valueOf((byte)4));
        vo.setSearchType(Byte.valueOf((byte)1));
        UserUtils.startWebDataScope();
        PageInfo pageInfo = this.planYearDetailServiceImpl.getDailyPlanListByParam(param, vo);
        JqGridData data = new JqGridData(pageInfo, param);
        return data;
    }

    @Log(title="\u83b7\u53d6\u5df2\u5b8c\u6210\u65e5\u5e38\u5de5\u4f5c\u8ba1\u5212\u5217\u8868", type=2)
    @RequestMapping(value={"finishedPlan"}, method={RequestMethod.GET})
    public String filishedPlan() {
        this.logger.info("\u5de5\u4f5c\u8ba1\u5212\u300b\u65e5\u5e38\u8ba1\u5212\u6e05\u5355(\u5df2\u5b8c\u6210)");
        return "work/planyear/dailyPlan/finishedPlanList";
    }

    @Log(title="\u83b7\u53d6\u5f85\u603b\u7ed3\u65e5\u5e38\u5de5\u4f5c\u8ba1\u5212\u5217\u8868", type=2)
    @RequestMapping(value={"summarylist"}, method={RequestMethod.GET})
    public String summarylist() {
        this.logger.info("\u5de5\u4f5c\u8ba1\u5212\u300b\u65e5\u5e38\u8ba1\u5212\u6e05\u5355(\u5f85\u603b\u7ed3)");
        return "work/planyear/dailyPlan/summaryList";
    }

    @ResponseBody
    @RequestMapping(value={"getChildPlanList"})
    public JqGridData<PlanYearDetail> getChildPlanList(JqGridParam param, Long pid) {
        this.logger.info(param.toString());
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        PageInfo pageInfo = this.planYearDetailServiceImpl.getChildrenPlanYearDetailsByPid(param, pid);
        JqGridData data = new JqGridData(pageInfo, param);
        return data;
    }

    @ResponseBody
    @RequestMapping(value={"getSummarylist"})
    public JqGridData<PlanYearDetail> getSummarylist(JqGridParam param, SearchParamVo vo) {
        this.logger.info(param.toString());
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        vo.setCid(cid);
        vo.setPlanType(Byte.valueOf((byte)2));
        vo.setStage(Byte.valueOf((byte)2));
        vo.setSearchType(Byte.valueOf((byte)1));
        UserUtils.startWebDataScope();
        PageInfo pageInfo = this.planYearDetailServiceImpl.getDailySummaryListByParam(param, vo);
        JqGridData data = new JqGridData(pageInfo, param);
        return data;
    }

    @Log(title="\u83b7\u53d6\u603b\u7ed3\u5b8c\u6210\u65e5\u5e38\u5de5\u4f5c\u8ba1\u5212\u5217\u8868", type=2)
    @RequestMapping(value={"finishedSummary"}, method={RequestMethod.GET})
    public String finishedSummary() {
        this.logger.info("\u5de5\u4f5c\u8ba1\u5212\u300b\u65e5\u5e38\u8ba1\u5212\u603b\u7ed3(\u5df2\u5b8c\u6210)");
        return "work/planyear/dailyPlan/finishedSummaryList";
    }

    @ResponseBody
    @RequestMapping(value={"getfinishedSummaryList"})
    public JqGridData<PlanYearDetail> getfinishedSummaryList(JqGridParam param, SearchParamVo vo) {
        this.logger.info(param.toString());
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        vo.setCid(cid);
        vo.setPlanType(Byte.valueOf((byte)2));
        vo.setStage(Byte.valueOf((byte)3));
        vo.setSearchType(Byte.valueOf((byte)2));
        UserUtils.startWebDataScope();
        PageInfo pageInfo = this.planYearDetailServiceImpl.getDailyPlanListByParam(param, vo);
        JqGridData data = new JqGridData(pageInfo, param);
        return data;
    }

    @Log(title="\u65b0\u589e\u65e5\u5e38\u5de5\u4f5c\u8ba1\u5212", type=20)
    @RequestMapping(value={"addPlan"}, method={RequestMethod.GET})
    public String page_AddPlan(Model model) {
        this.logger.info("\u65e5\u5e38\u8ba1\u5212\u300b\u65b0\u589e");
        return "work/planyear/dailyPlan/dailyPlanAdd";
    }

    @Log(title="\u7f16\u8f91\u65e5\u5e38\u5de5\u4f5c\u8ba1\u5212", type=21)
    @RequestMapping(value={"editPlan"}, method={RequestMethod.GET})
    public String page_AddPlan(Model model, Long id) {
        this.logger.info("\u65e5\u5e38\u8ba1\u5212\u300b\u7f16\u8f91");
        PlanYear planYear = (PlanYear)this.planYearServiceImpl.getById(id);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        if (planYear != null) {
            List detList = this.planYearDetailServiceImpl.getListByPlanYearId(id);
            if (detList != null) {
                planYear.setDetail((PlanYearDetail)detList.get(0));
                PlanYearDetail detail = (PlanYearDetail)detList.get(0);
                if (detail.getPlanImplDate() != null) {
                    String planDate = dateFormat.format(detail.getPlanImplDate()) + "\u81f3" + dateFormat.format(detail.getPlanImplDateEnd());
                    detail.setPlanImplDateStr(planDate);
                }
                String managName = StaffUtil.getStaffFullNameById(detail.getManagerId());
                model.addAttribute("managName", (Object)managName);
                if (detail.getId() != null) {
                    List executorList = this.planWorkExecutorOrgRecordService.getListByPlanIdAndPlanDetailOrExpendIdAndType(id, detail.getId(), Byte.valueOf((byte)1));
                    model.addAttribute("executorList", (Object)executorList);
                }
            }
            model.addAttribute("plan", (Object)planYear);
            ArrayList<SysFileModel> fileList = new ArrayList<SysFileModel>();
            Object fileId2 = "";
            List planYearUploadFileList = this.planYearUploadFileServiceImpl.getByPlanYearId(planYear.getId(), Byte.valueOf((byte)1));
            for (PlanYearUploadFile planYearUploadFile : planYearUploadFileList) {
                if (planYearUploadFile.getFileId() == null) continue;
                SysFileModel sysFile = this.sysFileServiceImpl.getFileById(planYearUploadFile.getFileId());
                fileList.add(sysFile);
                fileId2 = (String)fileId2 + sysFile.getId() + ",";
            }
            model.addAttribute("fileId2", fileId2);
            model.addAttribute("fileList", fileList);
        }
        return "work/planyear/dailyPlan/dailyPlanEdit";
    }

    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"planSave"}, method={RequestMethod.POST})
    public ResponseData<PlanYear> ajax_addPlan(PlanYear plan, Long[] fileId2) {
        this.logger.info("ajax-\u65e5\u5e38\u8ba1\u5212\u8ba1\u5212\u300b\u4fdd\u5b58\u65e5\u5e38\u8ba1\u5212");
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffid = UserUtils.getLoginStaffId();
        Long orgId = UserUtils.getOrgId();
        plan.setWorkPlanType(Byte.valueOf((byte)2));
        plan.setPlanCompleteTime(new Date());
        ResponseData r = new ResponseData();
        try {
            if (plan.getId() == null) {
                if (StringUtils.isEmpty((CharSequence)plan.getOrgId())) {
                    plan.setOrgId("" + orgId);
                }
                plan = this.planYearServiceImpl.addPlanDaily(cid, staffid, plan, fileId2);
            } else {
                plan = this.planYearServiceImpl.updatePlanDaily(cid, staffid, plan, fileId2, Byte.valueOf((byte)1));
            }
            if (plan.getStage() == 2) {
                if (plan.getId() == null && StringUtils.isEmpty((CharSequence)plan.getOrgId())) {
                    plan.setOrgId("" + orgId);
                }
                SyncBusinessUtil.syncBusinessWorkByPlanYear(plan);
                if (plan.getDetail().getDecomposeStatus() == 2) {
                    this.planYearServiceImpl.createDecomposePlanYearByParentIdAndType(plan.getId(), plan.getDetail().getId(), Byte.valueOf((byte)2), Byte.valueOf((byte)1), cid, staffid);
                }
            }
            r.setResult((Object)plan);
            r.setContent("\u4fdd\u5b58\u6210\u529f");
            r.setState(ResponseStateEnum.success);
        }
        catch (Exception e) {
            r.setContent("\u4fdd\u5b58\u5931\u8d25");
            r.setState(ResponseStateEnum.fail);
        }
        return r;
    }

    @Log(title="\u67e5\u770b\u65e5\u5e38\u5de5\u4f5c\u8ba1\u5212", type=2)
    @RequestMapping(value={"viewPlan"}, method={RequestMethod.GET})
    public String page_viewPlan(Model model, Long id) {
        this.logger.info("\u65e5\u5e38\u8ba1\u5212\u300b\u67e5\u770b");
        PlanYear planYear = (PlanYear)this.planYearServiceImpl.getById(id);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        if (planYear != null) {
            List detList = this.planYearDetailServiceImpl.getListByPlanYearId(id);
            if (detList != null) {
                planYear.setDetail((PlanYearDetail)detList.get(0));
                PlanYearDetail detail = (PlanYearDetail)detList.get(0);
                if (detail.getPlanImplDate() != null) {
                    String planDate = dateFormat.format(detail.getPlanImplDate()) + "\u81f3" + dateFormat.format(detail.getPlanImplDateEnd());
                    detail.setPlanImplDateStr(planDate);
                }
                String managName = StaffUtil.getStaffFullNameById(detail.getManagerId());
                model.addAttribute("managName", (Object)managName);
                if (detail.getId() != null) {
                    List executorList = this.planWorkExecutorOrgRecordService.getListByPlanIdAndPlanDetailOrExpendIdAndType(id, detail.getId(), Byte.valueOf((byte)1));
                    model.addAttribute("executorList", (Object)executorList);
                }
                if (detail.getBussnissModularId() != null) {
                    String typeName = this.getWorkTypeName(detail.getBussnissModularId().intValue(), detail.getWorkSubtype());
                    model.addAttribute("typeName", (Object)typeName);
                }
            }
            model.addAttribute("plan", (Object)planYear);
            ArrayList<SysFileModel> fileList = new ArrayList<SysFileModel>();
            Object fileId2 = "";
            List planYearUploadFileList = this.planYearUploadFileServiceImpl.getByPlanYearId(planYear.getId(), Byte.valueOf((byte)1));
            for (PlanYearUploadFile planYearUploadFile : planYearUploadFileList) {
                if (planYearUploadFile.getFileId() == null) continue;
                SysFileModel sysFile = this.sysFileServiceImpl.getFileById(planYearUploadFile.getFileId());
                fileList.add(sysFile);
                fileId2 = (String)fileId2 + sysFile.getId() + ",";
            }
            model.addAttribute("fileId2", fileId2);
            model.addAttribute("fileList", fileList);
        }
        return "work/planyear/dailyPlan/dailyPlanView";
    }

    private String getWorkTypeName(int type, String subType) {
        Object typeName = PlanYearDetailTypeEnum.getName((Integer)type);
        if (subType != null && !subType.equals("")) {
            int st = Integer.parseInt(subType);
            switch (type) {
                case 1: {
                    typeName = (String)typeName + "-" + CheckTypeEnum.getName((String)subType);
                    break;
                }
                case 2: {
                    typeName = (String)typeName + "-" + HcCheckTypeEnum.getThisEnumByValue((Long)Long.parseLong(subType)).getName();
                    break;
                }
                case 3: {
                    typeName = (String)typeName + "-" + TrainPlanTypeEnum.getName((Byte)((byte)st));
                    break;
                }
                case 9: {
                    typeName = (String)typeName + "-" + EvaluateHseTypeEnum.getEvaluateTypeName((Byte)((byte)st));
                    break;
                }
                case 6: {
                    typeName = (String)typeName + "-" + InspectionTypeEnum.getNameByValue((Byte)((byte)st));
                    break;
                }
                case 7: {
                    if (1 == st) {
                        typeName = (String)typeName + "-\u5355\u9879\u6f14\u7ec3";
                        break;
                    }
                    typeName = (String)typeName + "-\u7efc\u5408\u6f14\u7ec3";
                    break;
                }
            }
        }
        return typeName;
    }

    @Log(title="\u7f16\u8f91\u65e5\u5e38\u5de5\u4f5c\u8ba1\u5212\u603b\u7ed3", type=21)
    @RequestMapping(value={"editSummary"}, method={RequestMethod.GET})
    public String editSummary(Model model, Long id) {
        this.logger.info("\u65e5\u5e38\u8ba1\u5212\u300b\u603b\u7ed3");
        PlanYear planYear = this.getPlanSummInfo(model, id);
        if (planYear.getDetail().getDecomposeStatus() == 2) {
            return "work/planyear/dailyPlan/editSummaryDecompose";
        }
        return "work/planyear/dailyPlan/editSummary";
    }

    private PlanYear getPlanSummInfo(Model model, Long id) {
        PlanYear planYear = (PlanYear)this.planYearServiceImpl.getById(id);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        if (planYear != null) {
            List detList = this.planYearDetailServiceImpl.getListByPlanYearId(id);
            if (detList != null) {
                planYear.setDetail((PlanYearDetail)detList.get(0));
                PlanYearDetail detail = (PlanYearDetail)detList.get(0);
                if (detail.getPlanImplDate() != null) {
                    String planDate = dateFormat.format(detail.getPlanImplDate()) + "\u81f3" + dateFormat.format(detail.getPlanImplDateEnd());
                    detail.setPlanImplDateStr(planDate);
                }
                if (detail.getImplStartDate() != null) {
                    String implDate = dateFormat.format(detail.getImplStartDate()) + "\u81f3" + dateFormat.format(detail.getImplEndDate());
                    detail.setImplDateStr(implDate);
                }
                String managName = StaffUtil.getStaffFullNameById(detail.getManagerId());
                model.addAttribute("managName", (Object)managName);
                if (detail.getId() != null) {
                    List executorList = this.planWorkExecutorOrgRecordService.getListByPlanIdAndPlanDetailOrExpendIdAndType(id, detail.getId(), Byte.valueOf((byte)1));
                    model.addAttribute("executorList", (Object)executorList);
                }
                if (detail.getBussnissModularId() != null) {
                    String typeName = this.getWorkTypeName(detail.getBussnissModularId().intValue(), detail.getWorkSubtype());
                    model.addAttribute("typeName", (Object)typeName);
                }
            }
            model.addAttribute("plan", (Object)planYear);
            ArrayList<SysFileModel> planFileList = new ArrayList<SysFileModel>();
            Object planFileId = "";
            List planYearUploadFileList = this.planYearUploadFileServiceImpl.getByPlanYearId(planYear.getId(), Byte.valueOf((byte)1));
            for (PlanYearUploadFile planYearUploadFile : planYearUploadFileList) {
                SysFileModel sysFile;
                if (planYearUploadFile.getFileId() == null || (sysFile = this.sysFileServiceImpl.getFileById(planYearUploadFile.getFileId())) == null) continue;
                planFileList.add(sysFile);
                planFileId = (String)planFileId + sysFile.getId() + ",";
            }
            model.addAttribute("planFileId", planFileId);
            model.addAttribute("planFileList", planFileList);
            ArrayList<SysFileModel> summFileList = new ArrayList<SysFileModel>();
            Object summFileId = "";
            List planYearUploadFileList2 = this.planYearUploadFileServiceImpl.getByPlanYearId(planYear.getId(), Byte.valueOf((byte)2));
            for (PlanYearUploadFile planYearUploadFile : planYearUploadFileList2) {
                SysFileModel sysFile;
                if (planYearUploadFile.getFileId() == null || (sysFile = this.sysFileServiceImpl.getFileById(planYearUploadFile.getFileId())) == null) continue;
                summFileList.add(sysFile);
                summFileId = (String)summFileId + sysFile.getId() + ",";
            }
            model.addAttribute("summFileId", summFileId);
            model.addAttribute("summFileList", summFileList);
        }
        return planYear;
    }

    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"summarySave"}, method={RequestMethod.POST})
    public ResponseData<PlanYear> summarySave(PlanYear plan, Long[] summFileId) {
        this.logger.info("ajax-\u65e5\u5e38\u8ba1\u5212\u8ba1\u5212\u300b\u4fdd\u5b58\u65e5\u5e38\u8ba1\u5212\u603b\u7ed3");
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffid = UserUtils.getLoginStaffId();
        plan.setWorkPlanType(Byte.valueOf((byte)2));
        plan.setSummaryCompleteTime(new Date());
        ResponseData r = new ResponseData();
        try {
            plan = this.planYearServiceImpl.updateSummDaily(cid, staffid, plan, summFileId, Byte.valueOf((byte)2));
            r.setResult((Object)plan);
            r.setContent("\u4fdd\u5b58\u6210\u529f");
            r.setState(ResponseStateEnum.success);
        }
        catch (Exception e) {
            r.setContent("\u4fdd\u5b58\u5931\u8d25");
            r.setState(ResponseStateEnum.fail);
        }
        return r;
    }

    @Log(title="\u67e5\u770b\u65e5\u5e38\u5de5\u4f5c\u8ba1\u5212\u603b\u7ed3", type=2)
    @RequestMapping(value={"viewSummary"}, method={RequestMethod.GET})
    public String viewSummary(Model model, Long id) {
        this.logger.info("\u65e5\u5e38\u8ba1\u5212\u300b\u603b\u7ed3\u67e5\u770b");
        this.getPlanSummInfo(model, id);
        return "work/planyear/dailyPlan/viewSummaryInfo";
    }

    @Log(title="\u67e5\u770b\u65e5\u5e38\u5de5\u4f5c\u8ba1\u5212\u603b\u7ed3", type=2)
    @RequestMapping(value={"viewFinishSummary"}, method={RequestMethod.GET})
    public String viewFinishSummary(Model model, Long id) {
        this.logger.info("\u65e5\u5e38\u8ba1\u5212\u300b\u603b\u7ed3\u67e5\u770b");
        this.getPlanSummInfo(model, id);
        return "work/planyear/dailyPlan/viewSummaryFinish";
    }

    @RequestMapping(value={"toSendMessage"}, method={RequestMethod.GET})
    public String toSendMessage(Model model, Long id, String planWorkName) {
        this.logger.info("\u53d1\u9001\u63d0\u9192");
        Long staffid = UserUtils.getLoginStaffId();
        PlanYearDetail detail = this.planYearDetailServiceImpl.getPlanYearDetailById(id);
        PlanYear plan = (PlanYear)this.planYearServiceImpl.getById(detail.getPlanYearId());
        model.addAttribute("plan", (Object)plan);
        model.addAttribute("planWorkName", (Object)planWorkName);
        model.addAttribute("staffid", (Object)staffid);
        model.addAttribute("detail", (Object)detail);
        return "work/planyear/dailyPlan/sendMessage";
    }

    @Log(title="\u53d1\u9001\u65e5\u5e38\u5de5\u4f5c\u8ba1\u5212\u63d0\u9192", type=2)
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"sendMessage"}, method={RequestMethod.POST})
    public ResponseData<Integer> sendMessage(Long planId, String planWorkName) {
        this.logger.info("\u53d1\u9001\u63d0\u9192");
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffid = UserUtils.getLoginStaffId();
        PlanYearDetail detail = this.planYearDetailServiceImpl.getPlanYearDetailById(planId);
        PlanYear plan = (PlanYear)this.planYearServiceImpl.getById(detail.getPlanYearId());
        detail.setSelfPlan(plan);
        detail.setPlanWorkName(planWorkName);
        ResponseData r = new ResponseData();
        try {
            this.sendMes(detail, staffid, cid);
            r.setContent("\u53d1\u9001\u6210\u529f");
            r.setState(ResponseStateEnum.success);
        }
        catch (Exception e) {
            r.setContent("\u53d1\u9001\u5931\u8d25");
            r.setState(ResponseStateEnum.fail);
        }
        return r;
    }

    private void sendMes(PlanYearDetail detail, Long staffid, Long cid) {
        Message mes = new Message();
        mes.setBussinesId(detail.getId());
        mes.setBussinesType(MessageBusinessTypeEnum.remind.getValue());
        mes.setTypeName(MessageBusinessTypeEnum.remind.getName());
        if (detail.getParentPlanDetail() == null) {
            PlanYearDetail parentPlan = (PlanYearDetail)this.planYearDetailServiceImpl.getById(detail.getDetailPid());
            detail.setParentPlanDetail(parentPlan);
        }
        if (detail.getPlanWorkName() != null) {
            mes.setBussinesName(detail.getPlanWorkName());
        } else {
            mes.setBussinesName(detail.getParentPlanDetail().getPlanWorkName());
        }
        mes.setBussinesFromType(MessageBusinessFromEnum.workPlan.getValue());
        mes.setBussinesFrom(StaffUtil.getStaffNameOrgByStaffId(staffid));
        mes.setSendTime(new Date());
        mes.setBussinesNo("\u2014\u2014");
        mes.setCreateBy(staffid);
        mes.setUpdateBy(staffid);
        if (detail != null && detail.getSelfPlan() != null && detail.getSelfPlan().getStage() == 2) {
            con = "\u7236\u8ba1\u5212\u5de5\u4f5c\u540d\u79f0\uff1a" + detail.getParentPlanDetail().getPlanWorkName() + "<br />\u63d0\u9192\u5185\u5bb9\uff1a<a target=\"_blank\" href=\"{contextPath}/work/planyear/editNeedDecomposePlanWorkSummary?id=" + detail.getId() + "\">\u8bf7\u5c3d\u5feb\u5b9e\u65bd\u8ba1\u5212\uff01\u5982\u5df2\u5b9e\u65bd\u8bf7\u5c3d\u5feb\u603b\u7ed3\u5de5\u4f5c\u3002</a>";
            mes.setBussinessContent(con);
        } else {
            con = "\u7236\u8ba1\u5212\u5de5\u4f5c\u540d\u79f0\uff1a" + detail.getParentPlanDetail().getPlanWorkName() + "<br />\u63d0\u9192\u5185\u5bb9\uff1a<a target=\"_blank\" href=\"{contextPath}/work/planyear/editNeedDecomposePlanWork?id=" + detail.getId() + "\">\u8bf7\u5c3d\u5feb\u5236\u5b9a\u8ba1\u5212\uff01</a>";
            mes.setBussinessContent(con);
        }
        ArrayList<MessageReceiver> receivers = new ArrayList<MessageReceiver>();
        if (detail.getManagerId() != null) {
            MessageReceiver receiver = new MessageReceiver();
            receiver.setReveiver(detail.getManagerId());
            receivers.add(receiver);
        }
        mes.setReceivers(receivers);
        this.messageService.pushMessage(mes, staffid, cid);
    }

    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"sendMoreMessage"}, method={RequestMethod.POST})
    public ResponseData<Integer> sendMoreMessage(Long planId) {
        this.logger.info("\u53d1\u9001\u63d0\u9192");
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffid = UserUtils.getLoginStaffId();
        List list = this.planYearDetailServiceImpl.getChildrenPlanYearDetailsByPid(planId);
        ResponseData r = new ResponseData();
        try {
            if (list != null) {
                for (PlanYearDetail detail : list) {
                    this.sendMes(detail, staffid, cid);
                }
            }
            r.setContent("\u53d1\u9001\u6210\u529f");
            r.setState(ResponseStateEnum.success);
        }
        catch (Exception e) {
            r.setContent("\u53d1\u9001\u5931\u8d25");
            r.setState(ResponseStateEnum.fail);
        }
        return r;
    }

    @RequestMapping(value={"oneTouchRemind"}, method={RequestMethod.GET})
    public String oneTouchRemind(Model model, Long id) {
        this.logger.info("\u53d1\u9001\u63d0\u9192");
        Long staffid = UserUtils.getLoginStaffId();
        List list = this.planYearDetailServiceImpl.getChildrenPlanYearDetailsByPid(id);
        Object reminder = null;
        if (list != null) {
            for (PlanYearDetail detail : list) {
                if (detail.getImplateDateStr() != null) continue;
                if (reminder == null) {
                    reminder = StaffUtil.getStaffNameOrgByStaffId(detail.getManagerId());
                    continue;
                }
                reminder = (String)reminder + "\u3001" + StaffUtil.getStaffNameOrgByStaffId(detail.getManagerId());
            }
        }
        model.addAttribute("staffid", (Object)staffid);
        model.addAttribute("reminder", reminder);
        return "work/planyear/dailyPlan/oneTouchRemind";
    }

    @RequestMapping(value={"getWorkSubtypeByWorkType"}, method={RequestMethod.GET})
    public String getWorkSubtypeByWorkType(ModelMap m, String workType, String workSubtype) {
        if ("1".equals(workType)) {
            m.put((Object)"subtypes", (Object)CheckTypeEnum.values());
        } else if ("2".equals(workType)) {
            m.put((Object)"subtypes", (Object)HcCheckTypeEnum.values());
        } else if ("3".equals(workType)) {
            m.put((Object)"subtypes", (Object)TrainPlanTypeEnum.values());
        } else if ("9".equals(workType)) {
            m.put((Object)"subtypes", (Object)EvaluateHseTypeEnum.values());
        } else if ("6".equals(workType)) {
            m.put((Object)"subtypes", (Object)InspectionTypeEnum.values());
        } else if ("7".equals(workType)) {
            // empty if block
        }
        m.put((Object)"workType", (Object)workType);
        m.put((Object)"workSubtype", (Object)workSubtype);
        return "work/planyear/dailyPlan/getWorkSubtypeByWorkType";
    }
}

