/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.work.judge;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.mapper.JsonMapper;
import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCheckPlan;
import cn.smarthse.modules.health.entity.work.judge.OccuptionalJudge;
import cn.smarthse.modules.health.enums.sys.StatusEnum;
import cn.smarthse.modules.health.service.base.ICompanyService;
import cn.smarthse.modules.health.service.standard.IL081occupationalRiskFactorsListService;
import cn.smarthse.modules.health.service.work.judge.IJudgeEhsClassificationService;
import cn.smarthse.modules.health.service.work.judge.IOccuptionalJudgeService;
import cn.smarthse.modules.health.vo.work.judge.ContractInformInfo;
import cn.smarthse.modules.health.vo.work.judge.FunOrganManagerInfo;
import cn.smarthse.modules.health.vo.work.judge.HarmFactorDeclareInform;
import cn.smarthse.modules.health.vo.work.judge.LastHarmFactorTestInfo;
import cn.smarthse.modules.health.vo.work.judge.PhcCheckInfo;
import cn.smarthse.modules.health.vo.work.judge.PostHarmFactorInfo;
import cn.smarthse.modules.health.vo.work.judge.ShieldSendInfo;
import cn.smarthse.modules.health.vo.work.judge.TrainCertificateInfo;
import cn.smarthse.modules.health.vo.work.judge.WarningSignsSummary;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/work/judge"})
public class OccuptionalJudgeController
extends ControllerSupport {
    @DubboReference
    private IOccuptionalJudgeService judgeService;
    @DubboReference
    private IJudgeEhsClassificationService judgeEhsService;
    @DubboReference
    private ICompanyService companyService;
    @DubboReference
    private IL081occupationalRiskFactorsListService riskFactorsService;

    @RequiresPermissions(value={"judge.view", "judge.edit"}, logical=Logical.OR)
    @RequestMapping(method={RequestMethod.GET})
    public String index(Model model) {
        OccuptionalJudge lastJudge = this.judgeService.lastJudgeStaff(UserUtils.getLoginStaffId());
        if (lastJudge == null) {
            boolean hasJudgeCompany = this.judgeService.hasJudgeCompany(UserUtils.getLoginStaffCompanyId());
            if (hasJudgeCompany) {
                return "work/judge/noJudgeStaff";
            }
            return "work/judge/noJudgeCompany";
        }
        if (StatusEnum.finished.getValue().equals(lastJudge.getStatus())) {
            model.addAttribute("entity", (Object)lastJudge);
            return "work/judge/lastJudge";
        }
        model.addAttribute("entity", (Object)lastJudge);
        return "work/judge/lastJudgeNotFinished";
    }

    @RequiresPermissions(value={"judge.edit"}, logical=Logical.OR)
    @RequestMapping(method={RequestMethod.GET}, value={"/create"})
    public String create(Long id, Model model) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        this.setJudge(id, model);
        int msInfoCountHasFile = this.judgeEhsService.getMsInfoCountHasFile(cid);
        model.addAttribute("msInfoCountHasFile", (Object)msInfoCountHasFile);
        int msPohopCount = this.judgeEhsService.getMsPohopCount(cid);
        model.addAttribute("msPohopCount", (Object)msPohopCount);
        SysFileModel establishFile = this.judgeEhsService.getEstablishFile(cid);
        if (establishFile == null) {
            establishFile = new SysFileModel();
        }
        model.addAttribute("establishFile", (Object)establishFile);
        FunOrganManagerInfo funOrganMangerInfo = this.judgeEhsService.getFunOrganMangerInfo(cid);
        model.addAttribute("funOrganMangerInfo", (Object)funOrganMangerInfo);
        boolean isFinishedHarmFactorRegularCheck = this.judgeEhsService.isFinishedHarmFactorRegularCheck(cid, Calendar.getInstance().get(1));
        model.addAttribute("isFinishedHarmFactorRegularCheck", (Object)isFinishedHarmFactorRegularCheck);
        HcCheckPlan LastHarmFactorRegularCheck = this.judgeEhsService.getLastHarmFactorRegularCheck(cid, Calendar.getInstance().get(1));
        model.addAttribute("LastHarmFactorRegularCheck", (Object)LastHarmFactorRegularCheck);
        Company company = (Company)this.companyService.getById(cid);
        model.addAttribute("company", (Object)company);
        LastHarmFactorTestInfo lastEvalForHarmFactor = this.judgeEhsService.getLastEvalForHarmFactor(cid);
        model.addAttribute("lastEvalForHarmFactor", (Object)lastEvalForHarmFactor);
        if (lastEvalForHarmFactor != null && lastEvalForHarmFactor.getLastDate() != null) {
            Calendar threeYearDate = Calendar.getInstance();
            threeYearDate.add(1, -3);
            if (lastEvalForHarmFactor.getLastDate().before(threeYearDate.getTime())) {
                model.addAttribute("isThreeYear", (Object)true);
            } else {
                model.addAttribute("isThreeYear", (Object)false);
            }
        }
        LastHarmFactorTestInfo lastHarmFactorInfo = this.judgeEhsService.getLastHarmFactorInfo(cid);
        model.addAttribute("lastHarmFactorInfo", (Object)lastHarmFactorInfo);
        int harmFactorInformNum = this.judgeEhsService.getHarmFactorInformNum(cid);
        model.addAttribute("harmFactorInformNum", (Object)harmFactorInformNum);
        WarningSignsSummary warningSingsInfo = this.judgeEhsService.getWarningSingsInfo(cid);
        model.addAttribute("warningSingsInfo", (Object)warningSingsInfo);
        HarmFactorDeclareInform harmFactorDeclareInform = this.judgeEhsService.getHarmFactorDeclareInform(cid);
        model.addAttribute("harmFactorDeclareInform", (Object)harmFactorDeclareInform);
        List thirdTimeInfo = this.judgeEhsService.getThirdTimeInfo(cid);
        model.addAttribute("thirdTimeInfo", (Object)thirdTimeInfo);
        ContractInformInfo contractInformInfo = this.judgeEhsService.getContractInformInfo(cid);
        model.addAttribute("contractInformInfo", (Object)contractInformInfo);
        int deviceOccupationalDiseaseNum = this.judgeEhsService.getDeviceOccupationalDiseaseNum(cid);
        model.addAttribute("deviceOccupationalDiseaseNum", (Object)deviceOccupationalDiseaseNum);
        List shieldPurchaseList = this.judgeEhsService.getShieldPurchaseList(cid);
        model.addAttribute("shieldPurchaseList", (Object)shieldPurchaseList);
        ShieldSendInfo shieldSendInfo = this.judgeEhsService.getShieldSendInfo(cid);
        model.addAttribute("shieldSendInfo", (Object)shieldSendInfo);
        TrainCertificateInfo trainCertificateInfo = this.judgeEhsService.getTrainCertificateInfo(cid);
        model.addAttribute("trainCertificateInfo", (Object)trainCertificateInfo);
        PhcCheckInfo phcCheckInfo = this.judgeEhsService.getPhcCheckInfo(cid);
        model.addAttribute("phcCheckInfo", (Object)phcCheckInfo);
        int phcCheckNumJobing = this.judgeEhsService.getPhcCheckNumJobing(cid);
        model.addAttribute("phcCheckNumJobing", (Object)phcCheckNumJobing);
        Date lastPhcCheckDateJobing = this.judgeEhsService.getLastPhcCheckDateJobing(cid);
        model.addAttribute("lastPhcCheckDateJobing", (Object)lastPhcCheckDateJobing);
        int occupationalDiseasesNum = this.judgeEhsService.getOccupationalDiseasesNum(cid);
        model.addAttribute("occupationalDiseasesNum", (Object)occupationalDiseasesNum);
        int newOccupationalDiseasesNum = this.judgeEhsService.getNewOccupationalDiseasesNum(cid);
        model.addAttribute("newOccupationalDiseasesNum", (Object)newOccupationalDiseasesNum);
        int superSceneInspectionNum = this.judgeEhsService.getSuperSceneInspectionNum(cid);
        model.addAttribute("superSceneInspectionNum", (Object)superSceneInspectionNum);
        int superSceneInspectionNumYear = this.judgeEhsService.getSuperSceneInspectionNumYear(cid);
        model.addAttribute("superSceneInspectionNumYear", (Object)superSceneInspectionNumYear);
        return "work/judge/judgeCreate";
    }

    @RequiresPermissions(value={"judge.edit"}, logical=Logical.OR)
    @RequestMapping(value={"/notRegister"}, method={RequestMethod.GET})
    public String notRegister(Model model) {
        List contractInformNoRegisterList = this.judgeEhsService.getContractInformNoRegisterList(UserUtils.getLoginStaffCompanyId());
        model.addAttribute("contractInformNoRegisterList", (Object)JsonMapper.toJsonString((Object)contractInformNoRegisterList));
        return "work/judge/notRegister";
    }

    @RequiresPermissions(value={"judge.edit"}, logical=Logical.OR)
    @RequestMapping(method={RequestMethod.GET}, value={"/{id}/summaryJudgeOccManage"})
    public String summaryJudgeOccManage(@PathVariable(value="id") Long id, Model model) {
        OccuptionalJudge entity = (OccuptionalJudge)this.judgeService.getById(id);
        model.addAttribute("entity", (Object)entity);
        return "work/judge/summaryJudgeOccManage";
    }

    @RequiresPermissions(value={"judge.edit"}, logical=Logical.OR)
    @Log(title="\u4fdd\u5b58\u98ce\u9669\u5206\u7c7b\u5206\u7ea7\u8bc4\u5b9a\u5de5\u4f5c", type=24)
    @ResponseBody
    @RequestMapping(method={RequestMethod.POST}, value={"/save"})
    public ResponseData<OccuptionalJudge> save(OccuptionalJudge entity) {
        ResponseData data = new ResponseData();
        entity = this.judgeService.save(entity, UserUtils.getLoginStaffId(), UserUtils.getLoginStaffCompanyId());
        data.setResult((Object)entity);
        data.setContent("\u4fe1\u606f\u4fdd\u5b58\u6210\u529f");
        return data;
    }

    private void setJudge(Long id, Model model) {
        if (id != null) {
            OccuptionalJudge entity = (OccuptionalJudge)this.judgeService.getById(id);
            model.addAttribute("entity", (Object)entity);
        }
    }

    @RequiresPermissions(value={"judge.edit"}, logical=Logical.OR)
    @RequestMapping(method={RequestMethod.GET}, value={"/touchHarmFactorStaff"})
    public String touchHarmFactorStaff(Long id, Model model) {
        this.setJudge(id, model);
        int postHarmFactorStaffNum = this.judgeEhsService.getPostHarmFactorStaffNum(UserUtils.getLoginStaffCompanyId());
        model.addAttribute("postHarmFactorStaffNum", (Object)postHarmFactorStaffNum);
        return "work/judge/touchHarmFactorStaff";
    }

    @RequiresPermissions(value={"judge.edit"}, logical=Logical.OR)
    @ResponseBody
    @RequestMapping(value={"/touchStaff/jqGrid/data"}, method={RequestMethod.POST})
    public PageInfo<PostHarmFactorInfo> touchStaff(JqGridParam param) {
        PageInfo postHarmFactorInfoPage = this.judgeEhsService.getPostHarmFactorInfoPage(param, UserUtils.getLoginStaffCompanyId());
        return postHarmFactorInfoPage;
    }

    @RequiresPermissions(value={"judge.edit"}, logical=Logical.OR)
    @RequestMapping(method={RequestMethod.GET}, value={"/workPlaceJudge"})
    public String workPlaceJudge(Long id, Model model) {
        if (id != null) {
            OccuptionalJudge entity = (OccuptionalJudge)this.judgeService.getById(id);
            model.addAttribute("entity", (Object)entity);
        }
        Long cid = UserUtils.getLoginStaffCompanyId();
        List highHarm1 = this.judgeEhsService.getHighHarmFactorFromMaterial(cid, Integer.valueOf(1));
        List dustHarm1 = this.judgeEhsService.getHighHarmFactorFromMaterial(cid, Integer.valueOf(2));
        List highHarm2 = this.judgeEhsService.getHighHarmFactorFromProduct(cid, Integer.valueOf(1));
        List dustHarm2 = this.judgeEhsService.getHighHarmFactorFromProduct(cid, Integer.valueOf(2));
        List highHarm3 = this.judgeEhsService.getHighHarmFactorFromWorkPost(cid, Integer.valueOf(1));
        List dustHarm3 = this.judgeEhsService.getHighHarmFactorFromWorkPost(cid, Integer.valueOf(2));
        List highHarm4 = this.judgeEhsService.getHighHarmFactorFromWorkPlace(cid, Integer.valueOf(1));
        List dustHarm4 = this.judgeEhsService.getHighHarmFactorFromWorkPlace(cid, Integer.valueOf(2));
        List highHarm5 = this.judgeEhsService.getHighHarmFactorFromHarmFactorCheck(cid, Integer.valueOf(1));
        List dustHarm5 = this.judgeEhsService.getHighHarmFactorFromHarmFactorCheck(cid, Integer.valueOf(2));
        StringBuffer highHarmBuffer = new StringBuffer();
        for (String h : highHarm1) {
            if (highHarmBuffer.indexOf(h) > -1) continue;
            highHarmBuffer.append(h);
            highHarmBuffer.append("\uff1b");
        }
        for (String h : highHarm2) {
            if (highHarmBuffer.indexOf(h) > -1) continue;
            highHarmBuffer.append(h);
            highHarmBuffer.append("\uff1b");
        }
        for (String h : highHarm3) {
            if (highHarmBuffer.indexOf(h) > -1) continue;
            highHarmBuffer.append(h);
            highHarmBuffer.append("\uff1b");
        }
        for (String h : highHarm4) {
            if (highHarmBuffer.indexOf(h) > -1) continue;
            highHarmBuffer.append(h);
            highHarmBuffer.append("\uff1b");
        }
        for (String h : highHarm5) {
            if (highHarmBuffer.indexOf(h) > -1) continue;
            highHarmBuffer.append(h);
            highHarmBuffer.append("\uff1b");
        }
        if (highHarmBuffer.length() > 0) {
            highHarmBuffer.deleteCharAt(highHarmBuffer.length() - 1);
        }
        model.addAttribute("highHarmBuffer", (Object)highHarmBuffer);
        StringBuffer dustHarmBuffer = new StringBuffer();
        for (String h : dustHarm1) {
            if (dustHarmBuffer.indexOf(h) > -1) continue;
            dustHarmBuffer.append(h);
            dustHarmBuffer.append("\uff1b");
        }
        for (String h : dustHarm2) {
            if (dustHarmBuffer.indexOf(h) > -1) continue;
            dustHarmBuffer.append(h);
            dustHarmBuffer.append("\uff1b");
        }
        for (String h : dustHarm3) {
            if (dustHarmBuffer.indexOf(h) > -1) continue;
            dustHarmBuffer.append(h);
            dustHarmBuffer.append("\uff1b");
        }
        for (String h : dustHarm4) {
            if (dustHarmBuffer.indexOf(h) > -1) continue;
            dustHarmBuffer.append(h);
            dustHarmBuffer.append("\uff1b");
        }
        for (String h : dustHarm5) {
            if (dustHarmBuffer.indexOf(h) > -1) continue;
            dustHarmBuffer.append(h);
            dustHarmBuffer.append("\uff1b");
        }
        if (dustHarmBuffer.length() > 0) {
            dustHarmBuffer.deleteCharAt(dustHarmBuffer.length() - 1);
        }
        model.addAttribute("dustHarmBuffer", (Object)dustHarmBuffer);
        return "work/judge/workPlaceJudge";
    }

    @RequiresPermissions(value={"judge.edit"}, logical=Logical.OR)
    @ResponseBody
    @RequestMapping(method={RequestMethod.DELETE}, value={"/{id}"})
    public ResponseData<OccuptionalJudge> deleteJudge(@PathVariable(value="id") Long id, Model model) {
        ResponseData data = new ResponseData();
        OccuptionalJudge entity = new OccuptionalJudge();
        entity.setId(id);
        this.judgeService.delete((Object)entity, UserUtils.getLoginStaffId());
        data.setResult((Object)entity);
        return data;
    }

    @RequiresPermissions(value={"judge.view"}, logical=Logical.OR)
    @RequestMapping(method={RequestMethod.GET}, value={"/historyJudge"})
    public String historyJudge(Model model) {
        return "work/judge/historyJudge";
    }

    @RequiresPermissions(value={"judge.view"}, logical=Logical.OR)
    @ResponseBody
    @RequestMapping(value={"/historyJudge/jqGrid/data"}, method={RequestMethod.POST})
    public PageInfo<OccuptionalJudge> unfinishedJqGridData(JqGridParam param) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        PageInfo pageInfo = this.judgeService.judgeFinishedPageInfo(param);
        return pageInfo;
    }

    @RequiresPermissions(value={"judge.view"}, logical=Logical.OR)
    @RequestMapping(method={RequestMethod.GET}, value={"/view/{id}"})
    public String viewJudge(@PathVariable(value="id") Long id, Model model) {
        this.setJudge(id, model);
        return "work/judge/viewJudge";
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/highHarmFactor"})
    public String highHarmFactor(Model model, String searchName) {
        List list = this.riskFactorsService.getHToxicList(searchName);
        model.addAttribute("list", (Object)list);
        model.addAttribute("searchName", (Object)searchName);
        return "work/judge/highHarmFactor";
    }
}

