/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.work.informmanager;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.excel.ExportExcel;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.mapper.JsonMapper;
import cn.smarthse.common.util.CookieUtil;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.ZipCompressorUtil;
import cn.smarthse.common.util.leak.ResponseLeakUtil;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.entity.work.check.vo.PhcDiseaserConfirmedDetail;
import cn.smarthse.modules.health.entity.work.check.vo.PhcDiseaserUnProcessParam;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckConfiredInfo;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckParam;
import cn.smarthse.modules.health.entity.work.harmfactor.Vo.HarmfactorWorkSourceInfoVo;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCheckPlan;
import cn.smarthse.modules.health.entity.work.informmanager.ContractInform;
import cn.smarthse.modules.health.entity.work.informmanager.ContractInformTemplate;
import cn.smarthse.modules.health.entity.work.informmanager.NoInformStaff;
import cn.smarthse.modules.health.entity.work.informmanager.OccupationalDiseaseContraindication;
import cn.smarthse.modules.health.enums.check.CheckTypeEnum;
import cn.smarthse.modules.health.enums.hccheckplan.HcCheckPlanStatusEnum;
import cn.smarthse.modules.health.service.base.company.ICompanyOrganizationService;
import cn.smarthse.modules.health.service.base.company.role.ICompanyRoleRelationService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.base.workinfo.IWorkRoleInfoService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckCountService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckDataResultService;
import cn.smarthse.modules.health.service.work.harmfactor.IHarmfactorWorkService;
import cn.smarthse.modules.health.service.work.hccheckplan.IHcCheckPlanService;
import cn.smarthse.modules.health.service.work.informmanager.IContractInformService;
import cn.smarthse.modules.health.service.work.informmanager.IContractInformTemplateService;
import cn.smarthse.modules.health.service.work.informmanager.INoInformStaffService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.DocUtil;
import cn.smarthse.web.util.UserUtils;
import cn.smarthse.web.util.WorkRoleInfoUtil;
import com.alibaba.fastjson2.JSONArray;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/work/informmanager/InformManager"})
public class InformManagerController
extends ControllerSupport {
    @DubboReference
    private ICompanyRoleRelationService companyRoleRelationService;
    @DubboReference
    private ICompanyOrganizationService companyOrganizationService;
    @DubboReference
    private IPhcPhysicalCheckCountService phcPhysicalCheckCountService;
    @DubboReference
    private IStaffInfoService staffInfoService;
    @DubboReference
    private IContractInformService contractInformService;
    @DubboReference
    private IContractInformTemplateService contractInformTemplateService;
    @DubboReference
    private IHarmfactorWorkService harmfactorWorkService;
    @DubboReference
    private INoInformStaffService noInformStaffService;
    @DubboReference
    private IWorkRoleInfoService workRoleInfoService;
    @DubboReference
    private IPhcPhysicalCheckDataResultService resultService;
    @DubboReference
    private IHcCheckPlanService hcCheckPlanService;

    @RequestMapping(method={RequestMethod.GET}, value={"getAddContractInformPage"})
    public String getAddContractInformPage(ModelMap m) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long createBy = UserUtils.getLoginStaffId();
        m.put((Object)"staffCount", (Object)this.staffInfoService.getStaffCountByCid(cid, null));
        m.put((Object)"workHarmCount", (Object)this.harmfactorWorkService.countHarmNumByCid(cid));
        m.put((Object)"workCount", (Object)this.workRoleInfoService.getWorkRoleInfosByCid(cid).size());
        m.put((Object)"cid", (Object)cid);
        m.put((Object)"createBy", (Object)createBy);
        return "/work/informmanager/getAddContractInformPage";
    }

    @ResponseBody
    @RequestMapping(value={"getHarmfactorWorksByWorkId"})
    public ResponseData<JSONArray> getHarmfactorWorksByWorkId(ModelMap m, Long workId) throws Exception {
        ResponseData data = new ResponseData();
        Long cid = UserUtils.getLoginStaffCompanyId();
        if (workId != null) {
            List list = this.harmfactorWorkService.getHarmfactorListByWork(cid, workId);
            HashMap<CallSite, HarmfactorWorkSourceInfoVo> map = new HashMap<CallSite, HarmfactorWorkSourceInfoVo>();
            if (list != null && list.size() > 0) {
                for (HarmfactorWorkSourceInfoVo v : list) {
                    map.put((CallSite)((Object)("" + v.getHarmId())), v);
                }
            }
            data.setResult((Object)JSONArray.from((Object)JsonMapper.toJsonString(map.values())));
        }
        return data;
    }

    @RequestMapping(value={"addContractInformSubmit"})
    public String addContractInformSubmit(ModelMap m, ContractInform contractInform) throws Exception {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long loginStaffId = UserUtils.getLoginStaffId();
        if ((contractInform = this.contractInformService.addContractInformSubmit(contractInform, loginStaffId, cid)) != null) {
            m.put((Object)"staffInfo", (Object)this.staffInfoService.getStaffInfoWithStaffBasicWorkById(contractInform.getStaffId()));
            List harmfactors = this.harmfactorWorkService.getHarmfactorListByWork(contractInform.getCid(), contractInform.getInformWorkId());
            HashMap<CallSite, HarmfactorWorkSourceInfoVo> map = new HashMap<CallSite, HarmfactorWorkSourceInfoVo>();
            if (harmfactors != null && harmfactors.size() > 0) {
                for (HarmfactorWorkSourceInfoVo v : harmfactors) {
                    map.put((CallSite)((Object)("" + v.getHarmId())), v);
                }
            }
            m.put((Object)"harmfactors", map.values());
            if (contractInform.getInformTempId() != null && contractInform.getInformWorkId() != null) {
                List list = this.contractInformService.getOccupationalDiseaseContraindicationListFromBaseData(contractInform.getInformTempId(), contractInform.getInformWorkId(), cid, loginStaffId);
                m.put((Object)"list", (Object)list);
            }
        }
        m.put((Object)"contractInform", (Object)contractInform);
        return "/work/informmanager/addContractInformTemplateContentPage";
    }

    @RequestMapping(value={"getAddContractInformTemplatePage"})
    public String getAddContractInformTemplatePage(ModelMap m, HttpServletRequest request, HttpServletResponse response) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long orgId = UserUtils.getOrgId();
        ContractInformTemplate template = this.contractInformTemplateService.addNoValidContractInformTemplate(loginStaffId, cid, orgId);
        String alreadyTip = CookieUtil.getCookie((HttpServletRequest)request, (String)("informTip" + loginStaffId));
        boolean isPro = this.companyRoleRelationService.hasProfessionalRole(cid);
        m.put((Object)"isPro", (Object)isPro);
        if (isPro) {
            alreadyTip = "alreadyTip";
        }
        if ("alreadyTip".equals(alreadyTip)) {
            m.put((Object)"informTip", (Object)false);
        } else {
            m.put((Object)"informTip", (Object)true);
            CookieUtil.setCookie((HttpServletResponse)response, (String)("informTip" + loginStaffId), (String)"alreadyTip", (String)(request.getContextPath() + "/work/informmanager/InformManager"), (int)157680000);
        }
        m.put((Object)"template", (Object)template);
        return "/work/informmanager/getAddContractInformTemplatePage";
    }

    @RequestMapping(value={"goToAddContratInformTemlatePage"})
    public String goToAddContratInformTemlatePage(Long workId, ModelMap m) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long orgId = UserUtils.getOrgId();
        ContractInformTemplate template = this.contractInformTemplateService.addNoValidContractInformTemplate(loginStaffId, cid, orgId);
        template.setInformWorkId(workId);
        if (template != null && template.getInformWorkId() != null) {
            List list = this.contractInformService.getOccupationalDiseaseContraindicationListFromBaseData(template.getId(), template.getInformWorkId(), cid, loginStaffId);
            m.put((Object)"list", (Object)list);
        }
        m.put((Object)"template", (Object)template);
        return "/work/informmanager/goToAddContratInformTemlatePage";
    }

    @RequestMapping(value={"getOccupationalDiseaseContraindicationList"})
    public String getOccupationalDiseaseContraindicationList(ModelMap m, Long workId, Long templateId) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long loginStaffId = UserUtils.getLoginStaffId();
        List list = this.contractInformService.getOccupationalDiseaseContraindicationListFromBaseData(templateId, workId, cid, loginStaffId);
        m.put((Object)"list", (Object)list);
        return "/work/informmanager/getOccupationalDiseaseContraindicationPage";
    }

    @RequestMapping(value={"editOccupationalDiseaseContraindicationPage"})
    public String editOccupationalDiseaseContraindicationPage(ModelMap m, Long id) {
        OccupationalDiseaseContraindication odc = this.contractInformService.getOccupationalDiseaseContraindication(id);
        m.put((Object)"odc", (Object)odc);
        return "/work/informmanager/editOccupationalDiseaseContraindicationPage";
    }

    @ResponseBody
    @RequestMapping(value={"editOccupationalDiseaseContraindicationSubmit"})
    public ResponseData<String> editOccupationalDiseaseContraindicationSubmit(OccupationalDiseaseContraindication o) {
        Long loginStaffId = UserUtils.getLoginStaffId();
        this.contractInformService.editOccupationalDiseaseContraindicationSubmit(o, loginStaffId);
        return new ResponseData();
    }

    @ResponseBody
    @RequestMapping(value={"addContractInformTemplateSubmit"})
    public Boolean addContractInformTemplateSubmit(ContractInformTemplate template) {
        template.setIsValid(Global.TRUE);
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        template.setCid(cid);
        Boolean isExist = this.contractInformTemplateService.addContractInformTemplateSubmit(template, loginStaffId);
        return isExist;
    }

    @RequestMapping(value={"getContractInformTemplateSearchPage"})
    public String getContractInformTemplateSearchPage() {
        return "/work/informmanager/getContractInformTemplateSearchPage";
    }

    @ResponseBody
    @RequestMapping(value={"templateListData"})
    public JqGridData<ContractInformTemplate> templateListData(JqGridParam jparam, ContractInformTemplate template) throws Exception {
        template.setCid(UserUtils.getLoginStaffCompanyId());
        PageInfo list = this.contractInformTemplateService.getcontractInformTemplateListByJParam(jparam, template);
        return new JqGridData(list, jparam);
    }

    @RequestMapping(value={"getEditContractInformTemplatePage"})
    public String getEditContractInformTemplatePage(Long id, ModelMap m, HttpServletRequest request, HttpServletResponse response) {
        ContractInformTemplate template = (ContractInformTemplate)this.contractInformTemplateService.getById(id);
        m.put((Object)"template", (Object)template);
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long loginStaffId = UserUtils.getLoginStaffId();
        if (template != null && template.getInformWorkId() != null) {
            List list = this.contractInformService.getOccupationalDiseaseContraindicationListFromBaseData(template.getId(), template.getInformWorkId(), cid, loginStaffId);
            m.put((Object)"list", (Object)list);
        }
        String alreadyTip = CookieUtil.getCookie((HttpServletRequest)request, (String)("informTip" + loginStaffId));
        boolean isPro = this.companyRoleRelationService.hasProfessionalRole(cid);
        m.put((Object)"isPro", (Object)isPro);
        if (isPro) {
            alreadyTip = "alreadyTip";
        }
        if ("alreadyTip".equals(alreadyTip)) {
            m.put((Object)"informTip", (Object)false);
        } else {
            m.put((Object)"informTip", (Object)true);
            CookieUtil.setCookie((HttpServletResponse)response, (String)("informTip" + loginStaffId), (String)"alreadyTip", (String)(request.getContextPath() + "/work/informmanager/InformManager"), (int)157680000);
        }
        return "/work/informmanager/getEditContractInformTemplatePage";
    }

    @RequestMapping(value={"getContractInformTemplateViewPage"})
    public String getContractInformTemplateViewPage(Long id, ModelMap m, HttpServletRequest request, HttpServletResponse response) {
        ContractInformTemplate template = (ContractInformTemplate)this.contractInformTemplateService.getById(id);
        m.put((Object)"template", (Object)template);
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long loginStaffId = UserUtils.getLoginStaffId();
        if (template != null && template.getInformWorkId() != null) {
            List list = this.contractInformService.getOccupationalDiseaseContraindicationListFromBaseData(template.getId(), template.getInformWorkId(), cid, loginStaffId);
            m.put((Object)"list", (Object)list);
        }
        String alreadyTip = CookieUtil.getCookie((HttpServletRequest)request, (String)("informTip" + loginStaffId));
        boolean isPro = this.companyRoleRelationService.hasProfessionalRole(cid);
        m.put((Object)"isPro", (Object)isPro);
        if (isPro) {
            alreadyTip = "alreadyTip";
        }
        if ("alreadyTip".equals(alreadyTip)) {
            m.put((Object)"informTip", (Object)false);
        } else {
            m.put((Object)"informTip", (Object)true);
            CookieUtil.setCookie((HttpServletResponse)response, (String)("informTip" + loginStaffId), (String)"alreadyTip", (String)(request.getContextPath() + "/work/informmanager/InformManager"), (int)157680000);
        }
        return "/work/informmanager/getContractInformTemplateViewPage";
    }

    @RequestMapping(value={"getContractInformTemplateViewFromCiinfoPage"})
    public String getContractInformTemplateViewFromCiinfoPage(Long id, ModelMap m) {
        ContractInformTemplate template = (ContractInformTemplate)this.contractInformTemplateService.getById(id);
        m.put((Object)"template", (Object)template);
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long loginStaffId = UserUtils.getLoginStaffId();
        if (template != null && template.getInformWorkId() != null) {
            List list = this.contractInformService.getOccupationalDiseaseContraindicationListFromBaseData(template.getId(), template.getInformWorkId(), cid, loginStaffId);
            m.put((Object)"list", (Object)list);
        }
        return "/work/informmanager/getContractInformTemplateViewFromCiinfoPage";
    }

    @ResponseBody
    @RequestMapping(value={"deleteContractInformTemplateById"})
    public ResponseData<String> deleteContractInformTemplateById(Long id) {
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        this.contractInformTemplateService.deleteContractInformTemplateById(id, loginStaffId, cid);
        return new ResponseData();
    }

    @ResponseBody
    @RequestMapping(value={"exportContractInformTemplate"})
    public void exportContractInformTemplate(HttpServletResponse response, ModelMap m, Long templateId) throws IOException {
        ContractInformTemplate template = (ContractInformTemplate)this.contractInformTemplateService.getById(templateId);
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        m.put((Object)"template", (Object)template);
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long loginStaffId = UserUtils.getLoginStaffId();
        Object fileName = "";
        if (template != null && template.getInformWorkId() != null) {
            List list = this.contractInformService.getOccupationalDiseaseContraindicationListFromBaseData(template.getId(), template.getInformWorkId(), cid, loginStaffId);
            fileName = (String)fileName + WorkRoleInfoUtil.getWorkNameIncludeOrgName(template.getInformWorkId());
            fileName = ((String)fileName).replace("(\u5df2\u5220\u9664)", "").replace("/", "-");
            dataMap.put("workName", WorkRoleInfoUtil.getWorkRoleInfoName(template.getInformWorkId()));
            dataMap.put("diseaseContraindicationList", list);
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        fileName = (String)fileName + "\u5408\u540c\u544a\u77e5";
        fileName = (String)fileName + dateFormat.format(new Date());
        fileName = (String)fileName + ".doc";
        fileName = URLEncoder.encode(String.format((String)fileName, LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE)), "UTF-8").replaceAll("\\+", "%20");
        response.setContentType("application/x-download");
        ResponseLeakUtil.setReponseFileName((HttpServletResponse)response, (String)fileName);
        DocUtil docUtil = new DocUtil();
        docUtil.createDoc(dataMap, "ciinfo.ftl", response.getWriter(), "/templates/contractinfo/");
    }

    @ResponseBody
    @RequestMapping(value={"deleteContractInformTemplateByIds"})
    public ResponseData<String> deleteContractInformTemplateByIds(String ids) {
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        if (StringUtils.isNotEmpty((String)ids)) {
            this.contractInformTemplateService.deleteByIds(ids, loginStaffId, cid);
        }
        return new ResponseData();
    }

    @ResponseBody
    @RequestMapping(value={"updateContractInformSubmit"})
    public ResponseData<String> updateContractInformSubmit(ContractInform contractInform) {
        Long loginStaffId = UserUtils.getLoginStaffId();
        contractInform = this.contractInformService.updateContractInformSubmit(contractInform, loginStaffId);
        ResponseData data = new ResponseData();
        data.setResult((Object)("" + contractInform.getId()));
        return data;
    }

    @RequestMapping(value={"getContractInformingSearchPage"})
    public String getContractInformingSearchPage() {
        return "/work/informmanager/getContractInformingSearchPage";
    }

    @RequestMapping(value={"getContractInformedSearchPage"})
    public String getContractInformedSearchPage(ModelMap m, Integer informYear) {
        m.put((Object)"informYear", (Object)informYear);
        return "/work/informmanager/getInformManagerStatPage";
    }

    @ResponseBody
    @RequestMapping(value={"listData"})
    public JqGridData<ContractInform> listData(JqGridParam jparam, ContractInform inform) {
        inform.setCid(UserUtils.getLoginStaffCompanyId());
        UserUtils.startWebDataScope();
        PageInfo list = this.contractInformService.getcontractInformListByJParam(jparam, inform);
        return new JqGridData(list, jparam);
    }

    @RequestMapping(value={"getContractInformViewPage"})
    public String getContractInformViewPage(ModelMap m, Long id) throws Exception {
        ContractInform contractInform = this.contractInformService.getContractInformById(id);
        if (contractInform != null && contractInform.getInformTempId() != null) {
            ContractInformTemplate template = (ContractInformTemplate)this.contractInformTemplateService.getById(contractInform.getInformTempId());
            m.put((Object)"template", (Object)template);
            Long cid = UserUtils.getLoginStaffCompanyId();
            Long loginStaffId = UserUtils.getLoginStaffId();
            contractInform.setWorkName(WorkRoleInfoUtil.getWorkRoleInfoName(contractInform.getInformWorkId()));
            if (template != null && template.getInformWorkId() != null) {
                List harmFactorList = this.harmfactorWorkService.getHarmfactorListByWork(cid, template.getInformWorkId());
                HashMap<CallSite, HarmfactorWorkSourceInfoVo> map = new HashMap<CallSite, HarmfactorWorkSourceInfoVo>();
                if (harmFactorList != null && harmFactorList.size() > 0) {
                    for (HarmfactorWorkSourceInfoVo v : harmFactorList) {
                        map.put((CallSite)((Object)("" + v.getHarmId())), v);
                    }
                }
                m.put((Object)"harmFactorList", map.values());
                List list = this.contractInformService.getOccupationalDiseaseContraindicationListFromBaseData(template.getId(), template.getInformWorkId(), cid, loginStaffId);
                m.put((Object)"list", (Object)list);
            }
            m.put((Object)"staffInfo", (Object)this.staffInfoService.getStaffInfoWithStaffBasicWorkById(contractInform.getStaffId()));
        }
        m.put((Object)"page_editable", (Object)false);
        m.put((Object)"contractInform", (Object)contractInform);
        return "/work/informmanager/getContractInformViewPage";
    }

    @RequestMapping(value={"getEditContractInformPage"})
    public String getEditContractInformPage(ModelMap m, Long id) throws Exception {
        ContractInform contractInform = this.contractInformService.getContractInformById(id);
        if (contractInform != null && contractInform.getInformTempId() != null) {
            ContractInformTemplate template = (ContractInformTemplate)this.contractInformTemplateService.getById(contractInform.getInformTempId());
            m.put((Object)"template", (Object)template);
            Long cid = UserUtils.getLoginStaffCompanyId();
            Long loginStaffId = UserUtils.getLoginStaffId();
            contractInform.setWorkName(WorkRoleInfoUtil.getWorkRoleInfoName(contractInform.getInformWorkId()));
            if (template != null && template.getInformWorkId() != null) {
                List harmFactorList = this.harmfactorWorkService.getHarmfactorListByWork(cid, template.getInformWorkId());
                HashMap<CallSite, HarmfactorWorkSourceInfoVo> map = new HashMap<CallSite, HarmfactorWorkSourceInfoVo>();
                if (harmFactorList != null && harmFactorList.size() > 0) {
                    for (HarmfactorWorkSourceInfoVo v : harmFactorList) {
                        map.put((CallSite)((Object)("" + v.getHarmId())), v);
                    }
                }
                m.put((Object)"harmFactorList", map.values());
                List list = this.contractInformService.getOccupationalDiseaseContraindicationListFromBaseData(template.getId(), template.getInformWorkId(), cid, loginStaffId);
                m.put((Object)"list", (Object)list);
            }
            m.put((Object)"staffInfo", (Object)this.staffInfoService.getStaffInfoWithStaffBasicWorkById(contractInform.getStaffId()));
        }
        m.put((Object)"contractInform", (Object)contractInform);
        return "/work/informmanager/getEditContractInformPage";
    }

    @ResponseBody
    @RequestMapping(value={"deleteContractInformById"})
    public ResponseData<String> deleteContractInformById(Long id) {
        Long loginStaffId = UserUtils.getLoginStaffId();
        ContractInform contractInform = new ContractInform();
        contractInform.setId(id);
        this.contractInformService.delete((Object)contractInform, loginStaffId);
        return new ResponseData();
    }

    @RequestMapping(value={"getInformManagerStatPage"})
    public String getInformManagerStatPage(ModelMap m, Integer informYear) {
        m.put((Object)"informYear", (Object)informYear);
        return "/work/informmanager/getInformManagerStatPage";
    }

    @RequestMapping(value={"getPhysicalExaminationResultInformPage"})
    public String getPhysicalExaminationResultInformPage(ModelMap m, Integer informYear) {
        m.put((Object)"checkTypes", (Object)CheckTypeEnum.values());
        m.put((Object)"informYear", (Object)informYear);
        return "/work/informmanager/getPhysicalExaminationResultInformPage";
    }

    @RequestMapping(value={"getHcCheckPlanResultInformPage"})
    public String getHcCheckPlanResultInformPage(ModelMap m, Integer informYear) {
        m.put((Object)"informYear", (Object)informYear);
        return "/work/informmanager/getHcCheckPlanResultInformPage";
    }

    @RequestMapping(value={"getNoInformedStaffPage"})
    public String getNoInformedStaffPage() {
        return "/work/informmanager/getNoInformedStaffPage";
    }

    @ResponseBody
    @RequestMapping(value={"noInformStaffListData"})
    public JqGridData<NoInformStaff> noInformStaffListData(JqGridParam jparam, NoInformStaff noInformStaff) throws Exception {
        noInformStaff.setCid(UserUtils.getLoginStaffCompanyId());
        PageInfo list = this.contractInformService.getNoInformStaffLisByJParam(jparam, noInformStaff);
        return new JqGridData(list, jparam);
    }

    @ResponseBody
    @RequestMapping(value={"deleteNoInformStaffById"})
    public ResponseData<String> deleteNoInformStaffById(Long id) {
        Long loginStaffId = UserUtils.getLoginStaffId();
        NoInformStaff noInformStaff = new NoInformStaff();
        noInformStaff.setId(id);
        this.noInformStaffService.delete((Object)noInformStaff, loginStaffId);
        return new ResponseData();
    }

    @RequestMapping(value={"getIsConfirmInformPage"})
    public String getIsConfirmInformPage(ModelMap m, Long id, Long staffId, Long workInfoId, Byte changWorkStatus) {
        NoInformStaff noInformStaff;
        if (changWorkStatus == 6) {
            noInformStaff = (NoInformStaff)this.noInformStaffService.getById(id);
            m.put((Object)"noInformStaff", (Object)noInformStaff);
        }
        if (changWorkStatus == 1) {
            noInformStaff = new NoInformStaff();
            noInformStaff.setWorkInfoId(workInfoId);
            noInformStaff.setStaffId(staffId);
            m.put((Object)"noInformStaff", (Object)noInformStaff);
        }
        m.put((Object)"changWorkStatus", (Object)changWorkStatus);
        return "/work/informmanager/getIsConfirmInformPage";
    }

    @ResponseBody
    @RequestMapping(value={"isConfirmInformSubmit"})
    public Boolean isConfirmInformSubmit(ModelMap m, ContractInform contractInform) throws Exception {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long loginStaffId = UserUtils.getLoginStaffId();
        contractInform.setInformState(Long.valueOf(0L));
        contractInform = this.contractInformService.addContractInformSubmit(contractInform, loginStaffId, cid);
        if (contractInform == null) {
            return false;
        }
        return true;
    }

    @RequestMapping(value={"getPhysicalExaminationDiagnosisResultInformPage"})
    public String getPhysicalExaminationDiagnosisResultInformPage(ModelMap m, Integer informYear) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        m.put((Object)"orgs", (Object)this.companyOrganizationService.getListByCid(cid));
        m.put((Object)"informYear", (Object)informYear);
        return "/work/informmanager/getPhysicalExaminationDiagnosisResultInformPage";
    }

    @ResponseBody
    @RequestMapping(value={"phcDiseaserConfirmedStaffData"})
    public JqGridData<PhcDiseaserConfirmedDetail> phcDiseaserConfirmedStaffData(JqGridParam gparam, PhcDiseaserUnProcessParam query) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        query.setCid(cid);
        UserUtils.startWebDataScope();
        PageInfo list = this.phcPhysicalCheckCountService.getConfirmedPageByQuery(gparam, query);
        return new JqGridData(list, gparam);
    }

    @ResponseBody
    @RequestMapping(value={"getContractInformTemplateByWorkId"})
    public ResponseData<String> getContractInformTemplateByWorkId(Long workId) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        ContractInformTemplate template = this.contractInformTemplateService.getContractInformTemplateByWorkId(workId, cid);
        ResponseData data = new ResponseData();
        if (template != null) {
            data.setResult((Object)("" + template.getId()));
        } else {
            data.setResult((Object)"-1");
        }
        return data;
    }

    @RequiresPermissions(value={"informingmanagement.edit"})
    @RequestMapping(method={RequestMethod.GET}, value={"getNewAddContractInformPage"})
    public String getNewAddContractInformPage(ModelMap m, Long staffId) {
        StaffInfo staffInfo;
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long createBy = UserUtils.getLoginStaffId();
        m.put((Object)"staffCount", (Object)this.staffInfoService.getStaffCountByCid(cid, null));
        m.put((Object)"workHarmCount", (Object)this.harmfactorWorkService.countHarmNumByCid(cid));
        m.put((Object)"workCount", (Object)this.workRoleInfoService.getWorkRoleInfosByCid(cid).size());
        m.put((Object)"cid", (Object)cid);
        m.put((Object)"createBy", (Object)createBy);
        if (staffId != null && (staffInfo = this.staffInfoService.getStaffInfoWithStaffBasicWorkById(staffId)) != null) {
            m.put((Object)"staffInfo", (Object)staffInfo);
            if (staffInfo.getStaffWorkRole() != null && staffInfo.getStaffWorkRole().getWorkRoleId() != null) {
                List harmFactorList = this.harmfactorWorkService.getHarmfactorListByWork(cid, staffInfo.getStaffWorkRole().getWorkRoleId());
                HashMap<CallSite, HarmfactorWorkSourceInfoVo> map = new HashMap<CallSite, HarmfactorWorkSourceInfoVo>();
                if (harmFactorList != null && harmFactorList.size() > 0) {
                    for (HarmfactorWorkSourceInfoVo v : harmFactorList) {
                        map.put((CallSite)((Object)("" + v.getHarmId())), v);
                    }
                }
                m.put((Object)"harmFactorList", map.values());
            }
        }
        return "/work/informmanager/getNewAddContractInformPage";
    }

    @ResponseBody
    @RequestMapping(value={"addNewContractInformSubmit"})
    public ResponseData<ContractInform> addNewContractInformSubmit(ModelMap m, ContractInform contractInform) throws Exception {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long orgId = UserUtils.getOrgId();
        if (contractInform.getId() == null) {
            contractInform.setOrgId(orgId);
        }
        contractInform = this.contractInformService.addNewContractInformSubmit(contractInform, loginStaffId, cid);
        ResponseData data = new ResponseData();
        data.setResult((Object)contractInform);
        return data;
    }

    @RequestMapping(value={"getNewEditContractInformPage"})
    public String getNewEditContractInformPage(ModelMap m, Long id) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long createBy = UserUtils.getLoginStaffId();
        m.put((Object)"staffCount", (Object)this.staffInfoService.getStaffCountByCid(cid, null));
        m.put((Object)"workHarmCount", (Object)this.harmfactorWorkService.countHarmNumByCid(cid));
        m.put((Object)"workCount", (Object)this.workRoleInfoService.getWorkRoleInfosByCid(cid).size());
        m.put((Object)"cid", (Object)cid);
        m.put((Object)"createBy", (Object)createBy);
        ContractInform contractInform = this.contractInformService.getContractInformById(id);
        if (contractInform != null) {
            if (contractInform.getInformWorkId() != null) {
                ContractInformTemplate template = this.contractInformTemplateService.getContractInformTemplateByWorkId(contractInform.getInformWorkId(), cid);
                if (template != null) {
                    contractInform.setInformTempId(template.getId());
                    this.contractInformService.update((Object)contractInform, createBy);
                } else {
                    contractInform.setInformTempId(null);
                }
                List harmFactorList = this.harmfactorWorkService.getHarmfactorListByWork(cid, contractInform.getInformWorkId());
                HashMap<CallSite, HarmfactorWorkSourceInfoVo> map = new HashMap<CallSite, HarmfactorWorkSourceInfoVo>();
                if (harmFactorList != null && harmFactorList.size() > 0) {
                    for (HarmfactorWorkSourceInfoVo v : harmFactorList) {
                        map.put((CallSite)((Object)("" + v.getHarmId())), v);
                    }
                }
                m.put((Object)"harmFactorList", map.values());
            }
            if (contractInform.getStaffId() != null) {
                m.put((Object)"staffInfo", (Object)this.staffInfoService.getStaffInfoWithStaffBasicWorkById(contractInform.getStaffId()));
            }
        }
        m.put((Object)"contractInform", (Object)contractInform);
        return "/work/informmanager/getNewEditContractInformPage";
    }

    @RequestMapping(value={"getNewViewContractInformPage"})
    public String getNewViewContractInformPage(ModelMap m, Long id) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long createBy = UserUtils.getLoginStaffId();
        m.put((Object)"staffCount", (Object)this.staffInfoService.getStaffCountByCid(cid, null));
        m.put((Object)"workHarmCount", (Object)this.harmfactorWorkService.countHarmNumByCid(cid));
        m.put((Object)"workCount", (Object)this.workRoleInfoService.getWorkRoleInfosByCid(cid).size());
        m.put((Object)"cid", (Object)cid);
        m.put((Object)"createBy", (Object)createBy);
        ContractInform contractInform = this.contractInformService.getContractInformById(id);
        if (contractInform != null) {
            if (contractInform.getInformWorkId() != null) {
                ContractInformTemplate template = this.contractInformTemplateService.getContractInformTemplateByWorkId(contractInform.getInformWorkId(), cid);
                if (template != null) {
                    contractInform.setInformTempId(template.getId());
                    this.contractInformService.update((Object)contractInform, createBy);
                } else {
                    contractInform.setInformTempId(null);
                }
                List harmFactorList = this.harmfactorWorkService.getHarmfactorListByWork(cid, contractInform.getInformWorkId());
                HashMap<CallSite, HarmfactorWorkSourceInfoVo> map = new HashMap<CallSite, HarmfactorWorkSourceInfoVo>();
                if (harmFactorList != null && harmFactorList.size() > 0) {
                    for (HarmfactorWorkSourceInfoVo v : harmFactorList) {
                        map.put((CallSite)((Object)("" + v.getHarmId())), v);
                    }
                }
                m.put((Object)"harmFactorList", map.values());
            }
            if (contractInform.getStaffId() != null) {
                m.put((Object)"staffInfo", (Object)this.staffInfoService.getStaffInfoWithStaffBasicWorkById(contractInform.getStaffId()));
            }
        }
        m.put((Object)"contractInform", (Object)contractInform);
        m.put((Object)"page_editable", (Object)false);
        return "/work/informmanager/getNewViewContractInformPage";
    }

    @ResponseBody
    @RequestMapping(value={"exportBatchContractInformTemplate"})
    public void exportBatchContractInformTemplate(HttpServletResponse response, ModelMap m, String tempIds, ContractInformTemplate search) throws Exception {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Object fileName = "\u5408\u540c\u544a\u77e5\u6a21\u677f";
        fileName = (String)fileName + dateFormat.format(new Date());
        fileName = (String)fileName + ".zip";
        response.setContentType("application/x-download");
        response.setHeader("Content-disposition", "attachment; filename=" + new String(((String)fileName).getBytes("gbk"), "iso8859-1"));
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long loginStaffId = UserUtils.getLoginStaffId();
        search.setCid(cid);
        List datas = this.contractInformTemplateService.getcontractInformTemplateListBySearchAndIds(tempIds, search);
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        ArrayList<File> files = new ArrayList<File>();
        for (ContractInformTemplate template : datas) {
            if (template == null || template.getInformWorkId() == null) continue;
            List list = this.contractInformService.getOccupationalDiseaseContraindicationListFromBaseData(template.getId(), template.getInformWorkId(), cid, loginStaffId);
            String workName = WorkRoleInfoUtil.getWorkNameIncludeOrgName(template.getInformWorkId());
            dataMap.put("workName", workName);
            dataMap.put("diseaseContraindicationList", list);
            DocUtil docUtil = new DocUtil();
            File file = docUtil.createDocFile(dataMap, "ciinfo.ftl", "/templates/contractinfo/", workName.split("/")[0] + "_" + workName.split("/")[1] + dateFormat.format(new Date()));
            files.add(file);
        }
        ZipCompressorUtil.getDownZipFile(files, (String)"", (OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"exportPhysicalExaminationResultInform"})
    public void exportPhysicalExaminationResultInform(PhcPhysicalCheckParam param, HttpServletResponse response) throws Exception {
        String[] colums = new String[]{"\u5e8f\u53f7|checkId", "\u7f16\u53f7|checkNo", "\u540d\u79f0|checkName", "\u4f53\u68c0\u65f6\u95f4|checkDate", "\u804c\u4e1a\u5065\u5eb7\u76d1\u62a4\u79cd\u7c7b|checkTypeName"};
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String fileName = "\u4f53\u68c0\u7ed3\u679c\u544a\u77e5\u5df2\u5b8c\u6210\u6e05\u5355" + dateFormat.format(new Date()) + ".xls";
        response.setHeader("Content-Disposition", "attachment;filename=" + new String(fileName.getBytes("GBK"), "ISO8859_1"));
        response.setContentType("application/octet-stream; charset=GBK");
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        UserUtils.startWebDataScope();
        List list = this.resultService.getConfirmedCheckList(param);
        for (int i = 1; i <= list.size(); ++i) {
            ((PhcPhysicalCheckConfiredInfo)list.get(i - 1)).setCheckId(Long.valueOf(i));
        }
        ExportExcel excelList = new ExportExcel();
        excelList.simpleExport2(fileName, colums, list, (OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"exportPhysicalExaminationDiagnosisResultInform"})
    public void exportPhysicalExaminationDiagnosisResultInform(PhcDiseaserUnProcessParam query, HttpServletResponse response) throws Exception {
        Long cid = UserUtils.getLoginStaffCompanyId();
        String[] colums = new String[]{"\u5e8f\u53f7|diseaserId", "\u59d3\u540d|staffName", "\u5de5\u53f7|staffWorkNo", "\u90e8\u95e8/\u8f66\u95f4|staffDeptName", "\u5c97\u4f4d/\u5de5\u79cd|staffWorkName", "\u7591\u4f3c\u804c\u4e1a\u75c5\u540d\u79f0|diseaseName", "\u8bca\u65ad\u65f6\u95f4|diagnosedTime"};
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String fileName = "\u804c\u4e1a\u75c5\u8bca\u65ad\u7ed3\u679c\u544a\u77e5\u5df2\u5b8c\u6210\u6e05\u5355" + dateFormat.format(new Date()) + ".xls";
        response.setHeader("Content-Disposition", "attachment;filename=" + new String(fileName.getBytes("GBK"), "ISO8859_1"));
        response.setContentType("application/octet-stream; charset=GBK");
        query.setCid(cid);
        List list = this.phcPhysicalCheckCountService.getConfirmedListByQuery(query);
        for (int i = 1; i <= list.size(); ++i) {
            ((PhcDiseaserConfirmedDetail)list.get(i - 1)).setDiseaserId(Long.valueOf(i));
        }
        ExportExcel excelList = new ExportExcel();
        excelList.simpleExport2(fileName, colums, list, (OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"exportgetHcCheckPlanResultInform"})
    public void exportgetHcCheckPlanResultInform(HcCheckPlan hc, HttpServletResponse response) throws Exception {
        Long cid = UserUtils.getLoginStaffCompanyId();
        String[] colums = new String[]{"\u5e8f\u53f7|id", "\u7f16\u53f7|checkWorkNo", "\u540d\u79f0|checkWorkName", "\u68c0\u6d4b\u65f6\u95f4|checkTime", "\u68c0\u6d4b\u7c7b\u578b|checkTypeName"};
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String fileName = "\u68c0\u6d4b\u7ed3\u679c\u544a\u77e5\u5df2\u5b8c\u6210\u6e05\u5355" + dateFormat.format(new Date()) + ".xls";
        response.setHeader("Content-Disposition", "attachment;filename=" + new String(fileName.getBytes("GBK"), "ISO8859_1"));
        response.setContentType("application/octet-stream; charset=GBK");
        hc.setCid(cid);
        hc.setStatus(HcCheckPlanStatusEnum.CHECKED.getCode());
        hc.setIsInformed(Boolean.valueOf(true));
        List list = null;
        if (UserUtils.hasThirdOrganization()) {
            UserUtils.startWebDataScope();
            list = this.hcCheckPlanService.exportgetThirdHcCheckPlanResultInform(hc);
        } else {
            UserUtils.startWebDataScope();
            list = this.hcCheckPlanService.exportgetHcCheckPlanResultInform(hc);
        }
        for (int i = 1; i <= list.size(); ++i) {
            ((HcCheckPlan)list.get(i - 1)).setId(Long.valueOf(i));
        }
        ExportExcel excelList = new ExportExcel();
        excelList.simpleExport2(fileName, colums, list, (OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"getNewViewContractInformingPage"})
    public String getNewViewContractInformingPage(ModelMap m, Long id) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long createBy = UserUtils.getLoginStaffId();
        m.put((Object)"staffCount", (Object)this.staffInfoService.getStaffCountByCid(cid, null));
        m.put((Object)"workHarmCount", (Object)this.harmfactorWorkService.countHarmNumByCid(cid));
        m.put((Object)"workCount", (Object)this.workRoleInfoService.getWorkRoleInfosByCid(cid).size());
        m.put((Object)"cid", (Object)cid);
        m.put((Object)"createBy", (Object)createBy);
        ContractInform contractInform = this.contractInformService.getContractInformById(id);
        if (contractInform != null) {
            if (contractInform.getInformWorkId() != null) {
                List harmFactorList = this.harmfactorWorkService.getHarmfactorListByWork(cid, contractInform.getInformWorkId());
                ContractInformTemplate template = this.contractInformTemplateService.getContractInformTemplateByWorkId(contractInform.getInformWorkId(), cid);
                if (template != null) {
                    contractInform.setInformTempId(template.getId());
                    this.contractInformService.update((Object)contractInform, createBy);
                } else {
                    contractInform.setInformTempId(null);
                }
                HashMap<CallSite, HarmfactorWorkSourceInfoVo> map = new HashMap<CallSite, HarmfactorWorkSourceInfoVo>();
                if (harmFactorList != null && harmFactorList.size() > 0) {
                    for (HarmfactorWorkSourceInfoVo v : harmFactorList) {
                        map.put((CallSite)((Object)("" + v.getHarmId())), v);
                    }
                }
                m.put((Object)"harmFactorList", map.values());
            }
            if (contractInform.getStaffId() != null) {
                m.put((Object)"staffInfo", (Object)this.staffInfoService.getStaffInfoWithStaffBasicWorkById(contractInform.getStaffId()));
            }
        }
        m.put((Object)"contractInform", (Object)contractInform);
        m.put((Object)"page_editable", (Object)false);
        return "/work/informmanager/getNewViewContractInformingPage";
    }

    @ResponseBody
    @RequestMapping(value={"exportCompletedContractInform"})
    public void exportCompletedContractInform(HttpServletResponse response, ContractInform inform) throws Exception {
        Long cid = UserUtils.getLoginStaffCompanyId();
        String[] colums = new String[]{"\u5e8f\u53f7|id", "\u59d3\u540d|realName", "\u5de5\u53f7|workNo", "\u5c97\u4f4d/\u5de5\u79cd|workName", "\u544a\u77e5\u539f\u7531|informReasonStr", "\u544a\u77e5\u65f6\u95f4|informDate"};
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String fileName = "\u5408\u540c\u544a\u77e5\u5df2\u5b8c\u6210\u6e05\u5355" + dateFormat.format(new Date()) + ".xls";
        response.setHeader("Content-Disposition", "attachment;filename=" + new String(fileName.getBytes("GBK"), "ISO8859_1"));
        response.setContentType("application/octet-stream; charset=GBK");
        inform.setCid(cid);
        inform.setInformState(Long.valueOf(1L));
        List list = this.contractInformService.getcontractInformListByParam(inform);
        for (int i = 1; i <= list.size(); ++i) {
            ((ContractInform)list.get(i - 1)).setId(Long.valueOf(i));
        }
        ExportExcel excelList = new ExportExcel();
        excelList.simpleExport2(fileName, colums, list, (OutputStream)response.getOutputStream());
    }

    @ResponseBody
    @RequestMapping(value={"deleteNoInformStaffByIdAndStaffIdAndStatusAndWorkInfoId"})
    public ResponseData<String> deleteNoInformStaffByIdAndStaffIdAndStatusAndWorkInfoId(Long id, Long staffId, Long workInfoId, Byte changWorkStatus) {
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        if (changWorkStatus == 6) {
            this.noInformStaffService.deleteNoInformStaffById(id, loginStaffId, cid);
        }
        if (changWorkStatus == 1) {
            ContractInform ci = new ContractInform();
            ci.setCid(cid);
            ci.setInformWorkId(workInfoId);
            ci.setStaffId(staffId);
            ci.setIsValid(Boolean.valueOf(true));
            ci.setIsIgnore(Boolean.valueOf(true));
            this.contractInformService.add((Object)ci, loginStaffId, cid);
        }
        return new ResponseData();
    }

    @RequestMapping(value={"getNewEditContractInformAdminPage"})
    public String getNewEditContractInformAdminPage(ModelMap m, Long id) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long createBy = UserUtils.getLoginStaffId();
        m.put((Object)"staffCount", (Object)this.staffInfoService.getStaffCountByCid(cid, null));
        m.put((Object)"workHarmCount", (Object)this.harmfactorWorkService.countHarmNumByCid(cid));
        m.put((Object)"workCount", (Object)this.workRoleInfoService.getWorkRoleInfosByCid(cid).size());
        m.put((Object)"cid", (Object)cid);
        m.put((Object)"createBy", (Object)createBy);
        ContractInform contractInform = this.contractInformService.getContractInformById(id);
        if (contractInform != null) {
            if (contractInform.getInformWorkId() != null) {
                ContractInformTemplate template = this.contractInformTemplateService.getContractInformTemplateByWorkId(contractInform.getInformWorkId(), cid);
                if (template != null) {
                    contractInform.setInformTempId(template.getId());
                    this.contractInformService.update((Object)contractInform, createBy);
                } else {
                    contractInform.setInformTempId(null);
                }
                List harmFactorList = this.harmfactorWorkService.getHarmfactorListByWork(cid, contractInform.getInformWorkId());
                HashMap<CallSite, HarmfactorWorkSourceInfoVo> map = new HashMap<CallSite, HarmfactorWorkSourceInfoVo>();
                if (harmFactorList != null && harmFactorList.size() > 0) {
                    for (HarmfactorWorkSourceInfoVo v : harmFactorList) {
                        map.put((CallSite)((Object)("" + v.getHarmId())), v);
                    }
                }
                m.put((Object)"harmFactorList", map.values());
            }
            if (contractInform.getStaffId() != null) {
                m.put((Object)"staffInfo", (Object)this.staffInfoService.getStaffInfoWithStaffBasicWorkById(contractInform.getStaffId()));
            }
        }
        m.put((Object)"contractInform", (Object)contractInform);
        return "/work/informmanager/getNewEditContractInformAdminPage";
    }

    @ResponseBody
    @RequestMapping(value={"editContractInformTemplateSubmit"})
    public ResponseData<String> editContractInformTemplateSubmit(ContractInformTemplate template) {
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        template.setCid(cid);
        this.contractInformTemplateService.update((Object)template, loginStaffId);
        return new ResponseData();
    }
}

