/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.work.hccheckplan;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.services.hfi.api.exception.ParseException;
import cn.smarthse.services.hfi.api.pojo.bo.ImportCheckParamBo;
import cn.smarthse.services.hfi.api.service.ICheckResultImportService;
import cn.smarthse.util.common.excel.ExcelUtils;
import cn.smarthse.util.common.excel.model.ExcelModel;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.SysFileUtil;
import cn.smarthse.web.util.UserUtils;
import jakarta.annotation.PostConstruct;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/work/checkPlan/import"})
public class ProjectHcCheckPlanImportController
extends ControllerSupport {
    @DubboReference
    private ICheckResultImportService checkResultImportService;
    Map<String, Integer> sizesMap = new HashMap<String, Integer>();

    @PostConstruct
    public void init() {
        this.sizesMap.put("\u5316\u5b66\u56e0\u7d20", 7);
        this.sizesMap.put("\u7c89\u5c18", 10);
        this.sizesMap.put("\u566a\u58f0", 9);
        this.sizesMap.put("\u9ad8\u6e29", 5);
        this.sizesMap.put("\u5de5\u9891\u7535\u573a", 4);
        this.sizesMap.put("\u7167\u5ea6", 3);
        this.sizesMap.put("\u63a7\u5236\u98ce\u901f", 3);
        this.sizesMap.put("\u65b0\u98ce\u91cf", 5);
        this.sizesMap.put("\u5fae\u5c0f\u6c14\u5019", 7);
        this.sizesMap.put("\u7d2b\u5916\u8f90\u5c04", 15);
        this.sizesMap.put("\u624b\u4f20\u632f\u52a8", 4);
        this.sizesMap.put("\u8d85\u9ad8\u9891\u8f90\u5c04", 6);
        this.sizesMap.put("\u9ad8\u9891\u7535\u78c1\u573a", 6);
        this.sizesMap.put("\u6fc0\u5149\u8f90\u5c04", 9);
        this.sizesMap.put("\u5fae\u6ce2\u8f90\u5c04", 8);
        this.sizesMap.put("\u751f\u7269\u56e0\u7d20", 6);
        this.sizesMap.put("\u7535\u79bb\u8f90\u5c04-\u5c04\u7ebf\u88c5\u7f6e", 8);
        this.sizesMap.put("\u7535\u79bb\u8f90\u5c04-\u542b\u6e90\u88c5\u7f6e", 10);
    }

    @ResponseBody
    @RequestMapping(value={"/checkResult"})
    public ResponseData<String> importHcCheckResult(Long importFileId, Long hcId, Long standardId, HttpServletRequest request) throws IOException {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long userId = UserUtils.getLoginStaffId();
        SysFileModel file = SysFileUtil.getFileById(importFileId);
        ResponseData data = new ResponseData();
        data.setState(ResponseStateEnum.success);
        if (file == null) {
            data.setState(ResponseStateEnum.fail);
            data.setContent("\u4e0a\u4f20\u6587\u4ef6\u4e0d\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20");
            return data;
        }
        String fileExt = file.getFileExt();
        if (!"xls".equals(fileExt)) {
            data.setState(ResponseStateEnum.fail);
            data.setContent("\u4e0a\u4f20\u6587\u4ef6\u4e0d\u6b63\u786e\uff0c\u8bf7\u4e0a\u4f20xls\u6587\u4ef6");
            return data;
        }
        InputStream is = SysFileUtil.getInputStreamFileUrlByfid(file, request);
        List xlsSheetNames = ExcelUtils.getXlsSheetNames((InputStream)is);
        int[] columnSize = this.getColumnSize(xlsSheetNames);
        is = SysFileUtil.getInputStreamFileUrlByfid(file, request);
        ExcelModel excelModel = ExcelUtils.parseXls((InputStream)is, (int[])columnSize);
        ImportCheckParamBo bo = new ImportCheckParamBo();
        bo.setCheckId(hcId);
        bo.setCid(cid);
        bo.setCreateUserId(userId);
        if (standardId == null) {
            standardId = 2L;
        }
        bo.setStandardId(standardId);
        try {
            if ("true".equalsIgnoreCase(this.isActualize)) {
                this.checkResultImportService.importResultActualize(excelModel, bo, this.isActualize);
            } else {
                this.checkResultImportService.importResult(excelModel, bo);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
            this.logger.error("\u68c0\u67e5\u7ed3\u679c\u5bfc\u5165\u5931\u8d25", (Throwable)e);
            data.setState(ResponseStateEnum.fail);
            data.setContent(e.getMessage());
            data.setResult((Object)e.getMessage());
        }
        return data;
    }

    private int[] getColumnSize(List<String> sheetNames) {
        int[] sizes = new int[sheetNames.size()];
        for (int i = 0; i < sheetNames.size(); ++i) {
            sizes[i] = this.sizesMap.get(sheetNames.get(i));
        }
        return sizes;
    }
}

