/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.work.hccheckplan;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.util.ServletsUtil;
import cn.smarthse.modules.health.entity.work.harmfactor.Vo.HarmfactorWorkAreaSourceVo;
import cn.smarthse.modules.health.service.base.company.ICompanyAreaService;
import cn.smarthse.modules.health.service.work.harmfactor.IHarmfactorAreaSourceService;
import cn.smarthse.modules.health.service.work.hccheckplan.IHcCheckResultCollectDataService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.SysFileUtil;
import cn.smarthse.web.util.UserUtils;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.enums.WriteDirectionEnum;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.excel.write.metadata.fill.FillConfig;
import com.alibaba.excel.write.metadata.fill.FillWrapper;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/work/hccheckplan/HcCheckPlanWorkArea"})
public class HcCheckWorkAreaController
extends ControllerSupport {
    @DubboReference
    private ICompanyAreaService companyAreaService;
    @DubboReference
    private IHcCheckResultCollectDataService hcCheckResultCollectDataService;
    @DubboReference
    private IHarmfactorAreaSourceService harmfactorAreaSourceService;

    @RequestMapping(method={RequestMethod.GET}, value={"getImportWorkAreaHarmPage"})
    public String getImportWorkAreaHarmPage(ModelMap m) {
        return "/work/hccheckplan/getImportWorkAreaHarmPage";
    }

    @RequestMapping(method={RequestMethod.POST}, value={"downWorkAreaImportExcel"})
    public void downWorkAreaImportExcel(HttpServletRequest request, HttpServletResponse response, Long hcId) throws Exception {
        Long cid = UserUtils.getLoginStaffCompanyId();
        List companyAreas = this.companyAreaService.getExportCompanyArea(cid.longValue());
        List hcchInfoPageList = new ArrayList();
        PageInfo hcchInfoPage = this.hcCheckResultCollectDataService.getHcCheckCollectAllCheckPojNamesByPage(new JqGridParam(), cid, hcId);
        if (hcchInfoPage != null && CollectionUtils.isNotEmpty((Collection)hcchInfoPage.getList())) {
            hcchInfoPageList = hcchInfoPage.getList();
        }
        String templateDirPath = super.getTemplateFilePath() + "harmfactor/areaharmrelation.xls";
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String fileName = "\u5de5\u4f5c\u573a\u6240\u5173\u8054\u6570\u636e\u5bfc\u5165\u6a21\u677f" + dateFormat.format(new Date()) + ".xls";
        ServletsUtil.setFileDownloadHeader((HttpServletResponse)response, (String)fileName, (HttpServletRequest)request);
        ServletOutputStream out = response.getOutputStream();
        ExcelWriter excelWriter = EasyExcel.write((OutputStream)out).withTemplate(templateDirPath).build();
        WriteSheet writeSheet = EasyExcel.writerSheet().build();
        FillConfig fillConfigHeader = FillConfig.builder().direction(WriteDirectionEnum.HORIZONTAL).build();
        excelWriter.fill((Object)new FillWrapper("headers", hcchInfoPageList), fillConfigHeader, writeSheet);
        FillConfig fillConfigData = FillConfig.builder().forceNewRow(Boolean.valueOf(true)).build();
        excelWriter.fill((Object)new FillWrapper("datas", (Collection)companyAreas), fillConfigData, writeSheet);
        excelWriter.finish();
    }

    @RequiresPermissions(value={"company.harmfactor.view"})
    @RequestMapping(value={"ImportAreaHarm"})
    @ResponseBody
    public ResponseData<Map<String, HarmfactorWorkAreaSourceVo>> ImportAreaHarm(HttpServletRequest request, Long fileId) {
        ResponseData responseData = new ResponseData();
        if (fileId == null) {
            responseData.setContent("\u6587\u4ef6\u672a\u627e\u5230");
            responseData.setState(ResponseStateEnum.fail);
            return responseData;
        }
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long orgId = UserUtils.getOrgId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        String path = request.getContextPath();
        String basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + path + "/";
        Object ossfile = SysFileUtil.getFileUrlByfid(fileId);
        if (((String)ossfile).startsWith("/file")) {
            ossfile = basePath + (String)ossfile;
        }
        try {
            Map resultMap = this.harmfactorAreaSourceService.importAreaHarmRelation((String)ossfile, loginStaffId, orgId, cid);
            responseData.setResult((Object)resultMap);
        }
        catch (Exception e) {
            responseData.setContent("\u53d1\u751f\u9519\u8bef\uff1a" + e.getMessage());
            responseData.setState(ResponseStateEnum.fail);
        }
        return responseData;
    }
}

