/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.work.hccheckplan;

import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.entity.base.company.CompanyOrganization;
import cn.smarthse.modules.health.service.base.company.ICompanyOrganizationService;
import cn.smarthse.services.hfi.api.pojo.vo.HcCheckPlanCountDailyPageParamVo;
import cn.smarthse.services.hfi.api.pojo.vo.HcCheckPlanCountDailyPageVo;
import cn.smarthse.services.hfi.api.pojo.vo.HcCheckPlanCountVo;
import cn.smarthse.web.controller.work.hccheckplan.CheckPlanBaseController;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/work/checkPlanStatistic"})
public class CheckStatisticController
extends CheckPlanBaseController {
    @DubboReference
    private ICompanyOrganizationService companyOrganizationService;

    @RequestMapping(value={"/statisticPage"})
    public String statisticPage(ModelMap m) {
        this.setCheckCountModel(m);
        this.setIsSuperUser(m);
        Integer year = LocalDate.now().getYear();
        m.addAttribute("year", (Object)year);
        return "/work/checkPlan/statisticPage";
    }

    @ResponseBody
    @RequestMapping(value={"/getHcCheckPlanCompletedDaliyData"})
    public JqGridData<HcCheckPlanCountDailyPageVo> getHcCheckPlanCompletedDaliyData(JqGridParam jparam, HcCheckPlanCountDailyPageParamVo paramVo) {
        List checkOrgIds;
        Long cid = UserUtils.getLoginStaffCompanyId();
        paramVo.setCid(cid);
        if (StringUtils.isNotEmpty((String)paramVo.getOrgIds()) && !(checkOrgIds = StringUtils.parseToLongList((String)paramVo.getOrgIds(), (String)",")).isEmpty()) {
            paramVo.setCheckOrgId(checkOrgIds);
        }
        PageInfo pageInfo = this.checkPlanService.getHcCheckPlanCountDailyPage(jparam, paramVo);
        this.setDeptName(pageInfo.getList());
        return new JqGridData(pageInfo, jparam);
    }

    @ResponseBody
    @RequestMapping(value={"/getHcCheckPlanCheckRate"})
    public HcCheckPlanCountVo getHcCheckPlanCheckRate(Integer year, Long checkType) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        return this.checkPlanService.getHcCheckPlanCompletedCountByYearAndType(year, cid, checkType);
    }

    private void setDeptName(List<HcCheckPlanCountDailyPageVo> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (HcCheckPlanCountDailyPageVo vo : list) {
            sb.append(vo.getCheckOrgId() + ",");
        }
        HashMap<Long, CompanyOrganization> map = new HashMap<Long, CompanyOrganization>();
        List listByIds = this.companyOrganizationService.getListByIds(sb.substring(0, sb.length() - 1));
        for (CompanyOrganization org : listByIds) {
            map.put(org.getId(), org);
        }
        for (HcCheckPlanCountDailyPageVo vo : list) {
            CompanyOrganization companyOrganization = (CompanyOrganization)map.get(vo.getCheckOrgId());
            if (companyOrganization == null) continue;
            vo.setCheckOrgName(companyOrganization.getOrganizationName());
        }
    }
}

