/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.work.hccheckplan;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.excel.ExportExcel;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.modules.health.entity.base.company.CompanyOrganization;
import cn.smarthse.modules.health.service.base.company.ICompanyOrganizationService;
import cn.smarthse.services.hfi.api.entity.CheckPlan;
import cn.smarthse.services.hfi.api.model.ComCheckQueryModel;
import cn.smarthse.services.hfi.api.pojo.vo.ComCheckPlanListVo;
import cn.smarthse.web.controller.work.hccheckplan.CheckPlanBaseController;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.time.LocalDateTime;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/work/checkPlanReport"})
public class CheckPlanReportController
extends CheckPlanBaseController {
    @DubboReference
    private ICompanyOrganizationService companyOrganizationService;

    @RequestMapping(value={"/reportingPage"}, method={RequestMethod.GET})
    public String getHcCheckResultReportingPage(ModelMap m) {
        this.setIsSuperUser(m);
        return "/work/checkPlan/reportingPage";
    }

    @RequestMapping(value={"/reportCompletePage"}, method={RequestMethod.GET})
    public String reportCompletePage(ModelMap m) {
        this.setIsSuperUser(m);
        this.setCheckCountModel(m);
        return "/work/checkPlan/reportCompletePage";
    }

    private void setComCheckQueryModel(ComCheckQueryModel queryModel, String reportDateRange) {
        queryModel.setEditStatus(Integer.valueOf(2));
        queryModel.setCid(UserUtils.getLoginStaffCompanyId());
        if (reportDateRange != null && reportDateRange.length() > 6 && reportDateRange.contains("\u81f3")) {
            String[] split = reportDateRange.trim().split("\u81f3");
            queryModel.setReportStartDate(DateUtil.parseDateTime((String)(split[0] + " 00:00:00"), (String)"yyyy-MM-dd HH:mm:ss"));
            queryModel.setReportEndDate(DateUtil.parseDateTime((String)(split[1] + " 00:00:00"), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        this.setCheckPlanQueryModel(queryModel);
    }

    @RequestMapping(value={"/checkPlanUnReportList.json"})
    @ResponseBody
    public JqGridData<ComCheckPlanListVo> checkPlanCompleteList(JqGridParam param, ComCheckQueryModel queryModel, String reportDateRange) {
        this.setComCheckQueryModel(queryModel, reportDateRange);
        queryModel.setReportStatus(Integer.valueOf(1));
        PageInfo pageInfo = this.checkPlanService.comQueryList(queryModel, param);
        return new JqGridData(pageInfo, param);
    }

    @RequestMapping(value={"/reportCompleteList.json"})
    @ResponseBody
    public JqGridData<ComCheckPlanListVo> reportCompleteList(JqGridParam param, ComCheckQueryModel queryModel, String reportDateRange) {
        this.setComCheckQueryModel(queryModel, reportDateRange);
        queryModel.setReportStatus(Integer.valueOf(2));
        PageInfo pageInfo = this.checkPlanService.comQueryList(queryModel, param);
        return new JqGridData(pageInfo, param);
    }

    @RequestMapping(value={"/exportReportCompleteList"})
    public void exportReportCompleteList(ComCheckQueryModel queryModel, String reportDateRange, HttpServletResponse response) throws IOException {
        JqGridParam param = new JqGridParam();
        param.setPage(1);
        param.setRows(Integer.MAX_VALUE);
        this.setComCheckQueryModel(queryModel, reportDateRange);
        queryModel.setReportStatus(Integer.valueOf(2));
        PageInfo pageInfo = this.checkPlanService.comQueryList(queryModel, param);
        String[] colums = new String[]{"\u68c0\u6d4b\u5de5\u4f5c\u540d\u79f0|checkWorkName", "\u68c0\u6d4b\u65f6\u95f4|checkDateStr", "\u7f16\u5236\u4eba|registerName", "\u68c0\u6d4b\u7c7b\u578b|checkTypeStr", "\u4e0a\u62a5\u65f6\u95f4|reportDateStr", "\u66f4\u65b0\u65f6\u95f4|updateDateStr"};
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-Disposition", "attachment;filename=" + new String("\u68c0\u6d4b\u5df2\u4e0a\u62a5\u6e05\u5355.xls".getBytes("GBK"), "ISO8859_1"));
        response.setContentType("application/octet-stream; charset=GBK");
        ExportExcel listexcel = new ExportExcel();
        listexcel.simpleExport3("\u68c0\u6d4b\u5df2\u4e0a\u62a5\u6e05\u5355", colums, pageInfo.getList(), (OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/removeCheckReport"})
    @ResponseBody
    public ResponseData<Object> removeCheckReport(Long id) {
        this.checkPlanService.removeCheckReport(id);
        return new ResponseData();
    }

    @RequestMapping(value={"/editReportPage"}, method={RequestMethod.GET})
    public String editReportPage(ModelMap m, Long checkId, Boolean isEdit) {
        CheckPlan hc = null;
        if (checkId != null) {
            Long thirdOrgId;
            CompanyOrganization dept;
            hc = (CheckPlan)this.checkPlanService.getById((Serializable)checkId);
            m.addAttribute("hc", (Object)hc);
            Long deptId = hc.getDeptId();
            if (deptId != null && (dept = (CompanyOrganization)this.companyOrganizationService.getById(deptId)) != null) {
                m.put((Object)"deptName", (Object)dept.getOrganizationName());
            }
            if ((thirdOrgId = hc.getThirdOrgId()) != null) {
                // empty if block
            }
        }
        if (isEdit == null) {
            isEdit = this.canEdit(hc);
        }
        m.addAttribute("isEdit", (Object)isEdit);
        return "/work/checkPlan/editReportPage";
    }

    private Boolean canEdit(CheckPlan hc) {
        if (hc == null) {
            return true;
        }
        if (hc.getReportStatus().equals(1)) {
            return true;
        }
        if (hc.getReportStatus().equals(2)) {
            return this.isSuperUser();
        }
        return true;
    }

    @RequestMapping(value={"/updateReport"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<Object> updateReport(ModelMap m, CheckPlan checkPlan, String reportDateStr) {
        ResponseData data = new ResponseData();
        Long id = checkPlan.getId();
        if (id == null) {
            data.setState(ResponseStateEnum.fail);
            data.setContent("id\u4e0d\u80fd\u4e3a\u7a7a");
            return data;
        }
        CheckPlan old = (CheckPlan)this.checkPlanService.getById((Serializable)id);
        old.setUpdateDate(LocalDateTime.now());
        old.setUpdateBy(UserUtils.getLoginStaffId());
        old.setRegisterName(UserUtils.getLoginStaffName());
        if (reportDateStr != null && !reportDateStr.isEmpty()) {
            old.setReportDate(DateUtil.parseDateTime((String)(reportDateStr + " 00:00:00"), (String)"yyyy-MM-dd HH:mm:ss"));
        } else {
            old.setReportDate(null);
        }
        if (checkPlan.getCheckReportNameFileIdArr() != null && checkPlan.getCheckReportNameFileIdArr().length > 0) {
            old.setCheckReportFileIds(StringUtils.join((Object[])checkPlan.getCheckReportNameFileIdArr(), (String)","));
        }
        old.setCheckReportLocation(checkPlan.getCheckReportLocation());
        old.setReportStatus(checkPlan.getReportStatus());
        this.checkPlanService.updateById((Object)old);
        return new ResponseData();
    }
}

