/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.work.hccheckplan;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.util.ServletsUtil;
import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.modules.health.entity.base.workinfo.WorkRoleInfo;
import cn.smarthse.modules.health.entity.work.harmfactor.Vo.HarmfactorWorkAreaSourceVo;
import cn.smarthse.modules.health.service.base.company.ICompanyAreaService;
import cn.smarthse.modules.health.service.base.workinfo.IWorkRoleInfoService;
import cn.smarthse.modules.health.service.work.harmfactor.IHarmfactorAreaSourceService;
import cn.smarthse.modules.health.service.work.harmfactor.IHarmfactorWorkSourceService;
import cn.smarthse.services.hfi.api.entity.CheckPlan;
import cn.smarthse.services.hfi.api.model.ComCheckQueryModel;
import cn.smarthse.services.hfi.api.pojo.vo.ComCheckPlanListVo;
import cn.smarthse.web.controller.work.hccheckplan.CheckPlanBaseController;
import cn.smarthse.web.util.SysFileUtil;
import cn.smarthse.web.util.UserUtils;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.enums.WriteDirectionEnum;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.excel.write.metadata.fill.FillConfig;
import com.alibaba.excel.write.metadata.fill.FillWrapper;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/work/checkPlanRelevance"})
public class CheckPlanRelevanceController
extends CheckPlanBaseController {
    @DubboReference
    private ICompanyAreaService companyAreaService;
    @DubboReference
    private IHarmfactorAreaSourceService harmfactorAreaSourceService;
    @DubboReference
    private IHarmfactorWorkSourceService harmfactorWorkSourceService;
    @DubboReference
    IWorkRoleInfoService workRoleInfoService;

    @RequestMapping(value={"/completeListPage"})
    public String completeListPage(ModelMap m) {
        this.setCheckCountModel(m);
        this.setIsSuperUser(m);
        return "/work/checkPlan/relevanceCompleteListPage";
    }

    @RequestMapping(value={"/unCompleteListPage"})
    public String unCompleteListPage(ModelMap m) {
        this.setCheckCountModel(m);
        this.setIsSuperUser(m);
        return "/work/checkPlan/relevanceUnCompleteListPage";
    }

    @RequestMapping(value={"/relevanceCheckPlanList.json"})
    @ResponseBody
    public JqGridData<ComCheckPlanListVo> checkPlanCompleteList(JqGridParam param, ComCheckQueryModel queryModel, String checkDateRange) {
        this.setComCheckQueryModel(queryModel, checkDateRange);
        PageInfo pageInfo = this.checkPlanService.comQueryList(queryModel, param);
        return new JqGridData(pageInfo, param);
    }

    @RequestMapping(value={"/remove"})
    @ResponseBody
    public ResponseData<Object> remove(Long id) {
        Long loginStaffId = UserUtils.getLoginStaffId();
        this.harmfactorAreaSourceService.delHarmfactorAreaSourceByCheckPlanId(id, loginStaffId);
        this.harmfactorWorkSourceService.delHarmfactorWorkSourceByCheckPlanId(id, loginStaffId);
        this.checkPlanService.updateRelevanceStatus(id, Integer.valueOf(0));
        return new ResponseData();
    }

    @RequestMapping(value={"/add"})
    @ResponseBody
    public ResponseData<Object> add(Long id) {
        this.checkPlanService.updateRelevanceStatus(id, Integer.valueOf(1));
        return new ResponseData();
    }

    private void setComCheckQueryModel(ComCheckQueryModel queryModel, String checkDateRange) {
        if (checkDateRange != null && checkDateRange.length() > 6 && checkDateRange.contains("\u81f3")) {
            String[] split = checkDateRange.trim().split("\u81f3");
            queryModel.setCheckStartDate(DateUtil.parseDateTime((String)(split[0] + " 00:00:00"), (String)"yyyy-MM-dd HH:mm:ss"));
            queryModel.setCheckEndDate(DateUtil.parseDateTime((String)(split[1] + " 00:00:00"), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        queryModel.setCid(UserUtils.getLoginStaffCompanyId());
        this.setCheckPlanQueryModel(queryModel);
    }

    @RequestMapping(value={"/editRelevancePage"}, method={RequestMethod.GET})
    public String editRelevancePage(ModelMap m, Long hcId, Boolean isEdit) {
        this.setIsSuperUser(m);
        CheckPlan checkPlan = (CheckPlan)this.checkPlanService.getById((Serializable)hcId);
        m.put((Object)"hc", (Object)checkPlan);
        if (this.canEdit(checkPlan).booleanValue() && isEdit != null && isEdit.booleanValue()) {
            m.addAttribute("isAdmin", (Object)true);
        }
        if (isEdit == null || isEdit.booleanValue()) {
            isEdit = this.canEdit(checkPlan);
        }
        m.put((Object)"isEdit", (Object)isEdit);
        return "/work/checkPlan/editRelevancePage";
    }

    private Boolean canEdit(CheckPlan checkPlan) {
        if (checkPlan.getRelevanceStatus().equals(1)) {
            return true;
        }
        if (checkPlan.getRelevanceStatus().equals(2)) {
            return this.isSuperUser();
        }
        return false;
    }

    @RequestMapping(value={"downWorkAreaImportExcel"})
    public void downWorkAreaImportExcel(HttpServletRequest request, HttpServletResponse response, Long hcId) throws Exception {
        Long cid = UserUtils.getLoginStaffCompanyId();
        List companyAreas = this.companyAreaService.getExportCompanyArea(cid.longValue());
        List hcchInfoPageList = new ArrayList();
        JqGridParam jqGridParam = new JqGridParam();
        jqGridParam.setPage(1);
        jqGridParam.setRows(Integer.MAX_VALUE);
        PageInfo hcchInfoPage = this.checkResultService.querySelectPointVosGroupByCheckPoint(jqGridParam, hcId, null);
        if (hcchInfoPage != null && CollectionUtils.isNotEmpty((Collection)hcchInfoPage.getList())) {
            hcchInfoPageList = hcchInfoPage.getList();
        }
        String templateDirPath = super.getTemplateFilePath() + "harmfactor/areaharmrelation.xls";
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String fileName = "\u5de5\u4f5c\u573a\u6240\u5173\u8054\u6570\u636e\u5bfc\u5165\u6a21\u677f" + dateFormat.format(new Date()) + ".xls";
        ServletsUtil.setFileDownloadHeader((HttpServletResponse)response, (String)fileName, (HttpServletRequest)request);
        ServletOutputStream out = response.getOutputStream();
        ExcelWriter excelWriter = EasyExcel.write((OutputStream)out).withTemplate(templateDirPath).build();
        WriteSheet writeSheet = EasyExcel.writerSheet().build();
        FillConfig fillConfigHeader = FillConfig.builder().direction(WriteDirectionEnum.HORIZONTAL).build();
        excelWriter.fill((Object)new FillWrapper("headers", hcchInfoPageList), fillConfigHeader, writeSheet);
        FillConfig fillConfigData = FillConfig.builder().forceNewRow(Boolean.valueOf(true)).build();
        excelWriter.fill((Object)new FillWrapper("datas", (Collection)companyAreas), fillConfigData, writeSheet);
        excelWriter.finish();
    }

    @RequestMapping(value={"downWorkImportExcel"})
    public void downWorkImportExcel(HttpServletRequest request, HttpServletResponse response, Long hcId) throws Exception {
        Long cid = UserUtils.getLoginStaffCompanyId();
        List workRoleInfoList = this.workRoleInfoService.getWorkRoleOrgNameByCid(cid);
        List hcchInfoPageList = new ArrayList();
        JqGridParam jqGridParam = new JqGridParam();
        jqGridParam.setPage(1);
        jqGridParam.setRows(Integer.MAX_VALUE);
        PageInfo hcchInfoPage = this.checkResultService.querySelectPointVosGroupByCheckPoint(jqGridParam, hcId, null);
        if (hcchInfoPage != null && CollectionUtils.isNotEmpty((Collection)hcchInfoPage.getList())) {
            hcchInfoPageList = hcchInfoPage.getList();
        }
        String templateDirPath = super.getTemplateFilePath() + "harmfactor/workharmrelation.xls";
        if (CollectionUtils.isNotEmpty((Collection)workRoleInfoList)) {
            for (WorkRoleInfo workRoleInfo : workRoleInfoList) {
                workRoleInfo.setIdStr(workRoleInfo.getId().toString());
            }
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String fileName = "\u5c97\u4f4d\u5de5\u79cd\u5173\u8054\u6570\u636e\u5bfc\u5165\u6a21\u677f" + dateFormat.format(new Date()) + ".xls";
        ServletsUtil.setFileDownloadHeader((HttpServletResponse)response, (String)fileName, (HttpServletRequest)request);
        ServletOutputStream out = response.getOutputStream();
        ExcelWriter excelWriter = EasyExcel.write((OutputStream)out).withTemplate(templateDirPath).build();
        WriteSheet writeSheet = EasyExcel.writerSheet().build();
        FillConfig fillConfigHeader = FillConfig.builder().direction(WriteDirectionEnum.HORIZONTAL).build();
        excelWriter.fill((Object)new FillWrapper("hcchInfoPageList", hcchInfoPageList), fillConfigHeader, writeSheet);
        FillConfig fillConfigData = FillConfig.builder().forceNewRow(Boolean.valueOf(true)).build();
        excelWriter.fill((Object)new FillWrapper("workRoleInfoList", (Collection)workRoleInfoList), fillConfigData, writeSheet);
        excelWriter.finish();
    }

    @RequiresPermissions(value={"company.harmfactor.view"})
    @RequestMapping(value={"ImportAreaHarm"})
    @ResponseBody
    public ResponseData<Map<String, HarmfactorWorkAreaSourceVo>> ImportAreaHarm(HttpServletRequest request, Long fileId) {
        ResponseData responseData = new ResponseData();
        if (fileId == null) {
            responseData.setContent("\u6587\u4ef6\u672a\u627e\u5230");
            responseData.setState(ResponseStateEnum.fail);
            return responseData;
        }
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long orgId = UserUtils.getOrgId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        String path = request.getContextPath();
        String basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + path + "/";
        Object ossfile = SysFileUtil.getFileUrlByfid(fileId);
        if (((String)ossfile).startsWith("/file")) {
            ossfile = basePath + (String)ossfile;
        }
        try {
            Map resultMap = this.harmfactorAreaSourceService.importAreaHarmRelation((String)ossfile, loginStaffId, orgId, cid);
            responseData.setResult((Object)resultMap);
        }
        catch (Exception e) {
            responseData.setContent("\u53d1\u751f\u9519\u8bef\uff1a" + e.getMessage());
            responseData.setState(ResponseStateEnum.fail);
        }
        return responseData;
    }
}

