/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.work.hccheckplan;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.config.Global;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.BusinessNoTypeEnum;
import cn.smarthse.common.framework.excel.ExportExcel;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.common.util.excel.ExcelUtil;
import cn.smarthse.modules.health.entity.base.company.CompanyOrganization;
import cn.smarthse.modules.health.entity.sys.SysHintMsg;
import cn.smarthse.modules.health.enums.hccheckplan.ResultCollectTypeNewEnum;
import cn.smarthse.modules.health.enums.sys.coreWork.CoreWorkEnum;
import cn.smarthse.modules.health.service.base.IBusinessNoService;
import cn.smarthse.modules.health.service.base.company.ICompanyOrganizationService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.base.staff.IStaffWorkRoleService;
import cn.smarthse.modules.health.service.sys.ISysCoreWorkModuleCorrelationService;
import cn.smarthse.modules.health.service.sys.ISysHintMsgService;
import cn.smarthse.services.hfi.api.entity.CheckPlan;
import cn.smarthse.services.hfi.api.entity.CheckSelectItem;
import cn.smarthse.services.hfi.api.model.ComCheckQueryModel;
import cn.smarthse.services.hfi.api.model.result.CheckResultFormModel;
import cn.smarthse.services.hfi.api.pojo.vo.ComCheckPlanListVo;
import cn.smarthse.services.hfi.api.service.ICheckHistoryDataService;
import cn.smarthse.services.hfi.api.service.ICheckResultService;
import cn.smarthse.services.hfi.api.service.ICheckSelectItemService;
import cn.smarthse.services.hfi.api.service.IHaveAddReformCheckPointService;
import cn.smarthse.web.controller.work.hccheckplan.CheckPlanBaseController;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/work/checkPlan"})
public class CheckPlanController
extends CheckPlanBaseController {
    @DubboReference
    private IStaffInfoService staffInfoService;
    @DubboReference
    private IBusinessNoService businessNoService;
    @DubboReference
    private ISysCoreWorkModuleCorrelationService sysCoreWorkModuleCorrelationService;
    @DubboReference
    private ICompanyOrganizationService companyOrganizationService;
    @DubboReference
    private ICheckHistoryDataService checkHistoryDataService;
    @DubboReference
    private ICheckSelectItemService checkSelectItemService;
    @DubboReference
    private ICheckResultService checkResultService;
    @DubboReference
    private IStaffWorkRoleService workRoleService;
    @DubboReference
    private IHaveAddReformCheckPointService haveAddReformCheckPointService;
    @Autowired
    private ThreadPoolExecutor threadPoolExecutor;
    @DubboReference
    private ISysHintMsgService sysHintMsgService;

    @RequiresPermissions(value={"hccheckplan.edit"})
    @RequestMapping(method={RequestMethod.GET}, value={"editCheckPlan"})
    public String getAddHcCheckPlanPage(ModelMap m, Long checkId, Boolean edit, Long checkType, String reformIds) {
        Long thirdOrgId;
        CompanyOrganization dept;
        Long deptId;
        Long evaluateId;
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long loginStaffId = UserUtils.getLoginStaffId();
        List<String> roleList = UserUtils.getRoleList(UserUtils.getCurrentUser());
        CheckPlan hc = null;
        if (checkId != null) {
            hc = (CheckPlan)this.checkPlanService.getById((Serializable)checkId);
        }
        if (hc == null) {
            List orgs;
            hc = this.checkPlanService.getNotValidHcCheckThirdOrgPlan(cid, loginStaffId, Integer.valueOf(1), Integer.valueOf(1));
            String businessNo = this.businessNoService.getBusinessNo(cid, BusinessNoTypeEnum.HCCHECKPLAN.getCode());
            hc.setCheckWorkNo(businessNo);
            hc.setOrgIds("");
            hc.setCheckType(checkType);
            if (checkType != null && checkType.equals(5L)) {
                if (reformIds == null || reformIds.isEmpty()) {
                    throw new RuntimeException("\u6574\u6539\u7684\u68c0\u6d4b\uff0c\u9009\u62e9\u7684\u9690\u60a3\u4e0d\u80fd\u4e3a\u7a7a");
                }
                List checkIds = this.haveAddReformCheckPointService.getCheckIdsByBatchNo(CheckPlanController.parseStrIds(reformIds));
                hc.setLastCheckIds(CheckPlanController.formatListIds(checkIds));
                hc.setReformIds(reformIds);
            }
            if ((orgs = this.workRoleService.getStaffOrgByStaffId(loginStaffId)).size() == 1 && orgs.get(0) != null) {
                hc.setOrgIds("" + ((CompanyOrganization)orgs.get(0)).getId());
            } else if (orgs.size() > 1) {
                m.addAttribute("isShowStaffOrgs", (Object)true);
            }
        }
        if (hc.getLastCheckIds() != null && !hc.getLastCheckIds().isEmpty()) {
            List lastCheckPlans = this.checkPlanService.getByIds(CheckPlanController.parseStrIds(hc.getLastCheckIds()));
            m.put((Object)"lastCheckPlans", (Object)lastCheckPlans);
        }
        if ((evaluateId = hc.getEvaluateId()) != null) {
            // empty if block
        }
        if ((deptId = hc.getDeptId()) != null && (dept = (CompanyOrganization)this.companyOrganizationService.getById(deptId)) != null) {
            m.put((Object)"deptName", (Object)dept.getOrganizationName());
        }
        if ((thirdOrgId = hc.getThirdOrgId()) != null) {
            // empty if block
        }
        if (edit == null) {
            edit = this.canEdit(hc, roleList);
        }
        m.put((Object)"canEdit", (Object)edit);
        m.put((Object)"hc", (Object)hc);
        SysHintMsg msg = this.sysHintMsgService.getByUserAndTag(loginStaffId, Integer.valueOf(1));
        m.put((Object)"isShowMsg1", (Object)(msg != null ? 1 : 0));
        if (msg == null) {
            this.sysHintMsgService.addRecord(loginStaffId, Integer.valueOf(1));
        }
        return "/work/checkPlan/editCheckPlanPage";
    }

    private Boolean canEdit(CheckPlan checkPlan, List<String> roles) {
        if (checkPlan == null || checkPlan.getEditStatus() == null || checkPlan.getEditStatus().equals(1)) {
            return true;
        }
        if (checkPlan.getEditStatus().equals(2) && roles.contains("\u8d85\u7ea7\u7ba1\u7406\u5458")) {
            return true;
        }
        return false;
    }

    @Log(title="\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u68c0\u6d4b\u5de5\u4f5c-\u6dfb\u52a0", type=20)
    @ResponseBody
    @RequestMapping(method={RequestMethod.POST}, value={"updateHcCheckThirdOrgPlanSumbit"})
    public ResponseData<CheckPlan> updateHcCheckThirdOrgPlanSumbit(CheckPlan hc, String checkDateRange, String createDateStr, String giveReportDateStr) {
        String datePattern = "yyyy-MM-dd HH:mm:ss";
        LocalDateTime crateDate = DateUtil.parseDateTime((String)(createDateStr + " 00:00:00"), (String)datePattern);
        hc.setCreateDate(crateDate);
        if (giveReportDateStr != null && !giveReportDateStr.isEmpty()) {
            LocalDateTime giveReportDate = DateUtil.parseDateTime((String)(giveReportDateStr + " 00:00:00"), (String)datePattern);
            hc.setGiveReportDate(giveReportDate);
        } else {
            hc.setGiveReportDate(null);
        }
        if (checkDateRange != null && checkDateRange.length() > 5) {
            String[] ranges = checkDateRange.split("\u81f3");
            hc.setCheckDateBegin(DateUtil.parseDateTime((String)(ranges[0].trim() + " 00:00:00"), (String)datePattern));
            hc.setCheckDateEnd(DateUtil.parseDateTime((String)(ranges[1].trim() + " 00:00:00"), (String)datePattern));
        } else {
            hc.setCheckDateBegin(null);
            hc.setCheckDateEnd(null);
        }
        Long userId = UserUtils.getLoginStaffId();
        hc.setUpdateBy(userId);
        LocalDateTime now = LocalDateTime.now();
        hc.setUpdateDate(DateUtil.getLocalDateTime((int)now.getYear(), (int)now.getMonthValue(), (int)now.getDayOfMonth(), (int)0, (int)0, (int)0));
        if (hc.getCheckPointMapFileIdsArr() != null && hc.getCheckPointMapFileIdsArr().length > 0) {
            hc.setCheckPointMapFileIds(StringUtils.join((Object[])hc.getCheckPointMapFileIdsArr(), (String)","));
        }
        if (hc.getEvaluateOrCheckFileFileIdArr() != null && hc.getEvaluateOrCheckFileFileIdArr().length > 0) {
            hc.setContractFileIds(StringUtils.join((Object[])hc.getEvaluateOrCheckFileFileIdArr(), (String)","));
        }
        if (hc.getCheckReportNameFileIdArr() != null && hc.getCheckReportNameFileIdArr().length > 0) {
            hc.setCheckReportFileIds(StringUtils.join((Object[])hc.getCheckReportNameFileIdArr(), (String)","));
        }
        if (hc.getCheckResultCertificateFileIdsArr() != null && hc.getCheckResultCertificateFileIdsArr().length > 0) {
            hc.setCheckResultCertificateFileIds(StringUtils.join((Object[])hc.getCheckResultCertificateFileIdsArr(), (String)","));
        }
        if (hc.getCheckEvaluationReportFileIdsArr() != null && hc.getCheckEvaluationReportFileIdsArr().length > 0) {
            hc.setCheckEvaluationReportFileIds(StringUtils.join((Object[])hc.getCheckEvaluationReportFileIdsArr(), (String)","));
        }
        hc.setIsValid(Boolean.valueOf(true));
        hc.setProjectName(hc.getCheckWorkName());
        this.checkPlanService.saveOrUpdate((Object)hc);
        this.logger.info("\u4fdd\u5b58\u68c0\u6d4b\u6210\u529f");
        this.checkHistoryDataService.saveSnapshoot(hc.getId());
        if (hc.getEditStatus().equals(2) && hc.getCheckType().equals(5L)) {
            this.updateReformStatus(hc.getReformIds());
        }
        if (hc.getEditStatus().equals(2)) {
            this.checkPlanCompleteLogic(hc);
        }
        ResponseData responseData = new ResponseData();
        responseData.setResult((Object)hc);
        return responseData;
    }

    private void checkPlanCompleteLogic(CheckPlan hc) {
        Long userId = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        this.sysCoreWorkModuleCorrelationService.addHarmFactorManagerTodolistInfo(CoreWorkEnum.harmfactorTest, hc.getId(), hc.getCheckWorkName(), userId, cid);
        this.sysCoreWorkModuleCorrelationService.appearHcCheckThirdPlan(CoreWorkEnum.harmfactorTest, hc.getId(), hc.getCheckWorkName(), userId, cid);
    }

    private void updateReformStatus(String reformIds) {
        List<Long> list = CheckPlanController.parseStrIds(reformIds);
        Long currentUserId = UserUtils.getCurrentUserId();
        this.threadPoolExecutor.execute(() -> {
            for (Long reformId : list) {
                this.reformItemBasicService.reformItemRetest(reformId, currentUserId);
            }
        });
    }

    @RequestMapping(value={"/checkPlanCompleteListPage"})
    public String getHcCheckPlanResultStatPage(ModelMap m, String tabPage, Long checkType, Integer year, Boolean rectifyStatus) {
        this.setCheckCountModel(m);
        this.setIsSuperUser(m);
        m.addAttribute("checkType", (Object)checkType);
        m.addAttribute("year", (Object)year);
        return "/work/checkPlan/checkPlanCompleteListPage";
    }

    @RequestMapping(value={"/checkPlanCompleteList.json"})
    @ResponseBody
    public JqGridData<ComCheckPlanListVo> checkPlanCompleteList(JqGridParam param, ComCheckQueryModel queryModel, String checkDateRange, Integer year, Long checkType) {
        this.setComCheckQueryModel(queryModel, checkDateRange, null, null);
        if (year != null) {
            queryModel.setCheckStartDate(DateUtil.getLocalDateTime((int)year, (int)1, (int)1, (int)0, (int)0, (int)0));
            queryModel.setCheckEndDate(DateUtil.getLocalDateTime((int)(year + 1), (int)1, (int)1, (int)0, (int)0, (int)0));
        }
        if (checkType != null) {
            queryModel.setCheckTypes(Arrays.asList(checkType));
        }
        PageInfo pageInfo = this.checkPlanService.comQueryList(queryModel, param);
        return new JqGridData(pageInfo, param);
    }

    @RequestMapping(value={"/checkingListPage"})
    public String checkingListPage(ModelMap m, Long checkType, Long checkYear) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long loginStaffId = UserUtils.getLoginStaffId();
        m.put((Object)"cid", (Object)cid);
        m.put((Object)"loginStaffId", (Object)loginStaffId);
        m.put((Object)"checkType", (Object)checkType);
        m.put((Object)"checkYear", (Object)checkYear);
        return "/work/checkPlan/checkingListPage";
    }

    @RequestMapping(value={"/checkPlanNoCompleteList.json"})
    @ResponseBody
    public JqGridData<ComCheckPlanListVo> checkPlanNoCompleteList(JqGridParam param, ComCheckQueryModel queryModel, String checkDateStart, String checkDateEnd, Long checkType) {
        this.setComCheckQueryModel(queryModel, null, checkDateStart, checkDateEnd);
        queryModel.setEditStatus(Integer.valueOf(1));
        if (checkType != null) {
            queryModel.setCheckTypes(Arrays.asList(checkType));
        }
        PageInfo pageInfo = this.checkPlanService.comQueryList(queryModel, param);
        return new JqGridData(pageInfo, param);
    }

    @RequestMapping(value={"/delete"})
    @ResponseBody
    public ResponseData<Object> delete(Long id) {
        this.checkPlanService.logicDel((Number)id);
        return new ResponseData();
    }

    @RequestMapping(value={"/exportCheckPlanCompleteList"})
    public void exportCheckPlanCompleteList(ComCheckQueryModel queryModel, String checkDateRange, HttpServletResponse response) throws IOException {
        JqGridParam param = new JqGridParam();
        param.setPage(1);
        param.setRows(Integer.MAX_VALUE);
        this.setComCheckQueryModel(queryModel, checkDateRange, null, null);
        PageInfo pageInfo = this.checkPlanService.comQueryList(queryModel, param);
        String[] colums = new String[]{"\u68c0\u6d4b\u5de5\u4f5c\u540d\u79f0|checkWorkName", "\u68c0\u6d4b\u65f6\u95f4|checkDateStr", "\u8d1f\u8d23\u4eba|managerName", "\u68c0\u6d4b\u7c7b\u578b|checkTypeStr", "\u5b8c\u6210\u65f6\u95f4|updateDateStr"};
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-Disposition", "attachment;filename=" + new String("\u68c0\u6d4b\u5df2\u5b8c\u6210\u6e05\u5355.xls".getBytes("GBK"), "ISO8859_1"));
        response.setContentType("application/octet-stream; charset=GBK");
        ExportExcel listexcel = new ExportExcel();
        listexcel.simpleExport3("\u68c0\u6d4b\u5df2\u5b8c\u6210\u6e05\u5355", colums, pageInfo.getList(), (OutputStream)response.getOutputStream());
    }

    private void setComCheckQueryModel(ComCheckQueryModel queryModel, String checkDateRange, String checkDateStart, String checkDateEnd) {
        this.setCheckPlanQueryModel(queryModel);
        if (checkDateRange != null && checkDateRange.length() > 6 && checkDateRange.contains("\u81f3")) {
            String[] split = checkDateRange.trim().split("\u81f3");
            queryModel.setCheckStartDate(DateUtil.parseDateTime((String)(split[0] + " 00:00:00"), (String)"yyyy-MM-dd HH:mm:ss"));
            queryModel.setCheckEndDate(DateUtil.parseDateTime((String)(split[1] + " 00:00:00"), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        if (checkDateStart != null && checkDateStart.trim().length() > 6) {
            queryModel.setCheckStartDate(DateUtil.parseDateTime((String)(checkDateStart + " 00:00:00"), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        if (checkDateEnd != null && checkDateEnd.trim().length() > 6) {
            queryModel.setCheckEndDate(DateUtil.parseDateTime((String)(checkDateEnd + " 00:00:00"), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        queryModel.setEditStatus(Integer.valueOf(2));
        queryModel.setCid(UserUtils.getLoginStaffCompanyId());
    }

    @RequestMapping(method={RequestMethod.GET}, value={"getImportHcCheckResultCollectPage"})
    public String getImportHcCheckResultCollectPage(ModelMap m) {
        return "/work/checkPlan/getImportHcCheckResultCollectPage";
    }

    @RequestMapping(method={RequestMethod.GET}, value={"getDownHcCheckImportExcelPage"})
    public String getDownHcCheckImportExcelPage(ModelMap m) {
        HashMap<CallSite, ResultCollectTypeNewEnum> map = new HashMap<CallSite, ResultCollectTypeNewEnum>();
        for (ResultCollectTypeNewEnum r : ResultCollectTypeNewEnum.values()) {
            map.put((CallSite)((Object)("" + r.getCode())), r);
        }
        ArrayList<ResultCollectTypeNewEnum> list = new ArrayList<ResultCollectTypeNewEnum>();
        for (int i = 1; i <= 17; ++i) {
            list.add((ResultCollectTypeNewEnum)map.get("" + i));
        }
        m.put((Object)"list", list);
        return "/work/checkPlan/getDownHcCheckImportExcelPage";
    }

    @RequestMapping(value={"downHcCheckImportExcel"})
    public void downHcCheckImportExcel(HttpServletRequest request, HttpServletResponse response, String checkedTypes) throws Exception {
        String[] collectTypes;
        response.setHeader("Content-Disposition", "attachment;filename=" + new String("\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u68c0\u6d4b-\u7ed3\u679c\u6c47\u603b\u5bfc\u5165\u6a21\u677f.xls".getBytes("GBK"), "ISO8859_1"));
        response.setContentType("application/octet-stream; charset=GBK");
        ArrayList<Object> sheetNames = new ArrayList<Object>();
        for (String type : collectTypes = checkedTypes.split(",")) {
            String name = ResultCollectTypeNewEnum.getNameByCode((Integer)Integer.valueOf(type));
            if (!StringUtils.isNotEmpty((String)name)) continue;
            if ("10".equals(type)) {
                sheetNames.add(name + "-\u5c04\u7ebf\u88c5\u7f6e");
                sheetNames.add(name + "-\u542b\u6e90\u88c5\u7f6e");
                continue;
            }
            sheetNames.add(name);
        }
        String filePath = request.getSession().getServletContext().getRealPath("/") + "template" + File.separator + "projecthccheckplan" + File.separator + "\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u68c0\u6d4b-\u7ed3\u679c\u6c47\u603b\u5bfc\u5165\u6a21\u677f.xls";
        ExcelUtil.getInstance().downExcelBySheetNames(filePath, sheetNames, (OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"getHcCheckCollectDatasPage"})
    public String getHcCheckCollectDatasPage(ModelMap m, Long hcId, Boolean edit) {
        List items = this.checkSelectItemService.getByCheck(hcId);
        m.put((Object)"items", (Object)items);
        if (edit == null) {
            edit = false;
        }
        m.put((Object)"edit", (Object)edit);
        return "/work/checkPlan/getHcCheckCollectDatasPage";
    }

    @RequestMapping(value={"getNotGoodHcCheckCollectDatasPage"})
    public String getNotGoodHcCheckCollectDatasPage(ModelMap m, Long hcId) {
        List items = this.checkSelectItemService.getHaveOverPointItemByCheck(hcId);
        m.put((Object)"items", (Object)items);
        m.put((Object)"edit", (Object)false);
        m.put((Object)"result", (Object)"3");
        return "/work/checkPlan/getHcCheckCollectDatasPage";
    }

    @ResponseBody
    @RequestMapping(value={"deleteHcCheckPlanCollectByCollectType"})
    public ResponseData<String> deleteHcCheckPlanCollectByCollectType(Long hcId, Long collectType) {
        this.checkSelectItemService.deleteCheckItem(hcId, collectType);
        return new ResponseData();
    }

    @RequestMapping(value={"/getEveryCollectTypeDataPage"})
    public String getEveryCollectTypeDataPage(ModelMap m, Long resultCollectId, Long hcId, Integer collectType, Boolean pageEdit, String result, Integer standardId) {
        m.put((Object)"resultCollectId", (Object)resultCollectId);
        m.put((Object)"hcId", (Object)hcId);
        ResultCollectTypeNewEnum r = ResultCollectTypeNewEnum.getResultTypeByCode((Integer)collectType);
        m.put((Object)"rct", (Object)r);
        m.put((Object)"pageEditable", (Object)pageEdit);
        m.put((Object)"result", (Object)result);
        m.put((Object)"standardId", (Object)standardId);
        return "/work/checkPlan/result/table/" + r.getPage();
    }

    @ResponseBody
    @RequestMapping(value={"deleteHcCheckPlanCollectDataByDataId"})
    public ResponseData<String> deleteHcCheckPlanCollectDataByDataId(Long dataId) {
        this.checkResultService.deleteByRowNum(dataId);
        return new ResponseData();
    }

    @ResponseBody
    @RequestMapping(value={"deleteHcCheckPlanCollectDataByDataIds"})
    public ResponseData<String> deleteHcCheckPlanCollectDataByDataIds(@RequestParam(value="dataIds[]") Long[] dataIds) {
        this.checkResultService.deleteByRowNums(dataIds);
        return new ResponseData();
    }

    @RequestMapping(value={"getEditHcCheckPlanCollectPage"})
    public String getEditHcCheckPlanCollectPage(ModelMap m, Long hcId, Integer collectType, Long dataId, Boolean clone, Integer standardId) {
        m.put((Object)"hcId", (Object)hcId);
        m.put((Object)"cid", (Object)UserUtils.getLoginStaffCompanyId());
        if (clone == null || !clone.booleanValue()) {
            m.put((Object)"dataId", (Object)dataId);
        }
        m.put((Object)"standardId", (Object)standardId);
        ResultCollectTypeNewEnum r = ResultCollectTypeNewEnum.getResultTypeByCode((Integer)collectType);
        Map dataMap = this.checkResultService.getResultMapBydataId(dataId, clone);
        m.put((Object)"dataMap", (Object)dataMap);
        return "/work/checkPlan/result/info/" + r.getPageEdit();
    }

    @ResponseBody
    @RequestMapping(value={"udpateHcCheckResultCollectDataSubmit"})
    public ResponseData<String> udpateHcCheckResultCollectDataSubmit(CheckResultFormModel form) {
        form.setUserId(UserUtils.getLoginStaffId());
        form.setCid(UserUtils.getLoginStaffCompanyId());
        this.checkResultService.updateCheckResult(form);
        this.checkHistoryDataService.saveSnapshoot(form.getCheckId());
        return new ResponseData();
    }

    @RequestMapping(method={RequestMethod.GET}, value={"getAddHcCheckResultCollectPage"})
    public String getAddHcCheckResultCollectPage(ModelMap m, Long hcId) {
        List items = this.checkSelectItemService.getByCheck(hcId);
        HashMap<CallSite, Boolean> map = new HashMap<CallSite, Boolean>();
        for (CheckSelectItem i : items) {
            map.put((CallSite)((Object)("" + i.getItemId())), Global.TRUE);
        }
        m.put((Object)"map", map);
        m.put((Object)"list", (Object)ResultCollectTypeNewEnum.values());
        return "/work/checkPlan/getAddHcCheckResultCollectPage";
    }

    @ResponseBody
    @RequestMapping(value={"addHcCheckResultCollectSubmit"})
    public ResponseData<String> addHcCheckResultCollectSubmit(Long hcId, String collectTypes) {
        if (StringUtils.isNotEmpty((String)collectTypes)) {
            String[] items;
            Long userId = UserUtils.getLoginStaffId();
            Long cid = UserUtils.getLoginStaffCompanyId();
            for (String item : items = collectTypes.split(",")) {
                CheckSelectItem csi = new CheckSelectItem();
                csi.setCheckId(hcId);
                csi.setItemId(Integer.valueOf(Integer.parseInt(item)));
                csi.setCid(cid);
                csi.setCreateBy(userId);
                csi.setCreateDate(LocalDateTime.now());
                csi.setUpdateBy(userId);
                csi.setUpdateDate(LocalDateTime.now());
                this.checkSelectItemService.add((Object)csi);
            }
        }
        return new ResponseData();
    }

    @RequestMapping(method={RequestMethod.GET}, value={"selectCheckPlan"})
    public String selectCheckPlan(ModelMap m) {
        return "/work/checkPlan/selectCheckPlan";
    }

    @RequiresPermissions(value={"company.harmfactor.view"})
    @RequestMapping(value={"viewHccSource"})
    public String viewHccSource(ModelMap m, Long workHarmfactorId, Long checkPlanId, Long harmId) {
        m.put((Object)"hcId", (Object)checkPlanId);
        CheckPlan checkPlan = (CheckPlan)this.checkPlanService.getById((Serializable)checkPlanId);
        ResultCollectTypeNewEnum r = ResultCollectTypeNewEnum.getResultTypeByCode((Integer)this.getItemIdByFactorId(harmId));
        m.put((Object)"rct", (Object)r);
        m.put((Object)"pageEditable", (Object)false);
        m.put((Object)"harmId", (Object)harmId);
        m.put((Object)"result", (Object)"");
        m.put((Object)"standardId", (Object)checkPlan.getTargetStandardId());
        return "/work/checkPlan/result/table/" + r.getPage();
    }
}

