/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.work.hccheckplan;

import cn.smarthse.common.util.DateUtils;
import cn.smarthse.modules.health.entity.base.occriskfactor.OccupationalRiskFactors;
import cn.smarthse.modules.health.service.base.occriskfactor.IOccupationalRiskFactorsService;
import cn.smarthse.modules.health.service.work.reform.IReformItemBasicService;
import cn.smarthse.services.hfi.api.model.ComCheckQueryModel;
import cn.smarthse.services.hfi.api.model.smarthse.CheckPlanResultCountMdoel;
import cn.smarthse.services.hfi.api.service.ICheckPlanService;
import cn.smarthse.services.hfi.api.service.ICheckResultService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.ui.ModelMap;

public abstract class CheckPlanBaseController
extends ControllerSupport {
    @DubboReference
    protected ICheckPlanService checkPlanService;
    @DubboReference
    protected ICheckResultService checkResultService;
    @DubboReference
    private IOccupationalRiskFactorsService occupationalRiskFactorsService;
    @DubboReference
    protected IReformItemBasicService reformItemBasicService;
    Map<Long, Integer> factorIdToItemIdMap = new HashMap<Long, Integer>();

    public CheckPlanBaseController() {
        this.factorIdToItemIdMap.put(567L, 3);
        this.factorIdToItemIdMap.put(568L, 4);
        this.factorIdToItemIdMap.put(576L, 5);
        this.factorIdToItemIdMap.put(578L, 6);
        this.factorIdToItemIdMap.put(575L, 7);
        this.factorIdToItemIdMap.put(579L, 8);
        this.factorIdToItemIdMap.put(580L, 9);
        this.factorIdToItemIdMap.put(704L, 10);
        this.factorIdToItemIdMap.put(572L, 11);
        this.factorIdToItemIdMap.put(573L, 12);
    }

    protected void setCheckCountModel(ModelMap m) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Integer year = DateUtils.getYear((Date)new Date());
        CheckPlanResultCountMdoel countModel = this.checkPlanService.comCheckPlanCount(year, cid);
        m.put((Object)"countModel", (Object)countModel);
    }

    protected Boolean isSuperUser() {
        List<String> roleList = UserUtils.getRoleList(UserUtils.getCurrentUser());
        return roleList.contains("\u8d85\u7ea7\u7ba1\u7406\u5458");
    }

    protected void setIsSuperUser(ModelMap model) {
        model.addAttribute("isSuperUser", (Object)this.isSuperUser());
    }

    protected String toStringIds(List<Long> orgIdList) {
        if (orgIdList == null || orgIdList.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Long l : orgIdList) {
            sb.append(l);
            sb.append(",");
        }
        return sb.substring(0, sb.length() - 1);
    }

    protected void setCheckPlanQueryModel(ComCheckQueryModel queryModel) {
        queryModel.setStaffId(UserUtils.getLoginStaffId());
        queryModel.setDeptId(UserUtils.getOrgId());
    }

    protected static List<Long> parseStrIds(String ids) {
        if (ids == null || ids.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<Long> list = new LinkedList<Long>();
        for (String s : ids.split(",")) {
            list.add(Long.parseLong(s));
        }
        return list;
    }

    protected static String formatListIds(List<Long> ids) {
        if (ids == null || ids.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (Long id : ids) {
            sb.append(id);
            sb.append(",");
        }
        return sb.substring(0, sb.length() - 1);
    }

    protected Integer getItemIdByFactorId(Long factorId) {
        if (factorId == null) {
            throw new RuntimeException("\u5371\u5bb3\u56e0\u7d20id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Integer itemId = this.factorIdToItemIdMap.get(factorId);
        if (itemId != null) {
            return itemId;
        }
        OccupationalRiskFactors factor = (OccupationalRiskFactors)this.occupationalRiskFactorsService.getById(factorId);
        if (factor == null) {
            throw new RuntimeException("\u4f01\u4e1a\u7aef\uff0c\u5371\u5bb3\u56e0\u7d20\u4e0d\u5b58\u5728:id=" + factorId);
        }
        if ("\u5316\u5b66\u56e0\u7d20".equals(factor.getType())) {
            return 1;
        }
        if ("\u751f\u7269\u56e0\u7d20".equals(factor.getType())) {
            return 13;
        }
        if ("\u7c89\u5c18".equals(factor.getType())) {
            return 2;
        }
        throw new RuntimeException("\u4f01\u4e1a\u7aef\uff0c\u5371\u5bb3\u56e0\u7d20:id=" + factorId + "\u7c7b\u578b\u4e0d\u6b63\u786e:" + factor.getType());
    }
}

