/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.work.harmfactor;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.easyExcel.EasyExcelNumberConvert;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.excel.ExportExcel;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.jqgrid.ParamSeachFieldVO;
import cn.smarthse.common.framework.web.repeatform.RepeatUrlFormData;
import cn.smarthse.common.util.CommonUtil;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.ServletsUtil;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.ZipCompressorUtil;
import cn.smarthse.common.util.excel.ExcelUtil;
import cn.smarthse.modules.health.entity.base.occriskfactor.OccupationalRiskFactors;
import cn.smarthse.modules.health.entity.base.staff.vo.HarmWorkStaffInfoVo;
import cn.smarthse.modules.health.entity.base.workinfo.WorkRoleInfo;
import cn.smarthse.modules.health.entity.work.harmfactor.HarmfactorHccheckplanunderway;
import cn.smarthse.modules.health.entity.work.harmfactor.HarmfactorWork;
import cn.smarthse.modules.health.entity.work.harmfactor.HarmfactorWorkSource;
import cn.smarthse.modules.health.entity.work.harmfactor.Vo.HarmfactorWorkAreaSourceVo;
import cn.smarthse.modules.health.entity.work.harmfactor.Vo.HarmfactorWorkSourceInfoVo;
import cn.smarthse.modules.health.entity.work.harmfactor.Vo.HarmfactorWorkSourceVo;
import cn.smarthse.modules.health.entity.work.hccheckplan.HcCheckCollectHarmFactorVo;
import cn.smarthse.modules.health.enums.hccheckplan.ResultCollectTypeEnum;
import cn.smarthse.modules.health.service.base.company.ICompanyOrganizationService;
import cn.smarthse.modules.health.service.base.occriskfactor.IOccupationalRiskFactorsService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.base.workinfo.IWorkRoleInfoService;
import cn.smarthse.modules.health.service.sys.IParamService;
import cn.smarthse.modules.health.service.work.harmfactor.IHarmfactorWorkService;
import cn.smarthse.modules.health.service.work.hccheckplan.IHcCheckPlanService;
import cn.smarthse.modules.health.service.work.hccheckplan.IHcCheckResultCollectDataService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.controller.work.harmfactor.CustomMergeStrategy;
import cn.smarthse.web.util.SysFileUtil;
import cn.smarthse.web.util.UserUtils;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.fastjson.JSONArray;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.cn.smarthse.modules.health.exception.HealthException;
import net.sf.jxls.exception.ParsePropertyException;
import net.sf.jxls.transformer.XLSTransformer;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/work/harmfactor/work"})
public class HarmfactorWorkController
extends ControllerSupport {
    @DubboReference
    private IHarmfactorWorkService harmfactorWorkService;
    @DubboReference
    private IWorkRoleInfoService workRoleInfoService;
    @DubboReference
    private IHcCheckPlanService hcCheckPlanService;
    @DubboReference
    private IHcCheckResultCollectDataService hcCheckResultCollectDataService;
    @DubboReference
    private ICompanyOrganizationService companyOrganizationService;
    @DubboReference
    IStaffInfoService staffInfoService;
    @DubboReference
    private IOccupationalRiskFactorsService occupationalRiskFactorsService;
    @DubboReference
    private IParamService paramService;

    @RequiresPermissions(value={"company.harmfactor.view"})
    @RequestMapping
    @Log(title="\u5c97\u4f4d\u5371\u5bb3\u56e0\u7d20", type=2)
    public String page_index(HttpSession session, ModelMap m) {
        String company_code;
        Long cid = UserUtils.getLoginStaffCompanyId();
        List wriList = this.workRoleInfoService.getWorkRoleInfosByCid(cid);
        List workIdList = this.harmfactorWorkService.listWorkIdByCid(cid);
        if (workIdList != null && !workIdList.isEmpty()) {
            String igWrArr = org.apache.commons.lang3.StringUtils.join((Iterable)workIdList, (String)",");
            m.put((Object)"igWrArr", (Object)igWrArr);
        }
        if ("changxingdc".equals(company_code = this.paramService.getByKey("company_code", null))) {
            m.put((Object)"dbexport", (Object)1);
        }
        m.put((Object)"wriList", (Object)wriList);
        return "work/harmfactor/index_work";
    }

    @RequiresPermissions(value={"company.harmfactor.view"})
    @RequestMapping(value={"page_harmfactorCollect"})
    @Log(title="\u5c97\u4f4d\u5371\u5bb3\u56e0\u7d20-\u5371\u5bb3\u56e0\u7d20\u91c7\u96c6", type=2)
    public String page_harmfactorCollect(ModelMap m) {
        return "work/harmfactor/harmfactor_collect";
    }

    @RequiresPermissions(value={"company.harmfactor.view"})
    @RequestMapping(value={"harmfactorCollect"})
    public String harmfactorCollect(JqGridParam jparam, Date start, Date end, ModelMap m, String cj, String harmfactorName) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        if ("1".equals(cj) && start == null && end == null) {
            start = DateUtils.StringToDate((String)(DateUtils.getThisYear() + "-1-1"));
            end = DateUtils.StringToDate((String)(DateUtils.getThisYear() + "-12-31"));
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)harmfactorName)) {
            ArrayList<ParamSeachFieldVO> postDatas = jparam.getPostDatas();
            if (CollectionUtils.isEmpty((Collection)postDatas)) {
                postDatas = new ArrayList<ParamSeachFieldVO>();
            }
            ParamSeachFieldVO fvo = new ParamSeachFieldVO();
            fvo.setSearchField("harmNameOrSamplePoint");
            fvo.setSearchValue(harmfactorName);
            postDatas.add(fvo);
            jparam.setPostDatas(postDatas);
        }
        PageInfo hcCheckPlanList = this.hcCheckPlanService.getHcCheckPlanCompletedByTimeRange(jparam, start, end, cid);
        m.put((Object)"hcCheckPlanList", (Object)hcCheckPlanList);
        return "work/harmfactor/harmfactor_collectdata";
    }

    @RequiresPermissions(value={"company.harmfactor.view"})
    @RequestMapping(value={"page_hcchecksource"})
    public String page_hcchecksource(Long hcId) {
        return "work/harmfactor/dialog_hcchecksource";
    }

    @RequiresPermissions(value={"company.harmfactor.view"})
    @RequestMapping(value={"harmfactorCollectDetail"})
    @ResponseBody
    public JqGridData<HcCheckCollectHarmFactorVo> harmfactorCollectDetail(JqGridParam jparam, Long hcId, String search) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)search)) {
            ArrayList<ParamSeachFieldVO> paramSv = new ArrayList<ParamSeachFieldVO>();
            ParamSeachFieldVO sv = new ParamSeachFieldVO();
            sv.setSearchField("keyword");
            sv.setSearchValue(search);
            paramSv.add(sv);
            jparam.setPostDatas(paramSv);
        }
        PageInfo hcchInfo = this.hcCheckResultCollectDataService.getHcCheckCollectAllCheckPojNamesByPage(jparam, cid, hcId);
        JqGridData data = new JqGridData(hcchInfo, jparam);
        return data;
    }

    @RequiresPermissions(value={"company.harmfactor.view"})
    @RequestMapping(value={"viewHccSource"})
    public String viewHccSource(ModelMap m, Long workHarmfactorId, Long checkPlanId, Long harmId) {
        OccupationalRiskFactors orf = (OccupationalRiskFactors)this.occupationalRiskFactorsService.getById(harmId);
        Integer collectType = null;
        if (orf != null && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)orf.getType())) {
            collectType = "\u5316\u5b66\u56e0\u7d20".equals(orf.getType().trim()) ? ResultCollectTypeEnum.CHEMICAL.getCode() : ("\u7c89\u5c18".equals(orf.getType().trim()) ? ResultCollectTypeEnum.DUST.getCode() : ("\u751f\u7269\u56e0\u7d20".equals(orf.getType().trim()) ? ResultCollectTypeEnum.BIOLOGICAL.getCode() : ResultCollectTypeEnum.getCodeByParamCode((String)orf.getParamcode())));
        }
        m.put((Object)"hcId", (Object)checkPlanId);
        m.put((Object)"harmId", (Object)harmId);
        m.put((Object)"collectType", (Object)collectType);
        if (collectType != null && collectType < 18) {
            ResultCollectTypeEnum r = ResultCollectTypeEnum.getResultTypeByCode((Integer)collectType);
            return "work/harmfactor/hccheckplan/" + r.getHarmManagerPage();
        }
        return "";
    }

    @RequiresPermissions(value={"company.harmfactor.view"})
    @RequestMapping(value={"showHisPage"})
    @Log(title="\u5c97\u4f4d\u5371\u5bb3\u56e0\u7d20-\u5386\u53f2\u6570\u636e", type=2)
    public String showHisPage(ModelMap m, Long workId) {
        m.put((Object)"workId", (Object)workId);
        return "work/harmfactor/dialog_hisPage";
    }

    @RequiresPermissions(value={"company.harmfactor.view"})
    @RequestMapping(value={"showHisPageListData"})
    @ResponseBody
    public JqGridData<HarmfactorWorkSourceVo> showHisPageListData(JqGridParam jparam, Long workId) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        PageInfo hcchInfo = this.harmfactorWorkService.getHisDataByWork(jparam, workId, cid);
        JqGridData data = new JqGridData(hcchInfo, jparam);
        return data;
    }

    @RequiresPermissions(value={"company.harmfactor.view"})
    @RequestMapping(value={"page_harmfactorWorkEdit"})
    public String page_harmfactorWorkEdit(Long workSourceId, Long workId, Long harmId, ModelMap m, JqGridParam param) {
        PageInfo hwsInfopage;
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        param.setRows(1);
        if (workSourceId != null && harmId != null && (hwsInfopage = this.harmfactorWorkService.pageHarmfactorWorkSourceInfoList(param, workSourceId, harmId)) != null && hwsInfopage.getList() != null && hwsInfopage.getList().size() > 0) {
            HarmfactorWorkSourceInfoVo hwsInfo = (HarmfactorWorkSourceInfoVo)hwsInfopage.getList().get(0);
            m.put((Object)"hwsInfo", (Object)hwsInfo);
            String source = hwsInfo.getHazardSource();
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)source)) {
                String[] sources = org.apache.commons.lang3.StringUtils.split((String)source, (String)",");
                m.put((Object)"sourcesarray", (Object)sources);
            }
        }
        m.put((Object)"workHarmfactorId", (Object)workSourceId);
        m.put((Object)"workId", (Object)workId);
        return "work/harmfactor/dialog_harmfactorWorkEdit";
    }

    @RequiresPermissions(value={"company.harmfactor.view"})
    @RequestMapping(value={"litePageHarmfactorWorkEdit"})
    public String litePageHarmfactorWorkEdit(ModelMap m, Long workSourceId, Long workId, String clone) {
        List workIdList;
        Long cid = UserUtils.getLoginStaffCompanyId();
        if (workId != null) {
            if (!"1".equals(clone)) {
                m.put((Object)"workId", (Object)workId);
                String workName = this.workRoleInfoService.getWorkNameIncludeOrgName(workId);
                m.put((Object)"workName", (Object)workName);
            }
            List harmfactorListByWork = this.harmfactorWorkService.getHarmfactorListByWork(cid, workId);
            m.put((Object)"harmfactorList", (Object)harmfactorListByWork);
        }
        if ((workIdList = this.harmfactorWorkService.listWorkIdByCid(cid)) != null && !workIdList.isEmpty()) {
            m.put((Object)"wriList", (Object)org.apache.commons.lang3.StringUtils.join((Iterable)workIdList, (String)","));
        }
        return "work/harmfactor/dialog_harmfactorWorkEdit";
    }

    @RequiresPermissions(value={"company.harmfactor.view"})
    @RequestMapping(value={"/hccheckplan/underway"})
    public String hccheckplanUnderway() {
        Long cid = UserUtils.getLoginStaffCompanyId();
        return "work/harmfactor/hccheckplanUnderway";
    }

    @RequiresPermissions(value={"company.harmfactor.view"})
    @RequestMapping(value={"/hccheckplan/statistic"})
    @Log(title="\u5c97\u4f4d\u5371\u5bb3\u56e0\u7d20-\u5173\u8054\u7edf\u8ba1", type=2)
    public String hccheckplanStatistic() {
        Long cid = UserUtils.getLoginStaffCompanyId();
        return "work/harmfactor/hccheckplanStatistic";
    }

    @RequiresPermissions(value={"company.harmfactor.view"})
    @RequestMapping(value={"hccheckplanUnderwayListData"})
    @ResponseBody
    public JqGridData<HarmfactorHccheckplanunderway> hccheckplanUnderwayListData(JqGridParam jparam, Boolean isFinish) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        jparam.setCid(cid);
        UserUtils.startWebDataScope();
        PageInfo hccheckplanList = this.harmfactorWorkService.pageHarmfactorHccheckplanUnderway(jparam, isFinish);
        JqGridData data = new JqGridData(hccheckplanList, jparam);
        return data;
    }

    @RequiresPermissions(value={"company.harmfactor.view"})
    @RequestMapping(value={"page_harmLinkImport"})
    public String harmLinkImport(ModelMap m) {
        return "work/harmfactor/harmLinkImport";
    }

    @RequiresPermissions(value={"company.harmfactor.view"})
    @RequestMapping(value={"downImportTempl"})
    @Log(title="\u5c97\u4f4d\u5371\u5bb3\u56e0\u7d20-\u4e0b\u8f7d\u5bfc\u5165\u6a21\u677f", type=2)
    public void downImportTempl(JqGridParam jparam, Long hcplanId, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Long cid = UserUtils.getLoginStaffCompanyId();
        PageInfo hcchInfo = this.hcCheckResultCollectDataService.getHcCheckCollectAllCheckPojNamesByPage(jparam, cid, hcplanId);
        List hccList = hcchInfo.getList();
        List workRoleInfoList = this.workRoleInfoService.getWorkRoleInfosByCid(cid);
        if (workRoleInfoList != null && !workRoleInfoList.isEmpty()) {
            String realPath = request.getSession().getServletContext().getRealPath("/");
            String filePath = realPath + "/temp/" + hcplanId + "/";
            File fileDir = new File(filePath);
            if (fileDir != null) {
                FileUtils.deleteDirectory((File)fileDir);
            }
            fileDir.mkdirs();
            String[] colums = new String[]{"\u91c7\u6837\u70b9/\u5bf9\u8c61|reportName", "\u5b58\u5728\u7684\u5371\u5bb3\u56e0\u7d20|harmFactorNames", "\u662f\u5426\u7ecf\u5e38\u5728\u6b64\u5de5\u4f5c\uff08\u662f\u5219\u586b\u5199\u201c\u662f\u201d\uff0c\u5426\u5219\u65e0\u9700\u586b\u5199\uff09|checkProjectName"};
            for (WorkRoleInfo wri : workRoleInfoList) {
                String workName = (wri = (WorkRoleInfo)this.workRoleInfoService.getById(wri.getId())).getWorkName() + "-" + wri.getOrgName();
                File excelFile = new File(filePath + workName + ".xls");
                if (!excelFile.exists()) {
                    excelFile.createNewFile();
                }
                ExportExcel listexcel = new ExportExcel();
                listexcel.simpleExportAutoWidth("" + wri.getId(), colums, hccList, (OutputStream)new FileOutputStream(excelFile));
                excelFile = null;
            }
            String zipFilePath = realPath + "/temp/\u91c7\u6837\u70b9\u5bfc\u5165\u6a21\u677f.zip";
            ZipCompressorUtil zipCompressorUtil = new ZipCompressorUtil(zipFilePath);
            zipCompressorUtil.compressExe(filePath);
            File f = new File(zipFilePath);
            ServletsUtil.setFileDownloadHeader((HttpServletResponse)response, (String)"\u91c7\u6837\u70b9\u5bfc\u5165\u6a21\u677f.zip", (HttpServletRequest)request);
            ServletOutputStream os = null;
            FileInputStream inputStream = null;
            try {
                int length;
                inputStream = new FileInputStream(f);
                os = response.getOutputStream();
                byte[] b = new byte[2048];
                while ((length = ((InputStream)inputStream).read(b)) > 0) {
                    os.write(b, 0, length);
                }
            }
            catch (FileNotFoundException fe) {
                throw new HealthException("\u7cfb\u7edf\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u6587\u4ef6");
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                if (inputStream != null) {
                    ((InputStream)inputStream).close();
                }
                if (os != null) {
                    os.flush();
                    os.close();
                }
            }
        }
    }

    @RequiresPermissions(value={"company.harmfactor.view"})
    @RequestMapping(value={"downImportTempl2"})
    public void downImportTempl2(JqGridParam jparam, Long hcplanId, HttpServletRequest request, HttpServletResponse response) throws IOException, ParsePropertyException, InvalidFormatException {
        Long cid = UserUtils.getLoginStaffCompanyId();
        PageInfo hcchInfo = this.hcCheckResultCollectDataService.getHcCheckCollectAllCheckPojNamesByPage(jparam, cid, hcplanId);
        List hccList = hcchInfo.getList();
        List workRoleInfoList = this.workRoleInfoService.getWorkRoleOrgNameByCid(cid);
        if (CollectionUtils.isNotEmpty((Collection)workRoleInfoList)) {
            XLSTransformer transformer = new XLSTransformer();
            String templateDirPath = super.getTemplateFilePath() + "harmfactor/harmfactorsource.xls";
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(templateDirPath));
            ArrayList objects = new ArrayList();
            ArrayList<CallSite> newSheetNames = new ArrayList<CallSite>();
            for (int i = 0; i < workRoleInfoList.size(); ++i) {
                WorkRoleInfo wri = (WorkRoleInfo)workRoleInfoList.get(i);
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("hccList", hccList);
                data.put("workname", wri.getOrgName());
                data.put("workid", wri.getId());
                objects.add(data);
                newSheetNames.add((CallSite)((Object)(wri.getWorkName() + "(" + wri.getId() + ")")));
            }
            Workbook workbook = transformer.transformMultipleSheetsList((InputStream)is, objects, newSheetNames, "zb", new HashMap(), 0);
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String fileName = "\u5c97\u4f4d\u5371\u5bb3\u56e0\u7d20\u68c0\u6d4b\u62a5\u544a\u5173\u8054\u5bfc\u5165\u6a21\u677f" + dateFormat.format(new Date()) + ".xls";
            ServletsUtil.setFileDownloadHeader((HttpServletResponse)response, (String)fileName, (HttpServletRequest)request);
            ServletOutputStream os = null;
            try {
                os = response.getOutputStream();
                workbook.write((OutputStream)os);
            }
            catch (FileNotFoundException fe) {
                throw new HealthException("\u7cfb\u7edf\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u6587\u4ef6");
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                if (is != null) {
                    ((InputStream)is).close();
                }
                if (os != null) {
                    os.flush();
                    os.close();
                }
            }
        }
    }

    @RequiresPermissions(value={"company.harmfactor.view"})
    @RequestMapping(value={"downImportTempl3"})
    @Log(title="\u5c97\u4f4d\u5371\u5bb3\u56e0\u7d20-\u4e0b\u8f7d\u5bfc\u5165\u6a21\u677f", type=2)
    public void downImportTempl3(JqGridParam jparam, Long hcplanId, HttpServletRequest request, HttpServletResponse response) throws IOException, ParsePropertyException, InvalidFormatException {
        Long cid = UserUtils.getLoginStaffCompanyId();
        String outFiltPath = this.harmfactorWorkService.exportImportTemp(hcplanId, cid);
        FileInputStream in = new FileInputStream(new File(outFiltPath));
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String fileName = "\u5c97\u4f4d\u5371\u5bb3\u56e0\u7d20\u68c0\u6d4b\u62a5\u544a\u5173\u8054\u5bfc\u5165\u6a21\u677f" + dateFormat.format(new Date()) + ".xls";
        ServletsUtil.setFileDownloadHeader((HttpServletResponse)response, (String)fileName, (HttpServletRequest)request);
        ServletOutputStream os = response.getOutputStream();
        try {
            int len;
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) != -1) {
                os.write(buf, 0, len);
            }
            in.close();
            os.flush();
            os.close();
        }
        catch (FileNotFoundException fe) {
            throw new HealthException("\u7cfb\u7edf\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u6587\u4ef6");
        }
        catch (Exception e) {
            throw e;
        }
    }

    @RequiresPermissions(value={"company.harmfactor.view"})
    @RequestMapping(value={"exportHarmfactorWork"})
    @Log(title="\u5c97\u4f4d\u5371\u5bb3\u56e0\u7d20-\u5bfc\u51fa", type=24)
    public void exportHarmfactorWork(JqGridParam param, Long hcplanId, Boolean filterCurrYear, HttpServletRequest request, HttpServletResponse response) throws IOException, ParsePropertyException, InvalidFormatException {
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        param.setRows(10000000);
        UserUtils.startWebDataScope();
        PageInfo page = this.harmfactorWorkService.pageHarmfactorWork(param, filterCurrYear);
        XLSTransformer transformer = new XLSTransformer();
        String templateDirPath = super.getTemplateFilePath() + "harmfactor/workharmfactor.xls";
        List list = page.getList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (HarmfactorWorkSourceVo harmfactorWorkSourceVo : list) {
                harmfactorWorkSourceVo.setCheckWorkName(harmfactorWorkSourceVo.getCheckWorkName2());
            }
        }
        HashMap<String, List> data = new HashMap<String, List>();
        data.put("hwList", list);
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(templateDirPath));
        Workbook workbook = transformer.transformXLS((InputStream)is, data);
        ExcelUtil.verticalMerged((Workbook)workbook, (int)0, (int)1, (int)0);
        Sheet sheet = workbook.getSheetAt(0);
        List cellRangeList = sheet.getMergedRegions();
        int noColIndex = 4;
        int contactTypeColIndex = 3;
        if (CommonUtil.listIsNotEmpty((List)cellRangeList)) {
            for (CellRangeAddress cellAddress : cellRangeList) {
                int startRow = cellAddress.getFirstRow();
                int lastRow = cellAddress.getLastRow();
                StringBuffer NoSb = new StringBuffer(",");
                for (int i = startRow; i <= lastRow; ++i) {
                    Row row = sheet.getRow(i);
                    if (row == null || row.getCell(noColIndex) == null) continue;
                    String text = row.getCell(noColIndex).getStringCellValue();
                    if (NoSb.toString().indexOf(text) != -1) continue;
                    NoSb.append(text + ",");
                }
                NoSb.deleteCharAt(0);
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)NoSb)) {
                    NoSb.deleteCharAt(NoSb.toString().length() - 1);
                }
                CellRangeAddress region = new CellRangeAddress(startRow, lastRow, noColIndex, noColIndex);
                CellRangeAddress region2 = new CellRangeAddress(startRow, lastRow, contactTypeColIndex, contactTypeColIndex);
                sheet.getRow(startRow).getCell(noColIndex).setCellValue(NoSb.toString());
                sheet.addMergedRegion(region);
                sheet.addMergedRegion(region2);
            }
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String fileName = "\u5c97\u4f4d\u5de5\u79cd\u63a5\u89e6\u7684\u5371\u5bb3\u56e0\u7d20\u7ba1\u7406\u5217\u8868" + dateFormat.format(new Date()) + ".xls";
        ServletsUtil.setFileDownloadHeader((HttpServletResponse)response, (String)fileName, (HttpServletRequest)request);
        ServletOutputStream os = null;
        try {
            os = response.getOutputStream();
            workbook.write((OutputStream)os);
        }
        catch (FileNotFoundException fe) {
            throw new HealthException("\u7cfb\u7edf\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u6587\u4ef6");
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (is != null) {
                ((InputStream)is).close();
            }
            if (os != null) {
                os.flush();
                os.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermissions(value={"company.harmfactor.view"})
    @RequestMapping(value={"exportHarmfactorWork2"})
    @Log(title="\u5c97\u4f4d\u5371\u5bb3\u56e0\u7d20-\u5bfc\u51fa", type=24)
    public void exportHarmfactorWork2(JqGridParam param, Long hcplanId, Boolean filterCurrYear, HttpServletRequest request, HttpServletResponse response) throws IOException, ParsePropertyException, InvalidFormatException {
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        param.setRows(10000000);
        UserUtils.startWebDataScope();
        PageInfo page = this.harmfactorWorkService.pageHarmfactorWork(param, filterCurrYear);
        XLSTransformer transformer = new XLSTransformer();
        String templateDirPath = super.getTemplateFilePath() + "harmfactor/workharmfactor2.xls";
        List list = page.getList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (HarmfactorWorkSourceVo harmfactorWorkSourceVo : list) {
                harmfactorWorkSourceVo.setCheckWorkName(harmfactorWorkSourceVo.getCheckWorkName2());
            }
        }
        ServletOutputStream out = null;
        try {
            out = response.getOutputStream();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String fileName = "\u5c97\u4f4d\u5de5\u79cd\u63a5\u89e6\u7684\u5371\u5bb3\u56e0\u7d20\u7ba1\u7406\u5217\u8868" + dateFormat.format(new Date()) + ".xls";
            response.setHeader("Content-Disposition", "attachment;filename=" + new String((fileName + ".xlsx").getBytes("GBK"), "ISO8859_1"));
            EasyExcelNumberConvert easyExcelNumberConvert = new EasyExcelNumberConvert();
            ExcelWriter excelWriter = ((ExcelWriterBuilder)EasyExcel.write((OutputStream)out).registerConverter((Converter)easyExcelNumberConvert)).withTemplate(templateDirPath).build();
            WriteSheet writeSheet = ((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)((ExcelWriterSheetBuilder)EasyExcel.writerSheet().registerWriteHandler((WriteHandler)new CustomMergeStrategy(list.stream().map(HarmfactorWorkSourceVo::getWorkName).collect(Collectors.toList()), 0))).registerWriteHandler((WriteHandler)new CustomMergeStrategy(list.stream().map(k -> k.getWorkName() + k.getContactType()).collect(Collectors.toList()), 3))).registerWriteHandler((WriteHandler)new CustomMergeStrategy(list.stream().map(k -> k.getWorkName() + k.getCheckWorkNo()).collect(Collectors.toList()), 4))).build();
            excelWriter.fill((Object)list, writeSheet);
            excelWriter.finish();
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @RequiresPermissions(value={"company.harmfactor.view"})
    @RequestMapping(value={"exportRiskData"})
    @Log(title="\u98ce\u9669\u6570\u636e\u5e93\u5bfc\u51fa-\u5bfc\u51fa", type=24)
    public void exportRiskData(JqGridParam param, Long hcplanId, HttpServletRequest request, HttpServletResponse response) throws IOException, ParsePropertyException, InvalidFormatException {
        Long cid = UserUtils.getLoginStaffCompanyId();
        UserUtils.startWebDataScope();
        List harmRiskDataVoList = this.harmfactorWorkService.listHarmRiskData(cid);
        XLSTransformer transformer = new XLSTransformer();
        String templateDirPath = super.getTemplateFilePath() + "harmfactor/riskDataTemp.xlsx";
        HashMap<String, List> data = new HashMap<String, List>();
        data.put("riskDataList", harmRiskDataVoList);
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(templateDirPath));
        Workbook workbook = transformer.transformXLS((InputStream)is, data);
        ExcelUtil.verticalMerged((Workbook)workbook, (int)0, (int)3, (int)2);
        Sheet sheet = workbook.getSheetAt(0);
        List cellRangeList = sheet.getMergedRegions();
        int noColIndex = 1;
        int contactTypeColIndex = 3;
        if (CommonUtil.listIsNotEmpty((List)cellRangeList)) {
            for (CellRangeAddress cellAddress : cellRangeList) {
                int startRow = cellAddress.getFirstRow();
                int lastRow = cellAddress.getLastRow();
                if (startRow < 3 || startRow == lastRow) continue;
                CellRangeAddress region = new CellRangeAddress(startRow, lastRow, noColIndex, noColIndex);
                CellRangeAddress region2 = new CellRangeAddress(startRow, lastRow, contactTypeColIndex, contactTypeColIndex);
                sheet.addMergedRegion(region);
                sheet.addMergedRegion(region2);
            }
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String fileName = "\u804c\u4e1a\u5065\u5eb7\u98ce\u9669\u6570\u636e\u5e93" + dateFormat.format(new Date()) + ".xls";
        ServletsUtil.setFileDownloadHeader((HttpServletResponse)response, (String)fileName, (HttpServletRequest)request);
        ServletOutputStream os = null;
        try {
            os = response.getOutputStream();
            workbook.write((OutputStream)os);
        }
        catch (FileNotFoundException fe) {
            throw new HealthException("\u7cfb\u7edf\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u6587\u4ef6");
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (is != null) {
                ((InputStream)is).close();
            }
            if (os != null) {
                os.flush();
                os.close();
            }
        }
    }

    @RequiresPermissions(value={"company.harmfactor.view"})
    @RequestMapping(value={"ImportHarmsource"})
    @ResponseBody
    @Log(title="\u5c97\u4f4d\u5371\u5bb3\u56e0\u7d20-\u5bfc\u5165", type=23)
    public ResponseData<List<HarmfactorWorkSourceVo>> ImportHarmsource(HttpServletRequest request, JqGridParam jparam, String fileIds, Long hcplanId) {
        ResponseData data = new ResponseData();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)fileIds)) {
            data.setState(ResponseStateEnum.fail);
            data.setContent("\u6587\u4ef6\u672a\u627e\u5230");
            return data;
        }
        if (hcplanId == null) {
            data.setState(ResponseStateEnum.fail);
            data.setContent("\u7f3a\u5c11\u5fc5\u987b\u5f97\u53c2\u6570");
            return data;
        }
        String path = request.getContextPath();
        String basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + path + "/";
        Long cid = UserUtils.getLoginStaffCompanyId();
        String[] fileIdArr = org.apache.commons.lang3.StringUtils.splitByWholeSeparator((String)fileIds, (String)",");
        ArrayList<String> ossfileList = new ArrayList<String>();
        for (String fileId : fileIdArr) {
            if (!org.apache.commons.lang3.StringUtils.isNumeric((CharSequence)fileId)) continue;
            Long longFileId = Long.parseLong(fileId);
            Object ossfile = SysFileUtil.getFileUrlByfid(longFileId);
            if (((String)ossfile).startsWith("/file")) {
                ossfile = basePath + (String)ossfile;
            }
            ossfileList.add((String)ossfile);
        }
        try {
            List harmLinkHccheckplanList = this.harmfactorWorkService.ImportHarmsource(ossfileList, cid, hcplanId);
            data.setResult((Object)harmLinkHccheckplanList);
            return data;
        }
        catch (Exception e) {
            data.setState(ResponseStateEnum.fail);
            this.logger.error(e.getMessage());
            data.setContent(e.getMessage());
            return data;
        }
    }

    @RequiresPermissions(value={"company.harmfactor.view"})
    @RequestMapping(value={"/harmLinkHccheckplan"})
    public String harmLinkHccheckplan(ModelMap m, Long hcplanId, Long hccheckUnderwayId, @RequestParam(defaultValue="false") boolean isAdminModel) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        m.put((Object)"hcplanId", (Object)hcplanId);
        m.put((Object)"hccheckUnderwayId", (Object)hccheckUnderwayId);
        HarmfactorHccheckplanunderway hhccway = this.harmfactorWorkService.getHarmfactorHccheckplanunderwayById(hccheckUnderwayId);
        m.put((Object)"hhccway", (Object)hhccway);
        if (isAdminModel) {
            if (UserUtils.hasRole("\u8d85\u7ea7\u7ba1\u7406\u5458")) {
                m.put((Object)"isAdminModel", (Object)isAdminModel);
            } else {
                throw new AuthorizationException("\u6ca1\u6709\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
            }
        }
        return "work/harmfactor/harmLinkHccheckplan";
    }

    @RequiresPermissions(value={"company.harmfactor.view"})
    @RequestMapping(value={"harmLinkHccheckplanListData"})
    @ResponseBody
    public JqGridData<HarmfactorWorkSourceVo> harmLinkHccheckplanListData(JqGridParam jparam, Long hcplanId, Boolean isFinish, String kw, @RequestParam(defaultValue="false") boolean isAdminModel) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        if (isAdminModel && !UserUtils.hasRole("\u8d85\u7ea7\u7ba1\u7406\u5458")) {
            throw new AuthorizationException("\u6ca1\u6709\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
        }
        List harmLinkHccheckplanList = this.harmfactorWorkService.getHarmLinkHccheckplan(cid, hcplanId, isFinish, kw, isAdminModel);
        PageInfo harmLinkHccheckplanPage = new PageInfo(harmLinkHccheckplanList);
        JqGridData data = new JqGridData(harmLinkHccheckplanPage, jparam);
        return data;
    }

    @RequiresPermissions(value={"company.harmfactor.edit"})
    @Log(title="\u5c97\u4f4d\u5371\u5bb3\u56e0\u7d20\u7f16\u8f91", type=21)
    @RepeatUrlFormData
    @RequestMapping(value={"saveHarmLinkHccheckplan"})
    @ResponseBody
    public ResponseData<String> saveHarmLinkHccheckplan(String datas, boolean isFinish, Long checkPlanId, Long hccheckUnderwayId, @RequestParam(defaultValue="false") boolean isAdminModel) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long loginStaffId = UserUtils.getLoginStaffId();
        datas = StringEscapeUtils.unescapeHtml((String)datas);
        List wharmSourceHccplanList = JSONArray.parseArray((String)datas, HarmfactorWorkSource.class);
        ResponseData data = new ResponseData();
        if (isAdminModel && !UserUtils.hasRole("\u8d85\u7ea7\u7ba1\u7406\u5458")) {
            throw new AuthorizationException("\u6ca1\u6709\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
        }
        try {
            this.harmfactorWorkService.saveHarmLinkHccheckplan(wharmSourceHccplanList, isFinish, checkPlanId, Boolean.valueOf(isAdminModel), cid, loginStaffId);
            data.setContent("\u4fdd\u5b58\u6210\u529f");
        }
        catch (Exception e) {
            data.setState(ResponseStateEnum.fail);
            this.logger.error("\u4fdd\u5b58\u5931\u8d25:" + e.getMessage());
            data.setContent("\u4fdd\u5b58\u5931\u8d25:" + e.getMessage());
        }
        return data;
    }

    @RequiresPermissions(value={"company.harmfactor.edit"})
    @Log(title="\u5c97\u4f4d/\u5de5\u79cd \u5371\u5bb3\u56e0\u7d20\u7f16\u8f91", type=21)
    @RepeatUrlFormData
    @RequestMapping(value={"editHarmfactorWorkPage"})
    public String addHarmfactorWork(ModelMap m, @RequestParam(required=false) Long id, Boolean isClone) {
        List workIdList;
        Long cid = UserUtils.getLoginStaffCompanyId();
        HarmfactorWork hwInfo = null;
        if (id != null) {
            hwInfo = (HarmfactorWork)this.harmfactorWorkService.getById(id);
            m.put((Object)"hwInfo", (Object)hwInfo);
            if (hwInfo != null && hwInfo.getWorkId() != null) {
                String workName = this.workRoleInfoService.getWorkNameIncludeOrgName(hwInfo.getWorkId());
                m.put((Object)"workName", (Object)workName);
            }
        }
        if ((workIdList = this.harmfactorWorkService.listWorkIdByCid(cid)) != null && !workIdList.isEmpty()) {
            m.put((Object)"wriList", (Object)org.apache.commons.lang3.StringUtils.join((Iterable)workIdList, (String)","));
        }
        m.put((Object)"HAZ_SOURCE_SPLIT", (Object)"~@~");
        m.put((Object)"MORE_HAZ_SOURCE_SPLIT", (Object)"~#~");
        return "work/harmfactor/cloneHarmfactorWork";
    }

    @RequiresPermissions(value={"company.harmfactor.edit"})
    @Log(title="\u5c97\u4f4d/\u5de5\u79cd \u5371\u5bb3\u56e0\u7d20\u514b\u9686", type=21)
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"saveCloneHarmfactorWork"})
    public ResponseData<HarmfactorWork> saveCloneHarmfactorWork(ModelMap m, Long clonedWorkId, Long newWorkId) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long loginStaffId = UserUtils.getLoginStaffId();
        ResponseData resultData = new ResponseData();
        try {
            this.harmfactorWorkService.cloneHarmfactorWork(clonedWorkId, newWorkId, loginStaffId, cid);
            resultData.setContent("\u514b\u9686\u6210\u529f");
        }
        catch (Exception e) {
            resultData.setState(ResponseStateEnum.fail);
            this.logger.error("\u514b\u9686\u51fa\u9519\uff1a" + e.getMessage());
        }
        return resultData;
    }

    @RequiresPermissions(value={"company.harmfactor.edit"})
    @Log(title="\u5c97\u4f4d\u5371\u5bb3\u56e0\u7d20\u65b0\u589e\u4e0e\u7f16\u8f91", type=21)
    @RepeatUrlFormData
    @RequestMapping(value={"/add"})
    @ResponseBody
    public ResponseData<HarmfactorWork> save(HarmfactorWork harmfactorWork, boolean triggerChange) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long loginStaffId = UserUtils.getLoginStaffId();
        ResponseData resultData = new ResponseData();
        try {
            HarmfactorWork result = this.harmfactorWorkService.saveHarmfactorWork(harmfactorWork, triggerChange, loginStaffId, cid);
            resultData.setResult((Object)result);
            resultData.setContent("\u4fdd\u5b58\u6210\u529f");
            return resultData;
        }
        catch (Exception e) {
            this.logger.error("\u4fdd\u5b58\u5931\u8d25\uff1a" + e.getMessage());
            resultData.setState(ResponseStateEnum.fail);
            resultData.setContent(e.getMessage());
            return resultData;
        }
    }

    @Log(title="\u5c97\u4f4d\u5371\u5bb3\u56e0\u7d20\u5220\u9664", type=22)
    @RepeatUrlFormData
    @RequiresPermissions(value={"company.harmfactor.edit"})
    @RequestMapping(value={"/delHarmfactorWork"})
    @ResponseBody
    public ResponseData<HarmfactorWork> delHarmfactorWork(HarmfactorWork harmfactorWork) {
        Long loginStaffId = UserUtils.getLoginStaffId();
        ResponseData resultData = new ResponseData();
        try {
            this.harmfactorWorkService.delHarmfactorWork(harmfactorWork, loginStaffId);
            resultData.setContent("\u5220\u9664\u6210\u529f");
            return resultData;
        }
        catch (Exception e) {
            this.logger.error("\u5220\u9664\u51fa\u9519\uff1a" + e.getMessage());
            resultData.setState(ResponseStateEnum.fail);
            resultData.setContent(e.getMessage());
            return resultData;
        }
    }

    @Log(title="\u5c97\u4f4d\u5371\u5bb3\u56e0\u7d20\u6765\u6e90\u5220\u9664", type=22)
    @RequestMapping(value={"/delHarmfactorWorkSourceInfo"})
    @RepeatUrlFormData
    @RequiresPermissions(value={"company.harmfactor.edit"})
    @ResponseBody
    public ResponseData<HarmfactorWork> delHarmfactorWorkSourceInfo(HarmfactorWorkSource harmfactorWorkSource) {
        ResponseData resultData = new ResponseData();
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long loginStaffId = UserUtils.getLoginStaffId();
        try {
            this.harmfactorWorkService.delHarmfactorWorkSourceInfo(harmfactorWorkSource, cid, loginStaffId);
            resultData.setContent("\u5220\u9664\u6210\u529f");
            return resultData;
        }
        catch (Exception e) {
            this.logger.error("\u5220\u9664\u51fa\u9519\uff1a" + e.getMessage());
            resultData.setState(ResponseStateEnum.fail);
            resultData.setContent(e.getMessage());
            return resultData;
        }
    }

    @Log(title="\u68c0\u6d4b\u5c97\u4f4d\u5371\u5bb3\u56e0\u7d20\u6765\u6e90\u662f\u5426\u91cd\u590d", type=2)
    @RequestMapping(value={"checkWorkSource"})
    @ResponseBody
    public ResponseData<Integer> checkWorkSource(HarmfactorWorkSource wsource) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long loginStaffId = UserUtils.getLoginStaffId();
        ResponseData resultData = new ResponseData();
        wsource.setCid(cid);
        wsource.setUpdateBy(loginStaffId);
        try {
            int count = this.harmfactorWorkService.checkHarmfactorWorkSourceInfo(wsource);
            resultData.setResult((Object)count);
            return resultData;
        }
        catch (Exception e) {
            resultData.setState(ResponseStateEnum.fail);
            resultData.setContent(e.getMessage());
            return resultData;
        }
    }

    @RequiresPermissions(value={"company.harmfactor.edit"})
    @Log(title="\u5c97\u4f4d\u5371\u5bb3\u56e0\u7d20\u7f16\u8f91", type=21)
    @RepeatUrlFormData
    @RequestMapping(value={"saveHarmfactorWork"})
    @ResponseBody
    public ResponseData<HarmfactorWork> saveHarmfactorWorkSource(Long workHarmfactorId, Long workId, Byte contactType, Boolean isClone, String datas, String deleteMetaHarmId) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long loginStaffId = UserUtils.getLoginStaffId();
        datas = StringEscapeUtils.unescapeHtml((String)datas);
        List hwList = JSONArray.parseArray((String)datas, HarmfactorWorkSource.class);
        ArrayList<HarmfactorWorkSource> newhwList = new ArrayList<HarmfactorWorkSource>();
        ArrayList<HarmfactorWorkSource> areaDelMetaDataList = new ArrayList<HarmfactorWorkSource>();
        if (hwList != null && !hwList.isEmpty()) {
            for (HarmfactorWorkSource hw : hwList) {
                Object[] checkIdSourceTypeArr;
                String hazardSource = hw.getHazardSource();
                List<HarmfactorWorkSource> workSourceList = this.handleDelAreaMetaData(hw, workId);
                if (CollectionUtils.isNotEmpty(workSourceList)) {
                    areaDelMetaDataList.addAll(workSourceList);
                }
                if (!org.apache.commons.lang3.StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{hazardSource}) || !ArrayUtils.isNotEmpty((Object[])(checkIdSourceTypeArr = org.apache.commons.lang3.StringUtils.splitByWholeSeparatorPreserveAllTokens((String)hazardSource, (String)"~#~")))) continue;
                for (Object checkIdSourceType : checkIdSourceTypeArr) {
                    String[] metaDataArr = org.apache.commons.lang3.StringUtils.splitByWholeSeparatorPreserveAllTokens((String)checkIdSourceType, (String)"~@~");
                    String checkId = StringUtils.getArrValueByIndex((String[])metaDataArr, (int)0);
                    String hazsource = StringUtils.getArrValueByIndex((String[])metaDataArr, (int)1);
                    String sourceType = StringUtils.getArrValueByIndex((String[])metaDataArr, (int)2);
                    if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)hazsource)) continue;
                    HarmfactorWorkSource newhs = new HarmfactorWorkSource();
                    BeanUtils.copyProperties((Object)hw, (Object)newhs);
                    newhs.setHazardSource(hazsource);
                    if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)checkId) && org.apache.commons.lang3.StringUtils.isNumeric((CharSequence)checkId)) {
                        newhs.setCheckPlanId(Long.valueOf(Long.parseLong(checkId)));
                    }
                    newhwList.add(newhs);
                }
            }
        }
        Long orgId = UserUtils.getOrgId();
        ResponseData data = new ResponseData();
        try {
            List<HarmfactorWorkSource> workSourceList = this.handleDelHarmId(deleteMetaHarmId, workId);
            if (CollectionUtils.isNotEmpty(workSourceList)) {
                areaDelMetaDataList.addAll(workSourceList);
            }
            HarmfactorWork hwork = this.harmfactorWorkService.saveHarmfactorWorkSource(newhwList, areaDelMetaDataList, workId, contactType, workHarmfactorId, isClone, orgId, loginStaffId, cid);
            data.setContent("\u4fdd\u5b58\u6210\u529f");
            data.setResult((Object)hwork);
        }
        catch (HealthException e) {
            data.setState(ResponseStateEnum.fail);
            this.logger.error("\u4fdd\u5b58\u5931\u8d25:" + e.getMessage());
            data.setContent("\u4fdd\u5b58\u5931\u8d25:" + e.getMessage());
        }
        catch (Exception e) {
            data.setState(ResponseStateEnum.fail);
            this.logger.error("\u4fdd\u5b58\u5931\u8d25:" + e.getMessage());
            data.setContent("\u4fdd\u5b58\u5931\u8d25:" + e.getMessage());
        }
        return data;
    }

    private List<HarmfactorWorkSource> handleDelHarmId(String deleteMetaHarmId, Long workId) {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)deleteMetaHarmId)) {
            ArrayList<HarmfactorWorkSource> resultList = new ArrayList<HarmfactorWorkSource>();
            Object[] deleteMetaHarmIdArr = org.apache.commons.lang3.StringUtils.splitByWholeSeparator((String)deleteMetaHarmId, (String)",");
            if (ArrayUtils.isNotEmpty((Object[])deleteMetaHarmIdArr)) {
                for (Object harmIdStr : deleteMetaHarmIdArr) {
                    if (!org.apache.commons.lang3.StringUtils.isNumeric((CharSequence)harmIdStr)) continue;
                    HarmfactorWorkSource hw = new HarmfactorWorkSource();
                    hw.setWorkId(workId);
                    hw.setHarmId(Long.valueOf(Long.parseLong((String)harmIdStr)));
                    resultList.add(hw);
                }
            }
            return resultList;
        }
        return null;
    }

    private List<HarmfactorWorkSource> handleDelAreaMetaData(HarmfactorWorkSource hw, Long workId) {
        Object[] checkIdSourceTypeArr;
        if (workId == null) {
            return null;
        }
        HashSet<CallSite> keySet = new HashSet<CallSite>();
        ArrayList<HarmfactorWorkSource> workSourceList = new ArrayList<HarmfactorWorkSource>();
        String deleteMetaInfo = hw.getDeleteMetaInfo();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)deleteMetaInfo) && ArrayUtils.isNotEmpty((Object[])(checkIdSourceTypeArr = org.apache.commons.lang3.StringUtils.splitByWholeSeparatorPreserveAllTokens((String)deleteMetaInfo, (String)"~#~")))) {
            for (Object checkIdSourceType : checkIdSourceTypeArr) {
                String key;
                String[] metaDataArr = org.apache.commons.lang3.StringUtils.splitByWholeSeparatorPreserveAllTokens((String)checkIdSourceType, (String)"~@~");
                String checkId = StringUtils.getArrValueByIndex((String[])metaDataArr, (int)0);
                String hazsource = StringUtils.getArrValueByIndex((String[])metaDataArr, (int)1);
                String sourceType = StringUtils.getArrValueByIndex((String[])metaDataArr, (int)2);
                if (!"2".equals(sourceType) || !org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)checkId) || !org.apache.commons.lang3.StringUtils.isNumeric((CharSequence)checkId) || !org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)hazsource) || keySet.contains(key = workId + checkId + hazsource + hw.getHarmId())) continue;
                keySet.add((CallSite)((Object)key));
                HarmfactorWorkSource workSource = new HarmfactorWorkSource();
                workSource.setWorkId(workId);
                workSource.setHazardSource(hazsource);
                workSource.setHarmId(hw.getHarmId());
                workSource.setCheckPlanId(Long.valueOf(Long.parseLong(checkId)));
                workSourceList.add(workSource);
            }
        }
        return workSourceList;
    }

    @RequiresPermissions(value={"company.harmfactor.edit"})
    @Log(title="\u5c97\u4f4d\u5371\u5bb3\u56e0\u7d20\u7f16\u8f91", type=21)
    @RepeatUrlFormData
    @RequestMapping(value={"liteSaveHarmfactorWork"})
    @ResponseBody
    public ResponseData<HarmfactorWork> liteSaveHarmfactorWork(Long workHarmfactorId, Long workId, Boolean isClone, String harmIds) {
        List harmIdList;
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long loginStaffId = UserUtils.getLoginStaffId();
        ArrayList<HarmfactorWorkSource> hwsList = new ArrayList<HarmfactorWorkSource>();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)harmIds) && CollectionUtils.isNotEmpty(harmIdList = Arrays.stream(org.apache.commons.lang3.StringUtils.splitByWholeSeparator((String)harmIds, (String)",")).map(p -> Long.parseLong(p)).collect(Collectors.toList()))) {
            for (Long aLong : harmIdList) {
                HarmfactorWorkSource hws = new HarmfactorWorkSource();
                hws.setWorkId(workId);
                hws.setHarmId(aLong);
                hws.setHazardSource("");
                hwsList.add(hws);
            }
        }
        Long orgId = UserUtils.getOrgId();
        ResponseData data = new ResponseData();
        try {
            HarmfactorWork hwork = this.harmfactorWorkService.saveHarmfactorWorkSource(hwsList, null, workId, Byte.valueOf((byte)1), workHarmfactorId, isClone, orgId, loginStaffId, cid);
            data.setContent("\u4fdd\u5b58\u6210\u529f");
            data.setResult((Object)hwork);
        }
        catch (Exception e) {
            data.setState(ResponseStateEnum.fail);
            this.logger.error("\u4fdd\u5b58\u5931\u8d25:" + e.getMessage());
            data.setContent("\u4fdd\u5b58\u5931\u8d25:" + e.getMessage());
        }
        return data;
    }

    @Deprecated
    @RequiresPermissions(value={"company.harmfactor.edit"})
    @Log(title="\u4fdd\u5b58\u5c97\u4f4d\u5371\u5bb3\u56e0\u7d20\u6765\u6e90", type=20)
    @RequestMapping(value={"saveWorkSource"})
    @ResponseBody
    public ResponseData<HarmfactorWork> saveWorkSource(HarmfactorWorkSource wsource, String[] delSource, Long oldHarmId) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long loginStaffId = UserUtils.getLoginStaffId();
        ResponseData resultData = new ResponseData();
        wsource.setCid(cid);
        wsource.setUpdateBy(loginStaffId);
        try {
            this.harmfactorWorkService.updateHarmfactorWorkSourceInfo(wsource, delSource, oldHarmId);
            resultData.setContent("\u4fdd\u5b58\u6210\u529f");
            return resultData;
        }
        catch (Exception e) {
            this.logger.error("\u4fdd\u5b58\u51fa\u9519\uff1a" + e.getMessage());
            resultData.setState(ResponseStateEnum.fail);
            resultData.setContent(e.getMessage());
            return resultData;
        }
    }

    @Deprecated
    @Log(title="\u4fdd\u5b58\u6765\u81ea\u5371\u5bb3\u56e0\u7d20\u91c7\u96c6\u7684\u4fe1\u606f", type=20)
    @RequestMapping(value={"saveWorkSourceByCheckPlan"})
    @ResponseBody
    public ResponseData<HarmfactorWork> saveWorkSourceByCheckPlan(String checkPlanJson) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long loginStaffId = UserUtils.getLoginStaffId();
        ResponseData resultData = new ResponseData();
        List hwsList = JSONArray.parseArray((String)(checkPlanJson = checkPlanJson.replace("&quot;", "\"")), HarmfactorWorkSource.class);
        if (hwsList != null && hwsList.size() > 0) {
            for (HarmfactorWorkSource hws : hwsList) {
                hws.setCid(cid);
                hws.setUpdateBy(loginStaffId);
            }
        }
        try {
            this.harmfactorWorkService.updateHarmfactorWorkSourceInfo(hwsList);
            resultData.setContent("\u4fdd\u5b58\u6210\u529f");
            return resultData;
        }
        catch (Exception e) {
            this.logger.error("\u4fdd\u5b58\u51fa\u9519\uff1a" + e.getMessage());
            resultData.setState(ResponseStateEnum.fail);
            resultData.setContent(e.getMessage());
            return resultData;
        }
    }

    @RequestMapping(value={"/listData"})
    @ResponseBody
    public JqGridData<HarmfactorWorkSourceVo> listData(JqGridParam param, Boolean filterCurrYear) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        PageInfo list = this.harmfactorWorkService.pageHarmfactorWork(param, filterCurrYear);
        if (list != null && list.getList() != null && list.getList().size() > 0) {
            for (int i = 0; i < list.getList().size(); ++i) {
                HarmfactorWorkSourceVo vo = (HarmfactorWorkSourceVo)list.getList().get(i);
                vo.setId(Long.valueOf(vo.getId() + (long)(i * 100000)));
                if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)vo.getHazardSource2())) continue;
                String hazardSource2 = vo.getHazardSource2();
                hazardSource2 = hazardSource2.replaceAll(",{2,}", ",");
                hazardSource2 = hazardSource2.replaceAll("^,", "");
                hazardSource2 = hazardSource2.replaceAll(",$", "");
                vo.setHazardSource2(hazardSource2);
            }
        }
        JqGridData data = new JqGridData(list, param);
        return data;
    }

    @RequiresPermissions(value={"company.harmfactor.view"})
    @RequestMapping(value={"/editWorkInfolistData"})
    @Log(title="\u5c97\u4f4d\u5371\u5bb3\u56e0\u7d20-\u7f16\u8f91\u9875\u9762", type=2)
    @ResponseBody
    public JqGridData<HarmfactorWorkSourceInfoVo> editWorkInfolistData(JqGridParam param, Long workSourceId, String searchKw) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        UserUtils.startWebDataScope();
        PageInfo hwsInfopage = null;
        hwsInfopage = "true".equals(this.isActualize) ? this.harmfactorWorkService.pageActualizeHarmfactorWorkSourceInfoList(param, workSourceId, null) : this.harmfactorWorkService.pageHarmfactorWorkSourceInfoList(param, workSourceId, null);
        JqGridData data = new JqGridData(hwsInfopage, param);
        return data;
    }

    @RequiresPermissions(value={"company.harmfactor.view"})
    @RequestMapping(value={"harmfactorStaffInfoPage"})
    public String harmfactorStaffInfoPage(ModelMap m) {
        return "work/harmfactor/harmfactorStaffInfoPage";
    }

    @RequiresPermissions(value={"company.harmfactor.view"})
    @RequestMapping(value={"/harmfactorStaffListData"})
    @ResponseBody
    public JqGridData<HarmWorkStaffInfoVo> harmfactorStaffListData(JqGridParam gparam, Long workSourceId, String searchKw) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        gparam.setCid(cid);
        UserUtils.startWebDataScope();
        PageInfo page = this.harmfactorWorkService.listHarmfactorStaffInfo(gparam, true);
        JqGridData data = new JqGridData(page, gparam);
        return data;
    }

    @RequiresPermissions(value={"company.harmfactor.view"})
    @RequestMapping(value={"exportHarmfactorStaff"})
    @Log(title="\u5c97\u4f4d\u5371\u5bb3\u56e0\u7d20-\u5bfc\u51fa\u5371\u5bb3\u4eba\u5458", type=24)
    public void exportHarmfactorStaff(JqGridParam gparam, HttpServletRequest request, HttpServletResponse response) throws IOException, ParsePropertyException, InvalidFormatException {
        Long cid = UserUtils.getLoginStaffCompanyId();
        gparam.setCid(cid);
        UserUtils.startWebDataScope();
        PageInfo page = this.harmfactorWorkService.listHarmfactorStaffInfo(gparam, false);
        XLSTransformer transformer = new XLSTransformer();
        String templateDirPath = super.getTemplateFilePath() + "harmfactor/workharmfactorstaff.xls";
        HashMap<String, List> data = new HashMap<String, List>();
        data.put("hwsList", page.getList());
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(templateDirPath));
        Workbook workbook = transformer.transformXLS((InputStream)is, data);
        ExcelUtil.verticalMerged((Workbook)workbook, (int)0, (int)1, (int)0, (int)1);
        ExcelUtil.verticalMerged((Workbook)workbook, (int)0, (int)1, (int)1, (int)1);
        ExcelUtil.verticalMerged((Workbook)workbook, (int)0, (int)1, (int)2, (int)1);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String fileName = "\u5c97\u4f4d\u5de5\u79cd\u63a5\u89e6\u7684\u5371\u5bb3\u56e0\u7d20\u7ba1\u7406\u5217\u8868" + dateFormat.format(new Date()) + ".xls";
        ServletsUtil.setFileDownloadHeader((HttpServletResponse)response, (String)fileName, (HttpServletRequest)request);
        ServletOutputStream os = null;
        try {
            os = response.getOutputStream();
            workbook.write((OutputStream)os);
        }
        catch (FileNotFoundException fe) {
            throw new HealthException("\u7cfb\u7edf\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u6587\u4ef6");
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (is != null) {
                ((InputStream)is).close();
            }
            if (os != null) {
                os.flush();
                os.close();
            }
        }
    }

    @RequiresPermissions(value={"company.harmfactor.view"})
    @RequestMapping(value={"ImportWorkHarm"})
    @Log(title="\u5c97\u4f4d\u5371\u5bb3\u56e0\u7d20-\u5bfc\u5165", type=23)
    @ResponseBody
    public ResponseData<Map<String, Object>> ImportWorkHarm(HttpServletRequest request, Long fileId, String lite) throws Exception {
        ResponseData responseData = new ResponseData();
        if (fileId == null) {
            responseData.setContent("\u6587\u4ef6\u672a\u627e\u5230");
            responseData.setState(ResponseStateEnum.fail);
            return responseData;
        }
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long orgId = UserUtils.getOrgId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        String path = request.getContextPath();
        String basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + path + "/";
        Object ossfile = SysFileUtil.getFileUrlByfid(fileId);
        if (((String)ossfile).startsWith("/file")) {
            ossfile = basePath + (String)ossfile;
        }
        Map resultMap = new HashMap();
        resultMap = "1".equalsIgnoreCase(lite) ? this.harmfactorWorkService.importWorkHarmLite((String)ossfile, loginStaffId, orgId, cid) : this.harmfactorWorkService.importWorkHarm((String)ossfile, loginStaffId, orgId, cid);
        responseData.setResult(resultMap);
        return responseData;
    }

    @RequiresPermissions(value={"company.harmfactor.view"})
    @RequestMapping(value={"workAreaDetailList"})
    @ResponseBody
    public List<HarmfactorWorkAreaSourceVo> workAreaDetailList(JqGridParam jparam, Long hcId, String search, Boolean isFinish, Boolean isAdminModel) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)search)) {
            ArrayList<ParamSeachFieldVO> paramSv = new ArrayList<ParamSeachFieldVO>();
            ParamSeachFieldVO sv = new ParamSeachFieldVO();
            sv.setSearchField("keyword");
            sv.setSearchValue(search);
            paramSv.add(sv);
            jparam.setPostDatas(paramSv);
        }
        List workAreaSourceVoList = this.harmfactorWorkService.workAreaDetailList(jparam, cid, hcId, isFinish, isAdminModel);
        return workAreaSourceVoList;
    }

    @RequiresPermissions(value={"company.harmfactor.view"})
    @RequestMapping(value={"getHarmIdsByWorkId"})
    @ResponseBody
    public Set<Long> getHarmIdsByWorkId(Long workId) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Set harmIdsByWorkId = this.harmfactorWorkService.getHarmIdsByWorkId(cid, workId);
        return harmIdsByWorkId;
    }
}

