/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.work.harmfactor;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.jqgrid.ParamSeachFieldVO;
import cn.smarthse.common.framework.web.repeatform.RepeatUrlFormData;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.easyExcel.ExportEasyExcelUtils;
import cn.smarthse.modules.health.entity.base.occriskfactor.OccupationalRiskFactors;
import cn.smarthse.modules.health.entity.work.harmfactor.HarmfactorArea;
import cn.smarthse.modules.health.entity.work.harmfactor.Vo.HarmfactorAreaSourceHisVo;
import cn.smarthse.modules.health.entity.work.harmfactor.Vo.HarmfactorAreaVo;
import cn.smarthse.modules.health.entity.work.hccheckplan.vo.HcCheckResultValueVo;
import cn.smarthse.modules.health.enums.hccheckplan.ResultCollectTypeEnum;
import cn.smarthse.modules.health.service.base.company.ICompanyAreaService;
import cn.smarthse.modules.health.service.base.occriskfactor.IOccupationalRiskFactorsService;
import cn.smarthse.modules.health.service.work.harmfactor.IHarmfactorAreaService;
import cn.smarthse.modules.health.service.work.harmfactor.IHarmfactorAreaSourceService;
import cn.smarthse.modules.health.service.work.hccheckplan.IHcCheckResultCollectDataService;
import cn.smarthse.modules.health.vo.base.company.AreaHarmFactorCheckVo;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.SysFileUtil;
import cn.smarthse.web.util.UserUtils;
import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.data.ReadCellData;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import com.alibaba.fastjson.JSONArray;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.cn.smarthse.modules.health.exception.BusinessException;
import javax.cn.smarthse.modules.health.exception.HealthException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/work/harmfactor/area"})
public class HarmfactorAreaController
extends ControllerSupport {
    @DubboReference
    private IHarmfactorAreaService harmfactorAreaService;
    @DubboReference
    private IHarmfactorAreaSourceService harmfactorAreaSourceService;
    @DubboReference
    private ICompanyAreaService companyAreaService;
    @DubboReference
    private IHcCheckResultCollectDataService checkResultCollectDataService;
    @DubboReference
    private IOccupationalRiskFactorsService occupationalRiskFactorsService;
    public static final String HARM_SOURCE_HCID_SPARATER = "$###";
    public static final String HARM_SOURCE_SPARATER = "$~~~";

    @RequiresPermissions(value={"company.harmfactor.view"})
    @RequestMapping
    @Log(title="\u533a\u57df\u5371\u5bb3\u56e0\u7d20", type=2)
    public String page_index(HttpSession session, ModelMap m, String keyword) {
        m.put((Object)"keyword", (Object)keyword);
        return "work/harmfactor/index_area";
    }

    @Log(title="\u533a\u57df\u5371\u5bb3\u56e0\u7d20-\u5371\u5bb3\u56e0\u7d20\u91c7\u96c6", type=2)
    @RequiresPermissions(value={"company.harmfactor.view"})
    @RequestMapping(value={"page_harmfactorCollect"})
    public String page_harmfactorCollect(ModelMap m) {
        Date start = DateUtils.StringToDate((String)(DateUtils.getThisYear() + "-1-1"));
        Date end = DateUtils.StringToDate((String)(DateUtils.getThisYear() + "-12-31"));
        m.put((Object)"start", (Object)start);
        m.put((Object)"end", (Object)end);
        return "work/harmfactor/harmfactor_collect2";
    }

    @Log(title="\u533a\u57df\u5371\u5bb3\u56e0\u7d20-\u7f16\u8f91\u9875\u9762", type=2)
    @RequiresPermissions(value={"company.harmfactor.edit"})
    @RequestMapping(value={"/editHarmfactorAreaPage"})
    public String editHarmfactorAreaPage(HttpSession session, Long areaId, Boolean isClone, ModelMap m) {
        if (!(isClone != null && isClone.booleanValue() || areaId == null)) {
            String areaName = this.companyAreaService.getAreaNamesByAreaIds("" + areaId);
            m.put((Object)"areaName", (Object)areaName);
            m.put((Object)"areaId", (Object)areaId);
        }
        return "work/harmfactor/editHarmfactorArea";
    }

    @RequiresPermissions(value={"company.harmfactor.view"})
    @RequestMapping(value={"/listData"})
    @ResponseBody
    public JqGridData<HarmfactorAreaVo> listData(JqGridParam param, String searchKw) {
        PageInfo list;
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)searchKw) && (param.getPostDatas() == null || param.getPostDatas().isEmpty())) {
            ParamSeachFieldVO vo = new ParamSeachFieldVO("searchKw", searchKw);
            vo.setSearchOper("like");
            param.getPostDatas().add(vo);
        }
        if ((list = this.harmfactorAreaService.pageHarmfactorArea(param, null)) != null && list.getList() != null && list.getList().size() > 0) {
            for (HarmfactorAreaVo havo : list.getList()) {
                Long areaId = havo.getAreaId();
                String areaName = this.companyAreaService.getAreaNamesByAreaIds("" + areaId);
                havo.setAreaName(areaName);
            }
        }
        JqGridData data = new JqGridData(list, param);
        return data;
    }

    @RequiresPermissions(value={"company.harmfactor.view"})
    @RequestMapping(value={"exportHarmfactorArea"})
    @Log(title="\u533a\u57df\u5371\u5bb3\u56e0\u7d20-\u5bfc\u51fa", type=24)
    public void exportHarmfactorWork(JqGridParam param, Long hcplanId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        param.setRows(10000000);
        UserUtils.startWebDataScope();
        PageInfo list = this.harmfactorAreaService.pageHarmfactorArea(param, null);
        if (list != null && list.getList() != null && list.getList().size() > 0) {
            for (HarmfactorAreaVo havo : list.getList()) {
                Object[] sourceHcidArr;
                Long areaId = havo.getAreaId();
                String areaName = this.companyAreaService.getAreaNamesByAreaIds("" + areaId);
                havo.setAreaName(areaName);
                if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)havo.getHarmSource()) || !ArrayUtils.isNotEmpty((Object[])(sourceHcidArr = org.apache.commons.lang3.StringUtils.splitByWholeSeparator((String)havo.getHarmSource(), (String)HARM_SOURCE_HCID_SPARATER)))) continue;
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < sourceHcidArr.length; ++i) {
                    Object sourceHcid = sourceHcidArr[i];
                    Object[] sourceArr = org.apache.commons.lang3.StringUtils.splitByWholeSeparator((String)sourceHcid, (String)HARM_SOURCE_SPARATER);
                    if (!ArrayUtils.isNotEmpty((Object[])sourceArr)) continue;
                    sb.append((String)sourceArr[0]);
                }
                havo.setHarmSource(sb.toString());
            }
        }
        String templateFileName = super.getTemplateFilePath() + "harmfactor/areaharmfactor.xls";
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String resultFileName = "\u5de5\u4f5c\u573a\u6240\u5b58\u5728\u7684\u5371\u5bb3\u56e0\u7d20\u7ba1\u7406\u5217\u8868" + dateFormat.format(new Date()) + ".xls";
        ExportEasyExcelUtils.downloadTempByEasyExcel((String)resultFileName, (String)templateFileName, (List)list.getList(), (HttpServletResponse)response, (HttpServletRequest)request, (Converter)new Converter<Long>(){

            public Class supportJavaTypeKey() {
                return Long.class;
            }

            public CellDataTypeEnum supportExcelTypeKey() {
                return CellDataTypeEnum.STRING;
            }

            public Long convertToJavaData(ReadCellData cellData, ExcelContentProperty excelContentProperty, GlobalConfiguration globalConfiguration) throws Exception {
                if (StringUtils.isNumeric((CharSequence)cellData.getStringValue())) {
                    return Long.parseLong(cellData.getStringValue());
                }
                return null;
            }

            public WriteCellData convertToExcelData(Long o, ExcelContentProperty excelContentProperty, GlobalConfiguration globalConfiguration) throws Exception {
                if (o != null) {
                    return new WriteCellData(o.toString());
                }
                return new WriteCellData("");
            }
        });
    }

    @RequiresPermissions(value={"company.harmfactor.view"})
    @RequestMapping(value={"/editHarmfactorAreaListData"})
    @ResponseBody
    public JqGridData<HarmfactorAreaVo> editHarmfactorAreaListData(JqGridParam param, Long areaId) {
        if (areaId == null) {
            return new JqGridData(new PageInfo(), param);
        }
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        PageInfo list = this.harmfactorAreaService.pageHarmfactorArea(param, areaId);
        JqGridData data = new JqGridData(list, param);
        return data;
    }

    @RequiresPermissions(value={"company.harmfactor.view"})
    @RequestMapping(value={"page_harmfactorAreaEdit"})
    public String page_harmfactorWorkEdit(Long areaId, Long harmId, ModelMap m, JqGridParam param) {
        return "work/harmfactor/dialog_harmfactorAreaEdit";
    }

    @RequiresPermissions(value={"company.harmfactor.edit"})
    @Log(title="\u533a\u57df\u5371\u5bb3\u56e0\u7d20\u5220\u9664", type=22)
    @RequestMapping(value={"/delHarmfactorArea"})
    @ResponseBody
    @RepeatUrlFormData
    public ResponseData<HarmfactorArea> delHarmfactorArea(Long areaId) {
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        ResponseData data = new ResponseData();
        try {
            this.harmfactorAreaService.delHarmfactorArea(areaId, loginStaffId, cid);
            data.setContent("\u5220\u9664\u6210\u529f");
        }
        catch (BusinessException e) {
            data.setContent("\u5220\u9664\u5931\u8d25:" + e.getMessage());
            data.setState(ResponseStateEnum.fail);
        }
        catch (Exception e) {
            data.setState(ResponseStateEnum.fail);
            this.logger.error(e.getMessage());
        }
        return data;
    }

    @RequiresPermissions(value={"company.harmfactor.edit"})
    @Log(title="\u533a\u57df\u5371\u5bb3\u56e0\u7d20\u514b\u9686", type=20)
    @RequestMapping(value={"/saveCloneHarmfactorArea"})
    @ResponseBody
    @RepeatUrlFormData
    public ResponseData<HarmfactorArea> saveCloneHarmfactorArea(Long clonedAreaId, Long newAreaId) {
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long orgId = UserUtils.getOrgId();
        ResponseData data = new ResponseData();
        try {
            this.harmfactorAreaService.saveCloneHarmfactorArea(clonedAreaId, newAreaId, orgId, loginStaffId, cid);
            data.setContent("\u514b\u9686\u6210\u529f");
        }
        catch (BusinessException e) {
            data.setContent("\u514b\u9686\u5931\u8d25:" + e.getMessage());
            data.setState(ResponseStateEnum.fail);
        }
        catch (Exception e) {
            data.setState(ResponseStateEnum.fail);
            this.logger.error(e.getMessage());
        }
        return data;
    }

    @RequiresPermissions(value={"company.harmfactor.edit"})
    @Log(title="\u533a\u57df\u5371\u5bb3\u56e0\u7d20\u7f16\u8f91", type=21)
    @RequestMapping(value={"changeHarmfactorArea"})
    @ResponseBody
    @RepeatUrlFormData
    public ResponseData<HarmfactorArea> changeHarmfactorArea(Long areaId, Long oldAreaId, Boolean isClone, String datas) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long loginStaffId = UserUtils.getLoginStaffId();
        List haList = JSONArray.parseArray((String)(datas = StringEscapeUtils.unescapeHtml((String)datas)), HarmfactorArea.class);
        if (haList != null && !haList.isEmpty() && isClone != null && isClone.booleanValue()) {
            for (HarmfactorArea ha : haList) {
                ha.setId(null);
            }
        }
        Long orgId = UserUtils.getOrgId();
        if (CollectionUtils.isNotEmpty((Collection)haList)) {
            haList.forEach(h -> {
                if (h.getId() == null) {
                    h.setOrgId(orgId);
                }
            });
        }
        ResponseData data = new ResponseData();
        try {
            this.harmfactorAreaService.changeHarmfactorArea(haList, areaId, oldAreaId, loginStaffId, cid);
            data.setContent("\u4fdd\u5b58\u6210\u529f");
        }
        catch (BusinessException e) {
            data.setContent("\u4fdd\u5b58\u5931\u8d25:" + e.getMessage());
            data.setState(ResponseStateEnum.warning);
            this.logger.error("\u4fdd\u5b58\u5931\u8d25:" + e.getMessage());
        }
        catch (HealthException e) {
            data.setState(ResponseStateEnum.warning);
            this.logger.error("\u4fdd\u5b58\u5931\u8d25:" + e.getMessage());
            data.setContent("\u4fdd\u5b58\u5931\u8d25:" + e.getMessage());
        }
        catch (Exception e) {
            data.setState(ResponseStateEnum.fail);
            this.logger.error("\u4fdd\u5b58\u5931\u8d25:" + e.getMessage());
            data.setContent("\u4fdd\u5b58\u5931\u8d25:" + e.getMessage());
        }
        return data;
    }

    @RequiresPermissions(value={"company.harmfactor.view"})
    @RequestMapping(value={"ImportAreaHarm"})
    @Log(title="\u533a\u57df\u5371\u5bb3\u56e0\u7d20-\u5bfc\u5165", type=23)
    @ResponseBody
    public ResponseData<Map<String, Object>> ImportAreaHarm(HttpServletRequest request, Long fileId) {
        ResponseData responseData = new ResponseData();
        if (fileId == null) {
            responseData.setContent("\u6587\u4ef6\u672a\u627e\u5230");
            responseData.setState(ResponseStateEnum.fail);
            return responseData;
        }
        Long loginStaffId = UserUtils.getLoginStaffId();
        Long orgId = UserUtils.getOrgId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        String path = request.getContextPath();
        String basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + path + "/";
        Object ossfile = SysFileUtil.getFileUrlByfid(fileId);
        if (((String)ossfile).startsWith("/file")) {
            ossfile = basePath + (String)ossfile;
        }
        try {
            Map resultMap = this.harmfactorAreaService.importAreaHarm((String)ossfile, loginStaffId, orgId, cid);
            responseData.setResult((Object)resultMap);
        }
        catch (Exception e) {
            responseData.setContent("\u53d1\u751f\u9519\u8bef\uff1a" + e.getMessage());
            responseData.setState(ResponseStateEnum.fail);
        }
        return responseData;
    }

    @RequestMapping(value={"/listHarmArea"})
    @ResponseBody
    public List<HarmfactorAreaVo> listHarmArea(String searchKw, String harmTypes) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        List list = this.harmfactorAreaService.listDistinctFactorAreas(cid, searchKw, harmTypes);
        return list;
    }

    @RequestMapping(value={"/getHarmIdByArea"})
    @ResponseBody
    public Set<Long> getHarmIdByArea(String areaids) {
        List list;
        List<String> strList;
        Long cid = UserUtils.getLoginStaffCompanyId();
        List<Object> areaidList = new ArrayList();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)areaids) && CollectionUtils.isNotEmpty(strList = Arrays.asList(org.apache.commons.lang3.StringUtils.splitByWholeSeparator((String)areaids, (String)",")))) {
            areaidList = strList.stream().map(m -> Long.valueOf(m)).collect(Collectors.toList());
        }
        if (CollectionUtils.isNotEmpty((Collection)(list = this.harmfactorAreaService.listHarmFactorArea2(cid, areaidList, "\u7c89\u5c18,\u5316\u5b66\u56e0\u7d20")))) {
            Set<Long> harmIdSet = list.stream().map(AreaHarmFactorCheckVo::getId).collect(Collectors.toSet());
            return harmIdSet;
        }
        return Collections.emptySet();
    }

    @RequiresPermissions(value={"company.harmfactor.view"})
    @RequestMapping(value={"showAreaHisPage"})
    public String showAreaHisPage(ModelMap m, Long areaId) {
        m.put((Object)"areaId", (Object)areaId);
        return "work/harmfactor/dialog_areaHisPage";
    }

    @RequiresPermissions(value={"company.harmfactor.view"})
    @RequestMapping(value={"showAreaHisListData"})
    @ResponseBody
    public JqGridData<HarmfactorAreaSourceHisVo> showAreaHisListData(JqGridParam jparam, Long areaId) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        PageInfo harmfactorAreaSourceHisVoPageInfo = this.harmfactorAreaService.pageAreaHisData(jparam, cid, areaId);
        JqGridData data = new JqGridData(harmfactorAreaSourceHisVoPageInfo, jparam);
        return data;
    }

    @RequiresPermissions(value={"company.harmfactor.view"})
    @RequestMapping(value={"dialog_hccheckResult"})
    public String dialog_hccheckResult(ModelMap m, Long hcId, Long harmId) {
        m.put((Object)"hcId", (Object)hcId);
        m.put((Object)"harmId", (Object)harmId);
        return "work/harmfactor/dialog_hccheckResult";
    }

    @RequiresPermissions(value={"company.harmfactor.view"})
    @RequestMapping(value={"hccheckResultListData"})
    @ResponseBody
    public JqGridData<HcCheckResultValueVo> hccheckResultListData(JqGridParam jparam, Long hcId, Long harmId) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        PageInfo checkResultValuesByHcIdAndHarmIdPage = this.checkResultCollectDataService.getCheckResultValuesByHcIdAndHarmIdPage(jparam, hcId, harmId);
        JqGridData data = new JqGridData(checkResultValuesByHcIdAndHarmIdPage, jparam);
        return data;
    }

    @RequiresPermissions(value={"company.harmfactor.view"})
    @RequestMapping(value={"viewHccSource"})
    @Log(title="\u533a\u57df\u5371\u5bb3\u56e0\u7d20-\u5371\u5bb3\u56e0\u7d20\u6765\u6e90\u67e5\u770b", type=2)
    public String viewHccSource(ModelMap m, Long workHarmfactorId, Long checkPlanId, Long harmId) {
        OccupationalRiskFactors orf = (OccupationalRiskFactors)this.occupationalRiskFactorsService.getById(harmId);
        Integer collectType = null;
        if (orf != null && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)orf.getType())) {
            collectType = "\u5316\u5b66\u56e0\u7d20".equals(orf.getType().trim()) ? ResultCollectTypeEnum.CHEMICAL.getCode() : ("\u7c89\u5c18".equals(orf.getType().trim()) ? ResultCollectTypeEnum.DUST.getCode() : ("\u751f\u7269\u56e0\u7d20".equals(orf.getType().trim()) ? ResultCollectTypeEnum.BIOLOGICAL.getCode() : ResultCollectTypeEnum.getCodeByParamCode((String)orf.getParamcode())));
        }
        m.put((Object)"collectType", collectType);
        m.put((Object)"hcId", (Object)checkPlanId);
        m.put((Object)"harmId", (Object)harmId);
        if (collectType != null && collectType < 18) {
            ResultCollectTypeEnum r = ResultCollectTypeEnum.getResultTypeByCode((Integer)collectType);
            return "work/harmfactor/hccheckplan/" + r.getHarmManagerPage();
        }
        return "";
    }
}

