/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.work.harmfactor;

import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.write.merge.AbstractMergeStrategy;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;

public class CustomMergeStrategy
extends AbstractMergeStrategy {
    private List<Integer> exportFieldGroupCountList;
    private Integer targetColumnIndex;
    private Integer rowIndex;

    public CustomMergeStrategy(List<String> exportDataList, Integer targetColumnIndex) {
        this.exportFieldGroupCountList = this.getGroupCountList(exportDataList);
        this.targetColumnIndex = targetColumnIndex;
    }

    protected void merge(Sheet sheet, Cell cell, Head head, Integer relativeRowIndex) {
        if (null == this.rowIndex) {
            this.rowIndex = cell.getRowIndex();
        }
        if (cell.getRowIndex() == this.rowIndex.intValue() && Objects.equals(cell.getColumnIndex(), this.targetColumnIndex)) {
            this.mergeGroupColumn(sheet, cell.getColumnIndex());
        }
    }

    private void mergeGroupColumn(Sheet sheet, Integer targetColumnIndex) {
        int rowCount = this.rowIndex;
        for (Integer count : this.exportFieldGroupCountList) {
            if (count == 1) {
                rowCount += count.intValue();
                continue;
            }
            CellRangeAddress cellRangeAddress = new CellRangeAddress(rowCount, rowCount + count - 1, targetColumnIndex.intValue(), targetColumnIndex.intValue());
            sheet.addMergedRegionUnsafe(cellRangeAddress);
            rowCount += count.intValue();
        }
    }

    private List<Integer> getGroupCountList(List<String> exportDataList) {
        if (CollectionUtils.isEmpty(exportDataList)) {
            return new ArrayList<Integer>();
        }
        ArrayList<Integer> groupCountList = new ArrayList<Integer>();
        int count = 1;
        for (int i = 1; i < exportDataList.size(); ++i) {
            if (exportDataList.get(i).equals(exportDataList.get(i - 1))) {
                ++count;
                continue;
            }
            groupCountList.add(count);
            count = 1;
        }
        groupCountList.add(count);
        return groupCountList;
    }
}

