/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.work.harmFactorDeclare;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.excel.ExportExcel;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.web.repeatform.RepeatUrlFormData;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.modules.datacentre.model.CompanyBaseInfoModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideByHSEService;
import cn.smarthse.modules.health.entity.work.check.vo.PhcYearCheckInfo;
import cn.smarthse.modules.health.entity.work.harmFactorDeclare.HarmFactorDeclare;
import cn.smarthse.modules.health.entity.work.harmFactorDeclare.HarmFactorDeclareVO;
import cn.smarthse.modules.health.entity.work.harmfactor.HarmfactorWork;
import cn.smarthse.modules.health.enums.company.CompanySizeEnum;
import cn.smarthse.modules.health.param.SearchParam;
import cn.smarthse.modules.health.service.base.ICompanyService;
import cn.smarthse.modules.health.service.base.company.ICompanyFunctionalOrganizationService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.work.check.IPhcOccupationalDiseaserService;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckHarmDeclareService;
import cn.smarthse.modules.health.service.work.harmFactorDeclare.IHarmFactorDeclareService;
import cn.smarthse.modules.health.service.work.harmfactor.IHarmfactorWorkService;
import cn.smarthse.modules.health.vo.base.company.CompanyFunOrgVo;
import cn.smarthse.modules.health.vo.work.check.CheckHarmDeclareVO;
import cn.smarthse.modules.health.vo.work.harmFactorDeclare.CompanyDecBaseInfoVo;
import cn.smarthse.modules.health.vo.work.harmFactorDeclare.DeclareHarmWorkNewVo;
import cn.smarthse.services.hfi.api.pojo.vo.FactorTypeCheckPointVo;
import cn.smarthse.services.hfi.api.service.ICheckResultService;
import cn.smarthse.services.wanda.api.entity.WandaDeclare;
import cn.smarthse.services.wanda.api.service.IWandaDeclareService;
import cn.smarthse.util.common.date.DateUtils;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/work/harmFactorDeclare"})
public class HarmFactorDeclareController
extends ControllerSupport {
    @DubboReference
    private IWandaDeclareService wandaDeclareService;
    @DubboReference
    private IHarmFactorDeclareService harmFactorDeclareService;
    @DubboReference
    ICompanyService companyService;
    @DubboReference
    private IStaffInfoService staffInfoService;
    @DubboReference
    private IPhcOccupationalDiseaserService phcOccupationalDiseaserService;
    @DubboReference
    private ICompanyFunctionalOrganizationService companyFunctionalOrganizationService;
    @DubboReference
    private IHarmfactorWorkService harmfactorWorkService;
    @DubboReference(version="1.0.0")
    ICompanyProvideByHSEService companyProvideByHSEService;
    @DubboReference
    ICheckResultService checkResultService;
    @DubboReference
    IPhcPhysicalCheckHarmDeclareService phcPhysicalCheckHarmDeclareService;

    @RequiresPermissions(value={"harmFactorDeclare.view"})
    @RequestMapping
    public String index(HarmFactorDeclare info, HttpSession session, ModelMap m, Integer year) {
        this.logger.info("\u804c\u4e1a\u75c5\u5371\u5bb3\u9879\u76ee\u7533\u62a5\u6c47\u603b");
        m.put((Object)"year", (Object)year);
        return "work/harmFactorDeclare/finishedHarmFactorDeclare";
    }

    @ResponseBody
    @RequestMapping(value={"listFinishedData"})
    public JqGridData<HarmFactorDeclare> listFinishedData(JqGridParam param, HarmFactorDeclareVO info, HttpSession session, ModelMap m) {
        this.logger.info("\u5df2\u5b8c\u6210\u7684\u804c\u4e1a\u75c5\u5371\u5bb3\u9879\u76ee\u7533\u62a5\u6e05\u5355");
        Long cid = UserUtils.getLoginStaffCompanyId();
        info.setCid(cid);
        info.setStatus(Byte.valueOf((byte)2));
        UserUtils.startWebDataScope();
        PageInfo page = this.harmFactorDeclareService.getHarmFactorDeclareList(param, info);
        JqGridData data = new JqGridData(page, param);
        return data;
    }

    @RequiresPermissions(value={"harmFactorDeclare.view"})
    @RequestMapping(value={"unFinished"})
    public String unFinished(HttpSession session, ModelMap m, Integer year) {
        this.logger.info("\u804c\u4e1a\u75c5\u5371\u5bb3\u9879\u76ee\u7533\u62a5\u672a\u5b8c\u6210\u5de5\u4f5c");
        m.put((Object)"year", (Object)year);
        return "work/harmFactorDeclare/unFinishedHarmFactorDeclare";
    }

    @ResponseBody
    @RequestMapping(value={"listUnFinishedData"})
    public JqGridData<HarmFactorDeclare> listUnFinishedData(JqGridParam param, HarmFactorDeclareVO info, HttpSession session, ModelMap m) {
        this.logger.info("\u672a\u5b8c\u6210\u5b8c\u6210\u804c\u4e1a\u75c5\u5371\u5bb3\u9879\u76ee\u7533\u62a5\u6e05\u5355");
        Long cid = UserUtils.getLoginStaffCompanyId();
        info.setCid(cid);
        info.setStatus(Byte.valueOf((byte)1));
        UserUtils.startWebDataScope();
        PageInfo page = this.harmFactorDeclareService.getHarmFactorDeclareList(param, info);
        JqGridData data = new JqGridData(page, param);
        return data;
    }

    @RequiresPermissions(value={"harmFactorDeclare.edit"})
    @RequestMapping(value={"/addHarmFacDec"}, method={RequestMethod.GET})
    public String addHarmFacDec(HttpSession session, ModelMap m, Byte fromThird, Long workId) {
        HarmFactorDeclare data = new HarmFactorDeclare();
        if (fromThird != null) {
            data.setFromType(fromThird);
            data.setFromId(workId);
        }
        m.put((Object)"data", (Object)data);
        m.put((Object)"addOrEdit", (Object)1);
        return "work/harmFactorDeclare/addHarmFactorDeclare";
    }

    @RequiresPermissions(value={"harmFactorDeclare.edit"})
    @Log(title="\u65b0\u589e/\u7f16\u8f91\u804c\u4e1a\u75c5\u5371\u5bb3\u9879\u76ee\u7533\u62a5\u4fe1\u606f", type=20)
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public ResponseData<HarmFactorDeclare> add(HttpServletRequest request, ModelMap m, HarmFactorDeclare info, Byte finish) {
        ResponseData data = new ResponseData();
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffid = UserUtils.getLoginStaffId();
        Long orgId = UserUtils.getOrgId();
        if (info.getId() == null && StringUtils.isEmpty((CharSequence)info.getOrgId())) {
            info.setOrgId("" + UserUtils.getOrgId());
        }
        String[] feedbackFileids = request.getParameterValues("feedbackFile");
        String[] declareFileids = request.getParameterValues("declareFile");
        Object feedids = new String();
        if (feedbackFileids != null && feedbackFileids.length != 0) {
            for (int a = 0; a < feedbackFileids.length; ++a) {
                feedids = feedbackFileids[a] + "," + (String)feedids;
            }
            info.setFeedbackFile((String)feedids);
        } else {
            info.setFeedbackFile(",");
        }
        Object declids = new String();
        if (declareFileids != null && declareFileids.length != 0) {
            for (int a = 0; a < declareFileids.length; ++a) {
                declids = declareFileids[a] + "," + (String)declids;
            }
            info.setDeclareFile((String)declids);
        } else {
            info.setDeclareFile(",");
        }
        if (finish != null) {
            info.setStatus(finish);
        }
        if (info.getId() != null) {
            info.setCid(cid);
            info = this.harmFactorDeclareService.updateWithCoreWork(info, staffid);
            data.setResult((Object)info);
        } else {
            info = this.harmFactorDeclareService.addWithCoreWork(info, staffid, cid);
            data.setResult((Object)info);
        }
        data.setContent("\u4fdd\u5b58\u6210\u529f\uff01");
        return data;
    }

    @RequiresPermissions(value={"harmFactorDeclare.edit"})
    @RequestMapping(value={"/editHarmFacDec"}, method={RequestMethod.GET})
    public String editHarmFacDec(Long id, HttpSession session, ModelMap m) {
        HarmFactorDeclare data = (HarmFactorDeclare)this.harmFactorDeclareService.getById(id);
        List feedbackFileids = new ArrayList();
        List declareFileids = new ArrayList();
        feedbackFileids = StringUtils.parseToLongList((String)data.getFeedbackFile(), (String)",");
        declareFileids = StringUtils.parseToLongList((String)data.getDeclareFile(), (String)",");
        m.put((Object)"data", (Object)data);
        m.put((Object)"feedbackFileids", feedbackFileids);
        m.put((Object)"declareFileids", declareFileids);
        m.put((Object)"addOrEdit", (Object)2);
        return "work/harmFactorDeclare/addHarmFactorDeclare";
    }

    @RequiresPermissions(value={"harmFactorDeclare.view"})
    @RequestMapping(value={"/viewHarmFacDec"}, method={RequestMethod.GET})
    public String viewHarmFacDec(Long id, Boolean isList, HttpSession session, ModelMap m) {
        HarmFactorDeclare data = (HarmFactorDeclare)this.harmFactorDeclareService.getById(id);
        List feedbackFileids = new ArrayList();
        List declareFileids = new ArrayList();
        feedbackFileids = StringUtils.parseToLongList((String)data.getFeedbackFile(), (String)",");
        declareFileids = StringUtils.parseToLongList((String)data.getDeclareFile(), (String)",");
        m.put((Object)"isList", (Object)isList);
        m.put((Object)"data", (Object)data);
        m.put((Object)"feedbackFileids", feedbackFileids);
        m.put((Object)"declareFileids", declareFileids);
        return "work/harmFactorDeclare/viewHarmFactorDeclare";
    }

    @RequiresPermissions(value={"harmFactorDeclare.edit"})
    @Log(title="\u5220\u9664\u804c\u4e1a\u75c5\u5371\u5bb3\u9879\u76ee\u7533\u62a5\u8bb0\u5f55", type=22)
    @ResponseBody
    @RequestMapping(value={"/delete"}, method={RequestMethod.DELETE})
    public ResponseData<Integer> ajax_delete(Long id) {
        this.logger.info("ajax-\u3010\u3011-\u5220\u9664\u8bb0\u5f55:" + id);
        Long staffid = UserUtils.getLoginStaffId();
        ResponseData data = new ResponseData();
        HarmFactorDeclare info = (HarmFactorDeclare)this.harmFactorDeclareService.getById(id);
        info.setIsValid(Boolean.valueOf(false));
        this.harmFactorDeclareService.updateWithCoreWork(info, staffid);
        data.setContent("\u5220\u9664\u6210\u529f");
        return new ResponseData();
    }

    @RequiresPermissions(value={"harmFactorDeclare.view"})
    @RequestMapping(value={"/dataReference"}, method={RequestMethod.GET})
    public String dataReference(Integer way, HttpSession session, ModelMap m) {
        m.put((Object)"way", (Object)way);
        long cid = UserUtils.getLoginStaffCompanyId();
        CompanyBaseInfoModel companyBaseInfoModel = this.companyProvideByHSEService.getCompanyById(Long.valueOf(cid));
        Company company = new Company();
        try {
            BeanUtils.copyProperties((Object)company, (Object)companyBaseInfoModel);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        company.setId(companyBaseInfoModel.getCid());
        m.put((Object)"registerTypeName", (Object)companyBaseInfoModel.getRegisterTypeName());
        m.put((Object)"industryCategoryName", (Object)companyBaseInfoModel.getIndustryCategoryName());
        if (company.getStaffCount() == null) {
            Integer staffCount = this.staffInfoService.getStaffOnWorkCountByCid(Long.valueOf(cid));
            company.setStaffCount(staffCount);
        }
        String scale = "";
        if (StringUtils.isNotBlank((CharSequence)company.getScale()) && StringUtils.isNumeric((CharSequence)company.getScale()) && Long.parseLong(company.getScale()) < 5L) {
            String scaleName;
            scale = scaleName = CompanySizeEnum.getName((Byte)Byte.parseByte(company.getScale()));
        } else if (StringUtils.isBlank((CharSequence)company.getScale()) && company.getMainOperaIncome() != null && company.getStaffCount() != null) {
            Integer staffCount = company.getStaffCount();
            String scaleValue = "";
            BigDecimal mainOperaIncome = company.getMainOperaIncome();
            if (staffCount >= 1000) {
                if (mainOperaIncome.compareTo(new BigDecimal(40000)) >= 0) {
                    scale = "\u5927\u578b";
                    scaleValue = "1";
                } else {
                    scale = "\u4e2d\u578b";
                    scaleValue = "2";
                }
            } else if (300 <= staffCount && staffCount < 1000) {
                if (mainOperaIncome.compareTo(new BigDecimal(2000)) <= 0) {
                    scale = "\u4e2d\u578b";
                    scaleValue = "2";
                } else {
                    scale = "\u5c0f\u578b";
                    scaleValue = "3";
                }
            } else if (20 <= staffCount && staffCount < 300) {
                if (mainOperaIncome.compareTo(new BigDecimal(40000)) >= 0) {
                    scale = "\u4e2d\u578b";
                    scaleValue = "2";
                } else if (mainOperaIncome.compareTo(new BigDecimal(40000)) < 0 && mainOperaIncome.compareTo(new BigDecimal(300)) >= 0) {
                    scale = "\u5c0f\u578b";
                    scaleValue = "3";
                } else {
                    scale = "\u5fae\u578b";
                    scaleValue = "4";
                }
            } else if (20 > staffCount) {
                if (mainOperaIncome.compareTo(new BigDecimal(40000)) >= 0) {
                    scale = "\u4e2d\u578b";
                    scaleValue = "2";
                } else if (mainOperaIncome.compareTo(new BigDecimal(40000)) < 0 && mainOperaIncome.compareTo(new BigDecimal(2000)) >= 0) {
                    scale = "\u5c0f\u578b";
                    scaleValue = "3";
                } else {
                    scale = "\u5fae\u578b";
                    scaleValue = "4";
                }
            }
            company.setScale(scaleValue);
        }
        m.put((Object)"scaleName", (Object)scale);
        PhcYearCheckInfo info = new PhcYearCheckInfo();
        info.setCid(Long.valueOf(cid));
        Integer diseasesNum = this.phcOccupationalDiseaserService.countYearDiseasers(info);
        m.put((Object)"diseasesNum", (Object)diseasesNum);
        CompanyFunOrgVo companyFunOrgVo = this.companyFunctionalOrganizationService.getEHSBasicInfo(Long.valueOf(cid));
        m.put((Object)"companyFunOrgVo", (Object)companyFunOrgVo);
        Integer occupationalNum = this.harmfactorWorkService.countHarmNumByCid(Long.valueOf(cid));
        m.put((Object)"occupationalNum", (Object)occupationalNum);
        Integer occupationalStaffNum = this.harmfactorWorkService.getOccupationalStaffNumByCid(cid);
        if (company.getPickupCount() == null || company.getPickupCount() == 0) {
            company.setPickupCount(occupationalStaffNum);
        }
        m.put((Object)"company", (Object)company);
        return "work/harmFactorDeclare/declareDataRefrence";
    }

    @RequiresPermissions(value={"harmFactorDeclare.view"})
    @RequestMapping(value={"/companyDeclareInfoNew"}, method={RequestMethod.GET})
    public String companyDeclareInfoNew(HttpSession session, ModelMap m) {
        long cid = UserUtils.getLoginStaffCompanyId();
        CompanyBaseInfoModel companyBaseInfoModel = this.companyProvideByHSEService.getCompanyById(Long.valueOf(cid));
        m.put((Object)"company", (Object)companyBaseInfoModel);
        DeclareHarmWorkNewVo declareHarmWorkNewVo = this.harmfactorWorkService.collectDeclareHarmWorkNum(Long.valueOf(cid));
        m.put((Object)"declareHarmWorkNewVo", (Object)declareHarmWorkNewVo);
        CompanyDecBaseInfoVo companyDecBaseInfo = this.harmFactorDeclareService.getCompanyDecBaseInfo(Long.valueOf(cid));
        m.put((Object)"companyDecBaseInfo", (Object)companyDecBaseInfo);
        List factorTypeCheckPointVos = this.checkResultService.queryFactorTypeCheckPoint(Long.valueOf(cid), Integer.valueOf(DateUtils.getYear()));
        boolean hasCheck = false;
        if (CollectionUtils.isNotEmpty((Collection)factorTypeCheckPointVos)) {
            for (FactorTypeCheckPointVo factorTypeCheckPointVo : factorTypeCheckPointVos) {
                if (factorTypeCheckPointVo.getCheckPoint() == null || factorTypeCheckPointVo.getCheckPoint() <= 0) continue;
                hasCheck = true;
                break;
            }
        }
        m.put((Object)"hasCheck", (Object)hasCheck);
        m.put((Object)"factorTypeCheckPointVos", (Object)factorTypeCheckPointVos);
        CheckHarmDeclareVO checkHarmDeclareVO = this.phcPhysicalCheckHarmDeclareService.harmDeclareCheck(Long.valueOf(cid), DateUtils.getYear());
        m.put((Object)"checkHarmDeclareVO", (Object)checkHarmDeclareVO);
        return "work/harmFactorDeclare/companyDeclareInfoNew";
    }

    @ResponseBody
    @RequestMapping(value={"lishHarmFactor"})
    public JqGridData<HarmfactorWork> lishHarmFactor(JqGridParam param, HttpSession session, ModelMap m) {
        this.logger.info("\u672a\u5b8c\u6210\u7533\u62a5\u6e05\u5355");
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        PageInfo page = this.harmfactorWorkService.getHarmFactorWithWork(param);
        JqGridData data = new JqGridData(page, param);
        return data;
    }

    @RequiresPermissions(value={"harmFactorDeclare.view"})
    @Log(title="\u5bfc\u51fa\u5df2\u5b8c\u6210\u7533\u62a5\u6e05\u5355", type=24)
    @RequestMapping(value={"export"})
    public void exportManagerCert(HttpServletResponse response) throws Exception {
        this.logger.info("ajax-\u3010\u5df2\u5b8c\u6210\u804c\u4e1a\u75c5\u5371\u5bb3\u9879\u76ee\u7533\u62a5\u3011-\u5bfc\u51faExcel");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String fileName = "\u5df2\u5b8c\u6210\u804c\u4e1a\u75c5\u5371\u5bb3\u9879\u76ee\u7533\u62a5" + dateFormat.format(new Date()) + ".xls";
        Long cid = UserUtils.getLoginStaffCompanyId();
        String[] colums = new String[]{"\u5e8f\u53f7|serialNum", "\u540d\u79f0|workName", "\u7533\u62a5\u65e5\u671f|declareDate", "\u66f4\u65b0\u65f6\u95f4|updateDate"};
        HarmFactorDeclareVO info = new HarmFactorDeclareVO();
        info.setCid(cid);
        info.setStatus(Byte.valueOf((byte)2));
        UserUtils.startWebDataScope();
        List list = this.harmFactorDeclareService.getListByInfo(info);
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-Disposition", "attachment;filename=" + new String(fileName.getBytes("GBK"), "ISO8859_1"));
        response.setContentType("application/octet-stream; charset=GBK");
        ExportExcel listexcel = new ExportExcel();
        listexcel.simpleExport3("\u5df2\u5b8c\u6210\u804c\u4e1a\u75c5\u5371\u5bb3\u9879\u76ee\u7533\u62a5", colums, list, (OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/wandaDeclareListView"}, method={RequestMethod.GET})
    @RequiresPermissions(value={"harmFactorDeclare"})
    public String wandaDeclareListView() {
        return "views/keyFactorManagement/harmFactorDeclare/wandaDeclareListView";
    }

    @ResponseBody
    @RequestMapping(value={"getWandaDeclareListData"})
    public JqGridData<WandaDeclare> getWandaDeclareListData(JqGridParam param, SearchParam searchParam) {
        searchParam.setCid(UserUtils.getLoginStaffCompanyId());
        PageInfo wandaDeclarePageInfo = this.wandaDeclareService.getWandaDeclareList(param, searchParam);
        return new JqGridData(wandaDeclarePageInfo, param);
    }

    @RequestMapping(value={"wandaDeclareView"})
    public String wandaDeclareView(Long declareId, ModelMap modelMap) {
        WandaDeclare wandaDeclare = this.wandaDeclareService.getWandaDeclareDetails(declareId);
        modelMap.put((Object)"wandaDeclare", (Object)wandaDeclare);
        return "views/keyFactorManagement/harmFactorDeclare/wandaDeclareView";
    }

    @GetMapping(value={"/importCompany2024"})
    @ResponseBody
    public String importCompany2024(String creditCode) {
        this.wandaDeclareService.warehousingDeclare20240223(creditCode);
        return "\u5bfc\u5165\u6210\u529f";
    }
}

