/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.work.eme;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.excel.ExportExcel;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.web.repeatform.RepeatUrlFormData;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.entity.base.staff.vo.StaffBasicVo;
import cn.smarthse.modules.health.entity.work.eme.EmeTeam;
import cn.smarthse.modules.health.entity.work.eme.EmeTeamMember;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.work.eme.IEmeTeamMemberService;
import cn.smarthse.modules.health.service.work.eme.IEmeTeamService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/work/eme/emeteam"})
public class EmeTeamController
extends ControllerSupport {
    @DubboReference
    IEmeTeamService emeTeamServiceImpl;
    @DubboReference
    IEmeTeamMemberService emeTeamMemberServiceImpl;
    @DubboReference
    IStaffInfoService staffInfoServiceImpl;

    private void updateTeamMemberHistory(EmeTeamMember newEntity, Long cid, Long staffId) {
    }

    private void updateTeamHistory(EmeTeam newEntity, Long cid, Long staffId) {
    }

    @RequiresPermissions(value={"emergency.view"})
    @RequestMapping(value={"/info"}, method={RequestMethod.GET})
    public String emeInfo(Model model) {
        this.setEmeData(model);
        return "work/eme/emeteam_listContent";
    }

    private void setEmeData(Model model) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffid = UserUtils.getLoginStaffId();
        EmeTeam emeTeam = this.emeTeamServiceImpl.getEmeTeamByCid(cid);
        if (emeTeam.getId() == null) {
            emeTeam = new EmeTeam();
            emeTeam.setSettingTime(new Date());
            emeTeam = (EmeTeam)this.emeTeamServiceImpl.add((Object)emeTeam, staffid, cid);
            EmeTeamMember leader = new EmeTeamMember();
            leader.setDuty(Integer.valueOf(1));
            leader.setDeptId(emeTeam.getId());
            this.emeTeamMemberServiceImpl.add((Object)leader, staffid, cid);
        }
        model.addAttribute("emeTeam", (Object)emeTeam);
        List list = this.emeTeamMemberServiceImpl.getEmeTeamMemberList(emeTeam.getId());
        if (list != null && list.size() > 0) {
            EmeTeamMember leader = null;
            int i = 0;
            for (int j = 0; j < list.size(); ++j) {
                EmeTeamMember emeTeamMember = (EmeTeamMember)list.get(j);
                if (emeTeamMember.getDuty() == 1) {
                    leader = emeTeamMember;
                    i = j;
                    emeTeamMember.setDutyName("\u7ec4\u957f");
                } else if (emeTeamMember.getDuty() == 2) {
                    emeTeamMember.setDutyName("\u526f\u7ec4\u957f");
                } else if (emeTeamMember.getDuty() == 3) {
                    emeTeamMember.setDutyName("\u6210\u5458");
                }
                if (emeTeamMember.getStaffId() == null) continue;
                emeTeamMember.setMemberName(this.staffInfoServiceImpl.getStaffNameIncludeDelStatusByStaffId(emeTeamMember.getStaffId()));
            }
            model.addAttribute("leader", leader);
            list.remove(i);
            model.addAttribute("list", (Object)list);
        }
    }

    @RequiresPermissions(value={"emergency.view"})
    @RequestMapping(method={RequestMethod.GET})
    public String page_List(Model model) {
        this.logger.info("\u5e94\u6025\u673a\u6784\u4e0e\u961f\u4f0d\u300b\u5e94\u6025\u6551\u63f4\u7ba1\u7406\u673a\u6784");
        this.setEmeData(model);
        return "work/eme/emeteam_list";
    }

    @RequiresPermissions(value={"emergency.view"})
    @ResponseBody
    @RequestMapping(value={"listData"})
    public JqGridData<EmeTeamMember> listData(JqGridParam param, Long id) {
        this.logger.info(param.toString());
        param.setKeyId(id);
        PageInfo pageInfo = this.emeTeamMemberServiceImpl.getEmeTeamMemberListByGridParam(param);
        EmeTeamMember leader = (EmeTeamMember)pageInfo.getList().get(0);
        for (EmeTeamMember emeTeamMember : pageInfo.getList()) {
            if (emeTeamMember.getDuty() == 1) {
                emeTeamMember.setDutyName("\u7ec4\u957f");
                emeTeamMember.setPidName("/");
            } else if (emeTeamMember.getDuty() == 2) {
                emeTeamMember.setDutyName("\u526f\u7ec4\u957f");
            } else if (emeTeamMember.getDuty() == 3) {
                emeTeamMember.setDutyName("\u6210\u5458");
            }
            this.setStaffInfoByStaffId(emeTeamMember);
            if (emeTeamMember.getPid() == null) continue;
            if (emeTeamMember.getPid() == leader.getId()) {
                if (leader.getStaffId() == null) continue;
                emeTeamMember.setPidName(this.staffInfoServiceImpl.getStaffNameIncludeDelStatusByStaffId(leader.getStaffId()));
                continue;
            }
            EmeTeamMember e = (EmeTeamMember)this.emeTeamMemberServiceImpl.getById(emeTeamMember.getPid());
            if (e == null || leader.getStaffId() == null) continue;
            emeTeamMember.setPidName(this.staffInfoServiceImpl.getStaffNameIncludeDelStatusByStaffId(leader.getStaffId()));
        }
        JqGridData data = new JqGridData(pageInfo, param);
        return data;
    }

    private void setStaffInfoByStaffId(EmeTeamMember member) {
        if (member == null || member.getStaffId() == null) {
            return;
        }
        StaffBasicVo staffInfo = this.staffInfoServiceImpl.getStaffBasicInfoById(member.getStaffId());
        String deptName = staffInfo.getDeptName();
        member.setDeptName(deptName);
        member.setJob(staffInfo.getJobTitle());
        member.setTel(staffInfo.getMobile());
        if (member.getStaffId() != null) {
            member.setMemberName(this.staffInfoServiceImpl.getStaffNameIncludeDelStatusByStaffId(member.getStaffId()));
        }
    }

    @RequiresPermissions(value={"emergency.edit"})
    @RequestMapping(value={"viewteamedit/{id}"}, method={RequestMethod.GET})
    public String page_viewTeamEdit(@PathVariable(value="id") Long id, Model model) {
        EmeTeam emeTeam;
        this.logger.info("\u5e94\u6025\u673a\u6784\u4e0e\u961f\u4f0d\u300b\u5e94\u6025\u6551\u63f4\u7ba1\u7406\u673a\u6784\u300b\u7f16\u8f91\u673a\u6784");
        if (id != null && (emeTeam = (EmeTeam)this.emeTeamServiceImpl.getById(id)) != null) {
            model.addAttribute("emeTeam", (Object)emeTeam);
        }
        return "work/eme/dialog_editEmeTeam";
    }

    @Log(title="\u5e94\u6025\u6551\u63f4\u7ba1\u7406\u673a\u6784\u7f16\u8f91", type=21)
    @RequiresPermissions(value={"emergency.edit"})
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"editteam"}, method={RequestMethod.POST})
    public ResponseData<String> ajax_editEmeTeam(HttpServletRequest request, EmeTeam emeTeam) {
        this.logger.info("ajax-\u5e94\u6025\u673a\u6784\u4e0e\u961f\u4f0d\u300b\u5e94\u6025\u6551\u63f4\u7ba1\u7406\u673a\u6784\u300b\u7f16\u8f91\u673a\u6784");
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffid = UserUtils.getLoginStaffId();
        ResponseData r = new ResponseData();
        if (emeTeam.getId() == null) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u65e0\u6cd5\u83b7\u53d6\u8be5\u6761\u6570\u636e");
            return r;
        }
        if (emeTeam.getTeamName() == null || emeTeam.getTeamName().trim().isEmpty()) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u9886\u5bfc\u673a\u6784\u540d\u79f0\u4e0d\u5f97\u4e3a\u7a7a");
            return r;
        }
        if (emeTeam.getManageDept() == null) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u65e5\u5e38\u7ba1\u7406\u90e8\u95e8\u4e0d\u5f97\u4e3a\u7a7a");
            return r;
        }
        String fileIds = this.getDeptFileIds(request);
        emeTeam.setDeptFile(fileIds);
        this.emeTeamServiceImpl.update((Object)emeTeam, staffid);
        this.updateTeamHistory(emeTeam, cid, staffid);
        return r;
    }

    private String getDeptFileIds(HttpServletRequest request) {
        String[] fileId = request.getParameterValues("fileId");
        if (fileId == null || fileId.length == 0) {
            return "";
        }
        Object ids = "";
        for (String id : fileId) {
            if (!StringUtils.isNotEmpty((CharSequence)id)) continue;
            ids = (String)ids + id + ",";
        }
        if (StringUtils.isEmpty((CharSequence)ids)) {
            return ids;
        }
        return ((String)ids).substring(0, ((String)ids).length() - 1);
    }

    @RequiresPermissions(value={"emergency.edit"})
    @RequestMapping(value={"viewteammemberadd"}, method={RequestMethod.GET})
    public String page_viewTeamMemberAdd(Long deptId, Model model) {
        this.logger.info("\u5e94\u6025\u673a\u6784\u4e0e\u961f\u4f0d\u300b\u5e94\u6025\u6551\u63f4\u7ba1\u7406\u673a\u6784\u300b\u65b0\u589e\u673a\u6784\u4eba\u5458");
        if (deptId != null) {
            ArrayList<EmeTeamMember> list = new ArrayList<EmeTeamMember>();
            List emeTeamMemberList = this.emeTeamMemberServiceImpl.getEmeTeamMemberList(deptId);
            EmeTeamMember leader = (EmeTeamMember)emeTeamMemberList.get(0);
            leader.setDutyName("\u7ec4\u957f");
            model.addAttribute("leader", (Object)leader);
            emeTeamMemberList.remove(0);
            for (EmeTeamMember emeTeamMember : emeTeamMemberList) {
                if (emeTeamMember.getDuty() == null || emeTeamMember.getDuty() != 2) continue;
                emeTeamMember.setDutyName("\u526f\u7ec4\u957f");
                list.add(emeTeamMember);
            }
            model.addAttribute("list", list);
        }
        model.addAttribute("deptId", (Object)deptId);
        return "work/eme/dialog_addEmeTeamMember";
    }

    @RequiresPermissions(value={"emergency.edit"})
    @RequestMapping(value={"viewteammemberedit/{id}"}, method={RequestMethod.GET})
    public String page_viewTeamMemberEdit(@PathVariable(value="id") Long id, Model model) {
        EmeTeamMember emeTeamMember;
        this.logger.info("\u5e94\u6025\u673a\u6784\u4e0e\u961f\u4f0d\u300b\u5e94\u6025\u6551\u63f4\u7ba1\u7406\u673a\u6784\u300b\u7f16\u8f91\u673a\u6784\u4eba\u5458");
        if (id != null && (emeTeamMember = (EmeTeamMember)this.emeTeamMemberServiceImpl.getById(id)) != null) {
            this.setStaffInfoByStaffId(emeTeamMember);
            model.addAttribute("emeTeamMember", (Object)emeTeamMember);
            if (emeTeamMember.getDeptId() != null) {
                ArrayList<EmeTeamMember> list = new ArrayList<EmeTeamMember>();
                List emeTeamMemberList = this.emeTeamMemberServiceImpl.getEmeTeamMemberList(emeTeamMember.getDeptId());
                EmeTeamMember leader = (EmeTeamMember)emeTeamMemberList.get(0);
                leader.setDutyName("\u7ec4\u957f");
                model.addAttribute("leader", (Object)leader);
                emeTeamMemberList.remove(0);
                for (EmeTeamMember e : emeTeamMemberList) {
                    if (e.getDuty() == null || e.getDuty() != 2) continue;
                    e.setDutyName("\u526f\u7ec4\u957f");
                    list.add(e);
                }
                model.addAttribute("list", list);
            }
        }
        return "work/eme/dialog_editEmeTeamMember";
    }

    @RequiresPermissions(value={"emergency.edit"})
    @ResponseBody
    @RequestMapping(value={"/addteammember"}, method={RequestMethod.POST})
    public ResponseData<String> ajax_addEmeTeamMember(EmeTeamMember emeTeamMember) {
        this.logger.info("ajax-\u5e94\u6025\u673a\u6784\u4e0e\u961f\u4f0d\u300b\u5e94\u6025\u6551\u63f4\u7ba1\u7406\u673a\u6784\u300b\u65b0\u589e\u673a\u6784\u4eba\u5458");
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffid = UserUtils.getLoginStaffId();
        ResponseData r = new ResponseData();
        if (emeTeamMember.getDuty() == null) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u8bf7\u9009\u62e9\u672c\u673a\u6784\u804c\u52a1");
            return r;
        }
        if (emeTeamMember.getDuty() != 1 && emeTeamMember.getPid() == null) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u8bf7\u9009\u62e9\u4e0a\u7ea7\u9886\u5bfc");
            return r;
        }
        if (StringUtils.isEmpty((CharSequence)emeTeamMember.getMemberName())) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u59d3\u540d\u4e0d\u5f97\u4e3a\u7a7a");
            return r;
        }
        if (this.emeTeamMemberServiceImpl.hasMemeber(emeTeamMember)) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u8be5\u4eba\u5458\u5df2\u5b58\u5728,\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0");
            return r;
        }
        if (emeTeamMember.getPid() == null) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u8bf7\u9009\u62e9\u4e0a\u7ea7\u9886\u5bfc");
            return r;
        }
        this.emeTeamMemberServiceImpl.add((Object)emeTeamMember, staffid, cid);
        return r;
    }

    @Log(title="\u5e94\u6025\u6551\u63f4\u7ba1\u7406\u673a\u6784\u4eba\u5458\u7f16\u8f91", type=21)
    @RequiresPermissions(value={"emergency.edit"})
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"editteammember"}, method={RequestMethod.POST})
    public ResponseData<String> ajax_editEmeTeamMember(EmeTeamMember emeTeamMember) {
        this.logger.info("ajax-\u5e94\u6025\u673a\u6784\u4e0e\u961f\u4f0d\u300b\u5e94\u6025\u6551\u63f4\u7ba1\u7406\u673a\u6784\u300b\u7f16\u8f91\u673a\u6784\u4eba\u5458");
        Long staffid = UserUtils.getLoginStaffId();
        ResponseData r = new ResponseData();
        if (emeTeamMember.getId() == null) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u65e0\u6cd5\u83b7\u53d6\u8be5\u6761\u6570\u636e");
            return r;
        }
        EmeTeamMember e = (EmeTeamMember)this.emeTeamMemberServiceImpl.getById(emeTeamMember.getId());
        if (e.getDuty() != null && e.getDuty() == 1) {
            emeTeamMember.setDuty(e.getDuty());
        }
        if (e.getDuty() != 1 && emeTeamMember.getDuty() == null) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u8bf7\u9009\u62e9\u672c\u673a\u6784\u804c\u52a1");
            return r;
        }
        if (e.getDuty() != 1 && emeTeamMember.getPid() == null) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u8bf7\u9009\u62e9\u4e0a\u7ea7\u9886\u5bfc");
            return r;
        }
        if (StringUtils.isEmpty((CharSequence)emeTeamMember.getMemberName())) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u59d3\u540d\u4e0d\u5f97\u4e3a\u7a7a");
            return r;
        }
        if (this.emeTeamMemberServiceImpl.hasMemeber(emeTeamMember)) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u8be5\u4eba\u5458\u5df2\u5b58\u5728,\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0");
            return r;
        }
        this.emeTeamMemberServiceImpl.updateMemberByPrimaryKey(emeTeamMember, staffid);
        Long cid = UserUtils.getLoginStaffCompanyId();
        this.updateTeamMemberHistory(emeTeamMember, cid, staffid);
        return r;
    }

    @Log(title="\u5e94\u6025\u6551\u63f4\u7ba1\u7406\u673a\u6784\u4eba\u5458\u5220\u9664", type=22)
    @RequiresPermissions(value={"emergency.edit"})
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"delteammember/{id}"}, method={RequestMethod.POST})
    public ResponseData<String> ajax_delEmeTeamMember(@PathVariable(value="id") Long id) {
        EmeTeamMember emeTeamMember;
        this.logger.info("ajax-\u5e94\u6025\u673a\u6784\u4e0e\u961f\u4f0d\u300b\u5e94\u6025\u6551\u63f4\u7ba1\u7406\u673a\u6784\u300b\u5220\u9664\u673a\u6784\u4eba\u5458");
        Long staffid = UserUtils.getLoginStaffId();
        ResponseData r = new ResponseData();
        if (id != null) {
            emeTeamMember = (EmeTeamMember)this.emeTeamMemberServiceImpl.getById(id);
            if (emeTeamMember.getDuty() == 1) {
                r.setState(ResponseStateEnum.fail);
                r.setContent("\u7ec4\u957f\u4e0d\u5f97\u5220\u9664");
                return r;
            }
            if (emeTeamMember.getDuty() == 2) {
                List list = this.emeTeamMemberServiceImpl.getEmeTeamMemberList(emeTeamMember.getDeptId());
                EmeTeamMember leader = (EmeTeamMember)list.get(0);
                List list2 = this.emeTeamMemberServiceImpl.getEmeTeamMemberListByPid(emeTeamMember.getId());
                for (EmeTeamMember e : list2) {
                    e.setPid(leader.getId());
                    this.emeTeamMemberServiceImpl.update((Object)e, staffid);
                }
            }
        } else {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u65e0\u6cd5\u83b7\u53d6\u8be5\u6761\u6570\u636e");
            return r;
        }
        emeTeamMember.setIsValid(Boolean.valueOf(false));
        this.emeTeamMemberServiceImpl.update((Object)emeTeamMember, staffid);
        return r;
    }

    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"staffinfo"}, method={RequestMethod.POST})
    public ResponseData<StaffInfo> ajax_staffInfo(Long id) {
        this.logger.info("ajax-\u5e94\u6025\u673a\u6784\u4e0e\u961f\u4f0d\u300b\u5e94\u6025\u6551\u63f4\u7ba1\u7406\u673a\u6784\u300b\u67e5\u8be2\u4eba\u5458\u4fe1\u606f");
        ResponseData r = new ResponseData();
        if (id != null) {
            StaffInfo staffInfo = this.staffInfoServiceImpl.getStaffInfoWithStaffBasicWorkById(id);
            r.setResult((Object)staffInfo);
        }
        return r;
    }

    @RequiresPermissions(value={"emergency.view"})
    @Log(title="\u5e94\u6025\u6551\u63f4\u7ba1\u7406\u673a\u6784\u5bfc\u51fa", type=24)
    @RequestMapping(value={"emeteamexport"})
    public void emeTeamExport(HttpServletResponse response, Long id) throws Exception {
        this.logger.info("ajax-\u3010\u5e94\u6025\u6551\u63f4\u7ba1\u7406\u673a\u6784\u3011-\u5bfc\u51faExcel");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String fileName = "\u5e94\u6025\u6551\u63f4\u7ba1\u7406\u673a\u6784\u4eba\u5458\u6e05\u5355" + dateFormat.format(new Date()) + ".xls";
        String[] colums = new String[]{"\u672c\u673a\u6784\u804c\u52a1|dutyName", "\u59d3\u540d|memberName", "\u90e8\u95e8/\u8f66\u95f4|deptName", "\u804c\u52a1|job", "\u8054\u7cfb\u7535\u8bdd|tel", "\u4e0a\u7ea7\u9886\u5bfc|pidName"};
        List list = this.emeTeamMemberServiceImpl.getEmeTeamMemberList(id);
        EmeTeamMember leader = (EmeTeamMember)list.get(0);
        for (EmeTeamMember emeTeamMember : list) {
            if (emeTeamMember.getDuty() == 1) {
                emeTeamMember.setDutyName("\u7ec4\u957f");
                emeTeamMember.setPidName("/");
            } else if (emeTeamMember.getDuty() == 2) {
                emeTeamMember.setDutyName("\u526f\u7ec4\u957f");
            } else if (emeTeamMember.getDuty() == 3) {
                emeTeamMember.setDutyName("\u6210\u5458");
            }
            this.setStaffInfoByStaffId(emeTeamMember);
            if (emeTeamMember.getPid() == null) continue;
            if (emeTeamMember.getPid() == leader.getId()) {
                emeTeamMember.setPidName(leader.getMemberName());
                continue;
            }
            EmeTeamMember e = (EmeTeamMember)this.emeTeamMemberServiceImpl.getById(emeTeamMember.getPid());
            if (e == null) continue;
            emeTeamMember.setPidName(e.getMemberName());
        }
        response.setContentType("application/vnd.ms-excel");
        response.addHeader("Content-Disposition", "attachment; filename*=utf-8'zh_cn'" + URLEncoder.encode(new String(fileName.getBytes()), "utf-8"));
        ExportExcel listexcel = new ExportExcel();
        listexcel.simpleExport2("\u5e94\u6025\u6551\u63f4\u7ba1\u7406\u673a\u6784", colums, list, (OutputStream)response.getOutputStream());
    }
}

