/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.work.eme;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.excel.ExportExcel;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.web.repeatform.RepeatUrlFormData;
import cn.smarthse.common.util.leak.ResponseLeakUtil;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.entity.work.eme.EmeRescueTeam;
import cn.smarthse.modules.health.entity.work.eme.EmeRescueTeamRerson;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.sys.IHistoryBasicService;
import cn.smarthse.modules.health.service.work.eme.IEmeRescueTeamRersonService;
import cn.smarthse.modules.health.service.work.eme.IEmeRescueTeamService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/work/eme/emerescueteam"})
public class EmeRescueTeamController
extends ControllerSupport {
    @DubboReference
    IEmeRescueTeamService emeRescueTeamServiceImpl;
    @DubboReference
    IEmeRescueTeamRersonService emeRescueTeamRersonServiceImpl;
    @DubboReference(timeout=5000000)
    ISysFileProvideService sysFileServiceImpl;
    @DubboReference
    IStaffInfoService staffInfoServiceImpl;
    @DubboReference
    IHistoryBasicService historyService;

    private void updateTeamRersonHistory(EmeRescueTeamRerson newEntity, Long staffId) {
    }

    private void updateTeamHistory(EmeRescueTeam newEntity, Long staffId) {
    }

    @RequiresPermissions(value={"emergency.view"})
    @RequestMapping(method={RequestMethod.GET})
    public String page_List(Model model, Long id) {
        this.logger.info("\u5e94\u6025\u673a\u6784\u4e0e\u961f\u4f0d\u300b\u5e94\u6025\u6551\u63f4\u961f\u4f0d");
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffid = UserUtils.getLoginStaffId();
        boolean isEmeRescueTeam = this.emeRescueTeamServiceImpl.getExistsByAsc(cid);
        if (!isEmeRescueTeam) {
            EmeRescueTeam record = new EmeRescueTeam();
            record.setTeamName("\u8bf7\u547d\u540d");
            this.emeRescueTeamServiceImpl.add((Object)record, staffid, cid);
        }
        List teamList = this.emeRescueTeamServiceImpl.getEmeRescueTeamListByAsc(cid);
        EmeRescueTeam emeRescueTeam = null;
        emeRescueTeam = id == null ? (EmeRescueTeam)teamList.get(0) : (EmeRescueTeam)this.emeRescueTeamServiceImpl.getById(id);
        model.addAttribute("emeRescueTeam", (Object)emeRescueTeam);
        if (emeRescueTeam.getTeamFileId() != null) {
            SysFileModel sysFile = this.sysFileServiceImpl.getFileById(emeRescueTeam.getTeamFileId());
            model.addAttribute("sysFile", (Object)sysFile);
        }
        model.addAttribute("team", teamList.get(0));
        teamList.remove(0);
        model.addAttribute("teamList", (Object)teamList);
        model.addAttribute("id", (Object)id);
        return "work/eme/emerescueteam_list";
    }

    @RequiresPermissions(value={"emergency.view"})
    @ResponseBody
    @RequestMapping(value={"listData"})
    public JqGridData<EmeRescueTeamRerson> listData(JqGridParam param, Long id) {
        this.logger.info(param.toString());
        Long cid = UserUtils.getLoginStaffCompanyId();
        if (id == null) {
            List teamList = this.emeRescueTeamServiceImpl.getEmeRescueTeamListByAsc(cid);
            id = ((EmeRescueTeam)teamList.get(0)).getId();
        }
        param.setKeyId(id);
        PageInfo pageInfo = this.emeRescueTeamRersonServiceImpl.getEmeRescueTeamRersonListByGridParam(param);
        JqGridData data = new JqGridData(pageInfo, param);
        return data;
    }

    @RequiresPermissions(value={"emergency.edit"})
    @RequestMapping(value={"viewteamadd"}, method={RequestMethod.GET})
    public String page_viewTeamAdd() {
        this.logger.info("\u5e94\u6025\u673a\u6784\u4e0e\u961f\u4f0d\u300b\u5e94\u6025\u6551\u63f4\u961f\u4f0d\u300b\u65b0\u589e\u961f\u4f0d");
        return "work/eme/dialog_addEmeRescueTeam";
    }

    @RequiresPermissions(value={"emergency.edit"})
    @RequestMapping(value={"viewteamedit/{id}"}, method={RequestMethod.GET})
    public String page_viewTeamEdit(@PathVariable(value="id") Long id, Model model) {
        EmeRescueTeam emeRescueTeam;
        this.logger.info("\u5e94\u6025\u673a\u6784\u4e0e\u961f\u4f0d\u300b\u5e94\u6025\u6551\u63f4\u961f\u4f0d\u300b\u7f16\u8f91\u961f\u4f0d");
        if (id != null && (emeRescueTeam = (EmeRescueTeam)this.emeRescueTeamServiceImpl.getById(id)) != null) {
            model.addAttribute("emeRescueTeam", (Object)emeRescueTeam);
            if (emeRescueTeam.getTeamFileId() != null) {
                SysFileModel sysFile = this.sysFileServiceImpl.getFileById(emeRescueTeam.getTeamFileId());
                model.addAttribute("sysFile", (Object)sysFile);
            }
        }
        return "work/eme/dialog_editEmeRescueTeam";
    }

    @Log(title="\u5e94\u6025\u6551\u63f4\u961f\u4f0d\u65b0\u589e", type=20)
    @RequiresPermissions(value={"emergency.edit"})
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"/addteam"}, method={RequestMethod.POST})
    public ResponseData<String> ajax_addEmeRescueTeam(EmeRescueTeam emeRescueTeam, Long fileId) {
        this.logger.info("ajax-\u5e94\u6025\u673a\u6784\u4e0e\u961f\u4f0d\u300b\u5e94\u6025\u6551\u63f4\u961f\u4f0d\u300b\u65b0\u589e\u961f\u4f0d");
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffid = UserUtils.getLoginStaffId();
        ResponseData r = new ResponseData();
        if (emeRescueTeam.getTeamName() == null || emeRescueTeam.getTeamName().trim().isEmpty()) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u961f\u4f0d\u540d\u79f0\u4e0d\u5f97\u4e3a\u7a7a");
            return r;
        }
        if (emeRescueTeam.getTeamType() == null) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u8bf7\u9009\u62e9\u961f\u4f0d\u7c7b\u578b");
            return r;
        }
        if (emeRescueTeam.getTeamType() == 2) {
            if (emeRescueTeam.getOutCompanyName() == null || emeRescueTeam.getOutCompanyName().trim().isEmpty()) {
                r.setState(ResponseStateEnum.fail);
                r.setContent("\u5916\u534f\u5355\u4f4d\u4e0d\u5f97\u4e3a\u7a7a");
                return r;
            }
            if (emeRescueTeam.getStartTime() == null) {
                r.setState(ResponseStateEnum.fail);
                r.setContent("\u5916\u534f\u65f6\u95f4\u4e0d\u5f97\u4e3a\u7a7a");
                return r;
            }
        } else if (emeRescueTeam.getTeamType() == 3) {
            if (emeRescueTeam.getOutCompanyName() == null || emeRescueTeam.getOutCompanyName().trim().isEmpty()) {
                r.setState(ResponseStateEnum.fail);
                r.setContent("\u5408\u4f5c\u5355\u4f4d\u4e0d\u5f97\u4e3a\u7a7a");
                return r;
            }
            if (emeRescueTeam.getStartTime() == null) {
                r.setState(ResponseStateEnum.fail);
                r.setContent("\u5408\u4f5c\u65f6\u95f4\u4e0d\u5f97\u4e3a\u7a7a");
                return r;
            }
        }
        emeRescueTeam.setTeamFileId(fileId);
        emeRescueTeam = (EmeRescueTeam)this.emeRescueTeamServiceImpl.add((Object)emeRescueTeam, staffid, cid);
        r.setResult((Object)emeRescueTeam.getId().toString());
        return r;
    }

    @Log(title="\u5e94\u6025\u6551\u63f4\u961f\u4f0d\u7f16\u8f91", type=21)
    @RequiresPermissions(value={"emergency.edit"})
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"editteam"}, method={RequestMethod.POST})
    public ResponseData<String> ajax_editEmeRescueTeam(EmeRescueTeam emeRescueTeam, Long fileId) {
        this.logger.info("ajax-\u5e94\u6025\u673a\u6784\u4e0e\u961f\u4f0d\u300b\u5e94\u6025\u6551\u63f4\u961f\u4f0d\u300b\u7f16\u8f91\u961f\u4f0d");
        Long staffid = UserUtils.getLoginStaffId();
        ResponseData r = new ResponseData();
        if (emeRescueTeam.getId() == null) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u65e0\u6cd5\u83b7\u53d6\u8be5\u6761\u6570\u636e");
            return r;
        }
        if (emeRescueTeam.getTeamName() == null || emeRescueTeam.getTeamName().trim().isEmpty()) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u961f\u4f0d\u540d\u79f0\u4e0d\u5f97\u4e3a\u7a7a");
            return r;
        }
        if (emeRescueTeam.getTeamType() == null) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u8bf7\u9009\u62e9\u961f\u4f0d\u7c7b\u578b");
            return r;
        }
        if (emeRescueTeam.getTeamType() == 2) {
            if (emeRescueTeam.getOutCompanyName() == null || emeRescueTeam.getOutCompanyName().trim().isEmpty()) {
                r.setState(ResponseStateEnum.fail);
                r.setContent("\u5916\u534f\u5355\u4f4d\u4e0d\u5f97\u4e3a\u7a7a");
                return r;
            }
            if (emeRescueTeam.getStartTime() == null) {
                r.setState(ResponseStateEnum.fail);
                r.setContent("\u5916\u534f\u65f6\u95f4\u4e0d\u5f97\u4e3a\u7a7a");
                return r;
            }
        } else if (emeRescueTeam.getTeamType() == 3) {
            if (emeRescueTeam.getOutCompanyName() == null || emeRescueTeam.getOutCompanyName().trim().isEmpty()) {
                r.setState(ResponseStateEnum.fail);
                r.setContent("\u5408\u4f5c\u5355\u4f4d\u4e0d\u5f97\u4e3a\u7a7a");
                return r;
            }
            if (emeRescueTeam.getStartTime() == null) {
                r.setState(ResponseStateEnum.fail);
                r.setContent("\u5408\u4f5c\u65f6\u95f4\u4e0d\u5f97\u4e3a\u7a7a");
                return r;
            }
        }
        emeRescueTeam.setTeamFileId(fileId);
        if (fileId == null) {
            emeRescueTeam.setTeamFileId(Long.valueOf(0L));
        }
        this.emeRescueTeamServiceImpl.update((Object)emeRescueTeam, staffid);
        this.updateTeamHistory(emeRescueTeam, staffid);
        return r;
    }

    @Log(title="\u5e94\u6025\u6551\u63f4\u961f\u4f0d\u5220\u9664", type=22)
    @RequiresPermissions(value={"emergency.edit"})
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"delteam/{id}"}, method={RequestMethod.POST})
    public ResponseData<String> ajax_delEmeRescueTeam(@PathVariable(value="id") Long id) {
        this.logger.info("ajax-\u5e94\u6025\u673a\u6784\u4e0e\u961f\u4f0d\u300b\u5e94\u6025\u6551\u63f4\u961f\u4f0d\u300b\u5220\u9664\u961f\u4f0d");
        Long staffid = UserUtils.getLoginStaffId();
        ResponseData r = new ResponseData();
        if (id == null) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u65e0\u6cd5\u83b7\u53d6\u8be5\u6761\u6570\u636e");
            return r;
        }
        EmeRescueTeam emeRescueTeam = (EmeRescueTeam)this.emeRescueTeamServiceImpl.getById(id);
        emeRescueTeam.setIsValid(Boolean.valueOf(false));
        this.emeRescueTeamServiceImpl.update((Object)emeRescueTeam, staffid);
        return r;
    }

    @RequiresPermissions(value={"emergency.edit"})
    @RequestMapping(value={"viewteamrersonadd"}, method={RequestMethod.GET})
    public String page_viewTeamRersonAdd(Long teamId, Model model) {
        this.logger.info("\u5e94\u6025\u673a\u6784\u4e0e\u961f\u4f0d\u300b\u5e94\u6025\u6551\u63f4\u961f\u4f0d\u300b\u65b0\u589e\u961f\u4f0d\u4eba\u5458");
        model.addAttribute("teamId", (Object)teamId);
        this.getTeamRersons(model, teamId);
        return "work/eme/dialog_editEmeRescueTeamRerson";
    }

    private void getTeamRersons(Model model, Long teamId) {
        List members = this.emeRescueTeamRersonServiceImpl.getEmeRescueTeamRersonLeaderList(teamId);
        if (members != null && !members.isEmpty()) {
            for (EmeRescueTeamRerson m : members) {
                if (m.getStaffId() == null) continue;
                m.setPersonName(this.staffInfoServiceImpl.getStaffNameIncludeDelStatusByStaffId(m.getStaffId()));
            }
        }
        model.addAttribute("members", (Object)members);
    }

    @RequiresPermissions(value={"emergency.edit"})
    @RequestMapping(value={"viewteamrersonedit/{id}"}, method={RequestMethod.GET})
    public String page_viewTeamRersonEdit(@PathVariable(value="id") Long id, Model model) {
        EmeRescueTeamRerson emeRescueTeamRerson;
        this.logger.info("\u5e94\u6025\u673a\u6784\u4e0e\u961f\u4f0d\u300b\u5e94\u6025\u6551\u63f4\u961f\u4f0d\u300b\u7f16\u8f91\u961f\u4f0d\u4eba\u5458");
        if (id != null && (emeRescueTeamRerson = (EmeRescueTeamRerson)this.emeRescueTeamRersonServiceImpl.getById(id)) != null) {
            if (emeRescueTeamRerson.getStaffId() != null) {
                emeRescueTeamRerson.setPersonName(this.staffInfoServiceImpl.getStaffNameIncludeDelStatusByStaffId(emeRescueTeamRerson.getStaffId()));
            }
            model.addAttribute("emeRescueTeamRerson", (Object)emeRescueTeamRerson);
            this.getTeamRersons(model, emeRescueTeamRerson.getTeamId());
        }
        return "work/eme/dialog_editEmeRescueTeamRerson";
    }

    @Log(title="\u5e94\u6025\u6551\u63f4\u961f\u4f0d\u4eba\u5458\u65b0\u589e", type=20)
    @RequiresPermissions(value={"emergency.edit"})
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"/addteamrerson"}, method={RequestMethod.POST})
    public ResponseData<String> ajax_addEmeRescueTeamRerson(EmeRescueTeamRerson emeRescueTeamRerson) {
        this.logger.info("ajax-\u5e94\u6025\u673a\u6784\u4e0e\u961f\u4f0d\u300b\u5e94\u6025\u6551\u63f4\u961f\u4f0d\u300b\u65b0\u589e\u961f\u4f0d\u4eba\u5458");
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffid = UserUtils.getLoginStaffId();
        ResponseData r = new ResponseData();
        if (StringUtils.isEmpty((CharSequence)emeRescueTeamRerson.getPersonDuty())) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u672c\u673a\u6784\u804c\u52a1\u4e0d\u5f97\u4e3a\u7a7a");
            return r;
        }
        if (StringUtils.isEmpty((CharSequence)emeRescueTeamRerson.getPersonName())) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u59d3\u540d\u4e0d\u5f97\u4e3a\u7a7a");
            return r;
        }
        if (this.emeRescueTeamRersonServiceImpl.hasMemeber(emeRescueTeamRerson)) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u8be5\u4eba\u5458\u5df2\u5b58\u5728,\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0");
            return r;
        }
        this.emeRescueTeamRersonServiceImpl.add((Object)emeRescueTeamRerson, staffid, cid);
        return r;
    }

    @Log(title="\u5e94\u6025\u6551\u63f4\u961f\u4f0d\u4eba\u5458\u7f16\u8f91", type=21)
    @RequiresPermissions(value={"emergency.edit"})
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"editteamrerson"}, method={RequestMethod.POST})
    public ResponseData<String> ajax_editEmeRescueTeamRerson(EmeRescueTeamRerson emeRescueTeamRerson) {
        this.logger.info("ajax-\u5e94\u6025\u673a\u6784\u4e0e\u961f\u4f0d\u300b\u5e94\u6025\u6551\u63f4\u961f\u4f0d\u300b\u7f16\u8f91\u961f\u4f0d\u4eba\u5458");
        Long staffid = UserUtils.getLoginStaffId();
        ResponseData r = new ResponseData();
        if (StringUtils.isEmpty((CharSequence)emeRescueTeamRerson.getPersonDuty())) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u672c\u673a\u6784\u804c\u52a1\u4e0d\u5f97\u4e3a\u7a7a");
            return r;
        }
        if (StringUtils.isEmpty((CharSequence)emeRescueTeamRerson.getPersonName())) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u59d3\u540d\u4e0d\u5f97\u4e3a\u7a7a");
            return r;
        }
        if (this.emeRescueTeamRersonServiceImpl.hasMemeber(emeRescueTeamRerson)) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u8be5\u4eba\u5458\u5df2\u5b58\u5728,\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0");
            return r;
        }
        this.emeRescueTeamRersonServiceImpl.updateInfoByPrimaryKey(emeRescueTeamRerson, staffid);
        this.updateTeamRersonHistory(emeRescueTeamRerson, staffid);
        return r;
    }

    @Log(title="\u5e94\u6025\u6551\u63f4\u961f\u4f0d\u4eba\u5458\u5220\u9664", type=22)
    @RequiresPermissions(value={"emergency.edit"})
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"delteamrerson/{id}"}, method={RequestMethod.POST})
    public ResponseData<String> ajax_delEmeRescueTeamRerson(@PathVariable(value="id") Long id) {
        this.logger.info("ajax-\u5e94\u6025\u673a\u6784\u4e0e\u961f\u4f0d\u300b\u5e94\u6025\u6551\u63f4\u961f\u4f0d\u300b\u5220\u9664\u961f\u4f0d\u4eba\u5458");
        Long staffid = UserUtils.getLoginStaffId();
        ResponseData r = new ResponseData();
        if (id == null) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u65e0\u6cd5\u83b7\u53d6\u8be5\u6761\u6570\u636e");
            return r;
        }
        EmeRescueTeamRerson emeRescueTeamRerson = (EmeRescueTeamRerson)this.emeRescueTeamRersonServiceImpl.getById(id);
        emeRescueTeamRerson.setIsValid(Boolean.valueOf(false));
        this.emeRescueTeamRersonServiceImpl.update((Object)emeRescueTeamRerson, staffid);
        return r;
    }

    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"staffinfo"}, method={RequestMethod.POST})
    public ResponseData<StaffInfo> ajax_staffInfo(Long id) {
        this.logger.info("ajax-\u5e94\u6025\u673a\u6784\u4e0e\u961f\u4f0d\u300b\u5e94\u6025\u6551\u63f4\u961f\u4f0d\u300b\u67e5\u8be2\u4eba\u5458\u4fe1\u606f");
        ResponseData r = new ResponseData();
        if (id != null) {
            StaffInfo staffInfo = this.staffInfoServiceImpl.getStaffInfoWithStaffBasicWorkById(id);
            r.setResult((Object)staffInfo);
        }
        return r;
    }

    @RequiresPermissions(value={"emergency.view"})
    @Log(title="\u5e94\u6025\u6551\u63f4\u961f\u4f0d\u5bfc\u51fa", type=24)
    @RequestMapping(value={"teamrersonexport"})
    public void emeRescueTeamRersonExport(HttpServletResponse response, Long id) throws Exception {
        this.logger.info("ajax-\u3010\u5e94\u6025\u673a\u6784\u4e0e\u961f\u4f0d\u3011-\u3010\u5e94\u6025\u6551\u63f4\u961f\u4f0d\u3011-\u5bfc\u51faExcel");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        EmeRescueTeam team = (EmeRescueTeam)this.emeRescueTeamServiceImpl.getById(id);
        Object teamName = "";
        if (team != null) {
            teamName = "(" + team.getTeamName() + ")";
        }
        Object fileName = "\u5e94\u6025\u6551\u63f4\u961f\u4f0d\u4eba\u5458\u6e05\u5355" + (String)teamName + dateFormat.format(new Date()) + ".xls";
        fileName = URLEncoder.encode(String.format((String)fileName, LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE)), "UTF-8").replaceAll("\\+", "%20");
        String[] colums = new String[]{"\u672c\u673a\u6784\u7684\u804c\u52a1|personDutyName", "\u59d3\u540d|personName", "\u90e8\u95e8/\u8f66\u95f4|personOrg", "\u516c\u53f8\u804c\u52a1|personJob", "\u5c97\u4f4d|personWorkrole", "\u8054\u7cfb\u7535\u8bdd|personTel"};
        List list = this.emeRescueTeamRersonServiceImpl.getEmeRescueTeamRersonList(id);
        response.setContentType("application/vnd.ms-excel");
        ResponseLeakUtil.setReponseFileName((HttpServletResponse)response, (String)fileName);
        ExportExcel listexcel = new ExportExcel();
        listexcel.simpleExport2("\u5e94\u6025\u6551\u63f4\u961f\u4f0d", colums, list, (OutputStream)response.getOutputStream());
    }
}

