/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.work.eme;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.excel.ExportExcel;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.web.repeatform.RepeatUrlFormData;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.datacentre.provider.system.ISysFileProvideService;
import cn.smarthse.modules.health.entity.work.eme.EmeRescueDept;
import cn.smarthse.modules.health.entity.work.eme.EmeRescueDeptPerson;
import cn.smarthse.modules.health.service.base.company.ICompanyOrganizationService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.sys.IHistoryBasicService;
import cn.smarthse.modules.health.service.work.eme.IEmeRescueDeptPersonService;
import cn.smarthse.modules.health.service.work.eme.IEmeRescueDeptService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/work/eme/emerescuedept"})
public class EmeRescueDeptController
extends ControllerSupport {
    @DubboReference
    IEmeRescueDeptService emeRescueDeptServiceImpl;
    @DubboReference
    IEmeRescueDeptPersonService emeRescueDeptPersonServiceImpl;
    @DubboReference(timeout=5000000)
    ISysFileProvideService sysFileServiceImpl;
    @DubboReference
    ICompanyOrganizationService ICompanyOrganizationServiceImpl;
    @DubboReference
    IHistoryBasicService historyService;
    @DubboReference
    IStaffInfoService staffInfoServiceImpl;

    private void updateDeptPersonHistory(EmeRescueDeptPerson newEntity, Long cid, Long staffId) {
    }

    private void updateDeptHistory(EmeRescueDept newEntity, Long cid, Long staffId) {
    }

    @RequiresPermissions(value={"emergency.view"})
    @RequestMapping(method={RequestMethod.GET})
    public String init(ModelMap m) {
        this.logger.info("\u5e94\u6025\u673a\u6784\u4e0e\u961f\u4f0d\u300b\u804c\u80fd\u673a\u6784");
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffid = UserUtils.getLoginStaffId();
        EmeRescueDept emeRescueDept = this.emeRescueDeptServiceImpl.getRescueDeptByCid(cid);
        if (emeRescueDept == null) {
            emeRescueDept = new EmeRescueDept();
            emeRescueDept = (EmeRescueDept)this.emeRescueDeptServiceImpl.add((Object)emeRescueDept, staffid, cid);
        }
        Long fileId = emeRescueDept.getTeamFileId();
        String fileName = null;
        if (fileId != null) {
            SysFileModel file = this.sysFileServiceImpl.getFileById(fileId);
            m.put((Object)"sysFile", (Object)file);
            fileName = file.getFileName();
        }
        if (fileName == null || fileName.trim().isEmpty()) {
            fileName = "\u672a\u4e0a\u4f20\u6587\u4ef6";
        }
        emeRescueDept.setFileName(fileName);
        m.put((Object)"emeRescueDept", (Object)emeRescueDept);
        return "work/eme/emerescuedept_list";
    }

    @RequiresPermissions(value={"emergency.view"})
    @ResponseBody
    @RequestMapping(value={"listData"})
    public JqGridData<EmeRescueDeptPerson> listData(HttpSession session, JqGridParam param, Long deptId) {
        this.logger.info(param.toString());
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        param.setKeyId(deptId);
        PageInfo list = this.emeRescueDeptPersonServiceImpl.getEmeRescueDeptPersonContactListByGridParam(param);
        JqGridData data = new JqGridData(list, param);
        return data;
    }

    @Log(title="\u804c\u80fd\u90e8\u95e8\u4e0a\u4f20\u6587\u4ef6", type=26)
    @ResponseBody
    @RequestMapping(value={"/fileup"}, method={RequestMethod.POST})
    public ResponseData<String> ajax_fileUp(Long id, Long fileid) {
        if (id != null && fileid != null) {
            Long cid = UserUtils.getLoginStaffCompanyId();
            Long staffid = UserUtils.getLoginStaffId();
            EmeRescueDept record = new EmeRescueDept();
            record.setId(id);
            record.setTeamFileId(fileid);
            this.emeRescueDeptServiceImpl.update((Object)record, staffid);
            this.updateDeptHistory(record, cid, staffid);
            return new ResponseData(ResponseStateEnum.success);
        }
        return new ResponseData(ResponseStateEnum.fail);
    }

    @RequiresPermissions(value={"emergency.edit"})
    @RequestMapping(value={"viewadd"}, method={RequestMethod.GET})
    public String page_viewAdd(Long deptId, Model model) {
        this.logger.info("\u5e94\u6025\u673a\u6784\u4e0e\u961f\u4f0d\u300b\u804c\u80fd\u90e8\u95e8\u300b\u65b0\u589e");
        model.addAttribute("deptId", (Object)deptId);
        return "work/eme/dialog_addEmeRescueDeptPerson";
    }

    @RequiresPermissions(value={"emergency.edit"})
    @RequestMapping(value={"viewedit/{id}"}, method={RequestMethod.GET})
    public String page_viewEdit(@PathVariable(value="id") Long id, Model model) {
        this.logger.info("\u5e94\u6025\u673a\u6784\u4e0e\u961f\u4f0d\u300b\u804c\u80fd\u90e8\u95e8\u300b\u7f16\u8f91");
        if (id != null) {
            EmeRescueDeptPerson emeRescueDeptPerson = (EmeRescueDeptPerson)this.emeRescueDeptPersonServiceImpl.getById(id);
            emeRescueDeptPerson = this.emeRescueDeptPersonServiceImpl.setProperty(emeRescueDeptPerson);
            model.addAttribute("emeRescueDeptPerson", (Object)emeRescueDeptPerson);
            if (emeRescueDeptPerson.getOrgChargeStaffId() != null) {
                emeRescueDeptPerson.setRealName(this.staffInfoServiceImpl.getStaffNameIncludeDelStatusByStaffId(emeRescueDeptPerson.getOrgChargeStaffId()));
            }
            if (emeRescueDeptPerson.getOrgId() != null) {
                emeRescueDeptPerson.setFullName(this.ICompanyOrganizationServiceImpl.getOrgNameById(emeRescueDeptPerson.getOrgId()));
            }
        }
        return "work/eme/dialog_editEmeRescueDeptPerson";
    }

    @Log(title="\u804c\u80fd\u90e8\u95e8\u65b0\u589e", type=20)
    @RequiresPermissions(value={"emergency.edit"})
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public ResponseData<String> ajax_addEmeRescueDeptPerson(EmeRescueDeptPerson emeRescueDeptPerson) {
        this.logger.info("ajax-\u5e94\u6025\u673a\u6784\u4e0e\u961f\u4f0d\u300b\u804c\u80fd\u90e8\u95e8\u300b\u65b0\u589e");
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffid = UserUtils.getLoginStaffId();
        ResponseData r = new ResponseData();
        if (emeRescueDeptPerson.getOrgId() == null) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u90e8\u95e8\u4e0d\u80fd\u4e3a\u7a7a");
            return r;
        }
        if (emeRescueDeptPerson.getDuty() == null || emeRescueDeptPerson.getDuty().trim().isEmpty()) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u804c\u80fd\u804c\u8d23\u4e0d\u5f97\u4e3a\u7a7a");
            return r;
        }
        if (StringUtils.isEmpty((CharSequence)emeRescueDeptPerson.getRealName())) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u90e8\u95e8\u8d1f\u8d23\u4eba\u4e0d\u5f97\u4e3a\u7a7a");
            return r;
        }
        emeRescueDeptPerson.setCid(cid);
        boolean isEmeRescueDeptPerson = this.emeRescueDeptPersonServiceImpl.isEmeRescueDeptPerson(emeRescueDeptPerson);
        if (isEmeRescueDeptPerson) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u8be5\u804c\u80fd\u90e8\u95e8\u5df2\u5b58\u5728,\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0");
            return r;
        }
        this.emeRescueDeptPersonServiceImpl.add((Object)emeRescueDeptPerson, staffid, cid);
        return r;
    }

    @Log(title="\u804c\u80fd\u90e8\u95e8\u7f16\u8f91", type=21)
    @RequiresPermissions(value={"emergency.edit"})
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"edit"}, method={RequestMethod.POST})
    public ResponseData<String> ajax_editEmeRescueDeptPerson(EmeRescueDeptPerson emeRescueDeptPerson) {
        this.logger.info("ajax-\u5e94\u6025\u673a\u6784\u4e0e\u961f\u4f0d\u300b\u804c\u80fd\u90e8\u95e8\u300b\u7f16\u8f91");
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffid = UserUtils.getLoginStaffId();
        ResponseData r = new ResponseData();
        if (emeRescueDeptPerson.getId() == null) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u65e0\u6cd5\u83b7\u53d6\u8be5\u6761\u6570\u636e");
            return r;
        }
        if (emeRescueDeptPerson.getOrgId() == null) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u90e8\u95e8\u4e0d\u80fd\u4e3a\u7a7a");
            return r;
        }
        if (emeRescueDeptPerson.getDuty() == null || emeRescueDeptPerson.getDuty().trim().isEmpty()) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u804c\u80fd\u804c\u8d23\u4e0d\u5f97\u4e3a\u7a7a");
            return r;
        }
        if (StringUtils.isEmpty((CharSequence)emeRescueDeptPerson.getRealName())) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u90e8\u95e8\u8d1f\u8d23\u4eba\u4e0d\u5f97\u4e3a\u7a7a");
            return r;
        }
        emeRescueDeptPerson.setCid(cid);
        boolean isEmeRescueDeptPerson = this.emeRescueDeptPersonServiceImpl.isEmeRescueDeptPerson(emeRescueDeptPerson);
        if (isEmeRescueDeptPerson) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u8be5\u804c\u80fd\u90e8\u95e8\u5df2\u5b58\u5728,\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0");
            return r;
        }
        this.emeRescueDeptPersonServiceImpl.updatePersonByPrimaryKey(emeRescueDeptPerson, staffid);
        this.updateDeptPersonHistory(emeRescueDeptPerson, cid, staffid);
        return r;
    }

    @Log(title="\u804c\u80fd\u90e8\u95e8\u5220\u9664", type=22)
    @RequiresPermissions(value={"emergency.edit"})
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"/del/{id}"}, method={RequestMethod.POST})
    public ResponseData<String> ajax_delEmeRescueDeptPerson(@PathVariable(value="id") Long id) {
        this.logger.info("ajax-\u5e94\u6025\u673a\u6784\u4e0e\u961f\u4f0d\u300b\u804c\u80fd\u90e8\u95e8\u300b\u5220\u9664");
        Long staffid = UserUtils.getLoginStaffId();
        ResponseData r = new ResponseData();
        if (id == null) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u65e0\u6cd5\u83b7\u53d6\u8be5\u6761\u6570\u636e");
            return r;
        }
        EmeRescueDeptPerson emeRescueDeptPerson = (EmeRescueDeptPerson)this.emeRescueDeptPersonServiceImpl.getById(id);
        emeRescueDeptPerson.setIsValid(Boolean.valueOf(false));
        this.emeRescueDeptPersonServiceImpl.update((Object)emeRescueDeptPerson, staffid);
        return r;
    }

    @RequiresPermissions(value={"emergency.view"})
    @Log(title="\u804c\u80fd\u90e8\u95e8", type=24)
    @RequestMapping(value={"/emerescuedeptexport"})
    public void emeRescueDeptExport(HttpServletResponse response, Long deptId) throws Exception {
        this.logger.info("ajax-\u3010\u804c\u80fd\u90e8\u95e8\u3011-\u5bfc\u51faExcel");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String fileName = "\u5e94\u6025\u6551\u63f4\u804c\u80fd\u90e8\u95e8\u6e05\u5355" + dateFormat.format(new Date()) + ".xls";
        Long cid = UserUtils.getLoginStaffCompanyId();
        String[] colums = new String[]{"\u90e8\u95e8\u540d\u79f0|fullName", "\u804c\u80fd\u804c\u8d23|duty", "\u90e8\u95e8\u8d1f\u8d23\u4eba|realName", "\u516c\u53f8\u804c\u52a1|jobTitle", "\u8054\u7cfb\u7535\u8bdd|phone"};
        List emeRescueDeptPersonList = this.emeRescueDeptPersonServiceImpl.getEmeRescueDeptPersonContactList(cid, deptId);
        response.setContentType("application/vnd.ms-excel");
        response.addHeader("Content-Disposition", "attachment; filename*=utf-8'zh_cn'" + URLEncoder.encode(new String(fileName.getBytes()), "utf-8"));
        ExportExcel listexcel = new ExportExcel();
        listexcel.simpleExport2("\u5e94\u6025\u804c\u80fd\u90e8\u95e8\u4eba\u5458", colums, emeRescueDeptPersonList, (OutputStream)response.getOutputStream());
    }
}

