/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.work.eme;

import cn.smarthse.common.annotation.Log;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.excel.ExportExcel;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.web.repeatform.RepeatUrlFormData;
import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.modules.health.entity.base.staff.StaffInfo;
import cn.smarthse.modules.health.entity.work.eme.EmeReportContact;
import cn.smarthse.modules.health.service.base.ICompanyService;
import cn.smarthse.modules.health.service.base.staff.IStaffInfoService;
import cn.smarthse.modules.health.service.sys.IHistoryBasicService;
import cn.smarthse.modules.health.service.work.eme.IEmeReportContactService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/work/eme/emereportcontact"})
public class EmeReportContactController
extends ControllerSupport {
    @DubboReference
    IEmeReportContactService emeReportContactServiceImpl;
    @DubboReference
    IStaffInfoService staffInfoServiceImpl;
    @DubboReference
    ICompanyService companyServiceImpl;
    @DubboReference
    IHistoryBasicService historyService;

    private void updateHistory(EmeReportContact newEntity, Long cid, Long staffId) {
    }

    @RequiresPermissions(value={"emergency.view"})
    @RequestMapping(method={RequestMethod.GET})
    public String init(HttpSession session, ModelMap m) {
        this.logger.info("\u5e94\u6025\u673a\u6784\u4e0e\u961f\u4f0d\u300b\u4e0a\u62a5\u8054\u7cfb\u5355");
        return "work/eme/emereportcontact_list";
    }

    @RequiresPermissions(value={"emergency.view"})
    @ResponseBody
    @RequestMapping(value={"listData"})
    public JqGridData<EmeReportContact> listData(JqGridParam param) {
        this.logger.info(param.toString());
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        PageInfo list = this.emeReportContactServiceImpl.getEmeReportContactListByGridParam(param);
        JqGridData data = new JqGridData(list, param);
        return data;
    }

    @RequiresPermissions(value={"emergency.edit"})
    @RequestMapping(value={"viewadd"}, method={RequestMethod.GET})
    public String page_viewAdd(Model model) {
        this.logger.info("\u5e94\u6025\u673a\u6784\u4e0e\u961f\u4f0d\u300b\u4e0a\u62a5\u8054\u7cfb\u5355\u300b\u65b0\u589e");
        return "work/eme/dialog_addEmeReportContact";
    }

    @RequiresPermissions(value={"emergency.edit"})
    @RequestMapping(value={"viewedit/{id}"}, method={RequestMethod.GET})
    public String page_viewEdit(@PathVariable(value="id") Long id, Model model) {
        this.logger.info("\u5e94\u6025\u673a\u6784\u4e0e\u961f\u4f0d\u300b\u4e0a\u62a5\u8054\u7cfb\u5355\u300b\u7f16\u8f91");
        if (id != null) {
            EmeReportContact emeReportContact = (EmeReportContact)this.emeReportContactServiceImpl.getById(id);
            model.addAttribute("emeReportContact", (Object)emeReportContact);
        }
        return "work/eme/dialog_editEmeReportContact";
    }

    @Log(title="\u4e0a\u62a5\u8054\u7cfb\u5355\u65b0\u589e", type=20)
    @RequiresPermissions(value={"emergency.edit"})
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public ResponseData<String> ajax_addEmeReportContact(EmeReportContact emeReportContact) {
        this.logger.info("ajax-\u5e94\u6025\u673a\u6784\u4e0e\u961f\u4f0d\u300b\u4e0a\u62a5\u8054\u7cfb\u5355\u300b\u65b0\u589e");
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffid = UserUtils.getLoginStaffId();
        ResponseData r = new ResponseData();
        if (emeReportContact.getPersonName() == null || emeReportContact.getPersonName().trim().isEmpty()) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u59d3\u540d\u4e0d\u5f97\u4e3a\u7a7a");
            return r;
        }
        if (emeReportContact.getPersonJob() == null || emeReportContact.getPersonJob().trim().isEmpty()) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u804c\u52a1\u4e0d\u5f97\u4e3a\u7a7a");
            return r;
        }
        if (emeReportContact.getPersonTel() == null || emeReportContact.getPersonTel().trim().isEmpty()) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u8054\u7cfb\u7535\u8bdd\u4e0d\u5f97\u4e3a\u7a7a");
            return r;
        }
        if (emeReportContact.getPersonCompany() == null || emeReportContact.getPersonCompany().trim().isEmpty()) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u6240\u5728\u5355\u4f4d\u4e0d\u5f97\u4e3a\u7a7a");
            return r;
        }
        this.emeReportContactServiceImpl.add((Object)emeReportContact, staffid, cid);
        return r;
    }

    @Log(title="\u4e0a\u62a5\u8054\u7cfb\u5355\u7f16\u8f91", type=21)
    @RequiresPermissions(value={"emergency.edit"})
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"edit"}, method={RequestMethod.POST})
    public ResponseData<String> ajax_editEmeReportContact(EmeReportContact emeReportContact) {
        this.logger.info("ajax-\u5e94\u6025\u673a\u6784\u4e0e\u961f\u4f0d\u300b\u4e0a\u62a5\u8054\u7cfb\u5355\u300b\u7f16\u8f91");
        Long staffid = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        ResponseData r = new ResponseData();
        if (emeReportContact.getId() == null) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u65e0\u6cd5\u83b7\u53d6\u8be5\u6761\u6570\u636e");
            return r;
        }
        if (emeReportContact.getPersonName() == null || emeReportContact.getPersonName().trim().isEmpty()) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u59d3\u540d\u4e0d\u5f97\u4e3a\u7a7a");
            return r;
        }
        if (emeReportContact.getPersonJob() == null || emeReportContact.getPersonJob().trim().isEmpty()) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u804c\u52a1\u4e0d\u5f97\u4e3a\u7a7a");
            return r;
        }
        if (emeReportContact.getPersonTel() == null || emeReportContact.getPersonTel().trim().isEmpty()) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u8054\u7cfb\u7535\u8bdd\u4e0d\u5f97\u4e3a\u7a7a");
            return r;
        }
        if (emeReportContact.getPersonCompany() == null || emeReportContact.getPersonCompany().trim().isEmpty()) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u6240\u5728\u5355\u4f4d\u4e0d\u5f97\u4e3a\u7a7a");
            return r;
        }
        this.emeReportContactServiceImpl.update((Object)emeReportContact, staffid);
        this.updateHistory(emeReportContact, cid, staffid);
        return r;
    }

    @Log(title="\u4e0a\u62a5\u8054\u7cfb\u5355\u5220\u9664", type=22)
    @RequiresPermissions(value={"emergency.edit"})
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"/del/{id}"}, method={RequestMethod.POST})
    public ResponseData<String> ajax_delEmeReportContact(@PathVariable(value="id") Long id) {
        this.logger.info("ajax-\u5e94\u6025\u673a\u6784\u4e0e\u961f\u4f0d\u300b\u4e0a\u62a5\u8054\u7cfb\u5355\u300b\u5220\u9664");
        Long staffid = UserUtils.getLoginStaffId();
        ResponseData r = new ResponseData();
        if (id == null) {
            r.setState(ResponseStateEnum.fail);
            r.setContent("\u65e0\u6cd5\u83b7\u53d6\u8be5\u6761\u6570\u636e");
            return r;
        }
        EmeReportContact emeReportContact = (EmeReportContact)this.emeReportContactServiceImpl.getById(id);
        emeReportContact.setIsValid(Boolean.valueOf(false));
        this.emeReportContactServiceImpl.update((Object)emeReportContact, staffid);
        return r;
    }

    @RequiresPermissions(value={"emergency.edit"})
    @RepeatUrlFormData
    @ResponseBody
    @RequestMapping(value={"staffinfo"}, method={RequestMethod.POST})
    public ResponseData<List<Object>> ajax_staffInfo(Long id) {
        this.logger.info("ajax-\u5e94\u6025\u673a\u6784\u4e0e\u961f\u4f0d\u300b\u5e94\u6025\u6551\u63f4\u961f\u4f0d\u300b\u67e5\u8be2\u4eba\u5458\u4fe1\u606f");
        ResponseData r = new ResponseData();
        ArrayList<Object> list = new ArrayList<Object>();
        if (id != null) {
            StaffInfo staffInfo = this.staffInfoServiceImpl.getStaffInfoWithStaffBasicWorkById(id);
            list.add(staffInfo);
            if (staffInfo.getCid() != null) {
                Company company = (Company)this.companyServiceImpl.getById(staffInfo.getCid());
                if (company != null && company.getName() != null) {
                    list.add(company.getName());
                } else {
                    list.add("");
                }
            } else {
                list.add("");
            }
        }
        r.setResult(list);
        return r;
    }

    @RequiresPermissions(value={"emergency.view"})
    @Log(title="\u4e0a\u62a5\u8054\u7cfb\u5355", type=24)
    @RequestMapping(value={"/emereportcontactexport"})
    public void emeReportContactExport(HttpServletResponse response) throws Exception {
        this.logger.info("ajax-\u3010\u4e0a\u62a5\u8054\u7cfb\u5355\u3011-\u5bfc\u51faExcel");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String fileName = "\u5e94\u6025\u4e8b\u6545\u4e0a\u62a5\u8054\u7cfb\u5355" + dateFormat.format(new Date()) + ".xls";
        Long cid = UserUtils.getLoginStaffCompanyId();
        String[] colums = new String[]{"\u59d3\u540d|personName", "\u804c\u52a1|personJob", "\u8054\u7cfb\u7535\u8bdd|personTel", "\u6240\u5728\u5355\u4f4d|personCompany", "\u5907\u6ce8|remark"};
        List emeReportContactList = this.emeReportContactServiceImpl.getEmeReportContactList(cid);
        response.setContentType("application/vnd.ms-excel");
        response.addHeader("Content-Disposition", "attachment; filename*=utf-8'zh_cn'" + URLEncoder.encode(new String(fileName.getBytes()), "utf-8"));
        ExportExcel listexcel = new ExportExcel();
        listexcel.simpleExport2("\u4e0a\u62a5\u8054\u7cfb\u5355", colums, emeReportContactList, (OutputStream)response.getOutputStream());
    }
}

