/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.work.eme;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.BusinessNoTypeEnum;
import cn.smarthse.common.framework.enums.BusinessTypeEnum;
import cn.smarthse.common.framework.excel.ExportExcel;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.entity.work.eme.EmeDrill;
import cn.smarthse.modules.health.entity.work.eme.EmeDrillFiles;
import cn.smarthse.modules.health.entity.work.planyear.vo.PlanYearExecute;
import cn.smarthse.modules.health.enums.planyear.PlanYearDetailImplState;
import cn.smarthse.modules.health.service.base.IBusinessNoService;
import cn.smarthse.modules.health.service.work.eme.IEmeDrillService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.SyncBusinessUtil;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/work/eme/emeDrill"})
public class EmeDrillController
extends ControllerSupport {
    @DubboReference
    private IEmeDrillService emeDrillService;
    @DubboReference
    private IBusinessNoService businessNoService;

    @RequiresPermissions(value={"emergency.view"})
    @RequestMapping
    public String page_index(EmeDrill data, HttpSession session, ModelMap m) {
        data.setStatus(Byte.valueOf((byte)0));
        m.put((Object)"query", (Object)data);
        return "work/eme/eme_drill_unfinish_list";
    }

    @RequiresPermissions(value={"emergency.view"})
    @RequestMapping(value={"/count"}, method={RequestMethod.GET})
    public String count(EmeDrill data, HttpSession session, ModelMap m) {
        data.setStatus(Byte.valueOf((byte)1));
        m.put((Object)"query", (Object)data);
        return "work/eme/eme_drill_count";
    }

    @RequiresPermissions(value={"emergency.view"})
    @ResponseBody
    @RequestMapping(value={"listData"})
    public JqGridData<EmeDrill> listData(HttpSession session, JqGridParam gparam, EmeDrill param) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        UserUtils.startWebDataScope();
        PageInfo list = this.emeDrillService.getDrillList(gparam, param);
        JqGridData data = new JqGridData(list, gparam);
        return data;
    }

    @RequiresPermissions(value={"emergency.edit"})
    @RequestMapping(value={"/add"}, method={RequestMethod.GET})
    public String add(HttpSession session, ModelMap m, EmeDrill data) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        data.setNo(this.businessNoService.getBusinessNo(cid, BusinessNoTypeEnum.EMEDRILL.getCode()));
        m.put((Object)"data", (Object)data);
        return "work/eme/eme_drill_edit";
    }

    @RequiresPermissions(value={"emergency.edit"})
    @RequestMapping(value={"/edit/{id}"}, method={RequestMethod.GET})
    public String edit(HttpSession session, ModelMap m, @PathVariable Long id) {
        EmeDrill data = null;
        data = id != null ? this.emeDrillService.getDetailById(id) : new EmeDrill();
        m.put((Object)"data", (Object)data);
        return "work/eme/eme_drill_edit";
    }

    @RequiresPermissions(value={"emergency.view"})
    @RequestMapping(value={"/view/{id}"}, method={RequestMethod.GET})
    public String view(HttpSession session, ModelMap m, @PathVariable Long id) {
        EmeDrill data = null;
        data = id != null ? this.emeDrillService.getDetailById(id) : new EmeDrill();
        m.put((Object)"data", (Object)data);
        return "work/eme/eme_drill_info";
    }

    @RequiresPermissions(value={"emergency.edit"})
    @ResponseBody
    @RequestMapping(value={"/info"}, method={RequestMethod.POST})
    public ResponseData<EmeDrill> info(HttpSession session, HttpServletRequest request, EmeDrill emeDrillForm) {
        ResponseData data = new ResponseData();
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffId = UserUtils.getLoginStaffId();
        this.setFilesByRequest(request, emeDrillForm);
        if (emeDrillForm.getId() == null && StringUtils.isEmpty((CharSequence)emeDrillForm.getOrgId())) {
            emeDrillForm.setOrgId("" + UserUtils.getOrgId());
        }
        emeDrillForm = this.emeDrillService.insertOrUpdate(emeDrillForm, cid, staffId);
        PlanYearExecute planYearExecute = new PlanYearExecute();
        if (emeDrillForm.getStatus() != null && emeDrillForm.getStatus() == 1) {
            planYearExecute.setImplState(PlanYearDetailImplState.implemented);
        } else {
            planYearExecute.setImplState(PlanYearDetailImplState.progressing);
        }
        planYearExecute.setCid(cid);
        planYearExecute.setBusinessType(BusinessTypeEnum.emeDrills.getCode());
        planYearExecute.setBusinessId(emeDrillForm.getId());
        planYearExecute.setImplStartDate(emeDrillForm.getStartTime());
        planYearExecute.setImplWorkName(emeDrillForm.getName());
        planYearExecute.setImplManagerId(emeDrillForm.getManager());
        SyncBusinessUtil.executeUpdatePlanYearDetail(planYearExecute);
        data.setContent("\u64cd\u4f5c\u6210\u529f");
        data.setResult((Object)emeDrillForm);
        return data;
    }

    private void setFilesByRequest(HttpServletRequest request, EmeDrill emeDrillForm) {
        String[] schemesIds = request.getParameterValues("schemesIds");
        String[] sumarriesIds = request.getParameterValues("sumarriesIds");
        String[] recordsIds = request.getParameterValues("recordsIds");
        String[] othersIds = request.getParameterValues("othersIds");
        emeDrillForm.setSchemes(this.convertFileIds(schemesIds));
        emeDrillForm.setSumarries(this.convertFileIds(sumarriesIds));
        emeDrillForm.setRecords(this.convertFileIds(recordsIds));
        emeDrillForm.setOthers(this.convertFileIds(othersIds));
    }

    private List<EmeDrillFiles> convertFileIds(String[] fileIds) {
        ArrayList<EmeDrillFiles> files = new ArrayList<EmeDrillFiles>();
        if (fileIds == null || fileIds.length == 0) {
            return files;
        }
        for (String fileId : fileIds) {
            if (!StringUtils.isLong((String)fileId)) continue;
            EmeDrillFiles file = new EmeDrillFiles();
            file.setFileId(Long.valueOf(Long.parseLong(fileId)));
            files.add(file);
        }
        return files;
    }

    @RequiresPermissions(value={"emergency.edit"})
    @ResponseBody
    @RequestMapping(value={"/del/{ids}"}, method={RequestMethod.DELETE})
    public ResponseData<String> ajax_delete(@PathVariable String ids, HttpSession session) {
        this.logger.info("ajax-\u3010\u3011-\u5220\u9664\u8bb0\u5f55:" + ids);
        Long staffId = UserUtils.getLoginStaffId();
        this.emeDrillService.deleteByIds(ids, staffId);
        Long cid = UserUtils.getLoginStaffCompanyId();
        List idArray = StringUtils.parseToLongList((String)ids, (String)",");
        if (idArray != null && idArray.size() > 0) {
            for (Long id : idArray) {
                PlanYearExecute planYearExecute = new PlanYearExecute();
                planYearExecute.setImplState(PlanYearDetailImplState.unimplemented);
                planYearExecute.setCid(cid);
                planYearExecute.setBusinessId(id);
                planYearExecute.setBusinessType(BusinessTypeEnum.emeDrills.getCode());
                SyncBusinessUtil.executeUpdatePlanYearDetail(planYearExecute);
            }
        }
        ResponseData data = new ResponseData();
        data.setResult((Object)ids);
        data.setContent("\u5220\u9664\u6210\u529f");
        return data;
    }

    @RequiresPermissions(value={"emergency.view"})
    @RequestMapping(value={"export"})
    public void export(EmeDrill data, HttpSession session, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.logger.info("ajax-\u3010\u3011-\u5bfc\u51faExcel");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String fileName = "\u5df2\u5b8c\u6210\u5e94\u6025\u6f14\u7ec3\u6e05\u5355" + dateFormat.format(new Date()) + ".xls";
        response.setHeader("Content-Disposition", "attachment;filename=" + new String(fileName.getBytes("GBK"), "ISO8859_1"));
        response.setContentType("application/octet-stream; charset=GBK");
        String[] colums = new String[]{"\u6f14\u7ec3\u540d\u79f0|name", "\u6f14\u7ec3\u7c7b\u578b|typeName", "\u6f14\u7ec3\u65f6\u95f4|startTime", "\u8d1f\u8d23\u4eba|managerName", "\u5b8c\u6210\u65f6\u95f4|updateDate"};
        data.setCid(UserUtils.getLoginStaffCompanyId());
        data.setStatus(Byte.valueOf((byte)1));
        UserUtils.startWebDataScope();
        List list = this.emeDrillService.listDetails(data);
        ExportExcel export = new ExportExcel();
        export.simpleExport3("\u5df2\u5b8c\u6210\u5e94\u6025\u6f14\u7ec3\u6e05\u5355", colums, list, (OutputStream)response.getOutputStream());
    }

    @RequiresPermissions(value={"emergency.edit"})
    @ResponseBody
    @RequestMapping(value={"/cancel/{ids}"}, method={RequestMethod.POST})
    public ResponseData<String> cancel(@PathVariable String ids, HttpSession session) {
        this.logger.info("ajax-\u3010\u3011-\u5220\u9664\u8bb0\u5f55:" + ids);
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffId = UserUtils.getLoginStaffId();
        this.emeDrillService.cancelByIds(ids, staffId, cid);
        ResponseData data = new ResponseData();
        data.setResult((Object)ids);
        data.setContent("\u4f5c\u5e9f\u6210\u529f");
        return data;
    }
}

