/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.work.dosemonitor;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.dosemonitor.entity.DoseMonitor;
import cn.smarthse.modules.health.dosemonitor.enums.DoseMonitorStatusEnum;
import cn.smarthse.modules.health.dosemonitor.model.DoseMonitorDataModel;
import cn.smarthse.modules.health.dosemonitor.model.DoseMonitorModel;
import cn.smarthse.modules.health.dosemonitor.model.params.DoseMonitorDataParam;
import cn.smarthse.modules.health.dosemonitor.model.params.DoseMonitorParam;
import cn.smarthse.modules.health.dosemonitor.service.IDoseMonitorService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.smarthse.framework.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"dosemonitor"})
public class DoseMonitorController
extends ControllerSupport {
    @DubboReference
    private IDoseMonitorService doseMonitorService;

    @RequestMapping(value={"doseMonitorPage"})
    public String doseMonitorPage(ModelMap m) {
        Date start = DateUtils.getYearFirstTime((int)DateUtils.getThisYear());
        Date end = DateUtils.getYearLastTime((int)DateUtils.getThisYear());
        DoseMonitorParam param = new DoseMonitorParam();
        param.setCid(UserUtils.getLoginStaffCompanyId());
        param.setStartDate(start);
        param.setEndDate(end);
        param.setStatusList(List.of(DoseMonitorStatusEnum.CHECKED.getKey(), DoseMonitorStatusEnum.NOCHECK_FROMWANDA.getKey(), DoseMonitorStatusEnum.NOCHECK.getKey()));
        Long countCurrYearDoseMonitor = this.doseMonitorService.countDoseMonitorPersons(param);
        m.put((Object)"countCurrYearDoseMonitor", (Object)(countCurrYearDoseMonitor == null ? 0L : countCurrYearDoseMonitor));
        return "views/keyFactorManagement/personDose/index";
    }

    @RequestMapping(value={"pageDataDoseMonitor"})
    @ResponseBody
    public ResponseData<JqGridData<DoseMonitorModel>> pageDataDoseMonitor(JqGridParam jqGridParam, Date start, Date end, String searchName) {
        if (start == null) {
            start = DateUtils.getYearFirstTime((int)DateUtils.getThisYear());
        }
        if (end == null) {
            end = DateUtils.getYearLastTime((int)DateUtils.getThisYear());
        }
        DoseMonitorParam param = new DoseMonitorParam();
        param.setCid(UserUtils.getLoginStaffCompanyId());
        param.setStartDate(start);
        param.setEndDate(end);
        param.setSearchName(searchName);
        param.setStatusList(List.of(DoseMonitorStatusEnum.CHECKED.getKey(), DoseMonitorStatusEnum.NOCHECK_FROMWANDA.getKey(), DoseMonitorStatusEnum.NOCHECK.getKey()));
        PageInfo doseMonitorModelPageInfo = this.doseMonitorService.pageDoseMonitorByCid(jqGridParam, param);
        return ResponseData.success((Object)new JqGridData(doseMonitorModelPageInfo, jqGridParam));
    }

    @RequestMapping(value={"doseMonitorDetailPage"})
    public String doseMonitorDetailPage(Long doseMonitorId, ModelMap m) {
        DoseMonitor doseMonitor = (DoseMonitor)this.doseMonitorService.getById(doseMonitorId);
        m.put((Object)"doseMonitor", (Object)doseMonitor);
        return "views/keyFactorManagement/personDose/detail";
    }

    @RequestMapping(value={"pageDataDoseMonitorDetail"})
    @ResponseBody
    public ResponseData<JqGridData<DoseMonitorDataModel>> pageDataDoseMonitorDetail(JqGridParam jqGridParam, Long doseMonitroId, String searchName) {
        if (doseMonitroId == null) {
            return ResponseData.success((Object)new JqGridData(new ArrayList(), jqGridParam));
        }
        DoseMonitorDataParam param = new DoseMonitorDataParam();
        param.setPersonName(searchName);
        param.setDoseMonitorId(doseMonitroId);
        PageInfo doseMonitorModelPageInfo = this.doseMonitorService.pageDoseMonitorDataDetail(jqGridParam, param);
        return ResponseData.success((Object)new JqGridData(doseMonitorModelPageInfo, jqGridParam));
    }

    @RequestMapping(value={"pageDataDoseMonitorDataByIdCard"})
    @ResponseBody
    public JqGridData<DoseMonitorDataModel> pageDoseMonitorDataByIdCard(JqGridParam jqGridParam, String idCard, Long staffId) {
        if (StringUtils.isBlank((CharSequence)idCard) && staffId == null) {
            throw new ServiceException("\u5fc5\u4f20\u53c2\u6570\u4e3a\u7a7a\uff01");
        }
        DoseMonitorDataParam param = new DoseMonitorDataParam();
        param.setCid(UserUtils.getLoginStaffCompanyId());
        param.setIdCard(idCard);
        param.setStaffId(staffId);
        PageInfo doseMonitorModelPageInfo = this.doseMonitorService.pageDoseMonitorDataDetail(jqGridParam, param);
        return new JqGridData(doseMonitorModelPageInfo, jqGridParam);
    }
}

