/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.work.check.newcheck20241015;

import cn.smarthse.common.util.StringUtils;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import cn.smarthse.framework.sensitive.utils.DesensitizationUtils;
import cn.smarthse.modules.health.service.work.check.newcheck20241015.IPhcPhysicalCheckStaffBasicInfoService;
import cn.smarthse.modules.health.thirdOrganization.util.StringUtil;
import cn.smarthse.modules.health.vo.work.check.CheckStaffInfo;
import cn.smarthse.services.wanda.api.entity.WandaDictValue;
import cn.smarthse.services.wanda.api.entity.WandaHcRItems;
import cn.smarthse.services.wanda.api.service.IWandaDictionaryService;
import cn.smarthse.web.util.UserUtils;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PhcPhysicalCheckHelper {
    @Autowired
    private HttpSession session;
    @DubboReference(timeout=60000)
    private IWandaDictionaryService dictionaryService;
    @DubboReference(check=false)
    private IPhcPhysicalCheckStaffBasicInfoService phcPhysicalCheckStaffBasicInfoService;

    protected String getWaterMarkText() {
        String loginUserType = String.valueOf(this.session.getAttribute("loginUserType"));
        return "1".equals(loginUserType) ? String.valueOf(this.session.getAttribute("superviseFullName")) : UserUtils.getCurrentCompanyFromDataCenter().getName();
    }

    protected String getWaterMarkTextPhone() {
        String loginUserType = String.valueOf(this.session.getAttribute("loginUserType"));
        String phone = "1".equals(loginUserType) ? String.valueOf(this.session.getAttribute("superviseUserTel")) : UserUtils.getCurrentUser().getMobile();
        return DesensitizationUtils.desensitized((CharSequence)phone, (DesensitizationType)DesensitizationType.MOBILE_PHONE);
    }

    protected List<CheckStaffInfo> settingDicValue(List<CheckStaffInfo> list) {
        Map allWandRiskFactors = this.dictionaryService.getAllWandRiskFactorByCache();
        Map jobMap = this.dictionaryService.getDictValueByCodeCache(Long.valueOf(9L));
        Map itemMap = this.dictionaryService.getDictValueByCodeCache(Long.valueOf(10L));
        Map zyjjzMap = this.dictionaryService.getDictValueByCodeCache(Long.valueOf(20L));
        Map ysjzbMap = this.dictionaryService.getDictValueByCodeCache(Long.valueOf(21L));
        Map conclusionMap = this.dictionaryService.getDictValueByCodeCache(Long.valueOf(19L));
        List<String> otherHazardCode = Arrays.asList("16", "11999", "12999", "13999", "14999", "15999");
        for (CheckStaffInfo checkInfo : list) {
            String[] dictValue;
            if (checkInfo == null) continue;
            String conclusionName = (String)conclusionMap.get(checkInfo.getConclusion());
            checkInfo.setConclusionName(conclusionName);
            List<Object> hazardNameList = new ArrayList<String>();
            String hazardCodes = checkInfo.getHazardCodes();
            String otherHazardNames = checkInfo.getOtherHazardNames();
            if (StringUtils.isNotEmpty((String)hazardCodes)) {
                String[] contactHazardCodeArr;
                for (String code : contactHazardCodeArr = hazardCodes.split(",")) {
                    if (otherHazardCode.contains(code) || (dictValue = (String[])allWandRiskFactors.get(code)) == null) continue;
                    String value = dictValue.getValueLabel();
                    hazardNameList.add(value);
                }
            }
            if (StringUtils.isNotEmpty((String)otherHazardNames)) {
                hazardNameList.addAll(Arrays.asList(otherHazardNames.split(",")));
            }
            hazardNameList = hazardNameList.stream().distinct().collect(Collectors.toList());
            checkInfo.setContactHazardName(StringUtils.join(hazardNameList, (String)","));
            switch (checkInfo.getConclusion()) {
                case "3": {
                    String sptId = checkInfo.getSptId();
                    StringBuilder sptStr = new StringBuilder();
                    if (!StringUtil.isEmpty((String)sptId) && sptId.endsWith(";")) {
                        String[] split;
                        dictValue = split = sptId.split(";");
                        int value = dictValue.length;
                        for (int i = 0; i < value; ++i) {
                            String s = dictValue[i];
                            sptStr.append((String)ysjzbMap.get(s)).append(";");
                        }
                        checkInfo.setSptId(sptStr.toString());
                        break;
                    }
                    checkInfo.setSptId((String)ysjzbMap.get(sptId));
                    break;
                }
                case "4": {
                    String hazardCode = checkInfo.getHazardCodes();
                    StringBuilder cotStr = new StringBuilder();
                    if (!StringUtil.isEmpty((String)hazardCode) && hazardCode.contains(",")) {
                        String[] split;
                        for (String s : split = hazardCode.split(",")) {
                            WandaDictValue wandaDictValue = (WandaDictValue)allWandRiskFactors.get(s);
                            if (wandaDictValue == null) continue;
                            cotStr.append(wandaDictValue.getValueLabel()).append(",");
                        }
                        checkInfo.setCotId(cotStr.toString());
                        break;
                    }
                    WandaDictValue wandaDictValue = (WandaDictValue)allWandRiskFactors.get(hazardCode);
                    if (wandaDictValue == null) break;
                    String valueLabel = wandaDictValue.getValueLabel();
                    checkInfo.setCotId(valueLabel);
                    break;
                }
                case "2": {
                    List hcRItemsList = this.phcPhysicalCheckStaffBasicInfoService.getXfcItem(checkInfo.getCardId(), checkInfo.getDiagnosisId());
                    StringBuilder builder = new StringBuilder();
                    for (WandaHcRItems hcRItems : hcRItemsList) {
                        String repeatItemId = hcRItems.getRepeatItemId();
                        if ("90001".equals(repeatItemId)) {
                            builder.append(hcRItems.getOtherItemName()).append(",");
                            continue;
                        }
                        String itemName = (String)itemMap.get(repeatItemId);
                        if (!StringUtils.isNotEmpty((String)itemName)) continue;
                        builder.append(itemName).append(",");
                    }
                    if (!StringUtils.isNotEmpty((String)builder.toString())) break;
                    checkInfo.setItemId(builder.substring(0, builder.length() - 1));
                    break;
                }
            }
            if (!"99-9999".equals(checkInfo.getJobCode()) && StringUtil.isEmpty((String)checkInfo.getOtherJobName())) {
                checkInfo.setOtherJobName((String)jobMap.get(checkInfo.getJobCode()));
            }
            checkInfo.setJobCode(checkInfo.getOtherJobName());
        }
        return list;
    }
}

