/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.work.check.checkV3221;

import cn.smarthse.common.framework.database.persistence.LayUiResponseResult;
import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import cn.smarthse.framework.sensitive.utils.DesensitizationUtils;
import cn.smarthse.modules.datacentre.entity.Company;
import cn.smarthse.modules.health.bx.model.BxZybDetailVo;
import cn.smarthse.modules.health.bx.model.BxZybVo;
import cn.smarthse.modules.health.bx.service.IBxZybService;
import cn.smarthse.modules.health.entity.base.staff.StaffBasicInfo;
import cn.smarthse.modules.health.entity.work.check.checkV3221.PhcPhysicalCheckSearchVo;
import cn.smarthse.modules.health.entity.work.check.checkV3221.PhcPhysicalCheckV3221;
import cn.smarthse.modules.health.entity.work.check.checkV3221.PhcPhysicalStaffCheckInfo;
import cn.smarthse.modules.health.entity.work.check.checkV3221.PhcPhysicalStatisticsModel;
import cn.smarthse.modules.health.entity.work.check.checkV3221.PhcPhysicalViewModel;
import cn.smarthse.modules.health.param.FcythSearchParam;
import cn.smarthse.modules.health.service.base.staff.IStaffBasicInfoService;
import cn.smarthse.modules.health.service.work.check.checkV3221.IPhcPhysicalCheckV3221Service;
import cn.smarthse.modules.health.service.work.check.checkV3221.IPhcPhysicalStaffCheckInfoService;
import cn.smarthse.modules.health.service.work.check.checkv3222.IPhcPhysicalCheckV3222Service;
import cn.smarthse.modules.health.vo.work.check.OccPatientVo;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpSession;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/work/newCheck"})
public class PhcPhysicalCheckV3221Controller
extends ControllerSupport {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @DubboReference(timeout=600000, check=false)
    private IPhcPhysicalCheckV3221Service phcPhysicalCheckV3221Service;
    @DubboReference(timeout=600000, check=false)
    private IPhcPhysicalCheckV3222Service phcPhysicalCheckV3222Service;
    @DubboReference(timeout=600000, check=false)
    private IPhcPhysicalStaffCheckInfoService staffCheckInfoService;
    @DubboReference
    private IStaffBasicInfoService infoService;
    @Resource
    protected HttpSession session;
    @DubboReference
    private IBxZybService bxZybService;

    @ResponseBody
    @RequestMapping(value={"/convertedData"})
    public String convertedData(String unifiedSocialCcs) {
        List<String> unifiedSocialCcList = null;
        if (StringUtils.isNotEmpty((String)unifiedSocialCcs)) {
            unifiedSocialCcList = Arrays.asList(unifiedSocialCcs.split(","));
        }
        Integer page = 1;
        Integer pageSize = 100;
        this.logger.info("\u4f53\u68c0V3221\u6570\u636e\u8f6c\u6362\uff1a\u624b\u52a8\u6570\u636e\u8f6c\u6362\u5f00\u59cb");
        if (unifiedSocialCcList != null && unifiedSocialCcList.size() == 1) {
            try {
                this.phcPhysicalCheckV3221Service.convertedData(unifiedSocialCcList, page, pageSize);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            PageInfo creditCodePageInfo = this.phcPhysicalCheckV3221Service.getPage(unifiedSocialCcList, page, pageSize);
            for (int i = 1; i <= creditCodePageInfo.getPages(); ++i) {
                try {
                    this.phcPhysicalCheckV3221Service.convertedData(unifiedSocialCcList, Integer.valueOf(i), pageSize);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return "\u8f6c\u6362\u5b8c\u6210";
    }

    @GetMapping(value={"/phcPhysicalCheckTask"})
    @ResponseBody
    public String phcPhysicalCheckTask(String unifiedSocialCcs) {
        this.phcPhysicalCheckV3221Service.phcPhysicalCheckTask(unifiedSocialCcs, null);
        return "success";
    }

    @GetMapping(value={"/phcPhysicalCheckTask2"})
    @ResponseBody
    public String phcPhysicalCheckTask2(String unifiedSocialCcs) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(2023, 0, 1, 0, 0, 0);
        Date endTime = calendar.getTime();
        this.phcPhysicalCheckV3222Service.phcPhysicalCheckTask(unifiedSocialCcs, endTime);
        return "success";
    }

    @GetMapping(value={"/appendData"})
    @ResponseBody
    public String appendData(String unifiedSocialCcs) {
        this.phcPhysicalCheckV3221Service.appendPhysicalCheckData(unifiedSocialCcs);
        return "success";
    }

    @GetMapping(value={"/appendEmpData"})
    @ResponseBody
    public String appendEmpCreditCodeData(String unifiedSocialCcs) {
        this.phcPhysicalCheckV3221Service.appendEmpCreditCodeData(unifiedSocialCcs);
        return "success";
    }

    @GetMapping(value={"/correctData"})
    @ResponseBody
    public String correctData(String unifiedSocialCcs) {
        this.phcPhysicalCheckV3221Service.correctData(unifiedSocialCcs);
        return "success";
    }

    @GetMapping(value={"/CheckCorrectData"})
    @ResponseBody
    public String CheckCorrectData() {
        this.phcPhysicalCheckV3221Service.checkAndCorrect(UserUtils.getLoginStaffCompanyId());
        return "success";
    }

    @GetMapping(value={"/updateCheckNum"})
    @ResponseBody
    public String updateCheckNum(Integer year, Integer size) {
        this.phcPhysicalCheckV3221Service.updateCheckNum(UserUtils.getLoginStaffCompanyId(), year, size);
        return "success";
    }

    @RequestMapping(value={"/toIndex"})
    @RequiresPermissions(value={"healthCheck"})
    public String toIndex(ModelMap m, PhcPhysicalCheckSearchVo searchVo) {
        this.settingValueForSearchVo(searchVo);
        m.put((Object)"searchVo", (Object)searchVo);
        List yearList = this.phcPhysicalCheckV3221Service.getYearList(searchVo);
        if (CollectionUtils.isEmpty((Collection)yearList)) {
            yearList.add(LocalDateTime.now().getYear());
        }
        m.put((Object)"yearList", (Object)yearList);
        String watermarkedTextInformation = this.getWaterMarkText();
        m.put((Object)"watermarkedTextInformation", (Object)watermarkedTextInformation);
        String watermarkedTextInformationPhone = this.getWaterMarkTextPhone();
        m.put((Object)"watermarkedTextInformationPhone", (Object)watermarkedTextInformationPhone);
        return "work/check/checkV3221/index";
    }

    @ResponseBody
    @RequestMapping(value={"statisticsByYear"})
    public ResponseData<PhcPhysicalStatisticsModel> statisticsByYear(PhcPhysicalCheckSearchVo searchVo) {
        ResponseData responseData = new ResponseData();
        this.settingValueForSearchVo(searchVo);
        PhcPhysicalStatisticsModel statisticsModel = this.phcPhysicalCheckV3221Service.getStatisticsModel(searchVo);
        responseData.setResult((Object)statisticsModel);
        return responseData;
    }

    @ResponseBody
    @RequestMapping(value={"/listData"})
    public JqGridData<PhcPhysicalCheckV3221> listData(JqGridParam param, PhcPhysicalCheckSearchVo searchVo, Integer isSearchThirdMatch) {
        this.settingValueForSearchVo(searchVo);
        PageInfo pageInfo = this.phcPhysicalCheckV3221Service.getPageInfoBySearchVo(param, searchVo, isSearchThirdMatch);
        return new JqGridData(pageInfo, param);
    }

    @RequestMapping(value={"/toView"})
    public String toView(ModelMap m, PhcPhysicalCheckSearchVo searchVo, Integer isSearchThirdMatch) {
        this.settingValueForSearchVo(searchVo);
        m.put((Object)"searchVo", (Object)searchVo);
        PhcPhysicalViewModel model = Objects.equals(isSearchThirdMatch, 1) ? this.phcPhysicalCheckV3221Service.getViewAssociativeMatchDataById(searchVo, isSearchThirdMatch) : this.phcPhysicalCheckV3221Service.getViewById(searchVo);
        m.put((Object)"model", (Object)model);
        String watermarkedTextInformation = this.getWaterMarkText();
        m.put((Object)"watermarkedTextInformation", (Object)watermarkedTextInformation);
        String watermarkedTextInformationPhone = this.getWaterMarkTextPhone();
        m.put((Object)"watermarkedTextInformationPhone", (Object)watermarkedTextInformationPhone);
        return "work/check/checkV3221/view";
    }

    private String getWaterMarkText() {
        String loginUserType = String.valueOf(this.session.getAttribute("loginUserType"));
        return "1".equals(loginUserType) ? String.valueOf(this.session.getAttribute("superviseFullName")) : UserUtils.getCurrentCompany().getName();
    }

    private String getWaterMarkTextPhone() {
        String loginUserType = String.valueOf(this.session.getAttribute("loginUserType"));
        String phone = "1".equals(loginUserType) ? String.valueOf(this.session.getAttribute("superviseUserTel")) : UserUtils.getCurrentUser().getMobile();
        return DesensitizationUtils.desensitized((CharSequence)phone, (DesensitizationType)DesensitizationType.MOBILE_PHONE);
    }

    @RequestMapping(value={"/toTypeData"})
    public String toTypeData(ModelMap m, PhcPhysicalCheckSearchVo searchVo) {
        this.settingValueForSearchVo(searchVo);
        m.put((Object)"searchVo", (Object)searchVo);
        String watermarkedTextInformation = this.getWaterMarkText();
        m.put((Object)"watermarkedTextInformation", (Object)watermarkedTextInformation);
        String watermarkedTextInformationPhone = this.getWaterMarkTextPhone();
        m.put((Object)"watermarkedTextInformationPhone", (Object)watermarkedTextInformationPhone);
        return "work/check/checkV3221/check_type_data";
    }

    @RequestMapping(value={"/toTypeDataResult"})
    public String dataResult(ModelMap m, PhcPhysicalCheckSearchVo searchVo) {
        this.settingValueForSearchVo(searchVo);
        m.put((Object)"searchVo", (Object)searchVo);
        PhcPhysicalStaffCheckInfo checkInfo = this.staffCheckInfoService.getStaffCheckInfoById(searchVo);
        m.put((Object)"checkInfo", (Object)checkInfo);
        String watermarkedTextInformation = this.getWaterMarkText();
        m.put((Object)"watermarkedTextInformation", (Object)watermarkedTextInformation);
        String watermarkedTextInformationPhone = this.getWaterMarkTextPhone();
        m.put((Object)"watermarkedTextInformationPhone", (Object)watermarkedTextInformationPhone);
        return "work/check/checkV3221/check_type_data_result";
    }

    @ResponseBody
    @RequestMapping(value={"/getPhcPhysicalResult"})
    public JqGridData<PhcPhysicalStaffCheckInfo> getPhcPhysicalResult(JqGridParam param, PhcPhysicalCheckSearchVo searchVo, Integer isSearchThirdMatch) {
        this.settingValueForSearchVo(searchVo);
        PageInfo pageInfo = this.staffCheckInfoService.getPhcPhysicalResult(param, searchVo, isSearchThirdMatch);
        return new JqGridData(pageInfo, param);
    }

    @ResponseBody
    @RequestMapping(value={"/getPhcPhysicalResultView"})
    public ResponseData<PhcPhysicalStaffCheckInfo> getPhcPhysicalResultView(PhcPhysicalCheckSearchVo searchVo) {
        this.settingValueForSearchVo(searchVo);
        ResponseData responseData = new ResponseData();
        PhcPhysicalStaffCheckInfo staffCheckInfo = this.staffCheckInfoService.getPhcPhysicalResultView(searchVo);
        responseData.setResult((Object)staffCheckInfo);
        return responseData;
    }

    @RequestMapping(value={"/toYszybList"})
    @RequiresPermissions(value={"yszybList"})
    public String toYszybList(ModelMap m, PhcPhysicalCheckSearchVo searchVo) {
        this.settingValueForSearchVo(searchVo);
        m.put((Object)"searchVo", (Object)searchVo);
        String watermarkedTextInformation = this.getWaterMarkText();
        m.put((Object)"watermarkedTextInformation", (Object)watermarkedTextInformation);
        String watermarkedTextInformationPhone = this.getWaterMarkTextPhone();
        m.put((Object)"watermarkedTextInformationPhone", (Object)watermarkedTextInformationPhone);
        return "work/check/checkV3221/yszybList";
    }

    @RequestMapping(value={"/zybList"})
    @RequiresPermissions(value={"zybList"})
    public String YszybList(ModelMap m, PhcPhysicalCheckSearchVo searchVo) {
        this.settingValueForSearchVo(searchVo);
        m.put((Object)"searchVo", (Object)searchVo);
        String watermarkedTextInformation = this.getWaterMarkText();
        m.put((Object)"watermarkedTextInformation", (Object)watermarkedTextInformation);
        String watermarkedTextInformationPhone = this.getWaterMarkTextPhone();
        m.put((Object)"watermarkedTextInformationPhone", (Object)watermarkedTextInformationPhone);
        return "views/keyFactorManagement/newCheck/zybList";
    }

    @RequestMapping(value={"/toYsjjzList"})
    @RequiresPermissions(value={"ysjjzList"})
    public String toYsjjzList(ModelMap m, PhcPhysicalCheckSearchVo searchVo) {
        this.settingValueForSearchVo(searchVo);
        m.put((Object)"searchVo", (Object)searchVo);
        String watermarkedTextInformation = this.getWaterMarkText();
        m.put((Object)"watermarkedTextInformation", (Object)watermarkedTextInformation);
        String watermarkedTextInformationPhone = this.getWaterMarkTextPhone();
        m.put((Object)"watermarkedTextInformationPhone", (Object)watermarkedTextInformationPhone);
        return "work/check/checkV3221/ysjjzList";
    }

    @ResponseBody
    @RequestMapping(value={"/getListByConclusion"})
    public JqGridData<PhcPhysicalStaffCheckInfo> getListByConclusion(JqGridParam param, PhcPhysicalCheckSearchVo searchVo) {
        this.settingValueForSearchVo(searchVo);
        PageInfo pageInfo = this.staffCheckInfoService.getListByConclusion(param, searchVo);
        return new JqGridData(pageInfo, param);
    }

    private void settingValueForSearchVo(PhcPhysicalCheckSearchVo searchVo) {
        Company company = UserUtils.getCurrentCompany();
        if (company != null) {
            searchVo.setCid(company.getId());
            searchVo.setUnifiedSocialCc(company.getUnifiedSocialCc());
            searchVo.setCompanyName(company.getName());
        }
    }

    @ResponseBody
    @RequestMapping(value={"/getStatisticsModel"})
    public ResponseData<PhcPhysicalStatisticsModel> getStatisticsModel(PhcPhysicalCheckSearchVo searchVo) {
        ResponseData responseData = new ResponseData();
        PhcPhysicalStatisticsModel model = this.phcPhysicalCheckV3221Service.getStatisticsModel(searchVo);
        responseData.setResult((Object)model);
        return responseData;
    }

    @ResponseBody
    @RequestMapping(value={"changeGeneratedData"})
    public String changeGeneratedData(String unifiedSocialCcs) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd hh:mm:dd");
        Date startDate = new Date();
        this.logger.info("\u540e\u7eed\u4fee\u6539\u4f53\u68c0\u6570\u636e\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb\uff1a" + format.format(startDate));
        try {
            this.staffCheckInfoService.changeGeneratedData(unifiedSocialCcs);
        }
        catch (Exception e) {
            Date endDate = new Date();
            this.logger.info("\u540e\u7eed\u4fee\u6539\u4f53\u68c0\u6570\u636e\u5b9a\u65f6\u4efb\u52a1\u5f02\u5e38\uff0c\u7ed3\u675f\u65f6\u95f4\uff1a" + format.format(endDate));
            return e.getMessage();
        }
        Date endDate = new Date();
        this.logger.info("\u540e\u7eed\u4fee\u6539\u4f53\u68c0\u6570\u636e\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f\uff1a" + format.format(endDate));
        return "\u4f53\u68c0\u6570\u636e\u5904\u7406\u5b8c\u6210";
    }

    @GetMapping(value={"/laborDispatch"})
    public String laborDispatch(ModelMap modelMap) {
        String watermarkedTextInformation = this.getWaterMarkText();
        modelMap.put((Object)"watermarkedTextInformation", (Object)watermarkedTextInformation);
        String watermarkedTextInformationPhone = this.getWaterMarkTextPhone();
        modelMap.put((Object)"watermarkedTextInformationPhone", (Object)watermarkedTextInformationPhone);
        return "/work/check/checkV3221/lwpq";
    }

    @GetMapping(value={"/laborDispatchList"})
    @ResponseBody
    public JqGridData<PhcPhysicalStaffCheckInfo> laborDispatchList(JqGridParam param, PhcPhysicalCheckSearchVo searchVo) {
        searchVo.setCid(UserUtils.getLoginStaffCompanyId());
        return this.staffCheckInfoService.laborDispatchAssociationMatchList(param, searchVo);
    }

    @GetMapping(value={"/staffCheckList"})
    @ResponseBody
    public JqGridData<PhcPhysicalStaffCheckInfo> getStaffCheckList(JqGridParam gparam, PhcPhysicalCheckSearchVo searchVo) {
        if (searchVo.getCheckStaffId() != null) {
            StaffBasicInfo info = (StaffBasicInfo)this.infoService.getById(searchVo.getCheckStaffId());
            if (info == null) {
                return null;
            }
            searchVo.setIdcardCode(info.getIdCard().toUpperCase());
        }
        searchVo.setCid(UserUtils.getLoginStaffCompanyId());
        return new JqGridData(this.staffCheckInfoService.getStaffCheckListPage(gparam, searchVo), gparam);
    }

    @ResponseBody
    @RequestMapping(value={"/getDelStaffListPage"})
    public LayUiResponseResult<PhcPhysicalStaffCheckInfo> getDelStaffListPage(JqGridParam gparam, String keyword) {
        PageInfo pageInfo = this.staffCheckInfoService.getDelStaffListPage(gparam, keyword, UserUtils.getLoginStaffCompanyId());
        pageInfo.getList().forEach(i -> {
            i.setIdCardMix(i.getIdcardCode());
            i.setIdcardCode(null);
        });
        return new LayUiResponseResult(pageInfo);
    }

    @ResponseBody
    @GetMapping(value={"/getPatientList"})
    public ResponseData<JqGridData<OccPatientVo>> getPatientList(FcythSearchParam param) {
        param.setUnifiedSocialCc(Objects.requireNonNull(UserUtils.getCurrentCompanyFromDataCenter()).getUnifiedSocialCc());
        PageInfo page = this.bxZybService.getPatientList(param);
        return ResponseData.success((Object)new JqGridData(page));
    }

    @ResponseBody
    @GetMapping(value={"/getZybPatientList"})
    public ResponseData<JqGridData<BxZybVo>> getZybPatientList(FcythSearchParam param) {
        param.setUnifiedSocialCc(Objects.requireNonNull(UserUtils.getCurrentCompanyFromDataCenter()).getUnifiedSocialCc());
        PageInfo page = this.bxZybService.getZybPatientList(param, Integer.valueOf(1));
        return ResponseData.success((Object)new JqGridData(page));
    }

    @ResponseBody
    @GetMapping(value={"/getZybPatientDetailById"})
    public ResponseData<BxZybDetailVo> getZybPatientDetailById(FcythSearchParam param) {
        param.setUnifiedSocialCc(Objects.requireNonNull(UserUtils.getCurrentCompanyFromDataCenter()).getUnifiedSocialCc());
        BxZybDetailVo bxZybDetailVo = this.bxZybService.getZybPatientDetailById(param);
        return ResponseData.success((Object)bxZybDetailVo);
    }
}

