/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.work.check;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.framework.web.repeatform.RepeatUrlFormData;
import cn.smarthse.modules.health.entity.base.staff.StaffWorkRole;
import cn.smarthse.modules.health.entity.work.check.PhcWorkUnexchange;
import cn.smarthse.modules.health.entity.work.check.vo.PhcWorkUnexchangeInfo;
import cn.smarthse.modules.health.entity.work.check.vo.PhcWorkUnexchangeParam;
import cn.smarthse.modules.health.service.base.staff.IStaffWorkRoleService;
import cn.smarthse.modules.health.service.work.check.IPhcWorkUnexchangeService;
import cn.smarthse.modules.health.service.work.harmfactor.IHarmfactorWorkService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpSession;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/work/check/unexchange"})
public class PhcWorkUnexchangeController
extends ControllerSupport {
    @DubboReference
    private IPhcWorkUnexchangeService phcWorkUnexchangeService;
    @DubboReference
    private IStaffWorkRoleService staffWorkRoleService;
    @DubboReference
    private IHarmfactorWorkService harmService;

    @RequiresPermissions(value={"healthCheck.view"})
    @RequestMapping
    public String page_index(@RequestParam(value="page", required=false, defaultValue="1") int pageIndex, HttpSession session, ModelMap m, PhcWorkUnexchangeParam param) {
        this.logger.info("\u3010\u3011-\u6c47\u603b\u9996\u9875");
        m.put((Object)"param", (Object)param);
        return "work/check/unexchange/unexchange_list";
    }

    @RequiresPermissions(value={"healthCheck.view"})
    @ResponseBody
    @RequestMapping(value={"listData"})
    public JqGridData<PhcWorkUnexchangeInfo> listData(HttpSession session, JqGridParam gparam, PhcWorkUnexchangeParam param) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        UserUtils.startWebDataScope();
        PageInfo list = this.phcWorkUnexchangeService.getUnexchangePage(gparam, param);
        JqGridData data = new JqGridData(list, gparam);
        return data;
    }

    @RequiresPermissions(value={"healthCheck.edit"})
    @RequestMapping(value={"/step1"}, method={RequestMethod.GET})
    public String step1(PhcWorkUnexchangeParam data, HttpSession session, ModelMap m) {
        this.getCurrentWorkRoleAndHarms(data.getStaffId(), m);
        m.put((Object)"data", (Object)data);
        return "work/check/unexchange/step1";
    }

    @RequiresPermissions(value={"healthCheck.edit"})
    @RequestMapping(value={"/step2"}, method={RequestMethod.GET})
    public String step2(PhcWorkUnexchangeParam data, HttpSession session, ModelMap m) {
        PhcWorkUnexchange info = this.phcWorkUnexchangeService.getDetailById(data.getUnexchangeId());
        this.getCurrentWorkRoleAndHarms(data.getStaffId(), m);
        m.put((Object)"data", (Object)data);
        m.put((Object)"info", (Object)info);
        Long cid = UserUtils.getLoginStaffCompanyId();
        String changeWorkHarm = this.harmService.getHarmNamesByWork(cid, info.getChangeWorkId(), " ");
        m.put((Object)"changeWorkHarm", (Object)changeWorkHarm);
        return "work/check/unexchange/step2";
    }

    private void getCurrentWorkRoleAndHarms(Long staffId, ModelMap m) {
        if (staffId == null) {
            return;
        }
        StaffWorkRole workRole = this.staffWorkRoleService.getCurrentStaffWorkRoleByStaffId(staffId);
        if (workRole == null) {
            return;
        }
        m.put((Object)"workRole", (Object)workRole);
        Long workRoleId = workRole.getWorkRoleId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        String harms = this.harmService.getHarmNamesByWork(cid, workRoleId, " ");
        m.put((Object)"harms", (Object)harms);
    }

    @RequiresPermissions(value={"healthCheck.edit"})
    @ResponseBody
    @RequestMapping(value={"/ok"}, method={RequestMethod.POST})
    public ResponseData<String> ok(String ids, HttpSession session) {
        Long updateBy = UserUtils.getLoginStaffId();
        this.phcWorkUnexchangeService.setIsFinishByIds(ids, true, updateBy);
        ResponseData result = new ResponseData();
        result.setResult((Object)ids);
        result.setContent("\u64cd\u4f5c\u6210\u529f");
        return result;
    }

    @RequiresPermissions(value={"healthCheck.edit"})
    @ResponseBody
    @RequestMapping(value={"/ok2"}, method={RequestMethod.POST})
    @RepeatUrlFormData
    public ResponseData<PhcWorkUnexchange> ok2(PhcWorkUnexchange data, HttpSession session) {
        Long updateBy = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        data.setCid(cid);
        this.phcWorkUnexchangeService.updateChangeInfo(data, updateBy);
        ResponseData result = new ResponseData();
        result.setResult((Object)data);
        result.setContent("\u64cd\u4f5c\u6210\u529f");
        return result;
    }
}

