/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.work.check;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheck;
import cn.smarthse.modules.health.entity.work.check.PhcUnrecheck;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckAbnormalParam;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckRecheckInfo;
import cn.smarthse.modules.health.service.work.check.IPhcUnrecheckService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpSession;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/work/check/unrecheck"})
public class PhcUnrecheckController
extends ControllerSupport {
    @DubboReference
    private IPhcUnrecheckService phcUnrecheckService;

    @RequiresPermissions(value={"healthCheck.view"})
    @RequestMapping
    public String page_index(@RequestParam(value="page", required=false, defaultValue="1") int pageIndex, HttpSession session, ModelMap m, PhcPhysicalCheckAbnormalParam param) {
        this.logger.info("\u3010\u3011-\u6c47\u603b\u9996\u9875");
        m.put((Object)"param", (Object)param);
        return "work/check/result/recheck_list";
    }

    @RequestMapping(value={"table"})
    public String table(@RequestParam(value="page", required=false, defaultValue="1") int pageIndex, HttpSession session, ModelMap m, PhcPhysicalCheckAbnormalParam param) {
        this.logger.info("\u3010\u3011-\u6c47\u603b\u9996\u9875");
        m.put((Object)"param", (Object)param);
        return "work/check/result/recheck_table";
    }

    @RequiresPermissions(value={"healthCheck.view"})
    @ResponseBody
    @RequestMapping(value={"listData"})
    public JqGridData<PhcPhysicalCheckRecheckInfo> listData(HttpSession session, JqGridParam gparam, PhcPhysicalCheckAbnormalParam param) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        UserUtils.startWebDataScope();
        PageInfo list = this.phcUnrecheckService.getUnrecheckPage(gparam, param);
        JqGridData data = new JqGridData(list, gparam);
        return data;
    }

    @RequiresPermissions(value={"healthCheck.edit"})
    @ResponseBody
    @RequestMapping(value={"add"}, method={RequestMethod.POST})
    public ResponseData<PhcPhysicalCheck> add(String ids, Long checkId, Integer reCheckType, HttpSession session, ModelMap m) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffId = UserUtils.getLoginStaffId();
        PhcPhysicalCheck check = this.phcUnrecheckService.addRecheckInfo(checkId, ids, cid, staffId, reCheckType);
        ResponseData result = new ResponseData();
        result.setResult((Object)check);
        result.setContent("\u64cd\u4f5c\u6210\u529f");
        return result;
    }

    @RequiresPermissions(value={"healthCheck.edit"})
    @ResponseBody
    @RequestMapping(value={"/del"}, method={RequestMethod.DELETE})
    public ResponseData<PhcUnrecheck> ajax_delete_recheck(PhcUnrecheck data, HttpSession session) {
        Long updateBy = UserUtils.getLoginStaffId();
        this.phcUnrecheckService.setIsFinishByInfo(data, updateBy);
        ResponseData result = new ResponseData();
        result.setResult((Object)data);
        result.setContent("\u5220\u9664\u6210\u529f");
        return result;
    }
}

