/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.work.check;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.excel.ExportExcel;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheckRecommendQuery;
import cn.smarthse.modules.health.enums.check.SpecialWorkEnum;
import cn.smarthse.modules.health.enums.check.WorkStateEnum;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckRecommendQueryService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/work/check/recommend/query"})
public class PhcPhysicalCheckRecommendQueryController
extends ControllerSupport {
    @DubboReference
    IPhcPhysicalCheckRecommendQueryService queryService;
    private String[] colums = new String[]{"\u5c97\u4f4d\u72b6\u6001|workStateName", "\u63a5\u5bb3\u5c97\u4f4d/\u5de5\u79cd|workName", "\u7279\u6b8a\u4f5c\u4e1a\uff08\u53c2\u89c1GBZ188\uff09|specialWorks", "\u7ecf\u8fc7\u7684\u5de5\u4f5c\u573a\u6240|harmAreaNames", "\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20|harms", "\u4f53\u68c0\u5fc5\u68c0\u9879\u76ee|mustChecks", "\u4f53\u68c0\u9009\u68c0\u9879\u76ee|chooseChecks"};

    @RequiresPermissions(value={"healthCheck.view"})
    @RequestMapping(value={""})
    public String query(ModelMap m) {
        this.logger.info("\u3010\u3011-\u4f53\u68c0\u67e5\u8be2");
        m.put((Object)"specialWorks", (Object)SpecialWorkEnum.values());
        m.put((Object)"workStates", (Object)WorkStateEnum.values());
        Long cid = UserUtils.getLoginStaffCompanyId();
        Integer unExportCount = this.queryService.unExportCount(cid);
        m.put((Object)"unExportCount", (Object)unExportCount);
        return "work/check/recommend/query";
    }

    @ResponseBody
    @RequestMapping(value={"/info"}, method={RequestMethod.POST})
    public ResponseData<PhcPhysicalCheckRecommendQuery> queryPost(HttpServletRequest request, PhcPhysicalCheckRecommendQuery query) {
        this.setQueryInfos(request, query);
        PhcPhysicalCheckRecommendQuery result = this.queryService.query(query);
        ResponseData data = new ResponseData();
        data.setResult((Object)result);
        data.setContent("\u64cd\u4f5c\u6210\u529f");
        return data;
    }

    @ResponseBody
    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public ResponseData<PhcPhysicalCheckRecommendQuery> queryAdd(HttpServletRequest request, PhcPhysicalCheckRecommendQuery query) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffId = UserUtils.getLoginStaffId();
        query = this.queryService.insertOrUpdate(query, staffId, cid);
        ResponseData data = new ResponseData();
        data.setResult((Object)query);
        data.setContent("" + this.queryService.unExportCount(cid));
        return data;
    }

    private void setQueryInfos(HttpServletRequest request, PhcPhysicalCheckRecommendQuery query) {
        String[] harmId = request.getParameterValues("harmId");
        String[] specialWorkCode = request.getParameterValues("specialWorkCode");
        String[] harmName = request.getParameterValues("harmName");
        String[] specialWorkName = request.getParameterValues("specialWorkName");
        String[] harmAreaName = request.getParameterValues("areaName");
        String harmNames = StringUtils.convertArrayToStringWithSpliter((String[])harmName, (String)",");
        String specialWorkNames = StringUtils.convertArrayToStringWithSpliter((String[])specialWorkName, (String)",");
        String harmAreaNames = StringUtils.convertArrayToStringWithSpliter((String[])harmAreaName, (String)",");
        query.setHarms(harmNames);
        query.setSpecialWorks(specialWorkNames);
        query.setHarmIds(harmId);
        query.setSpecialWorkIds(specialWorkCode);
        query.setHarmAreaNames(harmAreaNames);
    }

    @RequiresPermissions(value={"healthCheck.view"})
    @RequestMapping(value={"exportAll"})
    public void exportAll(HttpSession session, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.logger.info("ajax-\u3010\u3011-\u5bfc\u51faExcel");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String fileName = " \u4f53\u68c0\u9879\u76ee\u67e5\u8be2" + dateFormat.format(new Date()) + ".xls";
        response.setHeader("Content-Disposition", "attachment;filename=" + new String(fileName.getBytes("GBK"), "ISO8859_1"));
        response.setContentType("application/octet-stream; charset=GBK");
        Long cid = UserUtils.getLoginStaffCompanyId();
        List list = this.queryService.exportAll(cid);
        ExportExcel export = new ExportExcel();
        export.simpleExport3(" \u4f53\u68c0\u9879\u76ee\u67e5\u8be2", this.colums, list, (OutputStream)response.getOutputStream());
    }

    @RequiresPermissions(value={"healthCheck.view"})
    @RequestMapping(value={"exportOne"})
    public void exportOne(HttpSession session, HttpServletRequest request, HttpServletResponse response, PhcPhysicalCheckRecommendQuery query) throws Exception {
        this.logger.info("ajax-\u3010\u3011-\u5bfc\u51faExcel");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String fileName = " \u4f53\u68c0\u9879\u76ee\u67e5\u8be2" + dateFormat.format(new Date()) + ".xls";
        response.setHeader("Content-Disposition", "attachment;filename=" + new String(fileName.getBytes("GBK"), "ISO8859_1"));
        response.setContentType("application/octet-stream; charset=GBK");
        ArrayList<PhcPhysicalCheckRecommendQuery> list = new ArrayList<PhcPhysicalCheckRecommendQuery>();
        list.add(query);
        ExportExcel export = new ExportExcel();
        export.simpleExport3(" \u4f53\u68c0\u9879\u76ee\u67e5\u8be2", this.colums, list, (OutputStream)response.getOutputStream());
    }

    @RequiresPermissions(value={"healthCheck.view"})
    @RequestMapping(value={"unExport"})
    public String unExport(@RequestParam(value="page", required=false, defaultValue="1") int pageIndex, HttpSession session, ModelMap m) {
        this.logger.info("\u3010\u3011-\u4f53\u68c0\u67e5\u8be2");
        m.put((Object)"specialWorks", (Object)SpecialWorkEnum.values());
        m.put((Object)"workStates", (Object)WorkStateEnum.values());
        Long cid = UserUtils.getLoginStaffCompanyId();
        Integer unExportCount = this.queryService.unExportCount(cid);
        m.put((Object)"unExportCount", (Object)unExportCount);
        return "work/check/recommend/unExport";
    }

    @RequiresPermissions(value={"healthCheck.view"})
    @ResponseBody
    @RequestMapping(value={"unExportList"})
    public JqGridData<PhcPhysicalCheckRecommendQuery> listData(JqGridParam gparam) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        PageInfo list = this.queryService.page(gparam, cid);
        JqGridData data = new JqGridData(list, gparam);
        return data;
    }
}

