/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.work.check;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.excel.ExportExcel;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.modules.health.entity.base.staff.vo.HealthCheckStaffInfoQuery;
import cn.smarthse.modules.health.entity.base.staff.vo.HealthCheckStaffInfoVo;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheck;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheckRecommendIgnored;
import cn.smarthse.modules.health.enums.check.RecommendCheckEnum;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/work/check/recommend"})
public class PhcPhysicalCheckRecommendController
extends ControllerSupport {
    @DubboReference
    private IPhcPhysicalCheckService phcPhysicalCheckService;

    @RequiresPermissions(value={"healthCheck.view"})
    @RequestMapping(value={"on"})
    public String page_index(@RequestParam(value="page", required=false, defaultValue="1") int pageIndex, HttpSession session, ModelMap m, PhcPhysicalCheck check) {
        this.logger.info("\u3010\u3011-\u6c47\u603b\u9996\u9875");
        return "work/check/recommend/on_list";
    }

    @RequiresPermissions(value={"healthCheck.view"})
    @ResponseBody
    @RequestMapping(value={"onListData"})
    public JqGridData<HealthCheckStaffInfoVo> listData(HttpSession session, JqGridParam gparam, HealthCheckStaffInfoQuery query) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        query.setCid(cid);
        query.setChoose(RecommendCheckEnum.onChoose.getCode());
        query.setMust(RecommendCheckEnum.onMust.getCode());
        PageInfo list = this.phcPhysicalCheckService.getRecommendHealthCheckStaffInfosPageBySearch(gparam, query);
        JqGridData data = new JqGridData(list, gparam);
        return data;
    }

    @RequiresPermissions(value={"healthCheck.view"})
    @RequestMapping(value={"export"})
    public void export(HealthCheckStaffInfoQuery query, HttpSession session, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.logger.info("ajax-\u3010\u3011-\u5bfc\u51faExcel");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String fileName = "\u4f53\u68c0\u4eba\u5458\u63a8\u8350\u6e05\u5355\uff08\u5728\u5c97\u671f\u95f4\u804c\u4e1a\u5065\u5eb7\u68c0\u67e5\uff09" + dateFormat.format(new Date()) + ".xls";
        response.setHeader("Content-Disposition", "attachment;filename=" + new String(fileName.getBytes("GBK"), "ISO8859_1"));
        response.setContentType("application/octet-stream; charset=GBK");
        String[] colums = new String[]{"\u5de5\u53f7|workNo", "\u59d3\u540d|realName", "\u6027\u522b|genderName", "\u90e8\u95e8/\u8f66\u95f4|orgName", "\u5c97\u4f4d/\u5de5\u79cd|workName", "\u4e0a\u5c97\u65f6\u95f4|beginTime", "\u4e0a\u6b21\u4f53\u68c0\u65f6\u95f4|lastCheckTime", "\u63a5\u89e6\u7684\u5371\u5bb3\u56e0\u7d20|harms", "\u4f53\u68c0\u5fc5\u68c0\u9879\u76ee|mustChecks", "\u4f53\u68c0\u9009\u68c0\u9879\u76ee|chooseChecks"};
        query.setCid(UserUtils.getLoginStaffCompanyId());
        query.setChoose(RecommendCheckEnum.onChoose.getCode());
        query.setMust(RecommendCheckEnum.onMust.getCode());
        List list = this.phcPhysicalCheckService.getRecommendHealthCheckStaffInfos(query);
        ExportExcel export = new ExportExcel();
        export.simpleExport3("\u4f53\u68c0\u4eba\u5458\u63a8\u8350\u6e05\u5355", colums, list, (OutputStream)response.getOutputStream());
    }

    @RequiresPermissions(value={"healthCheck.view"})
    @RequestMapping(value={"before"})
    public String page_before(@RequestParam(value="page", required=false, defaultValue="1") int pageIndex, HttpSession session, ModelMap m, PhcPhysicalCheck check) {
        this.logger.info("\u3010\u3011-\u6c47\u603b\u9996\u9875");
        return "work/check/recommend/before_list";
    }

    @RequiresPermissions(value={"healthCheck.view"})
    @ResponseBody
    @RequestMapping(value={"beforeListData"})
    public JqGridData<HealthCheckStaffInfoVo> listBeforeData(HttpSession session, JqGridParam gparam, HealthCheckStaffInfoQuery query) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        query.setCid(cid);
        query.setChoose(RecommendCheckEnum.beforeChoose.getCode());
        query.setMust(RecommendCheckEnum.beforeMust.getCode());
        PageInfo list = this.phcPhysicalCheckService.getBeforeRecommendHealthCheckStaffInfosPageBySearch(gparam, query);
        JqGridData data = new JqGridData(list, gparam);
        return data;
    }

    @RequiresPermissions(value={"healthCheck.view"})
    @RequestMapping(value={"exportBefore"})
    public void exportBefore(HealthCheckStaffInfoQuery query, HttpSession session, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.logger.info("ajax-\u3010\u3011-\u5bfc\u51faExcel");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String fileName = "\u4f53\u68c0\u4eba\u5458\u63a8\u8350\u6e05\u5355\uff08\u4e0a\u5c97\u524d\u804c\u4e1a\u5065\u5eb7\u68c0\u67e5\uff09" + dateFormat.format(new Date()) + ".xls";
        response.setHeader("Content-Disposition", "attachment;filename=" + new String(fileName.getBytes("GBK"), "ISO8859_1"));
        response.setContentType("application/octet-stream; charset=GBK");
        String[] colums = new String[]{"\u5de5\u53f7|workNo", "\u59d3\u540d|realName", "\u6027\u522b|genderName", "\u90e8\u95e8/\u8f66\u95f4|orgName", "\u5c97\u4f4d/\u5de5\u79cd|workName", "\u4e0a\u5c97\u65f6\u95f4|beginTime", "\u63a5\u89e6\u7684\u5371\u5bb3\u56e0\u7d20|harms", "\u4f53\u68c0\u5fc5\u68c0\u9879\u76ee|mustChecks", "\u4f53\u68c0\u9009\u68c0\u9879\u76ee|chooseChecks"};
        query.setCid(UserUtils.getLoginStaffCompanyId());
        query.setChoose(RecommendCheckEnum.beforeChoose.getCode());
        query.setMust(RecommendCheckEnum.beforeMust.getCode());
        List list = this.phcPhysicalCheckService.getBeforeRecommendHealthCheckStaffInfos(query);
        ExportExcel export = new ExportExcel();
        export.simpleExport3("\u4f53\u68c0\u4eba\u5458\u63a8\u8350\u6e05\u5355", colums, list, (OutputStream)response.getOutputStream());
    }

    @RequiresPermissions(value={"healthCheck.view"})
    @RequestMapping(value={"leave"})
    public String page_leavel(@RequestParam(value="page", required=false, defaultValue="1") int pageIndex, HttpSession session, ModelMap m, PhcPhysicalCheck check) {
        this.logger.info("\u3010\u3011-\u6c47\u603b\u9996\u9875");
        return "work/check/recommend/leave_list";
    }

    @RequiresPermissions(value={"healthCheck.view"})
    @ResponseBody
    @RequestMapping(value={"leaveListData"})
    public JqGridData<HealthCheckStaffInfoVo> listLeaveData(HttpSession session, JqGridParam gparam, HealthCheckStaffInfoQuery query) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        query.setCid(cid);
        query.setChoose(RecommendCheckEnum.leaveChoose.getCode());
        query.setMust(RecommendCheckEnum.leaveMust.getCode());
        PageInfo list = this.phcPhysicalCheckService.getLeaveRecommendHealthCheckStaffInfosPageBySearch(gparam, query);
        JqGridData data = new JqGridData(list, gparam);
        return data;
    }

    @RequiresPermissions(value={"healthCheck.view"})
    @RequestMapping(value={"exportLeave"})
    public void exportLeave(HealthCheckStaffInfoQuery query, HttpSession session, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.logger.info("ajax-\u3010\u3011-\u5bfc\u51faExcel");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String fileName = "\u4f53\u68c0\u4eba\u5458\u63a8\u8350\u6e05\u5355\uff08\u79bb\u5c97\u65f6\u804c\u4e1a\u5065\u5eb7\u68c0\u67e5\uff09" + dateFormat.format(new Date()) + ".xls";
        response.setHeader("Content-Disposition", "attachment;filename=" + new String(fileName.getBytes("GBK"), "ISO8859_1"));
        response.setContentType("application/octet-stream; charset=GBK");
        String[] colums = new String[]{"\u5de5\u53f7|workNo", "\u59d3\u540d|realName", "\u6027\u522b|genderName", "\u90e8\u95e8/\u8f66\u95f4|orgName", "\u5c97\u4f4d/\u5de5\u79cd|workName", "\u79bb\u5c97\u65f6\u95f4|beginTime", "\u63a5\u89e6\u7684\u5371\u5bb3\u56e0\u7d20|harms", "\u4f53\u68c0\u5fc5\u68c0\u9879\u76ee|mustChecks", "\u4f53\u68c0\u9009\u68c0\u9879\u76ee|chooseChecks"};
        query.setCid(UserUtils.getLoginStaffCompanyId());
        query.setChoose(RecommendCheckEnum.leaveChoose.getCode());
        query.setMust(RecommendCheckEnum.leaveMust.getCode());
        List list = this.phcPhysicalCheckService.getLeaveRecommendHealthCheckStaffInfos(query);
        ExportExcel export = new ExportExcel();
        export.simpleExport3("\u4f53\u68c0\u4eba\u5458\u63a8\u8350\u6e05\u5355", colums, list, (OutputStream)response.getOutputStream());
    }

    @RequiresPermissions(value={"healthCheck.edit"})
    @ResponseBody
    @RequestMapping(value={"/ignore"}, method={RequestMethod.POST})
    public ResponseData<PhcPhysicalCheckRecommendIgnored> ajax_ignore(PhcPhysicalCheckRecommendIgnored data, HttpSession session) {
        this.logger.info("ajax-\u3010\u3011-\u5ffd\u7565:" + data.getStaffId());
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long loginStaffId = UserUtils.getLoginStaffId();
        this.phcPhysicalCheckService.ignoreStaff(data, loginStaffId, cid);
        ResponseData result = new ResponseData();
        result.setResult((Object)data);
        result.setContent("\u5ffd\u7565\u6210\u529f");
        return result;
    }
}

