/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.work.check;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.common.util.BeanMapUtil;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.IDCardUtil;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.date.DateUtil;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheckDataResult;
import cn.smarthse.modules.health.entity.work.check.PhyCheckDataResultInfo;
import cn.smarthse.modules.health.entity.work.check.vo.PhcDieaserUnprocessInfo;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckAbnormal;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckAbnormalParam;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckRechckDataVO;
import cn.smarthse.modules.health.entity.work.check.vo.PhcSDInfo;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckDataResultService;
import cn.smarthse.modules.health.thirdOrganization.entity.org.ThirdOrganization;
import cn.smarthse.modules.health.thirdOrganization.service.org.IThirdOrganizationService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.data.ReadCellData;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.beans.IntrospectionException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.cn.smarthse.modules.health.exception.HealthException;
import net.sf.jxls.exception.ParsePropertyException;
import net.sf.jxls.transformer.XLSTransformer;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/work/check/data/result"})
public class PhcPhysicalCheckDataResultController
extends ControllerSupport {
    @DubboReference
    private IPhcPhysicalCheckDataResultService phcPhysicalCheckDataResultService;
    @DubboReference
    private IThirdOrganizationService thirdOrganizationService;

    @RequestMapping
    public String page_index(@RequestParam(value="page", required=false, defaultValue="1") int pageIndex, HttpSession session, ModelMap m, PhcPhysicalCheckAbnormalParam param, Integer year) {
        this.logger.info("\u3010\u3011-\u6c47\u603b\u9996\u9875");
        m.put((Object)"param", (Object)param);
        m.put((Object)"year", (Object)year);
        return "work/check/result/abnormal_list";
    }

    @ResponseBody
    @RequestMapping(value={"listData"})
    public JqGridData<PhcPhysicalCheckAbnormal> listData(HttpSession session, JqGridParam gparam, PhcPhysicalCheckAbnormalParam param, Integer year) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        if (year != null) {
            param.setBeginTime(DateUtil.getDate((LocalDateTime)DateUtil.getLocalDateTime((int)year, (int)1, (int)1, (int)0, (int)0, (int)0)));
            param.setEndTime(DateUtil.getDate((LocalDateTime)DateUtil.getLocalDateTime((int)(year + 1), (int)1, (int)1, (int)0, (int)0, (int)0)));
        }
        UserUtils.startWebDataScope();
        PageInfo list = this.phcPhysicalCheckDataResultService.getAbnormalPageV3_1(gparam, param);
        JqGridData data = new JqGridData(list, gparam);
        return data;
    }

    @RequestMapping(value={"/info"}, method={RequestMethod.GET})
    public String info(PhcPhysicalCheckDataResult data, HttpSession session, ModelMap m) {
        if (data.getId() != null) {
            data = this.phcPhysicalCheckDataResultService.getResultInfoById(data.getId());
        }
        this.setThirdOrgName(data);
        m.put((Object)"data", (Object)data);
        return "work/check/result/info";
    }

    @RequestMapping(value={"/info/view"}, method={RequestMethod.GET})
    public String infoView(PhcPhysicalCheckDataResult data, HttpSession session, ModelMap m) {
        if (data.getId() != null) {
            data = this.phcPhysicalCheckDataResultService.getResultInfoById(data.getId());
        }
        this.setThirdOrgName(data);
        m.put((Object)"data", (Object)data);
        return "work/check/result/info_view";
    }

    private void setThirdOrgName(PhcPhysicalCheckDataResult data) {
        if (data == null || data.getThirdOrgId() == null) {
            return;
        }
        ThirdOrganization org = (ThirdOrganization)this.thirdOrganizationService.getById(data.getThirdOrgId());
        data.setThirdOrgName(org == null ? null : org.getName());
    }

    @RequestMapping(value={"/deal/info"}, method={RequestMethod.GET})
    public String dealInfo(PhcPhysicalCheckDataResult data, HttpSession session, ModelMap m) {
        if (data.getId() != null) {
            data = this.phcPhysicalCheckDataResultService.getResultInfoById(data.getId());
        }
        this.setThirdOrgName(data);
        m.put((Object)"data", (Object)data);
        return "work/check/result/deal_info";
    }

    @RequestMapping(value={"/deal/info2"}, method={RequestMethod.GET})
    public String dataResult2(ModelMap m, Long id) {
        PhyCheckDataResultInfo resultInfo = this.phcPhysicalCheckDataResultService.getCheckResultInfo(id);
        m.put((Object)"resultInfo", (Object)resultInfo);
        String idCardMask = IDCardUtil.idCardMask((String)resultInfo.getIdCard());
        m.put((Object)"idCardMask", (Object)idCardMask);
        return "work/check/result/deal_info2";
    }

    @RequestMapping(value={"/abnormal/info"}, method={RequestMethod.GET})
    public String abnormalInfo(PhcPhysicalCheckDataResult data, HttpSession session, ModelMap m) {
        if (data.getId() != null) {
            data = this.phcPhysicalCheckDataResultService.getResultInfoById(data.getId());
        }
        m.put((Object)"resultInfo", (Object)data);
        return "work/check/result/abnormal_info";
    }

    @ResponseBody
    @RequestMapping(value={"/info"}, method={RequestMethod.POST})
    public ResponseData<PhcPhysicalCheckDataResult> infoPost(HttpServletRequest request, PhcPhysicalCheckDataResult data) {
        Long staffId = UserUtils.getLoginStaffId();
        Long cid = UserUtils.getLoginStaffCompanyId();
        data.setUpdator(UserUtils.getLoginStaffName());
        this.phcPhysicalCheckDataResultService.updateDealInfo(data, staffId, cid);
        ResponseData result = new ResponseData();
        result.setResult((Object)data);
        result.setContent("\u64cd\u4f5c\u6210\u529f");
        return result;
    }

    @RequestMapping(value={"/rechck/batch"}, method={RequestMethod.GET})
    public String rechckBatch(String resultIds, ModelMap m) {
        m.put((Object)"resultIds", (Object)resultIds);
        return "work/check/result/recheck_info";
    }

    @ResponseBody
    @RequestMapping(value={"rechck/batch/info"}, method={RequestMethod.POST})
    public ResponseData<PhcPhysicalCheckDataResult> rechckBatchPost(PhcPhysicalCheckDataResult data) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffId = UserUtils.getLoginStaffId();
        this.phcPhysicalCheckDataResultService.rechckBatchPost(data, staffId, cid);
        ResponseData result = new ResponseData();
        result.setResult((Object)data);
        result.setContent("\u64cd\u4f5c\u6210\u529f");
        return result;
    }

    @ResponseBody
    @RequestMapping(value={"rechck/info"}, method={RequestMethod.POST})
    public ResponseData<PhcPhysicalCheckRechckDataVO> rechckInfoPost(HttpServletRequest request, PhcPhysicalCheckRechckDataVO data) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffId = UserUtils.getLoginStaffId();
        this.phcPhysicalCheckDataResultService.rechckInfoPost(data, staffId, cid);
        ResponseData result = new ResponseData();
        result.setResult((Object)data);
        result.setContent("\u64cd\u4f5c\u6210\u529f");
        return result;
    }

    private void insertImage2(String templateFileName, String resultFilePath, XLSTransformer transformer, List<PhcPhysicalCheckAbnormal> list) throws IOException, ParsePropertyException, InvalidFormatException, IllegalAccessException, InvocationTargetException, IntrospectionException {
        HashMap paramDto = new HashMap();
        ArrayList<Map> result = new ArrayList<Map>();
        for (PhcPhysicalCheckAbnormal report : list) {
            Map itemMap = BeanMapUtil.bean2Map((Object)report);
            result.add(itemMap);
        }
        paramDto.put("infos", result);
        FileInputStream is = new FileInputStream(templateFileName);
        HSSFWorkbook workBook = (HSSFWorkbook)transformer.transformXLS((InputStream)is, paramDto);
        FileOutputStream os = new FileOutputStream(resultFilePath);
        workBook.write((OutputStream)os);
        ((InputStream)is).close();
        os.flush();
        ((OutputStream)os).close();
    }

    private void insertImage(HttpServletResponse response, String templateFileName, String resultFilePath, String resultFileName, List<PhcPhysicalCheckAbnormal> list) throws IOException, InvalidFormatException, IllegalAccessException, InvocationTargetException, IntrospectionException {
        ServletOutputStream out = null;
        try {
            FileInputStream is = new FileInputStream(templateFileName);
            out = response.getOutputStream();
            response.setHeader("Content-Disposition", "attachment;filename=" + new String(resultFileName.getBytes("GBK"), "ISO8859_1"));
            ExcelWriter excelWriter = ((ExcelWriterBuilder)EasyExcel.write((OutputStream)out).registerConverter((Converter)new Converter<Long>(){

                public Class supportJavaTypeKey() {
                    return Long.class;
                }

                public CellDataTypeEnum supportExcelTypeKey() {
                    return CellDataTypeEnum.STRING;
                }

                public Long convertToJavaData(ReadCellData cellData, ExcelContentProperty excelContentProperty, GlobalConfiguration globalConfiguration) throws Exception {
                    if (StringUtils.isNumeric((CharSequence)cellData.getStringValue())) {
                        return Long.parseLong(cellData.getStringValue());
                    }
                    return null;
                }

                public WriteCellData convertToExcelData(Long o, ExcelContentProperty excelContentProperty, GlobalConfiguration globalConfiguration) throws Exception {
                    if (o != null) {
                        return new WriteCellData(o.toString());
                    }
                    return new WriteCellData("");
                }
            })).withTemplate(templateFileName).build();
            WriteSheet writeSheet = EasyExcel.writerSheet().build();
            excelWriter.fill(list, writeSheet);
            excelWriter.finish();
        }
        catch (FileNotFoundException fe) {
            throw new HealthException("\u7cfb\u7edf\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u6587\u4ef6");
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/export"})
    public void exportCheckPointMap(HttpServletResponse response, PhcPhysicalCheckAbnormalParam param) throws Exception {
        String templateDirPath = super.getTemplateFilePath();
        String tempDirPath = super.getTempFilePath();
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        List list = this.phcPhysicalCheckDataResultService.getAbnormalList(param);
        if (list == null || list.size() == 0) {
            return;
        }
        String resultFileName = "\u5f02\u5e38\u4eba\u5458\u5904\u7406\u6e05\u5355.xls";
        String templateFileName = templateDirPath + "checkAbnormalListTemplate.xls";
        String resultFilePath = tempDirPath + resultFileName;
        try {
            this.insertImage(response, templateFileName, resultFilePath, resultFileName, list);
        }
        catch (ParsePropertyException e) {
            this.logger.error(e.getMessage());
        }
        catch (IOException e) {
            this.logger.error(e.getMessage());
        }
        catch (InvalidFormatException e) {
            this.logger.error(e.getMessage());
        }
        BufferedOutputStream bos = new BufferedOutputStream((OutputStream)response.getOutputStream());
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(resultFilePath));
        try {
            int bytesRead;
            response.setHeader("Content-Disposition", "attachment;filename=" + new String(resultFileName.getBytes("GBK"), "ISO8859_1"));
            response.setContentType("application/octet-stream; charset=GBK");
            response.setHeader("Content-Length", String.valueOf(new File(resultFilePath).length()));
            byte[] buff = new byte[1024];
            while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                bos.write(buff, 0, bytesRead);
            }
        }
        finally {
            if (bos != null) {
                bos.close();
            }
            if (bis != null) {
                bis.close();
            }
        }
    }

    @ResponseBody
    @RequestMapping(value={"listSDData"})
    public JqGridData<PhcDieaserUnprocessInfo> listSDData(HttpSession session, JqGridParam gparam, PhcPhysicalCheckAbnormalParam param, Integer endTime1) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        if (endTime1 != null) {
            Date yearFirstDay = DateUtils.getYearFirstDay((int)endTime1);
            param.setEndTime(yearFirstDay);
        }
        param.setCid(cid);
        UserUtils.startWebDataScope();
        PageInfo list = this.phcPhysicalCheckDataResultService.getSDPage(gparam, param);
        JqGridData data = new JqGridData(list, gparam);
        return data;
    }

    @ResponseBody
    @RequestMapping(value={"listOCData"})
    public JqGridData<PhcDieaserUnprocessInfo> listOCData(HttpSession session, JqGridParam gparam, PhcPhysicalCheckAbnormalParam param, Integer endTime1) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        if (endTime1 != null) {
            param.setEndTime(DateUtils.getYearFirstDay((int)(endTime1 + 1)));
        }
        param.setCid(cid);
        UserUtils.startWebDataScope();
        PageInfo list = this.phcPhysicalCheckDataResultService.listOCData(gparam, param);
        JqGridData data = new JqGridData(list, gparam);
        return data;
    }

    @ResponseBody
    @RequestMapping(value={"listRecheckData"})
    public JqGridData<PhcDieaserUnprocessInfo> listRecheckData(HttpSession session, JqGridParam gparam, PhcPhysicalCheckAbnormalParam param) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        UserUtils.startWebDataScope();
        PageInfo list = this.phcPhysicalCheckDataResultService.listRecheckData(gparam, param);
        JqGridData data = new JqGridData(list, gparam);
        return data;
    }

    @RequiresPermissions(value={"healthCheck.view"})
    @RequestMapping(value={"/sd/view"}, method={RequestMethod.GET})
    public String view(Long resultId, String fromPage, ModelMap m) {
        PhcSDInfo data = this.phcPhysicalCheckDataResultService.getSDById(resultId);
        m.put((Object)"data", (Object)data);
        m.put((Object)"fromPage", (Object)fromPage);
        return "work/check/result/sd_info";
    }
}

