/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.web.controller.work.check;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.framework.jqgrid.JqGridParam;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheckData;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheckDataResult;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckDataVO;
import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckQuery;
import cn.smarthse.modules.health.enums.check.ExamResultEnum;
import cn.smarthse.modules.health.service.work.check.IPhcPhysicalCheckDataService;
import cn.smarthse.modules.health.supervise.entity.check.project.CheckDataInfo;
import cn.smarthse.modules.health.supervise.entity.check.project.CheckDataResultInfo;
import cn.smarthse.modules.health.supervise.entity.check.project.PageCheckDataParam;
import cn.smarthse.modules.health.supervise.service.check.ISuperviseCheckThirdOrganizationService;
import cn.smarthse.web.controller.ControllerSupport;
import cn.smarthse.web.util.UserUtils;
import com.github.pagehelper.PageInfo;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/work/check/data"})
public class PhcPhysicalCheckDataController
extends ControllerSupport {
    @DubboReference
    private IPhcPhysicalCheckDataService phcPhysicalCheckDataService;
    @DubboReference
    private ISuperviseCheckThirdOrganizationService checkThirdOrganizationService;

    @RequestMapping
    public String page_index(@RequestParam(value="page", required=false, defaultValue="1") int pageIndex, HttpSession session, ModelMap m, PhcPhysicalCheckQuery param, String op) {
        this.logger.info("\u3010\u3011-\u6c47\u603b\u9996\u9875");
        m.put((Object)"param", (Object)param);
        m.put((Object)"op", (Object)op);
        m.put((Object)"isActualize", (Object)this.isActualize);
        return "work/check/type/check_type_data";
    }

    @ResponseBody
    @RequestMapping(value={"listData"})
    public JqGridData<PhcPhysicalCheckDataVO> listData(HttpSession session, JqGridParam gparam, PhcPhysicalCheckQuery param) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        PageInfo list = this.phcPhysicalCheckDataService.getList(gparam, param);
        JqGridData data = new JqGridData(list, gparam);
        return data;
    }

    @ResponseBody
    @RequestMapping(value={"selectStaff"})
    public List<PhcPhysicalCheckDataVO> selectStaff(PhcPhysicalCheckQuery param) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        List data = this.phcPhysicalCheckDataService.selectStaff(param);
        return data;
    }

    @ResponseBody
    @RequestMapping(value={"recheck/listData"})
    public JqGridData<PhcPhysicalCheckDataVO> recheckListData(HttpSession session, JqGridParam gparam, PhcPhysicalCheckQuery param) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        param.setCid(cid);
        PageInfo list = this.phcPhysicalCheckDataService.getRecheckPage(gparam, param);
        JqGridData data = new JqGridData(list, gparam);
        return data;
    }

    @RequestMapping(value={"/view"}, method={RequestMethod.GET})
    public String viewDataDetailById(PhcPhysicalCheckData data, HttpSession session, ModelMap m) {
        Byte examResult = data.getExamResult();
        if (data.getId() != null) {
            data = this.phcPhysicalCheckDataService.getDataDetailById(data);
            data.setExamResult(examResult);
            this.setReportFiles(m, data.getResults());
        }
        m.put((Object)"data", (Object)data);
        return "work/check/dialog/check_result_" + data.getExamResult() + "_view";
    }

    @RequestMapping(value={"/type/data/result/{id}"})
    public String dataResult(ModelMap m, @PathVariable Long id) {
        CheckDataResultInfo resultInfo = this.checkThirdOrganizationService.getCheckResultInfo(id);
        m.put((Object)"resultInfo", (Object)resultInfo);
        return "work/check/dialog/check_type_data_result";
    }

    private void setReportFiles(ModelMap model, List<PhcPhysicalCheckDataResult> results) {
        if (results != null) {
            ArrayList<String> reportFileIds = new ArrayList<String>();
            List fileIdsList = results.stream().map(PhcPhysicalCheckDataResult::getReportFiles).filter(i -> i != null && !i.isEmpty()).collect(Collectors.toList());
            for (String fileIds : fileIdsList) {
                String[] fileIdAdrr;
                for (String s : fileIdAdrr = fileIds.split(",")) {
                    if (reportFileIds.contains(s)) continue;
                    reportFileIds.add(s);
                }
            }
            if (!reportFileIds.isEmpty()) {
                model.put((Object)"resultReportFiles", (Object)String.join((CharSequence)",", reportFileIds));
            }
        }
    }

    @RequestMapping(value={"/info"}, method={RequestMethod.GET})
    public String getDataDetailById(PhcPhysicalCheckData data, HttpSession session, ModelMap m) {
        this.logger.info(this.getClass().getName() + "\u3010\u4f53\u68c0\u7ed3\u679c\u8be6\u60c5\u9875\u3011");
        Byte examResult = data.getExamResult();
        if (data.getId() != null) {
            this.logger.info(this.getClass().getName() + "\u3010\u4f53\u68c0\u7ed3\u679c\u8be6\u60c5\u9875\u3011---\u83b7\u53d6\u8be6\u60c5\u4fe1\u606f");
            data = this.phcPhysicalCheckDataService.getDataDetailById(data);
            data.setExamResult(examResult);
            this.setReportFiles(m, data.getResults());
        }
        m.put((Object)"data", (Object)data);
        String view = "work/check/dialog/check_result_" + data.getExamResult();
        this.logger.info(this.getClass().getName() + "\u3010\u4f53\u68c0\u7ed3\u679c\u8be6\u60c5\u9875\u3011---\u83b7\u53d6\u8be6\u60c5\u9875\u9762\uff1a" + view);
        return view;
    }

    @ResponseBody
    @RequestMapping(value={"staff/info"}, method={RequestMethod.GET})
    public PhcPhysicalCheckData getDataDetailByQuery(PhcPhysicalCheckData query, HttpSession session, ModelMap m) {
        PhcPhysicalCheckData data = this.phcPhysicalCheckDataService.getDataDetailByQuery(query);
        return data == null ? new PhcPhysicalCheckData() : data;
    }

    @ResponseBody
    @RequestMapping(value={"staff/info/exist"}, method={RequestMethod.GET})
    public Boolean hasDataExist(PhcPhysicalCheckData query, HttpSession session, ModelMap m) {
        Boolean flag = this.phcPhysicalCheckDataService.hasDataExist(query);
        return flag;
    }

    @ResponseBody
    @RequestMapping(value={"/info"}, method={RequestMethod.POST})
    public ResponseData<PhcPhysicalCheckData> infoPost(HttpServletRequest request, PhcPhysicalCheckData data) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffId = UserUtils.getLoginStaffId();
        CharSequence[] resultReportFileIdArr = data.getResultReportFileIdArr();
        String reportFiles = null;
        if (resultReportFileIdArr != null && resultReportFileIdArr.length > 0) {
            reportFiles = String.join((CharSequence)",", resultReportFileIdArr);
        }
        List results = data.getResults();
        for (PhcPhysicalCheckDataResult result : results) {
            result.setReportFiles(reportFiles);
        }
        data = this.phcPhysicalCheckDataService.insertOrUpdate(data, staffId, cid);
        ResponseData result = new ResponseData();
        result.setResult((Object)data);
        result.setContent("\u64cd\u4f5c\u6210\u529f");
        return result;
    }

    @ResponseBody
    @RequestMapping(value={"staffs"}, method={RequestMethod.POST})
    public ResponseData<PhcPhysicalCheckData> staffsPost(HttpServletRequest request, PhcPhysicalCheckData data, String staffIds) {
        Long cid = UserUtils.getLoginStaffCompanyId();
        Long staffId = UserUtils.getLoginStaffId();
        data = this.phcPhysicalCheckDataService.addStaffs(data, staffIds, staffId, cid);
        ResponseData result = new ResponseData();
        result.setResult((Object)data);
        result.setContent("\u64cd\u4f5c\u6210\u529f");
        return result;
    }

    @ResponseBody
    @RequestMapping(value={"/del"}, method={RequestMethod.DELETE})
    public ResponseData<PhcPhysicalCheckData> ajax_delete(PhcPhysicalCheckData data, HttpSession session) {
        this.phcPhysicalCheckDataService.deleteByInfo(data);
        ResponseData result = new ResponseData();
        result.setResult((Object)data);
        result.setContent("\u5220\u9664\u6210\u529f");
        return result;
    }

    @RequestMapping(value={"staff"}, method={RequestMethod.GET})
    public String staff(ModelMap m, HttpSession session, PhcPhysicalCheckData query) {
        PhcPhysicalCheckData data = this.phcPhysicalCheckDataService.getDataDetailById(query);
        m.put((Object)"examResults", (Object)ExamResultEnum.values());
        m.put((Object)"exams", this.getTypes(data == null ? null : data.getResults()));
        m.put((Object)"data", (Object)data);
        return "work/check/check_recheck_data";
    }

    @RequestMapping(value={"staff/view"}, method={RequestMethod.GET})
    public String staffView(ModelMap m, HttpSession session, PhcPhysicalCheckData query) {
        PhcPhysicalCheckData data = this.phcPhysicalCheckDataService.getDataDetailById(query);
        m.put((Object)"examResults", (Object)ExamResultEnum.values());
        m.put((Object)"exams", this.getTypes(data == null ? null : data.getResults()));
        m.put((Object)"data", (Object)data);
        return "work/check/check_recheck_data_info";
    }

    private List<Byte> getTypes(List<PhcPhysicalCheckDataResult> list) {
        ArrayList<Byte> types = new ArrayList<Byte>();
        if (list != null) {
            for (PhcPhysicalCheckDataResult l : list) {
                if (types.contains(l.getExamResult())) continue;
                types.add(l.getExamResult());
            }
        }
        return types;
    }

    @ResponseBody
    @RequestMapping(value={"staff/checkStaffCount"}, method={RequestMethod.GET})
    public Integer getAllCheckResultStaffCountByByQuery(PhcPhysicalCheckQuery param) {
        return this.phcPhysicalCheckDataService.getAllCheckResultStaffCountByByQuery(param);
    }

    @RequestMapping(value={"/type/data"})
    public String page_index(@RequestParam(value="page", required=false, defaultValue="1") int pageIndex, HttpSession session, ModelMap m, PageCheckDataParam param, String op) {
        m.put((Object)"param", (Object)param);
        m.put((Object)"op", (Object)op);
        return "work/check/type/check_type_data2";
    }

    @RequestMapping(value={"/type/data/list"})
    @ResponseBody
    public JqGridData<CheckDataInfo> checkData(JqGridParam jparam, PageCheckDataParam param) {
        PageInfo page = this.checkThirdOrganizationService.pageCheckData(jparam, param);
        JqGridData data = new JqGridData(page, jparam);
        return data;
    }
}

